<?php
/*
Template Name: Lead Account Page
*/
get_header();

$post_id              = get_the_ID();
$is_page_builder_used = et_pb_is_pagebuilder_used( $post_id );
$container_tag        = 'product' === get_post_type( $post_id ) ? 'div' : 'article'; ?>

<?php $image = wp_get_attachment_image_src(4293, 'single-post-thumbnail');?>
<style>
  .listing-hdr{left: 0; height: 100vh; width: 100%; background: url('<?php echo $image[0]; ?>') no-repeat; background-size: cover; }
  #main-content .container::before {background-color: transparent!important;}
  .hjitb .nav-tabs > li.active > a {background-color: #ddd;}
  .hjitb .nav-tabs > li {padding: 15px 5px 0 0 !important; border-bottom: 1px solid #ddd;}
  .hjitb .nav-tabs {border-bottom: transparent;}
  #content-area a {color: #4262c6!important; text-decoration: none;}
</style>

    <div id="main-content">
<div class="listing-hdr caidx"><h1 class="entry-title" style="top: 55%!important;"><?php the_title(); ?></h1></div>
<?php if ( ! $is_page_builder_used ) : ?>

	<div class="container">
		<div id="content-area" class="clearfix">
			

<?php endif; ?>

			<?php while ( have_posts() ) : the_post(); ?>

				<<?php echo $container_tag; ?> id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

				<?php if ( ! $is_page_builder_used ) : ?>

					<h1 class="main_title">Account & Alerts</h1>
				<?php
					$thumb = '';

					$width = (int) apply_filters( 'et_pb_index_blog_image_width', 1080 );

					$height = (int) apply_filters( 'et_pb_index_blog_image_height', 675 );
					$classtext = 'et_featured_image';
					$titletext = get_the_title();
					$thumbnail = get_thumbnail( $width, $height, $classtext, $titletext, $titletext, false, 'Blogimage' );
					$thumb = $thumbnail["thumb"];

					if ( 'on' === et_get_option( 'divi_page_thumbnails', 'false' ) && '' !== $thumb )
						print_thumbnail( $thumb, $thumbnail["use_timthumb"], $titletext, $width, $height );
				?>

				<?php endif; ?>

					<div class="entry-content">
					<?php
						the_content();

						if ( ! $is_page_builder_used )
							wp_link_pages( array( 'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'Divi' ), 'after' => '</div>' ) );
					?>
					</div> <!-- .entry-content -->

				<?php
					if ( ! $is_page_builder_used && comments_open() && 'on' === et_get_option( 'divi_show_pagescomments', 'false' ) ) comments_template( '', true );
				?>

				</<?php echo $container_tag; ?>> <!-- .et_pb_post -->

			<?php endwhile; ?>

<?php if ( ! $is_page_builder_used ) : ?>

			

			
		</div> <!-- #content-area -->
	</div> <!-- .container -->

<?php endif; ?>

</div> <!-- #main-content -->

<?php

get_footer();

