<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Sync\V1\Service\SyncMap;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class SyncMapItemOptions {
    /**
     * @param integer $ttl Time-to-live of this Map in seconds, defaults to no
     *                     expiration.
     * @return CreateSyncMapItemOptions Options builder
     */
    public static function create($ttl = Values::NONE) {
        return new CreateSyncMapItemOptions($ttl);
    }

    /**
     * @param string $order The order
     * @param string $from The from
     * @param string $bounds The bounds
     * @return ReadSyncMapItemOptions Options builder
     */
    public static function read($order = Values::NONE, $from = Values::NONE, $bounds = Values::NONE) {
        return new ReadSyncMapItemOptions($order, $from, $bounds);
    }

    /**
     * @param array $data Contains an arbitrary JSON object to be stored in this
     *                    Map Item.
     * @param integer $ttl New time-to-live of this Map in seconds.
     * @return UpdateSyncMapItemOptions Options builder
     */
    public static function update($data = Values::NONE, $ttl = Values::NONE) {
        return new UpdateSyncMapItemOptions($data, $ttl);
    }
}

class CreateSyncMapItemOptions extends Options {
    /**
     * @param integer $ttl Time-to-live of this Map in seconds, defaults to no
     *                     expiration.
     */
    public function __construct($ttl = Values::NONE) {
        $this->options['ttl'] = $ttl;
    }

    /**
     * (optional) Time-to-live of this Map in seconds, defaults to no expiration. In the range [1, 31 536 000 (1 year)], or 0 for infinity.
     * 
     * @param integer $ttl Time-to-live of this Map in seconds, defaults to no
     *                     expiration.
     * @return $this Fluent Builder
     */
    public function setTtl($ttl) {
        $this->options['ttl'] = $ttl;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Sync.V1.CreateSyncMapItemOptions ' . implode(' ', $options) . ']';
    }
}

class ReadSyncMapItemOptions extends Options {
    /**
     * @param string $order The order
     * @param string $from The from
     * @param string $bounds The bounds
     */
    public function __construct($order = Values::NONE, $from = Values::NONE, $bounds = Values::NONE) {
        $this->options['order'] = $order;
        $this->options['from'] = $from;
        $this->options['bounds'] = $bounds;
    }

    /**
     * The order
     * 
     * @param string $order The order
     * @return $this Fluent Builder
     */
    public function setOrder($order) {
        $this->options['order'] = $order;
        return $this;
    }

    /**
     * The from
     * 
     * @param string $from The from
     * @return $this Fluent Builder
     */
    public function setFrom($from) {
        $this->options['from'] = $from;
        return $this;
    }

    /**
     * The bounds
     * 
     * @param string $bounds The bounds
     * @return $this Fluent Builder
     */
    public function setBounds($bounds) {
        $this->options['bounds'] = $bounds;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Sync.V1.ReadSyncMapItemOptions ' . implode(' ', $options) . ']';
    }
}

class UpdateSyncMapItemOptions extends Options {
    /**
     * @param array $data Contains an arbitrary JSON object to be stored in this
     *                    Map Item.
     * @param integer $ttl New time-to-live of this Map in seconds.
     */
    public function __construct($data = Values::NONE, $ttl = Values::NONE) {
        $this->options['data'] = $data;
        $this->options['ttl'] = $ttl;
    }

    /**
     * (optional) Contains an arbitrary JSON object to be stored in this Map Item. Serialized to string to respect HTTP form input, up to 16KB.
     * 
     * @param array $data Contains an arbitrary JSON object to be stored in this
     *                    Map Item.
     * @return $this Fluent Builder
     */
    public function setData($data) {
        $this->options['data'] = $data;
        return $this;
    }

    /**
     * New time-to-live of this Map in seconds. In the range [1, 31 536 000 (1 year)], or 0 for infinity.
     * 
     * @param integer $ttl New time-to-live of this Map in seconds.
     * @return $this Fluent Builder
     */
    public function setTtl($ttl) {
        $this->options['ttl'] = $ttl;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Sync.V1.UpdateSyncMapItemOptions ' . implode(' ', $options) . ']';
    }
}