<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\Understand;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class AssistantOptions {
    /**
     * @param string $friendlyName The friendly_name
     * @param boolean $logQueries The log_queries
     * @param integer $ttl The ttl
     * @param string $uniqueName The unique_name
     * @param string $responseUrl The response_url
     * @param string $callbackUrl The callback_url
     * @param string $callbackEvents The callback_events
     * @return CreateAssistantOptions Options builder
     */
    public static function create($friendlyName = Values::NONE, $logQueries = Values::NONE, $ttl = Values::NONE, $uniqueName = Values::NONE, $responseUrl = Values::NONE, $callbackUrl = Values::NONE, $callbackEvents = Values::NONE) {
        return new CreateAssistantOptions($friendlyName, $logQueries, $ttl, $uniqueName, $responseUrl, $callbackUrl, $callbackEvents);
    }

    /**
     * @param string $friendlyName The friendly_name
     * @param boolean $logQueries The log_queries
     * @param integer $ttl The ttl
     * @param string $uniqueName The unique_name
     * @param string $responseUrl The response_url
     * @param string $callbackUrl The callback_url
     * @param string $callbackEvents The callback_events
     * @return UpdateAssistantOptions Options builder
     */
    public static function update($friendlyName = Values::NONE, $logQueries = Values::NONE, $ttl = Values::NONE, $uniqueName = Values::NONE, $responseUrl = Values::NONE, $callbackUrl = Values::NONE, $callbackEvents = Values::NONE) {
        return new UpdateAssistantOptions($friendlyName, $logQueries, $ttl, $uniqueName, $responseUrl, $callbackUrl, $callbackEvents);
    }
}

class CreateAssistantOptions extends Options {
    /**
     * @param string $friendlyName The friendly_name
     * @param boolean $logQueries The log_queries
     * @param integer $ttl The ttl
     * @param string $uniqueName The unique_name
     * @param string $responseUrl The response_url
     * @param string $callbackUrl The callback_url
     * @param string $callbackEvents The callback_events
     */
    public function __construct($friendlyName = Values::NONE, $logQueries = Values::NONE, $ttl = Values::NONE, $uniqueName = Values::NONE, $responseUrl = Values::NONE, $callbackUrl = Values::NONE, $callbackEvents = Values::NONE) {
        $this->options['friendlyName'] = $friendlyName;
        $this->options['logQueries'] = $logQueries;
        $this->options['ttl'] = $ttl;
        $this->options['uniqueName'] = $uniqueName;
        $this->options['responseUrl'] = $responseUrl;
        $this->options['callbackUrl'] = $callbackUrl;
        $this->options['callbackEvents'] = $callbackEvents;
    }

    /**
     * The friendly_name
     * 
     * @param string $friendlyName The friendly_name
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName) {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * The log_queries
     * 
     * @param boolean $logQueries The log_queries
     * @return $this Fluent Builder
     */
    public function setLogQueries($logQueries) {
        $this->options['logQueries'] = $logQueries;
        return $this;
    }

    /**
     * The ttl
     * 
     * @param integer $ttl The ttl
     * @return $this Fluent Builder
     */
    public function setTtl($ttl) {
        $this->options['ttl'] = $ttl;
        return $this;
    }

    /**
     * The unique_name
     * 
     * @param string $uniqueName The unique_name
     * @return $this Fluent Builder
     */
    public function setUniqueName($uniqueName) {
        $this->options['uniqueName'] = $uniqueName;
        return $this;
    }

    /**
     * The response_url
     * 
     * @param string $responseUrl The response_url
     * @return $this Fluent Builder
     */
    public function setResponseUrl($responseUrl) {
        $this->options['responseUrl'] = $responseUrl;
        return $this;
    }

    /**
     * The callback_url
     * 
     * @param string $callbackUrl The callback_url
     * @return $this Fluent Builder
     */
    public function setCallbackUrl($callbackUrl) {
        $this->options['callbackUrl'] = $callbackUrl;
        return $this;
    }

    /**
     * The callback_events
     * 
     * @param string $callbackEvents The callback_events
     * @return $this Fluent Builder
     */
    public function setCallbackEvents($callbackEvents) {
        $this->options['callbackEvents'] = $callbackEvents;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Preview.Understand.CreateAssistantOptions ' . implode(' ', $options) . ']';
    }
}

class UpdateAssistantOptions extends Options {
    /**
     * @param string $friendlyName The friendly_name
     * @param boolean $logQueries The log_queries
     * @param integer $ttl The ttl
     * @param string $uniqueName The unique_name
     * @param string $responseUrl The response_url
     * @param string $callbackUrl The callback_url
     * @param string $callbackEvents The callback_events
     */
    public function __construct($friendlyName = Values::NONE, $logQueries = Values::NONE, $ttl = Values::NONE, $uniqueName = Values::NONE, $responseUrl = Values::NONE, $callbackUrl = Values::NONE, $callbackEvents = Values::NONE) {
        $this->options['friendlyName'] = $friendlyName;
        $this->options['logQueries'] = $logQueries;
        $this->options['ttl'] = $ttl;
        $this->options['uniqueName'] = $uniqueName;
        $this->options['responseUrl'] = $responseUrl;
        $this->options['callbackUrl'] = $callbackUrl;
        $this->options['callbackEvents'] = $callbackEvents;
    }

    /**
     * The friendly_name
     * 
     * @param string $friendlyName The friendly_name
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName) {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * The log_queries
     * 
     * @param boolean $logQueries The log_queries
     * @return $this Fluent Builder
     */
    public function setLogQueries($logQueries) {
        $this->options['logQueries'] = $logQueries;
        return $this;
    }

    /**
     * The ttl
     * 
     * @param integer $ttl The ttl
     * @return $this Fluent Builder
     */
    public function setTtl($ttl) {
        $this->options['ttl'] = $ttl;
        return $this;
    }

    /**
     * The unique_name
     * 
     * @param string $uniqueName The unique_name
     * @return $this Fluent Builder
     */
    public function setUniqueName($uniqueName) {
        $this->options['uniqueName'] = $uniqueName;
        return $this;
    }

    /**
     * The response_url
     * 
     * @param string $responseUrl The response_url
     * @return $this Fluent Builder
     */
    public function setResponseUrl($responseUrl) {
        $this->options['responseUrl'] = $responseUrl;
        return $this;
    }

    /**
     * The callback_url
     * 
     * @param string $callbackUrl The callback_url
     * @return $this Fluent Builder
     */
    public function setCallbackUrl($callbackUrl) {
        $this->options['callbackUrl'] = $callbackUrl;
        return $this;
    }

    /**
     * The callback_events
     * 
     * @param string $callbackEvents The callback_events
     * @return $this Fluent Builder
     */
    public function setCallbackEvents($callbackEvents) {
        $this->options['callbackEvents'] = $callbackEvents;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Preview.Understand.UpdateAssistantOptions ' . implode(' ', $options) . ']';
    }
}