<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\Understand\Assistant;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class QueryOptions {
    /**
     * @param string $language The language
     * @param string $modelBuild The model_build
     * @param string $status The status
     * @return ReadQueryOptions Options builder
     */
    public static function read($language = Values::NONE, $modelBuild = Values::NONE, $status = Values::NONE) {
        return new ReadQueryOptions($language, $modelBuild, $status);
    }

    /**
     * @param string $intents The intents
     * @param string $modelBuild The model_build
     * @param string $field The field
     * @return CreateQueryOptions Options builder
     */
    public static function create($intents = Values::NONE, $modelBuild = Values::NONE, $field = Values::NONE) {
        return new CreateQueryOptions($intents, $modelBuild, $field);
    }

    /**
     * @param string $sampleSid The sample_sid
     * @param string $status The status
     * @return UpdateQueryOptions Options builder
     */
    public static function update($sampleSid = Values::NONE, $status = Values::NONE) {
        return new UpdateQueryOptions($sampleSid, $status);
    }
}

class ReadQueryOptions extends Options {
    /**
     * @param string $language The language
     * @param string $modelBuild The model_build
     * @param string $status The status
     */
    public function __construct($language = Values::NONE, $modelBuild = Values::NONE, $status = Values::NONE) {
        $this->options['language'] = $language;
        $this->options['modelBuild'] = $modelBuild;
        $this->options['status'] = $status;
    }

    /**
     * The language
     * 
     * @param string $language The language
     * @return $this Fluent Builder
     */
    public function setLanguage($language) {
        $this->options['language'] = $language;
        return $this;
    }

    /**
     * The model_build
     * 
     * @param string $modelBuild The model_build
     * @return $this Fluent Builder
     */
    public function setModelBuild($modelBuild) {
        $this->options['modelBuild'] = $modelBuild;
        return $this;
    }

    /**
     * The status
     * 
     * @param string $status The status
     * @return $this Fluent Builder
     */
    public function setStatus($status) {
        $this->options['status'] = $status;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Preview.Understand.ReadQueryOptions ' . implode(' ', $options) . ']';
    }
}

class CreateQueryOptions extends Options {
    /**
     * @param string $intents The intents
     * @param string $modelBuild The model_build
     * @param string $field The field
     */
    public function __construct($intents = Values::NONE, $modelBuild = Values::NONE, $field = Values::NONE) {
        $this->options['intents'] = $intents;
        $this->options['modelBuild'] = $modelBuild;
        $this->options['field'] = $field;
    }

    /**
     * The intents
     * 
     * @param string $intents The intents
     * @return $this Fluent Builder
     */
    public function setIntents($intents) {
        $this->options['intents'] = $intents;
        return $this;
    }

    /**
     * The model_build
     * 
     * @param string $modelBuild The model_build
     * @return $this Fluent Builder
     */
    public function setModelBuild($modelBuild) {
        $this->options['modelBuild'] = $modelBuild;
        return $this;
    }

    /**
     * The field
     * 
     * @param string $field The field
     * @return $this Fluent Builder
     */
    public function setField($field) {
        $this->options['field'] = $field;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Preview.Understand.CreateQueryOptions ' . implode(' ', $options) . ']';
    }
}

class UpdateQueryOptions extends Options {
    /**
     * @param string $sampleSid The sample_sid
     * @param string $status The status
     */
    public function __construct($sampleSid = Values::NONE, $status = Values::NONE) {
        $this->options['sampleSid'] = $sampleSid;
        $this->options['status'] = $status;
    }

    /**
     * The sample_sid
     * 
     * @param string $sampleSid The sample_sid
     * @return $this Fluent Builder
     */
    public function setSampleSid($sampleSid) {
        $this->options['sampleSid'] = $sampleSid;
        return $this;
    }

    /**
     * The status
     * 
     * @param string $status The status
     * @return $this Fluent Builder
     */
    public function setStatus($status) {
        $this->options['status'] = $status;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Preview.Understand.UpdateQueryOptions ' . implode(' ', $options) . ']';
    }
}