<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\Understand\Assistant;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class ModelBuildOptions {
    /**
     * @param string $statusCallback The status_callback
     * @param string $uniqueName The unique_name
     * @return CreateModelBuildOptions Options builder
     */
    public static function create($statusCallback = Values::NONE, $uniqueName = Values::NONE) {
        return new CreateModelBuildOptions($statusCallback, $uniqueName);
    }

    /**
     * @param string $uniqueName The unique_name
     * @return UpdateModelBuildOptions Options builder
     */
    public static function update($uniqueName = Values::NONE) {
        return new UpdateModelBuildOptions($uniqueName);
    }
}

class CreateModelBuildOptions extends Options {
    /**
     * @param string $statusCallback The status_callback
     * @param string $uniqueName The unique_name
     */
    public function __construct($statusCallback = Values::NONE, $uniqueName = Values::NONE) {
        $this->options['statusCallback'] = $statusCallback;
        $this->options['uniqueName'] = $uniqueName;
    }

    /**
     * The status_callback
     * 
     * @param string $statusCallback The status_callback
     * @return $this Fluent Builder
     */
    public function setStatusCallback($statusCallback) {
        $this->options['statusCallback'] = $statusCallback;
        return $this;
    }

    /**
     * The unique_name
     * 
     * @param string $uniqueName The unique_name
     * @return $this Fluent Builder
     */
    public function setUniqueName($uniqueName) {
        $this->options['uniqueName'] = $uniqueName;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Preview.Understand.CreateModelBuildOptions ' . implode(' ', $options) . ']';
    }
}

class UpdateModelBuildOptions extends Options {
    /**
     * @param string $uniqueName The unique_name
     */
    public function __construct($uniqueName = Values::NONE) {
        $this->options['uniqueName'] = $uniqueName;
    }

    /**
     * The unique_name
     * 
     * @param string $uniqueName The unique_name
     * @return $this Fluent Builder
     */
    public function setUniqueName($uniqueName) {
        $this->options['uniqueName'] = $uniqueName;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Preview.Understand.UpdateModelBuildOptions ' . implode(' ', $options) . ']';
    }
}