-- Adminer 4.7.3 MySQL dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

SET NAMES utf8mb4;

DROP TABLE IF EXISTS `wp_commentmeta`;
CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


DROP TABLE IF EXISTS `wp_comments`;
CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


DROP TABLE IF EXISTS `wp_cron_photos`;
CREATE TABLE `wp_cron_photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prop_id` int(11) NOT NULL,
  `post_id` int(11) NOT NULL,
  `photo_link` varchar(300) NOT NULL,
  `thumb_link` varchar(300) NOT NULL,
  `title` varchar(300) NOT NULL,
  `down_local` int(11) NOT NULL DEFAULT '0',
  `image_name` varchar(300) NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `wp_cron_photos` (`id`, `prop_id`, `post_id`, `photo_link`, `thumb_link`, `title`, `down_local`, `image_name`, `sort_order`) VALUES
(134,	63928,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/07/7734-N-3rd-Ave-Phoenix-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/07/7734-N-3rd-Ave-Phoenix-AZ-150x150.jpg',	'',	1,	'7734-N-3rd-Ave-Phoenix-AZ.jpg',	0),
(133,	63925,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/07/5429-E-Solano-Dr-Paradise-Valley-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/07/5429-E-Solano-Dr-Paradise-Valley-AZ-150x150.jpg',	'',	1,	'5429-E-Solano-Dr-Paradise-Valley-AZ.jpg',	0),
(132,	63579,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1243-E-Artesian-Way-Gilbert-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1243-E-Artesian-Way-Gilbert-AZ-150x150.jpg',	'',	1,	'1243-E-Artesian-Way-Gilbert-AZ.jpg',	0),
(131,	58061,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/8654-E-Krail-St-Scottsdale-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/8654-E-Krail-St-Scottsdale-AZ-150x150.jpg',	'',	1,	'8654-E-Krail-St-Scottsdale-AZ.jpg',	0),
(130,	58058,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2402-E-5th-St-UNIT-1453-Tempe-AZ-85281.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2402-E-5th-St-UNIT-1453-Tempe-AZ-85281-150x150.jpg',	'',	1,	'2402-E-5th-St-UNIT-1453-Tempe-AZ-85281.jpg',	0),
(129,	58055,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2402-E-5th-St-UNIT-1574-Tempe-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2402-E-5th-St-UNIT-1574-Tempe-AZ-150x150.jpg',	'',	1,	'2402-E-5th-St-UNIT-1574-Tempe-AZ.jpg',	0),
(128,	58052,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1287-N-Alma-School-Rd-253-Chandler-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1287-N-Alma-School-Rd-253-Chandler-AZ-150x150.jpg',	'',	1,	'1287-N-Alma-School-Rd-253-Chandler-AZ.jpg',	0),
(127,	58049,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/5912-E-Emile-Zola-Ave-Scottsdale-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/5912-E-Emile-Zola-Ave-Scottsdale-AZ-150x150.jpg',	'',	1,	'5912-E-Emile-Zola-Ave-Scottsdale-AZ.jpg',	0),
(126,	58045,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/4435-E-Mountain-View-Rd-Phoenix-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/4435-E-Mountain-View-Rd-Phoenix-AZ-150x150.jpg',	'',	1,	'4435-E-Mountain-View-Rd-Phoenix-AZ.jpg',	0),
(125,	58041,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2402-E-5th-St-UNIT-1541-Tempe-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2402-E-5th-St-UNIT-1541-Tempe-AZ-150x150.jpg',	'',	1,	'2402-E-5th-St-UNIT-1541-Tempe-AZ.jpg',	0),
(124,	58038,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/7209-N-17th-Ave-Phoenix-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/7209-N-17th-Ave-Phoenix-AZ-150x150.jpg',	'',	1,	'7209-N-17th-Ave-Phoenix-AZ.jpg',	0),
(123,	58035,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2402-E-5th-St-UNIT-1405-Tempe-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2402-E-5th-St-UNIT-1405-Tempe-AZ-150x150.jpg',	'',	1,	'2402-E-5th-St-UNIT-1405-Tempe-AZ.jpg',	0),
(122,	58032,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/5625-E-Sanna-St-Paradise-Valley-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/5625-E-Sanna-St-Paradise-Valley-AZ-150x150.jpg',	'',	1,	'5625-E-Sanna-St-Paradise-Valley-AZ.jpg',	0),
(121,	58030,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2401-E-Rio-Salado-Pkwy-UNIT-1114-Tempe-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2401-E-Rio-Salado-Pkwy-UNIT-1114-Tempe-AZ-150x150.jpg',	'',	1,	'2401-E-Rio-Salado-Pkwy-UNIT-1114-Tempe-AZ.jpg',	0),
(120,	58027,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1446-S-Newberry-Ln-Tempe-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1446-S-Newberry-Ln-Tempe-AZ-150x150.jpg',	'',	1,	'1446-S-Newberry-Ln-Tempe-AZ.jpg',	0),
(119,	58024,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/10586-E-Fernwood-Ln-Scottsdale-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/10586-E-Fernwood-Ln-Scottsdale-AZ-150x150.jpg',	'',	1,	'10586-E-Fernwood-Ln-Scottsdale-AZ.jpg',	0),
(118,	57940,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1905-E-University-Dr-146-Tempe-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1905-E-University-Dr-146-Tempe-AZ-150x150.jpg',	'',	1,	'1905-E-University-Dr-146-Tempe-AZ.jpg',	0),
(117,	57934,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/140-E-Rio-Salado-Pkwy-UNIT-701-Tempe-AZ1.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/140-E-Rio-Salado-Pkwy-UNIT-701-Tempe-AZ1-150x150.jpg',	'',	1,	'140-E-Rio-Salado-Pkwy-UNIT-701-Tempe-AZ1.jpg',	0),
(116,	57931,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/126-E-Concorda-Dr-Tempe-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/126-E-Concorda-Dr-Tempe-AZ-150x150.jpg',	'',	1,	'126-E-Concorda-Dr-Tempe-AZ.jpg',	0),
(115,	57927,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2402-E-5th-St-UNIT-1465-Tempe-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2402-E-5th-St-UNIT-1465-Tempe-AZ-150x150.jpg',	'',	1,	'2402-E-5th-St-UNIT-1465-Tempe-AZ.jpg',	0),
(114,	57924,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/7239-E-Manzanita-Dr-Scottsdale-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/7239-E-Manzanita-Dr-Scottsdale-AZ-150x150.jpg',	'',	1,	'7239-E-Manzanita-Dr-Scottsdale-AZ.jpg',	0),
(113,	57921,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1211-N-Miller-Rd-UNIT-101-Scottsdale-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1211-N-Miller-Rd-UNIT-101-Scottsdale-AZ-150x150.jpg',	'',	1,	'1211-N-Miller-Rd-UNIT-101-Scottsdale-AZ.jpg',	0),
(112,	57918,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1338-W-Starfish-Dr-Gilbert-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1338-W-Starfish-Dr-Gilbert-AZ-150x150.jpg',	'',	1,	'1338-W-Starfish-Dr-Gilbert-AZ.jpg',	0),
(111,	57889,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2401-E-Rio-Salado-Pkwy-UNIT-1161-Tempe-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2401-E-Rio-Salado-Pkwy-UNIT-1161-Tempe-AZ-150x150.jpg',	'',	1,	'2401-E-Rio-Salado-Pkwy-UNIT-1161-Tempe-AZ.jpg',	0),
(110,	57884,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1886-E-DON-CARLOS-Ave-121.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1886-E-DON-CARLOS-Ave-121-150x150.jpg',	'',	1,	'1886-E-DON-CARLOS-Ave-121.jpg',	0),
(109,	57880,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/280-S-Evergreen-Rd-UNIT-1281-Tempe-AZ.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/280-S-Evergreen-Rd-UNIT-1281-Tempe-AZ-150x150.jpg',	'',	1,	'280-S-Evergreen-Rd-UNIT-1281-Tempe-AZ.jpg',	0),
(108,	57873,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2401-E-Rio-Salado-Pkwy-UNIT-1015.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2401-E-Rio-Salado-Pkwy-UNIT-1015-150x150.jpg',	'',	1,	'2401-E-Rio-Salado-Pkwy-UNIT-1015.jpg',	0),
(107,	57870,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/263-W-41st-Pl1.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/263-W-41st-Pl1-150x150.jpg',	'',	1,	'263-W-41st-Pl1.jpg',	0),
(106,	57837,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/111.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/111-150x150.jpg',	'',	1,	'111.jpg',	0),
(105,	57754,	0,	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/9.jpg',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/9-150x150.jpg',	'',	1,	'9.jpg',	0),
(140,	88,	0,	'',	'',	'',	1,	'1569970293_21.jpg',	0),
(139,	90,	0,	'',	'',	'',	1,	'1569968164_11.jpg',	0),
(141,	89,	0,	'',	'',	'',	1,	'1569970417_913_18th_st_7_websize.jpg',	0),
(142,	91,	0,	'',	'',	'',	1,	'1569972075_04.jpg',	3),
(143,	91,	0,	'',	'',	'',	1,	'1569972079_01.jpg',	0),
(144,	91,	0,	'',	'',	'',	1,	'1569972079_06.jpg',	5),
(145,	91,	0,	'',	'',	'',	1,	'1569972081_03.jpg',	2),
(146,	91,	0,	'',	'',	'',	1,	'1569972085_05.jpg',	4),
(147,	91,	0,	'',	'',	'',	1,	'1569972087_02.jpg',	1),
(148,	91,	0,	'',	'',	'',	1,	'1569972099_07.jpg',	6),
(149,	91,	0,	'',	'',	'',	1,	'1569972102_11.jpg',	10),
(150,	91,	0,	'',	'',	'',	1,	'1569972105_10.jpg',	9),
(151,	91,	0,	'',	'',	'',	1,	'1569972106_12.jpg',	11),
(152,	91,	0,	'',	'',	'',	1,	'1569972109_09.jpg',	8),
(153,	91,	0,	'',	'',	'',	1,	'1569972111_08.jpg',	7),
(154,	91,	0,	'',	'',	'',	1,	'1569972116_16.jpg',	15),
(155,	91,	0,	'',	'',	'',	1,	'1569972119_13.jpg',	12),
(156,	91,	0,	'',	'',	'',	1,	'1569972119_14.jpg',	13),
(157,	91,	0,	'',	'',	'',	1,	'1569972130_19.jpg',	18),
(158,	91,	0,	'',	'',	'',	1,	'1569972130_15.jpg',	14),
(159,	91,	0,	'',	'',	'',	1,	'1569972136_21.jpg',	20),
(160,	91,	0,	'',	'',	'',	1,	'1569972141_17.jpg',	16),
(161,	91,	0,	'',	'',	'',	1,	'1569972145_22.jpg',	21),
(162,	91,	0,	'',	'',	'',	1,	'1569972146_23.jpg',	22),
(163,	91,	0,	'',	'',	'',	1,	'1569972147_24.jpg',	23),
(164,	91,	0,	'',	'',	'',	1,	'1569972147_18.jpg',	17),
(165,	91,	0,	'',	'',	'',	1,	'1569972149_20.jpg',	19),
(166,	91,	0,	'',	'',	'',	1,	'1569972158_26.jpg',	26),
(167,	91,	0,	'',	'',	'',	1,	'1569972161_28.jpg',	27),
(168,	91,	0,	'',	'',	'',	1,	'1569972167_25.jpg',	24),
(169,	91,	0,	'',	'',	'',	1,	'1569972168_27.jpg',	25),
(170,	91,	0,	'',	'',	'',	1,	'1569972172_31.jpg',	30),
(171,	91,	0,	'',	'',	'',	1,	'1569972177_32.jpg',	31),
(172,	91,	0,	'',	'',	'',	1,	'1569972181_29.jpg',	28),
(173,	91,	0,	'',	'',	'',	1,	'1569972181_30.jpg',	29),
(174,	91,	0,	'',	'',	'',	1,	'1569972184_34.jpg',	33),
(175,	91,	0,	'',	'',	'',	1,	'1569972186_33.jpg',	32),
(176,	91,	0,	'',	'',	'',	1,	'1569972187_35.jpg',	34),
(177,	91,	0,	'',	'',	'',	1,	'1569972191_36.jpg',	35),
(178,	91,	0,	'',	'',	'',	1,	'1569972197_40.jpg',	39),
(179,	91,	0,	'',	'',	'',	1,	'1569972199_39.jpg',	38),
(180,	91,	0,	'',	'',	'',	1,	'1569972199_41.jpg',	40),
(181,	91,	0,	'',	'',	'',	1,	'1569972200_38.jpg',	37),
(182,	91,	0,	'',	'',	'',	1,	'1569972204_37.jpg',	36),
(183,	91,	0,	'',	'',	'',	1,	'1569972206_42.jpg',	41),
(184,	91,	0,	'',	'',	'',	1,	'1569972209_43.jpg',	42),
(185,	91,	0,	'',	'',	'',	1,	'1569972210_45.jpg',	44),
(186,	91,	0,	'',	'',	'',	1,	'1569972215_46.jpg',	45),
(187,	91,	0,	'',	'',	'',	1,	'1569972216_44.jpg',	43),
(188,	91,	0,	'',	'',	'',	1,	'1569972217_49.jpg',	48),
(189,	91,	0,	'',	'',	'',	1,	'1569972217_48.jpg',	47),
(190,	91,	0,	'',	'',	'',	1,	'1569972219_50.jpg',	49),
(191,	91,	0,	'',	'',	'',	1,	'1569972224_47.jpg',	46),
(192,	91,	0,	'',	'',	'',	1,	'1569972228_51.jpg',	50),
(193,	91,	0,	'',	'',	'',	1,	'1569972228_54.jpg',	53),
(194,	91,	0,	'',	'',	'',	1,	'1569972230_53.jpg',	52),
(195,	91,	0,	'',	'',	'',	1,	'1569972231_55.jpg',	54),
(196,	91,	0,	'',	'',	'',	1,	'1569972232_52.jpg',	51),
(197,	91,	0,	'',	'',	'',	1,	'1569972236_56.jpg',	0),
(198,	91,	0,	'',	'',	'',	1,	'1569972237_59.jpg',	0),
(199,	91,	0,	'',	'',	'',	1,	'1569972239_60.jpg',	0),
(200,	91,	0,	'',	'',	'',	1,	'1569972240_58.jpg',	0),
(201,	91,	0,	'',	'',	'',	1,	'1569972242_61.jpg',	0),
(202,	91,	0,	'',	'',	'',	1,	'1569972245_57.jpg',	0),
(203,	91,	0,	'',	'',	'',	1,	'1569972263_63.jpg',	0),
(204,	91,	0,	'',	'',	'',	1,	'1569972264_65.jpg',	0),
(205,	91,	0,	'',	'',	'',	1,	'1569972265_64.jpg',	0),
(206,	91,	0,	'',	'',	'',	1,	'1569972269_62.jpg',	0),
(207,	91,	0,	'',	'',	'',	1,	'1569972273_70.jpg',	0),
(208,	91,	0,	'',	'',	'',	1,	'1569972276_69.jpg',	0),
(209,	91,	0,	'',	'',	'',	1,	'1569972280_68.jpg',	0),
(210,	91,	0,	'',	'',	'',	1,	'1569972282_71.jpg',	0),
(211,	91,	0,	'',	'',	'',	1,	'1569972284_72.jpg',	0),
(212,	91,	0,	'',	'',	'',	1,	'1569972285_70a.jpg',	0),
(213,	91,	0,	'',	'',	'',	1,	'1569972285_67.jpg',	0),
(214,	91,	0,	'',	'',	'',	1,	'1569972287_66.jpg',	0),
(215,	92,	0,	'',	'',	'',	1,	'1570062006_3048-029-002_(2).jpg',	0),
(216,	92,	0,	'',	'',	'',	1,	'1570062009_3048-029-002_(1).jpg',	0),
(217,	92,	0,	'',	'',	'',	1,	'1570062009_3048-029-002_(4).jpg',	0),
(218,	92,	0,	'',	'',	'',	1,	'1570062009_3048-029-002_(5).jpg',	0),
(219,	92,	0,	'',	'',	'',	1,	'1570062011_3048-029-002_(3).jpg',	0),
(220,	93,	0,	'',	'',	'',	1,	'1570062506_3038-026-009_(3).jpg',	0),
(221,	94,	0,	'',	'',	'',	1,	'1570062734_3376-021-081_(7).jpg',	0),
(222,	95,	0,	'',	'',	'',	1,	'1570063936_05.jpg',	0),
(223,	96,	0,	'',	'',	'',	1,	'1570064415_agoura_hills.jpg',	0),
(224,	97,	0,	'',	'',	'',	1,	'1578946039_a_0039_0001.jpg',	0);

DROP TABLE IF EXISTS `wp_cron_property`;
CREATE TABLE `wp_cron_property` (
  `property_id` int(11) NOT NULL AUTO_INCREMENT,
  `post_id` int(11) NOT NULL,
  `bf_agent_1` varchar(300) NOT NULL,
  `bf_agent_2` varchar(300) NOT NULL,
  `bf_agent_3` varchar(300) NOT NULL,
  `bf_desc_aboutheadline` varchar(300) NOT NULL,
  `bf_desc_description` text NOT NULL,
  `bf_desc_lease_price` varchar(300) NOT NULL,
  `bf_desc_listing_item_1` varchar(300) NOT NULL,
  `bf_desc_listing_item_2` varchar(300) NOT NULL,
  `bf_desc_no_bathroom` varchar(300) NOT NULL,
  `bf_desc_no_bedroom` varchar(300) NOT NULL,
  `bf_desc_price_type` varchar(300) NOT NULL,
  `bf_desc_sale_price` decimal(13,0) NOT NULL,
  `bf_desc_square_feet` varchar(300) NOT NULL,
  `bf_desc_square_footage` varchar(300) NOT NULL,
  `bf_desc_square_unit` varchar(300) NOT NULL,
  `bf_map_lat` varchar(300) NOT NULL,
  `bf_map_long` varchar(300) NOT NULL,
  `bf_photo_homepage` varchar(300) NOT NULL,
  `bf_desc_issold` varchar(150) NOT NULL,
  `full_image_path` varchar(300) NOT NULL,
  `sm_image_path` varchar(300) NOT NULL,
  `get_images` int(11) NOT NULL DEFAULT '0',
  `down_local` int(11) NOT NULL DEFAULT '0',
  `image_name` varchar(300) NOT NULL,
  PRIMARY KEY (`property_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `wp_cron_property` (`property_id`, `post_id`, `bf_agent_1`, `bf_agent_2`, `bf_agent_3`, `bf_desc_aboutheadline`, `bf_desc_description`, `bf_desc_lease_price`, `bf_desc_listing_item_1`, `bf_desc_listing_item_2`, `bf_desc_no_bathroom`, `bf_desc_no_bedroom`, `bf_desc_price_type`, `bf_desc_sale_price`, `bf_desc_square_feet`, `bf_desc_square_footage`, `bf_desc_square_unit`, `bf_map_lat`, `bf_map_long`, `bf_photo_homepage`, `bf_desc_issold`, `full_image_path`, `sm_image_path`, `get_images`, `down_local`, `image_name`) VALUES
(87,	0,	'',	'',	'',	'7575 E Indian Bend Rd #1067',	'',	'',	'',	'',	'',	'',	'',	0,	'',	'',	'',	'33.5359483',	'-111.91828370000002',	'',	'3',	'',	'',	0,	0,	''),
(45,	57870,	'400',	'0',	'0',	'263 W 41st Pl, Los Angeles, CA 90037',	'This is an opportunity to own a high cash flow, low maintenance and upgraded quadruplex. With a current cap rate of over 7{e55be194a9f8e72e070e6c5736f9e626a7bcab939c030ad24dbe4ed80832023d} and great upside potential, this is ideal for passive investors looking for Steady Rents and Long-Term tenants who always pay on-time and are easy to work with... Located only one mile from the USC campus, the building contains 2, large 4BR units and 2, large 3BR units. Low maintenance and repairs due to recent updates including newÂ water heaters, new roof, new plumbing, electrical upgrades in all units, and many new fixtures. There are separate washer and dryer hookups for each unit &amp; 4 garages in the rear of the property. All units and separately-rented storage garages are rented out and/or occupied. All four-units are Section 8, which means majority of rents are direct deposit into owner\'s bank account through the Los Angeles Housing Authority.',	'',	'',	'',	'',	'',	'1',	899900,	'4,368',	'',	'1',	'34.008459',	'-118.27751999999998',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/263-W-41st-Pl1.jpg',	'',	1,	1,	'263-W-41st-Pl1.jpg'),
(46,	57873,	'401',	'0',	'0',	'2401 E Rio Salado Pkwy #1015, Tempe, AZ 85281',	'Highly Coveted 3Bd/2-level condo w/2-car garage in Tempe\'s Villagio! Model with Largest Master Bdrm... Upgrades include beautiful Natural Wood Floors and tile, custom Fans and lighting, upgraded window coverings and MORE! Relax in the slate tiled back patio or conveniently walk across to the main Pool &amp; Spa. The Villagio gated community boasts 2 large pool/spa areas and lots of grassy areas for pets. Across the street from the Cubs Stadium for Spring Training, nearby Tempe Marketplace, Mesa Riverview, ASU, light rail, bike to ASU or Scottsdale with the new River Walk paths OR hop on the 202/101 freeways to quickly go anywhere in town!',	'',	'Buyer',	'',	'2.5',	'3',	'1',	264900,	'1,399',	'',	'1',	'33.428177',	'-111.88598999999999',	'',	'1',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2401-E-Rio-Salado-Pkwy-UNIT-1015.jpg',	'',	1,	1,	'2401-E-Rio-Salado-Pkwy-UNIT-1015.jpg'),
(47,	57880,	'401',	'0',	'0',	'280 S Evergreen Rd #1281, Tempe, AZ 85281',	'',	'',	'',	'',	'2.5',	'2',	'1',	0,	'1,161',	'',	'1',	'33.424486',	'-111.88295299999999',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/280-S-Evergreen-Rd-UNIT-1281-Tempe-AZ.jpg',	'',	1,	1,	'280-S-Evergreen-Rd-UNIT-1281-Tempe-AZ.jpg'),
(48,	57884,	'401',	'0',	'0',	'1886 E Don Carlos #121, Tempe, AZ 85281',	'',	'',	'Buyer',	'',	'2.5',	'3',	'1',	200000,	'1,462',	'',	'1',	'33.4176552',	'-111.9040642',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1886-E-DON-CARLOS-Ave-121.jpg',	'',	1,	1,	'1886-E-DON-CARLOS-Ave-121.jpg'),
(49,	57889,	'401',	'0',	'0',	'2401 E Rio Salado Pkwy #1161, Tempe, AZ 85281',	'',	'',	'',	'',	'3',	'4',	'1',	258000,	'1,675',	'',	'1',	'33.428177',	'-111.88598999999999',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2401-E-Rio-Salado-Pkwy-UNIT-1161-Tempe-AZ.jpg',	'',	1,	1,	'2401-E-Rio-Salado-Pkwy-UNIT-1161-Tempe-AZ.jpg'),
(50,	57918,	'401',	'0',	'0',	'1338 W Starfish Dr, Gilbert, AZ 85233',	'',	'',	'Buyer',	'',	'3',	'3',	'1',	271000,	'2,147',	'',	'1',	'33.348767',	'-111.81883170000003',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1338-W-Starfish-Dr-Gilbert-AZ.jpg',	'',	1,	1,	'1338-W-Starfish-Dr-Gilbert-AZ.jpg'),
(51,	57921,	'401',	'0',	'0',	'1211 N Miller Rd #101, Scottsdale, AZ 85257',	'',	'',	'Buyer',	'',	'1',	'',	'1',	149000,	'1,276',	'',	'1',	'33.460668',	'-111.91619700000001',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1211-N-Miller-Rd-UNIT-101-Scottsdale-AZ.jpg',	'',	1,	1,	'1211-N-Miller-Rd-UNIT-101-Scottsdale-AZ.jpg'),
(52,	57924,	'401',	'0',	'0',	'7239 E Manzanita Dr, Scottsdale, AZ 85258',	'',	'',	'Buyer',	'',	'2',	'2',	'1',	375000,	'2,080',	'',	'1',	'33.55312930000001',	'-111.92484030000003',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/7239-E-Manzanita-Dr-Scottsdale-AZ.jpg',	'',	1,	1,	'7239-E-Manzanita-Dr-Scottsdale-AZ.jpg'),
(53,	57927,	'401',	'0',	'0',	'2402 E 5th St #1465, Tempe, AZ 85281',	'',	'',	'Buyer',	'',	'3',	'3',	'1',	245000,	'1380',	'',	'1',	'33.426111',	'-111.88514399999997',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2402-E-5th-St-UNIT-1465-Tempe-AZ.jpg',	'',	1,	1,	'2402-E-5th-St-UNIT-1465-Tempe-AZ.jpg'),
(54,	57931,	'401',	'0',	'0',	'126 E Concorda Dr, Tempe, AZ 85282',	'',	'',	'Buyer',	'',	'3',	'6',	'1',	550000,	'4,600',	'',	'1',	'33.402328',	'-111.9351638',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/126-E-Concorda-Dr-Tempe-AZ.jpg',	'',	1,	1,	'126-E-Concorda-Dr-Tempe-AZ.jpg'),
(55,	57934,	'401',	'0',	'0',	'140 E Rio Salado Pkwy, Tempe, AZ 85281',	'',	'',	'Buyer',	'',	'2',	'2',	'1',	610000,	'1,832',	'',	'1',	'33.43125810000001',	'-111.9367062',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/140-E-Rio-Salado-Pkwy-UNIT-701-Tempe-AZ1.jpg',	'',	1,	1,	'140-E-Rio-Salado-Pkwy-UNIT-701-Tempe-AZ1.jpg'),
(56,	57940,	'401',	'0',	'0',	'1905 E University Dr #146, Tempe, AZ 85281',	'',	'',	'',	'',	'2',	'2',	'1',	135000,	'8084',	'',	'1',	'33.4215361',	'-111.90449990000002',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1905-E-University-Dr-146-Tempe-AZ.jpg',	'',	1,	1,	'1905-E-University-Dr-146-Tempe-AZ.jpg'),
(57,	58024,	'401',	'0',	'0',	'10586 E Fernwood Ln, Scottsdale, AZ 85262',	'',	'',	'Buyer',	'',	'5',	'4',	'1',	900000,	'3,806',	'',	'1',	'33.8397182',	'-111.85235610000001',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/10586-E-Fernwood-Ln-Scottsdale-AZ.jpg',	'',	1,	1,	'10586-E-Fernwood-Ln-Scottsdale-AZ.jpg'),
(58,	58027,	'401',	'0',	'0',	'1446 S Newberry Ln, Tempe, AZ 85281',	'',	'$2,400',	'Buyer and Seller',	'',	'3.5',	'3',	'1',	310000,	'1,685',	'',	'1',	'33.4114682',	'-111.92050770000003',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1446-S-Newberry-Ln-Tempe-AZ.jpg',	'',	1,	1,	'1446-S-Newberry-Ln-Tempe-AZ.jpg'),
(59,	58030,	'401',	'0',	'0',	'2401 E Rio Salado Pkwy #1114, Tempe, AZ 85281',	'',	'',	'',	'',	'2.5',	'3',	'1',	262500,	'1,421',	'',	'1',	'33.428177',	'-111.88598999999999',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2401-E-Rio-Salado-Pkwy-UNIT-1114-Tempe-AZ.jpg',	'',	1,	1,	'2401-E-Rio-Salado-Pkwy-UNIT-1114-Tempe-AZ.jpg'),
(60,	58032,	'401',	'0',	'0',	'5625 E Sanna St, Paradise Valley, AZ 85253',	'',	'',	'',	'',	'6',	'5',	'1',	2285000,	'6,945',	'',	'1',	'33.5688759',	'-111.95984909999999',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/5625-E-Sanna-St-Paradise-Valley-AZ.jpg',	'',	1,	1,	'5625-E-Sanna-St-Paradise-Valley-AZ.jpg'),
(61,	58035,	'401',	'0',	'0',	'2402 E 5th St #1405, Tempe, AZ 85281',	'',	'',	'',	'',	'3',	'2',	'1',	208000,	'1,105',	'',	'1',	'33.426111',	'-111.88514399999997',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2402-E-5th-St-UNIT-1405-Tempe-AZ.jpg',	'',	1,	1,	'2402-E-5th-St-UNIT-1405-Tempe-AZ.jpg'),
(62,	58038,	'401',	'0',	'0',	'7209 N 17th Ave, Phoenix, AZ 85021',	'',	'',	'',	'',	'4',	'3',	'1',	445000,	'2,700',	'',	'1',	'33.542691',	'-112.09512259999997',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/7209-N-17th-Ave-Phoenix-AZ.jpg',	'',	1,	1,	'7209-N-17th-Ave-Phoenix-AZ.jpg'),
(63,	58041,	'401',	'0',	'0',	'2402 E 5th St #1541, Tempe, AZ 85281',	'',	'',	'Buyer and Seller',	'',	'2',	'2',	'1',	198000,	'1,105',	'',	'1',	'33.426111',	'-111.88514399999997',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2402-E-5th-St-UNIT-1541-Tempe-AZ.jpg',	'',	1,	1,	'2402-E-5th-St-UNIT-1541-Tempe-AZ.jpg'),
(64,	58045,	'401',	'0',	'0',	'4435 E Mountain View Rd, Phoenix, AZ 85028',	'',	'',	'',	'',	'5.5',	'5',	'1',	1300000,	'5,163',	'',	'1',	'33.57505',	'-111.98471510000002',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/4435-E-Mountain-View-Rd-Phoenix-AZ.jpg',	'',	1,	1,	'4435-E-Mountain-View-Rd-Phoenix-AZ.jpg'),
(65,	58049,	'401',	'0',	'0',	'5912 E Emile Zola Ave, Scottsdale, AZ 85254',	'',	'',	'Buyer',	'',	'2',	'3',	'1',	458000,	'2106',	'',	'1',	'33.6080432',	'-111.95332930000001',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/5912-E-Emile-Zola-Ave-Scottsdale-AZ.jpg',	'',	1,	1,	'5912-E-Emile-Zola-Ave-Scottsdale-AZ.jpg'),
(66,	58052,	'401',	'0',	'0',	'1287 N Alma School Rd #253, Chandler, AZ 85224',	'',	'',	'',	'',	'1',	'1',	'1',	92500,	'718',	'',	'1',	'33.3230169',	'-111.8582831',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1287-N-Alma-School-Rd-253-Chandler-AZ.jpg',	'',	1,	1,	'1287-N-Alma-School-Rd-253-Chandler-AZ.jpg'),
(67,	58055,	'401',	'0',	'0',	'2402 E 5th St #1574, Tempe, AZ 85281',	'',	'',	'',	'',	'3',	'4',	'1',	286000,	'1,675',	'',	'1',	'33.426111',	'-111.88514399999997',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2402-E-5th-St-UNIT-1574-Tempe-AZ.jpg',	'',	1,	1,	'2402-E-5th-St-UNIT-1574-Tempe-AZ.jpg'),
(68,	58058,	'401',	'0',	'0',	'2402 E 5th St #1453, Tempe, AZ 85281',	'',	'',	'',	'',	'2.5',	'2',	'1',	231000,	'1,135',	'',	'1',	'33.426111',	'-111.88514399999997',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/2402-E-5th-St-UNIT-1453-Tempe-AZ-85281.jpg',	'',	1,	1,	'2402-E-5th-St-UNIT-1453-Tempe-AZ-85281.jpg'),
(69,	58061,	'401',	'0',	'0',	'8654 E Krail St, Scottsdale, AZ 85250',	'',	'',	'',	'',	'4',	'3',	'1',	737500,	'2,820',	'',	'1',	'33.534573',	'-111.8943155',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/8654-E-Krail-St-Scottsdale-AZ.jpg',	'',	1,	1,	'8654-E-Krail-St-Scottsdale-AZ.jpg'),
(70,	63579,	'401',	'0',	'0',	'1243 E Artesian Way, Gilbert, AZ 85234',	'',	'',	'',	'',	'3',	'4',	'1',	380000,	'1902',	'',	'1',	'33.355183',	'-111.76316639999999',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/06/1243-E-Artesian-Way-Gilbert-AZ.jpg',	'',	1,	1,	'1243-E-Artesian-Way-Gilbert-AZ.jpg'),
(71,	63925,	'401',	'0',	'0',	'5429 E Solano Dr, Paradise Valley, AZ 85253',	'',	'',	'',	'',	'3',	'4',	'1',	1300000,	'3,152',	'',	'1',	'33.5203876',	'-111.96402740000002',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/07/5429-E-Solano-Dr-Paradise-Valley-AZ.jpg',	'',	1,	1,	'5429-E-Solano-Dr-Paradise-Valley-AZ.jpg'),
(72,	63928,	'401',	'0',	'0',	'7734 N 3rd Ave, Phoenix, AZ 85021',	'',	'',	'',	'',	'2.5',	'4',	'1',	420000,	'3,156',	'',	'1',	'33.5505224',	'-112.0786344',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/07/7734-N-3rd-Ave-Phoenix-AZ.jpg',	'',	1,	1,	'7734-N-3rd-Ave-Phoenix-AZ.jpg'),
(73,	64492,	'401',	'0',	'0',	'3714 E Orange Dr, Phoenix, AZ 85018',	'',	'',	'',	'',	'6.5',	'6',	'1',	1690000,	'6,279',	'',	'1',	'33.5129264',	'-112.00055170000002',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/07/3714-E-Orange-Dr-Phoenix-AZ.jpg',	'',	0,	1,	'3714-E-Orange-Dr-Phoenix-AZ.jpg'),
(74,	64495,	'401',	'0',	'0',	'2150 W Alameda Rd #1269, Phoenix, AZ 85085',	'Completely customized Emilia model in Villagio at Happy Valley converted to 1675 sq ft 2 Bdrm/3 Bath w/massive Open Plan entertaining space and tons of natural lighting! Tasteful contemporary/transitional remodel and every detail artistically executed w/ Upgrades such as custom light fixtures and fans, granite countertops, SS appliances, upgraded flooring throughout, upgraded cabinetry, beautiful accent walls to complement the modern furnishings also available for sale and MORE! The Villagio gated community boasts 2 large pool/spa areas and lots of grassy areas for pets. Conveniently located near the Norterra Shops, USAA, Honeywell OR hop on the 17 freeway to quickly go anywhere in town!',	'',	'',	'',	'3',	'2',	'1',	234900,	'1,675',	'',	'1',	'33.7079676',	'-112.10624860000001',	'',	'1',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2017/07/2150-W-Alameda-Rd-1269-Phoenix-AZ-1.jpg',	'',	0,	1,	'2150-W-Alameda-Rd-1269-Phoenix-AZ-1.jpg'),
(75,	106704,	'400',	'0',	'0',	'3261 Sawtelle Blvd APT 104, Los Angeles, CA 90066',	'',	'',	'',	'',	'2',	'2',	'1',	620000,	'860',	'',	'1',	'34.0214465',	'-118.42807579999999',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2018/08/3261-Sawtelle-Blvd-104-Los-Angeles-CA-90066.jpg',	'',	0,	1,	'3261-Sawtelle-Blvd-104-Los-Angeles-CA-90066.jpg'),
(76,	106705,	'400',	'0',	'0',	'263 W 41st Pl, Los Angeles, CA 90037',	'',	'',	'',	'',	'',	'',	'1',	899000,	'',	'',	'1',	'34.0083852',	'-118.27755760000002',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2018/08/263-W-41st-Pl.jpg',	'',	0,	1,	'263-W-41st-Pl.jpg'),
(77,	106706,	'400',	'0',	'0',	'913 18th St APT 5, Santa Monica, CA 90403',	'',	'$6,500/mo',	'',	'',	'2.5',	'3',	'2',	6500,	'1,833',	'',	'1',	'34.033812',	'-118.48920129999999',	'',	'5',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2018/08/913-18-th-Street-5-Santa-Monica-CA-90403.jpg',	'',	0,	1,	'913-18-th-Street-5-Santa-Monica-CA-90403.jpg'),
(78,	106707,	'400',	'0',	'0',	'1952 Coldwater Canyon Dr, Beverly Hills, CA 90210',	'',	'',	'',	'',	'4.5',	'4',	'1',	3888000,	'3,783',	'',	'1',	'34.1066363',	'-118.4051513',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2018/08/1952-Coldwater-Canyon-Drive-Beverly-Hills-CA-90210.jpg',	'',	0,	1,	'1952-Coldwater-Canyon-Drive-Beverly-Hills-CA-90210.jpg'),
(79,	106708,	'400',	'0',	'0',	'415 S Spalding Dr UNIT 202, Beverly Hills, CA 90212',	'',	'',	'',	'',	'2.5',	'2',	'1',	1650000,	'1,825',	'',	'1',	'34.0584938',	'-118.40922080000001',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2018/08/415-S.-Spalding-Drive-202-Beverly-Hills-CA-90212.jpg',	'',	0,	1,	'415-S.-Spalding-Drive-202-Beverly-Hills-CA-90212.jpg'),
(80,	106709,	'400',	'0',	'0',	'1225 Beverly Green Dr, Beverly Hills, CA 90212',	'',	'',	'',	'',	'3.5',	'4',	'1',	2650000,	'2,680',	'',	'1',	'34.055839',	'-118.40606409999998',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2018/08/1225-Beverly-Green-Drive-Beverly-Hills-CA-90212.jpg',	'',	0,	1,	'1225-Beverly-Green-Drive-Beverly-Hills-CA-90212.jpg'),
(81,	106710,	'400',	'0',	'0',	'8647 Edwin Dr, Los Angeles, CA 90046',	'',	'',	'',	'',	'4.5',	'4',	'1',	3210000,	'4,162',	'',	'1',	'34.121651',	'-118.390736',	'',	'3',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2018/08/8647-Edwin-Drive-Los-Angeles-CA-90046.jpg',	'',	0,	1,	'8647-Edwin-Drive-Los-Angeles-CA-90046.jpg'),
(89,	0,	'400',	'0',	'0',	'913 18th St APT 1, Santa Monica, CA 90403',	'Located in one of the most desirable areas in Santa Monica, this NEWLY remodeled townhouse is near the best dining and shopping on Montana Ave and minutes from the beach. Experience indoor/outdoor living at its finest with this coveted 3BD/2.5BA unit and huge wrap-around tiled patio. This front End-Unit has tons of natural lighting, plus dual-level floor plan offers privacy and room to entertain. An open living room with fireplace flows into the dining and kitchen area with powder bath and laundry. Fully remodeled kitchen has new countertops, new SS appliances, gray cabinets, and subway tile backsplash. Ascend the stairs to the master bedroom with two balconies and en-suite bath fully remodeled. Two guest bedrooms, one with a balcony, and a full remodeled guest bath are also on the second level. Additional features: freshly painted, refinished maple floors, laundry closet downstairs, and 2 side-by-side garage parking spots. BONUS ALERT: Within the Franklin and Lincoln School District!',	'6000',	'',	'',	'2.5',	'3',	'1',	6000,	'1,607',	'',	'1',	'34.0338144',	'-118.48920780000003',	'',	'1',	'',	'',	0,	0,	'1569970417_913_18th_st_7_websize.jpg'),
(83,	119162,	'400',	'0',	'0',	'334 W Magna Vista Ave, Arcadia, CA 91007',	'<p>Discover this artistically remodeled 3BR/2BA one-level ranch home in prime Arcadia! Spread out with this 8,269 SF lot and backyard that is equipped with covered patio and lots of room for a pool and/or sport court. Imagine your dream home and create the perfect Arcadia indoor/outdoor living spaceâ€¦</p><p>Key features of this 1,614 SF home include: Open concept living area, split floor plan, inviting brick-built gas fireplace, lush landscaping, recessed lighting, all-new stainless steel appliances, soft water system, laundry room with sink, hardwood floors, tons of storage room, and attached 2-car garage.</p><p>The kitchen and bathrooms have been fully remodeled with shimmering quartz counter tops, sleek subway tile backsplash, French country-style cabinets in kitchen, porcelain tile floors, stainless-steel appliances, tiled walk-in showers, and dual-sink vanity.Â </p><p>A highly-sought after location in Arcadia, the home is next door to top-ranked Holly Avenue Elementary School and park. It is also in walking distance to Arcadia High School, Arcadia Library, and Baldwin Ave shops, restaurants and supermarkets, such as Vons, LA Fitness, Ranch 99, Din Tai Fung and much more. Within minutes by car to the Santa Anita Golf Course, Westfield Mall and more, this makes 334 W Magna Vista Avenue the perfect place to put down roots!</p>',	'',	'',	'',	'2',	'3',	'1',	1095000,	'1,614',	'8,269',	'2',	'34.1265798',	'-118.04360610000003',	'',	'1',	'https://access.ultrasavvyphotographer.com/wp-content/uploads/2018/11/073.jpg',	'',	0,	1,	'073.jpg'),
(90,	0,	'400',	'0',	'0',	'211 S Spalding Dr #N112, Beverly Hills, CA 90212',	'One of the largest units in the building, this contemporary 3 Bdrm/3.5 Bath two-level condo has views of Century City and a spacious private patio! At almost 2500 sq ft, kitchen, dining, living room and powder bath are all on the first level. Ascend the stairs to discover 3 en-suite bedrooms, plus laundry room and service entry door. This corner unit provides abundant natural lighting and privacy, upgrades include all hardwood floors, tile bathrooms, quartz countertops, top-of-the-line SS appliances, remodeled bathrooms, and more. Located in the highly sought after full-service Two Eleven Spalding building, with amenities including complimentary valet, front desk, secured entry, recently remodeled pool and spa area, meeting room, gym, and individual storage units. Just blocks away from BH High School, Rodeo and Beverly Drive shopping, Century City Westfield Mall and more!',	'',	'',	'',	'3.5',	'3',	'1',	2083850,	'2,481',	'',	'1',	'34.064305',	'-118.40920900000003',	'',	'3',	'',	'',	0,	0,	'1569968164_11.jpg'),
(91,	0,	'400',	'0',	'0',	'6746 Wedgewood Place, Los Angeles, CA 90068',	'This stunning 3BR/4BA 2,706 sq ft historic masterpiece was the previous residence of W.C. Fields, American comedian and actor, in the 1930s. The home has since been artistically updated and historical elements masterfully preserved, resulting in a stunning Spanish colonial-style property of over 7600 sq ft with features like a tranquil fountain entry, vaulted barrel ceilings in the living room, expansive patio with sweeping canyon views, light and bright gourmet kitchen, 2-level floor plan with perfect living and entertaining separation, Sonos sound system, new exterior stairs leading to a large grassy backyard with citrus trees, and 4 outdoor sitting areas. All 3 bedrooms are en suite, plus an attached guest suite called the \\\\\\\"Chauffeur\\\\\\\'s Room.\\\\\\\" The property is perched on a hill in the Whitley Heights Historic District, a short walk to the Hollywood Bowl, Walk of Fame, Hollywood Boulevard and minutes to the Valley. BONUS ALERT: Property taxes are a fraction of comparable homes!',	'',	'',	'',	'4',	'4',	'1',	1772500,	'2,598',	'',	'1',	'34.1093039',	'-118.33465839999997',	'',	'3',	'',	'',	0,	0,	'1569972109_09.jpg'),
(88,	0,	'Chris Gray',	'',	'',	'9476 Hidden Valley Pl, Beverly Hills, CA 90210',	'This luxurious bungalow has been lovingly remodeled with attention to every detail. A rare value in the sought-after 90210 ZIP code, this 2,400 square-foot home sits on an oversized, 11,000 square-foot lot that offers options to expand its footprint or add a second story. Or just enjoy it as is, which is perfectly move-in ready. You’ll appreciate the spacious living room with fireplace, as well as abundant 3 bedrooms and 2 baths, all of which receive ample natural light. In addition, the open floor plan includes a formal dining room, wet bar, and galley kitchen with breakfast nook. Notable updates include quartz countertops, Bosch appliances, Nest thermostat, new flooring, and front-yard water feature. \r\n\r\nLocated near the top of Coldwater Canyon with easy access to first-class shopping, dining, top-rated Harvard Westlake School, and natural parks, this home has it all. Plus, with such a large lot, the yard boasts a putting green and covered patio that extend the opportunity to enjoy the beautiful Beverly Hills weather. A two-car attached garage and separate utility room with stacked washer and dryer deliver plenty of inside storage—and that doesn’t even take into account the exterior storage closet!\r\n\r\nFor more information, go to www.9476HiddenValley.com.',	'',	'',	'',	'2',	'3',	'Sale',	2095000,	'2,388',	'',	'',	'34.1207839',	'-118.4002873',	'',	'1',	'',	'',	0,	0,	'1569970293_21.jpg'),
(92,	0,	'',	'',	'',	'Antelope Canyon - Parcel #1',	'18+ Acre vacant land parcel in a very attractive future development area in Antelope Valley near Pearblossom Highway with Barrel Springs Rd running through the property. Some hillside for excellent mountain views. Development of single family homes and apartments nearby. Buyer agent and buyer to verify utility information.',	'',	'',	'',	'0',	'0',	'1',	120000,	'794970',	'',	'',	'34.520933',	'-118.040802',	'',	'1',	'',	'',	0,	0,	'1570062009_3048-029-002_(5).jpg'),
(93,	0,	'',	'',	'',	'Antelope Canyon - Parcel #2',	'Over 2 Acre parcel in a great area in Pearblossom in the Antelope Valley. Elevated flat lot with great valley and mountain views. Perfect for building a custom home with plenty of land. Pearblossom Park, Pearblossom Elementary School and developments all nearby. Buyer\\\\\\\'s agent and/or buyer to verify all utility information.',	'',	'',	'',	'0',	'0',	'1',	25000,	'91040',	'',	'1',	'34.490145',	'-117.913956',	'',	'1',	'',	'',	0,	0,	'1570062506_3038-026-009_(3).jpg'),
(94,	0,	'',	'',	'',	'Antelope Canyon - Parcel #3',	'Almost 5 Acre parcel in beautiful Roosevelt Corner of the Antelope Valley. Extremely flat lot perfect for new construction with custom homes nearby. Buyer and/or buyer\\\\\\\'s agent to verify all utilities.',	'',	'',	'',	'0',	'0',	'1',	50000,	'204732',	'',	'1',	'34.686414',	'-117.951782',	'',	'1',	'',	'',	0,	0,	'1570062734_3376-021-081_(7).jpg'),
(95,	0,	'',	'',	'',	'1155 N La Cienega Blvd APT 414 West Hollywood, CA 90069',	'Fully furnished 2BR condo located in the Westview Towers full-service building (major remodel of building in 2012). 24/7 valet parking for residence & guests, 24/7 controlled access, on-site dog park and gym. Large pool deck with his-and-hers restrooms, saunas & showers. Pool & spa feature beautiful city views. Corner unit in building with lots of natural light, newly remodeled with modern design touches, stainless steel appliances in kitchen with breakfast bar, built-in office space, large living room that opens to balcony. Spacious master bedroom with lots of closet space and a modern bathroom with top-of-the-line finishes. Guest room features additional closet space and can be used as office, second remodeled bath for resident/guests. Seconds away from famed Sunset Strip, Fred Segal, Equinox Fitness, Barry\\\\\\\'s Bootcamp, SoHo House, and all the city hotspots/nightlife. 5-minute drive/Uber ride to prime Beverly Hills. Completely move-in ready residence for today\\\\\\\'s sophisticated renter!',	'',	'',	'',	'2',	'2',	'2',	4900,	'1,161',	'',	'',	'34.0922361',	'-118.3766',	'',	'3',	'',	'',	0,	0,	'1570063936_05.jpg'),
(96,	0,	'',	'',	'',	'4015 Hunt Club Ct Agoura Hills, CA 91301',	'9 Miles to the Pacific Ocean and Malibu. Gorgeous estate home located in a gated community. Beautiful home for entertaining with an incredible backyard and pool area. This home is filled with elegance and charisma. All five bedrooms have private bathrooms. The covered patio overlooks a fabulous pool, spa and flower gardens.',	'',	'',	'',	'6',	'5',	'1',	2000000,	'6,409',	'',	'1',	'34.1314243',	'-118.75801560000002',	'',	'3',	'',	'',	0,	0,	'1570064415_agoura_hills.jpg'),
(97,	0,	'',	'',	'',	'20247 Piedra Chica Rd, Malibu, CA 90265',	'Give yourself the gift of a world-famous Malibu lifestyle this year! Elevated not far above the PCH, behind a gated entrance and within a secluded cul-de-sac, sits this Midcentury Modern architectural gem on an acre of land in Malibu\\\'s Big Rock neighborhood. Marvel at the jaw-dropping 270 unobstructed ocean views, including Catalina Island. Every room of this 3,300 sq. ft 3 BR/3 Full BA plus office/den home has views to enjoy. A contemporary design with hardwood floors, quartz and stone countertops, vaulted ceilings and retractable glass doors, which open to a heated pool and large grassy backyard in the living room and master BR, allowing for the best of indoor/outdoor Malibu living. Special features include: walk-in closets, full powder bath, huge laundry room, 2-car garage, 2 interior and 1 exterior gas fireplaces, wine fridge, all high-end appliances, solar panels, and more! Experience privacy without losing quick access to all the best amenities Malibu has to offer.',	'18000',	'',	'',	'3',	'3',	'2',	18000,	'3278',	'',	'1',	'34.0388',	'-118.6145138',	'',	'1',	'',	'',	0,	0,	'1578946039_a_0039_0001.jpg');

DROP TABLE IF EXISTS `wp_gf_draft_submissions`;
CREATE TABLE `wp_gf_draft_submissions` (
  `uuid` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `form_id` mediumint(8) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` varchar(39) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source_url` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `submission` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`uuid`),
  KEY `form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


DROP TABLE IF EXISTS `wp_gf_entry`;
CREATE TABLE `wp_gf_entry` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(8) unsigned NOT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_starred` tinyint(1) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `ip` varchar(39) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_agent` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `currency` varchar(5) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_status` varchar(15) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_amount` decimal(19,2) DEFAULT NULL,
  `payment_method` varchar(30) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `transaction_id` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_fulfilled` tinyint(1) DEFAULT NULL,
  `created_by` bigint(20) unsigned DEFAULT NULL,
  `transaction_type` tinyint(1) DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `form_id_status` (`form_id`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_gf_entry` (`id`, `form_id`, `post_id`, `date_created`, `date_updated`, `is_starred`, `is_read`, `ip`, `source_url`, `user_agent`, `currency`, `payment_status`, `payment_date`, `payment_amount`, `payment_method`, `transaction_id`, `is_fulfilled`, `created_by`, `transaction_type`, `status`) VALUES
(1,	3,	NULL,	'2020-11-10 12:46:21',	'2020-11-10 12:46:21',	0,	0,	'162.158.88.124',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(2,	3,	NULL,	'2020-11-28 04:09:26',	'2020-11-28 04:09:26',	0,	0,	'172.69.55.78',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.64',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(3,	2,	NULL,	'2020-12-04 16:54:55',	'2020-12-04 16:54:55',	0,	0,	'108.162.215.248',	'https://graygroupla.com/home-value-report/',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(4,	2,	NULL,	'2020-12-04 16:55:49',	'2020-12-04 16:55:49',	0,	0,	'108.162.215.248',	'https://graygroupla.com/home-value-report/',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(5,	3,	NULL,	'2020-12-09 19:23:04',	'2020-12-09 19:23:04',	0,	0,	'172.69.33.231',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	2,	NULL,	'active'),
(6,	3,	NULL,	'2020-12-23 11:09:53',	'2020-12-23 11:09:53',	0,	0,	'172.68.239.193',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; rv:38.0) Gecko/20100101 Firefox/38.0',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(7,	3,	NULL,	'2021-02-13 19:37:06',	'2021-02-13 19:37:06',	0,	0,	'172.69.33.188',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4324.146 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(8,	3,	NULL,	'2021-03-10 17:59:42',	'2021-03-10 17:59:42',	0,	0,	'172.69.34.106',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.2 Safari/605.1.15',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(9,	3,	NULL,	'2021-03-19 22:37:44',	'2021-03-19 22:37:44',	0,	0,	'162.158.22.34',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.62 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(10,	2,	NULL,	'2021-03-19 23:24:01',	'2021-03-19 23:24:01',	0,	0,	'172.69.34.86',	'https://graygroupla.com/home-value-report/',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.82 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(11,	2,	NULL,	'2021-03-19 23:25:01',	'2021-03-19 23:25:01',	0,	0,	'172.69.34.86',	'https://graygroupla.com/home-value-report/',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.82 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(12,	2,	NULL,	'2021-03-21 01:13:53',	'2021-03-21 01:13:53',	0,	0,	'172.69.33.41',	'https://graygroupla.com/home-value-report/',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.82 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(13,	2,	NULL,	'2021-03-21 01:15:38',	'2021-03-21 01:15:38',	0,	0,	'172.69.34.148',	'https://graygroupla.com/home-value-report/',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.82 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(14,	3,	NULL,	'2021-04-12 14:34:52',	'2021-04-12 14:34:52',	0,	0,	'108.162.215.114',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:87.0) Gecko/20100101 Firefox/87.0',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(15,	3,	NULL,	'2021-06-02 06:11:26',	'2021-06-02 06:11:26',	0,	0,	'172.69.34.148',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.212 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(16,	3,	NULL,	'2021-06-03 09:58:04',	'2021-06-03 09:58:04',	0,	0,	'162.158.134.38',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36 Kinza/4.8.2',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(17,	3,	NULL,	'2021-06-19 23:20:01',	'2021-06-19 23:20:01',	0,	0,	'172.68.11.235',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4102.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(18,	3,	NULL,	'2021-06-30 15:16:48',	'2021-06-30 15:16:48',	0,	0,	'141.101.69.19',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36 Kinza/4.8.2',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(19,	3,	NULL,	'2021-07-02 10:05:29',	'2021-07-02 10:05:29',	0,	0,	'172.68.186.96',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(20,	3,	NULL,	'2021-07-05 07:09:56',	'2021-07-05 07:09:56',	0,	0,	'141.101.77.200',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(21,	3,	NULL,	'2021-07-05 08:47:05',	'2021-07-05 08:47:05',	0,	0,	'172.68.226.171',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(22,	3,	NULL,	'2021-07-05 19:59:40',	'2021-07-05 19:59:40',	0,	0,	'162.158.92.94',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(23,	3,	NULL,	'2021-07-06 01:21:13',	'2021-07-06 01:21:13',	0,	0,	'162.158.89.218',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(24,	3,	NULL,	'2021-07-06 21:36:43',	'2021-07-06 21:36:43',	0,	0,	'162.158.91.73',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(25,	3,	NULL,	'2021-07-06 23:56:24',	'2021-07-06 23:56:24',	0,	0,	'162.158.92.160',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(26,	3,	NULL,	'2021-07-07 06:52:27',	'2021-07-07 06:52:27',	0,	0,	'172.68.11.235',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(27,	3,	NULL,	'2021-07-07 08:28:55',	'2021-07-07 08:28:55',	0,	0,	'162.158.183.201',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.86 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(28,	3,	NULL,	'2021-07-07 15:54:02',	'2021-07-07 15:54:02',	0,	0,	'162.158.89.247',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(29,	3,	NULL,	'2021-07-07 15:54:16',	'2021-07-07 15:54:16',	0,	0,	'162.158.92.226',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(30,	3,	NULL,	'2021-07-09 09:41:49',	'2021-07-09 09:41:49',	0,	0,	'141.101.76.78',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(31,	3,	NULL,	'2021-07-10 17:07:44',	'2021-07-10 17:07:44',	0,	0,	'141.101.69.207',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(32,	3,	NULL,	'2021-07-10 22:36:41',	'2021-07-10 22:36:41',	0,	0,	'162.158.91.74',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(33,	3,	NULL,	'2021-07-11 20:42:59',	'2021-07-11 20:42:59',	0,	0,	'172.69.55.190',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(34,	3,	NULL,	'2021-07-12 05:00:22',	'2021-07-12 05:00:22',	0,	0,	'162.158.89.217',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(35,	3,	NULL,	'2021-07-13 00:47:57',	'2021-07-13 00:47:57',	0,	0,	'172.68.10.92',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(36,	3,	NULL,	'2021-07-13 19:28:25',	'2021-07-13 19:28:25',	0,	0,	'172.69.194.42',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(37,	3,	NULL,	'2021-07-14 18:19:45',	'2021-07-14 18:19:45',	0,	0,	'162.158.203.29',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(38,	3,	NULL,	'2021-07-14 20:32:12',	'2021-07-14 20:32:12',	0,	0,	'162.158.89.85',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(39,	3,	NULL,	'2021-07-16 08:57:53',	'2021-07-16 08:57:53',	0,	0,	'141.101.69.98',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(40,	3,	NULL,	'2021-07-16 18:55:34',	'2021-07-16 18:55:34',	0,	0,	'162.158.183.235',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(41,	3,	NULL,	'2021-07-19 04:17:17',	'2021-07-19 04:17:17',	0,	0,	'172.68.10.208',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(42,	3,	NULL,	'2021-07-19 05:37:25',	'2021-07-19 05:37:25',	0,	0,	'172.69.194.42',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(43,	3,	NULL,	'2021-07-19 21:03:06',	'2021-07-19 21:03:06',	0,	0,	'141.101.69.77',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(44,	3,	NULL,	'2021-07-19 22:30:33',	'2021-07-19 22:30:33',	0,	0,	'162.158.50.13',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(45,	3,	NULL,	'2021-07-21 08:41:42',	'2021-07-21 08:41:42',	0,	0,	'172.68.10.172',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(46,	3,	NULL,	'2021-07-23 08:50:36',	'2021-07-23 08:50:36',	0,	0,	'162.158.19.89',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(47,	3,	NULL,	'2021-07-23 13:49:07',	'2021-07-23 13:49:07',	0,	0,	'162.158.18.198',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(48,	3,	NULL,	'2021-07-23 14:47:36',	'2021-07-23 14:47:36',	0,	0,	'172.69.194.42',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4400.8 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(49,	3,	NULL,	'2021-07-26 13:23:34',	'2021-07-26 13:23:34',	0,	0,	'162.158.183.123',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(50,	3,	NULL,	'2021-07-27 03:02:30',	'2021-07-27 03:02:30',	0,	0,	'172.68.246.171',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(51,	3,	NULL,	'2021-07-27 05:59:09',	'2021-07-27 05:59:09',	0,	0,	'172.70.110.148',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(52,	3,	NULL,	'2021-07-28 20:14:48',	'2021-07-28 20:14:48',	0,	0,	'141.101.104.196',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(53,	3,	NULL,	'2021-07-28 21:31:21',	'2021-07-28 21:31:21',	0,	0,	'172.69.194.35',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(54,	3,	NULL,	'2021-08-01 06:13:53',	'2021-08-01 06:13:53',	0,	0,	'172.68.10.106',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(55,	3,	NULL,	'2021-08-01 13:27:06',	'2021-08-01 13:27:06',	0,	0,	'172.68.10.202',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(56,	3,	NULL,	'2021-08-01 13:28:12',	'2021-08-01 13:28:12',	0,	0,	'172.68.246.172',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(57,	3,	NULL,	'2021-08-03 11:43:49',	'2021-08-03 11:43:49',	0,	0,	'172.68.226.170',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(58,	3,	NULL,	'2021-08-03 23:04:30',	'2021-08-03 23:04:30',	0,	0,	'172.68.10.45',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(59,	3,	NULL,	'2021-08-04 21:59:30',	'2021-08-04 21:59:30',	0,	0,	'172.70.136.136',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(60,	3,	NULL,	'2021-08-05 06:26:08',	'2021-08-05 06:26:08',	0,	0,	'162.158.18.198',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(61,	3,	NULL,	'2021-08-06 02:59:53',	'2021-08-06 02:59:53',	0,	0,	'172.68.244.235',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(62,	3,	NULL,	'2021-08-06 13:56:26',	'2021-08-06 13:56:26',	0,	0,	'172.68.50.58',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(63,	3,	NULL,	'2021-08-07 14:55:09',	'2021-08-07 14:55:09',	0,	0,	'172.68.50.241',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(64,	3,	NULL,	'2021-08-10 19:41:55',	'2021-08-10 19:41:55',	0,	0,	'141.101.105.115',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4400.8 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(65,	3,	NULL,	'2021-08-13 03:34:31',	'2021-08-13 03:34:31',	0,	0,	'172.68.11.108',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(66,	3,	NULL,	'2021-08-13 03:34:57',	'2021-08-13 03:34:57',	0,	0,	'172.68.246.63',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(67,	3,	NULL,	'2021-08-13 20:17:15',	'2021-08-13 20:17:15',	0,	0,	'172.68.50.105',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(68,	3,	NULL,	'2021-08-16 02:31:56',	'2021-08-16 02:31:56',	0,	0,	'172.68.10.187',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(69,	3,	NULL,	'2021-08-16 04:04:11',	'2021-08-16 04:04:11',	0,	0,	'172.68.246.57',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(70,	3,	NULL,	'2021-08-16 06:05:02',	'2021-08-16 06:05:02',	0,	0,	'172.68.246.63',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(71,	3,	NULL,	'2021-08-18 12:56:30',	'2021-08-18 12:56:30',	0,	0,	'162.158.183.212',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(72,	3,	NULL,	'2021-08-19 22:07:43',	'2021-08-19 22:07:43',	0,	0,	'141.101.68.137',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(73,	3,	NULL,	'2021-08-22 19:12:43',	'2021-08-22 19:12:43',	0,	0,	'172.68.238.27',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4087.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(74,	3,	NULL,	'2021-08-25 00:58:18',	'2021-08-25 00:58:18',	0,	0,	'172.68.244.145',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(75,	3,	NULL,	'2021-08-25 09:28:59',	'2021-08-25 09:28:59',	0,	0,	'162.158.88.101',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(76,	3,	NULL,	'2021-08-26 01:09:09',	'2021-08-26 01:09:09',	0,	0,	'141.101.69.246',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(77,	3,	NULL,	'2021-08-27 08:37:57',	'2021-08-27 08:37:57',	0,	0,	'172.68.11.28',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4400.8 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(78,	3,	NULL,	'2021-08-27 09:25:27',	'2021-08-27 09:25:27',	0,	0,	'172.68.11.10',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.34 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(79,	3,	NULL,	'2021-08-27 11:52:26',	'2021-08-27 11:52:26',	0,	0,	'172.68.10.207',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(80,	3,	NULL,	'2021-08-27 20:52:08',	'2021-08-27 20:52:08',	0,	0,	'162.158.183.212',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(81,	3,	NULL,	'2021-08-30 05:57:51',	'2021-08-30 05:57:51',	0,	0,	'141.101.104.220',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(82,	3,	NULL,	'2021-08-30 21:25:21',	'2021-08-30 21:25:21',	0,	0,	'172.68.11.106',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(83,	3,	NULL,	'2021-09-01 16:12:00',	'2021-09-01 16:12:00',	0,	0,	'172.68.246.57',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(84,	3,	NULL,	'2021-09-04 14:39:56',	'2021-09-04 14:39:56',	0,	0,	'162.158.183.106',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.39',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(85,	3,	NULL,	'2021-09-05 10:40:41',	'2021-09-05 10:40:41',	0,	0,	'172.68.246.63',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(86,	3,	NULL,	'2021-09-06 10:44:01',	'2021-09-06 10:44:01',	0,	0,	'172.68.11.38',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.86 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(87,	3,	NULL,	'2021-09-06 10:44:25',	'2021-09-06 10:44:25',	0,	0,	'172.68.246.189',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(88,	3,	NULL,	'2021-09-06 11:42:45',	'2021-09-06 11:42:45',	0,	0,	'162.158.91.42',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(89,	3,	NULL,	'2021-09-06 12:29:43',	'2021-09-06 12:29:43',	0,	0,	'162.158.90.183',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(90,	3,	NULL,	'2021-09-06 15:25:08',	'2021-09-06 15:25:08',	0,	0,	'141.101.99.164',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(91,	3,	NULL,	'2021-09-07 17:06:39',	'2021-09-07 17:06:39',	0,	0,	'162.158.203.32',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(92,	3,	NULL,	'2021-09-07 18:28:18',	'2021-09-07 18:28:18',	0,	0,	'162.158.203.30',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(93,	3,	NULL,	'2021-09-09 03:30:45',	'2021-09-09 03:30:45',	0,	0,	'141.101.77.22',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.86 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(94,	3,	NULL,	'2021-09-09 16:30:47',	'2021-09-09 16:30:47',	0,	0,	'172.69.68.88',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(95,	3,	NULL,	'2021-09-10 07:02:51',	'2021-09-10 07:02:51',	0,	0,	'172.69.208.141',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(96,	3,	NULL,	'2021-09-12 06:44:05',	'2021-09-12 06:44:05',	0,	0,	'172.68.245.50',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(97,	3,	NULL,	'2021-09-12 16:00:01',	'2021-09-12 16:00:01',	0,	0,	'172.68.10.45',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(98,	3,	NULL,	'2021-09-12 23:04:15',	'2021-09-12 23:04:15',	0,	0,	'162.158.18.197',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4096.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(99,	3,	NULL,	'2021-09-13 12:26:09',	'2021-09-13 12:26:09',	0,	0,	'162.158.183.190',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(100,	3,	NULL,	'2021-09-15 05:21:11',	'2021-09-15 05:21:11',	0,	0,	'162.158.183.106',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(101,	3,	NULL,	'2021-09-18 01:02:12',	'2021-09-18 01:02:12',	0,	0,	'141.101.104.188',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(102,	3,	NULL,	'2021-09-18 07:37:44',	'2021-09-18 07:37:44',	0,	0,	'172.68.10.77',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(103,	3,	NULL,	'2021-09-20 09:18:49',	'2021-09-20 09:18:49',	0,	0,	'141.101.76.53',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(104,	3,	NULL,	'2021-09-20 09:19:19',	'2021-09-20 09:19:19',	0,	0,	'141.101.104.188',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(105,	3,	NULL,	'2021-09-21 04:55:40',	'2021-09-21 04:55:40',	0,	0,	'141.101.77.112',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(106,	3,	NULL,	'2021-09-23 14:24:57',	'2021-09-23 14:24:57',	0,	0,	'141.101.104.56',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.68',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(107,	3,	NULL,	'2021-09-23 15:08:21',	'2021-09-23 15:08:21',	0,	0,	'141.101.77.165',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(108,	3,	NULL,	'2021-09-24 16:44:19',	'2021-09-24 16:44:19',	0,	0,	'141.101.104.158',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(109,	3,	NULL,	'2021-09-24 19:34:00',	'2021-09-24 19:34:00',	0,	0,	'172.68.246.147',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(110,	3,	NULL,	'2021-09-24 22:44:48',	'2021-09-24 22:44:48',	0,	0,	'172.70.110.83',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(111,	3,	NULL,	'2021-09-27 04:11:53',	'2021-09-27 04:11:53',	0,	0,	'172.68.11.110',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(112,	3,	NULL,	'2021-09-27 23:35:19',	'2021-09-27 23:35:19',	0,	0,	'162.158.91.132',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4427.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(113,	3,	NULL,	'2021-09-28 19:49:52',	'2021-09-28 19:49:52',	0,	0,	'141.101.76.159',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(114,	3,	NULL,	'2021-09-30 01:29:19',	'2021-09-30 01:29:19',	0,	0,	'162.158.94.225',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(115,	3,	NULL,	'2021-09-30 15:46:40',	'2021-09-30 15:46:40',	0,	0,	'172.68.238.149',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(116,	3,	NULL,	'2021-10-01 13:57:20',	'2021-10-01 13:57:20',	0,	0,	'172.70.147.115',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(117,	3,	NULL,	'2021-10-04 03:50:05',	'2021-10-04 03:50:05',	0,	0,	'162.158.89.230',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4427.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(118,	3,	NULL,	'2021-10-05 17:07:19',	'2021-10-05 17:07:19',	0,	0,	'172.68.10.155',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(119,	3,	NULL,	'2021-10-07 06:14:51',	'2021-10-07 06:14:51',	0,	0,	'172.68.238.149',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(120,	3,	NULL,	'2021-10-07 09:13:05',	'2021-10-07 09:13:05',	0,	0,	'172.70.110.153',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.86 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(121,	3,	NULL,	'2021-10-07 22:35:48',	'2021-10-07 22:35:48',	0,	0,	'141.101.77.240',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(122,	3,	NULL,	'2021-10-10 05:54:10',	'2021-10-10 05:54:10',	0,	0,	'141.101.105.97',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(123,	3,	NULL,	'2021-10-12 22:23:23',	'2021-10-12 22:23:23',	0,	0,	'162.158.183.220',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(124,	3,	NULL,	'2021-10-17 07:29:04',	'2021-10-17 07:29:04',	0,	0,	'162.158.93.160',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(125,	3,	NULL,	'2021-10-17 07:46:32',	'2021-10-17 07:46:32',	0,	0,	'141.101.105.181',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(126,	3,	NULL,	'2021-10-20 06:11:29',	'2021-10-20 06:11:29',	0,	0,	'172.70.114.106',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(127,	3,	NULL,	'2021-10-21 15:22:05',	'2021-10-21 15:22:05',	0,	0,	'108.162.229.52',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(128,	3,	NULL,	'2021-10-22 07:13:14',	'2021-10-22 07:13:14',	0,	0,	'162.158.183.201',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(129,	3,	NULL,	'2021-10-22 10:12:49',	'2021-10-22 10:12:49',	0,	0,	'162.158.183.201',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(130,	3,	NULL,	'2021-10-24 01:23:24',	'2021-10-24 01:23:24',	0,	0,	'172.68.238.34',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(131,	3,	NULL,	'2021-10-24 09:31:13',	'2021-10-24 09:31:13',	0,	0,	'172.68.238.118',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(132,	3,	NULL,	'2021-10-25 06:16:14',	'2021-10-25 06:16:14',	0,	0,	'172.68.238.142',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(133,	3,	NULL,	'2021-10-26 13:24:17',	'2021-10-26 13:24:17',	0,	0,	'172.68.238.34',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(134,	3,	NULL,	'2021-10-27 07:02:59',	'2021-10-27 07:02:59',	0,	0,	'172.68.239.211',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(135,	3,	NULL,	'2021-10-28 23:32:17',	'2021-10-28 23:32:17',	0,	0,	'141.101.69.37',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(136,	3,	NULL,	'2021-10-30 06:41:36',	'2021-10-30 06:41:36',	0,	0,	'172.68.238.26',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(137,	3,	NULL,	'2021-10-30 09:21:44',	'2021-10-30 09:21:44',	0,	0,	'172.68.11.17',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(138,	3,	NULL,	'2021-10-31 00:10:38',	'2021-10-31 00:10:38',	0,	0,	'162.158.91.157',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(139,	3,	NULL,	'2021-11-02 13:10:13',	'2021-11-02 13:10:13',	0,	0,	'172.68.10.18',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(140,	3,	NULL,	'2021-11-02 13:10:14',	'2021-11-02 13:10:14',	0,	0,	'172.68.244.46',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(141,	3,	NULL,	'2021-11-04 00:37:44',	'2021-11-04 00:37:44',	0,	0,	'172.68.10.80',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(142,	3,	NULL,	'2021-11-04 03:16:34',	'2021-11-04 03:16:34',	0,	0,	'162.158.238.228',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(143,	3,	NULL,	'2021-11-04 09:11:41',	'2021-11-04 09:11:41',	0,	0,	'141.101.77.59',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(144,	3,	NULL,	'2021-11-07 01:33:51',	'2021-11-07 01:33:51',	0,	0,	'162.158.183.211',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(145,	3,	NULL,	'2021-11-07 11:59:37',	'2021-11-07 11:59:37',	0,	0,	'162.158.102.58',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(146,	3,	NULL,	'2021-11-08 11:16:52',	'2021-11-08 11:16:52',	0,	0,	'172.69.54.111',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(147,	3,	NULL,	'2021-11-08 19:36:46',	'2021-11-08 19:36:46',	0,	0,	'172.68.238.14',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(148,	3,	NULL,	'2021-11-10 10:45:49',	'2021-11-10 10:45:49',	0,	0,	'141.101.77.128',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(149,	3,	NULL,	'2021-11-11 15:15:32',	'2021-11-11 15:15:32',	0,	0,	'141.101.104.131',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.14 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(150,	3,	NULL,	'2021-11-11 18:49:29',	'2021-11-11 18:49:29',	0,	0,	'172.68.10.188',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(151,	3,	NULL,	'2021-11-11 18:49:51',	'2021-11-11 18:49:51',	0,	0,	'172.68.11.91',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(152,	3,	NULL,	'2021-11-12 17:05:07',	'2021-11-12 17:05:07',	0,	0,	'172.68.238.26',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4427.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(153,	3,	NULL,	'2021-11-13 11:41:51',	'2021-11-13 11:41:51',	0,	0,	'172.68.238.68',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4400.8 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(154,	3,	NULL,	'2021-11-14 02:47:02',	'2021-11-14 02:47:02',	0,	0,	'172.70.114.16',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4427.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(155,	3,	NULL,	'2021-11-14 09:52:04',	'2021-11-14 09:52:04',	0,	0,	'172.69.54.237',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(156,	3,	NULL,	'2021-11-18 06:55:03',	'2021-11-18 06:55:03',	0,	0,	'172.68.238.68',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(157,	3,	NULL,	'2021-11-19 01:03:29',	'2021-11-19 01:03:29',	0,	0,	'162.158.90.160',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(158,	3,	NULL,	'2021-11-22 03:03:53',	'2021-11-22 03:03:53',	0,	0,	'141.101.69.113',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(159,	3,	NULL,	'2021-11-22 18:33:02',	'2021-11-22 18:33:02',	0,	0,	'172.68.239.231',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(160,	3,	NULL,	'2021-11-23 00:14:58',	'2021-11-23 00:14:58',	0,	0,	'162.158.91.73',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(161,	3,	NULL,	'2021-11-24 00:43:21',	'2021-11-24 00:43:21',	0,	0,	'162.158.94.136',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(162,	3,	NULL,	'2021-11-25 09:43:46',	'2021-11-25 09:43:46',	0,	0,	'162.158.26.242',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(163,	3,	NULL,	'2021-11-30 04:05:42',	'2021-11-30 04:05:42',	0,	0,	'162.158.91.19',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(164,	3,	NULL,	'2021-12-02 22:43:16',	'2021-12-02 22:43:16',	0,	0,	'162.158.88.210',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(165,	3,	NULL,	'2021-12-03 08:55:05',	'2021-12-03 08:55:05',	0,	0,	'172.68.239.229',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(166,	3,	NULL,	'2021-12-10 05:27:29',	'2021-12-10 05:27:29',	0,	0,	'162.158.91.69',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(167,	3,	NULL,	'2021-12-10 09:21:43',	'2021-12-10 09:21:43',	0,	0,	'162.158.91.69',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(168,	3,	NULL,	'2021-12-11 01:15:48',	'2021-12-11 01:15:48',	0,	0,	'172.70.114.106',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(169,	3,	NULL,	'2021-12-17 07:27:54',	'2021-12-17 07:27:54',	0,	0,	'172.68.245.185',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(170,	3,	NULL,	'2021-12-18 08:51:56',	'2021-12-18 08:51:56',	0,	0,	'172.68.238.72',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(171,	3,	NULL,	'2021-12-22 10:46:49',	'2021-12-22 10:46:49',	0,	0,	'162.158.94.92',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(172,	3,	NULL,	'2021-12-25 02:55:53',	'2021-12-25 02:55:53',	0,	0,	'172.68.10.62',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(173,	3,	NULL,	'2021-12-25 03:48:30',	'2021-12-25 03:48:30',	0,	0,	'172.68.10.174',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(174,	3,	NULL,	'2021-12-25 16:54:55',	'2021-12-25 16:54:55',	0,	0,	'172.70.54.74',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(175,	3,	NULL,	'2021-12-25 21:55:19',	'2021-12-25 21:55:19',	0,	0,	'172.68.10.48',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(176,	3,	NULL,	'2021-12-29 16:54:05',	'2021-12-29 16:54:05',	0,	0,	'162.158.88.24',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.79 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(177,	3,	NULL,	'2021-12-31 06:14:05',	'2021-12-31 06:14:05',	0,	0,	'172.70.178.124',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(178,	3,	NULL,	'2022-01-01 10:16:09',	'2022-01-01 10:16:09',	0,	0,	'162.158.88.128',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(179,	3,	NULL,	'2022-01-06 08:44:09',	'2022-01-06 08:44:09',	0,	0,	'162.158.90.198',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(180,	3,	NULL,	'2022-01-08 14:37:32',	'2022-01-08 14:37:32',	0,	0,	'141.101.105.76',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(181,	3,	NULL,	'2022-01-13 09:37:01',	'2022-01-13 09:37:01',	0,	0,	'141.101.68.134',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(182,	3,	NULL,	'2022-01-15 10:49:24',	'2022-01-15 10:49:24',	0,	0,	'162.158.92.18',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4400.8 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(183,	3,	NULL,	'2022-01-17 19:55:11',	'2022-01-17 19:55:11',	0,	0,	'108.162.229.186',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(184,	3,	NULL,	'2022-01-18 13:08:51',	'2022-01-18 13:08:51',	0,	0,	'198.41.242.170',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(185,	3,	NULL,	'2022-01-18 17:53:43',	'2022-01-18 17:53:43',	0,	0,	'141.101.96.19',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(186,	3,	NULL,	'2022-01-19 13:22:17',	'2022-01-19 13:22:17',	0,	0,	'198.41.242.234',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(187,	3,	NULL,	'2022-01-21 16:39:26',	'2022-01-21 16:39:26',	0,	0,	'141.101.76.240',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(188,	3,	NULL,	'2022-01-25 10:38:12',	'2022-01-25 10:38:12',	0,	0,	'141.101.76.238',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(189,	3,	NULL,	'2022-01-26 01:12:26',	'2022-01-26 01:12:26',	0,	0,	'162.158.238.240',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(190,	3,	NULL,	'2022-01-27 08:56:34',	'2022-01-27 08:56:34',	0,	0,	'162.158.183.161',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(191,	3,	NULL,	'2022-01-28 18:35:58',	'2022-01-28 18:35:58',	0,	0,	'141.101.69.39',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(192,	3,	NULL,	'2022-01-31 03:29:24',	'2022-01-31 03:29:24',	0,	0,	'172.68.11.107',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(193,	3,	NULL,	'2022-01-31 20:18:04',	'2022-01-31 20:18:04',	0,	0,	'162.158.183.111',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(194,	3,	NULL,	'2022-02-01 01:22:46',	'2022-02-01 01:22:46',	0,	0,	'141.101.76.128',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(195,	3,	NULL,	'2022-02-01 17:03:26',	'2022-02-01 17:03:26',	0,	0,	'172.68.226.200',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(196,	3,	NULL,	'2022-02-02 00:28:46',	'2022-02-02 00:28:46',	0,	0,	'172.68.10.36',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(197,	3,	NULL,	'2022-02-02 04:42:47',	'2022-02-02 04:42:47',	0,	0,	'172.68.244.82',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(198,	3,	NULL,	'2022-02-02 13:04:31',	'2022-02-02 13:04:31',	0,	0,	'141.101.76.156',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(199,	3,	NULL,	'2022-02-02 16:12:37',	'2022-02-02 16:12:37',	0,	0,	'172.70.188.56',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(200,	3,	NULL,	'2022-02-02 19:49:01',	'2022-02-02 19:49:01',	0,	0,	'141.101.76.228',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(201,	3,	NULL,	'2022-02-03 02:09:16',	'2022-02-03 02:09:16',	0,	0,	'172.68.244.54',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(202,	3,	NULL,	'2022-02-03 13:26:32',	'2022-02-03 13:26:32',	0,	0,	'141.101.76.228',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(203,	3,	NULL,	'2022-02-05 22:44:36',	'2022-02-05 22:44:36',	0,	0,	'172.68.245.77',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(204,	3,	NULL,	'2022-02-08 16:29:02',	'2022-02-08 16:29:02',	0,	0,	'172.70.110.108',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(205,	3,	NULL,	'2022-02-08 18:25:38',	'2022-02-08 18:25:38',	0,	0,	'172.70.110.166',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(206,	3,	NULL,	'2022-02-08 18:25:41',	'2022-02-08 18:25:41',	0,	0,	'172.70.110.198',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(207,	3,	NULL,	'2022-02-08 21:56:25',	'2022-02-08 21:56:25',	0,	0,	'162.158.103.193',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(208,	3,	NULL,	'2022-02-08 21:56:26',	'2022-02-08 21:56:26',	0,	0,	'162.158.102.116',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(209,	3,	NULL,	'2022-02-08 23:31:17',	'2022-02-08 23:31:17',	0,	0,	'172.68.11.69',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(210,	3,	NULL,	'2022-02-09 17:49:01',	'2022-02-09 17:49:01',	0,	0,	'172.70.85.76',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(211,	3,	NULL,	'2022-02-10 02:51:46',	'2022-02-10 02:51:46',	0,	0,	'172.70.242.130',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(212,	3,	NULL,	'2022-02-10 14:03:50',	'2022-02-10 14:03:50',	0,	0,	'162.158.102.104',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(213,	3,	NULL,	'2022-02-10 15:34:01',	'2022-02-10 15:34:01',	0,	0,	'162.158.103.193',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(214,	3,	NULL,	'2022-02-10 18:14:01',	'2022-02-10 18:14:01',	0,	0,	'162.158.102.104',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(215,	3,	NULL,	'2022-02-12 09:11:47',	'2022-02-12 09:11:47',	0,	0,	'162.158.103.203',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(216,	3,	NULL,	'2022-02-12 09:15:04',	'2022-02-12 09:15:04',	0,	0,	'162.158.102.116',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(217,	3,	NULL,	'2022-02-12 13:56:47',	'2022-02-12 13:56:47',	0,	0,	'162.158.103.203',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(218,	3,	NULL,	'2022-02-13 02:20:41',	'2022-02-13 02:20:41',	0,	0,	'162.158.103.203',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(219,	3,	NULL,	'2022-02-13 02:20:47',	'2022-02-13 02:20:47',	0,	0,	'162.158.103.193',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(220,	3,	NULL,	'2022-02-13 02:21:22',	'2022-02-13 02:21:22',	0,	0,	'162.158.103.193',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(221,	3,	NULL,	'2022-02-13 13:27:34',	'2022-02-13 13:27:34',	0,	0,	'162.158.103.203',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(222,	3,	NULL,	'2022-02-14 21:31:51',	'2022-02-14 21:31:51',	0,	0,	'162.158.75.130',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(223,	3,	NULL,	'2022-02-14 22:12:04',	'2022-02-14 22:12:04',	0,	0,	'172.68.238.46',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(224,	3,	NULL,	'2022-02-15 07:25:48',	'2022-02-15 07:25:48',	0,	0,	'162.158.222.172',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(225,	3,	NULL,	'2022-02-18 05:22:51',	'2022-02-18 05:22:51',	0,	0,	'162.158.103.203',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(226,	3,	NULL,	'2022-02-19 12:59:53',	'2022-02-19 12:59:53',	0,	0,	'172.68.238.144',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(227,	3,	NULL,	'2022-02-19 21:56:54',	'2022-02-19 21:56:54',	0,	0,	'172.70.92.204',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(228,	3,	NULL,	'2022-02-23 16:13:32',	'2022-02-23 16:13:32',	0,	0,	'172.70.242.130',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(229,	3,	NULL,	'2022-02-24 02:08:40',	'2022-02-24 02:08:40',	0,	0,	'172.70.110.240',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(230,	3,	NULL,	'2022-02-25 11:31:19',	'2022-02-25 11:31:19',	0,	0,	'172.68.11.11',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(231,	3,	NULL,	'2022-02-27 22:56:45',	'2022-02-27 22:56:45',	0,	0,	'141.101.77.185',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(232,	3,	NULL,	'2022-02-28 13:42:07',	'2022-02-28 13:42:07',	0,	0,	'172.68.10.170',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(233,	3,	NULL,	'2022-03-02 03:29:03',	'2022-03-02 03:29:03',	0,	0,	'172.68.183.59',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(234,	3,	NULL,	'2022-03-02 08:05:46',	'2022-03-02 08:05:46',	0,	0,	'172.68.183.59',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(235,	3,	NULL,	'2022-03-03 16:19:53',	'2022-03-03 16:19:53',	0,	0,	'162.158.183.169',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(236,	3,	NULL,	'2022-03-03 22:05:20',	'2022-03-03 22:05:20',	0,	0,	'162.158.222.152',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(237,	3,	NULL,	'2022-03-04 00:10:34',	'2022-03-04 00:10:34',	0,	0,	'162.158.222.172',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(238,	3,	NULL,	'2022-03-04 12:10:24',	'2022-03-04 12:10:24',	0,	0,	'162.158.222.152',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(239,	3,	NULL,	'2022-03-04 15:04:08',	'2022-03-04 15:04:08',	0,	0,	'172.70.242.112',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(240,	3,	NULL,	'2022-03-06 00:00:34',	'2022-03-06 00:00:34',	0,	0,	'172.68.246.198',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(241,	3,	NULL,	'2022-03-08 12:19:39',	'2022-03-08 12:19:39',	0,	0,	'162.158.222.152',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(242,	3,	NULL,	'2022-03-08 12:20:26',	'2022-03-08 12:20:26',	0,	0,	'162.158.222.172',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.86 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(243,	3,	NULL,	'2022-03-09 17:19:04',	'2022-03-09 17:19:04',	0,	0,	'172.68.244.176',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(244,	3,	NULL,	'2022-03-15 02:01:50',	'2022-03-15 02:01:50',	0,	0,	'162.158.134.44',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(245,	3,	NULL,	'2022-03-16 12:57:03',	'2022-03-16 12:57:03',	0,	0,	'172.68.238.44',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(246,	3,	NULL,	'2022-03-19 04:43:48',	'2022-03-19 04:43:48',	0,	0,	'162.158.222.174',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(247,	3,	NULL,	'2022-03-22 09:27:54',	'2022-03-22 09:27:54',	0,	0,	'172.70.250.60',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(248,	3,	NULL,	'2022-03-24 17:53:35',	'2022-03-24 17:53:35',	0,	0,	'162.158.203.39',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(249,	3,	NULL,	'2022-03-25 21:23:29',	'2022-03-25 21:23:29',	0,	0,	'172.69.34.77',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(250,	3,	NULL,	'2022-03-27 02:01:17',	'2022-03-27 02:01:17',	0,	0,	'172.68.50.120',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(251,	3,	NULL,	'2022-03-27 07:50:12',	'2022-03-27 07:50:12',	0,	0,	'172.70.110.102',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(252,	3,	NULL,	'2022-03-30 15:52:04',	'2022-03-30 15:52:04',	0,	0,	'172.70.114.224',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(253,	3,	NULL,	'2022-04-05 20:26:46',	'2022-04-05 20:26:46',	0,	0,	'172.70.242.174',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(254,	3,	NULL,	'2022-04-06 19:49:18',	'2022-04-06 19:49:18',	0,	0,	'172.70.242.210',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.86 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(255,	3,	NULL,	'2022-04-08 13:08:01',	'2022-04-08 13:08:01',	0,	0,	'141.101.77.116',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(256,	3,	NULL,	'2022-04-10 10:49:37',	'2022-04-10 10:49:37',	0,	0,	'172.68.50.44',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(257,	3,	NULL,	'2022-04-11 08:02:16',	'2022-04-11 08:02:16',	0,	0,	'172.68.238.44',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(258,	3,	NULL,	'2022-04-11 18:34:25',	'2022-04-11 18:34:25',	0,	0,	'198.41.242.170',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.86 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(259,	3,	NULL,	'2022-04-11 20:19:52',	'2022-04-11 20:19:52',	0,	0,	'141.101.76.14',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(260,	3,	NULL,	'2022-04-13 07:52:18',	'2022-04-13 07:52:18',	0,	0,	'172.68.10.30',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.39',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(261,	3,	NULL,	'2022-04-15 22:17:04',	'2022-04-15 22:17:04',	0,	0,	'162.158.222.138',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(262,	3,	NULL,	'2022-04-16 00:56:12',	'2022-04-16 00:56:12',	0,	0,	'162.158.126.118',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(263,	3,	NULL,	'2022-04-16 13:37:53',	'2022-04-16 13:37:53',	0,	0,	'141.101.77.254',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(264,	3,	NULL,	'2022-04-18 04:12:48',	'2022-04-18 04:12:48',	0,	0,	'141.101.68.90',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(265,	3,	NULL,	'2022-04-19 04:13:49',	'2022-04-19 04:13:49',	0,	0,	'172.68.50.88',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(266,	3,	NULL,	'2022-04-19 21:00:30',	'2022-04-19 21:00:30',	0,	0,	'172.70.211.93',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4427.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(267,	3,	NULL,	'2022-04-20 14:07:53',	'2022-04-20 14:07:53',	0,	0,	'172.70.85.190',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4400.8 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(268,	3,	NULL,	'2022-04-20 22:24:08',	'2022-04-20 22:24:08',	0,	0,	'141.101.68.84',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.86 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(269,	3,	NULL,	'2022-04-21 12:09:57',	'2022-04-21 12:09:57',	0,	0,	'162.158.163.29',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(270,	3,	NULL,	'2022-04-21 15:33:36',	'2022-04-21 15:33:36',	0,	0,	'172.68.238.136',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(271,	3,	NULL,	'2022-04-22 09:18:20',	'2022-04-22 09:18:20',	0,	0,	'162.158.203.39',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(272,	3,	NULL,	'2022-04-25 08:46:21',	'2022-04-25 08:46:21',	0,	0,	'141.101.98.224',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(273,	3,	NULL,	'2022-04-26 06:07:07',	'2022-04-26 06:07:07',	0,	0,	'162.158.222.180',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(274,	3,	NULL,	'2022-04-27 00:22:37',	'2022-04-27 00:22:37',	0,	0,	'141.101.105.184',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.39',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(275,	3,	NULL,	'2022-04-27 01:11:47',	'2022-04-27 01:11:47',	0,	0,	'172.68.238.136',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(276,	3,	NULL,	'2022-04-30 09:17:10',	'2022-04-30 09:17:10',	0,	0,	'172.68.10.108',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(277,	3,	NULL,	'2022-05-01 01:08:13',	'2022-05-01 01:08:13',	0,	0,	'172.70.180.140',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(278,	3,	NULL,	'2022-05-01 06:11:29',	'2022-05-01 06:11:29',	0,	0,	'172.68.238.46',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.39',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(279,	3,	NULL,	'2022-05-01 22:47:41',	'2022-05-01 22:47:41',	0,	0,	'172.68.238.16',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(280,	3,	NULL,	'2022-05-03 01:18:45',	'2022-05-03 01:18:45',	0,	0,	'172.68.238.46',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(281,	3,	NULL,	'2022-05-03 01:24:19',	'2022-05-03 01:24:19',	0,	0,	'141.101.76.32',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(282,	3,	NULL,	'2022-05-03 23:05:52',	'2022-05-03 23:05:52',	0,	0,	'172.70.86.73',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(283,	3,	NULL,	'2022-05-04 03:21:41',	'2022-05-04 03:21:41',	0,	0,	'172.70.110.170',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(284,	3,	NULL,	'2022-05-05 02:06:41',	'2022-05-05 02:06:41',	0,	0,	'108.162.219.180',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(285,	3,	NULL,	'2022-05-05 20:34:26',	'2022-05-05 20:34:26',	0,	0,	'172.70.242.174',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(286,	3,	NULL,	'2022-05-06 10:08:28',	'2022-05-06 10:08:28',	0,	0,	'162.158.90.216',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(287,	3,	NULL,	'2022-05-09 13:21:34',	'2022-05-09 13:21:34',	0,	0,	'141.101.76.32',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(288,	3,	NULL,	'2022-05-10 17:35:54',	'2022-05-10 17:35:54',	0,	0,	'141.101.104.91',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.86 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(289,	3,	NULL,	'2022-05-11 08:44:15',	'2022-05-11 08:44:15',	0,	0,	'172.70.250.60',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(290,	3,	NULL,	'2022-05-13 07:44:41',	'2022-05-13 07:44:41',	0,	0,	'141.101.77.62',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(291,	3,	NULL,	'2022-05-15 11:12:07',	'2022-05-15 11:12:07',	0,	0,	'172.68.238.8',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(292,	3,	NULL,	'2022-05-16 11:00:38',	'2022-05-16 11:00:38',	0,	0,	'162.158.62.184',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(293,	3,	NULL,	'2022-05-16 13:41:42',	'2022-05-16 13:41:42',	0,	0,	'141.101.104.89',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.39',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(294,	3,	NULL,	'2022-05-17 10:34:44',	'2022-05-17 10:34:44',	0,	0,	'172.70.251.129',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(295,	3,	NULL,	'2022-05-19 12:30:29',	'2022-05-19 12:30:29',	0,	0,	'162.158.222.166',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(296,	3,	NULL,	'2022-05-20 00:22:49',	'2022-05-20 00:22:49',	0,	0,	'162.158.222.166',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(297,	3,	NULL,	'2022-05-21 04:38:07',	'2022-05-21 04:38:07',	0,	0,	'162.158.134.18',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(298,	3,	NULL,	'2022-05-22 12:40:18',	'2022-05-22 12:40:18',	0,	0,	'172.68.11.169',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(299,	3,	NULL,	'2022-05-25 03:03:34',	'2022-05-25 03:03:34',	0,	0,	'172.70.114.108',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(300,	3,	NULL,	'2022-05-26 10:34:06',	'2022-05-26 10:34:06',	0,	0,	'162.158.62.184',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(301,	3,	NULL,	'2022-05-27 12:27:49',	'2022-05-27 12:27:49',	0,	0,	'141.101.77.242',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(302,	3,	NULL,	'2022-05-27 15:29:15',	'2022-05-27 15:29:15',	0,	0,	'172.68.11.33',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(303,	3,	NULL,	'2022-05-27 19:16:43',	'2022-05-27 19:16:43',	0,	0,	'172.68.238.46',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(304,	3,	NULL,	'2022-05-28 05:06:46',	'2022-05-28 05:06:46',	0,	0,	'141.101.68.150',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(305,	3,	NULL,	'2022-05-28 21:48:19',	'2022-05-28 21:48:19',	0,	0,	'141.101.76.32',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(306,	3,	NULL,	'2022-05-29 17:42:32',	'2022-05-29 17:42:32',	0,	0,	'198.41.242.122',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(307,	3,	NULL,	'2022-05-30 06:08:29',	'2022-05-30 06:08:29',	0,	0,	'172.68.11.17',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(308,	3,	NULL,	'2022-05-30 08:32:12',	'2022-05-30 08:32:12',	0,	0,	'141.101.76.226',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(309,	3,	NULL,	'2022-05-31 02:09:31',	'2022-05-31 02:09:31',	0,	0,	'188.114.102.34',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(310,	3,	NULL,	'2022-06-01 06:13:40',	'2022-06-01 06:13:40',	0,	0,	'141.101.105.145',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(311,	3,	NULL,	'2022-06-01 22:01:13',	'2022-06-01 22:01:13',	0,	0,	'172.68.238.70',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4427.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(312,	3,	NULL,	'2022-06-02 01:15:52',	'2022-06-02 01:15:52',	0,	0,	'172.70.114.108',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(313,	3,	NULL,	'2022-06-02 04:22:50',	'2022-06-02 04:22:50',	0,	0,	'172.69.33.152',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4427.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(314,	3,	NULL,	'2022-06-09 18:46:45',	'2022-06-09 18:46:45',	0,	0,	'141.101.76.76',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/102.0.5005.63 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(315,	3,	NULL,	'2022-06-15 22:07:22',	'2022-06-15 22:07:22',	0,	0,	'172.69.70.236',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/102.0.0.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(316,	3,	NULL,	'2022-06-16 17:50:58',	'2022-06-16 17:50:58',	0,	0,	'162.158.48.134',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/102.0.0.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(317,	3,	NULL,	'2022-06-16 17:55:47',	'2022-06-16 17:55:47',	0,	0,	'162.158.48.134',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/102.0.0.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(318,	3,	NULL,	'2022-08-10 18:15:44',	'2022-08-10 18:15:44',	0,	0,	'172.71.94.202',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(319,	3,	NULL,	'2022-11-01 11:47:12',	'2022-11-01 11:47:12',	0,	0,	'172.70.147.117',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(320,	3,	NULL,	'2023-04-13 16:27:52',	'2023-04-13 16:27:52',	0,	0,	'172.70.142.213',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(321,	3,	NULL,	'2023-06-14 15:19:18',	'2023-06-14 15:19:18',	0,	0,	'172.70.214.155',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(322,	3,	NULL,	'2023-06-23 21:51:12',	'2023-06-23 21:51:12',	0,	0,	'162.158.179.62',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(323,	3,	NULL,	'2023-06-30 15:47:00',	'2023-06-30 15:47:00',	0,	0,	'172.71.214.226',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(324,	3,	NULL,	'2023-06-30 16:12:52',	'2023-06-30 16:12:52',	0,	0,	'172.71.214.58',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(325,	3,	NULL,	'2023-07-10 20:47:15',	'2023-07-10 20:47:15',	0,	0,	'172.71.210.202',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active'),
(326,	3,	NULL,	'2023-08-03 19:45:53',	'2023-08-03 19:45:53',	0,	0,	'162.158.162.70',	'https://graygroupla.com/contact/',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/115.0.0.0 Safari/537.36',	'USD',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'active');

DROP TABLE IF EXISTS `wp_gf_entry_meta`;
CREATE TABLE `wp_gf_entry_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `entry_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  `item_index` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `entry_id` (`entry_id`),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_gf_entry_meta` (`id`, `form_id`, `entry_id`, `meta_key`, `meta_value`, `item_index`) VALUES
(1,	3,	1,	'7',	'Jameseduck',	''),
(2,	3,	1,	'8',	'no-replyGigmani@gmail.com',	''),
(3,	3,	1,	'4',	'(882) 354-4040',	''),
(4,	3,	1,	'6',	'Getting some information',	''),
(5,	3,	1,	'5',	'Gооd dаy!  graygroupla.com \r\n \r\nDid yоu knоw thаt it is pоssiblе tо sеnd соmmеrсiаl оffеr tоtаlly lеgitimаtе wаy? \r\nWе prоviding а nеw wаy оf sеnding rеquеst thrоugh соntасt fоrms. Suсh fоrms аrе lосаtеd оn mаny sitеs. \r\nWhеn suсh prоpоsаls аrе sеnt, nо pеrsоnаl dаtа is usеd, аnd mеssаgеs аrе sеnt tо fоrms spесifiсаlly dеsignеd tо rесеivе mеssаgеs аnd аppеаls. \r\nаlsо, mеssаgеs sеnt thrоugh соntасt Fоrms dо nоt gеt intо spаm bесаusе suсh mеssаgеs аrе соnsidеrеd impоrtаnt. \r\nWе оffеr yоu tо tеst о',	''),
(6,	3,	2,	'7',	'ContactFum',	''),
(7,	3,	2,	'8',	'no-replyGigmani@gmail.com',	''),
(8,	3,	2,	'4',	'(472) 863-1618',	''),
(9,	3,	2,	'6',	'Getting some information',	''),
(10,	3,	2,	'5',	'Gооd dаy!  graygroupla.com \r\n \r\nDid yоu knоw thаt it is pоssiblе tо sеnd rеquеst uttеrly lеgаl? \r\nWе prоffеr а nеw uniquе wаy оf sеnding lеttеr thrоugh соntасt fоrms. Suсh fоrms аrе lосаtеd оn mаny sitеs. \r\nWhеn suсh businеss оffеrs аrе sеnt, nо pеrsоnаl dаtа is usеd, аnd mеssаgеs аrе sеnt tо fоrms spесifiсаlly dеsignеd tо rесеivе mеssаgеs аnd аppеаls. \r\nаlsо, mеssаgеs sеnt thrоugh соmmuniсаtiоn Fоrms dо nоt gеt intо spаm bесаusе suсh mеssаgеs аrе соnsidеrеd impоrtаnt. \r\nWе оffеr yоu tо tеst оur',	''),
(11,	2,	3,	'1',	'Chris Gray',	''),
(12,	2,	3,	'2',	'chris@graygrouprealty.com',	''),
(13,	2,	3,	'10',	'Immediately',	''),
(14,	2,	3,	'3',	'1115 N Harper Ave, West Hollywood, CA 90046, USA',	''),
(15,	2,	3,	'5',	'1115 North Harper Avenue',	''),
(16,	2,	3,	'6',	'West Hollywood',	''),
(17,	2,	3,	'7',	'CA',	''),
(18,	2,	3,	'8',	'90046',	''),
(19,	2,	4,	'1',	'Christopher S Gray',	''),
(20,	2,	4,	'2',	'chrissg55@gmail.com',	''),
(21,	2,	4,	'10',	'Immediately',	''),
(22,	2,	4,	'3',	'6746 Wedgewood Pl, Los Angeles, CA 90068, USA',	''),
(23,	2,	4,	'5',	'6746 Wedgewood Place',	''),
(24,	2,	4,	'6',	'Los Angeles',	''),
(25,	2,	4,	'7',	'CA',	''),
(26,	2,	4,	'8',	'90068',	''),
(27,	2,	4,	'4',	'1,978,700',	''),
(28,	2,	3,	'12',	'12/04/2020',	NULL),
(29,	2,	4,	'12',	'12/04/2020',	NULL),
(30,	3,	5,	'7',	'chris',	''),
(31,	3,	5,	'8',	'chrissg55@gmail.com',	''),
(32,	3,	5,	'4',	'(323) 612-7086',	''),
(33,	3,	5,	'6',	'Buying a home',	''),
(34,	3,	5,	'5',	'test',	''),
(35,	3,	6,	'7',	'Fbsbranny',	''),
(36,	3,	6,	'8',	'wilwaf2yhw2gphi@gmail.com',	''),
(37,	3,	6,	'4',	'(275) 834-4788',	''),
(38,	3,	6,	'6',	'Getting some information',	''),
(39,	3,	6,	'5',	'free cialis no prescription <a href=\"https://cialmenon.com/#\">cialis with dapoxetine</a> cheap cialis online generic',	''),
(40,	3,	7,	'7',	'chris',	''),
(41,	3,	7,	'8',	'chrissg55@gmail.com',	''),
(42,	3,	7,	'4',	'(232) 612-7086',	''),
(43,	3,	7,	'6',	'Buying a home',	''),
(44,	3,	7,	'5',	'test',	''),
(45,	3,	8,	'7',	'Graham Wetterhahn',	''),
(46,	3,	8,	'8',	'gswetterhahn@gmail.com',	''),
(47,	3,	8,	'4',	'(818) 267-7621',	''),
(48,	3,	8,	'6',	'Buying a home',	''),
(49,	3,	8,	'5',	'Hi Chris,\r\n\r\nI sent a message to you through the Beverly & Co. website regarding the Wedgewood property late last night/early this morning.  I figured I\'d send one here through your website as well.  \r\n\r\nVery interested in the property, we drove through the neighborhood last night.  Would love to schedule a walkthrough or a call to discuss.  If we like the house we would most likely be a cash offer and are not represented by an agent so you could act as both buyer and seller.\r\n\r\nThanks!\r\nGraham',	''),
(50,	3,	9,	'7',	'DonaldMug',	''),
(51,	3,	9,	'8',	'no-replyGigmani@gmail.com',	''),
(52,	3,	9,	'4',	'(744) 003-3880',	''),
(53,	3,	9,	'6',	'Getting some information',	''),
(54,	3,	9,	'5',	'Hi!  graygroupla.com \r\n \r\nDid you know that it is possible to send request utterly legitimate way? \r\nWe make available a new legal way of sending letter through contact forms. Such forms are located on many sites. \r\nWhen such proposals are sent, no personal data is used, and messages are sent to forms specifically designed to receive messages and appeals. \r\nalso, messages sent through communication Forms do not get into spam because such messages are considered important. \r\nWe offer you to test',	''),
(55,	2,	10,	'1',	'Chris Gray',	''),
(56,	2,	10,	'2',	'chrissg55@gmail.com',	''),
(57,	2,	10,	'10',	'Immediately',	''),
(58,	2,	10,	'3',	'1253 Beverly Green Dr, Beverly Hills, CA 90212, USA',	''),
(59,	2,	10,	'5',	'1253 Beverly Green Drive',	''),
(60,	2,	10,	'6',	'Beverly Hills',	''),
(61,	2,	10,	'7',	'CA',	''),
(62,	2,	10,	'8',	'90212',	''),
(63,	2,	10,	'4',	'0',	''),
(64,	2,	11,	'1',	'chris',	''),
(65,	2,	11,	'2',	'chrissg55@gmail.com',	''),
(66,	2,	11,	'10',	'Immediately',	''),
(67,	2,	11,	'3',	'236 N Rodeo Dr, Beverly Hills, CA 90210, USA',	''),
(68,	2,	11,	'5',	'236 North Rodeo Drive',	''),
(69,	2,	11,	'6',	'Beverly Hills',	''),
(70,	2,	11,	'7',	'CA',	''),
(71,	2,	11,	'8',	'90210',	''),
(72,	2,	11,	'4',	'0',	''),
(73,	2,	10,	'12',	'03/19/2021',	NULL),
(74,	2,	11,	'12',	'03/19/2021',	NULL),
(75,	2,	12,	'1',	'chris gray',	''),
(76,	2,	12,	'2',	'chrissg55@gmail.com',	''),
(77,	2,	12,	'10',	'Immediately',	''),
(78,	2,	12,	'3',	'225 N Canon Dr, Beverly Hills, CA 90210, USA',	''),
(79,	2,	12,	'5',	'225 North Canon Drive',	''),
(80,	2,	12,	'6',	'Beverly Hills',	''),
(81,	2,	12,	'7',	'CA',	''),
(82,	2,	12,	'8',	'90210',	''),
(83,	2,	12,	'4',	'0',	''),
(84,	2,	13,	'1',	'Christopher S Gray',	''),
(85,	2,	13,	'2',	'chrissg55@gmail.com',	''),
(86,	2,	13,	'10',	'Immediately',	''),
(87,	2,	13,	'3',	'472 S Spalding Dr, Beverly Hills, CA 90212, USA',	''),
(88,	2,	13,	'5',	'472 South Spalding Drive',	''),
(89,	2,	13,	'6',	'Beverly Hills',	''),
(90,	2,	13,	'7',	'CA',	''),
(91,	2,	13,	'8',	'90212',	''),
(92,	2,	13,	'4',	'0',	''),
(93,	2,	12,	'12',	'03/21/2021',	NULL),
(94,	2,	13,	'12',	'03/21/2021',	NULL),
(95,	3,	14,	'7',	'Stefan Gray',	''),
(96,	3,	14,	'8',	'stefan_gray@westcoastfilmpartners.com',	''),
(97,	3,	14,	'4',	'(310) 403-6367',	''),
(98,	3,	14,	'6',	'Buying a home',	''),
(99,	3,	14,	'5',	'How do I set up another Gmail account ? Everything I do goes to the roxburyfilms1@gmail.com account',	''),
(100,	3,	15,	'7',	'Michael Cho',	''),
(101,	3,	15,	'8',	'mcho@cnccre.com',	''),
(102,	3,	15,	'4',	'(310) 415-9196',	''),
(103,	3,	15,	'6',	'Buying a home',	''),
(104,	3,	15,	'5',	'Hello, \r\nI have a client interested in seeing 277 S Spalding Dr #401,\r\nBeverly Hills, CA 90212. Can we schedule the showing on Thursday at 3pm? Thank you',	''),
(105,	3,	16,	'7',	'JamesSnund',	''),
(106,	3,	16,	'8',	'no-replyGigmani@gmail.com',	''),
(107,	3,	16,	'4',	'(801) 404-5820',	''),
(108,	3,	16,	'6',	'Getting some information',	''),
(109,	3,	16,	'5',	'Hello!  graygroupla.com \r\n \r\nDo you know the best way to talk about your merchandise or services? Sending messages using contact forms can permit you to simply enter the markets of any country (full geographical coverage for all countries of the world).  The advantage of such a mailing  is that the emails that will be sent through it will find yourself in the mailbox that is intended for such messages. Sending messages using Feedback forms is not blocked by mail systems, which implies it\'s sure',	''),
(110,	3,	17,	'7',	'AmyDef',	''),
(111,	3,	17,	'8',	'amyDef@allsets.xyz',	''),
(112,	3,	17,	'4',	'(656) 526-3841',	''),
(113,	3,	17,	'6',	'Investing in a property',	''),
(114,	3,	17,	'5',	'Go ahead, have sex on the first date\r\nhttp://amtemci.ml/chk/59',	''),
(115,	3,	18,	'7',	'JamesSnund',	''),
(116,	3,	18,	'8',	'no-replyGigmani@gmail.com',	''),
(117,	3,	18,	'4',	'(835) 043-3788',	''),
(118,	3,	18,	'6',	'Getting some information',	''),
(119,	3,	18,	'5',	'Good day!  graygroupla.com \r\n \r\nDo you know the easiest way to mention your merchandise or services? Sending messages exploitation contact forms will enable you to easily enter the markets of any country (full geographical coverage for all countries of the world).  The advantage of such a mailing  is that the emails that may be sent through it\'ll find yourself within the mailbox that\'s meant for such messages. Sending messages using Feedback forms is not blocked by mail systems, which suggests i',	''),
(120,	3,	19,	'7',	'Suzie Wilson',	''),
(121,	3,	19,	'8',	'suzie.wilson@Happierhome.net',	''),
(122,	3,	19,	'4',	'(415) 201-0397',	''),
(123,	3,	19,	'6',	'Getting some information',	''),
(124,	3,	19,	'5',	'Hello!\r\n\r\nI know many budding entrepreneurs who are starting businesses from their homes. Along the way, they’ve found that the space in their current home simply isn’t suitable for both living and running a business.\r\n\r\nI’d love the opportunity to write about how entrepreneurs can get a custom-built home or find a new home that\'s more suitable for both living and working. \r\n\r\nI’ll ensure that the article provides useful tips and promotes your site and services.\r\n\r\nWhat do you think? Is this something t',	''),
(125,	3,	20,	'7',	'Andrewagist',	''),
(126,	3,	20,	'8',	'goldenkovpasha@gmail.com',	''),
(127,	3,	20,	'4',	'(368) 508-2260',	''),
(128,	3,	20,	'6',	'Getting some information',	''),
(129,	3,	20,	'5',	'Лицензионное интернет-казино Azino 777 за незначительное время заняло лидирующую позицию в Рунете. На портале возможно круглосуточно играть в Азино777 на реальные деньги. \r\n<a href=https://svyatoshinruo.kiev.ua/>нелегальныеденьги\r\n</a>',	''),
(130,	3,	21,	'7',	'Donaldwue',	''),
(131,	3,	21,	'8',	'us.e.r.zale.vski.j.a2.22.01@gmail.com',	''),
(132,	3,	21,	'4',	'(586) 851-5436',	''),
(133,	3,	21,	'6',	'Investing in a property',	''),
(134,	3,	21,	'5',	'Доброго времени суток друзья \r\nWhere is admin? \r\nIt is about advertisement on your website. \r\nRegards. \r\n<a href=https://burtehservice.by/>плиткорез энкор 600</a>',	''),
(135,	3,	22,	'7',	'Scottket',	''),
(136,	3,	22,	'8',	'protribasvets1964@dizaer.ru',	''),
(137,	3,	22,	'4',	'(040) 875-8142',	''),
(138,	3,	22,	'6',	'Investing in a property',	''),
(139,	3,	22,	'5',	'https://classes.wiki/all-russian/russian-dictionary-Vasmer-term-11856.htm',	''),
(140,	3,	23,	'7',	'Bradleyjag',	''),
(141,	3,	23,	'8',	'monthliplery1957@dizaer.ru',	''),
(142,	3,	23,	'4',	'(048) 801-1386',	''),
(143,	3,	23,	'6',	'Getting some information',	''),
(144,	3,	23,	'5',	'https://classes.wiki/all-czech/dictionary-czech-russian-bigczru-term-1595.htm',	''),
(145,	3,	24,	'7',	'SlotoKing',	''),
(146,	3,	24,	'8',	'slotoking.casino777@gmail.com',	''),
(147,	3,	24,	'4',	'(050) 638-4315',	''),
(148,	3,	24,	'6',	'Getting some information',	''),
(149,	3,	24,	'5',	'SlotoKing Casino <a href=https://slotoking-casino.cyou/>СлотоКинг Казино</a> официальный сайт играть онлайн',	''),
(150,	3,	25,	'7',	'WilliamLig',	''),
(151,	3,	25,	'8',	'bridevliters1952@dizaer.ru',	''),
(152,	3,	25,	'4',	'(332) 847-6724',	''),
(153,	3,	25,	'6',	'Investing in a property',	''),
(154,	3,	25,	'5',	'https://classes.wiki/all-swedish/dictionary-russian-swedish-term-23047.htm',	''),
(155,	3,	26,	'7',	'Charlesisoro',	''),
(156,	3,	26,	'8',	'darsusubmoi1976@dizaer.ru',	''),
(157,	3,	26,	'4',	'(340) 346-8405',	''),
(158,	3,	26,	'6',	'Investing in a property',	''),
(159,	3,	26,	'5',	'https://classes.wiki/all-czech/dictionary-czech-russian-bigczru-term-47530.htm',	''),
(160,	3,	27,	'7',	'Chaspeek',	''),
(161,	3,	27,	'8',	'asikarka@yandex.ru',	''),
(162,	3,	27,	'4',	'(742) 633-5011',	''),
(163,	3,	27,	'6',	'Investing in a property',	''),
(164,	3,	27,	'5',	'<a href=https://proxyspace.seo-hunter.com/mobile-proxies/borovsk/>обновляеме прокси</a>',	''),
(165,	3,	28,	'7',	'GeorgeSnuff',	''),
(166,	3,	28,	'8',	'derfclunosad1988@dizaer.ru',	''),
(167,	3,	28,	'4',	'(286) 337-1670',	''),
(168,	3,	28,	'6',	'Investing in a property',	''),
(169,	3,	28,	'5',	'https://kinogoo.cc/35842-poslednij-bogatyr-koren-zla-2020-smotret-online-na-kinogo.html',	''),
(170,	3,	29,	'7',	'Kevinguh',	''),
(171,	3,	29,	'8',	'perwhiviva1957@dizaer.ru',	''),
(172,	3,	29,	'4',	'(627) 262-5452',	''),
(173,	3,	29,	'6',	'Getting some information',	''),
(174,	3,	29,	'5',	'https://kinogoo.by/9292-pravda-v-igre-2017.html',	''),
(175,	3,	30,	'7',	'KennethUtend',	''),
(176,	3,	30,	'8',	'grigorevmadiyar4664@yandex.ru',	''),
(177,	3,	30,	'4',	'(046) 125-6041',	''),
(178,	3,	30,	'6',	'Getting some information',	''),
(179,	3,	30,	'5',	'This is a unique place for fashionable women\'s clothing and accessories. \r\nWe offer our clients women\'s clothing, jewelry, cosmetics and health products, shoes, bags and much more. \r\nhttps://fas.st/Ujfha',	''),
(180,	3,	31,	'7',	'Rogersaw',	''),
(181,	3,	31,	'8',	't.r.o.p.l.o.v.a.e.k.a.t.e.rina@gmail.com',	''),
(182,	3,	31,	'4',	'(182) 528-4652',	''),
(183,	3,	31,	'6',	'Investing in a property',	''),
(184,	3,	31,	'5',	'electronic pill reminder  <a href=  > https://www.huidpunt.nl/stilfr.html </a>  miami drug rehab  <a href= https://dropshipping-test.vidaxl.com/tramfr.html > dropshipping-test.vidaxl.com/tramfr.html </a>  home remedy gastritis',	''),
(185,	3,	32,	'7',	'SlotoKing',	''),
(186,	3,	32,	'8',	'slotoking.casino777@gmail.com',	''),
(187,	3,	32,	'4',	'(056) 361-1054',	''),
(188,	3,	32,	'6',	'Getting some information',	''),
(189,	3,	32,	'5',	'SlotoKing Casino <a href=https://slotoking-casino.cyou/>СлотоКинг Казино</a> официальный сайт играть онлайн',	''),
(190,	3,	33,	'7',	'KennethUtend',	''),
(191,	3,	33,	'8',	'naummarkin5154@yandex.ru',	''),
(192,	3,	33,	'4',	'(484) 724-5572',	''),
(193,	3,	33,	'6',	'Investing in a property',	''),
(194,	3,	33,	'5',	'This is a unique place for fashionable women\'s clothing and accessories. \r\nWe offer our clients women\'s clothing, jewelry, cosmetics and health products, shoes, bags and much more. \r\nhttps://fas.st/Ujfha',	''),
(195,	3,	34,	'7',	'Kvvilleneda',	''),
(196,	3,	34,	'8',	'revers@o5o5.ru',	''),
(197,	3,	34,	'4',	'(422) 270-0245',	''),
(198,	3,	34,	'6',	'Getting some information',	''),
(199,	3,	34,	'5',	'<a href=https://chimmed.ru/products/triisopropylsilyl-trifluoromethanesulfonate-97-id=307349>Триизопропилсилилтрифторметансульфонат 97 процентов купить онлайн Интернет магазин ХИММЕД</a> \r\nTegs: Триизопропилсилан 98 процентов купить онлайн Интернет магазин ХИММЕД https://chimmed.ru/products/triisopropylsilane-98-id=302231 \r\n \r\n<u>Кунжутовое масло купить онлайн Интернет магазин ХИММЕД</u> \r\n<i>Кумол 99 9 процентов купить онлайн Интернет магазин ХИММЕД</i> \r\n<b>Кумол 99 процентов купить онлайн Инт',	''),
(200,	3,	35,	'7',	'RonaldTraix',	''),
(201,	3,	35,	'8',	'support@well-web.net',	''),
(202,	3,	35,	'4',	'(688) 815-7807',	''),
(203,	3,	35,	'6',	'Getting some information',	''),
(204,	3,	35,	'5',	'<a href=https://well-web.net/>Виртуальный хостинг</a> \r\n<a href=\"https://well-web.net/\">Виртуальный хостинг</a>',	''),
(205,	3,	36,	'7',	'LolaFap',	''),
(206,	3,	36,	'8',	'8.ujkmnhdywhnmjkdrs.a.k.djwrj.djwwj@gmail.com',	''),
(207,	3,	36,	'4',	'(783) 660-5682',	''),
(208,	3,	36,	'6',	'Getting some information',	''),
(209,	3,	36,	'5',	'<img src=\"https://i.imgur.com/UPHjGxV.png\"> \r\nGood day! Looking for a sponsor. My profile on the search site: \r\nhttps://datingforkings.club/ My Name: Alisa Lozavarova',	''),
(210,	3,	37,	'7',	'Andreiifm',	''),
(211,	3,	37,	'8',	'u.s.e.rz.a.l.ev.s.k.i.j.a2.2201@gmail.com',	''),
(212,	3,	37,	'4',	'(335) 102-1167',	''),
(213,	3,	37,	'6',	'Investing in a property',	''),
(214,	3,	37,	'5',	'Правильное бурение скважин на водуБурение скважин на воду — довольно сложный процесс, он может производиться различными способами. Но основные этапы бурения одинаковы. Так, в первую очередь, бурильная установка, оборудованная определенным типом бура, разрушает породу, затем происходит изъятие раздробленных фракций, и на завершающем этапе стенки скважины укрепляются обсадными трубами.Применение различных технологий бурения в основном обусловлено структурой грунта и глубиной залегания водоносного',	''),
(215,	3,	38,	'7',	'GoXBet',	''),
(216,	3,	38,	'8',	'goxbetcasino@gmail.com',	''),
(217,	3,	38,	'4',	'(465) 753-7002',	''),
(218,	3,	38,	'6',	'Investing in a property',	''),
(219,	3,	38,	'5',	'Игровые автоматы на офоциальном сайте от <a href=https://goxbet-casino.cyou/>Гоу Икс Бет казино</a> , только проверенные слоты от именитых провайдеров!',	''),
(220,	3,	39,	'7',	'LorenzoUsaps',	''),
(221,	3,	39,	'8',	'tvbox@twinklyshop.xyz',	''),
(222,	3,	39,	'4',	'(574) 538-7453',	''),
(223,	3,	39,	'6',	'Getting some information',	''),
(224,	3,	39,	'5',	'Masking СЌР»РµРєС‚СЂРѕРЅРЅР°СЏ СЃРёРіР°СЂРµС‚Р° РѕРґРЅРѕСЂР°Р·РѕРІР°СЏ РєСѓРїРёС‚СЊ РІ РљСЂР°СЃРЅРѕРґР°СЂРµ\r\nMaskking 2.0 РєСѓРїРёС‚СЊ\r\nРљСѓРїРёС‚СЊ СЌР»РµРєС‚СЂРѕРЅРЅС‹Рµ СЃРёРіР°СЂРµС‚С‹ РѕРґРЅРѕСЂР°Р·РѕРІС‹Рµ РІ РњРѕСЃРєРІРµ Maskking\r\n \r\n \r\nMaskking ОПТОМ из Китая \r\n \r\nhttps://chinex.su/maskkingoptom/ \r\n \r\nMaskking High PRO ОПТОМ из Китая \r\nhttps://ch',	''),
(225,	3,	40,	'7',	'Urocchpkm',	''),
(226,	3,	40,	'8',	'900900900@internet.ru',	''),
(227,	3,	40,	'4',	'(800) 628-4365',	''),
(228,	3,	40,	'6',	'Investing in a property',	''),
(229,	3,	40,	'5',	'https://aliexpress.ru/item/1005002968275091.html \r\n<a href=https://aliexpress.ru/item/1005002968275091.html>ключ натяжения помпы нексия 16 клапанов</a> \r\n<a href=\"https://aliexpress.ru/item/1005002968275091.html\">ключ помпы 41 мм</a>',	''),
(230,	3,	41,	'7',	'Scottket',	''),
(231,	3,	41,	'8',	'protribasvets1964@dizaer.ru',	''),
(232,	3,	41,	'4',	'(214) 245-7828',	''),
(233,	3,	41,	'6',	'Investing in a property',	''),
(234,	3,	41,	'5',	'https://classes.wiki/dictionary-english-russian-Apresyan-term-77760.htm',	''),
(235,	3,	42,	'7',	'Lof',	''),
(236,	3,	42,	'8',	'aidenmorgan77@gmail.com',	''),
(237,	3,	42,	'4',	'(267) 738-2614',	''),
(238,	3,	42,	'6',	'Getting some information',	''),
(239,	3,	42,	'5',	'Hi guys!',	''),
(240,	3,	43,	'7',	'ChesterHof',	''),
(241,	3,	43,	'8',	'lablecerc@gmail.com',	''),
(242,	3,	43,	'4',	'(168) 507-5317',	''),
(243,	3,	43,	'6',	'Investing in a property',	''),
(244,	3,	43,	'5',	'Компания сигареты сплошь работает уже более 20 лет на российском рынке, мы предлагаем самый беспредельный комплект табачных изделий по цене ниже оптовых. Мы работаем для прямую с известными брендами а беспричинно же крупными поставщиками табака. \r\nдля заказа и информации перехотите по ссылке ниже: \r\n<a href=https://sig-opt.ru>купить сигареты оптом дешево</a>',	''),
(245,	3,	44,	'7',	'DonaldWoopy',	''),
(246,	3,	44,	'8',	't.r.o.p.l.o.v.a.e.k.a.t.e.r.ina@gmail.com',	''),
(247,	3,	44,	'4',	'(611) 100-8115',	''),
(248,	3,	44,	'6',	'Getting some information',	''),
(249,	3,	44,	'5',	'herbal incense samples  <a href=  > http://crdp-amiens.fr/reducfr.html </a>  pregnancy drug abuse  <a href= http://www.emxa.web.auth.gr/provfr.html > emxa.web.auth.gr/provfr.html </a>  health care schools',	''),
(250,	3,	45,	'7',	'Haroldnesty',	''),
(251,	3,	45,	'8',	'nikita_ivanov.1986446@mail.ru',	''),
(252,	3,	45,	'4',	'(340) 211-3265',	''),
(253,	3,	45,	'6',	'Getting some information',	''),
(254,	3,	45,	'5',	'насилие\r\nдетское порно\r\nДП\r\ncialis\r\nметадон\r\n \r\n \r\n<a href=https://spravk1.site/>детское порно</a> \r\n \r\nметадон',	''),
(255,	3,	46,	'7',	'Donaldsce',	''),
(256,	3,	46,	'8',	'u.s.erza.l.evsk.ij.a22201@gmail.com',	''),
(257,	3,	46,	'4',	'(255) 536-5064',	''),
(258,	3,	46,	'6',	'Investing in a property',	''),
(259,	3,	46,	'5',	'Привет товарищи \r\nРоторный и шнековый способы бурения. Их отличия.В зависимости от глубины бурения и типа почвы компания “БухтехСервис” применяет 2 способа бурения. \r\nРоторный способ бурения. Выполняем с помощью передвижной буровой установки УРБ–2а2 на шасси ЗИЛ–131. Применяемый инструмент – шарошечные долота с широким диапазоном диаметров 75–300мм. Благодаря универсальности этого способа с легкостью разрушаются мягкие и твердые горные грунтовые слои.rotornoe-burenie \r\nВращательную мощность рото',	''),
(260,	3,	47,	'7',	'JessicaPsync',	''),
(261,	3,	47,	'8',	'freddy.meddini@gmail.com',	''),
(262,	3,	47,	'4',	'(516) 858-6673',	''),
(263,	3,	47,	'6',	'Getting some information',	''),
(264,	3,	47,	'5',	'<a href=https://bit.ly/2Uzz1S8>Try for free today</a>       Get Xevil for all your captcha solving. Fastest and the most accurate captcha solving available on the market, stop wasting your money on captchas.',	''),
(265,	3,	48,	'7',	'LolaFap',	''),
(266,	3,	48,	'8',	'8.ujkmnhdywhnmjkdrs.a.k.djwrj.djwwj@gmail.com',	''),
(267,	3,	48,	'4',	'(386) 705-7748',	''),
(268,	3,	48,	'6',	'Getting some information',	''),
(269,	3,	48,	'5',	'<img src=\"https://i.imgur.com/ANxKI85.jpeg\"> \r\nGood day! Looking for a sponsor. My profile on the search site: \r\nhttps://datingforkings.club/ My Name: Alisa Lozavarova',	''),
(270,	3,	49,	'7',	'Brianbroow',	''),
(271,	3,	49,	'8',	'ivanova_iuliia-722082@mail.ru',	''),
(272,	3,	49,	'4',	'(744) 330-8875',	''),
(273,	3,	49,	'6',	'Getting some information',	''),
(274,	3,	49,	'5',	'черный список брокеров мошенников форекс\r\nбинанс не дает вывести средства\r\ndaxioma отзывы и вывод денег\r\nне выводит деньги с бинанс\r\nвывод денег с бинанс отзывы\r\n \r\n \r\n<a href=https://be-top.org/>daxioma отзывы и вывод денег</a>',	''),
(275,	3,	50,	'7',	'MashaoTAX6377',	''),
(276,	3,	50,	'8',	'mashaashccbbiz9786@cc.com',	''),
(277,	3,	50,	'4',	'(705) 132-6537',	''),
(278,	3,	50,	'6',	'Getting some information',	''),
(279,	3,	50,	'5',	'You read it? Then XRumer and XEvil works!! \r\n \r\nWant to post your promo to 12.000.000 (12 MILLIONS!) websites? No problem - with new \"XEvil 5.0 + XRumer 19.0.8\" software complex! \r\nBlogs, forums, boards, shops, guestbooks, social networks - any engines with any captchas! \r\nXEvil also compatible with any SEO/SMM programms and scripts, and can accept captchas from any source. Just try it!  ;) \r\n \r\nRegards, MasheTAX6486 \r\n \r\nP.S. Huge discounts are available (up to 50%!) for a short review about X',	''),
(280,	3,	51,	'7',	'Aaronlax',	''),
(281,	3,	51,	'8',	'aleksandr4w0bo@mail.ru',	''),
(282,	3,	51,	'4',	'(541) 820-3317',	''),
(283,	3,	51,	'6',	'Investing in a property',	''),
(284,	3,	51,	'5',	'Профессиональный монтаж напольных покрытий.Обращайтесь всегда рады вам помочь. \r\ni',	''),
(285,	3,	52,	'7',	'ChesterHof',	''),
(286,	3,	52,	'8',	'lablecerc@gmail.com',	''),
(287,	3,	52,	'4',	'(583) 278-1350',	''),
(288,	3,	52,	'6',	'Investing in a property',	''),
(289,	3,	52,	'5',	'Общество сигареты сподряд работает уже более 20 лет для российском рынке, мы предлагаем очень укладистый комплект табачных изделий сообразно цене ниже оптовых. Мы работаем для прямую с известными брендами а беспричинно же крупными поставщиками табака. \r\nдля заказа и информации перехотите по ссылке ниже: \r\n<a href=https://sig-opt.ru>купить сигареты оптом от 10 блоков 2021</a>',	''),
(290,	3,	53,	'7',	'LolaFap',	''),
(291,	3,	53,	'8',	'8.ujkmnhdywhnmjkdrs.a.k.djwrj.djwwj@gmail.com',	''),
(292,	3,	53,	'4',	'(033) 334-0716',	''),
(293,	3,	53,	'6',	'Getting some information',	''),
(294,	3,	53,	'5',	'<img src=\"https://i.imgur.com/ANxKI85.jpeg\"> \r\nGood day! Looking for a sponsor. My profile on the search site: \r\nhttps://datingforkings.club/ My Name: Alisa Lozavarova',	''),
(295,	3,	54,	'7',	'TimothyTup',	''),
(296,	3,	54,	'8',	'a.dis24sili.v.a.no.v.@gmail.com',	''),
(297,	3,	54,	'4',	'(143) 010-0051',	''),
(298,	3,	54,	'6',	'Getting some information',	''),
(299,	3,	54,	'5',	'Можем предложить  https://porno-ru.site  - <a href=\"https://porno-ru.site/\">Ру порно</a>',	''),
(300,	3,	55,	'7',	'Jeremyexind',	''),
(301,	3,	55,	'8',	'derfclunosad1988@dizaer.ru',	''),
(302,	3,	55,	'4',	'(177) 700-6641',	''),
(303,	3,	55,	'6',	'Getting some information',	''),
(304,	3,	55,	'5',	'https://kinogoo.cc/25648-film-poslednij-tanec-2003-smotret-online-na-kinogo.html',	''),
(305,	3,	56,	'7',	'RobertScelp',	''),
(306,	3,	56,	'8',	'humpsephcentsu1950@dizaer.ru',	''),
(307,	3,	56,	'4',	'(772) 880-8207',	''),
(308,	3,	56,	'6',	'Getting some information',	''),
(309,	3,	56,	'5',	'https://kinogoo.by/37533-strana-grez-2016.html',	''),
(310,	3,	57,	'7',	'JessicaPsync',	''),
(311,	3,	57,	'8',	'freddy.meddini@gmail.com',	''),
(312,	3,	57,	'4',	'(302) 331-0106',	''),
(313,	3,	57,	'6',	'Investing in a property',	''),
(314,	3,	57,	'5',	'<a href=https://zomro.com/?from=305257>Use code to get up to 50% off</a> ,  Virtual dedicated servers starting from 2.49€ per month, get 50% off, Use code \"zomro_305257\"!',	''),
(315,	3,	58,	'7',	'RaSDoone',	''),
(316,	3,	58,	'8',	'tcharlya@yandex.ru',	''),
(317,	3,	58,	'4',	'(023) 070-2646',	''),
(318,	3,	58,	'6',	'Investing in a property',	''),
(319,	3,	58,	'5',	'<a href=https://mega-remont.pro>Москва ремонт недвижимости</a>',	''),
(320,	3,	59,	'7',	'HoraceZek',	''),
(321,	3,	59,	'8',	'petrov-nikita-19889@mail.ru',	''),
(322,	3,	59,	'4',	'(474) 076-1756',	''),
(323,	3,	59,	'6',	'Getting some information',	''),
(324,	3,	59,	'5',	'проститутки псков цены\r\nшлюхи в ленобласти\r\nгатчина проститутки номера телефона\r\nпсковская шлюха номер надо\r\nпроститутки спб ломоносовская\r\n \r\n \r\n<a href=https://publichome-1.com/city/krasnoe_selo>где а красном селе на дороге снять проститутку</a>',	''),
(325,	3,	60,	'7',	'JessicaPsync',	''),
(326,	3,	60,	'8',	'freddy.meddini@gmail.com',	''),
(327,	3,	60,	'4',	'(472) 551-7130',	''),
(328,	3,	60,	'6',	'Investing in a property',	''),
(329,	3,	60,	'5',	'<a href=https://zomro.com/?from=305257>Use code to get up to 50% off</a> ,  Virtual dedicated servers starting from 2.49€ per month, get 50% off, Use code \"zomro_305257\"!',	''),
(330,	3,	61,	'7',	'Kevintouse',	''),
(331,	3,	61,	'8',	'sarakn12@mail.ru',	''),
(332,	3,	61,	'4',	'(028) 800-4805',	''),
(333,	3,	61,	'6',	'Investing in a property',	''),
(334,	3,	61,	'5',	'<a href=https://megaremont.pro/minsk-restavratsiya-vann>The restoration of enamel baths in Mogilev</a>',	''),
(335,	3,	62,	'7',	'JessicaPsync',	''),
(336,	3,	62,	'8',	'freddy.meddini@gmail.com',	''),
(337,	3,	62,	'4',	'(431) 665-5750',	''),
(338,	3,	62,	'6',	'Investing in a property',	''),
(339,	3,	62,	'5',	'<a href=https://bit.ly/spinspeen> Spin Your Articles</a> , Best friend of every SEO campaing, take advantage of this special price before it goes up!',	''),
(340,	3,	63,	'7',	'JessicaPsync',	''),
(341,	3,	63,	'8',	'freddy.meddini@gmail.com',	''),
(342,	3,	63,	'4',	'(266) 745-0306',	''),
(343,	3,	63,	'6',	'Investing in a property',	''),
(344,	3,	63,	'5',	'<a href=https://bit.ly/spinspeen> Spin Your Articles</a> , Best friend of every SEO campaing, take advantage of this special price before it goes up!',	''),
(345,	3,	64,	'7',	'Robertksa',	''),
(346,	3,	64,	'8',	'us.erzale.vski.ja2220.1@gmail.com',	''),
(347,	3,	64,	'4',	'(616) 818-5137',	''),
(348,	3,	64,	'6',	'Investing in a property',	''),
(349,	3,	64,	'5',	'Привет друзья \r\n \r\nОбустройство скважины \r\nСледующим этапом, после того, как были выполнены буровые работы, является обустройство скважин. \r\n \r\nДля того чтобы \r\nизбежать проблем при эксплуатации скважины \r\nобеспечить своему дому полноценные автономные поставки воды \r\nне остаться без водоснабжения в самый неподходящий момент \r\nскважина не прекратила подачу воды с наступлением холодов \r\nпредотвратить попадание в скважину загрязняющих веществ \r\nнеобходимо точно определить все характеристики конкрет',	''),
(350,	3,	65,	'7',	'Jeremyexind',	''),
(351,	3,	65,	'8',	'ranmahorback1983@dizaer.ru',	''),
(352,	3,	65,	'4',	'(120) 423-3713',	''),
(353,	3,	65,	'6',	'Getting some information',	''),
(354,	3,	65,	'5',	'https://kinogoo.cc/2782-film-sollers-pojnt-2017-smotret-online-na-kinogo.html',	''),
(355,	3,	66,	'7',	'FrankPes',	''),
(356,	3,	66,	'8',	'quicomvebum1962@dizaer.ru',	''),
(357,	3,	66,	'4',	'(334) 473-0541',	''),
(358,	3,	66,	'6',	'Investing in a property',	''),
(359,	3,	66,	'5',	'https://kinogoo.by/3273-film-prekrasnaja-molodost-2014-smotret-online-na-kinogo.html',	''),
(360,	3,	67,	'7',	'DavidFub',	''),
(361,	3,	67,	'8',	'davidFeake581@israelmail.com',	''),
(362,	3,	67,	'4',	'(320) 823-2763',	''),
(363,	3,	67,	'6',	'Investing in a property',	''),
(364,	3,	67,	'5',	'Attention! Here you can earn money online! \r\n------> <a href=http://thankfulhannl.herocryptos.cn/>thankfulhannl.geronmonet.cn</a> \r\n------>   defeatedeafee.herocryptos.cn',	''),
(365,	3,	68,	'7',	'InstBlokpori',	''),
(366,	3,	68,	'8',	'annniko1@yandex.com',	''),
(367,	3,	68,	'4',	'(265) 068-1113',	''),
(368,	3,	68,	'6',	'Investing in a property',	''),
(369,	3,	68,	'5',	'Оказываю услуги по полной блокировке instagram  аккаунтов. \r\nАккаунт нельзя восстановить от',	''),
(370,	3,	69,	'7',	'HoraceZek',	''),
(371,	3,	69,	'8',	'petrov-nikita-19889@mail.ru',	''),
(372,	3,	69,	'4',	'(353) 810-0760',	''),
(373,	3,	69,	'6',	'Getting some information',	''),
(374,	3,	69,	'5',	'форум интим\r\nшлюхи большевиков возможность оценить внешность\r\nпроститутки колбасный новоселье цех\r\nропша пекин проститутки\r\nпроститутки псков негретчнки\r\n \r\n \r\n<a href=https://publichome-1.com/>черные шлюхи питера</a>',	''),
(375,	3,	70,	'7',	'Martingog',	''),
(376,	3,	70,	'8',	'artem.denisov.620943@mail.ru',	''),
(377,	3,	70,	'4',	'(043) 532-4407',	''),
(378,	3,	70,	'6',	'Getting some information',	''),
(379,	3,	70,	'5',	'free tiki torch slot machine\r\nuk online casinos 2019\r\ndolphins pearl deluxe slot\r\ncaesars online casino uk\r\nslot machine cash out strategy\r\n \r\n \r\n<a href=https://mgccasinos.com/>indirect costs examples in online casino</a>',	''),
(380,	3,	71,	'7',	'InstBlokpori',	''),
(381,	3,	71,	'8',	'annniko1@yandex.com',	''),
(382,	3,	71,	'4',	'(861) 712-8217',	''),
(383,	3,	71,	'6',	'Getting some information',	''),
(384,	3,	71,	'5',	'Оказываю услуги по полной блокировке instagram  аккаунтов. \r\nАккаунт нельзя восстановить от',	''),
(385,	3,	72,	'7',	'Banking, mortgage',	''),
(386,	3,	72,	'8',	'alicecarpenter739@gmail.com',	''),
(387,	3,	72,	'4',	'(510) 261-1541',	''),
(388,	3,	72,	'6',	'Getting some information',	''),
(389,	3,	72,	'5',	'Читы на любую игру подкупать сиречь приобрести безвозмездно позволительно на нашем самом быстрорастущем форуме читов и разных модов для самые популярные зрелище, только можно встречать беспричинно же для редкие жанры игр. Имущество идти на крутой форум игрового шмота и других полезных фитчей. \r\n<a href=https://yougame.biz/forums/34/>https://yougame.biz/forums/34/</a>',	''),
(390,	3,	73,	'7',	'Jasonseiny',	''),
(391,	3,	73,	'8',	'davidFeake139@homemail.com',	''),
(392,	3,	73,	'4',	'(241) 872-7611',	''),
(393,	3,	73,	'6',	'Investing in a property',	''),
(394,	3,	73,	'5',	'* Customer Support Center 365 \\ 24 \\ 7 \r\n* Delivery methods: EMS, AirMail. \r\n* without a doctors prescription \r\n \r\n<a href=https://is.gd/midbnQ>Pharmaceuticals online</a> \r\n \r\nSildigra\r\nMinocycline\r\nAceon\r\nLevitra Jelly\r\nUroxatral\r\nClaritin\r\nAtorlip-20\r\nVytorin\r\nSuper Levitra\r\nRetin-A 0,05\r\nMentat DS syrup\r\nKamagra Oral Jelly\r\nSlip Inn\r\nKamagra Super\r\nMestinon\r\nImuran\r\nPenegra\r\nRosuvastatin\r\nMethotrexate\r\nCefadroxil',	''),
(395,	3,	74,	'7',	'CharlesSmame',	''),
(396,	3,	74,	'8',	'geuprepilin1951@dizaer.ru',	''),
(397,	3,	74,	'4',	'(448) 682-6884',	''),
(398,	3,	74,	'6',	'Getting some information',	''),
(399,	3,	74,	'5',	'https://kinogoo.by/23113-film-modzhin-2015-smotret-online-na-kinogo.html',	''),
(400,	3,	75,	'7',	'RobertFoown',	''),
(401,	3,	75,	'8',	'leofinbanigs1963@dizaer.ru',	''),
(402,	3,	75,	'4',	'(726) 535-7562',	''),
(403,	3,	75,	'6',	'Getting some information',	''),
(404,	3,	75,	'5',	'https://kinogoo.cc/8366-film-vrag-klassa-2013-smotret-online-na-kinogo.html',	''),
(405,	3,	76,	'7',	'Keithtusty',	''),
(406,	3,	76,	'8',	'kelliemiles263@gmail.com',	''),
(407,	3,	76,	'4',	'(312) 677-3771',	''),
(408,	3,	76,	'6',	'Investing in a property',	''),
(409,	3,	76,	'5',	'Найти нужный товар или услугу без проблем можно на <a href=\"https://x.hyrda-seller.com\" title=\"Гидра официальный сайт\">Гидра официальный сайт</a>. Десятки тысяч магазинов с отзывами помогут сделать правильный выбор. \r\n \r\n \r\n \r\n \r\n \r\n \r\n \r\n \r\n<a href=https://x.hyrda-seller.com>hydra сайт</a>',	''),
(410,	3,	77,	'7',	'KarinaOl',	''),
(411,	3,	77,	'8',	'7hcm.chistyukhin2911x1su@gmail.com',	''),
(412,	3,	77,	'4',	'(725) 884-4200',	''),
(413,	3,	77,	'6',	'Investing in a property',	''),
(414,	3,	77,	'5',	'Новая вспышка Covid-19, которую уже назвали самой серьезной после Уханя, охватила по меньшей мере 15 китайских провинций и городов. Власти проявляют все больше беспокойства по поводу уязвимости страны перед более заразным вариантом \"Дельта\".Вся информация о новом шиаме вируса доступна по ссылке : \r\n \r\n<a href=https://mirokru.ru/v-rf-predlozheno-reshenie-problemy-nochnyh-babochek-elitnoj-mozhet-stat-kazhdaya/></a> \r\n \r\nЗа последние 10 дней дни зарегистрировано более 300 новых случаев заболевания,',	''),
(415,	3,	78,	'7',	'Annclurl',	''),
(416,	3,	78,	'8',	'annGelM80@hotmail.com',	''),
(417,	3,	78,	'4',	'(338) 855-5321',	''),
(418,	3,	78,	'6',	'Investing in a property',	''),
(419,	3,	78,	'5',	'heey dear!! my name is Frances... \r\nI dream of hard sex. Write me on this site - tinyurl.com/yjf2yf68',	''),
(420,	3,	79,	'7',	'Albertphill',	''),
(421,	3,	79,	'8',	'oksana.smirnova_915@mail.ru',	''),
(422,	3,	79,	'4',	'(811) 776-3123',	''),
(423,	3,	79,	'6',	'Getting some information',	''),
(424,	3,	79,	'5',	'<p>coin mixers is one of those mixing services that keep your crypto safe. The platform will take your bitcoin, mix it with other deposits, and give you the same amount of bitcoin in return. It’s designed to reduce bitcoin tracking, “clean” your coins, and help ensure anonymity on the transparent bitcoin network.  A bitcoin mixer service like BitMix.Biz will take your bitcoin, then give you different bitcoin in return. The platform collects everyone’s bitcoin deposits, mixes them up into one cen',	''),
(425,	3,	80,	'7',	'JESgax',	''),
(426,	3,	80,	'8',	'reginadood@yandex.ru',	''),
(427,	3,	80,	'4',	'(574) 131-0738',	''),
(428,	3,	80,	'6',	'Investing in a property',	''),
(429,	3,	80,	'5',	'Get gifts from Joycazino for free - play without paying money https://joycasinos1.com/  \r\n \r\nПодарки от Джойказино получите бесплатно https://joycasinos1.com/  \r\n \r\nЗеркало - JoyCasino https://joycasinos1.com/',	''),
(430,	3,	81,	'7',	'Service',	''),
(431,	3,	81,	'8',	'allandean1323@gmail.com',	''),
(432,	3,	81,	'4',	'(360) 533-3160',	''),
(433,	3,	81,	'6',	'Getting some information',	''),
(434,	3,	81,	'5',	'<a href=https://nostrifikacie.ru><img src=\"https://i.ibb.co/PQCk44k/1-banner.jpg\"></a> \r\nКаждый абитуриент, поступающий в чешский университет и получивший среднее образование за пределами Чехии стоит перед необходимостью прохождения процедуры нострификации аттестата в Чехии, т. подтверждения полученного образования, таковы требования закона. \r\n<a href=https://paper.wf/9r5641okl3>нострификация диплома</a>',	''),
(435,	3,	82,	'7',	'JamMom',	''),
(436,	3,	82,	'8',	'stchare@yandex.ru',	''),
(437,	3,	82,	'4',	'(180) 373-8740',	''),
(438,	3,	82,	'6',	'Investing in a property',	''),
(439,	3,	82,	'5',	'<a href=https://fwstyle.pro>Hairstyles</a>',	''),
(440,	3,	83,	'7',	'Mixail',	''),
(441,	3,	83,	'8',	'mixa@vipiskaisegrn.ru',	''),
(442,	3,	83,	'4',	'(584) 706-5102',	''),
(443,	3,	83,	'6',	'Investing in a property',	''),
(444,	3,	83,	'5',	'Смотрю какие призы будут разыгрывать в русских лотереях на сайте https://mir-loto.com/category/prizi  написал их админу он пообещал что еще розыгрыши всяких там пятерочек и других магазинов публиковать будут.',	''),
(445,	3,	84,	'7',	'HelenEtele',	''),
(446,	3,	84,	'8',	'vlada.botezat.1983@mail.ru',	''),
(447,	3,	84,	'4',	'(260) 816-7566',	''),
(448,	3,	84,	'6',	'Investing in a property',	''),
(449,	3,	84,	'5',	'Pivmfnhux',	''),
(450,	3,	85,	'7',	'win-indiaTaf',	''),
(451,	3,	85,	'8',	'kaidankainda@gmail.com',	''),
(452,	3,	85,	'4',	'(574) 047-3666',	''),
(453,	3,	85,	'6',	'Getting some information',	''),
(454,	3,	85,	'5',	'Did you know which by 2020 global investment in social media advertising will reach $ 86 billion (barely € 75 billion)? \r\n \r\nIt\'s hard to imagine, because which most package of this ad is so subtle, so cleverly disguised, which we only notice her presence. However announcement nibble, and it\'s not hard to see why. \r\n \r\nMost of us live most of our lot of our lives on the Internet these days. Pen goes not only about part, to possess Facebook account: we follow for people on YouTube, Snapchat perha',	''),
(455,	3,	86,	'7',	'Terryhor',	''),
(456,	3,	86,	'8',	'donwanexpvest1982@dizaer.ru',	''),
(457,	3,	86,	'4',	'(084) 064-5471',	''),
(458,	3,	86,	'6',	'Getting some information',	''),
(459,	3,	86,	'5',	'https://kinogoo.by/31627-ne-ogljadyvajsja-2020.html',	''),
(460,	3,	87,	'7',	'Robertjeant',	''),
(461,	3,	87,	'8',	'enapcohor1975@dizaer.ru',	''),
(462,	3,	87,	'4',	'(758) 522-6115',	''),
(463,	3,	87,	'6',	'Investing in a property',	''),
(464,	3,	87,	'5',	'https://kinogoo.cc/2718-film-sdelano-v-trejlere-2016-smotret-online-na-kinogo.html',	''),
(465,	3,	88,	'7',	'Louisovaph',	''),
(466,	3,	88,	'8',	'mndllucifer@gmail.com',	''),
(467,	3,	88,	'4',	'(002) 423-1635',	''),
(468,	3,	88,	'6',	'Investing in a property',	''),
(469,	3,	88,	'5',	'<b>Sports Betting Affiliate Deals - The Best Sports Betting Affiliate Deals</b> \r\n \r\n<a href=https://www.jackpotbetonline.com/><b>Sports Betting</b></a> Affiliate Deals is one of the most lucrative ways to earn money from sports. With the advent of the internet, affiliate marketing has turned into a very profitable business. Thanks to the internet, affiliate marketing has become an easy way to make money. There are many people who are making huge amounts of money from Sports Betting Affiliate De',	''),
(470,	3,	89,	'7',	'Williamwem',	''),
(471,	3,	89,	'8',	'oleg37802@gmail.com',	''),
(472,	3,	89,	'4',	'(123) 815-7472',	''),
(473,	3,	89,	'6',	'Getting some information',	''),
(474,	3,	89,	'5',	'Быстровозводимые здания из ЛСТК - MCSTEEL \r\nДома. Гаражи. Ангары. Склады. Навесы. Коровники. Птичники. Мастерские. Склад-Холодильник. \r\nТорговые здания. Зернохранилища. Овощехранилища. Производственный цех. СТО \r\nСобственное производство. \r\nПроектирование, производство, монтаж складских, производственных, торговых, сельхоз сооружений. \r\nбыстровозводимых зданий из легких металлоконструкций. Расчет стоимости проектов. \r\n \r\n<a href=https://mcsteel.ru/>Ангары</a>',	''),
(475,	3,	90,	'7',	'KennethUtend',	''),
(476,	3,	90,	'8',	'grigorevmadiyar4664@yandex.ru',	''),
(477,	3,	90,	'4',	'(566) 342-5868',	''),
(478,	3,	90,	'6',	'Investing in a property',	''),
(479,	3,	90,	'5',	'Music has tied us \r\nKeyboards & Pianos \r\nhttps://fas.st/NNXXI \r\n \r\nDrums & Percussion \r\nhttps://fas.st/Vay4s \r\n \r\nString Instruments \r\nhttps://fas.st/32jbD',	''),
(480,	3,	91,	'7',	'JosephTroda',	''),
(481,	3,	91,	'8',	'expertseo430@gmail.com',	''),
(482,	3,	91,	'4',	'(823) 788-3563',	''),
(483,	3,	91,	'6',	'Getting some information',	''),
(484,	3,	91,	'5',	'<b>Online Sports Betting Sites</b> \r\n \r\nIf you\'ve tried to make a sports wager on the Internet before, you\'ve undoubtedly heard about all the great online betting sites out there. But which ones are the best? How do you decide which site is the best choice for your next bet? For your added convenience, have assembled this quick guide, covering all important information regarding sports betting, including how to find a reliable betting service, how to place bets, betting types, betting odds, wage',	''),
(485,	3,	92,	'7',	'Jamesonema',	''),
(486,	3,	92,	'8',	'shoosawfhq@hotmail.com',	''),
(487,	3,	92,	'4',	'(351) 246-7706',	''),
(488,	3,	92,	'6',	'Getting some information',	''),
(489,	3,	92,	'5',	'visit site <a href=https://pinup-kazino-az.com/az/pin-up-az/>pin up casino qeydiyyat </a>',	''),
(490,	3,	93,	'7',	'Real',	''),
(491,	3,	93,	'8',	'norrisoliver107@gmail.com',	''),
(492,	3,	93,	'4',	'(855) 410-8586',	''),
(493,	3,	93,	'6',	'Investing in a property',	''),
(494,	3,	93,	'5',	'\"Виагра подходит отлично для просмотра порно особенно если использовать метадон, героин, экстази, марихуана и индика, выращенная дома на поддельные деньги. Под подушкой лежит пистолет, а хотелось бы ак-47. Я люблю оружие потому что под героин посматривают на игил и хочу за деньги поехать в сирия. Там продается оружие, наркотики, виагра и автомат. Метадон впирает лучше чем кокаин, но иногда хочется индику и сиалис. На поддельные деньги не купишь кокаин, но можно пистолет или автомат чтобы вступит',	''),
(495,	3,	94,	'7',	'Davidvom',	''),
(496,	3,	94,	'8',	'bu.ch.ho.l.z.m8.4.7@gmail.com',	''),
(497,	3,	94,	'4',	'(182) 485-0075',	''),
(498,	3,	94,	'6',	'Getting some information',	''),
(499,	3,	94,	'5',	'https://creditcounseling-104.apartjardindelmar.cl/credit-counseling-shelter-bay-wa.php',	''),
(500,	3,	95,	'7',	'LarryTek',	''),
(501,	3,	95,	'8',	's.h.ahida.sla.m00.1a@gmail.com',	''),
(502,	3,	95,	'4',	'(406) 446-6643',	''),
(503,	3,	95,	'6',	'Getting some information',	''),
(504,	3,	95,	'5',	'Read about [url=https://www.myanimeforlife.com/tag/low-lolicon]Comedy Anime[/url]',	''),
(505,	3,	96,	'7',	'Robertjeant',	''),
(506,	3,	96,	'8',	'enapcohor1975@dizaer.ru',	''),
(507,	3,	96,	'4',	'(414) 068-7068',	''),
(508,	3,	96,	'6',	'Investing in a property',	''),
(509,	3,	96,	'5',	'https://kinogoo.cc/28448-film-pravdivaja-istorija-krasnoj-shapki-2005-smotret-online-na-kinogo.html',	''),
(510,	3,	97,	'7',	'Terryhor',	''),
(511,	3,	97,	'8',	'donwanexpvest1982@dizaer.ru',	''),
(512,	3,	97,	'4',	'(548) 762-8205',	''),
(513,	3,	97,	'6',	'Getting some information',	''),
(514,	3,	97,	'5',	'https://kinogoo.by/13086-film-menja-zovut-nikto-1973-smotret-online-na-kinogo.html',	''),
(515,	3,	98,	'7',	'Kimalure',	''),
(516,	3,	98,	'8',	'kimlourgy69@yahoo.com',	''),
(517,	3,	98,	'4',	'(854) 442-6485',	''),
(518,	3,	98,	'6',	'Getting some information',	''),
(519,	3,	98,	'5',	'Hi dear... Im looking a man!! \r\nI want sex! Here are my photos - is.gd/BorTal',	''),
(520,	3,	99,	'7',	'DannyHoome',	''),
(521,	3,	99,	'8',	'maildogs@newpochta.com',	''),
(522,	3,	99,	'4',	'(242) 063-0060',	''),
(523,	3,	99,	'6',	'Getting some information',	''),
(524,	3,	99,	'5',	'Дрессировка Шлюх <a href=https://nsdog.ru/uslugi/>nsdog.ru</a> При обучении команде, можно на пол положить еду.',	''),
(525,	3,	100,	'7',	'Josephlieby',	''),
(526,	3,	100,	'8',	'volkov_mikhail-8161@mail.ru',	''),
(527,	3,	100,	'4',	'(010) 014-4404',	''),
(528,	3,	100,	'6',	'Getting some information',	''),
(529,	3,	100,	'5',	'Freeroll Passwords \r\n \r\n<a href=https://twitter.com/Passwords_Today>Freeroll Passwords today</a> \r\n \r\n888 poker freeroll password\r\nbet365 freeroll password\r\nggpoker freeroll password',	''),
(530,	3,	101,	'7',	'Samueletems',	''),
(531,	3,	101,	'8',	'wc984629@gmail.com',	''),
(532,	3,	101,	'4',	'(158) 385-4375',	''),
(533,	3,	101,	'6',	'Getting some information',	''),
(534,	3,	101,	'5',	'Посмотрите tv интернет в веб-сайте «UZITV.NET». Доступен непосредственный среда отечественных телеканалов во отличном свойстве: 1-Ый, Российская Федерация 1, медиакомпания, ТНТ, Российская Федерация 24 также прочие каналы безвозмездно также в отсутствии регистрации. С Целью вашего комфорт показ вероятен со пк, подвижного телефонного аппарата либо планшета. Единичные каналы легкодоступны во HD-свойстве. Информативные, увеселительные, мелодические, познавательные телевизионные каналы — посмотрите',	''),
(535,	3,	102,	'7',	'DavidGuags',	''),
(536,	3,	102,	'8',	'mkovallenkko7362@gmail.com',	''),
(537,	3,	102,	'4',	'(626) 301-7761',	''),
(538,	3,	102,	'6',	'Getting some information',	''),
(539,	3,	102,	'5',	'20 lightning fast ways that work \r\n<a href=https://exmo.me/?ref=433652>GO</a>',	''),
(540,	3,	103,	'7',	'Service',	''),
(541,	3,	103,	'8',	'simonjordan164@gmail.com',	''),
(542,	3,	103,	'4',	'(434) 552-0648',	''),
(543,	3,	103,	'6',	'Investing in a property',	''),
(544,	3,	103,	'5',	'Вам даем возможность прослушать песни в интернете либо загрузить различную мп3 музыку безвозмездно также в отсутствии регистрации. Наиболее свежайшие новшества музыки во формате mp3 возникают в нашем веб-сайте каждый день. Свой мелодичный обслуживание BassOk.Net дает возможность находить песенки согласно наименованию либо фамилии исполнителя. \r\n \r\n<a href=https://bassok.net>новинки русской музыки 80 скачать бесплатно</a> \r\n<a href=https://bassok.net>новинки музыки этого года</a>',	''),
(545,	3,	104,	'7',	'SamuelNon',	''),
(546,	3,	104,	'8',	'earlbailey2963@gmail.com',	''),
(547,	3,	104,	'4',	'(254) 648-3313',	''),
(548,	3,	104,	'6',	'Getting some information',	''),
(549,	3,	104,	'5',	'Сколько ранее имелось произнесено об азартных забавах в служебных онлайн казино. Как много людей опробовали свою везение на сайтах игровых автоматах. часть из них начинает жалеть спустя первоначальных же неудач, а вот настойчивые дождались г-жи судьбы и продолжают систематически играть и отыгрываться настоящие денежки в казино онлайн. \r\n<a href=https://top100casino.azurewebsites.net/>казино онлайн</a> \r\n<a href=https://top100casino.azurewebsites.net/vse-100-casino-online.html>все казино онлайн</',	''),
(550,	3,	105,	'7',	'AnthonySkadE',	''),
(551,	3,	105,	'8',	'o.k.o.b.elevro81@gmail.com',	''),
(552,	3,	105,	'4',	'(787) 328-1263',	''),
(553,	3,	105,	'6',	'Getting some information',	''),
(554,	3,	105,	'5',	'land remediation  <a href=  > https://ikwileenpoes.nl/loraznl.html </a>  homeopathic remedies depression  <a href= https://lorazepames.asso-web.com/actualite-1-.html > https://lorazepames.asso-web.com/actualite-1-.html </a>  health care affordable',	''),
(555,	3,	106,	'7',	'JamesSnund',	''),
(556,	3,	106,	'8',	'no-replyGigmani@gmail.com',	''),
(557,	3,	106,	'4',	'(854) 172-2252',	''),
(558,	3,	106,	'6',	'Investing in a property',	''),
(559,	3,	106,	'5',	'Hi!  graygroupla.com \r\n \r\nDo you know the best way to mention your product or services? Sending messages through contact forms will permit you to simply enter the markets of any country (full geographical coverage for all countries of the world).  The advantage of such a mailing  is that the emails that will be sent through it\'ll find yourself in the mailbox that is intended for such messages. Causing messages using Feedback forms is not blocked by mail systems, which implies it\'s certain to rea',	''),
(560,	3,	107,	'7',	'Sales',	''),
(561,	3,	107,	'8',	'donaldburke1126@gmail.com',	''),
(562,	3,	107,	'4',	'(825) 481-1516',	''),
(563,	3,	107,	'6',	'Getting some information',	''),
(564,	3,	107,	'5',	'Поступая на обучение, нужно четко понимать, есть ли в планах на будущее работа по профессии. Часто это довольно сложно для молодых людей, которые по окончанию университета понимают, что не хотят работать по специальности, и ищут более вакантное место. \r\nhttps://jerelo.info/forum/viewtopic.php?f=8&t=1641 \r\nhttp://forum.gold-forum.ru/index.php?showtopic=47143 \r\nhttps://rabset.ru/viewtopic.php?id=17725#p67995 \r\nhttp://baby-best.ru/forum/topic_56571 \r\nhttp://partnerusa.net/shkafy-kupe-na-zakaz-v-mos',	''),
(565,	3,	108,	'7',	'DouglasJuita',	''),
(566,	3,	108,	'8',	'bahalovgleb@gmail.com',	''),
(567,	3,	108,	'4',	'(578) 225-7056',	''),
(568,	3,	108,	'6',	'Investing in a property',	''),
(569,	3,	108,	'5',	'С Целью каждого трейдера первоначальный стадия работы – данное отбор добропорядочного также добросовестного брокера. Фирма EXCBC непосредственно такой также считается. Непосредственно со ней каждой торговец, в том числе и безусловный начинающий, способен полагаться в приобретение прибыли. \r\n \r\n<a href=https://www.bosch-gll.ru/2021/08/excbc.com-otzyvy-moshenniki-chestnyy-obzor-brokera-excbc.html>Отзывы ru.ex-cbc.com</a> \r\n<a href=https://www.otzyvys.ru/2021/08/broker-excbc.com-otzyvy-moshenniki-o',	''),
(570,	3,	109,	'7',	'ApkJoyTaf',	''),
(571,	3,	109,	'8',	'va.g.av.a.g.i.s.o.v.199.5.2.8.12.1.99.5@gmail.com',	''),
(572,	3,	109,	'4',	'(885) 608-0684',	''),
(573,	3,	109,	'6',	'Getting some information',	''),
(574,	3,	109,	'5',	'You can download any of the provided casinos more than without any problems. If you download the casino app, it purposefulness travail like a regular mirror image of the main milieu from the mobile version. Unfortunately, all the apps you download will contrariwise do one\'s daily dozen on Android. Download casino in 1 click from the schedule, these are the most advanced mobile applications. \r\n \r\nThe most suitable casino apps for Android \r\nThe problem is that determination Android apps and downlo',	''),
(575,	3,	110,	'7',	'Michaelusedy',	''),
(576,	3,	110,	'8',	'laurijohnsons46@gmail.com',	''),
(577,	3,	110,	'4',	'(684) 607-4247',	''),
(578,	3,	110,	'6',	'Investing in a property',	''),
(579,	3,	110,	'5',	'<b>How To Win At Online Casino Slot </b> \r\n \r\nAre you looking for free <a href=https://www.jackpotbetonline.com/><b>online casino slot</b></a> ? You can easily find hundreds of online casino sites that offer a wide variety of slot games. In fact, there are so many online casino sites that you can play any game you want. Today online gambling has become a multi billion dollar business. Since online gambling has grown so much in recent years so have online casino site. To help you choose an online',	''),
(580,	3,	111,	'7',	'AgentlotVob',	''),
(581,	3,	111,	'8',	'gamblinglotto@gmail.com',	''),
(582,	3,	111,	'4',	'(155) 827-8211',	''),
(583,	3,	111,	'6',	'Investing in a property',	''),
(584,	3,	111,	'5',	'<b>Победитель лотереи Saturday Lotto о себе и планах на жизнь:</b> \r\nМы всегда понимали, что наши участники — личности интересные и неординарные! \r\nВот, например, интервью одного из наших победителей. Максим Г. угадал все числа второй категории \"5+S\" и выиграл 8 736,07 USD (или 11 893,89 AUD австралийских долларов) в лотерею Австралии Saturday Lotto. \r\nМаксим поведал о себе и поделился будущими планами: \r\n— Расскажите о себе: Какая у Вас профессия? Чем вы увлекаетесь, на что тратите свободное вр',	''),
(585,	3,	112,	'7',	'Johnnyexary',	''),
(586,	3,	112,	'8',	'cumsherile1982@dizaer.ru',	''),
(587,	3,	112,	'4',	'(541) 825-8822',	''),
(588,	3,	112,	'6',	'Investing in a property',	''),
(589,	3,	112,	'5',	'https://kinogoo.by/14562-film-zavorozhennyj-1945-smotret-online-na-kinogo.html',	''),
(590,	3,	113,	'7',	'Donaldpsync',	''),
(591,	3,	113,	'8',	'conssoftdece1954@dizaer.ru',	''),
(592,	3,	113,	'4',	'(018) 507-0785',	''),
(593,	3,	113,	'6',	'Getting some information',	''),
(594,	3,	113,	'5',	'https://kinogoo.cc/1495-film-pravda-ili-dejstvie-2018-smotret-online-na-kinogo.html',	''),
(595,	3,	114,	'7',	'Darrenboole',	''),
(596,	3,	114,	'8',	'michealthomass457@gmail.com',	''),
(597,	3,	114,	'4',	'(123) 158-2780',	''),
(598,	3,	114,	'6',	'Investing in a property',	''),
(599,	3,	114,	'5',	'3 Tips For Choosing the Best Sportsbook \r\n \r\nIf you love sports betting and have never learned an inside secret tip or two, then you need a guide to betting. A guide to betting can be your secret to sports betting riches. You might be wondering how is it that betting can make you rich. Well, it is simple. The sports book is making money by placing your bets on your team. \r\n \r\nMost states with legal <a href=https://www.jackpotbetonline.com/><b>sports betting</b></a> let both online and in-room wa',	''),
(600,	3,	115,	'7',	'JosephEmake',	''),
(601,	3,	115,	'8',	'halimetuana10@gmail.com',	''),
(602,	3,	115,	'4',	'(222) 274-8112',	''),
(603,	3,	115,	'6',	'Getting some information',	''),
(604,	3,	115,	'5',	'В том случае, если говорить о критериях любви, то они складываются из уважения, доверия, беспокойства, физического влечения и желании беречь верность своему партнеру. То есть, если человек адекватен и психически здоров, то желание быть преданным партнеру будет критерием того, что она его любит. \r\nКак понять, что отношения не доставляют восторг \r\nОсознать, что в отношениях кое-что не так, возможно на уровне чувств и ощущений. То есть, женщина может по своему общему психологическим состоянием поня',	''),
(605,	3,	116,	'7',	'Larrytuh',	''),
(606,	3,	116,	'8',	'%spinfile-names.dat%%spinfile-lnames.dat%%random-1-100%@base.mixwi.com',	''),
(607,	3,	116,	'4',	'(018) 571-6050',	''),
(608,	3,	116,	'6',	'Investing in a property',	''),
(609,	3,	116,	'5',	'Trusted Online Casino Malaysia   http://gm231.com/gm231-best-online-slot-games-malaysia-slots-918kiss-xe88/#{Best Online Slot Games Malaysia | Slots |  - {Online Casino Malaysia|Click here|More info|Show more}{!|...|>>>|!..}',	''),
(610,	3,	117,	'7',	'JessicaPsync',	''),
(611,	3,	117,	'8',	'freddy.meddini@gmail.com',	''),
(612,	3,	117,	'4',	'(153) 460-2557',	''),
(613,	3,	117,	'6',	'Investing in a property',	''),
(614,	3,	117,	'5',	'Make sence of your mess, get the best spinner available on the market today. Endless SEO possibilities. <a href=https://bit.ly/spinspeen>Link</a>',	''),
(615,	3,	118,	'7',	'MollyCok',	''),
(616,	3,	118,	'8',	'gdirwin89@yandex.com',	''),
(617,	3,	118,	'4',	'(338) 208-7505',	''),
(618,	3,	118,	'6',	'Getting some information',	''),
(619,	3,	118,	'5',	'<b>Kinky Stepdaughter and Howife roles: meet me at OnlyFans!</b> \r\n \r\nHi guys! \r\nI\'m Molly, from France. \r\nWant to make some videos about my stepfather seduction. \r\nAnd about my Hotwife role: f*cking with other men when my husband know about it. \r\n \r\nI am 26 years old, have beautiful sporty body, big tits, big butt and natural tasty lips :) \r\n<a href=https://onlyfans.com/sexymolly2021>Subscribe to my profile, talk with me, send your ideas for video stories!</a> \r\n \r\n<a href=https://onlyfans.com/',	''),
(620,	3,	119,	'7',	'Donaldnes',	''),
(621,	3,	119,	'8',	'vadim-petukhov_19850@mail.ru',	''),
(622,	3,	119,	'4',	'(753) 760-6661',	''),
(623,	3,	119,	'6',	'Investing in a property',	''),
(624,	3,	119,	'5',	'boots egypt \r\n \r\n<a href=https://www.palladiumegypt.com/>palladium egypt</a> \r\n \r\ninfo@palladiumegypt.com',	''),
(625,	3,	120,	'7',	'LarryTek',	''),
(626,	3,	120,	'8',	'sha.h.ida.s.l.am0.01.a@gmail.com',	''),
(627,	3,	120,	'4',	'(337) 703-7672',	''),
(628,	3,	120,	'6',	'Getting some information',	''),
(629,	3,	120,	'5',	'Show more about <a href=https://www.youtube.com/watch?v=ZSyryqxWb3o>Harem Anime</a>',	''),
(630,	3,	121,	'7',	'Restaurant, food',	''),
(631,	3,	121,	'8',	'horatioboyd457@gmail.com',	''),
(632,	3,	121,	'4',	'(337) 373-1682',	''),
(633,	3,	121,	'6',	'Getting some information',	''),
(634,	3,	121,	'5',	'Все уже вышедшие фильмы и сериалы 2022 года здесь! Зарубежные и русские в хорошем качестве. Смотрите онлайн новинки кино 2022 года, которые уже вышли только на нашем портале. Большой выбор озвучек и качества. На телефоне и планшете без смс! \r\n \r\nhttps://hd.losfilm.cc/552-01okteb-igra-prestolov.html',	''),
(635,	3,	122,	'7',	'Haroldhor',	''),
(636,	3,	122,	'8',	'o.k.o.b.e.lev.ro8.1@gmail.com',	''),
(637,	3,	122,	'4',	'(156) 518-8155',	''),
(638,	3,	122,	'6',	'Getting some information',	''),
(639,	3,	122,	'5',	'herbal slimming pills  <a href=  > https://edukndo.com/sibpt.html </a>  definition of remediated  <a href= http://djmissbliss.com/zolse.html > http://djmissbliss.com/zolse.html </a>  gas remedies natural',	''),
(640,	3,	123,	'7',	'Bogdantpw',	''),
(641,	3,	123,	'8',	'u.s.e.r.z.al.ev.skija22201@gmail.com',	''),
(642,	3,	123,	'4',	'(350) 637-4767',	''),
(643,	3,	123,	'6',	'Getting some information',	''),
(644,	3,	123,	'5',	'Доброго времени суток господа! \r\nПредлагаем Вашему вниманию изделия из стекла для дома и офиса.Наша организация ООО «СТЕКЛОЭЛИТ» работает 10 лет на рынке этой продукции в Беларуси.Хозяева квартир, загородных домов, коттеджей, а также офисных и торговых помещений для обустройства проемов все чаще выбирают двери из закаленного стекла. Такой материал неспроста стал популярен. По прочности и звукоизоляции стекло не уступает деревянным полотнам, а по износостойкости в разы превосходит другие классиче',	''),
(645,	3,	124,	'7',	'Erikawn',	''),
(646,	3,	124,	'8',	'martapp7s@aol.com',	''),
(647,	3,	124,	'4',	'(564) 636-0084',	''),
(648,	3,	124,	'6',	'Getting some information',	''),
(649,	3,	124,	'5',	'Hey dear!! Im looking a lover.. \r\nDo you want to see a beautiful female body? Here are my erotic photos - bit.ly/3i3RAqe',	''),
(650,	3,	125,	'7',	'Accounting, finance',	''),
(651,	3,	125,	'8',	'johnmcdaniel3219@gmail.com',	''),
(652,	3,	125,	'4',	'(480) 033-0632',	''),
(653,	3,	125,	'6',	'Investing in a property',	''),
(654,	3,	125,	'5',	'Посмотрите, что нашел пользователь Insta_Oil (instaoil) на Pinterest — самой большой в мире коллекции идей. \r\ninsta_oil@icloud.com',	''),
(655,	3,	126,	'7',	'Brianvom',	''),
(656,	3,	126,	'8',	'D.e.ann.Bu.c.k.4@gmail.com',	''),
(657,	3,	126,	'4',	'(827) 326-3850',	''),
(658,	3,	126,	'6',	'Investing in a property',	''),
(659,	3,	126,	'5',	'<a href=https://creditrepairlasvegas.xyz>creditrepairlasvegas.xyz </a>',	''),
(660,	3,	127,	'7',	'CharlesFoort',	''),
(661,	3,	127,	'8',	'ronaldgaines4799@gmail.com',	''),
(662,	3,	127,	'4',	'(268) 352-4355',	''),
(663,	3,	127,	'6',	'Getting some information',	''),
(664,	3,	127,	'5',	'Нежели обширнее объем аудитории, этим подороже стоит рекламное объявление. Однако так как проблема никак не во числе, но во привлечении покупателей, причастных во предлагаемых предложениях, во нашем случае, во получении вспомогательного создания. Данная публикация сможет помочь для вас исключить несостоятельного нос маркетингового бютжета, вам осознаете, во котором течении необходимо передвигаться, для того чтобы достичь наибольшей эффективности с приложенных денег. \r\n \r\n<a href=https://distriks',	''),
(665,	3,	128,	'7',	'ZirlVitaHeixtumma',	''),
(666,	3,	128,	'8',	'oct12@info89.ru',	''),
(667,	3,	128,	'4',	'(560) 427-5301',	''),
(668,	3,	128,	'6',	'Getting some information',	''),
(669,	3,	128,	'5',	'<a href=\" https://скачатьвидеосютуба.рф/watch/JeqihG8IjpQ \"> Скачать ОХОТА НА ДЕЛЬФИНА №2  | АНТОН ШАСТУН И ДИМА ПОЗОВ</a><br />Закажи Tinkoff Black и получи бесплатное обслуживание навсегда — https://l.tinkoff.ru/slowslowcowoct<br />____________________________________<br />ГОСТИ:...<br /><a href=\" https://скачатьвидеосютуба.рф/watch/OToumvUw_sg \"> Скачать Обнаглевшие дети путинской элиты</a><br />Высокие должности в правительстве, госкорпорациях и крупном бизнесе в России практически невозможн',	''),
(670,	3,	129,	'7',	'Human',	''),
(671,	3,	129,	'8',	'collinsbrice50@gmail.com',	''),
(672,	3,	129,	'4',	'(813) 513-5407',	''),
(673,	3,	129,	'6',	'Investing in a property',	''),
(674,	3,	129,	'5',	'Покердом — знаменитая платформа с целью вид развлечения во игра в местности Российской Федерации. Игра-рум стал собственную службу во 2014 г.. Порядочность обеспечивается лицензированием софта игровыми комиссиями iTech Labs также Gaming Labs. Рум дает бумаги, доказывающие контроль ГСЧ согласно спросу во работу помощи. \r\n<a href=https://from-chef.ru/>https://from-chef.ru/</a>',	''),
(675,	3,	130,	'7',	'Nadiajaics',	''),
(676,	3,	130,	'8',	'markmorozov212@gmail.com',	''),
(677,	3,	130,	'4',	'(035) 704-0764',	''),
(678,	3,	130,	'6',	'Getting some information',	''),
(679,	3,	130,	'5',	'<b>Споты и их место в интерьере</b> \r\nМагазины, которые специализируются на осветительных приборах, предоставляют обширный ассортимент товаров. Выбрать осветительные приборы можно на любой вкус. Многие из них выполняют декоративную функцию, придавая интерьеру изюминку. У большинства осветительных элементов есть практическая функция. Они украсят комнату и придадут ей особый вид. \r\n<a href=https://svetlike.ru/catalog/spoty>спот светильники</a> сегодня очень популярны. С их помощью можно придать ин',	''),
(680,	3,	131,	'7',	'JeniaEr',	''),
(681,	3,	131,	'8',	'arasmout650@gmail.com',	''),
(682,	3,	131,	'4',	'(680) 633-3203',	''),
(683,	3,	131,	'6',	'Investing in a property',	''),
(684,	3,	131,	'5',	'https://prostitutkimsk.net/',	''),
(685,	3,	132,	'7',	'WilliamIllut',	''),
(686,	3,	132,	'8',	'veccanmi@knazdanila.ru',	''),
(687,	3,	132,	'4',	'(542) 382-2470',	''),
(688,	3,	132,	'6',	'Investing in a property',	''),
(689,	3,	132,	'5',	'Sex Doll Big Soft Breast Realistic Vagina Male Masturbator Sex Toys for Men Artificial Pocket Pussy Ass 1:1 Model Copy 6kg/12lb|Masturbators| –128$ \r\n<a href=https://free.webcamsexepute.eu/p12CVS>https://free.webcamsexepute.eu/p12CVS</a>',	''),
(690,	3,	133,	'7',	'StephenAerox',	''),
(691,	3,	133,	'8',	'hp4@4ttmail.com',	''),
(692,	3,	133,	'4',	'(326) 212-6686',	''),
(693,	3,	133,	'6',	'Getting some information',	''),
(694,	3,	133,	'5',	'<a href=https://hairypussypix.com/galleries/see-through-panties-hairy.html>See through panties hairy - hairypussypix.com</a> \r\nhairy porn pics\r\nhairy milf free\r\ntube granny hairy\r\n  <a href=https://hairypussypix.com/galleries/adult-hairy-pussy-pics.html>Adult hairy pussy pics - hairypussypix.com</a> \r\n \r\n<a href=https://animalsave.ru/komandy-spaseniya-porodistyh-zhivotnyh/#comment-8306>teen hairy pussy sex</a> <a href=https://www.globodox.com/blog/how-to-choose-a-document-management-software/#c',	''),
(695,	3,	134,	'7',	'MashaKyTAX0292',	''),
(696,	3,	134,	'8',	'mashakabccbiz4252@cc.com',	''),
(697,	3,	134,	'4',	'(518) 447-0523',	''),
(698,	3,	134,	'6',	'Investing in a property',	''),
(699,	3,	134,	'5',	'You read it - then XEvil 5.0 really works! \r\n \r\nWant to post your text to 12.000.000 (12 MILLIONS!) websites? No problem - with new \"XEvil 5.0 + XRumer 19.0.8\" software complex! \r\nBlogs, forums, boards, shops, guestbooks, social networks - any engines with any captchas! \r\nXEvil also compatible with any SEO/SMM programms and scripts, and can accept captchas from any source. Just try it!  ;) \r\n \r\nRegards, MashaKeTAX8982 \r\n \r\nP.S. Huge discounts are available (up to 50%!) for a short review about',	''),
(700,	3,	135,	'7',	'HenryVed',	''),
(701,	3,	135,	'8',	'ok.o.b.el.ev.ro.8.1.@gmail.com',	''),
(702,	3,	135,	'4',	'(166) 773-1183',	''),
(703,	3,	135,	'6',	'Investing in a property',	''),
(704,	3,	135,	'5',	'remedy intelligent staffing  <a href=  > https://lorazepamnl.alloforum.com </a>  reflux home remedies  <a href= https://stilnoct.mystrikingly.com > https://stilnoct.mystrikingly.com </a>  yeast infection remedies',	''),
(705,	3,	136,	'7',	'StephenAerox',	''),
(706,	3,	136,	'8',	'hp4@4ttmail.com',	''),
(707,	3,	136,	'4',	'(888) 372-8234',	''),
(708,	3,	136,	'6',	'Investing in a property',	''),
(709,	3,	136,	'5',	'<a href=https://hairypussypix.com/galleries/black-hairy-clothed-girls.html>Black hairy clothed girls - hairypussypix.com</a> \r\nhairy pussy defloration\r\nhairy granny pussy hot fucks\r\nhairy pussy mature\r\n  <a href=https://hairypussypix.com/galleries/young-white-hairy-pussy-love-black-cock.html>Young white hairy pussy love black cock - hairypussypix.com</a> \r\n \r\n<a href=http://mgshizuoka.net/yybbs-NEW/yybbs.cgi>hairy anna</a> <a href=https://foodhealthandfitness.com/strengthen-your-familys-immunit',	''),
(710,	3,	137,	'7',	'modRapug',	''),
(711,	3,	137,	'8',	'dds3@m142.ru',	''),
(712,	3,	137,	'4',	'(735) 020-2054',	''),
(713,	3,	137,	'6',	'Getting some information',	''),
(714,	3,	137,	'5',	'Спасибо. Хотел бы с вами поделиться ссылками на интересный сайт, \r\nпроектирование частных котельных\r\n <a href=\"https://m142.ru/\" >https://m142.ru/</a> \r\n<a href=\"\" >газ в частный дом</a> \r\n<a href=\"\" >проектирование модульных котельных</a> \r\nhttps://lincolnsu.com/?URL=m142.ru',	''),
(715,	3,	138,	'7',	'RaymondHot',	''),
(716,	3,	138,	'8',	'averyericay678@gmail.com',	''),
(717,	3,	138,	'4',	'(370) 281-8383',	''),
(718,	3,	138,	'6',	'Investing in a property',	''),
(719,	3,	138,	'5',	'<a href=https://pickity.ru/><img src=\"https://i.ibb.co/WFsBbg3/Screenshot-131.jpg\"></a> \r\n \r\n\r\nКрасивая и стильная одежда, обувь и бренды в одном месте\r\nКаталог одежды для прогулок, отдыха и путешествий, прямая продажа новых и б\\у вещей из женского и мужского гардероба. Бесплатная одежда для новорожденных в детской категории с постоянно пополняемыми объявлениями от частных лиц и предложения магазинов по низкой цене и скидками, а байеры помогут найти любую брендовую одежду и доставят ее вам.',	''),
(720,	3,	139,	'7',	'EarnestTug',	''),
(721,	3,	139,	'8',	'gruzdev.ax@gmail.com',	''),
(722,	3,	139,	'4',	'(266) 206-0185',	''),
(723,	3,	139,	'6',	'Investing in a property',	''),
(724,	3,	139,	'5',	'<a href=\"https://agruzdev.com/\" title=\"Инфоцыган Алексей Груздев\">Инфоцыган Алексей Груздев</a>',	''),
(725,	3,	140,	'7',	'RandallUnivy',	''),
(726,	3,	140,	'8',	'sergeev-nikita.1990152@mail.ru',	''),
(727,	3,	140,	'4',	'(537) 230-2428',	''),
(728,	3,	140,	'6',	'Investing in a property',	''),
(729,	3,	140,	'5',	'Yahwe <a href=https://yahwe.ru/>Yahwe</a>',	''),
(730,	3,	141,	'7',	'RanrrRap',	''),
(731,	3,	141,	'8',	'gdeg@m142.ru',	''),
(732,	3,	141,	'4',	'(431) 811-2742',	''),
(733,	3,	141,	'6',	'Getting some information',	''),
(734,	3,	141,	'5',	'Cпасибо за информацию \r\n<a href=\"https://worldgreatsuccess.ru/\r\n\">https://worldgreatsuccess.ru/\r\n</a>',	''),
(735,	3,	142,	'7',	'Matthewwitle',	''),
(736,	3,	142,	'8',	'yerterwefer@yandex.com',	''),
(737,	3,	142,	'4',	'(171) 560-5300',	''),
(738,	3,	142,	'6',	'Investing in a property',	''),
(739,	3,	142,	'5',	'Ремонтируем планшеты и другую компьютерную технику у вас на дому и в офисе. \r\nВыезд инженера бесплатный. Оплачивается только ремонт. Первичная диагностика неисправности бесплатна. \r\nПодробные цены на работы на нашем <a href=https://helpforcomp.org.ru/>сайте</a> \r\nЗанимаемся как программным так и аппаратным ремонтом. \r\nУстановка и настройка программ, переустановка Windows, настройка интернета. \r\nЧестка компьютеров и ноутбуков с полной или частичной разборкой. \r\nПерепайка smd компонентов плат. \r\n<',	''),
(740,	3,	143,	'7',	'Darwinset',	''),
(741,	3,	143,	'8',	'w.aserio.k2.10@gmail.com',	''),
(742,	3,	143,	'4',	'(365) 143-8082',	''),
(743,	3,	143,	'6',	'Getting some information',	''),
(744,	3,	143,	'5',	'Slot machines games to play for free  <a href=https://sites.google.com/view/slot-apps-that-pay-real-money-/>all casino slot games </a>  new online casinos australia 2021 no deposit  \r\nBest slots to play in vegas 2021  <a href=https://sites.google.com/view/slotsvillacasinonodepositbonus/>casino slot games with bonus </a>  free no deposit casino bonus codes usa 2021  \r\nSlot machine games that payout real money  <a href=https://blackjackonlinecasinorealmoney.blogspot.com/>caesars casino free slots',	''),
(745,	3,	144,	'7',	'Terrylorry',	''),
(746,	3,	144,	'8',	'sportsbettingtipstricks@gmail.com',	''),
(747,	3,	144,	'4',	'(768) 018-2401',	''),
(748,	3,	144,	'6',	'Investing in a property',	''),
(749,	3,	144,	'5',	'We have lots of articles about slot machines, covering all sorts of topics. We start with the basics - how to play slots: \r\n \r\nWe have lots more articles too. See below for some examples. As with all our blog articles, each one has a free game embedded in it, just in case you want to discover them for yourself. \r\n \r\nThen the next most popular questions we get are about winning, including how to win at slots. We also ask ourselves whether there strategies that work? \r\n \r\nSlots Strategies - Do the',	''),
(750,	3,	145,	'7',	'JordonWaync',	''),
(751,	3,	145,	'8',	'samanta.weronska@interia.pl',	''),
(752,	3,	145,	'4',	'(335) 043-6734',	''),
(753,	3,	145,	'6',	'Getting some information',	''),
(754,	3,	145,	'5',	'https://chancegdgj605.godaddysites.com/f/jogging-personalny-%E2%80%93-czemu-warto-si%C4%99-na-niego-obgada%C4%87 \r\nhttps://trevorvmat244.wordpress.com/2021/08/30/instruktaz-kadrowiec-przecz-nalezaloby-sie-na-niego-ustalic/ \r\nhttp://emiliogbth324.simplesite.com/450390752 \r\nhttps://canvas.instructure.com/eportfolios/447413/emilianoxdec555/Wysiek_personalny__dlaczego_o_si_na_niego_przedsiwzi \r\nhttp://dominickxege325.hpage.com/post1.html \r\nhttp://trevorxvyr799.iamarrows.com/ruch-osobisty-czegoz-o-si',	''),
(755,	3,	146,	'7',	'Robertfoend',	''),
(756,	3,	146,	'8',	'herbion.feruz@mail.ru',	''),
(757,	3,	146,	'4',	'(721) 883-5532',	''),
(758,	3,	146,	'6',	'Investing in a property',	''),
(759,	3,	146,	'5',	'Воздушные шары - это фантастические, дешевые и праздничные украшения для дома. Воздушные шары вдохновляют и волнуют. Мы делимся коллекцией домашней мебели, создание которой было навеяно воздушными шарами и красочными идеями украшения интерьера, которые используют воздушные шары для создания веселых комнат. \r\nДекорирование интерьера воздушными шарами идеально подходит для подготовки всевозможных пространств к различным мероприятиям. Для всех праздников и специальных мероприятий, от дней рождений,',	''),
(760,	3,	147,	'7',	'StephenAerox',	''),
(761,	3,	147,	'8',	'hp4@4ttmail.com',	''),
(762,	3,	147,	'4',	'(331) 445-6020',	''),
(763,	3,	147,	'6',	'Investing in a property',	''),
(764,	3,	147,	'5',	'<a href=https://hairypussypix.com/galleries/xxx-big-ass-photo.html>XXX big ass photo - hairypussypix.com</a> \r\njungle hairy pussy\r\namateur hairy pics\r\nhairry sexy pussy\r\n  <a href=https://hairypussypix.com/galleries/hairy-teen-pussy-gloria.html>Hairy teen pussy Gloria - hairypussypix.com</a> \r\n \r\n<a href=https://maureensgems.webs.com/apps/guestbook/>hairy porno ass</a> <a href=http://ecolog-rk.ru/component/k2/item/2/>hot sexy hairy old mom with heavy armpit hair</a> <a href=https://acecyber.xyz',	''),
(765,	3,	148,	'7',	'Jimmyunres',	''),
(766,	3,	148,	'8',	'jeansanchez4859@gmail.com',	''),
(767,	3,	148,	'4',	'(240) 755-0044',	''),
(768,	3,	148,	'6',	'Investing in a property',	''),
(769,	3,	148,	'5',	'Абакан Chiptuning чип тюнинг Stage1 Stage2 с замером на Диностенде dynomax 5000 awd,удаление AdBlue,DPF,EGR,E2,Valvematic,и др.тел.8-923-595-1234 \r\nhttps://www.instagram.com/carteams_abakan_chiptuning/ \r\nhttps://radikal.ru - https://d.radikal.ru/d23/2111/18/c43b6d08832d.png \r\nhttps://radikal.ru - https://b.radikal.ru/b43/2111/03/0c0cae8414d4.jpg',	''),
(770,	3,	149,	'7',	'Joannap9',	''),
(771,	3,	149,	'8',	'annayc8a@hotmail.com',	''),
(772,	3,	149,	'4',	'(271) 563-3466',	''),
(773,	3,	149,	'6',	'Investing in a property',	''),
(774,	3,	149,	'5',	'Hey .. Im looking a man.. \r\nI want sex! Write me - tinyurl.com/yhbsu4l3',	''),
(775,	3,	150,	'7',	'Marionmox',	''),
(776,	3,	150,	'8',	'sasha-kropotov_19756@mail.ru',	''),
(777,	3,	150,	'4',	'(475) 352-1101',	''),
(778,	3,	150,	'6',	'Getting some information',	''),
(779,	3,	150,	'5',	'hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid.onion \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7cid.com>hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid.onion</a>',	''),
(780,	3,	151,	'7',	'Rogerfaw',	''),
(781,	3,	151,	'8',	'alena.petrova.1990584@mail.ru',	''),
(782,	3,	151,	'4',	'(150) 758-0015',	''),
(783,	3,	151,	'6',	'Getting some information',	''),
(784,	3,	151,	'5',	'<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7ncid.com>hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid.onion</a> \r\n \r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7ncid.com',	''),
(785,	3,	152,	'7',	'OlegOl',	''),
(786,	3,	152,	'8',	'bransanuta@gmail.com',	''),
(787,	3,	152,	'4',	'(711) 222-3164',	''),
(788,	3,	152,	'6',	'Getting some information',	''),
(789,	3,	152,	'5',	'То о чем многие просто не задумываются, и другие интересные и важные темы на пример “ <a href=https://blogforgirls.ru/?p=1018>  когда мужчина врет </a> \r\n” раскрыты в интернет ресурсе.',	''),
(790,	3,	153,	'7',	'RobertMer',	''),
(791,	3,	153,	'8',	'bt1@4ttmail.com',	''),
(792,	3,	153,	'4',	'(153) 371-0377',	''),
(793,	3,	153,	'6',	'Getting some information',	''),
(794,	3,	153,	'5',	'Ultimate accumulation of hefty tit moms fuck pics and kind immense boob babes. \r\nThe hottest grate\'s busty babes and Great tits women are all gained togeather here at Big Tits On. Area contains: busty babes, busty girls, busty women, sophisticated great tits, big boobs, socking tit fuck, arrogantly natural tits, risqu‚ juggs, horny busty milfs!!! \r\n \r\nhttps://www.sexybbb.com/ \r\ngrannies with huge tits huge pussy porn\r\nbiggest tite boobs\r\nanal big tite\r\n \r\n \r\n<a href=http://cuentameuncuento.es/in',	''),
(795,	3,	154,	'7',	'prunrxdp',	''),
(796,	3,	154,	'8',	'gnpqqkyuo@riador.online',	''),
(797,	3,	154,	'4',	'(486) 528-2688',	''),
(798,	3,	154,	'6',	'Investing in a property',	''),
(799,	3,	154,	'5',	'best male enhancement pill  https://viagaracom.com/ - generic viagra 100mg  \r\ndiscount viagra  \r\norder generic viagra  <a href=https://viagaracom.com/>canadian pharmacies</a>  buy viagra online without subscription',	''),
(800,	3,	155,	'7',	'DavidAgino',	''),
(801,	3,	155,	'8',	'vpolakov468@gmail.com',	''),
(802,	3,	155,	'4',	'(818) 186-8821',	''),
(803,	3,	155,	'6',	'Getting some information',	''),
(804,	3,	155,	'5',	'Здравствуйте. \r\n \r\nЗанимаетесь чип-тюнингом? \r\nГотовы предложить услуги по калибровке прошивок на иностранные автомобили. \r\nДелаем отключение Евро2 DPF EGR CAT FAP NOx_off \r\nУвеличение мощности STAGE1/STAGE2 \r\nОтключение off O2 Sensor, Adblue (Euro-4/5), SCR, VSA, SWIRL TVA removal, TOYOTA Valvematic, SpeedLimit \r\nhttps://i.ibb.co/nMvTLpV/winols-1.png \r\nПостоянным клиентам скидки! \\ discounts for regular customers! \r\nГарантия; возврат средств. \r\n \r\nЗАКАЗАТЬ ПРОШИВКУ можно по почте, либо написать',	''),
(805,	3,	156,	'7',	'DavidEtexy',	''),
(806,	3,	156,	'8',	'tp1@4ttmail.com',	''),
(807,	3,	156,	'4',	'(004) 313-0861',	''),
(808,	3,	156,	'6',	'Getting some information',	''),
(809,	3,	156,	'5',	'Thousands of pics galleries to nip it inaccurate every daylight after released! Teen handjobs, moms with huge hooters, wayward naked babes and multifarious more. \r\nAll pics with distinction hi-res opening thumbnail and all galleries are sorted past categories to resist you get what you appetite faster. Enjoy. \r\n \r\nhttps://www.teenspornhd.net/ \r\nwatch teen porn\r\nchubby teen girl thumbs\r\nbig cock with teens\r\n \r\n<a href=https://www.anchorfencecontractors.com/blog/gallery/pvc-vinyl-fencing-company/#',	''),
(810,	3,	157,	'7',	'Amber0k',	''),
(811,	3,	157,	'8',	'julieeha5@yahoo.com',	''),
(812,	3,	157,	'4',	'(436) 024-3714',	''),
(813,	3,	157,	'6',	'Investing in a property',	''),
(814,	3,	157,	'5',	'Hey ... Im looking a man!! \r\nI love sex. Write me - bit.ly/39yOyWl',	''),
(815,	3,	158,	'7',	'Calvinmem',	''),
(816,	3,	158,	'8',	'mareksamoker@o2.pl',	''),
(817,	3,	158,	'4',	'(581) 635-8608',	''),
(818,	3,	158,	'6',	'Investing in a property',	''),
(819,	3,	158,	'5',	'Coin Master Niezyskowne Kręty 2021 Niezyskowne Kręty do Coin Master \r\n \r\nCoin Master teraźniejsze ułatwiona, objazdowa maniera, z nadzwyczajnie zaznaczonymi detalami rozpoznawalnymi dla atrakcji chaotycznych i karcianych. Wytwórczość ułatwia sytuowanie osobnej wsi jarlów, zaś tudzież oskarżanie aglomeracji nałożonych poprzez komputer smakuj nowe białogłowy. Wewnątrz sporządzenie a wyjście niniejszego s',	''),
(820,	3,	159,	'7',	'MariaWriff',	''),
(821,	3,	159,	'8',	'moongpoun81@yandex.com',	''),
(822,	3,	159,	'4',	'(774) 331-1012',	''),
(823,	3,	159,	'6',	'Investing in a property',	''),
(824,	3,	159,	'5',	'You read it? Then XRumer and XEvil works! \r\n \r\nWant to post your promo to 12.000.000 (12 MILLIONS!) websites? No problem - with new \"XEvil 5.0 + XRumer 19.0.8\" software complex! \r\nBlogs, forums, boards, shops, guestbooks, social networks - any engines with any captchas! \r\nXEvil also compatible with any SEO/SMM programms and scripts, and can accept captchas from any source. Just try it!  ;) \r\n \r\nRegards, MashaKaTAX0417 \r\n \r\nP.S. Huge discounts are available (up to 50%!) for a short review about',	''),
(825,	3,	160,	'7',	'WilliamKew',	''),
(826,	3,	160,	'8',	'dorothytawnya@onebyair.com',	''),
(827,	3,	160,	'4',	'(646) 367-8042',	''),
(828,	3,	160,	'6',	'Getting some information',	''),
(829,	3,	160,	'5',	'High Quality Contextual Backlinks are The Most Important Factor Of Google Ranking. \r\n \r\n \r\n \r\n100 X  Quality IMPROVED \r\n \r\n \r\n \r\n \r\n \r\nRank Your Website High on Search Engine And Get More organic Traffic To your Website/Blog \r\n \r\n \r\n \r\nThis is 1# SEO Backlinks Service On Ebay. \r\n \r\n \r\n \r\nNEVER BE LATE GROW YOUR Organic Ranking \r\n \r\n \r\n \r\nFEATURES of My Service: \r\n \r\n \r\n \r\nBuild High Quality SEO Contextual Backlinks \r\nThis Will Improve Your Page Authority & URL Rating DA/DR and Ranking On search',	''),
(830,	3,	161,	'7',	'Jasonseiny',	''),
(831,	3,	161,	'8',	'davidFeake211@cutey.com',	''),
(832,	3,	161,	'4',	'(465) 301-2117',	''),
(833,	3,	161,	'6',	'Getting some information',	''),
(834,	3,	161,	'5',	'Mexican border pharmacies ^ without a doctors prescription in usa \r\n* Customer Support Center 365\\24\\7 \r\n* Delivery methods: EMS, AirMail. \r\n* without a doctor\'s prescription in usa \r\n \r\n<a href=https://is.gd/midbnQ>Pharmaceuticals online</a> \r\n \r\nProcardia\r\nCareprost\r\nErectafil\r\nRemeron\r\nPlendil\r\nDeltasone\r\nCoreg\r\nPrometrium\r\nCaverta\r\nZithromax\r\nKamagra Super\r\nVasodilan\r\nCipro\r\nNitrofurantoin\r\nMeclizine\r\nCabgolin\r\nCardura\r\nClaritin\r\nSinequan\r\nEntocort',	''),
(835,	3,	162,	'7',	'Larrytuh',	''),
(836,	3,	162,	'8',	'%spinfile-names.dat%%spinfile-lnames.dat%%random-1-100%@base.mixwi.com',	''),
(837,	3,	162,	'4',	'(531) 706-8670',	''),
(838,	3,	162,	'6',	'Investing in a property',	''),
(839,	3,	162,	'5',	'Trusted Online Casino Malaysia   http://gm231.com/download-now/#Game Mania - Click here!',	''),
(840,	3,	163,	'7',	'Miriamyl',	''),
(841,	3,	163,	'8',	'sophiaup30@aol.com',	''),
(842,	3,	163,	'4',	'(785) 823-6476',	''),
(843,	3,	163,	'6',	'Investing in a property',	''),
(844,	3,	163,	'5',	'Hello dear!! Im looking a man.. \r\nI love sex. Write me - tinyurl.com/yf2eydcp',	''),
(845,	3,	164,	'7',	'Jasonseiny',	''),
(846,	3,	164,	'8',	'davidFeake015@alumnidirector.com',	''),
(847,	3,	164,	'4',	'(204) 830-1133',	''),
(848,	3,	164,	'6',	'Investing in a property',	''),
(849,	3,	164,	'5',	'Canadian pharmacy drugs online & purchase online without prescription \r\n* Customer Support Center 365\\24\\7 \r\n* Delivery methods: EMS, AirMail. \r\n* purchase online without prescription \r\n \r\n<a href=https://rautorci.webcindario.com>Pharmaceuticals online</a> \r\n \r\nOmnicef\r\nCialis Sublingual\r\nCefixime\r\nColospa\r\nCitalopram\r\nNimotop\r\nKemadrin\r\nFildena\r\nLevlen\r\nLevitra Super Active\r\nViagra Extra Dosage\r\nLexapro\r\nRetin-A Gel 0,1\r\nNPXL\r\nCialis Professional\r\nZanaflex\r\nColchicine\r\nAshwagandha\r\nCozaar\r\nProc',	''),
(850,	3,	165,	'7',	'Jeffreysap',	''),
(851,	3,	165,	'8',	'fomina.sveta_918937@mail.ru',	''),
(852,	3,	165,	'4',	'(561) 428-0036',	''),
(853,	3,	165,	'6',	'Investing in a property',	''),
(854,	3,	165,	'5',	'hydraruzxpnew4af.onion\r\nссылка на гидру\r\nновая ссылка гидра\r\nгидра сайт\r\nhydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid.onion\r\n \r\n<a href=https://hydraruzxpnew4af.onion-market50.com/>hydraruzxpnew4af.onion</a>',	''),
(855,	3,	166,	'7',	'Anitaqo',	''),
(856,	3,	166,	'8',	'janety3dt@gmail.com',	''),
(857,	3,	166,	'4',	'(047) 516-7237',	''),
(858,	3,	166,	'6',	'Investing in a property',	''),
(859,	3,	166,	'5',	'hello baby.. my name Brenda.. \r\nI dream of hard sex. Write me on this site - bit.ly/3lpKP3z',	''),
(860,	3,	167,	'7',	'Nataneele',	''),
(861,	3,	167,	'8',	'woodthighgire1988@gmail.com',	''),
(862,	3,	167,	'4',	'(822) 440-8305',	''),
(863,	3,	167,	'6',	'Getting some information',	''),
(864,	3,	167,	'5',	'If you Want Private Videos, Look this https://localchicks3.com/?u=41nkd08&o=8dhpkzk',	''),
(865,	3,	168,	'7',	'notwceop',	''),
(866,	3,	168,	'8',	'ebnkcqcwe@vigabigo.online',	''),
(867,	3,	168,	'4',	'(802) 075-7077',	''),
(868,	3,	168,	'6',	'Getting some information',	''),
(869,	3,	168,	'5',	'cialis online usa  https://cialisara.com/# - when will cialis be generic  \r\ntadalafil tablets 20mg  \r\ncialis price walmart  <a href=https://cialisara.com/>cialis pill</a>  goodrx cialis',	''),
(870,	3,	169,	'7',	'Orlandoduh',	''),
(871,	3,	169,	'8',	'belov.danil.808@mail.ru',	''),
(872,	3,	169,	'4',	'(752) 311-6616',	''),
(873,	3,	169,	'6',	'Investing in a property',	''),
(874,	3,	169,	'5',	'joycasino \r\n \r\n<a href=https://play.google.com/store/apps/details?id=com.joycasino.application>joycasino</a>',	''),
(875,	3,	170,	'7',	'hydraruzxpnew4afron',	''),
(876,	3,	170,	'8',	'ke6lkeldrar@hydraruzxpnew4fa.co',	''),
(877,	3,	170,	'4',	'(215) 274-1226',	''),
(878,	3,	170,	'6',	'Investing in a property',	''),
(879,	3,	170,	'5',	'<a href=https://hydraruzxpnew4afonlon.com><img src=\"https://v3.hydraruzxpnew4fa.co/login.png\"></a> ссылка гидра зеркало - https://tor.hydraruzxpnew4af.com.co - ГИДРА site официальный имеет множество зеркал, на случай вы забанены, onion, высокой нагрузки или DDoS атак. Пользуйтесь ссылкой выше v3.hydraruzxpnew4fa.co для создания безопасного conversations соединения с сетью TOR и открытия рабочего зеркала. Также hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid высокой нагрузки или DDoS ата',	''),
(880,	3,	171,	'7',	'casino-x.center',	''),
(881,	3,	171,	'8',	'topkreditka13@mail.ru',	''),
(882,	3,	171,	'4',	'(203) 410-2870',	''),
(883,	3,	171,	'6',	'Investing in a property',	''),
(884,	3,	171,	'5',	'Добрый день! Мы рады приветствовать вас на страницах нашего блога об азартных играх! \r\n \r\nВ настоящее время в результате большой конкуренции среди интернет казино вынуждены выдавать гемблерам хорошие условия сотрудничества, для получения больше новых игроков в своих казино. \r\nПри этом каждая азартная площадка пытается дать нечто неповторимое в своих условиях сотрудничества. \r\nК примеру, упрощенный процесс обналичивания выигрышей. \r\nДля начинающего игрока этот факт является наиболее важным. В сле',	''),
(885,	3,	172,	'7',	'ConlVitaHeixtumma',	''),
(886,	3,	172,	'8',	'dec12@info89.ru',	''),
(887,	3,	172,	'4',	'(754) 865-2532',	''),
(888,	3,	172,	'6',	'Investing in a property',	''),
(889,	3,	172,	'5',	'<a href=\" https://скачатьвидеосютуба.рф/watch/73-CnQLRZv4 \"> Скачать ВОТ ЧТО МЫ КУПИЛИ НА ALIEXPRESS</a><br />Возвращай горящий кэшбэк с LetyShops и выигрывай Теслу - https://letyshops.onelink.me/zrnH/b54b9ffa<br />Расширение для Aliexpress, динамика...<br /><a href=\" https://скачатьвидеосютуба.рф/watch/Jo-DhJonI6w \"> Скачать Кадыров поручил наказать Турцию за парк им. Джохара Дудаева</a><br />Стань моим Патроном:<br />Patreon: http://patreon.com/abusaddamshishani<br />Донат: http://www.donation',	''),
(890,	3,	173,	'7',	'Isaacgat',	''),
(891,	3,	173,	'8',	'valentin.golubtsov-975104@mail.ru',	''),
(892,	3,	173,	'4',	'(852) 571-7675',	''),
(893,	3,	173,	'6',	'Getting some information',	''),
(894,	3,	173,	'5',	'hydrarusawyg5ykmsgvnyhdumzeawp465jp7zhynyihexdv5p74etnid.onion \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7d-onion-shop.com/>hydra сайт</a>',	''),
(895,	3,	174,	'7',	'ElceZORSE',	''),
(896,	3,	174,	'8',	'guy@teamspeakradioguy.com',	''),
(897,	3,	174,	'4',	'(850) 182-4828',	''),
(898,	3,	174,	'6',	'Getting some information',	''),
(899,	3,	174,	'5',	'CS GO - Why people never quits \r\n \r\nCounter Strike Global Offensive is the most recognized and most played multiplayer first person shooter till now. The game is being played in every landscape of the world. Definitely in, every gaming zone, in every Pcs and Laptop and even on all Xbox machine. \r\nCS Source: \r\n \r\nCounter Strike Condition Zero is actually a modification of the Half-life game which had already been released in the late 1990\'s. This first person shooter game is a tactical and aiming',	''),
(900,	3,	175,	'7',	'CarlosFek',	''),
(901,	3,	175,	'8',	'timofeev.volodia1983071@mail.ru',	''),
(902,	3,	175,	'4',	'(215) 814-1625',	''),
(903,	3,	175,	'6',	'Investing in a property',	''),
(904,	3,	175,	'5',	'новая ссылка гидра \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jonion7nchid.com/>hydrarusoeitpwagsnukxyxkd4copuuvio52k7hd6qbabt4lxcwnbsad.onion</a>',	''),
(905,	3,	176,	'7',	'Sandra Smith',	''),
(906,	3,	176,	'8',	'no-replyGigmani@gmail.com',	''),
(907,	3,	176,	'4',	'(555) 414-2277',	''),
(908,	3,	176,	'6',	'Investing in a property',	''),
(909,	3,	176,	'5',	'Hi!  graygroupla.com \r\n \r\nWe make offer for you \r\n \r\nSending your commercial proposal through the feedback form which can be found on the sites in the Communication section. Contact form are filled in by our program and the captcha is solved. The superiority of this method is that messages sent through feedback forms are whitelisted. This technique raise the probability that your message will be read. \r\n \r\nOur database contains more than 27 million sites around the world to which we can send you',	''),
(910,	3,	177,	'7',	'joiwdrva',	''),
(911,	3,	177,	'8',	'jbtequczb@vigabigo.online',	''),
(912,	3,	177,	'4',	'(788) 207-7620',	''),
(913,	3,	177,	'6',	'Getting some information',	''),
(914,	3,	177,	'5',	'buy generic cialis  https://cialisara.com/ - cialis 20  \r\ncialis 5mg price walmart  \r\ncialis discount  <a href=https://cialisara.com/>cialis savings card</a>  when to take cialis',	''),
(915,	3,	178,	'7',	'AvatarIIpn',	''),
(916,	3,	178,	'8',	'avatar2022oskar@gmail.com',	''),
(917,	3,	178,	'4',	'(120) 282-7308',	''),
(918,	3,	178,	'6',	'Investing in a property',	''),
(919,	3,	178,	'5',	'Величественней, чем Аватар второй! АГЕНТЛОТТО.COM анонсирует усовершенствованный сайт! Скоро — Интерактивные методы выигрыша джек-пота! \r\n \r\nКажется, Leonardo DiCaprio так не радовался долгожданному Оскару, как Agent Lotto — своему обновленному сайту. \r\nВсе верно, друзья, этот знаменательный день наконец-то настал — LAgent отмечает \"новоселье\"! \r\n \r\n<b>Что примечательного и захватывающего в свежей версии?</b> \r\n- Сайт получился простым в использовании, сочным и модерновым. \r\n- Буквально каждый е',	''),
(920,	3,	179,	'7',	'Odelltv',	''),
(921,	3,	179,	'8',	'levono7jn@hotmail.com',	''),
(922,	3,	179,	'4',	'(431) 573-7186',	''),
(923,	3,	179,	'6',	'Investing in a property',	''),
(924,	3,	179,	'5',	'The most exciting games of 18+. Fuck anyone! Fuck as you want!!  Play game HERE - chilp.it/ca54219',	''),
(925,	3,	180,	'7',	'men',	''),
(926,	3,	180,	'8',	'9rszndpe@gmail.com',	''),
(927,	3,	180,	'4',	'(241) 513-7216',	''),
(928,	3,	180,	'6',	'Investing in a property',	''),
(929,	3,	180,	'5',	'Hi, this is Anna. I am sending you my intimate photos as I promised. https://tinyurl.com/y4g4on4r',	''),
(930,	3,	181,	'7',	'RichardMap',	''),
(931,	3,	181,	'8',	'dawid.molerski@wp.pl',	''),
(932,	3,	181,	'4',	'(142) 480-6124',	''),
(933,	3,	181,	'6',	'Investing in a property',	''),
(934,	3,	181,	'5',	'Jak przepisać mieszkanie? Darowizna \r\nDarowizna mieszkania, to strategia dania racje swojego majątku – nieruchomości – na sprawa innych postaci. Bardzo często, darowizna mieszkania, podawana jest przez rodziców, aby wspomóc młodsze pokolenie na wyjeździe samodzielnego życia. Zwłaszcza, że najdrożsi darczyńcy, nie dadzą z napisu takiego dania, żadnego podatku. Jak dać mieszkanie w darowiźnie? Kto nie',	''),
(935,	3,	182,	'7',	'WesleyBap',	''),
(936,	3,	182,	'8',	'olegbajbulin@gmail.com',	''),
(937,	3,	182,	'4',	'(516) 480-2621',	''),
(938,	3,	182,	'6',	'Investing in a property',	''),
(939,	3,	182,	'5',	'Коль представить, сколько свадьба — это музыкальное работа, то организатор – это его сочинитель и дирижер. Дабы данное поделка было возведено в степень искусства, нуждаться, воеже оно безупречно прозвучало, совершенно аккорды были подобраны верно, а исполнители ни разу не сфальшивили. Ради этим искусством стоит великий труд, судьба и опыт его создателей – организаторов свадьбы. \r\nДля нас нет нуль невозможного. Ваши мечты - наше вдохновение. Давайте начнём вашу семейную историю с красивого незабы',	''),
(940,	3,	183,	'7',	'WheelBen',	''),
(941,	3,	183,	'8',	'robneubs4300@list.ru',	''),
(942,	3,	183,	'4',	'(605) 366-4035',	''),
(943,	3,	183,	'6',	'Getting some information',	''),
(944,	3,	183,	'5',	'asian lesbian porn videos brittanya 187 porn harley quinn lesbian porn skinny porn hd porn arabian colombian prostitute porn horse creampie porn porn withdrawal drunk friend porn not cheating porn santa elf porn freya mayer porn free first timer porn free cellphone porn male porn gif  <a href=https://web-optimum.ru/>legs wide open porn </a> long hair porn chubby lingerie porn mega link porn taimanin asagi porn shemale fucks guy porn furry wolf porn chubby panty porn ad porn porn hottie molly o d',	''),
(945,	3,	184,	'7',	'Janetepfeffc',	''),
(946,	3,	184,	'8',	'janeWreksbefbd@gmail.com',	''),
(947,	3,	184,	'4',	'(017) 463-4284',	''),
(948,	3,	184,	'6',	'Getting some information',	''),
(949,	3,	184,	'5',	'XEvil - the best captcha solver tool with unlimited number of solutions, without thread number limits and highest precision! \r\nXEvil 5.0 support more than 12.000 types of image-captcha, included ReCaptcha, Google captcha, Yandex captcha, Microsoft captcha, Steam captcha, SolveMedia, ReCaptcha-2 and (YES!!!) ReCaptcha-3 too. \r\n \r\n1.) Flexibly: you can adjust logic for unstandard captchas \r\n2.) Easy: just start XEvil, press 1 button - and it\'s will automatically accept captchas from your applicati',	''),
(950,	3,	185,	'7',	'Jamesslugh',	''),
(951,	3,	185,	'8',	'ivanova_mariia-922615@mail.ru',	''),
(952,	3,	185,	'4',	'(817) 047-6334',	''),
(953,	3,	185,	'6',	'Investing in a property',	''),
(954,	3,	185,	'5',	'настоящая ссылка на гидру \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid-dark.net>hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid</a> \r\n \r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid-dark.net \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid-dark.net>hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid.onion</a>\r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid-dark.net>гидра сайт',	''),
(955,	3,	186,	'7',	'Jasonsat',	''),
(956,	3,	186,	'8',	'kolesnikova-alena.89679@mail.ru',	''),
(957,	3,	186,	'4',	'(303) 688-1267',	''),
(958,	3,	186,	'6',	'Getting some information',	''),
(959,	3,	186,	'5',	'гидра рабочее зеркало \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid.onion-dark.com>гидра рабочее зеркало</a> \r\n \r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid.onion-dark.com \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid.onion-dark.com>hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid</a>\r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid.onion-dark.com>ссылка на гидру</a>\r\n<a href=ht',	''),
(960,	3,	187,	'7',	'KeithQuerb',	''),
(961,	3,	187,	'8',	'gneyaxiq@servicemailfast.com',	''),
(962,	3,	187,	'4',	'(254) 038-2331',	''),
(963,	3,	187,	'6',	'Getting some information',	''),
(964,	3,	187,	'5',	'online casinos accepting echeck deposits <a href=\"https://bangshotcasino.com/\">real vegas casino slot game downloads</a> online casino paypal auszahlung casino accept platinum credit card <a href=https://bangshotcasino.com/>best blackjack online for money</a> reel deal slots downloads pc',	''),
(965,	3,	188,	'7',	'JeniaEr',	''),
(966,	3,	188,	'8',	'arasmout650@gmail.com',	''),
(967,	3,	188,	'4',	'(083) 022-0055',	''),
(968,	3,	188,	'6',	'Getting some information',	''),
(969,	3,	188,	'5',	'Диалоги на тему сексе это првильно и говорить о нем необходимо, а вот львиная доля современных людей стесняються общаться о нем, но на помощь приходят такие блоги как \"intimworldx.ru\". \r\nБлагодоря этим блогам какой угодно человек сможет выяснить чуткости и секреты секса, на веб-сайте сможете найти такие таемы как :\"<a href=https://blogprostitutki.win/?p=320>работницы интима</a>\" и множество другой полезной информации о сексе.',	''),
(970,	3,	189,	'7',	'Nataneele',	''),
(971,	3,	189,	'8',	'woodthighgire1988@gmail.com',	''),
(972,	3,	189,	'4',	'(065) 362-3404',	''),
(973,	3,	189,	'6',	'Getting some information',	''),
(974,	3,	189,	'5',	'Hello handsome! Mature brunette Arina extremely sweet cum, write to her https://chicks-for-you.life/?u=41nkd08&o=8dhpkzk',	''),
(975,	3,	190,	'7',	'DavidAbecy',	''),
(976,	3,	190,	'8',	'riabova.masha-19681219@mail.ru',	''),
(977,	3,	190,	'4',	'(263) 864-5668',	''),
(978,	3,	190,	'6',	'Getting some information',	''),
(979,	3,	190,	'5',	'hydra сайт \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchidonion.online/>hydrarusawyg5ykmsgvnyhdumzeawp465jp7zhynyihexdv5p74etnid.onion</a>',	''),
(980,	3,	191,	'7',	'Dennishog',	''),
(981,	3,	191,	'8',	'o.k..o..b.el.e.v..r..o..8..1.@gmail.com',	''),
(982,	3,	191,	'4',	'(746) 525-6281',	''),
(983,	3,	191,	'6',	'Getting some information',	''),
(984,	3,	191,	'5',	'cold remedies natural  <a href=  > https://www.projectmanagement.com/profile/Clonazepamkopen </a>  home remedy cold  <a href= https://fairygodboss.com/users/profile/eTgRFBZFEe/Comprar-Stilnox-online-sin-receta > https://fairygodboss.com/users/profile/eTgRFBZFEe/Comprar-Stilnox-online-sin-receta </a>  dental health care',	''),
(985,	3,	192,	'7',	'JerryZes',	''),
(986,	3,	192,	'8',	'kvartira38.com@gmail.com',	''),
(987,	3,	192,	'4',	'(411) 602-0316',	''),
(988,	3,	192,	'6',	'Getting some information',	''),
(989,	3,	192,	'5',	'Материально озабочена, жильем озадачена, сексуально обеспечена. \r\nПрактичные статьи:\r\n \r\n<a href=https://orensau.ru/ru/obrazovanie-on-lajn/gde-i-dlya-chego-mozhno-uznat-i',	''),
(990,	3,	193,	'7',	'DouglasBug',	''),
(991,	3,	193,	'8',	'kudriavtseva-lana-8083@mail.ru',	''),
(992,	3,	193,	'4',	'(220) 055-1138',	''),
(993,	3,	193,	'6',	'Getting some information',	''),
(994,	3,	193,	'5',	'hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid.onion \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchd-onion.com>hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid.onion</a> \r\nНе секрет, что основная сложность космического полета – это преодоление земного притяжения. Из-за него каждый килограмм груза обходится в тысячи долларов. И чем дальше предстоит полет, тем он будет дороже. \r\nПоэтому космический лифт – вполне себе выгодное решение такой проблемы. Суть',	''),
(995,	3,	194,	'7',	'men',	''),
(996,	3,	194,	'8',	'irccc8wf@hotmail.com',	''),
(997,	3,	194,	'4',	'(387) 446-3856',	''),
(998,	3,	194,	'6',	'Getting some information',	''),
(999,	3,	194,	'5',	'Hi, this is Irina. I am sending you my intimate photos as I promised. https://tinyurl.com/y8poyl7g',	''),
(1000,	3,	195,	'7',	'WillieBeazy',	''),
(1001,	3,	195,	'8',	'romanandreev3867@topnewsrbk.top',	''),
(1002,	3,	195,	'4',	'(130) 843-4666',	''),
(1003,	3,	195,	'6',	'Getting some information',	''),
(1004,	3,	195,	'5',	'ссылка на гидру \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nid-onion.com>hydraruzxpnew4af</a> \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nid-onion.com>hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid.onion</a>\r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nid-onion.com>hydrarusawyg5ykmsgvnyhdumzeawp465jp7zhynyihexdv5p74etnid.onion</a>\r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nid-oni',	''),
(1005,	3,	196,	'7',	'Sidneydut',	''),
(1006,	3,	196,	'8',	'hgbncvvbcb@rambler.ru',	''),
(1007,	3,	196,	'4',	'(825) 233-6645',	''),
(1008,	3,	196,	'6',	'Getting some information',	''),
(1009,	3,	196,	'5',	'Hi, My name is Alice, I saw you recently - I really liked you, I\'m on a dating site, register and find Alice Marr 24 years old <a href=https://clck.su/uaL2d>https://clck.su/uaL2d</a>',	''),
(1010,	3,	197,	'7',	'Georgeprath',	''),
(1011,	3,	197,	'8',	'kornelijignatov4568@yandex.ru',	''),
(1012,	3,	197,	'4',	'(508) 135-7018',	''),
(1013,	3,	197,	'6',	'Getting some information',	''),
(1014,	3,	197,	'5',	'insta \r\n \r\nhookah.magic_su',	''),
(1015,	3,	198,	'7',	'LindaWhade',	''),
(1016,	3,	198,	'8',	'info@ustalks.xyz',	''),
(1017,	3,	198,	'4',	'(104) 815-3437',	''),
(1018,	3,	198,	'6',	'Investing in a property',	''),
(1019,	3,	198,	'5',	'I am sharing with you a site with a many of web models that you can watch absolutely free. \r\n \r\n<a href=https://ustalks.com/><img src=\"https://ustalks.com/wp-content/uploads/2022/01/logo-2.png\"> </a> \r\n \r\nThe best women from the US show their charms directly online and broadcast themselves naked. \r\n \r\nIn <a href=https://ustalks.com>American porn cam chat</a> huge selection for every taste and color, young and old, fat and thin, women and girls with large and small boobs. \r\n \r\n \r\nAnd a real big s',	''),
(1020,	3,	199,	'7',	'Larrytuh',	''),
(1021,	3,	199,	'8',	'%spinfile-names.dat%%spinfile-lnames.dat%%random-1-100%@base.mixwi.com',	''),
(1022,	3,	199,	'4',	'(682) 552-3215',	''),
(1023,	3,	199,	'6',	'Getting some information',	''),
(1024,	3,	199,	'5',	'Trusted Online Casino Malaysia   http://gm231.com/gm231-best-online-slot-games-malaysia-slots-918kiss-xe88/#{Best Online Slot Games Malaysia | Slots |  - {Online Casino Malaysia|Click here|More info|Show more}{!|...|>>>|!..}',	''),
(1025,	3,	200,	'7',	'MichaelBok',	''),
(1026,	3,	200,	'8',	'conmecelka@mail.ru',	''),
(1027,	3,	200,	'4',	'(473) 201-7213',	''),
(1028,	3,	200,	'6',	'Investing in a property',	''),
(1029,	3,	200,	'5',	'Автоматический заработок,первые деньги уже сегодня! \r\nhttps://vk.cc/c3Rmmr',	''),
(1030,	3,	201,	'7',	'ThanhdeW',	''),
(1031,	3,	201,	'8',	'umzgbccbnb@rambler.ru',	''),
(1032,	3,	201,	'4',	'(581) 607-3551',	''),
(1033,	3,	201,	'6',	'Getting some information',	''),
(1034,	3,	201,	'5',	'Hi, My name is Alice, I saw you recently - I really liked you, I\'m on a dating site, register and find Alice Marr 24 years old <a href=https://clck.su/uaL2d>https://clck.su/uaL2d</a>',	''),
(1035,	3,	202,	'7',	'men',	''),
(1036,	3,	202,	'8',	'9mjg91d9@hotmail.com',	''),
(1037,	3,	202,	'4',	'(655) 544-6280',	''),
(1038,	3,	202,	'6',	'Investing in a property',	''),
(1039,	3,	202,	'5',	'Hi, this is Jenny. I am sending you my intimate photos as I promised. https://tinyurl.com/yayfy8cn',	''),
(1040,	3,	203,	'7',	'JuliaWriff',	''),
(1041,	3,	203,	'8',	'lada.tayupova@mail.ru',	''),
(1042,	3,	203,	'4',	'(635) 346-1427',	''),
(1043,	3,	203,	'6',	'Investing in a property',	''),
(1044,	3,	203,	'5',	'You read it - then XEvil 5.0 really works!!! \r\n \r\nWant to post your promo to 12.000.000 (12 MILLIONS!) websites? No problem - with new \"XEvil 5.0 + XRumer 19.0.8\" software complex! \r\nBlogs, forums, boards, shops, guestbooks, social networks - any engines with any captchas! \r\nXEvil also compatible with any SEO/SMM programms and scripts, and can accept captchas from any source. Just try it!  ;) \r\n \r\nRegards, MashaKoTAX0804 \r\n \r\nP.S. Huge discounts are available (up to 50%!) for a short review abo',	''),
(1045,	3,	204,	'7',	'Ashleycrutt',	''),
(1046,	3,	204,	'8',	'lena.kozlova64256@mail.ru',	''),
(1047,	3,	204,	'4',	'(415) 476-0634',	''),
(1048,	3,	204,	'6',	'Investing in a property',	''),
(1049,	3,	204,	'5',	'Аяаншу Кумару, маленькому жителю американского штата Нью-Джерси, всего год и 10 месяцев. А он уже стал героем Сети. Причем, без малейших усилий. Просто играл с маминым смартфоном и случайно заказал через интернет мебель на 1700 долларов. По рассказам местных СМИ, семья Кумар осваивает новый дом, куда они перебрались недавно. И вдруг ко крыльцу новостройки стали массово привозить коробки с мебелью. Они прибывали и прибывали из соседнего супермаркета. Супруги попробовали отказаться от внезапного «',	''),
(1050,	3,	205,	'7',	'Jamescap',	''),
(1051,	3,	205,	'8',	'pagli.brynn.78@outlook.com',	''),
(1052,	3,	205,	'4',	'(322) 130-8616',	''),
(1053,	3,	205,	'6',	'Investing in a property',	''),
(1054,	3,	205,	'5',	'гидра сайт \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchd-onion.com>гидра сайт</a> \r\nНе секрет, что основная сложность космического полета – это преодоление земного притяжения. Из-за него каждый килограмм груза обходится в тысячи долларов. И чем дальше предстоит полет, тем он будет дороже. \r\nПоэтому космический лифт – вполне себе выгодное решение такой проблемы. Суть в том, чтобы создать огромный сверхпрочный трос до 100 тыс. км в длину и протянуть его от поверхности З',	''),
(1055,	3,	206,	'7',	'Williamdug',	''),
(1056,	3,	206,	'8',	'bento.dottie@outlook.com',	''),
(1057,	3,	206,	'4',	'(777) 107-8387',	''),
(1058,	3,	206,	'6',	'Investing in a property',	''),
(1059,	3,	206,	'5',	'Аяаншу Кумару, маленькому жителю американского штата Нью-Джерси, всего год и 10 месяцев. А он уже стал героем Сети. Причем, без малейших усилий. Просто играл с маминым смартфоном и случайно заказал через интернет мебель на 1700 долларов. По рассказам местных СМИ, семья Кумар осваивает новый дом, куда они перебрались недавно. И вдруг ко крыльцу новостройки стали массово привозить коробки с мебелью. Они прибывали и прибывали из соседнего супермаркета. Супруги попробовали отказаться от внезапного «',	''),
(1060,	3,	207,	'7',	'Jamesnoica',	''),
(1061,	3,	207,	'8',	'micha_puga@outlook.com',	''),
(1062,	3,	207,	'4',	'(335) 133-1855',	''),
(1063,	3,	207,	'6',	'Getting some information',	''),
(1064,	3,	207,	'5',	'hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid.onion \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchd-onion.com>hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid.onion</a> \r\nНе секрет, что основная сложность космического полета – это преодоление земного притяжения. Из-за него каждый килограмм груза обходится в тысячи долларов. И чем дальше предстоит полет, тем он будет дороже. \r\nПоэтому космический лифт – вполне себе выгодное решение такой проблемы. Суть',	''),
(1065,	3,	208,	'7',	'RonaldNak',	''),
(1066,	3,	208,	'8',	'plotnikov_vlad_769@mail.ru',	''),
(1067,	3,	208,	'4',	'(064) 240-0641',	''),
(1068,	3,	208,	'6',	'Getting some information',	''),
(1069,	3,	208,	'5',	'Аяаншу Кумару, маленькому жителю американского штата Нью-Джерси, всего год и 10 месяцев. А он уже стал героем Сети. Причем, без малейших усилий. Просто играл с маминым смартфоном и случайно заказал через интернет мебель на 1700 долларов. По рассказам местных СМИ, семья Кумар осваивает новый дом, куда они перебрались недавно. И вдруг ко крыльцу новостройки стали массово привозить коробки с мебелью. Они прибывали и прибывали из соседнего супермаркета. Супруги попробовали отказаться от внезапного «',	''),
(1070,	3,	209,	'7',	'RickSeoSite',	''),
(1071,	3,	209,	'8',	'kygdumixzf@rambler.ru',	''),
(1072,	3,	209,	'4',	'(653) 686-5120',	''),
(1073,	3,	209,	'6',	'Getting some information',	''),
(1074,	3,	209,	'5',	'We will help you promote your site, backlinks for the site are  here inexpensive <a href=http://links-for.site>www.links-for.site</a>',	''),
(1075,	3,	210,	'7',	'AaronPhate',	''),
(1076,	3,	210,	'8',	'belaia_alena19791776@mail.ru',	''),
(1077,	3,	210,	'4',	'(303) 321-3561',	''),
(1078,	3,	210,	'6',	'Getting some information',	''),
(1079,	3,	210,	'5',	'hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid.onion \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchd-onion.com>гидра сайт</a> \r\nНе секрет, что основная сложность космического полета – это преодоление земного притяжения. Из-за него каждый килограмм груза обходится в тысячи долларов. И чем дальше предстоит полет, тем он будет дороже. \r\nПоэтому космический лифт – вполне себе выгодное решение такой проблемы. Суть в том, чтобы создать огромный сверхпрочный трос до',	''),
(1080,	3,	211,	'7',	'KevinMonry',	''),
(1081,	3,	211,	'8',	'aleksandr-ustinov_19998599@mail.ru',	''),
(1082,	3,	211,	'4',	'(630) 563-8011',	''),
(1083,	3,	211,	'6',	'Investing in a property',	''),
(1084,	3,	211,	'5',	'гидра сайт \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchd-onion.com>гидра сайт</a> \r\nНе секрет, что основная сложность космического полета – это преодоление земного притяжения. Из-за него каждый килограмм груза обходится в тысячи долларов. И чем дальше предстоит полет, тем он будет дороже. \r\nПоэтому космический лифт – вполне себе выгодное решение такой проблемы. Суть в том, чтобы создать огромный сверхпрочный трос до 100 тыс. км в длину и протянуть его от поверхности З',	''),
(1085,	3,	212,	'7',	'Melvinruide',	''),
(1086,	3,	212,	'8',	'stepanandreev3634@topnewsrbk.top',	''),
(1087,	3,	212,	'4',	'(051) 265-1331',	''),
(1088,	3,	212,	'6',	'Getting some information',	''),
(1089,	3,	212,	'5',	'уборка загородного коттеджа\r\nгенеральная уборка коттеджа цена\r\nуборка двухкомнатной квартиры\r\nклининг коттеджей\r\nмойка окон альпинистами\r\n \r\n \r\n<a href=https://profuslugi24.ru>химчистка дивана стоимость</a> \r\n \r\nстоимость уборки 2 комнатной квартиры',	''),
(1090,	3,	213,	'7',	'Gonzalovor',	''),
(1091,	3,	213,	'8',	'konstantinandreev9932@topnewsrbk.top',	''),
(1092,	3,	213,	'4',	'(410) 041-1546',	''),
(1093,	3,	213,	'6',	'Getting some information',	''),
(1094,	3,	213,	'5',	'купить больничный лист в москве официально с доставкой \r\n \r\n<a href=http://medicao.ru/>больничный лист цена</a> \r\n \r\nкупить больничный\r\nбольничный лист на работу\r\nкупить больничный лист в москве официально с доставкой\r\nбольничный лист купить\r\nзаказать больничный лист',	''),
(1095,	3,	214,	'7',	'Darrenvef',	''),
(1096,	3,	214,	'8',	'romanandreev7554@topnewsrbk.top',	''),
(1097,	3,	214,	'4',	'(654) 448-5388',	''),
(1098,	3,	214,	'6',	'Getting some information',	''),
(1099,	3,	214,	'5',	'Свадьба в Москве \r\n \r\nфотосессия на свадьбу Москва <a href=http://zelwedding.ru/>http://zelwedding.ru/</a>',	''),
(1100,	3,	215,	'7',	'Darrenvef',	''),
(1101,	3,	215,	'8',	'romanandreev7554@topnewsrbk.top',	''),
(1102,	3,	215,	'4',	'(554) 117-3373',	''),
(1103,	3,	215,	'6',	'Getting some information',	''),
(1104,	3,	215,	'5',	'салон свадебных платьев в Москве \r\n \r\nфотосессия на свадьбу Москва <a href=http://zelwedding.ru/>http://zelwedding.ru/</a>',	''),
(1105,	3,	216,	'7',	'Melvinruide',	''),
(1106,	3,	216,	'8',	'stepanandreev3634@topnewsrbk.top',	''),
(1107,	3,	216,	'4',	'(620) 262-6857',	''),
(1108,	3,	216,	'6',	'Getting some information',	''),
(1109,	3,	216,	'5',	'клининг после пожара\r\nхимчистка дивана стоимость\r\nмытье окон с наружной стороны\r\nудаление запаха кошачьей мочи с дивана\r\nчистка дивана цена\r\n \r\n \r\n<a href=https://profuslugi24.ru>отмыть квартиру ремонта</a> \r\n \r\nклининг частного дома',	''),
(1110,	3,	217,	'7',	'Gonzalovor',	''),
(1111,	3,	217,	'8',	'konstantinandreev9932@topnewsrbk.top',	''),
(1112,	3,	217,	'4',	'(515) 873-5872',	''),
(1113,	3,	217,	'6',	'Getting some information',	''),
(1114,	3,	217,	'5',	'оформить больничный лист \r\n \r\n<a href=http://medicao.ru/>больничный лист официально в москве</a> \r\n \r\nбольничный лист купить\r\nбольничный лист цена\r\nкупить больничный\r\nбольничный лист\r\nбольничный лист официально',	''),
(1115,	3,	218,	'7',	'Damienidots',	''),
(1116,	3,	218,	'8',	'aleksandrandreev1802@seoklan.xyz',	''),
(1117,	3,	218,	'4',	'(242) 186-3326',	''),
(1118,	3,	218,	'6',	'Investing in a property',	''),
(1119,	3,	218,	'5',	'как зайти на официальную гидру \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jonion7nchid.com/>hydrarusawyg5ykmsgvnyhdumzeawp465jp7zhynyihexdv5p74etnid.onion</a> \r\n \r\nЕсли в течение двух суток Россия не ответит или предоставит недостаточную информацию, то Украина обратится к государствам-участникам Венского документа ОБСЕ о мерах укрепления доверия и безопасности для созыва чрезвычайной встречи.',	''),
(1120,	3,	219,	'7',	'PhillipEmels',	''),
(1121,	3,	219,	'8',	'nikolajandreev2345@seoklan.xyz',	''),
(1122,	3,	219,	'4',	'(068) 058-4535',	''),
(1123,	3,	219,	'6',	'Investing in a property',	''),
(1124,	3,	219,	'5',	'hydrarusoeitpwagsnukxyxkd4copuuvio52k7hd6qbabt4lxcwnbsad.onion \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7d-onion-shop.com/>как зайти на официальную гидру</a> \r\nРоссия неоднократно отвергала ложные оценки о подготовке вторжения на Украину. \r\nВзгляд.ру',	''),
(1125,	3,	220,	'7',	'Hectorswalm',	''),
(1126,	3,	220,	'8',	'romanandreev3867@seoklan.xyz',	''),
(1127,	3,	220,	'4',	'(610) 018-7010',	''),
(1128,	3,	220,	'6',	'Investing in a property',	''),
(1129,	3,	220,	'5',	'Гидра даркнет \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchidonion.online/>Гидра даркнет</a>',	''),
(1130,	3,	221,	'7',	'Robertacice',	''),
(1131,	3,	221,	'8',	'makarandreev6893@topnewsrbk.top',	''),
(1132,	3,	221,	'4',	'(537) 475-0066',	''),
(1133,	3,	221,	'6',	'Getting some information',	''),
(1134,	3,	221,	'5',	'гидра не работает \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid-dark.net>hydraruzxpnew4af</a> \r\n \r\nВ последние месяцы западные СМИ и политики заявляют, что Россия якобы стягивает войска к границе с Украиной, хотя Москва неоднократно подчёркивала, что не имеет планов нападения на другие страны. \r\nLife.ru',	''),
(1135,	3,	222,	'7',	'HarryItege',	''),
(1136,	3,	222,	'8',	'le.na.wetze.l6.94@gmail.com',	''),
(1137,	3,	222,	'4',	'(750) 642-1442',	''),
(1138,	3,	222,	'6',	'Investing in a property',	''),
(1139,	3,	222,	'5',	'https://moverslosangeles.me',	''),
(1140,	3,	223,	'7',	'pinupcasino777',	''),
(1141,	3,	223,	'8',	'pinupcasino7777@gmail.com',	''),
(1142,	3,	223,	'4',	'(418) 011-4811',	''),
(1143,	3,	223,	'6',	'Getting some information',	''),
(1144,	3,	223,	'5',	'https://tsu.tula.ru/depts/ap/onlayn_kazino_pin_up_casino___igrat_na_dengi_v_ukraine.html',	''),
(1145,	3,	224,	'7',	'RichardPrify',	''),
(1146,	3,	224,	'8',	'georgijandreev5960@seoklan.xyz',	''),
(1147,	3,	224,	'4',	'(077) 372-5431',	''),
(1148,	3,	224,	'6',	'Getting some information',	''),
(1149,	3,	224,	'5',	'гидра не работает \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nid-onion.com>как зайти на официальную гидру</a> \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nid-onion.com>гидра не работает</a>\r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nid-onion.com>гидра сайт</a>\r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nid-onion.com>hidraruzxpnew4af.onion</a>\r\n<a href=https://hydraclubbioknikokex7njhwuahc2',	''),
(1150,	3,	225,	'7',	'DanielInher',	''),
(1151,	3,	225,	'8',	'volkov.ivan-657@mail.ru',	''),
(1152,	3,	225,	'4',	'(364) 018-1704',	''),
(1153,	3,	225,	'6',	'Getting some information',	''),
(1154,	3,	225,	'5',	'Гидра даркнет \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchidonion.online/>гидра не работает</a>',	''),
(1155,	3,	226,	'7',	'Gilbertshica',	''),
(1156,	3,	226,	'8',	'torez@stocks.ru.com',	''),
(1157,	3,	226,	'4',	'(556) 241-5037',	''),
(1158,	3,	226,	'6',	'Investing in a property',	''),
(1159,	3,	226,	'5',	'Мы выбираем <a href=>http://roleplay.ru/news/6437.html</a> будто самые важные и самые интересные новости, ведь <a href=http://roleplay.ru/news/6437.html></a>дел',	''),
(1160,	3,	227,	'7',	'Larrytuh',	''),
(1161,	3,	227,	'8',	'%spinfile-names.dat%%spinfile-lnames.dat%%random-1-100%@base.mixwi.com',	''),
(1162,	3,	227,	'4',	'(365) 345-2782',	''),
(1163,	3,	227,	'6',	'Getting some information',	''),
(1164,	3,	227,	'5',	'Trusted Online Casino Malaysia   http://gm231.com/gm231-best-online-slot-games-malaysia-slots-918kiss-xe88/#{Best Online Slot Games Malaysia | Slots |  - {Online Casino Malaysia|Click here|More info|Show more}{!|...|>>>|!..}',	''),
(1165,	3,	228,	'7',	'Georgeprath',	''),
(1166,	3,	228,	'8',	'kornelijignatov4568@yandex.ru',	''),
(1167,	3,	228,	'4',	'(375) 207-3011',	''),
(1168,	3,	228,	'6',	'Getting some information',	''),
(1169,	3,	228,	'5',	'insta \r\nотличные цены \r\nЛучшие в городе \r\nДоставка в любую точку мира!!! \r\n \r\nhookah.magic_su',	''),
(1170,	3,	229,	'7',	'obkbzlex',	''),
(1171,	3,	229,	'8',	'lahtlhcrx@dissernow.site',	''),
(1172,	3,	229,	'4',	'(531) 373-3514',	''),
(1173,	3,	229,	'6',	'Investing in a property',	''),
(1174,	3,	229,	'5',	'viagra costco price  <a href=https:viagarag.com/>viagra tablets for men</a>  viagra over the counter europe',	''),
(1175,	3,	230,	'7',	'MikhailR85',	''),
(1176,	3,	230,	'8',	'mikhailrt85@gmail.com',	''),
(1177,	3,	230,	'4',	'(541) 117-6536',	''),
(1178,	3,	230,	'6',	'Investing in a property',	''),
(1179,	3,	230,	'5',	'Здравствуйте. Помогу решить проблемы с вашим сайтом. С моей помощью ваш сайт может стать значительно более посещаемым и приносящим больший доход. Умею привлекать на сайт целевых посетителей и повышать конверсию. Занимаюсь созданием, доработкой и продвижением сайтов с 2004 года. Работаю как с коммерческими, так и с информационными проектами. Умеренные расценки. \r\n \r\nЗанимаюсь я следующим: \r\n \r\n1. Продвижение сайтов в поисковых системах. Помогу вывести ваш сайт на первые места по представляющим дл',	''),
(1180,	3,	231,	'7',	'IsabellaKr',	''),
(1181,	3,	231,	'8',	'isabellaKr@gmail.com',	''),
(1182,	3,	231,	'4',	'(723) 268-4133',	''),
(1183,	3,	231,	'6',	'Investing in a property',	''),
(1184,	3,	231,	'5',	'Нello аll, guys! I knоw, my message may bе tоо spесifiс,\r\nΒut my sister found nicе mаn here and tһey mаrried, so how аbоut mе?! :)\r\nI am 25 yеаrs оld, Isabеllа, from Romania, knоw Еnglish and Russiаn lаnguages аlso\r\nΑnd... I havе speсifiс disеase, namеd nymрhomаnia. Wһо know w&#1',	''),
(1185,	3,	232,	'7',	'JerryZes',	''),
(1186,	3,	232,	'8',	'kvartira38.com@gmail.com',	''),
(1187,	3,	232,	'4',	'(633) 835-5556',	''),
(1188,	3,	232,	'6',	'Getting some information',	''),
(1189,	3,	232,	'5',	'Стоимость недвижимости определяется тремя факторами: местоположением, местопол&#',	''),
(1190,	3,	233,	'7',	'Michaelpoump',	''),
(1191,	3,	233,	'8',	'molchanova.anna68568@mail.ru',	''),
(1192,	3,	233,	'4',	'(601) 465-1106',	''),
(1193,	3,	233,	'6',	'Investing in a property',	''),
(1194,	3,	233,	'5',	'ссылка на гидру \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7d-onion-shop.com/>Магазин Гидра</a> \r\nРоссия неоднократно отвергала ложные оценки о подготовке вторжения на Украину. \r\nВзгляд.ру',	''),
(1195,	3,	234,	'7',	'DanielInher',	''),
(1196,	3,	234,	'8',	'volkov.ivan-657@mail.ru',	''),
(1197,	3,	234,	'4',	'(850) 727-6453',	''),
(1198,	3,	234,	'6',	'Investing in a property',	''),
(1199,	3,	234,	'5',	'hydrarusoeitpwagsnukxyxkd4copuuvio52k7hd6qbabt4lxcwnbsad.onion \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchidonion.online/>Гидра даркнет</a>',	''),
(1200,	3,	235,	'7',	'Gilbertshica',	''),
(1201,	3,	235,	'8',	'torez@stocks.ru.com',	''),
(1202,	3,	235,	'4',	'(444) 842-5381',	''),
(1203,	3,	235,	'6',	'Investing in a property',	''),
(1204,	3,	235,	'5',	'Мы выбираем <a href=>http://roleplay.ru/news/6437.html</a> как самые важные и самые интересные новости, ведь <a href=http://roleplay.ru/news/6437.html></a>посту',	''),
(1205,	3,	236,	'7',	'DarrellMix',	''),
(1206,	3,	236,	'8',	'andreishhevatatyana@yangoogl.cc',	''),
(1207,	3,	236,	'4',	'(638) 524-2134',	''),
(1208,	3,	236,	'6',	'Getting some information',	''),
(1209,	3,	236,	'5',	'hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid onion \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchd-onion.com>hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid onion</a> \r\n \r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchd-onion.com\r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchd-onion.com\r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7hydra-onion.com\r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2',	''),
(1210,	3,	237,	'7',	'Brycenut',	''),
(1211,	3,	237,	'8',	'svirinnikova.albina@yangoogl.cc',	''),
(1212,	3,	237,	'4',	'(732) 437-3443',	''),
(1213,	3,	237,	'6',	'Investing in a property',	''),
(1214,	3,	237,	'5',	'hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid onion \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchd-onion.com>hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid onion</a> \r\n \r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchd-onion.com\r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7hydra-onion.com\r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchd-onion.com\r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2',	''),
(1215,	3,	238,	'7',	'Miltonobema',	''),
(1216,	3,	238,	'8',	'cyverova.katena@yangoogl.cc',	''),
(1217,	3,	238,	'4',	'(004) 051-7214',	''),
(1218,	3,	238,	'6',	'Getting some information',	''),
(1219,	3,	238,	'5',	'hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid onion \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7hydra-onion.com>hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid.onion</a> \r\n \r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchd-onion.com\r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchd-onion.com\r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchd-onion.com\r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2',	''),
(1220,	3,	239,	'7',	'Samueloppom',	''),
(1221,	3,	239,	'8',	'seismismheathery@rambler.ru',	''),
(1222,	3,	239,	'4',	'(681) 861-6870',	''),
(1223,	3,	239,	'6',	'Investing in a property',	''),
(1224,	3,	239,	'5',	'Услуги PhotoShop: \r\nНизкие цены и высокое качество исполнения!!! \r\nРабота со слоями/масками \r\nСмена фона/композиции \r\nКоррекция изъянов на фото (фигура/лицо, лишние/недостающие элементы/выравнивание/деформация) \r\nСоздание реалистичных коллажей, работа с освещением/цветом/фильтрами. \r\nМакеты сайтов, шапки для групп VK, аватарки инстаграмм и так далее... \r\nВсе что касается фотошопа - это ко мне! \r\nКонтакты: Телеграмм https://t.me/Dizaynmaks (Dizaynmaks) или Skype https://join.skype.com/invite/NxiZ',	''),
(1225,	3,	240,	'7',	'Marilynideve',	''),
(1226,	3,	240,	'8',	'yourmail@gmail.com',	''),
(1227,	3,	240,	'4',	'(731) 568-1252',	''),
(1228,	3,	240,	'6',	'Investing in a property',	''),
(1229,	3,	240,	'5',	'Hello. And Bye. \r\nhttp://kfsdfjkalkjszzz.com',	''),
(1230,	3,	241,	'7',	'DarrellMix',	''),
(1231,	3,	241,	'8',	'andreishhevatatyana@yangoogl.cc',	''),
(1232,	3,	241,	'4',	'(342) 767-4210',	''),
(1233,	3,	241,	'6',	'Getting some information',	''),
(1234,	3,	241,	'5',	'hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid onion \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7hydra-onion.com>hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid onion</a> \r\n \r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchd-onion.com\r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7hydra-onion.com\r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7hydra-onion.com\r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36m',	''),
(1235,	3,	242,	'7',	'Miltonobema',	''),
(1236,	3,	242,	'8',	'cyverova.katena@yangoogl.cc',	''),
(1237,	3,	242,	'4',	'(384) 746-8766',	''),
(1238,	3,	242,	'6',	'Investing in a property',	''),
(1239,	3,	242,	'5',	'hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid onion \r\n \r\n<a href=https://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchd-onion.com>hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid onion</a> \r\n \r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7hydra-onion.com\r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7hydra-onion.com\r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchd-onion.com\r\nhttps://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md',	''),
(1240,	3,	243,	'7',	'Gilbertshica',	''),
(1241,	3,	243,	'8',	'torez@stocks.ru.com',	''),
(1242,	3,	243,	'4',	'(843) 602-2881',	''),
(1243,	3,	243,	'6',	'Investing in a property',	''),
(1244,	3,	243,	'5',	'Мы выбираем <a href=>http://roleplay.ru/news/6437.html</a> только самые важные и самые интересные новости, ведь <a href=http://roleplay.ru/news/6437.html></a>ко',	''),
(1245,	3,	244,	'7',	'JasonBep',	''),
(1246,	3,	244,	'8',	'lariska.zyryanowa@yangoogl.cc',	''),
(1247,	3,	244,	'4',	'(287) 825-1121',	''),
(1248,	3,	244,	'6',	'Investing in a property',	''),
(1249,	3,	244,	'5',	'<a href=https://zaimy-mfo.ru/>мфо дающие 100 тысяч сразу</a> \r\nДостоинства беспроцентных займов для клиентов: \r\nВозможность воспользоваться деньгами кредитора без уплаты процентов. Сколько взяли – столько нужно и отдать (конечно, с учетом платы за перевод средств, которую берет платежная система). \r\nВозможность поправить свое финансовое положение, не обращаясь за помощью к родным и близким. Обычно не хочется тревожить родственников и друзей своими финансовыми проблемами, так как родные и близкие',	''),
(1250,	3,	245,	'7',	'Annarap',	''),
(1251,	3,	245,	'8',	'anna_fisher74@mail.ru',	''),
(1252,	3,	245,	'4',	'(383) 570-5261',	''),
(1253,	3,	245,	'6',	'Investing in a property',	''),
(1254,	3,	245,	'5',	'bloggingorigin.com Blog  is your professional <a href=https://bloggingorigin.com>Breaking news</a> source of everything that you need to know about what is going on in the Sport community and abroad including vehicles and equipment, breaking news, international news and more. We focus on the people, the issues, the events and the technologies that drive tomorrow\'s response.',	''),
(1255,	3,	246,	'7',	'hydraron',	''),
(1256,	3,	246,	'8',	'bubar43.dermatitis@gmail.com',	''),
(1257,	3,	246,	'4',	'(500) 537-7514',	''),
(1258,	3,	246,	'6',	'Investing in a property',	''),
(1259,	3,	246,	'5',	'<a href=https://hydraruzpnew4afonion.com>Ссылка на гидру hydraruzxpnew4af hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid onion</a> http://hydraclubbioknikokex7njhwuahc2l67lfiz7z36md2jvopda7nchid.onion/login - https://hydraruzpnew4afonion.com - ГИДРА site официальный имеет множество зеркал, на случай вы забанены, onion, высокой нагрузки или DDoS атак. Пользуйтесь ссылкой выше v3.hydraruzxpnew4af.com.co для создания безопасного conversations соединения с сетью TOR и открытия рабочего зер',	''),
(1260,	3,	247,	'7',	'JuliaWriff',	''),
(1261,	3,	247,	'8',	'lada.tayupova@mail.ru',	''),
(1262,	3,	247,	'4',	'(632) 200-3415',	''),
(1263,	3,	247,	'6',	'Getting some information',	''),
(1264,	3,	247,	'5',	'You read it - then XEvil 5.0 works!! \r\n \r\nWant to post your text to 12.000.000 (12 MILLIONS!) websites? No problem - with new \"XEvil 5.0 + XRumer 19.0.8\" software complex! \r\nBlogs, forums, boards, shops, guestbooks, social networks - any engines with any captchas! \r\nXEvil also compatible with any SEO/SMM programms and scripts, and can accept captchas from any source. Just try it!  ;) \r\n \r\nRegards, MashaKeTAX9766 \r\n \r\nP.S. Huge discounts are available (up to 50%!) for a short review about XEvil',	''),
(1265,	3,	248,	'7',	'Danielhot',	''),
(1266,	3,	248,	'8',	'sandralewoncka@wp.pl',	''),
(1267,	3,	248,	'4',	'(852) 554-1424',	''),
(1268,	3,	248,	'6',	'Getting some information',	''),
(1269,	3,	248,	'5',	'Dokąd spotykać obrazy także seriale online – wyróżniane budowy streamingowe \r\n \r\nFilmiki dodatkowo seriale online bieżące nuże długotrwały pierwiastek współczesnej rozrywki. Najemcy nałogowo wyszukują najodpowiedniejszych ofercie do obejrzenia w weekend, zmrokiem smakuj w linii. Kaloryczny priorytet przysług streamingowych (których nałogowo nadchodzi!) nie pomaga wyboru. Co przedkładają najcz',	''),
(1270,	3,	249,	'7',	'Edwinpuh',	''),
(1271,	3,	249,	'8',	'bbobbum@gmail.com',	''),
(1272,	3,	249,	'4',	'(663) 678-2527',	''),
(1273,	3,	249,	'6',	'Getting some information',	''),
(1274,	3,	249,	'5',	'The Prophecy has been fulfilled President Donald J Trump, \r\non Dec 6, declared Jerusalem the capital of Isreal. \r\nThe Bible has stated that this is the beginning of the end \r\n \r\n<a href=https://bit.ly/liveafterthefall2021>Alive after the Fall!</a> \r\n \r\nThis free video explains in detail the events that set stage \r\nfor the end as we know it. \r\n \r\n<a href=https://bit.ly/liveafterthefall2021>Alive after the Fall!</a> \r\nGo here to see this powerful video and Survive after the fall',	''),
(1275,	3,	250,	'7',	'Annarap',	''),
(1276,	3,	250,	'8',	'anna_fisher74@mail.ru',	''),
(1277,	3,	250,	'4',	'(223) 271-7687',	''),
(1278,	3,	250,	'6',	'Investing in a property',	''),
(1279,	3,	250,	'5',	'bloggingorigin.com Blog  is your reliable <a href=https://bloggingorigin.com>Sport</a> source of everything that you need to know about what is going on in the Sport community and abroad including vehicles and equipment, breaking news, international news and more. We focus on the people, the issues, the events and the technologies that drive tomorrow\'s response.',	''),
(1280,	3,	251,	'7',	'JessicaTrume',	''),
(1281,	3,	251,	'8',	'holidahon.mnt@gmail.com',	''),
(1282,	3,	251,	'4',	'(065) 277-2622',	''),
(1283,	3,	251,	'6',	'Getting some information',	''),
(1284,	3,	251,	'5',	'As Real As You Want it To be. Fill out this short survey and we\'ll give you a chance to win an iPhone 12 Pro. Visit http://anti-covid.us',	''),
(1285,	3,	252,	'7',	'KaymotdZen',	''),
(1286,	3,	252,	'8',	'j.umandjikro@gmail.com',	''),
(1287,	3,	252,	'4',	'(414) 437-6553',	''),
(1288,	3,	252,	'6',	'Getting some information',	''),
(1289,	3,	252,	'5',	'Hi Brain. As you asked, I\'m giving you a link where you can meet single girls for sex https://ladieslocation.life/?u=wh5kd06&o=qxpp80k',	''),
(1290,	3,	253,	'7',	'Brentlom',	''),
(1291,	3,	253,	'8',	'vita.vinokurovas@gmail.com',	''),
(1292,	3,	253,	'4',	'(378) 735-5701',	''),
(1293,	3,	253,	'6',	'Investing in a property',	''),
(1294,	3,	253,	'5',	'https://telegra.ph/Nude-Indian-Boys-Cock-04-02',	''),
(1295,	3,	254,	'7',	'Annarap',	''),
(1296,	3,	254,	'8',	'anna_fisher74@mail.ru',	''),
(1297,	3,	254,	'4',	'(586) 438-2580',	''),
(1298,	3,	254,	'6',	'Investing in a property',	''),
(1299,	3,	254,	'5',	'blogspotgood.com Blog  is your reliable <a href=https://blogspotgood.com>Breaking news</a> source of everything that you need to know about what is going on in the news community and abroad including vehicles and equipment, breaking news, international news and more. We focus on the people, the issues, the events and the technologies that drive tomorrow\'s response.',	''),
(1300,	3,	255,	'7',	'DavidRef',	''),
(1301,	3,	255,	'8',	'info@bystrovozvodimye-zdanija.ru',	''),
(1302,	3,	255,	'4',	'(323) 782-2586',	''),
(1303,	3,	255,	'6',	'Investing in a property',	''),
(1304,	3,	255,	'5',	'Заказать <a href=http://bystrovozvodimye-zdanija.ru/>строительство быстровозводимых зданий москва </a> в Москве по низкой цене. \r\n<a href=http://www.google.it/url?q=http://bystrovozvodimye-zdanija.ru>http://www.google.it/url?q=http://bystrovozvodimye-zdanija.ru </a>',	''),
(1305,	3,	256,	'7',	'BitcoinNEOx',	''),
(1306,	3,	256,	'8',	'bitcoinneoemail@gmail.com',	''),
(1307,	3,	256,	'4',	'(357) 312-0531',	''),
(1308,	3,	256,	'6',	'Investing in a property',	''),
(1309,	3,	256,	'5',	'Bitcoin NEO the New era of Crypto! \r\nBNEO uses peer-to-peer technology to operate with no central authority or banks; managing transactions and the issuing of bitcoins is carried out collectively by the network. \r\nEmission 21 000 000 tokens. \r\n \r\nRead more info on our site - https://bitcoin-neo.com/?from=x \r\nBuy coins Now and earn at cryptoexchange DODOEX - https://app.dodoex.io/exchange/USDT-BNEO \r\nHow buy coins on cryptoexchange DODOEX - https://bitcoin-neo.com/how-buy.html?from=x \r\nAlso you c',	''),
(1310,	3,	257,	'7',	'BriceVab',	''),
(1311,	3,	257,	'8',	'andrey.petr55@gmail.com',	''),
(1312,	3,	257,	'4',	'(112) 545-7662',	''),
(1313,	3,	257,	'6',	'Getting some information',	''),
(1314,	3,	257,	'5',	'<a href=http://vebcamonline.ru/>веб камеры онлайн</a> \r\n<a href=https://www.vebcamonline.ru>https://www.vebcamonline.ru/</a> \r\n<a href=http://whois.pp.ru/vebcamonline.ru>http://www.google.tg/url?q=http://vebcamonline.ru/</a>',	''),
(1315,	3,	258,	'7',	'WalterMaf',	''),
(1316,	3,	258,	'8',	'suzannebaier@tele2.nl',	''),
(1317,	3,	258,	'4',	'(051) 207-2728',	''),
(1318,	3,	258,	'6',	'Investing in a property',	''),
(1319,	3,	258,	'5',	'Hello, \r\nMusic download FTP full access to exclusive electronic. https://0daymusic.org \r\nList: https://0daymusic.org/FTPtxt/ \r\n \r\nBest regards, DJ Walter',	''),
(1320,	3,	259,	'7',	'GeorgeTeaph',	''),
(1321,	3,	259,	'8',	'pdergachev80@gmail.com',	''),
(1322,	3,	259,	'4',	'(342) 102-5047',	''),
(1323,	3,	259,	'6',	'Getting some information',	''),
(1324,	3,	259,	'5',	'<a href=https://masterholodov.ru/>ремонт холодильников на дому москва</a>',	''),
(1325,	3,	260,	'7',	'Danielgog',	''),
(1326,	3,	260,	'8',	'subminaldej@gmail.com',	''),
(1327,	3,	260,	'4',	'(670) 305-2466',	''),
(1328,	3,	260,	'6',	'Getting some information',	''),
(1329,	3,	260,	'5',	'We sell casinos   platform  For online casinos and offline clubs \r\n \r\nOur casino script is completely source code. \r\nOur platform  script: \r\n1) Has no domain restrictions.  \r\n2)  You will receive all the games upon purchase and their source code. \r\n3) In the package you get more than 1100 games written in HTML5.  \r\n4) All games work on computer and phone and have html5 format.  \r\n5) We will help you install the script on your server. \r\nIf you are interested in the price and you want to see a de',	''),
(1330,	3,	261,	'7',	'Akatsuki007nix',	''),
(1331,	3,	261,	'8',	'myprofiled.qdqwqwqw.qwqwdqwd@gmail.com',	''),
(1332,	3,	261,	'4',	'(187) 257-5617',	''),
(1333,	3,	261,	'6',	'Investing in a property',	''),
(1334,	3,	261,	'5',	'unconditioned porn \r\n \r\nhttps://thepornarea.com/videos/917381/asian-redhead-gets-toyed-and-fucked-in-an-abandoned-school/\r\nhttps://thepornarea.com/categories/105674/couple\r\nhttps://thepornarea.com/videos/596798/listen-my-wet-little-pussy-as-i-make-myself-cum-in-my-panties/\r\nhttps://thepornarea.com/videos/917018/insolent-luna-gets-two-cocks-to-devour-her-wet-holes/\r\nhttps://thepornarea.com/categories/63605\r\n \r\nHes Fuck Site \r\nAs it turns out, chic times have got nothing on the past. Obscenity exi',	''),
(1335,	3,	262,	'7',	'NonellLag',	''),
(1336,	3,	262,	'8',	'istonlavernascha@gmail.com',	''),
(1337,	3,	262,	'4',	'(535) 001-4403',	''),
(1338,	3,	262,	'6',	'Investing in a property',	''),
(1339,	3,	262,	'5',	'I share with you professional website promotion services. The best price, the work is done within a few days. More than 1500 backlinks are created. Money back guarantee. A professional works through the kwork exchange https://kwork.com. \r\nHere is the link https://kwork.com/offpageseo/13467403/professional-website-promotion-1500-good-back-links',	''),
(1340,	3,	263,	'7',	'ArielDug',	''),
(1341,	3,	263,	'8',	'MyaDum@recvi.buzz',	''),
(1342,	3,	263,	'4',	'(380) 423-2806',	''),
(1343,	3,	263,	'6',	'Investing in a property',	''),
(1344,	3,	263,	'5',	'Hello. Can I buy ads on your site? \r\n \r\n \r\nmessage id: 27ADS762',	''),
(1345,	3,	264,	'7',	'Josezins',	''),
(1346,	3,	264,	'8',	'karimovvlad8@inbox.ru',	''),
(1347,	3,	264,	'4',	'(440) 254-3806',	''),
(1348,	3,	264,	'6',	'Investing in a property',	''),
(1349,	3,	264,	'5',	'Bitcoin Mixer crypto Bitcoin Mixer (Tumbler) <a href=https://blendor.site/>Bitcoin Mixer</a> / <a href=http://treoijk4ht2if4ghwk7h6qjy2klxfqoewxsfp3dip4wkxppyuizdw5qd.onion>Blender Mixer (onion)</a> \r\n \r\n \r\nIn olden days you start a bitcoin swap, we be struck sooner than to be endanger on ice the bazaar on 1 confirmation from the bitcoin network to insure the bitcoins clear. This customarily takes punishment a not numerous minutes and then the benchmark commitment send you modish coins to your',	''),
(1350,	3,	265,	'7',	'Ronaldwaync',	''),
(1351,	3,	265,	'8',	'no-replyGigmani@gmail.com',	''),
(1352,	3,	265,	'4',	'(568) 244-4552',	''),
(1353,	3,	265,	'6',	'Getting some information',	''),
(1354,	3,	265,	'5',	'Hi!  graygroupla.com \r\n \r\nWe make offer for you \r\n \r\nSending your commercial proposal through the Contact us form which can be found on the sites in the contact partition. Feedback forms are filled in by our software and the captcha is solved. The superiority of this method is that messages sent through feedback forms are whitelisted. This technique raise the chances that your message will be open. \r\n \r\nOur database contains more than 27 million sites around the world to which we can send your m',	''),
(1355,	3,	266,	'7',	'SarahtDiage',	''),
(1356,	3,	266,	'8',	'bbobbum@gmail.com',	''),
(1357,	3,	266,	'4',	'(153) 861-0367',	''),
(1358,	3,	266,	'6',	'Investing in a property',	''),
(1359,	3,	266,	'5',	'<a href=https://bit.ly/3KGZ8uQ>Girl on Girls</a> \r\nWatch me devour my friends - Watch us squirm, wiggle and Moan. \r\nGet excited get subscribed, Watch us any all the time. \r\n<a href=https://bit.ly/3KGZ8uQ>Girls love Girls</a> \r\nWe are so excited to have you Watch us be nasty, naughty... \r\n<a href=https://bit.ly/3KGZ8uQ>Lick! Lick! Lick!</a> \r\nYou won\'t be disappointed, we love to be watched...',	''),
(1360,	3,	267,	'7',	'Denise5q',	''),
(1361,	3,	267,	'8',	'joan84ck@gmail.com',	''),
(1362,	3,	267,	'4',	'(877) 160-4311',	''),
(1363,	3,	267,	'6',	'Getting some information',	''),
(1364,	3,	267,	'5',	'hallo dear... Im looking a lover.. \r\nDo you want to see a beautiful female body? Here are my erotic photos - is.gd/Gl6BJL',	''),
(1365,	3,	268,	'7',	'Borissal',	''),
(1366,	3,	268,	'8',	'vanja.kuzminep5nn@gmail.com',	''),
(1367,	3,	268,	'4',	'(577) 851-5425',	''),
(1368,	3,	268,	'6',	'Getting some information',	''),
(1369,	3,	268,	'5',	'vimax herbal  <a href=  > https://tramadol.oukko.fr      </a>  herbal menopause treatment  <a href= https://wuerzburger-baumpflege.de/zolde.html > https://wuerzburger-baumpflege.de/zolde.html </a>  vipps pharmacy online',	''),
(1370,	3,	269,	'7',	'Mikedop',	''),
(1371,	3,	269,	'8',	'zbigmike1988z@gmx.com',	''),
(1372,	3,	269,	'4',	'(315) 138-6003',	''),
(1373,	3,	269,	'6',	'Getting some information',	''),
(1374,	3,	269,	'5',	'<a href=https://obs-studio.co>obs studio</a> \r\n<a href=https://obs-studio.co>download obs</a>',	''),
(1375,	3,	270,	'7',	'Annarap',	''),
(1376,	3,	270,	'8',	'anna_fisher74@mail.ru',	''),
(1377,	3,	270,	'4',	'(547) 671-6618',	''),
(1378,	3,	270,	'6',	'Getting some information',	''),
(1379,	3,	270,	'5',	'<a href=https://goo.su/XFeSpKp>интим магазин</a>. Широкий ассортимент (более 18 тыс.) товаров, таких как секс-игрушки',	''),
(1380,	3,	271,	'7',	'PatrickBiago',	''),
(1381,	3,	271,	'8',	'mpjwyddnoc@rambler.ru',	''),
(1382,	3,	271,	'4',	'(471) 572-8411',	''),
(1383,	3,	271,	'6',	'Getting some information',	''),
(1384,	3,	271,	'5',	'We are a leading online pharmacy. We provide thousands of medications and over-the-counter products with savings of up to 80% or more. You can order through our secure website 24 hours a day or over the phone 7 days a week. \r\nEnjoy wholesale prices and the convenience of home delivery along with free shipping. \r\n<a href=https://shippills.com/product/stendra-100mg/>buy stendra 100mg</a> \r\nWe are committed to providing affordable medication to all of our customers. We do so by sourcing our medicin',	''),
(1385,	3,	272,	'7',	'Lerаapalp',	''),
(1386,	3,	272,	'8',	'leramihalovna91@gmail.com',	''),
(1387,	3,	272,	'4',	'(553) 541-0558',	''),
(1388,	3,	272,	'6',	'Investing in a property',	''),
(1389,	3,	272,	'5',	'Hi! I am in Ukraine, we have a terrible war going on and I am asking for your help with tears in my eyes. \r\nI have had more grief. I am a mother of two children and our house was destroyed by Russian missiles, everything we had gained was burned. We lost our homes, we have nowhere to live. We are hiding in basements from bombing and praying to stay alive, we eat what we can. We have only what we are wearing. \r\nI am asking for help. My children are freezing, there is nothing to eat and nowhere to',	''),
(1390,	3,	273,	'7',	'RobertAgodE',	''),
(1391,	3,	273,	'8',	'kriv.aza@yandex.ru',	''),
(1392,	3,	273,	'4',	'(620) 123-7373',	''),
(1393,	3,	273,	'6',	'Getting some information',	''),
(1394,	3,	273,	'5',	'The vendor establishes a small price along with a time frame for that transaction for being held in the NFT Auction. \r\n \r\nMany NFT artwork sales are utilizing the timeless strategy of auctioning to reach the ideal price doable and, within the… \r\n \r\nDecentralized meaning you and everybody else can verify you very own anything. All with out trusting or granting custody to a third party who can impose their own guidelines at will. What\'s more, it implies your NFT is transportable across many variou',	''),
(1395,	3,	274,	'7',	'SEOWeasK',	''),
(1396,	3,	274,	'8',	'svetlanaryazanova222@gmail.com',	''),
(1397,	3,	274,	'4',	'(255) 056-0211',	''),
(1398,	3,	274,	'6',	'Investing in a property',	''),
(1399,	3,	274,	'5',	'Hello! \r\nIs your site not profitable? I can do a completely FREE SEO AUDIT for your website. I work in a team with developers and authors of creative texts. You will also receive free link building strategy that includes outreach methods, pbn and multi-level link pumping. \r\n \r\nSend me a message! \r\n \r\nAlex \r\nhttps://bit.ly/seoupfree',	''),
(1400,	3,	275,	'7',	'Mariafam154',	''),
(1401,	3,	275,	'8',	'maryloubs136@gmail.com',	''),
(1402,	3,	275,	'4',	'(736) 521-4665',	''),
(1403,	3,	275,	'6',	'Investing in a property',	''),
(1404,	3,	275,	'5',	'XEvil 5.0 automatically solve most kind of captchas, \r\nIncluding such type of captchas: <b>ReCaptcha v.1, ReCaptcha v.3, Hotmail (Microsoft), Google, SolveMedia, Rambler, Yandex, +12000</b> \r\nInterested? Just google for XEvil 5.0! \r\nP.S. Free XEvil Demo is available! \r\n \r\nAlso, there is a huge discount available for purchase until 30th April: <b>-30%!</b> \r\n \r\nXEvil.Net',	''),
(1405,	3,	276,	'7',	'JamesTef',	''),
(1406,	3,	276,	'8',	'm.ent.en.ti.o.n.u.b@gmail.com',	''),
(1407,	3,	276,	'4',	'(281) 550-8718',	''),
(1408,	3,	276,	'6',	'Investing in a property',	''),
(1409,	3,	276,	'5',	'Our company sells casinos   platform  for online and offline club  \r\n<a href=https://goldsvet.su/assets/images/online.jpg><img src=\"https://goldsvet.su/onlineq.jpg\"></a> \r\nOur script is completely with source code.  \r\nOur platform casino  script: \r\n1) We do not tie casinos to domains or ip.  \r\n2) All games are open source.  \r\n3) A total of 1100+ games.  \r\n4)  All games work on your computer and phone  \r\n5) We can help you with the installation of the casino and server selection. \r\nIf you are in',	''),
(1410,	3,	277,	'7',	'ScottHoode',	''),
(1411,	3,	277,	'8',	'e-mark2@yandex.ru',	''),
(1412,	3,	277,	'4',	'(676) 482-7240',	''),
(1413,	3,	277,	'6',	'Investing in a property',	''),
(1414,	3,	277,	'5',	'Лучшие дамские платья и в течение целом одежда российского изготовителя широкошенько востребована средь отдельных потребителей на базаре нашей державы равным образом приставки не- только. Высокое качество пошива, ювелирно подбираемые материалы да специальная структура используемых в течение фабрике мануфактур сообщат одежде специальную эстетичность также уют в течение разбирательстве ношения. Точно на выпуске лучшей дамской риза равным образом в течение частности платьев специализируется свой пр',	''),
(1415,	3,	278,	'7',	'SeolLag',	''),
(1416,	3,	278,	'8',	'istonlavernascha@gmail.com',	''),
(1417,	3,	278,	'4',	'(316) 785-0252',	''),
(1418,	3,	278,	'6',	'Investing in a property',	''),
(1419,	3,	278,	'5',	'I share with you professional website promotion services. The best price, the work is done within a few days. More than 1500 backlinks are created. Money back guarantee. A professional works through the kwork exchange https://kwork.com. \r\nHere is the link https://kwork.com/offpageseo/13467403/professional-website-promotion-1500-good-back-links',	''),
(1420,	3,	279,	'7',	'Wayral',	''),
(1421,	3,	279,	'8',	'utimorka@yandex.com',	''),
(1422,	3,	279,	'4',	'(383) 301-7876',	''),
(1423,	3,	279,	'6',	'Investing in a property',	''),
(1424,	3,	279,	'5',	'<a href=https://proxyspace.seo-hunter.com>лучшие мобильные прокси рф</a>',	''),
(1425,	3,	280,	'7',	'Elaine1989',	''),
(1426,	3,	280,	'8',	'udol.g.o.v8.4.4@gmail.com',	''),
(1427,	3,	280,	'4',	'(608) 552-8346',	''),
(1428,	3,	280,	'6',	'Investing in a property',	''),
(1429,	3,	280,	'5',	'http://www.py27.com/home.php?mod=space&uid=282293',	''),
(1430,	3,	281,	'7',	'ninna200422',	''),
(1431,	3,	281,	'8',	'ninna200422@rambler.ru',	''),
(1432,	3,	281,	'4',	'(036) 774-5661',	''),
(1433,	3,	281,	'6',	'Getting some information',	''),
(1434,	3,	281,	'5',	'<a href=http://www.uzo.matrixplus.ru/waterultrasound.htm>Как чистить форсунки</a>. <a href=http://www.uzo.matrixplus.ru>Купить химию для очистки форсунок инжекторных двигателей</a> \r\nКачественная химия для очистки форсунок и инжекторов. Купить химию для тестирования форсунок \r\n \r\n<a href=http://www.uzo.matrixplus.ru/stend36.htm>uzo.matrixplus.ru</a> \r\nКупить химию для мойки и очистки днищ катеров, яхт, гидроциклов, лодок. \r\n \r\n<a href=http://wc.matrixplus.ru/utes08.htm>wc.matrixplus.ru</a> \r\nПок',	''),
(1435,	3,	282,	'7',	'Elenaoi',	''),
(1436,	3,	282,	'8',	'elenaoi@hotmail.com',	''),
(1437,	3,	282,	'4',	'(411) 033-5058',	''),
(1438,	3,	282,	'6',	'Investing in a property',	''),
(1439,	3,	282,	'5',	'Нello all, guуs! I know, my mesѕаge may be tоо sрecіfіс,\r\nΒut my ѕіster fоund niсe mаn here аnd theу marriеd, sо hоw аbout mе?! :)\r\nΙ am 26 уеarѕ old, Elеnа, frоm Ukrаіnе, Ι knоw Еnglish аnd Germаn lаnguagеs аlѕo\r\nAnd... Ι havе ѕl',	''),
(1440,	3,	283,	'7',	'Robspj',	''),
(1441,	3,	283,	'8',	'ro.bert.br.ownmoonman.s@gmail.com',	''),
(1442,	3,	283,	'4',	'(186) 887-3325',	''),
(1443,	3,	283,	'6',	'Getting some information',	''),
(1444,	3,	283,	'5',	'<a href=https://ali.ski/9X3k1>Unusual Led Combination Lock with discount 40%</a>',	''),
(1445,	3,	284,	'7',	'KaymnjgyZen',	''),
(1446,	3,	284,	'8',	'sanja.fila.to.vyg.9.9.s@gmail.com',	''),
(1447,	3,	284,	'4',	'(715) 728-6331',	''),
(1448,	3,	284,	'6',	'Getting some information',	''),
(1449,	3,	284,	'5',	'My nipples are hard and I\'m caressing my pussy right now. Lick my clitoris https://ladies-location.life/?u=wh5kd06&o=qxpp80k',	''),
(1450,	3,	285,	'7',	'FriceVab',	''),
(1451,	3,	285,	'8',	'vonak92@mail.ru',	''),
(1452,	3,	285,	'4',	'(755) 362-5577',	''),
(1453,	3,	285,	'6',	'Investing in a property',	''),
(1454,	3,	285,	'5',	'<a href=https://aktumauto.by/>аренда авто под выкуп минск</a> \r\n<a href=https://www.aktumauto.by>https://www.aktumauto.by</a> \r\n<a href=http://www.google.is/url?q=http://aktumauto.by>http://google.ps/url?q=http://aktumauto.by</a>',	''),
(1455,	3,	286,	'7',	'Julialinc',	''),
(1456,	3,	286,	'8',	'o-tendencii@yandex.ru',	''),
(1457,	3,	286,	'4',	'(314) 185-5726',	''),
(1458,	3,	286,	'6',	'Investing in a property',	''),
(1459,	3,	286,	'5',	'Подборки фотографий с красивыми поделками <a href=https://din-don.club/>https://din-don.club/</a>',	''),
(1460,	3,	287,	'7',	'urtaritual@rambler.ru',	''),
(1461,	3,	287,	'8',	'urtaritual@rambler.ru',	''),
(1462,	3,	287,	'4',	'(064) 436-5052',	''),
(1463,	3,	287,	'6',	'Investing in a property',	''),
(1464,	3,	287,	'5',	'Как ухаживать за водным транспортом.  Мойка и уборка на водном транспорте <a href=http://wb.matrixplus.ru/boatklining.htm>wb.matrixplus.ru</a> \r\nКак собрать с ребенком радиолюбительский компьютер, технологии, методики, сборки и настройки. \r\n<a href=http://rdk.regionsv.ru/orion128.htm>Орион-128 ПРК для учебы и программирования</a> \r\n \r\n \r\n<a href=http://wb.matrixplus.ru/index2-6.htm>wb.matrixplus.ru</a> \r\n \r\nХимия для клининга <a href=http://regionsv.ru/>купить химию для клининга и уборки</a>',	''),
(1465,	3,	288,	'7',	'Jameswaync',	''),
(1466,	3,	288,	'8',	'support@fire-flower.ru',	''),
(1467,	3,	288,	'4',	'(458) 138-8852',	''),
(1468,	3,	288,	'6',	'Investing in a property',	''),
(1469,	3,	288,	'5',	'<a href=https://fire-flower.ru/>РЎС‚РµРєР»Рѕ РїРѕРґ РєР°РјРёРЅ РЅР° РїРѕР» РєСѓРїРёС‚СЊ РІ РњРѕСЃРєРІРµ СЃ РґРѕСЃС‚Р°РІРєРѕР№</a> \r\n<a href=http://fire-flower.ru>http://www.fire-flower.ru/</a> \r\n<a href=http://google.com.et/url?q=https://fire-flower.ru>http://www.mmnt.org/cat/rp/fire-flower.ru</a>',	''),
(1470,	3,	289,	'7',	'Sdvilleneda',	''),
(1471,	3,	289,	'8',	'revers@o5o5.ru',	''),
(1472,	3,	289,	'4',	'(151) 668-0878',	''),
(1473,	3,	289,	'6',	'Investing in a property',	''),
(1474,	3,	289,	'5',	'<a href=https://chimmed.ru/>cisbio </a> \r\nTegs: cisbio eu  https://chimmed.ru/  \r\n \r\n<u>schmittmann-gmbh de </u> \r\n<i>schmittmann-gmbh.de </i> \r\n<b>sciencix </b>',	''),
(1475,	3,	290,	'7',	'Vasyatox',	''),
(1476,	3,	290,	'8',	'contabo_mer@outlook.com',	''),
(1477,	3,	290,	'4',	'(607) 813-6101',	''),
(1478,	3,	290,	'6',	'Investing in a property',	''),
(1479,	3,	290,	'5',	'<a href=http://dsapchits.com/ua/mandarin-fortune-slot-machine-from-2by2-gaming-play-for-free.html>casino megeve</a>\r\n<a href=https://katiamacedo.com.br/ts/wildblaster-casino-player-reviews-and-detailed-review.html>launceston casino</a>\r\n<a href=http://vprbaguio.xyz/wp-content/lib/online-casinos-accepting-hungarian-forint-huf-currency.html>catalina casino</a>\r\n<a href=https://nooraniilm.com/wp-content/lib/playojo-casino-player-reviews-and-detailed-review.html>black diamond casino</a>\r\n<a',	''),
(1480,	3,	291,	'7',	'Annarap',	''),
(1481,	3,	291,	'8',	'anna_fisher74@mail.ru',	''),
(1482,	3,	291,	'4',	'(588) 385-3558',	''),
(1483,	3,	291,	'6',	'Investing in a property',	''),
(1484,	3,	291,	'5',	'<a href=https://msk-life.ru>Факты о Москве</a>. Москва — сердце России, и этим всё сказано! В Москве нет недостат&#1',	''),
(1485,	3,	292,	'7',	'Charlotteiin',	''),
(1486,	3,	292,	'8',	'c.harlo.t.te.an.d.e.rso.n3.67@gmail.com',	''),
(1487,	3,	292,	'4',	'(103) 162-8371',	''),
(1488,	3,	292,	'6',	'Investing in a property',	''),
(1489,	3,	292,	'5',	'<a href=https://bit.ly/3L7KkFE>I know what to offer you tonight. Do you want this night to be unforgettable?</a>',	''),
(1490,	3,	293,	'7',	'Josezins',	''),
(1491,	3,	293,	'8',	'karimovvlad8@inbox.ru',	''),
(1492,	3,	293,	'4',	'(222) 722-7665',	''),
(1493,	3,	293,	'6',	'Investing in a property',	''),
(1494,	3,	293,	'5',	'Bitcoin Blender ether Bitcoin Mixer (Tumbler) <a href=https://blendor.online/>Mixer Bitcoin</a> <a href=http://treoijk4ht2if4ghwk7h6qjy2klxfqoewxsfp3dip4wkxppyuizdw5qd.onion>Mixer Bitcoin (onion)</a> \r\n \r\n \r\nYears you start a bitcoin transportation, we get to dozing section in search 1 confirmation from the bitcoin network to insure the bitcoins clear. This customarily takes saintly a unsociable a unchanging minutes and then the scenario purposefulness send you to in nappies coins to your at th',	''),
(1495,	3,	294,	'7',	'Beaiunlicky',	''),
(1496,	3,	294,	'8',	'boksijk1@superbox.pl',	''),
(1497,	3,	294,	'4',	'(056) 271-7407',	''),
(1498,	3,	294,	'6',	'Investing in a property',	''),
(1499,	3,	294,	'5',	'https://www.wakacjejeziorohancza.online \r\nnoclegi nad morzem bon turystyczny domki https://www.wakacjejeziorohancza.online/psem-tanie-podlaskie-noclegi-w-z-noclegi-podlaskiej-biaej',	''),
(1500,	3,	295,	'7',	'Gaflus',	''),
(1501,	3,	295,	'8',	'l.aw.r.en.ced.erri.c.k.ynu7.aq@gmail.com',	''),
(1502,	3,	295,	'4',	'(388) 633-8522',	''),
(1503,	3,	295,	'6',	'Getting some information',	''),
(1504,	3,	295,	'5',	'Воспользовавшись ситуацией несколько местных девочек на глазах но это мало того что порно мало того что детское порно героине 1 лет так еще. Такое впечатление что у режиссера какой-то пунктик на тему мужских гениталий и child porn смотреть  <>url] бы не уделял этому столько внимания если бы режиссер сам крупным планом. A RTP1 o principal canal de televiso da Rdio e Televiso de Portugal e o primeiro canal portugus de rdio e televiso um canal generalista com. Голосовой помощник Алиса от Яндекса на',	''),
(1505,	3,	296,	'7',	'MickesVab',	''),
(1506,	3,	296,	'8',	'ibagtre@rambler.ru',	''),
(1507,	3,	296,	'4',	'(780) 456-6784',	''),
(1508,	3,	296,	'6',	'Investing in a property',	''),
(1509,	3,	296,	'5',	'<a href=https://pistolet-ustroystvo-pioner.ru/>газ в баллончиках</a> \r\n<a href=http://magazin-shokerov-v-spb.ru>https://www.magazin-shokerov-v-spb.ru/</a> \r\n<a href=https://cse.google.ie/url?q=http://site.ru>http://pagecs.net/site.ru</a>',	''),
(1510,	3,	297,	'7',	'Sonyaneele',	''),
(1511,	3,	297,	'8',	'woodthighgire1988@gmail.com',	''),
(1512,	3,	297,	'4',	'(103) 137-2043',	''),
(1513,	3,	297,	'6',	'Getting some information',	''),
(1514,	3,	297,	'5',	'Hey handsome! I\'m a sexy girl. Ready to fulfill all your fantasies https://bunnyvv.space/click?o=6&a=1036',	''),
(1515,	3,	298,	'7',	'Ramoncep',	''),
(1516,	3,	298,	'8',	'tha.n.nes.inc@gmail.com',	''),
(1517,	3,	298,	'4',	'(473) 451-8720',	''),
(1518,	3,	298,	'6',	'Investing in a property',	''),
(1519,	3,	298,	'5',	'Only our script will protect your site from ddos attacks   \r\n \r\nLearn more on the site :   <a href=\"https://zerocode.su/index.php?threads/ddos-protection-level-l1-l2-l3-l4-l5-l6-l7.30/#post-217\"> Is there protection against DDoS?',	''),
(1520,	3,	299,	'7',	'Elizahzu',	''),
(1521,	3,	299,	'8',	'el.i.z.ab.e.t.hh.e.rn.a.n.d.ez.3.w.3@gmail.com',	''),
(1522,	3,	299,	'4',	'(068) 417-2100',	''),
(1523,	3,	299,	'6',	'Investing in a property',	''),
(1524,	3,	299,	'5',	'<a href=https://goo.su/vENeldz>Fuck me in the Ass!!! I am waiting...</a> \r\n<a href=https://goo.su/vENeldz><img src=\"https://i.ibb.co/WtpTJWr/a11a61daa09ca6321a4678e76eb4a848.jpg\"></a>',	''),
(1525,	3,	300,	'7',	'Brolus',	''),
(1526,	3,	300,	'8',	's.co.t.tr.ob.bin.s.db.rm.5.u.@gmail.com',	''),
(1527,	3,	300,	'4',	'(708) 142-1661',	''),
(1528,	3,	300,	'6',	'Getting some information',	''),
(1529,	3,	300,	'5',	'Кафедры и войти ЧЕРЕЗ ГОСУСЛУГИ РУ. Понятие государственного или на канале ТНВ Новый закон х бю д 5 0 0 0 0 0. На портале <a href=http://kommunar.propiska-official.site/>Временная регистрация для военкомата в Кувандыке  </a> - <a href=http://malgobek.propiska-official.site/>Временная регистрация сделать в Кореновске  </a> Госуслуги будет если в городском округе Люберцы Московской области оказывающих муниципальную услугу в качестве Национального расчетного счета специалист руководителя компании К',	''),
(1530,	3,	301,	'7',	'Garitox',	''),
(1531,	3,	301,	'8',	'ukraine774677@outlook.com',	''),
(1532,	3,	301,	'4',	'(583) 175-1351',	''),
(1533,	3,	301,	'6',	'Investing in a property',	''),
(1534,	3,	301,	'5',	'<a href=https://cryptodds.com/wp-content/lib/slot-machine-kamchatka-play-for-free.html>hard rock casino tampa hours</a>\r\n<a href=https://beststoreng.xyz/wp-content/lib/renegades-slot-machine-from-nextgen-gaming-play-for-free.html>graton casino open</a>\r\n<a href=http://alovex.co/li>how to start a dating app</a>\r\n<a href=https://www.centre-equestre-villiers.fr/li/map1.php>dating sites for black men</a>\r\n<a href=https://hrs-software.com/online-casino-with-belatra-games-software-belatra-gam',	''),
(1535,	3,	302,	'7',	'shush_mnr',	''),
(1536,	3,	302,	'8',	'jkhdfhfdj34d@intermediate-website.store',	''),
(1537,	3,	302,	'4',	'(665) 211-1512',	''),
(1538,	3,	302,	'6',	'Investing in a property',	''),
(1539,	3,	302,	'5',	'самые крутые сайты <a href=https://shush-skk.ru/>http://shush-skk.ru/</a>',	''),
(1540,	3,	303,	'7',	'Annarap',	''),
(1541,	3,	303,	'8',	'anna_fisher74@mail.ru',	''),
(1542,	3,	303,	'4',	'(420) 307-1805',	''),
(1543,	3,	303,	'6',	'Investing in a property',	''),
(1544,	3,	303,	'5',	'bloggingorigin.com Blog  is your high-quality <a href=https://bloggingorigin.com>Breaking news</a> source of everything that you need to know about what is going on in the Sport community and abroad including vehicles and equipment, breaking news, international news and more. We focus on the people, the issues, the events and the technologies that drive tomorrow\'s response.',	''),
(1545,	3,	304,	'7',	'Samuelhen',	''),
(1546,	3,	304,	'8',	'damian.sobor922@wp.pl',	''),
(1547,	3,	304,	'4',	'(545) 851-3801',	''),
(1548,	3,	304,	'6',	'Investing in a property',	''),
(1549,	3,	304,	'5',	'Dokąd ślepić obrazy online zbytnio bezowocnie? Reguła najciekawszych cech 2022! \r\n \r\nKażdy z nas kocha należeć do kina lub badać negatywy online w internecie. W końcowych kilku latkach w Polsce zdecydowanie zaanektowała się kandydatura tudzież baza negatywów dogodnych nadmiernie poparciem internetu. Mocną glebę zagrała w obecnym nurt serwów VOD – bieg Netflixa, Player albo CDA Premium. Jakiś z tych&#3',	''),
(1550,	3,	305,	'7',	'Lindseyben',	''),
(1551,	3,	305,	'8',	'channel.indomito@gmail.com',	''),
(1552,	3,	305,	'4',	'(786) 410-3363',	''),
(1553,	3,	305,	'6',	'Getting some information',	''),
(1554,	3,	305,	'5',	'Лучшие гайды и обзоры по танкам игры <a href=https://www.youtube.com/c/INDOMITOWOT>WOT</a> \r\nна нашем канале только самая свежая информация. \r\n \r\nCегодня у нас в центре внимания оказался один из знаменитейших представителей песочницы, <a href=https://www.youtube.com/watch?v=8eBTsWDFIiA>БТ-2 гайд</a> советский легкий танк второго уровня. \r\nВ мире танков наш <a href=https://www.youtube.com/watch?v=h6LeXIipm_Q>БТ-5 guide</a> сможет чувствовать себя комфортно не только в топе. \r\nCегодня в гайде мы п',	''),
(1555,	3,	306,	'7',	'typodar_kic',	''),
(1556,	3,	306,	'8',	'typodar@gmail.com',	''),
(1557,	3,	306,	'4',	'(556) 063-8103',	''),
(1558,	3,	306,	'6',	'Investing in a property',	''),
(1559,	3,	306,	'5',	'Паблик с единственным правильным мнением, имеющий только лояльную аудиторию. При малейшем сомнении в лояльности, подписчик удаляется. Таким образом, предлагаем Вашему вниманию рекламную площадку, зачищенную от ненужных мнений. Мы не уважаем вату и/или ура-аутистов. Всё будет Туподар! Подписывайтесь, заказывайте рекламу. Нас больше 250к! \r\ntypodar@gmail.com \r\n<a href=https://vk.com/typodar>VK</a> \r\n<a href=https://www.instagram.com/typodar/>Instagram</a> \r\n<a href=https://t.me/typodar>Telegram</a',	''),
(1560,	3,	307,	'7',	'AslanDIP',	''),
(1561,	3,	307,	'8',	'aslan@my-mail.site',	''),
(1562,	3,	307,	'4',	'(051) 474-0036',	''),
(1563,	3,	307,	'6',	'Getting some information',	''),
(1564,	3,	307,	'5',	'<a href=https://3d-pechat-ekaterinburg.ru/></a> \r\nI ordered 3D-printing from this studio <a href=https://3d-pechat-ekaterinburg.ru>http://www.3d-pechat-ekaterinburg.ru/</a> I was very glad with the result. Inexpensive and qualitatively. I recommend everyone. \r\n<a href=https://voensud.ru/go/?http://3d-pechat-ekaterinburg.ru>https://google.cc/url?q=http://3d-pechat-ekaterinburg.ru</a>',	''),
(1565,	3,	308,	'7',	'BrandonCab',	''),
(1566,	3,	308,	'8',	'artur-abramov-1961@bk.ru',	''),
(1567,	3,	308,	'4',	'(305) 332-6440',	''),
(1568,	3,	308,	'6',	'Getting some information',	''),
(1569,	3,	308,	'5',	'<a href=https://damian-m.ru/magazin/folder/80755803>бак нержавейка </a>\r\n   <a href=https://damian-m.ru/magazin/folder/56149403>умывальник для дачи </a>\r\n   <a href=https://damian-m.ru/magazin/folder/313398601>нержавейка бак </a>\r\n    идей и опыта, полученного от предков, а также в результате длительной работы в отрасли <a href=https://damian-m.ru/magazin/folder/438138801>гипсовые панели </a>\r\n    А этим просто нельзя не поделиться с окружающими <a href=https://damian-m.ru/magazin/folder/439',	''),
(1570,	3,	309,	'7',	'RichardCrage',	''),
(1571,	3,	309,	'8',	'ksyusha.vorobeva.93@bk.ru',	''),
(1572,	3,	309,	'4',	'(805) 162-1567',	''),
(1573,	3,	309,	'6',	'Getting some information',	''),
(1574,	3,	309,	'5',	'Но следует заметить, что использование только кованой мебели в оформлении прихожей будет смотреться очень вульгарно, стоит добавить деревянные предметы интерьера <a href=https://damian-m.ru/magazin/folder/313398601>3d панели для стен </a>\r\n   Например, обычный платяной шкаф отлично дополнится кованой напольной вешалкой, а кованное зеркало украсит стену над деревянным комодом <a href=https://damian-m.ru/magazin/folder/umyvalnik-dlya-dachi-iz-nerzhaveyki>столик журнальный стеклянный </a>\r\n \r\nВ кат',	''),
(1575,	3,	310,	'7',	'uliyantreb',	''),
(1576,	3,	310,	'8',	'uliyantreb@rambler.ru',	''),
(1577,	3,	310,	'4',	'(415) 830-2027',	''),
(1578,	3,	310,	'6',	'Investing in a property',	''),
(1579,	3,	310,	'5',	'Все про массаж и нетолько. Техника массажа. <a href=http://freshrelax.ru/>Методики массажа</a> \r\nКак сделать спортивный массаж, косметический, лечебный. \r\n<a href=http://infanta.freshrelax.ru/>Посетить эротический массажа</a> \r\nТантрический и сексуальный массаж <a href=http://tantra64.ru/>посетить в Саратове, любовный массажа</a> \r\n \r\nВсе о методиках массажа, красота за 30 дней:  \r\n<a href=http://freshrelax.ru/samomassage-020.htm>freshrelax.ru</a> \r\nВсе способы массажа, методики массажа и техник',	''),
(1580,	3,	311,	'7',	'PutinCesar',	''),
(1581,	3,	311,	'8',	'a.tuzhikov@eeyptf.bizml.ru',	''),
(1582,	3,	311,	'4',	'(182) 210-6111',	''),
(1583,	3,	311,	'6',	'Getting some information',	''),
(1584,	3,	311,	'5',	'https://www.belmabeautycenter.fi/ \r\nhttps://morelife.fi/ \r\nhttps://www.kauneushoitolavillatuila.fi/ \r\nhttps://www.sannabc.fi/ \r\nhttps://kauneuskeskusfenix.fi/kauneushoitola-kauniainen/ \r\nhttps://bluelagoon.fi/liike/blue-lagoon-iso-omena/ \r\nhttps://lachica.fi/iso-omena/ \r\nhttps://lachica.fi/la-chica-tapiola-ainoa/ \r\nhttps://mariacare.fi/',	''),
(1585,	3,	312,	'7',	'Josephiaikju',	''),
(1586,	3,	312,	'8',	'josep.hi.n.e.guti.e.r.re.z1.990@gmail.com',	''),
(1587,	3,	312,	'4',	'(436) 213-7523',	''),
(1588,	3,	312,	'6',	'Investing in a property',	''),
(1589,	3,	312,	'5',	'<a href=https://goo.su/5O4dh9B>What\'s up? Chat? I like 30-39 old guys, is it You?</a>',	''),
(1590,	3,	313,	'7',	'MattJut',	''),
(1591,	3,	313,	'8',	'mattthedev383@gmail.com',	''),
(1592,	3,	313,	'4',	'(343) 088-6488',	''),
(1593,	3,	313,	'6',	'Getting some information',	''),
(1594,	3,	313,	'5',	'Hello my name is Matt and I\'m from Seattle USA, I\'m a huge fan of your fabulous website, however I\'ve noticed it lacks proper SEO. \r\n \r\nI can offer my assistance for free, if you wish. I have 7+ years in the SEO field and would gladly help you out. You can contact me at +1 (206)923-9546. \r\n \r\nI\'m only offering this for a limited time.',	''),
(1595,	3,	314,	'7',	'John Bartlett',	''),
(1596,	3,	314,	'8',	'john@system4-losangeleswest.com',	''),
(1597,	3,	314,	'4',	'(832) 261-9325',	''),
(1598,	3,	314,	'6',	'Getting some information',	''),
(1599,	3,	314,	'5',	'Are you interested in receiving a professional janitorial or disinfection quote for your business?\r\n\r\nI’d like to provide a strategy that will take care of all your facility needs, along with excellent communication and customer service.\r\n\r\nJust send me a quick reply and I’d be happy to schedule a site visit and give you a complimentary, no-obligation quote.\r\n\r\nRegards,\r\nJohn\r\n\r\nJohn Bartlett\r\nExecutive\r\nSystem4 Facility Services\r\n832-261-9325\r\njohn@system4-losangeleswest.com\r\n\r\nPlease respond w',	''),
(1600,	3,	315,	'7',	'Elizabeth Singh',	''),
(1601,	3,	315,	'8',	'Elizabeth.Singh@howtocareforyou.com',	''),
(1602,	3,	315,	'4',	'(562) 426-7002',	''),
(1603,	3,	315,	'6',	'Getting some information',	''),
(1604,	3,	315,	'5',	'Hello,\r\n\r\nWhen launching a business from home, having a location that can be used for both living and running a business is critical.\r\n\r\nI\'d be happy to write an article for your website about how to start a business while simultaneously moving if your existing home isn\'t large enough for both living and working. The article will cover topics such as reducing stress during the transition, home buying, relocating to a new place, and starting a home-based business. It will also include advice on h',	''),
(1605,	3,	316,	'7',	'Sakshi Agrawal',	''),
(1606,	3,	316,	'8',	'sakshiagrawal9011@gmail.com',	''),
(1607,	3,	316,	'4',	'(076) 930-0275',	''),
(1608,	3,	316,	'6',	'Getting some information',	''),
(1609,	3,	316,	'5',	'Hi there, \r\nI am a web developer with extensive experience in web design, graphic design, HTML, among others, I can start with the design of the mockup for your forex trading website, I will show you examples of previous work I have done, I invite you To review my ratings from previous clients, \r\n\r\nplease contact via chat for more details, \r\nThanks\r\nSakshi',	''),
(1610,	3,	317,	'7',	'Sakshi Agrawal',	''),
(1611,	3,	317,	'8',	'sakshiagrawal9011@gmail.com',	''),
(1612,	3,	317,	'4',	'(076) 930-0275',	''),
(1613,	3,	317,	'6',	'Getting some information',	''),
(1614,	3,	317,	'5',	'Hi there, \r\nI am a web developer with extensive experience in web design, graphic design, HTML, among others, I can start with the design of the mockup for your forex trading website, I will show you examples of previous work I have done, I invite you To review my ratings from previous clients, \r\n\r\nplease contact via chat for more details, \r\nThanks\r\nSakshi',	''),
(1615,	3,	318,	'7',	'John Bartlett',	''),
(1616,	3,	318,	'8',	'john@system4-losangeleswest.com',	''),
(1617,	3,	318,	'4',	'(424) 377-2767',	''),
(1618,	3,	318,	'6',	'Getting some information',	''),
(1619,	3,	318,	'5',	'Are you interested in receiving a professional janitorial or disinfection quote for your business?\r\n\r\nI’d like to provide a strategy that will take care of all your facility needs, along with excellent communication and customer service.\r\n\r\nJust send me a quick reply and I’d be happy to schedule a site visit and give you a complimentary, no-obligation quote.\r\n\r\nRegards,\r\nJohn\r\n\r\nPlease respond with \"stop\" to opt out.',	''),
(1620,	3,	319,	'7',	'John Bartlett',	''),
(1621,	3,	319,	'8',	'john@system4-losangeleswest.com',	''),
(1622,	3,	319,	'4',	'(424) 377-2767',	''),
(1623,	3,	319,	'6',	'Selling a home',	''),
(1624,	3,	319,	'5',	'Are you interested in receiving a professional janitorial or disinfection quote for your business?\r\n\r\nI’d like to provide a strategy that will take care of all your facility needs, along with excellent communication and customer service.\r\n\r\nJust send me a quick reply and I’d be happy to schedule a site visit and give you a complimentary, no-obligation quote.\r\n\r\nRegards,\r\nJohn\r\n\r\nJohn Bartlett\r\nOwner\r\nSystem4 Facility Services\r\n(424) 377-2767\r\njohn@system4-losangeleswest.com\r\n\r\nPlease respond w',	''),
(1625,	3,	320,	'7',	'Dan Hendryx',	''),
(1626,	3,	320,	'8',	'dan@gulfstatecapital.net',	''),
(1627,	3,	320,	'4',	'(251) 283-4771',	''),
(1628,	3,	320,	'6',	'Getting some information',	''),
(1629,	3,	320,	'5',	'Do you need funding quickly to re-invest in your business? If the banks say “no,” Gulf State Capital provides a great alternative.\r\n\r\nWe can give you preliminary approval and funds within 24 to 48 hours. It’s a straightforward process with no surprises or unnecessary red tape.\r\n\r\nTo qualify, you will need revenues that average $50k/month or more.\r\n\r\nWe also have SBA financing, Lines of Credit, Term Loans, and Debt Consolidation partnerships around the country. Everyone\'s need is different and we',	''),
(1630,	3,	321,	'7',	'Tim Curran',	''),
(1631,	3,	321,	'8',	'timcurran@tlcinstallers.com',	''),
(1632,	3,	321,	'4',	'(310) 328-7762',	''),
(1633,	3,	321,	'6',	'Getting some information',	''),
(1634,	3,	321,	'5',	'Please pay the invoice dated 4/12/2023 for 1440 Kings Road.\r\n\r\n$1,085.00\r\nContact Dan Curran at 310 350-8766 to pay by credit card or make arrangements for him to pick up a check. Please do so asap I am leaving 1 star reviews on yelp and google for your business this morning with explanation. I will leave update reviews after you pay the bill.',	''),
(1635,	3,	322,	'7',	'Kenneth Hall',	''),
(1636,	3,	322,	'8',	'kennethhall0711@gmail.com',	''),
(1637,	3,	322,	'4',	'(408) 585-5364',	''),
(1638,	3,	322,	'6',	'Getting some information',	''),
(1639,	3,	322,	'5',	'Looking for exceptional janitorial services for your facility? Exceptional Cleaners is here to provide just that. Would you like to receive a free quote for your facility\'s janitorial needs?',	''),
(1640,	3,	323,	'7',	'Kenneth Hall',	''),
(1641,	3,	323,	'8',	'kennethhall0711@gmail.com',	''),
(1642,	3,	323,	'4',	'(408) 585-5364',	''),
(1643,	3,	323,	'6',	'Buying a home',	''),
(1644,	3,	323,	'5',	'I would like to confirm if you received my previous email. As a company that specializes in janitorial services, Exceptional Cleaners would like to offer you a free estimate for your facility\'s cleaning needs. Are you interested in this opportunity?',	''),
(1645,	3,	324,	'7',	'Kenneth Hall',	''),
(1646,	3,	324,	'8',	'kennethhall0711@gmail.com',	''),
(1647,	3,	324,	'4',	'(408) 585-5364',	''),
(1648,	3,	324,	'6',	'Getting some information',	''),
(1649,	3,	324,	'5',	'I would like to confirm if you received my previous email. As a company that specializes in janitorial services, Exceptional Cleaners would like to offer you a free estimate for your facility\'s cleaning needs. Are you interested in this opportunity?',	''),
(1650,	3,	325,	'7',	'Kenneth Hall',	''),
(1651,	3,	325,	'8',	'kennethhall0711@gmail.com',	''),
(1652,	3,	325,	'4',	'(408) 585-5364',	''),
(1653,	3,	325,	'6',	'Buying a home',	''),
(1654,	3,	325,	'5',	'Is your facility in need of janitorial services? Exceptional Cleaners specializes in providing such services and we would be happy to offer you a free quote.',	''),
(1655,	3,	326,	'7',	'John Bartlett',	''),
(1656,	3,	326,	'8',	'john@system4-losangeleswest.com',	''),
(1657,	3,	326,	'4',	'(424) 377-2767',	''),
(1658,	3,	326,	'6',	'Selling a home',	''),
(1659,	3,	326,	'5',	'Hi, Are you interested in receiving a professional janitorial or disinfection quote for your business?\r\n\r\nI’d like to provide a strategy that will take care of all your facility needs, along with excellent communication and customer service.\r\n\r\nJust send me a quick reply and I’d be happy to schedule a site visit and give you a complimentary, no-obligation quote.\r\n\r\nRegards,\r\nJohn\r\n\r\nJohn Bartlett\r\nOwner\r\nSystem4 Facility Services\r\n(424) 377-2767\r\njohn@system4-losangeleswest.com\r\n\r\nPlease respond',	'');

DROP TABLE IF EXISTS `wp_gf_entry_notes`;
CREATE TABLE `wp_gf_entry_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` int(10) unsigned NOT NULL,
  `user_name` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  `note_type` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `sub_type` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `entry_id` (`entry_id`),
  KEY `entry_user_key` (`entry_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_gf_entry_notes` (`id`, `entry_id`, `user_name`, `user_id`, `date_created`, `value`, `note_type`, `sub_type`) VALUES
(1,	1,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2020-11-10 12:46:21',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(2,	1,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2020-11-10 12:46:21',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(3,	2,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2020-11-28 04:09:26',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(4,	2,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2020-11-28 04:09:27',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(5,	3,	'Admin Notification (ID: 5320cef46d2b6)',	0,	'2020-12-04 16:54:56',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(6,	3,	'Agent Notification (ID: 5e5572622a243)',	0,	'2020-12-04 16:54:56',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(7,	4,	'Admin Notification (ID: 5320cef46d2b6)',	0,	'2020-12-04 16:55:49',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(8,	4,	'Agent Notification (ID: 5e5572622a243)',	0,	'2020-12-04 16:55:49',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(9,	5,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2020-12-09 19:23:05',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(10,	5,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2020-12-09 19:23:05',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(11,	6,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2020-12-23 11:09:54',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(12,	6,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2020-12-23 11:09:54',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(13,	7,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-02-13 19:37:06',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(14,	7,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-02-13 19:37:06',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(15,	8,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-03-10 17:59:43',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(16,	8,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-03-10 17:59:43',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(17,	9,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-03-19 22:37:45',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(18,	9,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-03-19 22:37:45',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(19,	10,	'Admin Notification (ID: 5320cef46d2b6)',	0,	'2021-03-19 23:24:03',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(20,	10,	'Agent Notification (ID: 5e5572622a243)',	0,	'2021-03-19 23:24:03',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(21,	11,	'Admin Notification (ID: 5320cef46d2b6)',	0,	'2021-03-19 23:25:03',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(22,	11,	'Agent Notification (ID: 5e5572622a243)',	0,	'2021-03-19 23:25:03',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(23,	12,	'Admin Notification (ID: 5320cef46d2b6)',	0,	'2021-03-21 01:13:54',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(24,	12,	'Agent Notification (ID: 5e5572622a243)',	0,	'2021-03-21 01:13:55',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(25,	13,	'Admin Notification (ID: 5320cef46d2b6)',	0,	'2021-03-21 01:15:39',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(26,	13,	'Agent Notification (ID: 5e5572622a243)',	0,	'2021-03-21 01:15:39',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(27,	14,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-04-12 14:34:54',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(28,	14,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-04-12 14:34:54',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(29,	15,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-06-02 06:11:28',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(30,	15,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-06-02 06:11:28',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(31,	16,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-06-03 09:58:06',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(32,	16,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-06-03 09:58:06',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(33,	17,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-06-19 23:20:03',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(34,	17,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-06-19 23:20:03',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(35,	18,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-06-30 15:16:48',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(36,	18,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-06-30 15:16:49',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(37,	19,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-02 10:05:30',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(38,	19,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-02 10:05:30',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(39,	20,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-05 07:09:57',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(40,	20,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-05 07:09:57',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(41,	21,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-05 08:47:06',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(42,	21,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-05 08:47:06',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(43,	22,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-05 19:59:41',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(44,	22,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-05 19:59:41',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(45,	23,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-06 01:21:14',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(46,	23,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-06 01:21:14',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(47,	24,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-06 21:36:44',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(48,	24,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-06 21:36:44',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(49,	25,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-06 23:56:25',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(50,	25,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-06 23:56:25',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(51,	26,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-07 06:52:27',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(52,	26,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-07 06:52:28',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(53,	27,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-07 08:28:57',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(54,	27,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-07 08:28:57',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(55,	28,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-07 15:54:03',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(56,	28,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-07 15:54:03',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(57,	29,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-07 15:54:16',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(58,	29,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-07 15:54:16',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(59,	30,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-09 09:41:50',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(60,	30,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-09 09:41:50',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(61,	31,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-10 17:07:45',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(62,	31,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-10 17:07:45',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(63,	32,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-10 22:36:41',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(64,	32,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-10 22:36:42',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(65,	33,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-11 20:42:59',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(66,	33,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-11 20:42:59',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(67,	34,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-12 05:00:23',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(68,	34,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-12 05:00:23',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(69,	35,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-13 00:47:58',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(70,	35,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-13 00:47:58',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(71,	36,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-13 19:28:27',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(72,	36,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-13 19:28:27',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(73,	37,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-14 18:19:47',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(74,	37,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-14 18:19:47',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(75,	38,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-14 20:32:14',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(76,	38,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-14 20:32:14',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(77,	39,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-16 08:57:54',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(78,	39,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-16 08:57:54',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(79,	40,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-16 18:55:36',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(80,	40,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-16 18:55:36',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(81,	41,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-19 04:17:17',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(82,	41,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-19 04:17:18',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(83,	42,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-19 05:37:25',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(84,	42,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-19 05:37:26',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(85,	43,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-19 21:03:08',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(86,	43,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-19 21:03:08',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(87,	44,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-19 22:30:35',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(88,	44,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-19 22:30:35',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(89,	45,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-21 08:41:43',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(90,	45,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-21 08:41:43',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(91,	46,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-23 08:50:37',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(92,	46,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-23 08:50:38',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(93,	47,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-23 13:49:09',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(94,	47,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-23 13:49:09',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(95,	48,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-23 14:47:38',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(96,	48,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-23 14:47:38',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(97,	49,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-26 13:23:36',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(98,	49,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-26 13:23:36',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(99,	50,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-27 03:02:32',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(100,	50,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-27 03:02:32',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(101,	51,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-27 05:59:10',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(102,	51,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-27 05:59:10',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(103,	52,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-28 20:14:48',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(104,	52,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-28 20:14:48',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(105,	53,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-07-28 21:31:23',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(106,	53,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-07-28 21:31:23',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(107,	54,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-01 06:13:54',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(108,	54,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-01 06:13:54',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(109,	55,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-01 13:27:07',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(110,	55,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-01 13:27:07',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(111,	56,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-01 13:28:13',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(112,	56,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-01 13:28:13',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(113,	57,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-03 11:43:50',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(114,	57,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-03 11:43:50',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(115,	58,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-03 23:04:32',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(116,	58,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-03 23:04:32',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(117,	59,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-04 21:59:32',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(118,	59,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-04 21:59:32',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(119,	60,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-05 06:26:09',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(120,	60,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-05 06:26:09',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(121,	61,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-06 02:59:55',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(122,	61,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-06 02:59:55',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(123,	62,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-06 13:56:26',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(124,	62,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-06 13:56:26',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(125,	63,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-07 14:55:10',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(126,	63,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-07 14:55:10',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(127,	64,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-10 19:41:57',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(128,	64,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-10 19:41:57',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(129,	65,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-13 03:34:33',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(130,	65,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-13 03:34:33',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(131,	66,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-13 03:34:58',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(132,	66,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-13 03:34:58',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(133,	67,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-13 20:17:17',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(134,	67,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-13 20:17:17',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(135,	68,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-16 02:31:58',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(136,	68,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-16 02:31:58',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(137,	69,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-16 04:04:11',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(138,	69,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-16 04:04:11',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(139,	70,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-16 06:05:03',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(140,	70,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-16 06:05:03',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(141,	71,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-18 12:56:32',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(142,	71,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-18 12:56:32',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(143,	72,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-19 22:07:43',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(144,	72,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-19 22:07:43',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(145,	73,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-22 19:12:45',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(146,	73,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-22 19:12:45',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(147,	74,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-25 00:58:19',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(148,	74,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-25 00:58:19',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(149,	75,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-25 09:29:01',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(150,	75,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-25 09:29:01',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(151,	76,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-26 01:09:11',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(152,	76,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-26 01:09:11',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(153,	77,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-27 08:37:57',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(154,	77,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-27 08:37:57',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(155,	78,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-27 09:25:28',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(156,	78,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-27 09:25:28',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(157,	79,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-27 11:52:28',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(158,	79,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-27 11:52:28',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(159,	80,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-27 20:52:09',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(160,	80,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-27 20:52:10',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(161,	81,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-30 05:57:53',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(162,	81,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-30 05:57:53',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(163,	82,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-08-30 21:25:22',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(164,	82,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-08-30 21:25:23',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(165,	83,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-01 16:12:01',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(166,	83,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-01 16:12:01',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(167,	84,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-04 14:39:57',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(168,	84,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-04 14:39:57',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(169,	85,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-05 10:40:42',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(170,	85,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-05 10:40:42',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(171,	86,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-06 10:44:02',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(172,	86,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-06 10:44:02',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(173,	87,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-06 10:44:26',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(174,	87,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-06 10:44:27',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(175,	88,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-06 11:42:46',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(176,	88,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-06 11:42:47',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(177,	89,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-06 12:29:43',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(178,	89,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-06 12:29:44',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(179,	90,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-06 15:25:09',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(180,	90,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-06 15:25:09',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(181,	91,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-07 17:06:40',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(182,	91,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-07 17:06:40',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(183,	92,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-07 18:28:20',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(184,	92,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-07 18:28:20',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(185,	93,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-09 03:30:47',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(186,	93,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-09 03:30:47',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(187,	94,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-09 16:30:49',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(188,	94,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-09 16:30:49',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(189,	95,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-10 07:02:53',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(190,	95,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-10 07:02:53',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(191,	96,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-12 06:44:06',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(192,	96,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-12 06:44:06',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(193,	97,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-12 16:00:02',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(194,	97,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-12 16:00:03',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(195,	98,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-12 23:04:16',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(196,	98,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-12 23:04:16',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(197,	99,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-13 12:26:11',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(198,	99,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-13 12:26:11',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(199,	100,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-15 05:21:12',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(200,	100,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-15 05:21:12',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(201,	101,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-18 01:02:13',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(202,	101,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-18 01:02:14',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(203,	102,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-18 07:37:46',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(204,	102,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-18 07:37:46',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(205,	103,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-20 09:18:51',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(206,	103,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-20 09:18:51',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(207,	104,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-20 09:19:21',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(208,	104,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-20 09:19:21',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(209,	105,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-21 04:55:42',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(210,	105,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-21 04:55:42',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(211,	106,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-23 14:24:59',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(212,	106,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-23 14:24:59',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(213,	107,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-23 15:08:22',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(214,	107,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-23 15:08:22',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(215,	108,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-24 16:44:19',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(216,	108,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-24 16:44:19',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(217,	109,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-24 19:34:02',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(218,	109,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-24 19:34:02',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(219,	110,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-24 22:44:49',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(220,	110,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-24 22:44:49',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(221,	111,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-27 04:11:55',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(222,	111,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-27 04:11:55',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(223,	112,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-27 23:35:20',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(224,	112,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-27 23:35:20',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(225,	113,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-28 19:49:53',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(226,	113,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-28 19:49:53',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(227,	114,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-30 01:29:20',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(228,	114,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-30 01:29:20',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(229,	115,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-09-30 15:46:42',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(230,	115,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-09-30 15:46:42',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(231,	116,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-01 13:57:21',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(232,	116,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-01 13:57:21',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(233,	117,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-04 03:50:06',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(234,	117,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-04 03:50:06',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(235,	118,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-05 17:07:19',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(236,	118,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-05 17:07:20',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(237,	119,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-07 06:14:52',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(238,	119,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-07 06:14:52',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(239,	120,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-07 09:13:08',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(240,	120,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-07 09:13:08',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(241,	121,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-07 22:35:49',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(242,	121,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-07 22:35:49',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(243,	122,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-10 05:54:11',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(244,	122,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-10 05:54:11',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(245,	123,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-12 22:23:26',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(246,	123,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-12 22:23:27',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(247,	124,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-17 07:29:05',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(248,	124,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-17 07:29:06',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(249,	125,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-17 07:46:34',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(250,	125,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-17 07:46:34',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(251,	126,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-20 06:11:30',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(252,	126,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-20 06:11:30',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(253,	127,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-21 15:22:07',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(254,	127,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-21 15:22:07',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(255,	128,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-22 07:13:15',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(256,	128,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-22 07:13:15',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(257,	129,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-22 10:12:50',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(258,	129,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-22 10:12:50',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(259,	130,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-24 01:23:25',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(260,	130,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-24 01:23:25',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(261,	131,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-24 09:31:15',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(262,	131,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-24 09:31:15',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(263,	132,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-25 06:16:15',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(264,	132,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-25 06:16:15',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(265,	133,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-26 13:24:17',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(266,	133,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-26 13:24:17',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(267,	134,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-27 07:03:00',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(268,	134,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-27 07:03:00',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(269,	135,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-28 23:32:19',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(270,	135,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-28 23:32:19',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(271,	136,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-30 06:41:38',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(272,	136,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-30 06:41:38',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(273,	137,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-30 09:21:46',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(274,	137,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-30 09:21:46',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(275,	138,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-10-31 00:10:40',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(276,	138,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-10-31 00:10:41',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(277,	140,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-02 13:10:14',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(278,	140,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-02 13:10:14',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(279,	139,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-02 13:10:15',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(280,	139,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-02 13:10:15',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(281,	141,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-04 00:37:46',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(282,	141,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-04 00:37:46',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(283,	142,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-04 03:16:35',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(284,	142,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-04 03:16:35',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(285,	143,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-04 09:11:42',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(286,	143,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-04 09:11:43',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(287,	144,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-07 01:33:51',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(288,	144,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-07 01:33:52',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(289,	145,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-07 11:59:38',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(290,	145,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-07 11:59:38',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(291,	146,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-08 11:16:53',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(292,	146,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-08 11:16:53',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(293,	147,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-08 19:36:46',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(294,	147,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-08 19:36:47',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(295,	148,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-10 10:45:51',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(296,	148,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-10 10:45:52',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(297,	149,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-11 15:15:33',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(298,	149,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-11 15:15:33',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(299,	150,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-11 18:49:30',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(300,	150,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-11 18:49:31',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(301,	151,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-11 18:49:52',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(302,	151,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-11 18:49:52',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(303,	152,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-12 17:05:07',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(304,	152,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-12 17:05:07',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(305,	153,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-13 11:41:53',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(306,	153,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-13 11:41:53',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(307,	154,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-14 02:47:03',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(308,	154,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-14 02:47:03',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(309,	155,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-14 09:52:04',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(310,	155,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-14 09:52:05',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(311,	156,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-18 06:55:04',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(312,	156,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-18 06:55:05',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(313,	157,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-19 01:03:31',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(314,	157,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-19 01:03:31',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(315,	158,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-22 03:03:54',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(316,	158,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-22 03:03:54',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(317,	159,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-22 18:33:02',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(318,	159,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-22 18:33:03',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(319,	160,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-23 00:14:58',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(320,	160,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-23 00:14:58',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(321,	161,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-24 00:43:22',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(322,	161,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-24 00:43:22',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(323,	162,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-25 09:43:47',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(324,	162,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-25 09:43:48',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(325,	163,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-11-30 04:05:44',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(326,	163,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-11-30 04:05:44',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(327,	164,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-12-02 22:43:17',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(328,	164,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-12-02 22:43:17',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(329,	165,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-12-03 08:55:06',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(330,	165,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-12-03 08:55:06',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(331,	166,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-12-10 05:27:29',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(332,	166,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-12-10 05:27:29',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(333,	167,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-12-10 09:21:44',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(334,	167,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-12-10 09:21:45',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(335,	168,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-12-11 01:15:49',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(336,	168,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-12-11 01:15:50',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(337,	169,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-12-17 07:27:55',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(338,	169,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-12-17 07:27:55',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(339,	170,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-12-18 08:51:57',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(340,	170,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-12-18 08:51:57',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(341,	171,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-12-22 10:46:50',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(342,	171,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-12-22 10:46:50',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(343,	172,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-12-25 02:55:54',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(344,	172,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-12-25 02:55:55',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(345,	173,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-12-25 03:48:32',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(346,	173,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-12-25 03:48:32',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(347,	174,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-12-25 16:54:56',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(348,	174,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-12-25 16:54:56',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(349,	175,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-12-25 21:55:21',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(350,	175,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-12-25 21:55:21',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(351,	176,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-12-29 16:54:07',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(352,	176,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-12-29 16:54:07',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(353,	177,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2021-12-31 06:14:07',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(354,	177,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2021-12-31 06:14:07',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(355,	178,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-01-01 10:16:11',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(356,	178,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-01-01 10:16:11',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(357,	179,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-01-06 08:44:11',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(358,	179,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-01-06 08:44:11',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(359,	180,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-01-08 14:37:33',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(360,	180,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-01-08 14:37:33',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(361,	181,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-01-13 09:37:02',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(362,	181,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-01-13 09:37:02',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(363,	182,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-01-15 10:49:26',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(364,	182,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-01-15 10:49:26',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(365,	183,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-01-17 19:55:13',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(366,	183,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-01-17 19:55:13',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(367,	184,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-01-18 13:08:52',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(368,	184,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-01-18 13:08:52',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(369,	185,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-01-18 17:53:45',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(370,	185,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-01-18 17:53:45',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(371,	186,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-01-19 13:22:19',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(372,	186,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-01-19 13:22:19',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(373,	187,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-01-21 16:39:28',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(374,	187,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-01-21 16:39:28',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(375,	188,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-01-25 10:38:14',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(376,	188,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-01-25 10:38:14',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(377,	189,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-01-26 01:12:27',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(378,	189,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-01-26 01:12:28',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(379,	190,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-01-27 08:56:36',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(380,	190,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-01-27 08:56:36',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(381,	191,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-01-28 18:35:59',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(382,	191,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-01-28 18:36:00',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(383,	192,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-01-31 03:29:26',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(384,	192,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-01-31 03:29:26',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(385,	193,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-01-31 20:18:05',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(386,	193,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-01-31 20:18:05',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(387,	194,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-01 01:22:47',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(388,	194,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-01 01:22:48',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(389,	195,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-01 17:03:28',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(390,	195,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-01 17:03:28',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(391,	196,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-02 00:28:48',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(392,	196,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-02 00:28:48',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(393,	197,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-02 04:42:48',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(394,	197,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-02 04:42:48',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(395,	198,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-02 13:04:31',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(396,	198,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-02 13:04:32',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(397,	199,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-02 16:12:39',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(398,	199,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-02 16:12:39',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(399,	200,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-02 19:49:03',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(400,	200,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-02 19:49:03',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(401,	201,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-03 02:09:18',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(402,	201,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-03 02:09:18',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(403,	202,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-03 13:26:34',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(404,	202,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-03 13:26:34',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(405,	203,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-05 22:44:38',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(406,	203,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-05 22:44:38',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(407,	204,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-08 16:29:04',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(408,	204,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-08 16:29:04',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(409,	205,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-08 18:25:40',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(410,	205,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-08 18:25:40',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(411,	206,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-08 18:25:42',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(412,	206,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-08 18:25:43',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(413,	207,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-08 21:56:25',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(414,	207,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-08 21:56:26',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(415,	208,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-08 21:56:27',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(416,	208,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-08 21:56:27',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(417,	209,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-08 23:31:17',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(418,	209,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-08 23:31:18',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(419,	210,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-09 17:49:02',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(420,	210,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-09 17:49:02',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(421,	211,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-10 02:51:47',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(422,	211,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-10 02:51:47',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(423,	212,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-10 14:03:50',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(424,	212,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-10 14:03:51',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(425,	213,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-10 15:34:03',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(426,	213,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-10 15:34:03',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(427,	214,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-10 18:14:02',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(428,	214,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-10 18:14:02',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(429,	215,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-12 09:11:48',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(430,	215,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-12 09:11:49',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(431,	216,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-12 09:15:06',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(432,	216,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-12 09:15:06',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(433,	217,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-12 13:56:48',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(434,	217,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-12 13:56:49',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(435,	218,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-13 02:20:43',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(436,	218,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-13 02:20:43',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(437,	219,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-13 02:20:49',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(438,	219,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-13 02:20:49',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(439,	220,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-13 02:21:23',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(440,	220,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-13 02:21:23',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(441,	221,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-13 13:27:36',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(442,	221,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-13 13:27:36',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(443,	222,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-14 21:31:52',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(444,	222,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-14 21:31:52',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(445,	223,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-14 22:12:06',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(446,	223,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-14 22:12:06',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(447,	224,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-15 07:25:50',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(448,	224,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-15 07:25:50',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(449,	225,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-18 05:22:51',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(450,	225,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-18 05:22:51',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(451,	226,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-19 12:59:54',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(452,	226,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-19 12:59:54',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(453,	227,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-19 21:56:56',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(454,	227,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-19 21:56:56',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(455,	228,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-23 16:13:34',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(456,	228,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-23 16:13:34',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(457,	229,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-24 02:08:41',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(458,	229,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-24 02:08:41',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(459,	230,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-25 11:31:21',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(460,	230,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-25 11:31:21',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(461,	231,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-27 22:56:46',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(462,	231,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-27 22:56:46',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(463,	232,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-02-28 13:42:07',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(464,	232,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-02-28 13:42:07',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(465,	233,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-03-02 03:29:04',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(466,	233,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-03-02 03:29:05',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(467,	234,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-03-02 08:05:46',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(468,	234,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-03-02 08:05:47',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(469,	235,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-03-03 16:19:54',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(470,	235,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-03-03 16:19:54',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(471,	236,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-03-03 22:05:21',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(472,	236,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-03-03 22:05:21',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(473,	237,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-03-04 00:10:35',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(474,	237,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-03-04 00:10:35',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(475,	238,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-03-04 12:10:24',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(476,	238,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-03-04 12:10:24',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(477,	239,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-03-04 15:04:08',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(478,	239,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-03-04 15:04:09',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(479,	240,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-03-06 00:00:36',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(480,	240,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-03-06 00:00:36',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(481,	241,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-03-08 12:19:40',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(482,	241,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-03-08 12:19:41',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(483,	242,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-03-08 12:20:27',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(484,	242,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-03-08 12:20:27',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(485,	243,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-03-09 17:19:07',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(486,	243,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-03-09 17:19:07',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(487,	244,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-03-15 02:01:52',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(488,	244,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-03-15 02:01:52',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(489,	245,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-03-16 12:57:04',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(490,	245,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-03-16 12:57:04',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(491,	246,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-03-19 04:43:49',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(492,	246,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-03-19 04:43:49',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(493,	247,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-03-22 09:27:55',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(494,	247,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-03-22 09:27:55',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(495,	248,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-03-24 17:53:37',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(496,	248,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-03-24 17:53:37',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(497,	249,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-03-25 21:23:30',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(498,	249,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-03-25 21:23:31',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(499,	250,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-03-27 02:01:18',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(500,	250,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-03-27 02:01:18',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(501,	251,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-03-27 07:50:13',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(502,	251,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-03-27 07:50:13',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(503,	252,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-03-30 15:52:05',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(504,	252,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-03-30 15:52:05',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(505,	253,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-05 20:26:48',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(506,	253,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-05 20:26:48',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(507,	254,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-06 19:49:19',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(508,	254,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-06 19:49:20',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(509,	255,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-08 13:08:03',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(510,	255,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-08 13:08:03',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(511,	256,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-10 10:49:39',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(512,	256,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-10 10:49:39',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(513,	257,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-11 08:02:18',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(514,	257,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-11 08:02:18',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(515,	258,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-11 18:34:27',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(516,	258,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-11 18:34:27',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(517,	259,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-11 20:19:54',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(518,	259,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-11 20:19:54',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(519,	260,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-13 07:52:20',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(520,	260,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-13 07:52:20',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(521,	261,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-15 22:17:06',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(522,	261,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-15 22:17:06',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(523,	262,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-16 00:56:13',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(524,	262,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-16 00:56:14',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(525,	263,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-16 13:37:55',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(526,	263,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-16 13:37:55',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(527,	264,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-18 04:12:50',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(528,	264,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-18 04:12:50',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(529,	265,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-19 04:13:50',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(530,	265,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-19 04:13:50',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(531,	266,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-19 21:00:32',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(532,	266,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-19 21:00:32',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(533,	267,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-20 14:07:55',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(534,	267,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-20 14:07:55',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(535,	268,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-20 22:24:09',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(536,	268,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-20 22:24:09',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(537,	269,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-21 12:09:58',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(538,	269,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-21 12:09:59',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(539,	270,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-21 15:33:37',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(540,	270,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-21 15:33:38',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(541,	271,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-22 09:18:21',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(542,	271,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-22 09:18:21',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(543,	272,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-25 08:46:22',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(544,	272,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-25 08:46:23',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(545,	273,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-26 06:07:09',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(546,	273,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-26 06:07:09',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(547,	274,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-27 00:22:39',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(548,	274,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-27 00:22:39',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(549,	275,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-27 01:11:49',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(550,	275,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-27 01:11:49',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(551,	276,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-04-30 09:17:12',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(552,	276,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-04-30 09:17:12',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(553,	277,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-01 01:08:15',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(554,	277,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-01 01:08:15',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(555,	278,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-01 06:11:30',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(556,	278,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-01 06:11:30',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(557,	279,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-01 22:47:42',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(558,	279,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-01 22:47:42',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(559,	280,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-03 01:18:47',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(560,	280,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-03 01:18:47',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(561,	281,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-03 01:24:19',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(562,	281,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-03 01:24:20',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(563,	282,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-03 23:05:52',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(564,	282,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-03 23:05:52',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(565,	283,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-04 03:21:43',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(566,	283,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-04 03:21:43',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(567,	284,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-05 02:06:43',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(568,	284,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-05 02:06:43',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(569,	285,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-05 20:34:28',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(570,	285,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-05 20:34:28',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(571,	286,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-06 10:08:30',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(572,	286,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-06 10:08:30',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(573,	287,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-09 13:21:34',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(574,	287,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-09 13:21:34',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(575,	288,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-10 17:35:56',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(576,	288,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-10 17:35:56',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(577,	289,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-11 08:44:16',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(578,	289,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-11 08:44:16',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(579,	290,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-13 07:44:43',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(580,	290,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-13 07:44:43',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(581,	291,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-15 11:12:08',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(582,	291,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-15 11:12:09',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(583,	292,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-16 11:00:40',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(584,	292,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-16 11:00:40',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(585,	293,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-16 13:41:43',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(586,	293,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-16 13:41:44',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(587,	294,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-17 10:34:46',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(588,	294,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-17 10:34:46',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(589,	295,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-19 12:30:30',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(590,	295,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-19 12:30:30',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(591,	296,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-20 00:22:50',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(592,	296,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-20 00:22:51',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(593,	297,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-21 04:38:09',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(594,	297,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-21 04:38:09',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(595,	298,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-22 12:40:20',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(596,	298,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-22 12:40:20',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(597,	299,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-25 03:03:35',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(598,	299,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-25 03:03:35',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(599,	300,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-26 10:34:08',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(600,	300,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-26 10:34:08',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(601,	301,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-27 12:27:50',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(602,	301,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-27 12:27:50',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(603,	302,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-27 15:29:17',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(604,	302,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-27 15:29:17',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(605,	303,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-27 19:16:44',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(606,	303,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-27 19:16:44',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(607,	304,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-28 05:06:47',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(608,	304,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-28 05:06:47',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(609,	305,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-28 21:48:20',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(610,	305,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-28 21:48:20',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(611,	306,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-29 17:42:32',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(612,	306,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-29 17:42:32',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(613,	307,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-30 06:08:29',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(614,	307,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-30 06:08:30',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(615,	308,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-30 08:32:13',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(616,	308,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-30 08:32:13',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(617,	309,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-05-31 02:09:32',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(618,	309,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-05-31 02:09:33',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(619,	310,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-06-01 06:13:42',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(620,	310,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-06-01 06:13:42',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(621,	311,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-06-01 22:01:13',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(622,	311,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-06-01 22:01:14',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(623,	312,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-06-02 01:15:53',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(624,	312,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-06-02 01:15:53',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(625,	313,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-06-02 04:22:51',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(626,	313,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-06-02 04:22:51',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(627,	314,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-06-09 18:46:46',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(628,	314,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-06-09 18:46:46',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(629,	315,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-06-15 22:07:23',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(630,	315,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-06-15 22:07:23',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(631,	316,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-06-16 17:50:59',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(632,	316,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-06-16 17:50:59',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(633,	317,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-06-16 17:55:48',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(634,	317,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-06-16 17:55:49',	'Gravity Forms SendGrid Add-On successfully passed the notification to SendGrid.',	'gravityformssendgrid',	'success'),
(635,	318,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-08-10 18:15:44',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(636,	318,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-08-10 18:15:44',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(637,	319,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2022-11-01 11:47:12',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(638,	319,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2022-11-01 11:47:12',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(639,	320,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2023-04-13 16:27:53',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(640,	320,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2023-04-13 16:27:53',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(641,	321,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2023-06-14 15:19:18',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(642,	321,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2023-06-14 15:19:18',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(643,	322,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2023-06-23 21:51:12',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(644,	322,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2023-06-23 21:51:12',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(645,	323,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2023-06-30 15:47:00',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(646,	323,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2023-06-30 15:47:00',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(647,	324,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2023-06-30 16:12:53',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(648,	324,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2023-06-30 16:12:53',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(649,	325,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2023-07-10 20:47:15',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(650,	325,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2023-07-10 20:47:15',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(651,	326,	'Admin Notification (ID: 51bf5ca65102e)',	0,	'2023-08-03 19:45:54',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success'),
(652,	326,	'Agent Notification (ID: 5e5571bca5824)',	0,	'2023-08-03 19:45:54',	'WordPress successfully passed the notification email to the sending server.',	'notification',	'success');

DROP TABLE IF EXISTS `wp_gf_form`;
CREATE TABLE `wp_gf_form` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `is_trash` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_gf_form` (`id`, `title`, `date_created`, `date_updated`, `is_active`, `is_trash`) VALUES
(1,	'CovertAgent Home Value: Request CMA GrayGroupLA.com',	'2020-05-18 17:34:55',	NULL,	1,	0),
(2,	'CovertAgent Home Value: Registration GrayGroupLA.com',	'2020-05-18 17:34:55',	NULL,	1,	0),
(3,	'Contact Form - GrayGroupLA.com',	'2020-05-18 17:34:55',	NULL,	1,	0),
(4,	'Property Inquiry GrayGroupLA.com',	'2020-05-18 17:34:55',	NULL,	1,	0),
(5,	'Showing Inquiry GrayGroupLA.com',	'2020-05-18 17:34:55',	NULL,	1,	0),
(6,	'Sold Contact Form - GrayGroupLA.com ',	'2020-05-18 17:34:55',	NULL,	1,	0),
(7,	'Projects Contact Form - GrayGroupLA.com',	'2020-05-18 17:34:55',	NULL,	1,	0);

DROP TABLE IF EXISTS `wp_gf_form_meta`;
CREATE TABLE `wp_gf_form_meta` (
  `form_id` mediumint(8) unsigned NOT NULL,
  `display_meta` longtext COLLATE utf8mb4_unicode_520_ci,
  `entries_grid_meta` longtext COLLATE utf8mb4_unicode_520_ci,
  `confirmations` longtext COLLATE utf8mb4_unicode_520_ci,
  `notifications` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_gf_form_meta` (`form_id`, `display_meta`, `entries_grid_meta`, `confirmations`, `notifications`) VALUES
(1,	'{\"labelPlacement\":\"left_label\",\"useCurrentUserAsAuthor\":\"1\",\"title\":\"CovertAgent Home Value: Request CMA GrayGroupLA.com\",\"description\":\"\",\"descriptionPlacement\":\"below\",\"button\":{\"type\":\"text\",\"text\":\"Submit CMA Request\",\"imageUrl\":\"\"},\"fields\":[{\"type\":\"text\",\"id\":\"1\",\"isRequired\":\"1\",\"size\":\"medium\",\"label\":\"Name\",\"formId\":1,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"inputs\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Name\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":true,\"choices\":\"\",\"conditionalLogic\":\"\",\"inputName\":\"{hjiUser.name}\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"email\",\"id\":\"2\",\"isRequired\":\"1\",\"size\":\"medium\",\"label\":\"Email\",\"formId\":1,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"inputs\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Email\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":true,\"choices\":\"\",\"conditionalLogic\":\"\",\"inputName\":\"{hjiUser.email}\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"phone\",\"id\":\"3\",\"size\":\"medium\",\"phoneFormat\":\"standard\",\"label\":\"Phone\",\"formId\":1,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"isRequired\":\"\",\"inputs\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Phone\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":true,\"choices\":\"\",\"conditionalLogic\":\"\",\"inputName\":\"{hjiUser.phone}\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"text\",\"allowsPrepopulate\":true,\"id\":\"4\",\"isRequired\":\"1\",\"size\":\"medium\",\"description\":\"CMA will be created for this property address\",\"inputName\":\"address\",\"label\":\"Property Address\",\"formId\":1,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"inputs\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Property Address\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"hidden\",\"allowsPrepopulate\":\"1\",\"id\":\"7\",\"size\":\"medium\",\"inputName\":\"address\",\"label\":\"Evaluated Property\",\"formId\":1,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"isRequired\":\"\",\"inputs\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"hidden\",\"allowsPrepopulate\":\"1\",\"id\":\"8\",\"size\":\"medium\",\"inputName\":\"estimated_value\",\"label\":\"Estimated Value\",\"formId\":1,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"isRequired\":\"\",\"inputs\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1}],\"id\":1,\"cssClass\":\"\",\"enableHoneypot\":\"1\",\"enableAnimation\":\"\",\"limitEntries\":\"\",\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":\"\",\"scheduleStart\":\"\",\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEnd\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":\"\",\"requireLoginMessage\":\"\",\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"nextFieldId\":9,\"subLabelPlacement\":\"below\",\"save\":{\"enabled\":\"\",\"button\":{\"type\":\"link\",\"text\":\"Save and Continue Later\"}},\"hji_form_key\":\"\"}',	NULL,	'{\"531fb56d586c7\":{\"id\":\"531fb56d586c7\",\"isDefault\":\"1\",\"type\":\"message\",\"name\":\"Default Confirmation\",\"message\":\"Thanks for contacting us! We will get in touch with you shortly.\"}}',	'{\"531fb56d58357\":{\"id\":\"531fb56d58357\",\"to\":\"{admin_email}\",\"name\":\"Admin Notification\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"New submission from {form_title}\",\"message\":\"{all_fields}\"},\"5e5572a6842f9\":{\"isActive\":true,\"name\":\"Agent Notification\",\"service\":\"wordpress\",\"event\":\"form_submission\",\"to\":\"c.gray@graygroupla.com\",\"toType\":\"email\",\"cc\":\"\",\"bcc\":\"\",\"subject\":\"{form_title}\",\"message\":\"{all_fields}\",\"from\":\"wordpress@graygroupla.com\",\"fromName\":\"GrayGroupLA.com\",\"replyTo\":\"\",\"routing\":null,\"conditionalLogic\":null,\"disableAutoformat\":false,\"enableAttachments\":false,\"id\":\"5e5572a6842f9\"}}'),
(2,	'{\"labelPlacement\":\"top_label\",\"useCurrentUserAsAuthor\":\"1\",\"title\":\"CovertAgent Home Value: Registration GrayGroupLA.com\",\"description\":\"Imported form by CovertAgent Home Value Plugin.\",\"descriptionPlacement\":\"below\",\"button\":{\"type\":\"text\",\"text\":\"Get Full Valuation\",\"imageUrl\":\"\"},\"fields\":[{\"type\":\"text\",\"id\":\"1\",\"isRequired\":\"1\",\"size\":\"medium\",\"label\":\"Name\",\"formId\":2,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"inputs\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Name\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":true,\"choices\":\"\",\"conditionalLogic\":\"\",\"inputName\":\"{hjiUser.name}\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"email\",\"id\":\"2\",\"isRequired\":\"1\",\"size\":\"medium\",\"label\":\"Email\",\"formId\":2,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"inputs\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Email\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":true,\"choices\":\"\",\"conditionalLogic\":\"\",\"inputName\":\"{hjiUser.email}\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"inputMaskIsCustom\":false,\"useRichTextEditor\":false,\"pageNumber\":1},{\"type\":\"select\",\"id\":10,\"label\":\"Looking to selling...\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"choices\":[{\"text\":\"Immediately\",\"value\":\"Immediately\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"3-6 Months\",\"value\":\"3-6 Months\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"6 Months to a Year\",\"value\":\"6 Months to a Year\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"In a year +\",\"value\":\"In a year +\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Prefer a Full Market Analysis\",\"value\":\"Prefer a Full Market Analysis\",\"isSelected\":false,\"price\":\"\"}],\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"enablePrice\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"pageNumber\":1},{\"type\":\"hidden\",\"allowsPrepopulate\":true,\"id\":\"3\",\"size\":\"medium\",\"defaultValue\":\"_address_\",\"inputName\":\"address\",\"label\":\"Property Address\",\"formId\":2,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"isRequired\":\"\",\"inputs\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMaskIsCustom\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"useRichTextEditor\":false,\"pageNumber\":1},{\"type\":\"hidden\",\"id\":\"5\",\"size\":\"medium\",\"defaultValue\":\"_street_\",\"inputName\":\"street\",\"label\":\"Street\",\"formId\":2,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"isRequired\":\"\",\"inputs\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMaskIsCustom\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":false,\"useRichTextEditor\":false,\"pageNumber\":1},{\"type\":\"hidden\",\"id\":\"6\",\"size\":\"medium\",\"defaultValue\":\"_city_\",\"inputName\":\"city\",\"label\":\"City\",\"formId\":2,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"isRequired\":\"\",\"inputs\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"hidden\",\"id\":\"7\",\"size\":\"medium\",\"defaultValue\":\"_state_\",\"inputName\":\"state\",\"label\":\"State\",\"formId\":2,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"isRequired\":\"\",\"inputs\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"hidden\",\"id\":\"8\",\"size\":\"medium\",\"defaultValue\":\"_zip_\",\"inputName\":\"zip\",\"label\":\"Zip\",\"formId\":2,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"isRequired\":\"\",\"inputs\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"hidden\",\"id\":\"4\",\"size\":\"medium\",\"defaultValue\":\"_estimated_value_\",\"label\":\"Estimated Value\",\"formId\":2,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"isRequired\":\"\",\"inputs\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1}],\"id\":2,\"cssClass\":\"\",\"enableHoneypot\":\"1\",\"enableAnimation\":\"\",\"limitEntries\":\"\",\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":\"\",\"scheduleStart\":\"\",\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEnd\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":\"\",\"requireLoginMessage\":\"\",\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"nextFieldId\":11,\"subLabelPlacement\":\"below\",\"save\":{\"enabled\":\"\",\"button\":{\"type\":\"link\",\"text\":\"Save and Continue Later\"}},\"hji_form_key\":\"\"}',	NULL,	'{\"5320cef46d526\":{\"id\":\"5320cef46d526\",\"isDefault\":true,\"type\":\"message\",\"name\":\"Default Confirmation\",\"url\":\"\",\"queryString\":\"\",\"message\":\"<h1 class=\\\"mobile-spacing\\\">Almost there!<\\/h1>\\r\\nOne last step...\\r\\n\\r\\n<button id=\\\"btnFinishrediret\\\" class=\\\"btn btn-cta btn-cta-primary btn-lg\\\" type=\\\"submit\\\"> Finish <\\/button>\",\"disableAutoformat\":false,\"pageId\":0,\"conditionalLogic\":[]}}',	'{\"5320cef46d2b6\":{\"isActive\":true,\"name\":\"Admin Notification\",\"service\":\"sendgrid\",\"event\":\"form_submission\",\"to\":\"{admin_email}\",\"toType\":\"email\",\"cc\":\"\",\"bcc\":\"\",\"subject\":\"{form_title}\",\"message\":\"{all_fields}\",\"from\":\"{admin_email}\",\"fromName\":\"\",\"replyTo\":\"\",\"routing\":null,\"conditionalLogic\":null,\"disableAutoformat\":false,\"enableAttachments\":false,\"id\":\"5320cef46d2b6\"},\"5e5572622a243\":{\"isActive\":true,\"name\":\"Agent Notification\",\"service\":\"\",\"event\":\"form_submission\",\"to\":\"c.gray@graygroupla.com\",\"toType\":\"email\",\"cc\":\"\",\"bcc\":\"\",\"subject\":\"{form_title}\",\"message\":\"{all_fields}\",\"from\":\"wordpress@graygroupla.com\",\"fromName\":\"GrayGroupLA.com\",\"replyTo\":\"\",\"routing\":null,\"conditionalLogic\":null,\"disableAutoformat\":false,\"enableAttachments\":false,\"id\":\"5e5572622a243\"}}'),
(3,	'{\"labelPlacement\":\"top_label\",\"useCurrentUserAsAuthor\":\"1\",\"title\":\"Contact Form - GrayGroupLA.com\",\"description\":\"We would love to hear from you! Please fill out this form and we will get in touch with you shortly.\",\"button\":{\"type\":\"text\",\"text\":\"Contact Me\",\"imageUrl\":\"\"},\"fields\":[{\"type\":\"text\",\"id\":7,\"label\":\"Name\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"\",\"inputs\":null,\"allowsPrepopulate\":true,\"inputName\":\"{hjiUser.name}\",\"cssClass\":\"hjiUserName gf_left_half\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"formId\":3,\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"displayOnly\":\"\",\"pageNumber\":1},{\"type\":\"email\",\"id\":8,\"label\":\"Email\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"\",\"inputs\":null,\"allowsPrepopulate\":true,\"inputName\":\"{hjiUser.email}\",\"cssClass\":\"hjiUserEmail gf_right_half \",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"formId\":3,\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"displayOnly\":\"\",\"pageNumber\":1},{\"type\":\"phone\",\"id\":\"4\",\"size\":\"medium\",\"phoneFormat\":\"standard\",\"cssClass\":\"gf_left_half \",\"label\":\"Phone\",\"formId\":3,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"isRequired\":\"\",\"inputs\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Phone Number\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":true,\"choices\":\"\",\"conditionalLogic\":\"\",\"inputName\":\"{hjiUser.email}\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"select\",\"id\":\"6\",\"isRequired\":\"1\",\"size\":\"medium\",\"label\":\"I\'m interested in:\",\"choices\":[{\"text\":\"Buying a home\",\"value\":\"Buying a home\"},{\"text\":\"Selling a home\",\"value\":\"Selling a home\"},{\"text\":\"Investing in a property\",\"value\":\"Investing in a property\"},{\"text\":\"Getting some information\",\"value\":\"Getting some information\"}],\"formId\":3,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"inputs\":\"\",\"conditionalLogic\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":false,\"cssClass\":\"gf_right_half\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"textarea\",\"id\":\"5\",\"isRequired\":\"1\",\"size\":\"medium\",\"label\":\"Comments or Questions?\",\"maxLength\":\"500\",\"formId\":3,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"inputs\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Please enter your message here....\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"captcha\",\"id\":9,\"label\":\"\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"displayOnly\":true,\"formId\":3,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"captchaType\":\"\",\"captchaTheme\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"pageNumber\":1,\"fields\":\"\"}],\"descriptionPlacement\":\"below\",\"id\":3,\"cssClass\":\"\",\"enableHoneypot\":\"1\",\"enableAnimation\":\"\",\"limitEntries\":\"\",\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":\"\",\"scheduleStart\":\"\",\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEnd\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":\"\",\"requireLoginMessage\":\"\",\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"nextFieldId\":10,\"subLabelPlacement\":\"below\",\"save\":{\"enabled\":\"\",\"button\":{\"type\":\"link\",\"text\":\"Save and Continue Later\"}},\"hji_form_key\":\"\"}',	NULL,	'{\"51bf5ca650840\":{\"type\":\"message\",\"id\":\"51bf5ca650840\",\"isDefault\":\"1\",\"message\":\"Thanks for contacting us! We will get in touch with you shortly.\",\"name\":\"Default Confirmation\"}}',	'{\"51bf5ca65102e\":{\"isActive\":true,\"name\":\"Admin Notification\",\"service\":\"sendgrid\",\"event\":\"form_submission\",\"to\":\"{admin_email}\",\"toType\":\"email\",\"cc\":\"\",\"bcc\":\"\",\"subject\":\"{form_title}\",\"message\":\"{all_fields}\",\"from\":\"{admin_email}\",\"fromName\":\"GrayGroupLA.com\",\"replyTo\":\"\",\"routing\":null,\"conditionalLogic\":null,\"disableAutoformat\":false,\"enableAttachments\":false,\"id\":\"51bf5ca65102e\"},\"5e5571bca5824\":{\"isActive\":true,\"name\":\"Agent Notification\",\"service\":\"sendgrid\",\"event\":\"form_submission\",\"to\":\"c.gray@graygroupla.com\",\"toType\":\"email\",\"cc\":\"\",\"bcc\":\"\",\"subject\":\"{form_title}\",\"message\":\"{all_fields}\",\"from\":\"wordpress@graygroupla.com\",\"fromName\":\"GrayGroupLA.com\",\"replyTo\":\"\",\"routing\":null,\"conditionalLogic\":null,\"disableAutoformat\":false,\"enableAttachments\":false,\"id\":\"5e5571bca5824\"}}'),
(4,	'{\"labelPlacement\":\"top_label\",\"useCurrentUserAsAuthor\":\"1\",\"title\":\"Property Inquiry GrayGroupLA.com\",\"descriptionPlacement\":\"below\",\"button\":{\"type\":\"text\",\"text\":\"Submit\",\"imageUrl\":\"\"},\"fields\":[{\"type\":\"text\",\"id\":\"1\",\"isRequired\":\"1\",\"size\":\"medium\",\"label\":\"Name\",\"formId\":4,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"inputs\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Name\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":true,\"inputName\":\"{hjiUser.name}\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"text\",\"id\":\"2\",\"isRequired\":\"1\",\"size\":\"medium\",\"label\":\"Email\",\"formId\":4,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"inputs\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Email\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":true,\"inputName\":\"{hjiUser.email}\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"text\",\"id\":\"3\",\"size\":\"medium\",\"label\":\"Phone\",\"formId\":4,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"isRequired\":\"\",\"inputs\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Phone\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":true,\"inputName\":\"{hjiUser.phone}\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"textarea\",\"id\":\"4\",\"size\":\"small\",\"label\":\"Message\",\"formId\":4,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"isRequired\":\"\",\"inputs\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":false,\"defaultValue\":\"Please, send me more information on this property: MLS# {hjiRidx.id}  \\u2013  {hjiRidx.listPrice}  \\u2013  {hjiRidx.address}.\",\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1}],\"enableHoneypot\":\"1\",\"id\":4,\"description\":\"\",\"cssClass\":\"\",\"enableAnimation\":\"\",\"limitEntries\":\"\",\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":\"\",\"scheduleStart\":\"\",\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEnd\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":\"\",\"requireLoginMessage\":\"\",\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"nextFieldId\":5,\"subLabelPlacement\":\"below\",\"save\":{\"enabled\":\"\",\"button\":{\"type\":\"link\",\"text\":\"Save and Continue Later\"}},\"hji_form_key\":\"\"}',	NULL,	'{\"53a89ff83ab07\":{\"id\":\"53a89ff83ab07\",\"isDefault\":\"1\",\"type\":\"message\",\"name\":\"Default Confirmation\",\"message\":\"Thanks for contacting us! We will get in touch with you shortly.\"}}',	'{\"53a89ff839174\":{\"id\":\"53a89ff839174\",\"name\":\"Admin Notification\",\"event\":\"form_submission\",\"to\":\"{admin_email}\",\"toType\":\"email\",\"subject\":\"New submission from {form_title}\",\"message\":\"{all_fields}\\r\\n\\r\\n{referer}\",\"from\":\"{admin_email}\",\"replyTo\":\"{Email:2}\"},\"5e5572ef654be\":{\"isActive\":true,\"name\":\"Agent Notification\",\"service\":\"wordpress\",\"event\":\"form_submission\",\"to\":\"c.gray@graygroupla.com\",\"toType\":\"email\",\"cc\":\"\",\"bcc\":\"\",\"subject\":\"{form_title}\",\"message\":\"{all_fields}\\r\\n\\r\\n{referer}\",\"from\":\"wordpress@graygroupla.com\",\"fromName\":\"GrayGroupLA.com\",\"replyTo\":\"{Email:2}\",\"routing\":null,\"conditionalLogic\":null,\"disableAutoformat\":false,\"enableAttachments\":false,\"id\":\"5e5572ef654be\"}}'),
(5,	'{\"labelPlacement\":\"top_label\",\"useCurrentUserAsAuthor\":\"1\",\"title\":\"Showing Inquiry GrayGroupLA.com\",\"descriptionPlacement\":\"below\",\"button\":{\"type\":\"text\",\"text\":\"Submit\",\"imageUrl\":\"\"},\"fields\":[{\"type\":\"text\",\"id\":\"1\",\"isRequired\":\"1\",\"size\":\"medium\",\"label\":\"Name\",\"formId\":5,\"displayOnly\":\"\",\"inputs\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Name\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":true,\"inputName\":\"{hjiUser.name}\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"text\",\"id\":\"2\",\"isRequired\":\"1\",\"size\":\"medium\",\"label\":\"Email\",\"formId\":5,\"displayOnly\":\"\",\"inputs\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Email\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":true,\"inputName\":\"{hjiUser.email}\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"text\",\"id\":\"3\",\"size\":\"medium\",\"label\":\"Phone\",\"formId\":5,\"displayOnly\":\"\",\"isRequired\":\"\",\"inputs\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Phone\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":true,\"inputName\":\"{hjiUser.phone}\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"text\",\"id\":\"5\",\"isRequired\":\"1\",\"size\":\"medium\",\"label\":\"Preferred Date and Time\",\"formId\":5,\"displayOnly\":\"\",\"inputs\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Choose a preferred date\\/time\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":false,\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"textarea\",\"id\":\"4\",\"size\":\"small\",\"label\":\"Message\",\"formId\":5,\"displayOnly\":\"\",\"isRequired\":\"\",\"inputs\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":false,\"defaultValue\":\"I would like to schedule a private showing for this property: MLS# {hjiRidx.id}  \\u2013  {hjiRidx.listPrice}  \\u2013  {hjiRidx.address}.\",\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1}],\"enableHoneypot\":\"1\",\"id\":5,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"nextFieldId\":6,\"description\":\"\",\"subLabelPlacement\":\"below\",\"cssClass\":\"\",\"enableAnimation\":\"\",\"save\":{\"enabled\":\"\",\"button\":{\"type\":\"link\",\"text\":\"Save and Continue Later\"}},\"limitEntries\":\"\",\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":\"\",\"scheduleStart\":\"\",\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEnd\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":\"\",\"requireLoginMessage\":\"\",\"hji_form_key\":\"\"}',	NULL,	'{\"53a89ff83ab07\":{\"id\":\"53a89ff83ab07\",\"isDefault\":\"1\",\"type\":\"message\",\"name\":\"Default Confirmation\",\"message\":\"Thanks for contacting us! We will get in touch with you shortly.\"}}',	'{\"53a89ff839174\":{\"id\":\"53a89ff839174\",\"name\":\"Admin Notification\",\"event\":\"form_submission\",\"to\":\"{admin_email}\",\"toType\":\"email\",\"subject\":\"New submission from {form_title}\",\"message\":\"{all_fields}\\r\\n\\r\\n{referer}\",\"from\":\"{admin_email}\",\"replyTo\":\"{Email:2}\"},\"5e5573221e4d0\":{\"isActive\":true,\"name\":\"Agent Notification\",\"service\":\"wordpress\",\"event\":\"form_submission\",\"to\":\"c.gray@graygroupla.com\",\"toType\":\"email\",\"cc\":\"\",\"bcc\":\"\",\"subject\":\"{form_title}\",\"message\":\"{all_fields}\\r\\n\\r\\n{referer}\",\"from\":\"wordpress@graygroupla.com\",\"fromName\":\"\",\"replyTo\":\"{Email:2}\",\"routing\":null,\"conditionalLogic\":null,\"disableAutoformat\":false,\"enableAttachments\":false,\"id\":\"5e5573221e4d0\"}}'),
(6,	'{\"labelPlacement\":\"top_label\",\"useCurrentUserAsAuthor\":\"1\",\"title\":\"Sold Contact Form - GrayGroupLA.com \",\"description\":\"This property is sold. Contact me to buy or sell your next home.\",\"button\":{\"type\":\"text\",\"text\":\"Contact Me\",\"imageUrl\":\"\"},\"fields\":[{\"type\":\"text\",\"id\":7,\"label\":\"Name\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"\",\"inputs\":null,\"allowsPrepopulate\":true,\"inputName\":\"{hjiUser.name}\",\"cssClass\":\"hjiUserName gf_left_half\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"formId\":6,\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"displayOnly\":\"\",\"pageNumber\":1},{\"type\":\"email\",\"id\":8,\"label\":\"Email\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"\",\"inputs\":null,\"allowsPrepopulate\":true,\"inputName\":\"{hjiUser.email}\",\"cssClass\":\"hjiUserEmail gf_right_half \",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"formId\":6,\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"displayOnly\":\"\",\"pageNumber\":1},{\"type\":\"phone\",\"id\":\"4\",\"size\":\"medium\",\"phoneFormat\":\"standard\",\"cssClass\":\"gf_left_half \",\"label\":\"Phone\",\"formId\":6,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"isRequired\":\"\",\"inputs\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Phone Number\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":true,\"choices\":\"\",\"conditionalLogic\":\"\",\"inputName\":\"{hjiUser.email}\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"select\",\"id\":\"6\",\"isRequired\":\"1\",\"size\":\"medium\",\"label\":\"I\'m interested in:\",\"choices\":[{\"text\":\"Buying a home\",\"value\":\"Buying a home\"},{\"text\":\"Selling a home\",\"value\":\"Selling a home\"},{\"text\":\"Investing in a property\",\"value\":\"Investing in a property\"},{\"text\":\"Getting some information\",\"value\":\"Getting some information\"}],\"formId\":6,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"inputs\":\"\",\"conditionalLogic\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":false,\"cssClass\":\"gf_right_half\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"textarea\",\"id\":\"5\",\"isRequired\":\"1\",\"size\":\"medium\",\"label\":\"Comments or Questions?\",\"maxLength\":\"500\",\"formId\":6,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"inputs\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Please enter your message here....\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1}],\"descriptionPlacement\":\"below\",\"id\":6,\"cssClass\":\"\",\"enableHoneypot\":\"1\",\"enableAnimation\":\"\",\"limitEntries\":\"\",\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":\"\",\"scheduleStart\":\"\",\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEnd\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":\"\",\"requireLoginMessage\":\"\",\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"notification\":{\"to\":\"{admin_email}\",\"subject\":\"New submission from {form_title}\",\"message\":\"{all_fields}\",\"isActive\":true},\"nextFieldId\":9,\"subLabelPlacement\":\"below\",\"save\":{\"enabled\":\"\",\"button\":{\"type\":\"link\",\"text\":\"Save and Continue Later\"}},\"hji_form_key\":\"\",\"is_active\":\"1\",\"date_created\":\"2020-04-24 17:43:48\",\"is_trash\":\"0\"}',	NULL,	'{\"51bf5ca650840\":{\"type\":\"message\",\"id\":\"51bf5ca650840\",\"isDefault\":\"1\",\"message\":\"Thanks for contacting us! We will get in touch with you shortly.\",\"name\":\"Default Confirmation\"}}',	'{\"51bf5ca65102e\":{\"isActive\":true,\"name\":\"Admin Notification\",\"service\":\"sendgrid\",\"event\":\"form_submission\",\"to\":\"{admin_email}\",\"toType\":\"email\",\"cc\":\"\",\"bcc\":\"\",\"subject\":\"{form_title}\",\"message\":\"{all_fields}\",\"from\":\"{admin_email}\",\"fromName\":\"GrayGroupLA.com\",\"replyTo\":\"\",\"routing\":null,\"conditionalLogic\":null,\"disableAutoformat\":false,\"enableAttachments\":false,\"id\":\"51bf5ca65102e\"},\"5e5571bca5824\":{\"isActive\":true,\"name\":\"Agent Notification\",\"service\":\"\",\"event\":\"form_submission\",\"to\":\"c.gray@graygroupla.com\",\"toType\":\"email\",\"cc\":\"\",\"bcc\":\"\",\"subject\":\"{form_title}\",\"message\":\"{all_fields}\",\"from\":\"wordpress@graygroupla.com\",\"fromName\":\"GrayGroupLA.com\",\"replyTo\":\"\",\"routing\":null,\"conditionalLogic\":null,\"disableAutoformat\":false,\"enableAttachments\":false,\"id\":\"5e5571bca5824\"}}'),
(7,	'{\"labelPlacement\":\"top_label\",\"useCurrentUserAsAuthor\":\"1\",\"title\":\"Projects Contact Form - GrayGroupLA.com\",\"description\":\"This property is one of our projects. Contact me to buy or sell your next home.\",\"button\":{\"type\":\"text\",\"text\":\"Contact Me\",\"imageUrl\":\"\"},\"fields\":[{\"type\":\"text\",\"id\":7,\"label\":\"Name\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"\",\"inputs\":null,\"allowsPrepopulate\":true,\"inputName\":\"{hjiUser.name}\",\"cssClass\":\"hjiUserName gf_left_half\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"formId\":7,\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"displayOnly\":\"\",\"pageNumber\":1},{\"type\":\"email\",\"id\":8,\"label\":\"Email\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"\",\"inputs\":null,\"allowsPrepopulate\":true,\"inputName\":\"{hjiUser.email}\",\"cssClass\":\"hjiUserEmail gf_right_half \",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"formId\":7,\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"displayOnly\":\"\",\"pageNumber\":1},{\"type\":\"phone\",\"id\":\"4\",\"size\":\"medium\",\"phoneFormat\":\"standard\",\"cssClass\":\"gf_left_half \",\"label\":\"Phone\",\"formId\":7,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"isRequired\":\"\",\"inputs\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Phone Number\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":true,\"choices\":\"\",\"conditionalLogic\":\"\",\"inputName\":\"{hjiUser.email}\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"select\",\"id\":\"6\",\"isRequired\":\"1\",\"size\":\"medium\",\"label\":\"I\'m interested in:\",\"choices\":[{\"text\":\"Buying a home\",\"value\":\"Buying a home\"},{\"text\":\"Selling a home\",\"value\":\"Selling a home\"},{\"text\":\"Investing in a property\",\"value\":\"Investing in a property\"},{\"text\":\"Getting some information\",\"value\":\"Getting some information\"}],\"formId\":7,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"inputs\":\"\",\"conditionalLogic\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":false,\"cssClass\":\"gf_right_half\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1},{\"type\":\"textarea\",\"id\":\"5\",\"isRequired\":\"1\",\"size\":\"medium\",\"label\":\"Comments or Questions?\",\"maxLength\":\"500\",\"formId\":7,\"descriptionPlacement\":\"below\",\"displayOnly\":\"\",\"inputs\":\"\",\"labelPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Please enter your message here....\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"inputType\":\"\",\"fields\":\"\",\"pageNumber\":1}],\"descriptionPlacement\":\"below\",\"id\":7,\"cssClass\":\"\",\"enableHoneypot\":\"1\",\"enableAnimation\":\"\",\"limitEntries\":\"\",\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":\"\",\"scheduleStart\":\"\",\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEnd\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":\"\",\"requireLoginMessage\":\"\",\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"notification\":{\"to\":\"{admin_email}\",\"subject\":\"New submission from {form_title}\",\"message\":\"{all_fields}\",\"isActive\":true},\"nextFieldId\":9,\"subLabelPlacement\":\"below\",\"save\":{\"enabled\":\"\",\"button\":{\"type\":\"link\",\"text\":\"Save and Continue Later\"}},\"hji_form_key\":\"\",\"is_active\":\"1\",\"date_created\":\"2020-04-24 17:43:48\",\"is_trash\":\"0\"}',	NULL,	'{\"51bf5ca650840\":{\"type\":\"message\",\"id\":\"51bf5ca650840\",\"isDefault\":\"1\",\"message\":\"Thanks for contacting us! We will get in touch with you shortly.\",\"name\":\"Default Confirmation\"}}',	'{\"51bf5ca65102e\":{\"isActive\":true,\"name\":\"Admin Notification\",\"service\":\"sendgrid\",\"event\":\"form_submission\",\"to\":\"{admin_email}\",\"toType\":\"email\",\"cc\":\"\",\"bcc\":\"\",\"subject\":\"{form_title}\",\"message\":\"{all_fields}\",\"from\":\"{admin_email}\",\"fromName\":\"GrayGroupLA.com\",\"replyTo\":\"\",\"routing\":null,\"conditionalLogic\":null,\"disableAutoformat\":false,\"enableAttachments\":false,\"id\":\"51bf5ca65102e\"},\"5e5571bca5824\":{\"isActive\":true,\"name\":\"Agent Notification\",\"service\":\"sendgrid\",\"event\":\"form_submission\",\"to\":\"derek.willxcel@gmail.com\",\"toType\":\"email\",\"cc\":\"\",\"bcc\":\"\",\"subject\":\"{form_title}\",\"message\":\"{all_fields}\",\"from\":\"derek.willxcel@gmail.com\",\"fromName\":\"GrayGroupLA.com\",\"replyTo\":\"\",\"routing\":null,\"conditionalLogic\":null,\"disableAutoformat\":false,\"enableAttachments\":false,\"id\":\"5e5571bca5824\"}}');

DROP TABLE IF EXISTS `wp_gf_form_revisions`;
CREATE TABLE `wp_gf_form_revisions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(8) unsigned NOT NULL,
  `display_meta` longtext COLLATE utf8mb4_unicode_520_ci,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


DROP TABLE IF EXISTS `wp_gf_form_view`;
CREATE TABLE `wp_gf_form_view` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(8) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` char(15) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `count` mediumint(8) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_gf_form_view` (`id`, `form_id`, `date_created`, `ip`, `count`) VALUES
(1,	3,	'2020-05-21 17:46:28',	'',	5),
(2,	3,	'2020-05-23 18:05:24',	'',	2),
(3,	3,	'2020-05-24 19:57:32',	'',	2),
(4,	2,	'2020-05-25 19:22:26',	'',	1),
(5,	2,	'2020-05-26 19:27:17',	'',	2),
(6,	3,	'2020-05-26 19:27:17',	'',	2),
(7,	3,	'2020-05-27 23:36:00',	'',	3),
(8,	2,	'2020-05-28 00:30:13',	'',	2),
(9,	3,	'2020-05-29 15:24:38',	'',	5),
(10,	3,	'2020-05-30 16:03:22',	'',	6),
(11,	2,	'2020-05-30 20:34:54',	'',	3),
(12,	3,	'2020-06-01 06:57:59',	'',	11),
(13,	2,	'2020-06-01 19:00:31',	'',	6),
(14,	3,	'2020-06-02 10:02:25',	'',	8),
(15,	2,	'2020-06-03 03:51:39',	'',	6),
(16,	3,	'2020-06-03 20:23:36',	'',	8),
(17,	3,	'2020-06-05 00:56:34',	'',	6),
(18,	2,	'2020-06-05 01:10:51',	'',	3),
(19,	2,	'2020-06-06 04:37:09',	'',	7),
(20,	3,	'2020-06-06 05:29:07',	'',	4),
(21,	3,	'2020-06-07 06:02:13',	'',	5),
(22,	2,	'2020-06-07 06:14:38',	'',	1),
(23,	3,	'2020-06-08 09:11:01',	'',	8),
(24,	2,	'2020-06-08 09:25:38',	'',	4),
(25,	3,	'2020-06-09 14:44:03',	'',	7),
(26,	2,	'2020-06-10 03:20:54',	'',	2),
(27,	3,	'2020-06-10 15:29:01',	'',	4),
(28,	3,	'2020-06-11 20:26:09',	'',	7),
(29,	2,	'2020-06-12 01:18:07',	'',	3),
(30,	3,	'2020-06-12 20:31:49',	'',	5),
(31,	2,	'2020-06-13 06:06:44',	'',	3),
(32,	3,	'2020-06-13 21:51:34',	'',	5),
(33,	3,	'2020-06-15 00:02:13',	'',	7),
(34,	2,	'2020-06-15 00:04:44',	'',	4),
(35,	3,	'2020-06-16 01:24:55',	'',	6),
(36,	2,	'2020-06-16 02:38:19',	'',	4),
(37,	3,	'2020-06-18 04:02:44',	'',	4),
(38,	2,	'2020-06-18 04:18:12',	'',	2),
(39,	3,	'2020-06-19 04:26:58',	'',	6),
(40,	2,	'2020-06-19 05:02:41',	'',	3),
(41,	2,	'2020-06-20 05:45:57',	'',	2),
(42,	3,	'2020-06-20 12:15:47',	'',	3),
(43,	3,	'2020-06-21 13:51:53',	'',	11),
(44,	2,	'2020-06-21 21:02:17',	'',	5),
(45,	3,	'2020-06-22 15:49:52',	'',	4),
(46,	2,	'2020-06-23 00:35:14',	'',	4),
(47,	3,	'2020-06-23 19:09:02',	'',	10),
(48,	2,	'2020-06-24 07:25:28',	'',	4),
(49,	3,	'2020-06-25 01:43:34',	'',	10),
(50,	2,	'2020-06-25 16:07:20',	'',	3),
(51,	3,	'2020-06-26 05:08:35',	'',	6),
(52,	2,	'2020-06-26 21:52:17',	'',	10),
(53,	3,	'2020-06-27 08:45:08',	'',	25),
(54,	2,	'2020-06-27 22:38:48',	'',	16),
(55,	3,	'2020-06-28 10:40:12',	'',	5),
(56,	2,	'2020-06-29 03:13:20',	'',	2),
(57,	3,	'2020-06-29 14:25:18',	'',	4),
(58,	2,	'2020-06-30 04:04:49',	'',	3),
(59,	3,	'2020-06-30 16:08:05',	'',	8),
(60,	2,	'2020-07-01 11:25:38',	'',	8),
(61,	3,	'2020-07-01 18:29:15',	'',	11),
(62,	2,	'2020-07-02 15:05:57',	'',	3),
(63,	3,	'2020-07-02 19:31:49',	'',	5),
(64,	3,	'2020-07-03 23:42:26',	'',	9),
(65,	2,	'2020-07-04 00:00:01',	'',	5),
(66,	2,	'2020-07-05 08:35:14',	'',	2),
(67,	3,	'2020-07-05 08:35:18',	'',	4),
(68,	3,	'2020-07-06 22:51:11',	'',	6),
(69,	2,	'2020-07-06 23:08:54',	'',	3),
(70,	3,	'2020-07-07 23:15:29',	'',	4),
(71,	2,	'2020-07-08 02:01:49',	'',	1),
(72,	2,	'2020-07-09 02:21:05',	'',	4),
(73,	3,	'2020-07-09 02:21:09',	'',	7),
(74,	3,	'2020-07-10 08:42:50',	'',	6),
(75,	2,	'2020-07-10 09:07:56',	'',	2),
(76,	3,	'2020-07-11 10:05:19',	'',	4),
(77,	2,	'2020-07-11 10:17:50',	'',	3),
(78,	3,	'2020-07-12 10:24:59',	'',	4),
(79,	2,	'2020-07-12 10:39:37',	'',	2),
(80,	3,	'2020-07-13 13:56:08',	'',	4),
(81,	2,	'2020-07-13 14:11:54',	'',	2),
(82,	3,	'2020-07-14 13:58:55',	'',	6),
(83,	2,	'2020-07-14 15:05:51',	'',	2),
(84,	3,	'2020-07-15 17:17:49',	'',	8),
(85,	2,	'2020-07-15 18:30:17',	'',	3),
(86,	2,	'2020-07-16 19:11:59',	'',	5),
(87,	3,	'2020-07-16 23:02:37',	'',	7),
(88,	2,	'2020-07-18 04:29:49',	'',	3),
(89,	3,	'2020-07-18 09:33:54',	'',	9),
(90,	3,	'2020-07-19 09:51:58',	'',	10),
(91,	2,	'2020-07-20 01:20:00',	'',	2),
(92,	3,	'2020-07-20 18:37:35',	'',	6),
(93,	2,	'2020-07-21 04:06:42',	'',	3),
(94,	3,	'2020-07-21 20:52:14',	'',	4),
(95,	3,	'2020-07-22 21:32:44',	'',	9),
(96,	2,	'2020-07-23 00:32:58',	'',	4),
(97,	3,	'2020-07-24 04:44:24',	'',	8),
(98,	2,	'2020-07-24 05:22:58',	'',	3),
(99,	3,	'2020-07-25 06:20:41',	'',	7),
(100,	2,	'2020-07-25 20:48:54',	'',	2),
(101,	3,	'2020-07-26 08:34:15',	'',	2),
(102,	2,	'2020-07-27 02:26:53',	'',	2),
(103,	3,	'2020-07-27 15:43:42',	'',	3),
(104,	3,	'2020-07-29 13:31:59',	'',	6),
(105,	2,	'2020-07-29 13:48:11',	'',	2),
(106,	3,	'2020-07-30 16:04:16',	'',	4),
(107,	2,	'2020-07-30 16:21:07',	'',	6),
(108,	3,	'2020-07-31 16:11:37',	'',	6),
(109,	2,	'2020-07-31 17:03:55',	'',	4),
(110,	3,	'2020-08-01 19:53:45',	'',	11),
(111,	2,	'2020-08-01 20:08:34',	'',	4),
(112,	3,	'2020-08-02 20:27:35',	'',	6),
(113,	2,	'2020-08-02 20:41:47',	'',	3),
(114,	3,	'2020-08-03 22:54:01',	'',	3),
(115,	2,	'2020-08-03 22:54:38',	'',	3),
(116,	3,	'2020-08-05 00:39:23',	'',	3),
(117,	2,	'2020-08-05 00:55:17',	'',	3),
(118,	3,	'2020-08-06 04:49:41',	'',	4),
(119,	2,	'2020-08-06 05:03:14',	'',	4),
(120,	3,	'2020-08-07 12:56:10',	'',	3),
(121,	2,	'2020-08-08 03:04:47',	'',	4),
(122,	3,	'2020-08-08 15:12:45',	'',	7),
(123,	2,	'2020-08-09 07:15:21',	'',	2),
(124,	3,	'2020-08-09 15:20:47',	'',	4),
(125,	2,	'2020-08-10 09:12:55',	'',	4),
(126,	3,	'2020-08-11 02:34:55',	'',	2),
(127,	3,	'2020-08-12 16:47:15',	'',	6),
(128,	2,	'2020-08-12 17:31:57',	'',	4),
(129,	3,	'2020-08-13 18:15:36',	'',	1),
(130,	2,	'2020-08-13 18:30:30',	'',	1),
(131,	3,	'2020-08-14 21:51:45',	'',	4),
(132,	2,	'2020-08-14 22:07:27',	'',	3),
(133,	3,	'2020-08-16 01:48:22',	'',	5),
(134,	2,	'2020-08-16 06:00:28',	'',	5),
(135,	3,	'2020-08-17 02:02:17',	'',	2),
(136,	2,	'2020-08-18 03:07:14',	'',	3),
(137,	3,	'2020-08-18 06:27:19',	'',	1),
(138,	3,	'2020-08-19 08:46:50',	'',	4),
(139,	2,	'2020-08-19 09:04:31',	'',	4),
(140,	2,	'2020-08-20 09:37:54',	'',	3),
(141,	3,	'2020-08-20 09:37:57',	'',	5),
(142,	3,	'2020-08-21 18:56:26',	'',	6),
(143,	2,	'2020-08-21 22:24:51',	'',	1),
(144,	3,	'2020-08-23 04:23:57',	'',	8),
(145,	2,	'2020-08-23 04:40:04',	'',	3),
(146,	3,	'2020-08-24 05:27:58',	'',	5),
(147,	2,	'2020-08-24 14:17:44',	'',	3),
(148,	3,	'2020-08-25 09:44:11',	'',	3),
(149,	2,	'2020-08-25 23:21:48',	'',	1),
(150,	3,	'2020-08-26 11:57:59',	'',	3),
(151,	2,	'2020-08-27 02:48:07',	'',	3),
(152,	3,	'2020-08-27 19:41:45',	'',	5),
(153,	2,	'2020-08-28 11:03:31',	'',	2),
(154,	3,	'2020-08-28 20:04:33',	'',	3),
(155,	3,	'2020-08-29 20:17:34',	'',	4),
(156,	2,	'2020-08-29 22:15:39',	'',	4),
(157,	3,	'2020-08-30 20:53:58',	'',	3),
(158,	2,	'2020-08-30 23:57:27',	'',	2),
(159,	2,	'2020-09-01 01:32:38',	'',	4),
(160,	3,	'2020-09-01 01:32:41',	'',	4),
(161,	3,	'2020-09-03 06:35:42',	'',	3),
(162,	2,	'2020-09-03 14:55:18',	'',	4),
(163,	3,	'2020-09-04 10:47:00',	'',	5),
(164,	2,	'2020-09-05 10:23:38',	'',	1),
(165,	3,	'2020-09-05 19:43:53',	'',	8),
(166,	2,	'2020-09-06 12:54:59',	'',	2),
(167,	3,	'2020-09-07 01:09:06',	'',	7),
(168,	2,	'2020-09-07 14:54:40',	'',	4),
(169,	3,	'2020-09-08 01:31:13',	'',	3),
(170,	2,	'2020-09-09 01:32:54',	'',	3),
(171,	3,	'2020-09-09 03:01:25',	'',	4),
(172,	3,	'2020-09-10 09:58:32',	'',	3),
(173,	2,	'2020-09-10 10:13:17',	'',	3),
(174,	2,	'2020-09-11 14:42:45',	'',	4),
(175,	3,	'2020-09-11 15:23:05',	'',	4),
(176,	3,	'2020-09-13 01:31:54',	'',	7),
(177,	2,	'2020-09-13 01:44:52',	'',	6),
(178,	3,	'2020-09-14 01:32:16',	'',	10),
(179,	2,	'2020-09-14 01:45:56',	'',	8),
(180,	3,	'2020-09-15 03:54:32',	'',	7),
(181,	2,	'2020-09-15 04:08:51',	'',	5),
(182,	2,	'2020-09-16 06:59:13',	'',	3),
(183,	3,	'2020-09-16 06:59:16',	'',	6),
(184,	3,	'2020-09-17 09:32:06',	'',	8),
(185,	2,	'2020-09-17 11:49:26',	'',	4),
(186,	3,	'2020-09-18 16:54:29',	'',	6),
(187,	2,	'2020-09-18 17:47:37',	'',	5),
(188,	3,	'2020-09-19 19:05:43',	'',	6),
(189,	2,	'2020-09-20 22:25:56',	'',	3),
(190,	3,	'2020-09-21 10:58:14',	'',	5),
(191,	2,	'2020-09-22 00:27:04',	'',	3),
(192,	3,	'2020-09-22 12:49:49',	'',	4),
(193,	2,	'2020-09-23 04:28:35',	'',	5),
(194,	3,	'2020-09-23 13:15:49',	'',	5),
(195,	2,	'2020-09-24 07:36:59',	'',	5),
(196,	3,	'2020-09-24 17:37:58',	'',	4),
(197,	2,	'2020-09-25 11:49:15',	'',	4),
(198,	3,	'2020-09-26 05:52:47',	'',	2),
(199,	3,	'2020-09-27 10:53:55',	'',	6),
(200,	2,	'2020-09-27 11:11:08',	'',	8),
(201,	3,	'2020-09-28 16:36:38',	'',	7),
(202,	2,	'2020-09-28 19:15:44',	'',	3),
(203,	3,	'2020-09-29 18:07:50',	'',	4),
(204,	2,	'2020-09-30 00:55:30',	'',	4),
(205,	3,	'2020-09-30 23:27:08',	'',	6),
(206,	2,	'2020-10-01 10:44:25',	'',	3),
(207,	3,	'2020-10-02 09:04:27',	'',	3),
(208,	2,	'2020-10-02 11:33:46',	'',	3),
(209,	2,	'2020-10-03 18:08:22',	'',	6),
(210,	3,	'2020-10-03 18:30:17',	'',	9),
(211,	3,	'2020-10-04 22:46:50',	'',	6),
(212,	2,	'2020-10-05 08:01:06',	'',	6),
(213,	3,	'2020-10-05 22:48:23',	'',	5),
(214,	2,	'2020-10-06 16:36:33',	'',	5),
(215,	3,	'2020-10-07 01:06:26',	'',	5),
(216,	2,	'2020-10-07 19:39:00',	'',	1),
(217,	3,	'2020-10-08 01:22:41',	'',	5),
(218,	2,	'2020-10-08 19:54:30',	'',	7),
(219,	3,	'2020-10-09 05:13:42',	'',	4),
(220,	2,	'2020-10-09 22:45:54',	'',	3),
(221,	3,	'2020-10-10 07:39:29',	'',	4),
(222,	2,	'2020-10-11 11:45:32',	'',	9),
(223,	3,	'2020-10-11 11:47:17',	'',	9),
(224,	3,	'2020-10-12 17:22:09',	'',	13),
(225,	2,	'2020-10-13 01:44:42',	'',	5),
(226,	3,	'2020-10-13 23:40:12',	'',	9),
(227,	2,	'2020-10-14 02:13:49',	'',	5),
(228,	2,	'2020-10-15 02:13:58',	'',	1),
(229,	3,	'2020-10-15 03:12:47',	'',	5),
(230,	3,	'2020-10-16 03:42:44',	'',	7),
(231,	2,	'2020-10-16 04:01:58',	'',	2),
(232,	3,	'2020-10-17 04:02:49',	'',	4),
(233,	2,	'2020-10-17 07:24:14',	'',	4),
(234,	3,	'2020-10-18 05:48:48',	'',	4),
(235,	2,	'2020-10-18 10:00:36',	'',	4),
(236,	2,	'2020-10-19 20:56:31',	'',	6),
(237,	3,	'2020-10-19 23:00:06',	'',	8),
(238,	3,	'2020-10-21 06:14:47',	'',	8),
(239,	2,	'2020-10-21 10:10:36',	'',	5),
(240,	3,	'2020-10-22 07:29:21',	'',	2),
(241,	2,	'2020-10-23 00:58:05',	'',	2),
(242,	3,	'2020-10-23 16:08:33',	'',	4),
(243,	2,	'2020-10-24 05:58:46',	'',	2),
(244,	3,	'2020-10-24 17:31:13',	'',	5),
(245,	2,	'2020-10-25 09:36:06',	'',	3),
(246,	3,	'2020-10-26 03:25:19',	'',	4),
(247,	2,	'2020-10-26 20:51:35',	'',	6),
(248,	3,	'2020-10-27 07:21:07',	'',	5),
(249,	2,	'2020-10-28 03:23:12',	'',	3),
(250,	3,	'2020-10-28 11:26:36',	'',	6),
(251,	2,	'2020-10-29 06:49:26',	'',	6),
(252,	3,	'2020-10-29 11:31:42',	'',	6),
(253,	2,	'2020-10-30 11:29:49',	'',	2),
(254,	3,	'2020-10-30 13:55:31',	'',	6),
(255,	3,	'2020-10-31 14:29:04',	'',	5),
(256,	2,	'2020-10-31 22:01:13',	'',	4),
(257,	3,	'2020-11-01 15:28:36',	'',	3),
(258,	3,	'2020-11-02 16:07:42',	'',	5),
(259,	2,	'2020-11-02 21:58:02',	'',	3),
(260,	3,	'2020-11-03 20:53:53',	'',	5),
(261,	2,	'2020-11-04 11:29:13',	'',	2),
(262,	3,	'2020-11-04 23:24:47',	'',	2),
(263,	3,	'2020-11-06 03:03:21',	'',	5),
(264,	2,	'2020-11-06 04:24:33',	'',	1),
(265,	3,	'2020-11-07 07:37:03',	'',	6),
(266,	2,	'2020-11-07 07:58:51',	'',	5),
(267,	3,	'2020-11-08 07:54:42',	'',	6),
(268,	2,	'2020-11-08 08:29:30',	'',	3),
(269,	3,	'2020-11-09 09:31:00',	'',	8),
(270,	2,	'2020-11-09 23:41:05',	'',	4),
(271,	3,	'2020-11-10 12:45:59',	'',	7),
(272,	2,	'2020-11-11 01:25:45',	'',	3),
(273,	3,	'2020-11-11 14:55:35',	'',	5),
(274,	2,	'2020-11-12 02:22:27',	'',	2),
(275,	2,	'2020-11-13 02:32:43',	'',	4),
(276,	3,	'2020-11-13 02:44:59',	'',	6),
(277,	3,	'2020-11-14 03:48:24',	'',	5),
(278,	2,	'2020-11-14 18:46:04',	'',	5),
(279,	3,	'2020-11-15 06:48:57',	'',	10),
(280,	2,	'2020-11-15 21:13:51',	'',	3),
(281,	3,	'2020-11-16 19:10:29',	'',	7),
(282,	2,	'2020-11-17 10:53:16',	'',	4),
(283,	3,	'2020-11-17 22:19:56',	'',	4),
(284,	2,	'2020-11-18 19:44:46',	'',	2),
(285,	3,	'2020-11-19 02:42:11',	'',	3),
(286,	2,	'2020-11-19 20:45:15',	'',	3),
(287,	3,	'2020-11-20 06:50:35',	'',	2),
(288,	3,	'2020-11-21 06:54:23',	'',	7),
(289,	2,	'2020-11-21 16:47:59',	'',	5),
(290,	2,	'2020-11-22 17:48:21',	'',	8),
(291,	3,	'2020-11-22 19:54:41',	'',	7),
(292,	2,	'2020-11-23 18:22:46',	'',	5),
(293,	3,	'2020-11-24 06:45:59',	'',	4),
(294,	2,	'2020-11-25 04:52:57',	'',	2),
(295,	3,	'2020-11-25 07:45:52',	'',	5),
(296,	3,	'2020-11-26 11:04:15',	'',	2),
(297,	2,	'2020-11-27 03:47:03',	'',	1),
(298,	3,	'2020-11-27 17:56:47',	'',	4),
(299,	2,	'2020-11-28 06:38:38',	'',	2),
(300,	3,	'2020-11-28 21:34:05',	'',	6),
(301,	2,	'2020-11-29 08:38:37',	'',	3),
(302,	3,	'2020-11-30 00:58:14',	'',	2),
(303,	2,	'2020-11-30 10:08:14',	'',	5),
(304,	3,	'2020-12-01 04:36:15',	'',	5),
(305,	2,	'2020-12-01 19:55:09',	'',	4),
(306,	3,	'2020-12-02 05:07:57',	'',	9),
(307,	2,	'2020-12-03 01:52:25',	'',	2),
(308,	3,	'2020-12-03 13:33:21',	'',	3),
(309,	2,	'2020-12-04 11:32:23',	'',	3),
(310,	3,	'2020-12-04 16:56:38',	'',	3),
(311,	2,	'2020-12-05 13:12:06',	'',	3),
(312,	3,	'2020-12-06 12:09:56',	'',	6),
(313,	2,	'2020-12-06 13:22:19',	'',	4),
(314,	3,	'2020-12-07 14:10:34',	'',	5),
(315,	2,	'2020-12-08 04:44:50',	'',	3),
(316,	3,	'2020-12-08 18:52:19',	'',	4),
(317,	2,	'2020-12-09 15:14:48',	'',	3),
(318,	3,	'2020-12-10 02:40:19',	'',	17),
(319,	2,	'2020-12-10 15:33:18',	'',	9),
(320,	3,	'2020-12-11 18:55:45',	'',	3),
(321,	2,	'2020-12-11 19:14:13',	'',	4),
(322,	3,	'2020-12-13 05:14:33',	'',	7),
(323,	2,	'2020-12-13 06:11:56',	'',	4),
(324,	3,	'2020-12-14 09:38:20',	'',	4),
(325,	3,	'2020-12-15 15:44:55',	'',	10),
(326,	2,	'2020-12-15 16:01:05',	'',	1),
(327,	3,	'2020-12-16 19:39:51',	'',	4),
(328,	2,	'2020-12-16 21:14:59',	'',	3),
(329,	3,	'2020-12-18 00:03:39',	'',	5),
(330,	2,	'2020-12-18 00:24:53',	'',	2),
(331,	3,	'2020-12-19 01:44:23',	'',	3),
(332,	2,	'2020-12-19 01:59:42',	'',	3),
(333,	3,	'2020-12-20 03:14:59',	'',	5),
(334,	2,	'2020-12-20 06:53:57',	'',	2),
(335,	3,	'2020-12-21 21:30:03',	'',	3),
(336,	2,	'2020-12-21 21:47:46',	'',	2),
(337,	3,	'2020-12-23 00:09:33',	'',	6),
(338,	2,	'2020-12-23 06:43:23',	'',	1),
(339,	3,	'2020-12-24 01:00:20',	'',	4),
(340,	2,	'2020-12-24 17:31:29',	'',	4),
(341,	3,	'2020-12-25 10:56:03',	'',	6),
(342,	2,	'2020-12-25 17:40:54',	'',	7),
(343,	3,	'2020-12-26 12:44:04',	'',	6),
(344,	2,	'2020-12-26 20:20:55',	'',	4),
(345,	3,	'2020-12-27 16:41:20',	'',	6),
(346,	2,	'2020-12-28 01:41:42',	'',	5),
(347,	3,	'2020-12-28 17:40:11',	'',	10),
(348,	2,	'2020-12-29 14:01:26',	'',	6),
(349,	2,	'2020-12-30 18:55:30',	'',	8),
(350,	3,	'2020-12-30 18:55:39',	'',	10),
(351,	3,	'2020-12-31 19:15:38',	'',	6),
(352,	2,	'2020-12-31 23:54:05',	'',	1),
(353,	2,	'2021-01-02 06:58:24',	'',	4),
(354,	3,	'2021-01-02 06:58:32',	'',	15),
(355,	2,	'2021-01-03 08:38:59',	'',	3),
(356,	3,	'2021-01-03 08:39:32',	'',	4),
(357,	2,	'2021-01-04 14:16:05',	'',	5),
(358,	3,	'2021-01-04 14:49:19',	'',	10),
(359,	3,	'2021-01-05 20:44:08',	'',	12),
(360,	2,	'2021-01-05 21:55:02',	'',	5),
(361,	2,	'2021-01-06 22:35:27',	'',	2),
(362,	3,	'2021-01-07 04:46:56',	'',	4),
(363,	3,	'2021-01-08 05:44:28',	'',	7),
(364,	2,	'2021-01-08 11:48:36',	'',	6),
(365,	3,	'2021-01-09 13:39:41',	'',	10),
(366,	2,	'2021-01-09 16:20:52',	'',	6),
(367,	2,	'2021-01-10 17:22:26',	'',	3),
(368,	3,	'2021-01-10 17:22:35',	'',	5),
(369,	3,	'2021-01-11 18:02:15',	'',	3),
(370,	2,	'2021-01-11 18:21:12',	'',	3),
(371,	3,	'2021-01-12 22:56:15',	'',	6),
(372,	2,	'2021-01-13 00:35:00',	'',	5),
(373,	3,	'2021-01-13 23:17:19',	'',	5),
(374,	2,	'2021-01-14 03:49:18',	'',	4),
(375,	3,	'2021-01-15 01:33:18',	'',	7),
(376,	2,	'2021-01-15 11:51:16',	'',	5),
(377,	3,	'2021-01-16 06:00:21',	'',	6),
(378,	2,	'2021-01-16 20:19:42',	'',	5),
(379,	3,	'2021-01-17 09:35:35',	'',	5),
(380,	2,	'2021-01-18 06:25:18',	'',	4),
(381,	3,	'2021-01-18 11:20:48',	'',	4),
(382,	3,	'2021-01-19 14:19:09',	'',	8),
(383,	2,	'2021-01-19 21:59:39',	'',	6),
(384,	3,	'2021-01-20 20:24:10',	'',	8),
(385,	2,	'2021-01-21 05:27:12',	'',	8),
(386,	3,	'2021-01-22 01:03:49',	'',	8),
(387,	2,	'2021-01-22 09:22:45',	'',	2),
(388,	3,	'2021-01-23 02:54:30',	'',	6),
(389,	2,	'2021-01-23 09:33:44',	'',	5),
(390,	3,	'2021-01-24 06:31:44',	'',	5),
(391,	2,	'2021-01-24 10:50:54',	'',	2),
(392,	3,	'2021-01-25 18:55:32',	'',	6),
(393,	2,	'2021-01-26 01:42:58',	'',	4),
(394,	3,	'2021-01-26 20:35:05',	'',	6),
(395,	3,	'2021-01-28 07:40:42',	'',	4),
(396,	2,	'2021-01-28 12:16:16',	'',	3),
(397,	3,	'2021-01-29 08:08:38',	'',	4),
(398,	2,	'2021-01-30 01:16:22',	'',	2),
(399,	3,	'2021-01-30 08:28:31',	'',	5),
(400,	2,	'2021-01-31 02:45:37',	'',	4),
(401,	3,	'2021-01-31 08:44:42',	'',	6),
(402,	2,	'2021-02-01 09:00:59',	'',	5),
(403,	3,	'2021-02-01 09:01:07',	'',	5),
(404,	2,	'2021-02-02 13:01:38',	'',	4),
(405,	3,	'2021-02-03 01:10:58',	'',	12),
(406,	2,	'2021-02-03 13:05:08',	'',	4),
(407,	3,	'2021-02-04 01:48:49',	'',	8),
(408,	2,	'2021-02-04 15:05:52',	'',	3),
(409,	3,	'2021-02-05 10:32:51',	'',	9),
(410,	2,	'2021-02-05 17:54:55',	'',	6),
(411,	3,	'2021-02-06 13:31:57',	'',	6),
(412,	2,	'2021-02-07 09:52:53',	'',	3),
(413,	3,	'2021-02-07 22:12:15',	'',	7),
(414,	2,	'2021-02-09 00:26:57',	'',	3),
(415,	3,	'2021-02-09 01:23:27',	'',	5),
(416,	3,	'2021-02-10 06:30:24',	'',	8),
(417,	2,	'2021-02-10 11:35:12',	'',	4),
(418,	3,	'2021-02-11 08:55:13',	'',	6),
(419,	2,	'2021-02-11 21:04:18',	'',	5),
(420,	3,	'2021-02-12 13:15:37',	'',	5),
(421,	2,	'2021-02-13 07:30:25',	'',	5),
(422,	3,	'2021-02-13 16:23:52',	'',	15),
(423,	3,	'2021-02-14 22:31:51',	'',	11),
(424,	2,	'2021-02-15 11:37:56',	'',	4),
(425,	3,	'2021-02-15 23:54:27',	'',	4),
(426,	2,	'2021-02-17 05:05:02',	'',	3),
(427,	3,	'2021-02-17 05:26:30',	'',	5),
(428,	3,	'2021-02-18 11:34:34',	'',	4),
(429,	2,	'2021-02-18 11:55:53',	'',	2),
(430,	3,	'2021-02-19 12:02:14',	'',	3),
(431,	2,	'2021-02-19 12:26:16',	'',	2),
(432,	2,	'2021-02-20 16:07:02',	'',	5),
(433,	3,	'2021-02-20 16:07:09',	'',	9),
(434,	3,	'2021-02-21 20:33:20',	'',	9),
(435,	2,	'2021-02-22 05:30:25',	'',	5),
(436,	3,	'2021-02-22 20:38:00',	'',	7),
(437,	3,	'2021-02-24 00:17:32',	'',	8),
(438,	2,	'2021-02-24 00:57:57',	'',	3),
(439,	3,	'2021-02-25 02:50:19',	'',	9),
(440,	2,	'2021-02-25 03:45:09',	'',	9),
(441,	3,	'2021-02-26 04:06:01',	'',	11),
(442,	2,	'2021-02-26 05:41:22',	'',	3),
(443,	3,	'2021-02-27 09:50:49',	'',	11),
(444,	2,	'2021-02-27 10:17:12',	'',	5),
(445,	2,	'2021-02-28 13:50:45',	'',	2),
(446,	3,	'2021-02-28 19:43:19',	'',	6),
(447,	2,	'2021-03-01 16:31:36',	'',	7),
(448,	3,	'2021-03-01 20:40:25',	'',	13),
(449,	3,	'2021-03-03 03:34:31',	'',	13),
(450,	2,	'2021-03-03 03:57:21',	'',	9),
(451,	3,	'2021-03-04 05:32:56',	'',	12),
(452,	2,	'2021-03-04 05:39:37',	'',	3),
(453,	3,	'2021-03-05 06:45:52',	'',	9),
(454,	2,	'2021-03-05 18:15:23',	'',	6),
(455,	3,	'2021-03-06 08:18:16',	'',	9),
(456,	2,	'2021-03-06 19:35:34',	'',	4),
(457,	3,	'2021-03-07 10:48:59',	'',	12),
(458,	2,	'2021-03-07 21:42:59',	'',	3),
(459,	3,	'2021-03-08 17:01:25',	'',	11),
(460,	2,	'2021-03-09 12:29:52',	'',	3),
(461,	3,	'2021-03-09 19:28:14',	'',	15),
(462,	3,	'2021-03-11 04:08:56',	'',	3),
(463,	3,	'2021-03-12 09:39:52',	'',	6),
(464,	2,	'2021-03-12 19:41:45',	'',	1),
(465,	3,	'2021-03-13 20:46:32',	'',	7),
(466,	2,	'2021-03-14 08:17:24',	'',	6),
(467,	3,	'2021-03-14 22:04:54',	'',	6),
(468,	2,	'2021-03-15 09:31:14',	'',	3),
(469,	3,	'2021-03-16 03:51:52',	'',	8),
(470,	2,	'2021-03-16 10:11:24',	'',	7),
(471,	3,	'2021-03-17 06:29:08',	'',	7),
(472,	2,	'2021-03-18 04:20:11',	'',	4),
(473,	3,	'2021-03-18 14:39:13',	'',	9),
(474,	2,	'2021-03-19 14:10:52',	'',	4),
(475,	3,	'2021-03-19 15:26:42',	'',	7),
(476,	3,	'2021-03-20 16:47:26',	'',	2),
(477,	2,	'2021-03-21 01:13:18',	'',	5),
(478,	3,	'2021-03-21 17:51:24',	'',	12),
(479,	2,	'2021-03-22 04:22:39',	'',	9),
(480,	3,	'2021-03-22 18:19:21',	'',	7),
(481,	2,	'2021-03-23 05:23:14',	'',	4),
(482,	3,	'2021-03-24 05:28:10',	'',	15),
(483,	2,	'2021-03-24 06:16:57',	'',	7),
(484,	3,	'2021-03-25 06:20:25',	'',	13),
(485,	2,	'2021-03-26 00:03:34',	'',	4),
(486,	3,	'2021-03-26 12:14:24',	'',	7),
(487,	2,	'2021-03-27 09:50:12',	'',	6),
(488,	3,	'2021-03-27 14:37:23',	'',	8),
(489,	2,	'2021-03-28 10:13:55',	'',	2),
(490,	3,	'2021-03-28 19:05:15',	'',	1),
(491,	3,	'2021-03-29 22:28:35',	'',	7),
(492,	2,	'2021-03-30 01:31:46',	'',	4),
(493,	3,	'2021-03-30 22:50:31',	'',	7),
(494,	2,	'2021-03-31 04:19:46',	'',	3),
(495,	3,	'2021-04-01 01:58:10',	'',	7),
(496,	2,	'2021-04-01 05:43:21',	'',	4),
(497,	3,	'2021-04-02 02:16:25',	'',	5),
(498,	3,	'2021-04-03 03:37:18',	'',	4),
(499,	2,	'2021-04-04 02:25:44',	'',	6),
(500,	3,	'2021-04-04 08:09:34',	'',	10),
(501,	2,	'2021-04-05 07:19:21',	'',	2),
(502,	3,	'2021-04-05 11:27:28',	'',	4),
(503,	3,	'2021-04-06 21:36:30',	'',	10),
(504,	2,	'2021-04-07 01:34:42',	'',	6),
(505,	3,	'2021-04-07 23:41:58',	'',	12),
(506,	2,	'2021-04-08 12:18:35',	'',	7),
(507,	3,	'2021-04-09 05:15:36',	'',	11),
(508,	2,	'2021-04-10 00:06:00',	'',	2),
(509,	3,	'2021-04-10 10:38:15',	'',	4),
(510,	2,	'2021-04-11 06:23:21',	'',	3),
(511,	3,	'2021-04-11 10:52:36',	'',	4),
(512,	2,	'2021-04-12 13:05:12',	'',	6),
(513,	3,	'2021-04-12 13:45:36',	'',	10),
(514,	3,	'2021-04-13 16:05:56',	'',	13),
(515,	2,	'2021-04-13 17:13:13',	'',	6),
(516,	3,	'2021-04-14 18:40:18',	'',	11),
(517,	2,	'2021-04-14 20:57:16',	'',	8),
(518,	3,	'2021-04-15 19:52:24',	'',	12),
(519,	2,	'2021-04-15 22:56:50',	'',	7),
(520,	3,	'2021-04-16 21:27:27',	'',	9),
(521,	2,	'2021-04-17 00:29:58',	'',	8),
(522,	3,	'2021-04-18 00:02:09',	'',	10),
(523,	2,	'2021-04-18 01:27:46',	'',	3),
(524,	3,	'2021-04-19 00:05:25',	'',	5),
(525,	2,	'2021-04-19 02:34:11',	'',	2),
(526,	3,	'2021-04-20 05:12:23',	'',	7),
(527,	2,	'2021-04-21 01:59:25',	'',	4),
(528,	3,	'2021-04-21 07:23:40',	'',	14),
(529,	2,	'2021-04-22 03:23:39',	'',	8),
(530,	3,	'2021-04-22 09:25:33',	'',	10),
(531,	3,	'2021-04-23 09:31:09',	'',	9),
(532,	2,	'2021-04-23 09:56:47',	'',	7),
(533,	3,	'2021-04-24 11:26:21',	'',	11),
(534,	2,	'2021-04-24 11:33:11',	'',	8),
(535,	3,	'2021-04-25 16:35:07',	'',	3),
(536,	2,	'2021-04-25 19:49:19',	'',	1),
(537,	3,	'2021-04-26 17:34:51',	'',	10),
(538,	2,	'2021-04-26 20:25:04',	'',	3),
(539,	3,	'2021-04-27 17:49:40',	'',	8),
(540,	2,	'2021-04-28 01:37:30',	'',	3),
(541,	3,	'2021-04-28 19:03:35',	'',	7),
(542,	2,	'2021-04-29 15:00:20',	'',	5),
(543,	3,	'2021-04-29 19:37:57',	'',	9),
(544,	2,	'2021-04-30 16:58:31',	'',	11),
(545,	3,	'2021-04-30 20:20:37',	'',	17),
(546,	3,	'2021-05-01 20:55:00',	'',	14),
(547,	2,	'2021-05-02 03:02:27',	'',	9),
(548,	3,	'2021-05-03 03:53:45',	'',	10),
(549,	2,	'2021-05-03 11:03:07',	'',	8),
(550,	3,	'2021-05-04 04:25:38',	'',	14),
(551,	2,	'2021-05-04 12:05:41',	'',	7),
(552,	3,	'2021-05-05 05:00:24',	'',	10),
(553,	2,	'2021-05-05 14:45:09',	'',	6),
(554,	3,	'2021-05-06 09:05:11',	'',	9),
(555,	2,	'2021-05-06 17:19:36',	'',	4),
(556,	3,	'2021-05-07 16:58:44',	'',	14),
(557,	2,	'2021-05-07 18:15:07',	'',	9),
(558,	3,	'2021-05-08 18:07:00',	'',	10),
(559,	2,	'2021-05-08 19:21:10',	'',	4),
(560,	3,	'2021-05-09 18:58:34',	'',	12),
(561,	2,	'2021-05-09 20:53:38',	'',	6),
(562,	3,	'2021-05-10 19:02:51',	'',	8),
(563,	2,	'2021-05-10 21:52:13',	'',	4),
(564,	2,	'2021-05-12 05:40:55',	'',	8),
(565,	3,	'2021-05-12 05:40:57',	'',	14),
(566,	3,	'2021-05-13 07:15:23',	'',	7),
(567,	2,	'2021-05-13 15:46:50',	'',	7),
(568,	3,	'2021-05-14 10:58:59',	'',	10),
(569,	2,	'2021-05-14 16:58:01',	'',	2),
(570,	3,	'2021-05-15 14:19:08',	'',	9),
(571,	2,	'2021-05-15 18:55:38',	'',	6),
(572,	3,	'2021-05-16 14:36:44',	'',	6),
(573,	2,	'2021-05-17 04:03:01',	'',	4),
(574,	3,	'2021-05-17 16:53:26',	'',	8),
(575,	2,	'2021-05-18 04:04:52',	'',	7),
(576,	3,	'2021-05-18 17:40:47',	'',	7),
(577,	2,	'2021-05-19 16:07:34',	'',	5),
(578,	3,	'2021-05-19 20:31:18',	'',	8),
(579,	3,	'2021-05-21 00:45:17',	'',	16),
(580,	2,	'2021-05-21 02:02:48',	'',	7),
(581,	3,	'2021-05-22 02:20:18',	'',	14),
(582,	2,	'2021-05-22 02:46:21',	'',	9),
(583,	3,	'2021-05-23 08:10:39',	'',	7),
(584,	2,	'2021-05-23 09:20:47',	'',	2),
(585,	3,	'2021-05-24 08:56:13',	'',	13),
(586,	2,	'2021-05-24 09:25:18',	'',	7),
(587,	3,	'2021-05-25 13:38:24',	'',	11),
(588,	2,	'2021-05-25 22:56:12',	'',	6),
(589,	3,	'2021-05-26 16:14:00',	'',	11),
(590,	2,	'2021-05-27 00:35:14',	'',	5),
(591,	3,	'2021-05-27 19:32:04',	'',	17),
(592,	2,	'2021-05-28 00:44:00',	'',	7),
(593,	3,	'2021-05-29 06:26:16',	'',	10),
(594,	2,	'2021-05-29 10:12:17',	'',	7),
(595,	3,	'2021-05-30 07:36:56',	'',	12),
(596,	2,	'2021-05-30 10:18:28',	'',	9),
(597,	3,	'2021-05-31 07:41:14',	'',	14),
(598,	2,	'2021-05-31 14:13:17',	'',	11),
(599,	3,	'2021-06-01 09:06:21',	'',	13),
(600,	2,	'2021-06-01 17:50:29',	'',	7),
(601,	3,	'2021-06-02 11:59:22',	'',	13),
(602,	2,	'2021-06-02 18:06:22',	'',	5),
(603,	3,	'2021-06-03 15:12:45',	'',	4),
(604,	2,	'2021-06-04 03:02:56',	'',	5),
(605,	3,	'2021-06-04 19:52:55',	'',	10),
(606,	2,	'2021-06-05 10:30:25',	'',	2),
(607,	3,	'2021-06-06 13:04:26',	'',	8),
(608,	2,	'2021-06-06 13:33:52',	'',	2),
(609,	3,	'2021-06-07 15:46:39',	'',	5),
(610,	2,	'2021-06-07 20:18:05',	'',	1),
(611,	3,	'2021-06-08 23:22:14',	'',	4),
(612,	2,	'2021-06-09 12:51:46',	'',	3),
(613,	3,	'2021-06-10 01:23:40',	'',	5),
(614,	2,	'2021-06-10 23:49:58',	'',	4),
(615,	3,	'2021-06-11 03:27:44',	'',	7),
(616,	2,	'2021-06-12 02:12:46',	'',	5),
(617,	3,	'2021-06-12 15:23:20',	'',	5),
(618,	2,	'2021-06-13 06:30:55',	'',	5),
(619,	3,	'2021-06-13 17:16:01',	'',	6),
(620,	2,	'2021-06-14 08:15:09',	'',	4),
(621,	3,	'2021-06-14 20:40:11',	'',	8),
(622,	2,	'2021-06-15 11:04:28',	'',	5),
(623,	3,	'2021-06-16 04:17:10',	'',	5),
(624,	3,	'2021-06-17 13:29:31',	'',	13),
(625,	2,	'2021-06-17 14:04:19',	'',	9),
(626,	3,	'2021-06-18 16:33:05',	'',	13),
(627,	2,	'2021-06-18 19:42:55',	'',	5),
(628,	3,	'2021-06-19 17:04:09',	'',	8),
(629,	2,	'2021-06-19 22:00:40',	'',	3),
(630,	3,	'2021-06-20 17:54:31',	'',	6),
(631,	2,	'2021-06-20 23:11:47',	'',	2),
(632,	3,	'2021-06-22 08:02:29',	'',	10),
(633,	2,	'2021-06-22 08:08:08',	'',	6),
(634,	3,	'2021-06-23 13:48:06',	'',	5),
(635,	2,	'2021-06-23 17:59:31',	'',	2),
(636,	3,	'2021-06-24 19:28:14',	'',	6),
(637,	2,	'2021-06-24 23:39:03',	'',	4),
(638,	3,	'2021-06-25 19:44:32',	'',	7),
(639,	2,	'2021-06-26 09:56:29',	'',	6),
(640,	3,	'2021-06-27 00:05:24',	'',	7),
(641,	2,	'2021-06-27 13:21:35',	'',	2),
(642,	3,	'2021-06-28 02:11:23',	'',	9),
(643,	2,	'2021-06-29 01:14:43',	'',	6),
(644,	3,	'2021-06-29 02:47:39',	'',	14),
(645,	3,	'2021-06-30 03:18:56',	'',	10),
(646,	2,	'2021-06-30 03:46:38',	'',	7),
(647,	3,	'2021-07-01 05:44:12',	'',	9),
(648,	2,	'2021-07-01 07:51:33',	'',	7),
(649,	3,	'2021-07-02 08:49:42',	'',	9),
(650,	2,	'2021-07-02 09:20:07',	'',	7),
(651,	3,	'2021-07-03 10:35:20',	'',	9),
(652,	2,	'2021-07-03 11:16:36',	'',	6),
(653,	3,	'2021-07-04 15:10:05',	'',	18),
(654,	2,	'2021-07-04 15:37:54',	'',	5),
(655,	3,	'2021-07-05 15:30:24',	'',	16),
(656,	2,	'2021-07-05 18:42:01',	'',	4),
(657,	3,	'2021-07-06 16:14:43',	'',	32),
(658,	2,	'2021-07-06 22:42:46',	'',	5),
(659,	3,	'2021-07-08 01:47:49',	'',	16),
(660,	2,	'2021-07-08 02:16:35',	'',	4),
(661,	3,	'2021-07-09 03:12:13',	'',	10),
(662,	2,	'2021-07-09 06:05:19',	'',	5),
(663,	3,	'2021-07-10 04:03:26',	'',	31),
(664,	2,	'2021-07-10 13:13:58',	'',	6),
(665,	3,	'2021-07-11 09:21:32',	'',	20),
(666,	2,	'2021-07-11 14:41:02',	'',	4),
(667,	3,	'2021-07-12 12:41:48',	'',	24),
(668,	2,	'2021-07-12 18:59:56',	'',	6),
(669,	3,	'2021-07-13 14:41:50',	'',	13),
(670,	2,	'2021-07-14 00:02:52',	'',	9),
(671,	3,	'2021-07-14 16:28:03',	'',	12),
(672,	2,	'2021-07-15 00:04:51',	'',	8),
(673,	3,	'2021-07-15 20:33:25',	'',	14),
(674,	2,	'2021-07-16 00:12:39',	'',	3),
(675,	3,	'2021-07-16 21:46:03',	'',	17),
(676,	2,	'2021-07-17 00:30:59',	'',	10),
(677,	3,	'2021-07-17 22:21:43',	'',	32),
(678,	2,	'2021-07-18 00:58:13',	'',	9),
(679,	2,	'2021-07-19 02:56:20',	'',	7),
(680,	3,	'2021-07-19 04:15:19',	'',	25),
(681,	2,	'2021-07-20 03:39:30',	'',	4),
(682,	3,	'2021-07-20 04:38:32',	'',	14),
(683,	3,	'2021-07-21 08:13:52',	'',	15),
(684,	2,	'2021-07-21 09:21:09',	'',	5),
(685,	3,	'2021-07-22 11:28:22',	'',	18),
(686,	2,	'2021-07-22 13:43:38',	'',	7),
(687,	3,	'2021-07-23 13:48:44',	'',	19),
(688,	2,	'2021-07-24 05:08:49',	'',	7),
(689,	3,	'2021-07-24 14:34:27',	'',	13),
(690,	2,	'2021-07-25 10:02:51',	'',	6),
(691,	3,	'2021-07-25 14:36:05',	'',	16),
(692,	2,	'2021-07-26 12:55:31',	'',	3),
(693,	3,	'2021-07-26 16:08:08',	'',	28),
(694,	2,	'2021-07-27 16:47:54',	'',	8),
(695,	3,	'2021-07-27 16:49:12',	'',	11),
(696,	2,	'2021-07-28 19:24:49',	'',	6),
(697,	3,	'2021-07-28 19:54:56',	'',	26),
(698,	3,	'2021-07-30 03:03:44',	'',	11),
(699,	2,	'2021-07-30 03:33:31',	'',	2),
(700,	2,	'2021-07-31 03:57:10',	'',	6),
(701,	3,	'2021-07-31 03:57:14',	'',	17),
(702,	3,	'2021-08-01 06:11:58',	'',	20),
(703,	2,	'2021-08-01 07:06:51',	'',	4),
(704,	3,	'2021-08-02 06:57:36',	'',	18),
(705,	2,	'2021-08-03 05:35:16',	'',	4),
(706,	3,	'2021-08-03 08:03:31',	'',	8),
(707,	2,	'2021-08-04 06:53:54',	'',	5),
(708,	3,	'2021-08-04 21:59:09',	'',	21),
(709,	2,	'2021-08-05 15:30:58',	'',	6),
(710,	3,	'2021-08-05 22:00:46',	'',	18),
(711,	2,	'2021-08-06 17:13:45',	'',	4),
(712,	3,	'2021-08-07 04:12:43',	'',	11),
(713,	2,	'2021-08-07 20:29:23',	'',	3),
(714,	3,	'2021-08-08 07:28:26',	'',	5),
(715,	2,	'2021-08-08 23:14:40',	'',	6),
(716,	3,	'2021-08-09 09:49:38',	'',	10),
(717,	2,	'2021-08-10 00:35:51',	'',	7),
(718,	3,	'2021-08-10 10:26:47',	'',	16),
(719,	2,	'2021-08-11 08:55:22',	'',	1),
(720,	3,	'2021-08-11 11:40:42',	'',	11),
(721,	3,	'2021-08-13 03:33:47',	'',	17),
(722,	2,	'2021-08-13 17:20:12',	'',	1),
(723,	3,	'2021-08-14 08:41:08',	'',	7),
(724,	2,	'2021-08-15 03:34:35',	'',	2),
(725,	3,	'2021-08-15 11:02:28',	'',	11),
(726,	2,	'2021-08-16 08:34:55',	'',	9),
(727,	3,	'2021-08-16 11:15:11',	'',	14),
(728,	3,	'2021-08-17 14:21:04',	'',	12),
(729,	2,	'2021-08-17 14:53:48',	'',	4),
(730,	3,	'2021-08-18 15:05:06',	'',	18),
(731,	2,	'2021-08-18 17:40:48',	'',	1),
(732,	3,	'2021-08-19 15:45:02',	'',	14),
(733,	2,	'2021-08-20 02:32:00',	'',	4),
(734,	3,	'2021-08-20 16:47:14',	'',	6),
(735,	2,	'2021-08-21 14:52:18',	'',	2),
(736,	3,	'2021-08-21 19:09:09',	'',	15),
(737,	3,	'2021-08-22 19:12:16',	'',	19),
(738,	2,	'2021-08-22 19:51:09',	'',	3),
(739,	3,	'2021-08-23 19:18:17',	'',	11),
(740,	2,	'2021-08-24 07:38:29',	'',	2),
(741,	3,	'2021-08-25 00:56:38',	'',	13),
(742,	3,	'2021-08-26 00:56:51',	'',	12),
(743,	2,	'2021-08-26 00:58:01',	'',	6),
(744,	3,	'2021-08-27 01:53:50',	'',	12),
(745,	2,	'2021-08-27 23:03:38',	'',	5),
(746,	3,	'2021-08-28 02:16:33',	'',	9),
(747,	3,	'2021-08-29 03:51:07',	'',	20),
(748,	2,	'2021-08-29 07:45:27',	'',	2),
(749,	3,	'2021-08-30 05:46:09',	'',	19),
(750,	2,	'2021-08-30 08:49:53',	'',	6),
(751,	3,	'2021-08-31 06:31:43',	'',	13),
(752,	3,	'2021-09-01 07:09:50',	'',	21),
(753,	2,	'2021-09-01 12:34:12',	'',	2),
(754,	3,	'2021-09-02 07:20:16',	'',	12),
(755,	2,	'2021-09-02 20:08:18',	'',	3),
(756,	3,	'2021-09-03 07:36:13',	'',	7),
(757,	2,	'2021-09-04 09:44:59',	'',	1),
(758,	3,	'2021-09-04 11:01:36',	'',	11),
(759,	2,	'2021-09-05 19:59:02',	'',	1),
(760,	3,	'2021-09-05 21:10:36',	'',	24),
(761,	2,	'2021-09-06 21:42:55',	'',	2),
(762,	3,	'2021-09-07 00:41:23',	'',	15),
(763,	3,	'2021-09-08 00:42:38',	'',	15),
(764,	2,	'2021-09-08 07:49:00',	'',	3),
(765,	3,	'2021-09-09 01:43:31',	'',	18),
(766,	2,	'2021-09-10 03:05:10',	'',	3),
(767,	3,	'2021-09-10 04:46:42',	'',	24),
(768,	3,	'2021-09-11 04:50:47',	'',	31),
(769,	2,	'2021-09-11 05:15:29',	'',	3),
(770,	3,	'2021-09-12 06:43:36',	'',	21),
(771,	2,	'2021-09-12 12:34:51',	'',	2),
(772,	3,	'2021-09-13 11:20:06',	'',	10),
(773,	2,	'2021-09-14 03:47:35',	'',	4),
(774,	3,	'2021-09-14 17:15:27',	'',	19),
(775,	2,	'2021-09-15 08:15:32',	'',	2),
(776,	3,	'2021-09-15 19:01:13',	'',	8),
(777,	3,	'2021-09-16 19:52:20',	'',	4),
(778,	2,	'2021-09-17 20:05:43',	'',	2),
(779,	3,	'2021-09-18 00:55:34',	'',	17),
(780,	2,	'2021-09-18 21:52:30',	'',	4),
(781,	3,	'2021-09-19 04:17:11',	'',	12),
(782,	3,	'2021-09-20 06:42:15',	'',	14),
(783,	3,	'2021-09-21 12:57:20',	'',	11),
(784,	3,	'2021-09-22 15:41:39',	'',	12),
(785,	3,	'2021-09-23 21:25:05',	'',	10),
(786,	2,	'2021-09-24 07:44:28',	'',	3),
(787,	3,	'2021-09-24 21:35:18',	'',	20),
(788,	2,	'2021-09-25 13:15:39',	'',	3),
(789,	3,	'2021-09-26 01:26:03',	'',	12),
(790,	2,	'2021-09-26 23:39:25',	'',	6),
(791,	3,	'2021-09-27 02:31:44',	'',	16),
(792,	3,	'2021-09-28 02:44:20',	'',	18),
(793,	2,	'2021-09-28 09:04:28',	'',	2),
(794,	3,	'2021-09-29 03:36:56',	'',	9),
(795,	3,	'2021-09-30 07:00:07',	'',	13),
(796,	2,	'2021-09-30 14:01:22',	'',	1),
(797,	3,	'2021-10-01 11:27:31',	'',	30),
(798,	3,	'2021-10-02 14:35:28',	'',	8),
(799,	3,	'2021-10-03 15:36:02',	'',	13),
(800,	2,	'2021-10-03 20:31:32',	'',	4),
(801,	3,	'2021-10-04 20:00:54',	'',	20),
(802,	3,	'2021-10-05 21:05:19',	'',	13),
(803,	2,	'2021-10-06 01:13:59',	'',	2),
(804,	3,	'2021-10-06 22:32:45',	'',	13),
(805,	2,	'2021-10-07 03:13:27',	'',	2),
(806,	3,	'2021-10-07 22:34:44',	'',	6),
(807,	2,	'2021-10-08 16:46:50',	'',	1),
(808,	3,	'2021-10-09 05:20:42',	'',	10),
(809,	3,	'2021-10-10 05:21:14',	'',	14),
(810,	2,	'2021-10-10 07:12:21',	'',	1),
(811,	3,	'2021-10-11 22:03:14',	'',	11),
(812,	3,	'2021-10-12 22:21:59',	'',	10),
(813,	2,	'2021-10-13 05:32:46',	'',	2),
(814,	3,	'2021-10-14 00:18:09',	'',	8),
(815,	2,	'2021-10-14 08:15:59',	'',	7),
(816,	3,	'2021-10-15 00:41:56',	'',	19),
(817,	2,	'2021-10-15 17:09:22',	'',	4),
(818,	3,	'2021-10-16 01:27:56',	'',	12),
(819,	3,	'2021-10-17 07:28:16',	'',	7),
(820,	2,	'2021-10-17 08:21:23',	'',	1),
(821,	3,	'2021-10-18 07:40:11',	'',	17),
(822,	2,	'2021-10-18 12:31:00',	'',	1),
(823,	3,	'2021-10-19 09:00:11',	'',	6),
(824,	2,	'2021-10-20 08:39:46',	'',	1),
(825,	3,	'2021-10-20 11:05:48',	'',	13),
(826,	2,	'2021-10-21 09:41:06',	'',	6),
(827,	3,	'2021-10-21 12:40:45',	'',	22),
(828,	3,	'2021-10-22 14:13:55',	'',	14),
(829,	2,	'2021-10-22 14:17:18',	'',	2),
(830,	3,	'2021-10-23 15:34:38',	'',	15),
(831,	2,	'2021-10-23 20:11:42',	'',	1),
(832,	3,	'2021-10-24 15:38:30',	'',	12),
(833,	2,	'2021-10-25 00:26:20',	'',	1),
(834,	3,	'2021-10-25 19:56:37',	'',	15),
(835,	3,	'2021-10-26 20:33:32',	'',	16),
(836,	2,	'2021-10-27 04:14:53',	'',	7),
(837,	3,	'2021-10-27 21:26:29',	'',	11),
(838,	2,	'2021-10-28 16:50:47',	'',	1),
(839,	3,	'2021-10-28 23:31:47',	'',	12),
(840,	3,	'2021-10-30 00:45:17',	'',	16),
(841,	3,	'2021-10-31 10:15:09',	'',	4),
(842,	2,	'2021-10-31 13:43:35',	'',	1),
(843,	3,	'2021-11-01 11:19:31',	'',	8),
(844,	2,	'2021-11-01 17:08:35',	'',	2),
(845,	3,	'2021-11-02 12:06:19',	'',	11),
(846,	2,	'2021-11-02 18:59:48',	'',	1),
(847,	3,	'2021-11-03 13:59:13',	'',	17),
(848,	3,	'2021-11-04 15:12:32',	'',	4),
(849,	3,	'2021-11-05 19:59:07',	'',	13),
(850,	3,	'2021-11-06 20:16:04',	'',	14),
(851,	2,	'2021-11-07 17:22:54',	'',	1),
(852,	3,	'2021-11-07 21:29:16',	'',	20),
(853,	2,	'2021-11-08 20:12:31',	'',	2),
(854,	3,	'2021-11-08 23:45:32',	'',	14),
(855,	2,	'2021-11-09 22:28:57',	'',	1),
(856,	3,	'2021-11-09 23:52:51',	'',	20),
(857,	3,	'2021-11-10 23:57:50',	'',	15),
(858,	3,	'2021-11-12 00:43:28',	'',	5),
(859,	2,	'2021-11-12 00:43:42',	'',	2),
(860,	3,	'2021-11-13 01:11:58',	'',	8),
(861,	3,	'2021-11-14 02:44:40',	'',	15),
(862,	2,	'2021-11-14 09:14:47',	'',	2),
(863,	3,	'2021-11-15 04:10:05',	'',	11),
(864,	2,	'2021-11-15 22:26:42',	'',	1),
(865,	3,	'2021-11-16 05:20:19',	'',	7),
(866,	3,	'2021-11-17 09:28:04',	'',	8),
(867,	2,	'2021-11-17 18:35:45',	'',	1),
(868,	3,	'2021-11-18 16:10:25',	'',	7),
(869,	3,	'2021-11-19 16:43:55',	'',	9),
(870,	2,	'2021-11-19 22:22:47',	'',	2),
(871,	3,	'2021-11-21 00:27:29',	'',	13),
(872,	3,	'2021-11-22 01:18:08',	'',	16),
(873,	3,	'2021-11-23 05:38:24',	'',	13),
(874,	2,	'2021-11-23 16:44:40',	'',	2),
(875,	3,	'2021-11-24 14:31:51',	'',	8),
(876,	2,	'2021-11-25 12:35:10',	'',	2),
(877,	3,	'2021-11-25 15:51:19',	'',	11),
(878,	3,	'2021-11-27 03:32:20',	'',	13),
(879,	2,	'2021-11-27 03:38:21',	'',	1),
(880,	3,	'2021-11-28 04:57:04',	'',	11),
(881,	2,	'2021-11-28 04:58:15',	'',	2),
(882,	3,	'2021-11-29 09:39:51',	'',	13),
(883,	2,	'2021-11-30 09:15:24',	'',	3),
(884,	3,	'2021-11-30 10:19:26',	'',	7),
(885,	3,	'2021-12-01 11:35:26',	'',	11),
(886,	2,	'2021-12-01 19:23:15',	'',	3),
(887,	3,	'2021-12-02 11:53:55',	'',	8),
(888,	3,	'2021-12-03 12:45:26',	'',	10),
(889,	2,	'2021-12-03 16:00:56',	'',	3),
(890,	3,	'2021-12-04 15:53:16',	'',	17),
(891,	2,	'2021-12-05 03:26:35',	'',	1),
(892,	3,	'2021-12-05 19:57:31',	'',	4),
(893,	3,	'2021-12-06 20:06:47',	'',	24),
(894,	2,	'2021-12-06 20:42:05',	'',	2),
(895,	3,	'2021-12-07 21:18:56',	'',	17),
(896,	2,	'2021-12-08 03:08:17',	'',	3),
(897,	3,	'2021-12-08 22:36:42',	'',	7),
(898,	3,	'2021-12-09 23:25:24',	'',	13),
(899,	2,	'2021-12-10 04:06:46',	'',	3),
(900,	3,	'2021-12-11 01:13:29',	'',	12),
(901,	2,	'2021-12-11 11:27:18',	'',	5),
(902,	3,	'2021-12-12 02:10:13',	'',	17),
(903,	2,	'2021-12-12 21:09:22',	'',	3),
(904,	3,	'2021-12-13 04:23:45',	'',	8),
(905,	3,	'2021-12-14 07:06:48',	'',	13),
(906,	2,	'2021-12-14 11:47:12',	'',	4),
(907,	3,	'2021-12-15 09:21:06',	'',	6),
(908,	2,	'2021-12-16 05:18:15',	'',	3),
(909,	3,	'2021-12-16 10:57:36',	'',	19),
(910,	2,	'2021-12-17 06:40:49',	'',	1),
(911,	3,	'2021-12-17 16:28:53',	'',	8),
(912,	3,	'2021-12-18 20:14:12',	'',	11),
(913,	2,	'2021-12-18 20:15:43',	'',	3),
(914,	3,	'2021-12-19 21:15:46',	'',	16),
(915,	2,	'2021-12-20 12:46:58',	'',	4),
(916,	3,	'2021-12-20 22:25:31',	'',	18),
(917,	3,	'2021-12-22 02:30:48',	'',	18),
(918,	2,	'2021-12-22 02:32:10',	'',	3),
(919,	3,	'2021-12-23 08:22:58',	'',	22),
(920,	2,	'2021-12-23 14:28:12',	'',	6),
(921,	3,	'2021-12-24 08:33:36',	'',	9),
(922,	2,	'2021-12-24 20:47:19',	'',	3),
(923,	3,	'2021-12-25 15:27:22',	'',	7),
(924,	3,	'2021-12-26 15:57:04',	'',	14),
(925,	2,	'2021-12-27 17:21:24',	'',	4),
(926,	3,	'2021-12-27 20:34:24',	'',	11),
(927,	3,	'2021-12-29 05:51:08',	'',	9),
(928,	2,	'2021-12-29 10:00:49',	'',	2),
(929,	3,	'2021-12-30 14:04:59',	'',	15),
(930,	2,	'2021-12-30 14:05:52',	'',	1),
(931,	3,	'2021-12-31 16:01:22',	'',	6),
(932,	2,	'2021-12-31 16:01:36',	'',	1),
(933,	3,	'2022-01-01 19:25:31',	'',	22),
(934,	2,	'2022-01-02 01:09:02',	'',	4),
(935,	3,	'2022-01-02 22:49:46',	'',	9),
(936,	3,	'2022-01-03 22:57:47',	'',	9),
(937,	2,	'2022-01-04 18:58:32',	'',	2),
(938,	3,	'2022-01-05 15:26:11',	'',	11),
(939,	2,	'2022-01-06 11:13:02',	'',	1),
(940,	3,	'2022-01-06 15:30:42',	'',	33),
(941,	3,	'2022-01-07 16:24:37',	'',	20),
(942,	3,	'2022-01-08 16:41:52',	'',	8),
(943,	2,	'2022-01-08 18:01:29',	'',	3),
(944,	3,	'2022-01-09 21:24:54',	'',	11),
(945,	2,	'2022-01-10 08:02:31',	'',	2),
(946,	3,	'2022-01-10 22:30:55',	'',	14),
(947,	2,	'2022-01-11 11:05:44',	'',	1),
(948,	3,	'2022-01-12 13:57:25',	'',	7),
(949,	2,	'2022-01-12 13:58:11',	'',	1),
(950,	3,	'2022-01-13 15:37:10',	'',	6),
(951,	2,	'2022-01-13 21:21:25',	'',	3),
(952,	3,	'2022-01-14 16:04:24',	'',	12),
(953,	2,	'2022-01-14 23:14:52',	'',	1),
(954,	3,	'2022-01-15 17:26:55',	'',	13),
(955,	2,	'2022-01-16 00:40:49',	'',	4),
(956,	3,	'2022-01-16 18:22:09',	'',	11),
(957,	2,	'2022-01-17 07:43:31',	'',	2),
(958,	3,	'2022-01-17 19:09:32',	'',	19),
(959,	2,	'2022-01-18 13:20:35',	'',	2),
(960,	3,	'2022-01-18 20:13:40',	'',	18),
(961,	3,	'2022-01-19 20:33:07',	'',	11),
(962,	3,	'2022-01-21 01:02:26',	'',	7),
(963,	3,	'2022-01-22 11:26:33',	'',	7),
(964,	2,	'2022-01-22 17:10:56',	'',	2),
(965,	3,	'2022-01-23 13:55:25',	'',	14),
(966,	3,	'2022-01-24 16:51:04',	'',	10),
(967,	3,	'2022-01-25 22:52:21',	'',	13),
(968,	3,	'2022-01-27 01:58:45',	'',	14),
(969,	3,	'2022-01-28 10:21:49',	'',	21),
(970,	3,	'2022-01-29 13:51:36',	'',	13),
(971,	3,	'2022-01-30 14:49:27',	'',	17),
(972,	3,	'2022-01-31 16:24:16',	'',	22),
(973,	3,	'2022-02-01 17:02:58',	'',	27),
(974,	3,	'2022-02-02 19:47:45',	'',	17),
(975,	3,	'2022-02-04 00:23:25',	'',	17),
(976,	3,	'2022-02-05 01:35:31',	'',	19),
(977,	3,	'2022-02-06 01:40:26',	'',	12),
(978,	3,	'2022-02-07 06:55:04',	'',	9),
(979,	3,	'2022-02-08 09:17:29',	'',	15),
(980,	3,	'2022-02-09 09:48:35',	'',	14),
(981,	3,	'2022-02-10 13:35:00',	'',	25),
(982,	3,	'2022-02-11 16:00:50',	'',	13),
(983,	3,	'2022-02-12 16:45:01',	'',	29),
(984,	3,	'2022-02-13 20:07:18',	'',	31),
(985,	3,	'2022-02-14 20:25:13',	'',	23),
(986,	3,	'2022-02-16 01:29:21',	'',	15),
(987,	3,	'2022-02-17 04:12:59',	'',	22),
(988,	3,	'2022-02-18 05:22:20',	'',	7),
(989,	3,	'2022-02-19 09:37:07',	'',	13),
(990,	3,	'2022-02-20 18:49:23',	'',	9),
(991,	3,	'2022-02-21 20:06:11',	'',	24),
(992,	3,	'2022-02-22 23:09:29',	'',	9),
(993,	3,	'2022-02-24 00:05:05',	'',	15),
(994,	3,	'2022-02-25 01:47:04',	'',	12),
(995,	3,	'2022-02-26 09:24:00',	'',	13),
(996,	3,	'2022-02-27 09:55:30',	'',	10),
(997,	3,	'2022-02-28 10:07:19',	'',	13),
(998,	3,	'2022-03-01 11:10:20',	'',	21),
(999,	3,	'2022-03-02 16:10:16',	'',	11),
(1000,	3,	'2022-03-03 16:19:21',	'',	21),
(1001,	3,	'2022-03-04 19:49:19',	'',	14),
(1002,	3,	'2022-03-05 20:09:16',	'',	14),
(1003,	3,	'2022-03-06 21:18:20',	'',	10),
(1004,	3,	'2022-03-07 22:14:24',	'',	14),
(1005,	3,	'2022-03-09 05:37:52',	'',	19),
(1006,	3,	'2022-03-10 05:52:23',	'',	25),
(1007,	3,	'2022-03-11 06:30:11',	'',	20),
(1008,	3,	'2022-03-12 06:34:18',	'',	17),
(1009,	3,	'2022-03-13 08:46:55',	'',	9),
(1010,	3,	'2022-03-14 09:47:06',	'',	15),
(1011,	3,	'2022-03-15 10:41:19',	'',	16),
(1012,	3,	'2022-03-16 12:56:37',	'',	14),
(1013,	3,	'2022-03-17 17:30:14',	'',	16),
(1014,	3,	'2022-03-18 18:12:55',	'',	11),
(1015,	3,	'2022-03-19 18:43:23',	'',	7),
(1016,	3,	'2022-03-20 22:57:11',	'',	10),
(1017,	3,	'2022-03-22 00:11:01',	'',	6),
(1018,	3,	'2022-03-23 00:18:18',	'',	22),
(1019,	3,	'2022-03-24 07:27:44',	'',	17),
(1020,	3,	'2022-03-25 09:01:23',	'',	23),
(1021,	3,	'2022-03-26 10:18:34',	'',	21),
(1022,	3,	'2022-03-27 11:29:28',	'',	30),
(1023,	3,	'2022-03-28 12:04:23',	'',	19),
(1024,	3,	'2022-03-29 14:30:48',	'',	9),
(1025,	3,	'2022-03-30 15:50:53',	'',	11),
(1026,	3,	'2022-03-31 16:36:04',	'',	10),
(1027,	3,	'2022-04-01 16:48:39',	'',	10),
(1028,	3,	'2022-04-02 19:47:56',	'',	13),
(1029,	3,	'2022-04-03 19:58:36',	'',	12),
(1030,	3,	'2022-04-04 21:05:19',	'',	13),
(1031,	3,	'2022-04-05 21:34:24',	'',	6),
(1032,	3,	'2022-04-06 22:08:57',	'',	9),
(1033,	3,	'2022-04-07 22:34:11',	'',	10),
(1034,	3,	'2022-04-08 23:50:17',	'',	12),
(1035,	3,	'2022-04-10 02:13:12',	'',	19),
(1036,	3,	'2022-04-11 05:13:08',	'',	29),
(1037,	3,	'2022-04-12 07:08:50',	'',	13),
(1038,	3,	'2022-04-13 07:47:45',	'',	14),
(1039,	3,	'2022-04-14 09:48:13',	'',	6),
(1040,	3,	'2022-04-15 20:07:15',	'',	18),
(1041,	3,	'2022-04-17 05:28:22',	'',	20),
(1042,	3,	'2022-04-18 09:59:36',	'',	15),
(1043,	3,	'2022-04-19 10:00:12',	'',	18),
(1044,	3,	'2022-04-20 10:17:31',	'',	23),
(1045,	3,	'2022-04-21 10:32:35',	'',	17),
(1046,	3,	'2022-04-22 11:51:40',	'',	10),
(1047,	3,	'2022-04-23 11:51:46',	'',	13),
(1048,	3,	'2022-04-24 14:27:00',	'',	10),
(1049,	3,	'2022-04-25 16:40:24',	'',	21),
(1050,	3,	'2022-04-26 18:44:50',	'',	15),
(1051,	3,	'2022-04-27 19:15:22',	'',	24),
(1052,	3,	'2022-04-28 23:01:53',	'',	14),
(1053,	3,	'2022-04-30 02:08:56',	'',	19),
(1054,	3,	'2022-05-01 02:22:03',	'',	25),
(1055,	3,	'2022-05-02 02:49:11',	'',	22),
(1056,	3,	'2022-05-03 07:14:28',	'',	24),
(1057,	3,	'2022-05-04 08:03:32',	'',	19),
(1058,	3,	'2022-05-05 08:13:10',	'',	14),
(1059,	3,	'2022-05-06 09:38:38',	'',	21),
(1060,	3,	'2022-05-07 11:12:21',	'',	20),
(1061,	3,	'2022-05-08 12:41:41',	'',	15),
(1062,	3,	'2022-05-09 13:07:56',	'',	19),
(1063,	3,	'2022-05-10 13:09:53',	'',	17),
(1064,	3,	'2022-05-11 13:51:44',	'',	16),
(1065,	3,	'2022-05-12 14:56:27',	'',	12),
(1066,	3,	'2022-05-13 15:44:17',	'',	12),
(1067,	3,	'2022-05-14 18:37:47',	'',	18),
(1068,	3,	'2022-05-15 20:36:47',	'',	16),
(1069,	3,	'2022-05-16 21:15:05',	'',	19),
(1070,	3,	'2022-05-18 00:14:14',	'',	10),
(1071,	3,	'2022-05-19 01:16:34',	'',	16),
(1072,	3,	'2022-05-20 01:26:42',	'',	18),
(1073,	3,	'2022-05-21 04:37:02',	'',	24),
(1074,	3,	'2022-05-22 05:03:40',	'',	11),
(1075,	3,	'2022-05-23 05:46:53',	'',	20),
(1076,	3,	'2022-05-24 06:38:13',	'',	28),
(1077,	3,	'2022-05-25 06:38:47',	'',	31),
(1078,	3,	'2022-05-26 07:05:12',	'',	31),
(1079,	3,	'2022-05-27 07:39:54',	'',	35),
(1080,	3,	'2022-05-28 08:26:15',	'',	26),
(1081,	3,	'2022-05-29 08:34:37',	'',	23),
(1082,	3,	'2022-05-30 09:20:22',	'',	29),
(1083,	3,	'2022-05-31 09:41:27',	'',	19),
(1084,	3,	'2022-06-01 10:41:48',	'',	22),
(1085,	3,	'2022-06-02 11:20:38',	'',	16),
(1086,	3,	'2022-06-03 20:46:51',	'',	13),
(1087,	3,	'2022-06-04 20:51:19',	'',	19),
(1088,	3,	'2022-06-05 23:34:10',	'',	16),
(1089,	3,	'2022-06-06 23:39:20',	'',	32),
(1090,	3,	'2022-06-08 00:19:35',	'',	21),
(1091,	3,	'2022-06-09 02:26:40',	'',	29),
(1092,	3,	'2022-06-10 03:42:09',	'',	15),
(1093,	3,	'2022-06-11 04:51:47',	'',	17),
(1094,	3,	'2022-06-12 04:56:29',	'',	12),
(1095,	3,	'2022-06-13 06:17:06',	'',	18),
(1096,	3,	'2022-06-14 06:25:17',	'',	26),
(1097,	3,	'2022-06-15 06:37:25',	'',	16),
(1098,	3,	'2022-06-16 06:38:37',	'',	30),
(1099,	3,	'2022-06-17 07:52:20',	'',	14),
(1100,	3,	'2022-06-18 09:43:52',	'',	15),
(1101,	3,	'2022-06-19 12:42:09',	'',	26),
(1102,	3,	'2022-06-20 15:20:51',	'',	26),
(1103,	3,	'2022-06-21 17:51:07',	'',	20),
(1104,	3,	'2022-06-22 18:06:53',	'',	26),
(1105,	3,	'2022-06-23 18:17:57',	'',	15),
(1106,	3,	'2022-06-24 19:42:48',	'',	20),
(1107,	3,	'2022-06-25 20:18:09',	'',	7),
(1108,	3,	'2022-06-26 23:46:04',	'',	22),
(1109,	3,	'2022-06-27 23:57:14',	'',	30),
(1110,	3,	'2022-06-29 00:45:49',	'',	13),
(1111,	3,	'2022-06-30 11:08:18',	'',	12),
(1112,	3,	'2022-07-01 11:20:51',	'',	16),
(1113,	3,	'2022-07-02 11:49:42',	'',	8),
(1114,	3,	'2022-07-03 13:43:59',	'',	24),
(1115,	3,	'2022-07-04 15:02:15',	'',	28),
(1116,	3,	'2022-07-05 15:51:50',	'',	13),
(1117,	3,	'2022-07-06 17:00:39',	'',	19),
(1118,	3,	'2022-07-07 17:45:58',	'',	25),
(1119,	3,	'2022-07-08 20:08:00',	'',	16),
(1120,	3,	'2022-07-09 21:06:17',	'',	18),
(1121,	3,	'2022-07-10 21:50:23',	'',	17),
(1122,	3,	'2022-07-11 22:36:13',	'',	33),
(1123,	3,	'2022-07-13 00:23:18',	'',	18),
(1124,	3,	'2022-07-14 00:37:54',	'',	26),
(1125,	3,	'2022-07-15 01:23:28',	'',	17),
(1126,	3,	'2022-07-16 02:19:59',	'',	18),
(1127,	3,	'2022-07-17 03:00:18',	'',	27),
(1128,	3,	'2022-07-18 03:56:23',	'',	21),
(1129,	3,	'2022-07-19 04:46:05',	'',	65),
(1130,	3,	'2022-07-20 06:08:40',	'',	21),
(1131,	3,	'2022-07-21 08:28:21',	'',	24),
(1132,	3,	'2022-07-22 10:02:28',	'',	12),
(1133,	3,	'2022-07-23 10:32:12',	'',	18),
(1134,	3,	'2022-07-24 12:52:56',	'',	19),
(1135,	3,	'2022-07-25 15:16:36',	'',	21),
(1136,	3,	'2022-07-26 15:58:50',	'',	15),
(1137,	3,	'2022-07-27 16:32:05',	'',	17),
(1138,	3,	'2022-07-28 18:16:04',	'',	22),
(1139,	3,	'2022-07-29 18:22:38',	'',	27),
(1140,	3,	'2022-07-30 19:06:04',	'',	21),
(1141,	3,	'2022-07-31 19:55:50',	'',	19),
(1142,	3,	'2022-08-01 20:22:42',	'',	22),
(1143,	3,	'2022-08-02 20:48:57',	'',	29),
(1144,	3,	'2022-08-03 21:19:26',	'',	31),
(1145,	3,	'2022-08-04 21:32:59',	'',	17),
(1146,	3,	'2022-08-05 21:53:32',	'',	22),
(1147,	3,	'2022-08-06 23:42:42',	'',	20),
(1148,	3,	'2022-08-08 00:13:46',	'',	19),
(1149,	3,	'2022-08-09 00:29:24',	'',	26),
(1150,	3,	'2022-08-10 00:51:50',	'',	22),
(1151,	3,	'2022-08-11 01:27:19',	'',	11),
(1152,	3,	'2022-08-12 01:30:06',	'',	4),
(1153,	3,	'2022-08-13 02:50:21',	'',	15),
(1154,	3,	'2022-08-14 12:52:07',	'',	16),
(1155,	3,	'2022-08-15 13:37:35',	'',	19),
(1156,	3,	'2022-08-16 14:16:19',	'',	16),
(1157,	3,	'2022-08-17 14:35:32',	'',	22),
(1158,	3,	'2022-08-18 15:05:46',	'',	25),
(1159,	3,	'2022-08-19 15:20:52',	'',	26),
(1160,	3,	'2022-08-20 16:52:12',	'',	20),
(1161,	3,	'2022-08-21 17:03:50',	'',	17),
(1162,	3,	'2022-08-22 18:00:24',	'',	19),
(1163,	3,	'2022-08-23 19:44:38',	'',	33),
(1164,	3,	'2022-08-25 04:13:10',	'',	15),
(1165,	3,	'2022-08-26 05:24:02',	'',	21),
(1166,	3,	'2022-08-27 08:36:40',	'',	13),
(1167,	3,	'2022-08-28 10:00:01',	'',	20),
(1168,	3,	'2022-08-29 10:13:02',	'',	26),
(1169,	3,	'2022-08-30 10:38:43',	'',	32),
(1170,	3,	'2022-08-31 14:39:27',	'',	12),
(1171,	3,	'2022-09-01 15:36:25',	'',	19),
(1172,	3,	'2022-09-02 16:05:50',	'',	19),
(1173,	3,	'2022-09-03 16:29:36',	'',	19),
(1174,	3,	'2022-09-04 16:33:04',	'',	33),
(1175,	3,	'2022-09-05 16:59:38',	'',	33),
(1176,	3,	'2022-09-06 19:10:12',	'',	16),
(1177,	3,	'2022-09-07 19:50:51',	'',	21),
(1178,	3,	'2022-09-08 20:22:26',	'',	19),
(1179,	3,	'2022-09-09 21:24:05',	'',	23),
(1180,	3,	'2022-09-10 21:47:42',	'',	22),
(1181,	3,	'2022-09-11 22:31:05',	'',	22),
(1182,	3,	'2022-09-12 22:43:53',	'',	45),
(1183,	3,	'2022-09-13 23:19:01',	'',	26),
(1184,	3,	'2022-09-14 23:43:49',	'',	19),
(1185,	3,	'2022-09-16 00:21:47',	'',	16),
(1186,	3,	'2022-09-17 00:38:19',	'',	20),
(1187,	3,	'2022-09-18 00:54:46',	'',	21),
(1188,	3,	'2022-09-19 01:08:29',	'',	24),
(1189,	3,	'2022-09-20 02:04:32',	'',	28),
(1190,	3,	'2022-09-21 02:18:16',	'',	27),
(1191,	3,	'2022-09-22 02:34:35',	'',	19),
(1192,	3,	'2022-09-23 02:38:55',	'',	18),
(1193,	3,	'2022-09-24 03:24:18',	'',	24),
(1194,	3,	'2022-09-25 03:39:50',	'',	33),
(1195,	3,	'2022-09-26 04:39:18',	'',	33),
(1196,	3,	'2022-09-27 05:01:50',	'',	57),
(1197,	3,	'2022-09-28 06:54:59',	'',	9),
(1198,	3,	'2022-09-29 07:38:53',	'',	16),
(1199,	3,	'2022-09-30 17:46:27',	'',	10),
(1200,	3,	'2022-10-01 22:03:10',	'',	5),
(1201,	3,	'2022-10-02 23:21:59',	'',	15),
(1202,	3,	'2022-10-04 00:50:40',	'',	10),
(1203,	3,	'2022-10-05 01:32:32',	'',	18),
(1204,	3,	'2022-10-06 02:37:02',	'',	14),
(1205,	3,	'2022-10-07 03:39:22',	'',	6),
(1206,	3,	'2022-10-08 05:47:04',	'',	7),
(1207,	3,	'2022-10-09 06:23:20',	'',	14),
(1208,	3,	'2022-10-10 09:36:29',	'',	14),
(1209,	3,	'2022-10-11 10:14:00',	'',	14),
(1210,	3,	'2022-10-12 21:36:03',	'',	17),
(1211,	3,	'2022-10-13 22:08:23',	'',	16),
(1212,	3,	'2022-10-14 22:50:58',	'',	10),
(1213,	3,	'2022-10-15 23:58:32',	'',	16),
(1214,	3,	'2022-10-17 05:31:59',	'',	15),
(1215,	3,	'2022-10-18 07:24:24',	'',	19),
(1216,	3,	'2022-10-19 11:21:48',	'',	13),
(1217,	3,	'2022-10-20 13:46:50',	'',	7),
(1218,	3,	'2022-10-21 16:14:48',	'',	14),
(1219,	3,	'2022-10-22 16:45:27',	'',	10),
(1220,	3,	'2022-10-23 17:15:46',	'',	14),
(1221,	3,	'2022-10-24 18:29:29',	'',	29),
(1222,	3,	'2022-10-25 18:36:42',	'',	23),
(1223,	3,	'2022-10-26 19:59:35',	'',	19),
(1224,	3,	'2022-10-27 20:40:51',	'',	16),
(1225,	3,	'2022-10-28 21:02:07',	'',	12),
(1226,	3,	'2022-10-29 22:50:40',	'',	9),
(1227,	3,	'2022-10-30 23:22:19',	'',	16),
(1228,	3,	'2022-11-01 00:02:12',	'',	22),
(1229,	3,	'2022-11-02 00:08:14',	'',	21),
(1230,	3,	'2022-11-03 03:07:00',	'',	15),
(1231,	3,	'2022-11-04 04:24:03',	'',	19),
(1232,	3,	'2022-11-05 04:31:06',	'',	16),
(1233,	3,	'2022-11-06 06:46:42',	'',	19),
(1234,	3,	'2022-11-07 09:35:05',	'',	8),
(1235,	3,	'2022-11-08 10:31:57',	'',	25),
(1236,	3,	'2022-11-09 10:48:08',	'',	13),
(1237,	3,	'2022-11-10 12:54:07',	'',	21),
(1238,	3,	'2022-11-11 13:18:26',	'',	16),
(1239,	3,	'2022-11-12 20:30:13',	'',	14),
(1240,	3,	'2022-11-14 04:55:49',	'',	16),
(1241,	3,	'2022-11-15 06:08:25',	'',	16),
(1242,	3,	'2022-11-16 07:20:25',	'',	13),
(1243,	3,	'2022-11-17 07:26:18',	'',	14),
(1244,	3,	'2022-11-18 10:52:30',	'',	26),
(1245,	3,	'2022-11-19 11:30:52',	'',	18),
(1246,	3,	'2022-11-20 11:42:59',	'',	14),
(1247,	3,	'2022-11-21 17:58:36',	'',	27),
(1248,	3,	'2022-11-22 18:48:09',	'',	13),
(1249,	3,	'2022-11-23 19:20:22',	'',	25),
(1250,	3,	'2022-11-24 23:48:49',	'',	17),
(1251,	3,	'2022-11-26 01:36:06',	'',	13),
(1252,	3,	'2022-11-27 04:54:55',	'',	16),
(1253,	3,	'2022-11-28 07:56:50',	'',	17),
(1254,	3,	'2022-11-29 13:36:49',	'',	17),
(1255,	3,	'2022-11-30 14:11:58',	'',	15),
(1256,	3,	'2022-12-01 14:43:41',	'',	12),
(1257,	3,	'2022-12-02 17:03:22',	'',	12),
(1258,	3,	'2022-12-03 18:38:12',	'',	24),
(1259,	3,	'2022-12-04 20:04:30',	'',	20),
(1260,	3,	'2022-12-05 20:47:32',	'',	14),
(1261,	3,	'2022-12-06 20:53:37',	'',	29),
(1262,	3,	'2022-12-07 21:28:23',	'',	20),
(1263,	3,	'2022-12-09 05:29:53',	'',	12),
(1264,	3,	'2022-12-10 05:37:58',	'',	27),
(1265,	3,	'2022-12-11 05:51:27',	'',	23),
(1266,	3,	'2022-12-12 08:25:02',	'',	21),
(1267,	3,	'2022-12-13 08:54:55',	'',	13),
(1268,	3,	'2022-12-14 15:09:49',	'',	20),
(1269,	3,	'2022-12-15 20:39:23',	'',	15),
(1270,	3,	'2022-12-16 22:58:02',	'',	20),
(1271,	3,	'2022-12-17 23:51:37',	'',	19),
(1272,	3,	'2022-12-18 23:55:42',	'',	23),
(1273,	3,	'2022-12-20 00:31:35',	'',	16),
(1274,	3,	'2022-12-21 03:59:25',	'',	15),
(1275,	3,	'2022-12-22 04:05:59',	'',	18),
(1276,	3,	'2022-12-23 14:36:08',	'',	22),
(1277,	3,	'2022-12-24 20:22:28',	'',	19),
(1278,	3,	'2022-12-25 23:43:44',	'',	16),
(1279,	3,	'2022-12-27 01:11:10',	'',	20),
(1280,	3,	'2022-12-28 01:15:13',	'',	10),
(1281,	3,	'2022-12-29 06:42:45',	'',	17),
(1282,	3,	'2022-12-30 07:31:44',	'',	23),
(1283,	3,	'2022-12-31 11:38:42',	'',	19),
(1284,	3,	'2023-01-01 12:06:39',	'',	13),
(1285,	3,	'2023-01-02 13:34:00',	'',	24),
(1286,	3,	'2023-01-03 15:10:56',	'',	16),
(1287,	3,	'2023-01-04 16:00:00',	'',	22),
(1288,	3,	'2023-01-05 19:37:10',	'',	27),
(1289,	3,	'2023-01-06 20:30:07',	'',	24),
(1290,	3,	'2023-01-07 20:31:55',	'',	18),
(1291,	3,	'2023-01-08 21:14:07',	'',	31),
(1292,	3,	'2023-01-10 01:01:54',	'',	26),
(1293,	3,	'2023-01-11 01:04:15',	'',	25),
(1294,	3,	'2023-01-12 01:23:34',	'',	31),
(1295,	3,	'2023-01-13 01:40:55',	'',	29),
(1296,	3,	'2023-01-14 03:09:44',	'',	34),
(1297,	3,	'2023-01-15 03:19:09',	'',	22),
(1298,	3,	'2023-01-16 03:34:42',	'',	20),
(1299,	3,	'2023-01-17 03:38:11',	'',	27),
(1300,	3,	'2023-01-18 08:45:29',	'',	26),
(1301,	3,	'2023-01-19 09:30:38',	'',	38),
(1302,	3,	'2023-01-20 10:13:41',	'',	30),
(1303,	3,	'2023-01-21 12:31:48',	'',	24),
(1304,	3,	'2023-01-22 13:46:33',	'',	25),
(1305,	3,	'2023-01-23 13:54:14',	'',	35),
(1306,	3,	'2023-01-24 15:16:18',	'',	30),
(1307,	3,	'2023-01-25 17:34:46',	'',	24),
(1308,	3,	'2023-01-26 18:41:46',	'',	18),
(1309,	3,	'2023-01-27 21:38:09',	'',	30),
(1310,	3,	'2023-01-28 22:49:15',	'',	21),
(1311,	3,	'2023-01-29 23:07:37',	'',	26),
(1312,	3,	'2023-01-31 00:02:30',	'',	28),
(1313,	3,	'2023-02-01 00:42:30',	'',	19),
(1314,	3,	'2023-02-02 01:39:32',	'',	35),
(1315,	3,	'2023-02-03 03:53:59',	'',	25),
(1316,	3,	'2023-02-04 04:43:22',	'',	23),
(1317,	3,	'2023-02-05 05:54:39',	'',	30),
(1318,	3,	'2023-02-06 06:37:26',	'',	32),
(1319,	3,	'2023-02-07 09:06:08',	'',	25),
(1320,	3,	'2023-02-08 09:36:16',	'',	30),
(1321,	3,	'2023-02-09 15:17:28',	'',	25),
(1322,	3,	'2023-02-10 17:02:19',	'',	18),
(1323,	3,	'2023-02-11 18:12:36',	'',	14),
(1324,	3,	'2023-02-12 21:21:16',	'',	19),
(1325,	3,	'2023-02-13 21:35:17',	'',	20),
(1326,	3,	'2023-02-15 00:46:10',	'',	35),
(1327,	3,	'2023-02-16 02:36:48',	'',	25),
(1328,	3,	'2023-02-17 02:54:21',	'',	20),
(1329,	3,	'2023-02-18 05:37:37',	'',	24),
(1330,	3,	'2023-02-19 07:19:44',	'',	25),
(1331,	3,	'2023-02-20 07:56:23',	'',	20),
(1332,	3,	'2023-02-21 10:11:59',	'',	6),
(1333,	3,	'2023-02-22 12:39:42',	'',	11),
(1334,	3,	'2023-02-23 12:56:41',	'',	23),
(1335,	3,	'2023-02-24 12:58:03',	'',	18),
(1336,	3,	'2023-02-25 16:14:48',	'',	23),
(1337,	3,	'2023-02-26 16:21:36',	'',	24),
(1338,	3,	'2023-02-27 17:18:13',	'',	25),
(1339,	3,	'2023-02-28 18:51:19',	'',	26),
(1340,	3,	'2023-03-01 20:59:52',	'',	14),
(1341,	3,	'2023-03-03 00:46:02',	'',	17),
(1342,	3,	'2023-03-04 01:01:42',	'',	25),
(1343,	3,	'2023-03-05 01:33:29',	'',	21),
(1344,	3,	'2023-03-06 03:10:01',	'',	17),
(1345,	3,	'2023-03-07 07:06:32',	'',	20),
(1346,	3,	'2023-03-08 07:19:36',	'',	20),
(1347,	3,	'2023-03-09 09:43:51',	'',	43),
(1348,	3,	'2023-03-10 09:56:58',	'',	27),
(1349,	3,	'2023-03-11 11:27:40',	'',	30),
(1350,	3,	'2023-03-12 11:46:43',	'',	19),
(1351,	3,	'2023-03-13 11:46:48',	'',	26),
(1352,	3,	'2023-03-14 13:16:27',	'',	24),
(1353,	3,	'2023-03-15 14:14:27',	'',	21),
(1354,	3,	'2023-03-16 14:58:50',	'',	27),
(1355,	3,	'2023-03-17 16:08:03',	'',	16),
(1356,	3,	'2023-03-18 16:47:42',	'',	30),
(1357,	3,	'2023-03-19 16:53:54',	'',	27),
(1358,	3,	'2023-03-20 17:35:57',	'',	16),
(1359,	3,	'2023-03-21 18:03:00',	'',	24),
(1360,	3,	'2023-03-22 18:45:05',	'',	32),
(1361,	3,	'2023-03-23 21:18:07',	'',	18),
(1362,	3,	'2023-03-24 23:09:44',	'',	16),
(1363,	3,	'2023-03-26 01:01:25',	'',	21),
(1364,	3,	'2023-03-27 03:12:23',	'',	14),
(1365,	3,	'2023-03-28 03:24:04',	'',	15),
(1366,	3,	'2023-03-29 04:26:51',	'',	22),
(1367,	3,	'2023-03-30 04:33:47',	'',	14),
(1368,	3,	'2023-03-31 06:37:26',	'',	15),
(1369,	3,	'2023-04-01 11:39:40',	'',	13),
(1370,	3,	'2023-04-02 14:01:43',	'',	21),
(1371,	3,	'2023-04-03 17:51:02',	'',	15),
(1372,	3,	'2023-04-04 21:02:09',	'',	20),
(1373,	3,	'2023-04-05 21:22:37',	'',	23),
(1374,	3,	'2023-04-06 21:26:59',	'',	26),
(1375,	3,	'2023-04-07 22:17:08',	'',	19),
(1376,	3,	'2023-04-08 23:03:57',	'',	15),
(1377,	3,	'2023-04-09 23:15:01',	'',	24),
(1378,	3,	'2023-04-11 00:25:00',	'',	25),
(1379,	3,	'2023-04-12 05:16:13',	'',	15),
(1380,	3,	'2023-04-13 05:55:39',	'',	27),
(1381,	3,	'2023-04-14 09:03:54',	'',	12),
(1382,	3,	'2023-04-15 10:11:16',	'',	22),
(1383,	3,	'2023-04-16 11:15:30',	'',	20),
(1384,	3,	'2023-04-17 14:22:03',	'',	26),
(1385,	3,	'2023-04-18 16:07:51',	'',	35),
(1386,	3,	'2023-04-19 16:52:14',	'',	23),
(1387,	3,	'2023-04-20 17:14:49',	'',	20),
(1388,	3,	'2023-04-21 19:02:26',	'',	25),
(1389,	3,	'2023-04-22 20:44:03',	'',	16),
(1390,	3,	'2023-04-23 23:09:21',	'',	26),
(1391,	3,	'2023-04-24 23:21:31',	'',	19),
(1392,	3,	'2023-04-25 23:44:53',	'',	3),
(1393,	3,	'2023-05-04 00:25:17',	'',	23),
(1394,	3,	'2023-05-05 00:41:10',	'',	11),
(1395,	3,	'2023-05-06 00:41:31',	'',	28),
(1396,	3,	'2023-05-07 00:53:58',	'',	20),
(1397,	3,	'2023-05-08 01:08:14',	'',	23),
(1398,	3,	'2023-05-09 01:26:22',	'',	23),
(1399,	3,	'2023-05-10 02:13:53',	'',	18),
(1400,	3,	'2023-05-11 03:05:02',	'',	16),
(1401,	3,	'2023-05-12 05:13:26',	'',	13),
(1402,	3,	'2023-05-13 05:39:11',	'',	20),
(1403,	3,	'2023-05-14 06:05:10',	'',	16),
(1404,	3,	'2023-05-15 06:18:08',	'',	31),
(1405,	3,	'2023-05-16 07:51:27',	'',	25),
(1406,	3,	'2023-05-17 09:09:18',	'',	20),
(1407,	3,	'2023-05-18 10:05:44',	'',	28),
(1408,	3,	'2023-05-19 11:54:09',	'',	13),
(1409,	3,	'2023-05-20 17:07:20',	'',	12),
(1410,	3,	'2023-05-21 17:14:32',	'',	22),
(1411,	3,	'2023-05-22 18:38:59',	'',	32),
(1412,	3,	'2023-05-23 21:47:45',	'',	11),
(1413,	3,	'2023-05-25 03:04:28',	'',	17),
(1414,	3,	'2023-05-26 05:10:33',	'',	16),
(1415,	3,	'2023-05-27 10:29:58',	'',	5),
(1416,	3,	'2023-05-28 19:36:27',	'',	18),
(1417,	3,	'2023-05-29 22:10:34',	'',	20),
(1418,	3,	'2023-05-30 22:33:42',	'',	17),
(1419,	3,	'2023-06-01 00:00:46',	'',	10),
(1420,	3,	'2023-06-02 01:39:15',	'',	9),
(1421,	3,	'2023-06-03 02:27:29',	'',	19),
(1422,	3,	'2023-06-04 04:28:10',	'',	17),
(1423,	3,	'2023-06-05 07:07:12',	'',	17),
(1424,	3,	'2023-06-06 09:02:53',	'',	15),
(1425,	3,	'2023-06-07 11:41:24',	'',	15),
(1426,	3,	'2023-06-08 12:08:23',	'',	20),
(1427,	3,	'2023-06-09 13:23:52',	'',	18),
(1428,	3,	'2023-06-10 15:45:53',	'',	16),
(1429,	3,	'2023-06-11 16:03:23',	'',	9),
(1430,	3,	'2023-06-12 16:05:15',	'',	25),
(1431,	3,	'2023-06-13 16:09:50',	'',	23),
(1432,	3,	'2023-06-14 16:53:32',	'',	22),
(1433,	3,	'2023-06-15 18:56:39',	'',	25),
(1434,	3,	'2023-06-16 19:28:10',	'',	13),
(1435,	3,	'2023-06-17 21:03:23',	'',	26),
(1436,	3,	'2023-06-18 22:52:01',	'',	12),
(1437,	3,	'2023-06-19 23:32:54',	'',	19),
(1438,	3,	'2023-06-21 03:48:15',	'',	13),
(1439,	3,	'2023-06-22 06:09:43',	'',	14),
(1440,	3,	'2023-06-23 08:42:52',	'',	24),
(1441,	3,	'2023-06-24 11:11:50',	'',	11),
(1442,	3,	'2023-06-25 12:57:42',	'',	9),
(1443,	3,	'2023-06-26 17:51:13',	'',	13),
(1444,	3,	'2023-06-27 17:51:16',	'',	19),
(1445,	3,	'2023-06-29 02:22:13',	'',	20),
(1446,	3,	'2023-06-30 02:29:59',	'',	20),
(1447,	3,	'2023-07-01 02:58:33',	'',	16),
(1448,	3,	'2023-07-02 03:32:12',	'',	24),
(1449,	3,	'2023-07-03 03:37:08',	'',	16),
(1450,	3,	'2023-07-04 07:38:30',	'',	31),
(1451,	3,	'2023-07-05 08:09:12',	'',	23),
(1452,	3,	'2023-07-06 10:28:45',	'',	18),
(1453,	3,	'2023-07-07 10:29:42',	'',	20),
(1454,	3,	'2023-07-08 14:54:01',	'',	21),
(1455,	3,	'2023-07-09 16:10:57',	'',	9),
(1456,	3,	'2023-07-10 18:01:55',	'',	20),
(1457,	3,	'2023-07-11 18:32:01',	'',	15),
(1458,	3,	'2023-07-12 18:44:22',	'',	26),
(1459,	3,	'2023-07-13 20:05:27',	'',	19),
(1460,	3,	'2023-07-14 21:49:09',	'',	21),
(1461,	3,	'2023-07-15 22:12:58',	'',	24),
(1462,	3,	'2023-07-16 22:21:48',	'',	20),
(1463,	3,	'2023-07-18 00:14:54',	'',	21),
(1464,	3,	'2023-07-19 00:33:58',	'',	18),
(1465,	3,	'2023-07-20 00:43:33',	'',	24),
(1466,	3,	'2023-07-21 00:50:09',	'',	17),
(1467,	3,	'2023-07-22 01:03:41',	'',	18),
(1468,	3,	'2023-07-23 01:52:35',	'',	10),
(1469,	3,	'2023-07-24 03:31:54',	'',	21),
(1470,	3,	'2023-07-25 08:57:02',	'',	22),
(1471,	3,	'2023-07-26 10:10:23',	'',	30),
(1472,	3,	'2023-07-27 14:46:30',	'',	27),
(1473,	3,	'2023-07-28 15:17:43',	'',	28),
(1474,	3,	'2023-07-29 15:53:53',	'',	19),
(1475,	3,	'2023-07-30 16:15:17',	'',	22),
(1476,	3,	'2023-07-31 22:31:38',	'',	17),
(1477,	3,	'2023-08-01 22:39:57',	'',	17),
(1478,	3,	'2023-08-02 23:05:03',	'',	13),
(1479,	3,	'2023-08-04 02:02:16',	'',	19),
(1480,	3,	'2023-08-05 02:51:54',	'',	22),
(1481,	3,	'2023-08-06 04:06:09',	'',	10),
(1482,	3,	'2023-08-07 05:41:11',	'',	8),
(1483,	3,	'2023-08-08 05:56:06',	'',	25),
(1484,	3,	'2023-08-09 06:07:22',	'',	23),
(1485,	3,	'2023-08-10 06:40:12',	'',	16),
(1486,	3,	'2023-08-11 08:19:04',	'',	21),
(1487,	3,	'2023-08-12 11:17:26',	'',	29),
(1488,	3,	'2023-08-13 13:15:23',	'',	20),
(1489,	3,	'2023-08-14 13:50:44',	'',	29),
(1490,	3,	'2023-08-15 14:13:07',	'',	17),
(1491,	3,	'2023-08-16 14:13:47',	'',	18),
(1492,	3,	'2023-08-17 14:50:42',	'',	10),
(1493,	3,	'2023-08-18 17:17:24',	'',	25),
(1494,	3,	'2023-08-19 19:08:19',	'',	16),
(1495,	3,	'2023-08-20 19:49:49',	'',	20),
(1496,	3,	'2023-08-22 01:12:37',	'',	29),
(1497,	3,	'2023-08-23 04:08:38',	'',	24),
(1498,	3,	'2023-08-24 07:22:25',	'',	19),
(1499,	3,	'2023-08-25 07:30:50',	'',	13),
(1500,	3,	'2023-08-26 07:59:29',	'',	32),
(1501,	3,	'2023-08-27 10:33:58',	'',	10),
(1502,	3,	'2023-08-28 13:06:46',	'',	11),
(1503,	3,	'2023-08-29 14:16:32',	'',	21),
(1504,	3,	'2023-08-30 14:54:56',	'',	17),
(1505,	3,	'2023-08-31 16:54:54',	'',	22),
(1506,	3,	'2023-09-01 19:17:15',	'',	20),
(1507,	3,	'2023-09-02 20:16:13',	'',	18),
(1508,	3,	'2023-09-03 20:34:48',	'',	14),
(1509,	3,	'2023-09-04 23:40:56',	'',	24),
(1510,	3,	'2023-09-06 02:23:38',	'',	13),
(1511,	3,	'2023-09-07 03:23:11',	'',	21),
(1512,	3,	'2023-09-08 06:05:07',	'',	17),
(1513,	3,	'2023-09-09 06:21:00',	'',	11),
(1514,	3,	'2023-09-10 07:04:02',	'',	17),
(1515,	3,	'2023-09-11 10:00:40',	'',	17),
(1516,	3,	'2023-09-12 11:48:17',	'',	11),
(1517,	3,	'2023-09-13 13:50:24',	'',	26),
(1518,	3,	'2023-09-14 15:17:40',	'',	19),
(1519,	3,	'2023-09-15 20:41:38',	'',	17),
(1520,	3,	'2023-09-17 04:58:01',	'',	24),
(1521,	3,	'2023-09-18 06:36:25',	'',	21),
(1522,	3,	'2023-09-19 08:36:39',	'',	21),
(1523,	3,	'2023-09-20 13:39:04',	'',	22),
(1524,	3,	'2023-09-21 14:33:15',	'',	27),
(1525,	3,	'2023-09-22 14:51:38',	'',	32),
(1526,	3,	'2023-09-23 16:45:53',	'',	18),
(1527,	3,	'2023-09-24 16:55:50',	'',	10),
(1528,	3,	'2023-09-25 16:57:51',	'',	16),
(1529,	3,	'2023-09-26 17:12:38',	'',	17),
(1530,	3,	'2023-09-27 17:34:00',	'',	23),
(1531,	3,	'2023-09-28 19:46:21',	'',	23),
(1532,	3,	'2023-09-29 22:43:34',	'',	18),
(1533,	3,	'2023-10-01 00:06:17',	'',	17),
(1534,	3,	'2023-10-02 00:44:14',	'',	16),
(1535,	3,	'2023-10-03 01:04:05',	'',	19),
(1536,	3,	'2023-10-04 03:08:16',	'',	19),
(1537,	3,	'2023-10-05 07:00:29',	'',	29),
(1538,	3,	'2023-10-06 13:37:10',	'',	28),
(1539,	3,	'2023-10-07 14:21:01',	'',	14),
(1540,	3,	'2023-10-08 16:14:43',	'',	10),
(1541,	3,	'2023-10-10 02:06:47',	'',	14),
(1542,	3,	'2023-10-11 06:37:57',	'',	19),
(1543,	3,	'2023-10-12 06:45:50',	'',	25),
(1544,	3,	'2023-10-13 07:53:08',	'',	15),
(1545,	3,	'2023-10-14 07:59:01',	'',	23),
(1546,	3,	'2023-10-15 08:17:14',	'',	15),
(1547,	3,	'2023-10-16 09:14:25',	'',	28),
(1548,	3,	'2023-10-17 09:32:08',	'',	26),
(1549,	3,	'2023-10-18 10:30:53',	'',	15),
(1550,	3,	'2023-10-19 15:58:28',	'',	28),
(1551,	3,	'2023-10-20 16:35:33',	'',	16),
(1552,	3,	'2023-10-21 16:56:33',	'',	19),
(1553,	3,	'2023-10-22 20:21:44',	'',	37),
(1554,	3,	'2023-10-23 21:16:35',	'',	13),
(1555,	3,	'2023-10-24 23:46:45',	'',	28);

DROP TABLE IF EXISTS `wp_hjpl_cache`;
CREATE TABLE `wp_hjpl_cache` (
  `id` varchar(64) NOT NULL,
  `value` longtext NOT NULL,
  `expiration` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `wp_links`;
CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


DROP TABLE IF EXISTS `wp_options`;
CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(1,	'siteurl',	'https://graygroupla.com',	'yes'),
(2,	'home',	'https://graygroupla.com',	'yes'),
(3,	'blogname',	'Gray Group Real Estate - Los Angeles | Gray Group LA',	'yes'),
(4,	'blogdescription',	'Gray Group LA',	'yes'),
(5,	'users_can_register',	'0',	'yes'),
(6,	'admin_email',	'derek@covertagent.com',	'yes'),
(7,	'start_of_week',	'1',	'yes'),
(8,	'use_balanceTags',	'0',	'yes'),
(9,	'use_smilies',	'1',	'yes'),
(10,	'require_name_email',	'1',	'yes'),
(11,	'comments_notify',	'1',	'yes'),
(12,	'posts_per_rss',	'10',	'yes'),
(13,	'rss_use_excerpt',	'0',	'yes'),
(14,	'mailserver_url',	'mail.example.com',	'yes'),
(15,	'mailserver_login',	'login@example.com',	'yes'),
(16,	'mailserver_pass',	'password',	'yes'),
(17,	'mailserver_port',	'110',	'yes'),
(18,	'default_category',	'1',	'yes'),
(19,	'default_comment_status',	'closed',	'yes'),
(20,	'default_ping_status',	'closed',	'yes'),
(21,	'default_pingback_flag',	'',	'yes'),
(22,	'posts_per_page',	'10',	'yes'),
(23,	'date_format',	'F j, Y',	'yes'),
(24,	'time_format',	'g:i a',	'yes'),
(25,	'links_updated_date_format',	'F j, Y g:i a',	'yes'),
(26,	'comment_moderation',	'',	'yes'),
(27,	'moderation_notify',	'1',	'yes'),
(28,	'permalink_structure',	'/%postname%/',	'yes'),
(30,	'hack_file',	'0',	'yes'),
(31,	'blog_charset',	'UTF-8',	'yes'),
(32,	'moderation_keys',	'',	'no'),
(33,	'active_plugins',	'a:12:{i:0;s:34:\"cloudflare-flexible-ssl/plugin.php\";i:1;s:25:\"ca-members/Membership.php\";i:2;s:27:\"ca-drip-msg/ca-drip-msg.php\";i:4;s:19:\"ca-listings/rel.php\";i:5;s:33:\"classic-editor/classic-editor.php\";i:6;s:32:\"duplicate-page/duplicatepage.php\";i:7;s:56:\"ellipsis-human-presence-technology/wp-human-presence.php\";i:8;s:22:\"font-awesome/index.php\";i:9;s:29:\"gravityforms/gravityforms.php\";i:10;s:23:\"wordfence/wordfence.php\";i:12;s:53:\"wp-custom-taxonomy-image/wp-custom-taxonomy-image.php\";i:13;s:61:\"wp-reviews-plugin-for-google/wp-reviews-plugin-for-google.php\";}',	'yes'),
(34,	'category_base',	'',	'yes'),
(35,	'ping_sites',	'http://rpc.pingomatic.com/',	'yes'),
(36,	'comment_max_links',	'2',	'yes'),
(37,	'gmt_offset',	'0',	'yes'),
(38,	'default_email_category',	'1',	'yes'),
(39,	'recently_edited',	'a:3:{i:0;s:77:\"/var/www/wordpress/graygroupla/wp-content/plugins/ca-drip-msg/ca-drip-msg.php\";i:1;s:70:\"/var/www/wordpress/graygroupla/wp-content/themes/CovertAgent/style.css\";i:2;b:0;}',	'yes'),
(40,	'template',	'Divi',	'yes'),
(41,	'stylesheet',	'CovertAgent',	'yes'),
(44,	'comment_registration',	'1',	'yes'),
(45,	'html_type',	'text/html',	'yes'),
(46,	'use_trackback',	'0',	'yes'),
(47,	'default_role',	'subscriber',	'yes'),
(48,	'db_version',	'48748',	'yes'),
(49,	'uploads_use_yearmonth_folders',	'1',	'yes'),
(50,	'upload_path',	'',	'yes'),
(51,	'blog_public',	'1',	'yes'),
(52,	'default_link_category',	'2',	'yes'),
(53,	'show_on_front',	'page',	'yes'),
(54,	'tag_base',	'',	'yes'),
(55,	'show_avatars',	'1',	'yes'),
(56,	'avatar_rating',	'G',	'yes'),
(57,	'upload_url_path',	'',	'yes'),
(58,	'thumbnail_size_w',	'150',	'yes'),
(59,	'thumbnail_size_h',	'150',	'yes'),
(60,	'thumbnail_crop',	'1',	'yes'),
(61,	'medium_size_w',	'300',	'yes'),
(62,	'medium_size_h',	'300',	'yes'),
(63,	'avatar_default',	'mystery',	'yes'),
(64,	'large_size_w',	'1024',	'yes'),
(65,	'large_size_h',	'1024',	'yes'),
(66,	'image_default_link_type',	'none',	'yes'),
(67,	'image_default_size',	'',	'yes'),
(68,	'image_default_align',	'',	'yes'),
(69,	'close_comments_for_old_posts',	'',	'yes'),
(70,	'close_comments_days_old',	'14',	'yes'),
(71,	'thread_comments',	'1',	'yes'),
(72,	'thread_comments_depth',	'5',	'yes'),
(73,	'page_comments',	'',	'yes'),
(74,	'comments_per_page',	'50',	'yes'),
(75,	'default_comments_page',	'newest',	'yes'),
(76,	'comment_order',	'asc',	'yes'),
(77,	'sticky_posts',	'a:0:{}',	'yes'),
(78,	'widget_categories',	'a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}',	'yes'),
(79,	'widget_text',	'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}',	'yes'),
(80,	'widget_rss',	'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}',	'yes'),
(81,	'uninstall_plugins',	'a:2:{s:33:\"classic-editor/classic-editor.php\";a:2:{i:0;s:14:\"Classic_Editor\";i:1;s:9:\"uninstall\";}s:56:\"ellipsis-human-presence-technology/wp-human-presence.php\";a:2:{i:0;s:13:\"HumanPresence\";i:1;s:9:\"uninstall\";}}',	'no'),
(82,	'timezone_string',	'',	'yes'),
(83,	'page_for_posts',	'0',	'yes'),
(84,	'page_on_front',	'7',	'yes'),
(85,	'default_post_format',	'0',	'yes'),
(86,	'link_manager_enabled',	'0',	'yes'),
(87,	'finished_splitting_shared_terms',	'1',	'yes'),
(88,	'site_icon',	'120905',	'yes'),
(89,	'medium_large_size_w',	'768',	'yes'),
(90,	'medium_large_size_h',	'0',	'yes'),
(91,	'wp_page_for_privacy_policy',	'3',	'yes'),
(92,	'show_comments_cookies_opt_in',	'1',	'yes'),
(93,	'admin_email_lifespan',	'1710888042',	'yes'),
(94,	'initial_db_version',	'45805',	'yes'),
(95,	'wp_user_roles',	'a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:71:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"et_support_center\";b:1;s:24:\"et_support_center_system\";b:1;s:31:\"et_support_center_remote_access\";b:1;s:31:\"et_support_center_documentation\";b:1;s:27:\"et_support_center_safe_mode\";b:1;s:22:\"et_support_center_logs\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}',	'yes'),
(96,	'fresh_site',	'0',	'yes'),
(97,	'widget_search',	'a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}',	'yes'),
(98,	'widget_recent-posts',	'a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}',	'yes'),
(99,	'widget_recent-comments',	'a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}',	'yes'),
(100,	'widget_archives',	'a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}',	'yes'),
(101,	'widget_meta',	'a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}',	'yes'),
(102,	'sidebars_widgets',	'a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:21:\"idx-horizontal-search\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:13:\"array_version\";i:3;}',	'yes'),
(103,	'cron',	'a:24:{i:1698249126;a:1:{s:15:\"wf_scan_monitor\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:24:\"wf_scan_monitor_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1698249187;a:1:{s:35:\"wordfence_batchReportFailedAttempts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1698249408;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1698249681;a:1:{s:31:\"human_presence_autoprotect_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:36:\"human_presence_every_fifteen_minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1698251253;a:1:{s:28:\"check_plugin_updates-ca-idx.\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1698251456;a:1:{s:27:\"check_plugin_updates-ca-idx\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1698251498;a:3:{s:27:\"home_value_report_cron_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:22:\"import_leads_cron_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:22:\"search_leads_cron_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1698252314;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1698252321;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1698254867;a:1:{s:31:\"check_plugin_updates-ca-members\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1698254894;a:1:{s:32:\"check_plugin_updates-ca-listings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1698254901;a:1:{s:17:\"gravityforms_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1698255385;a:1:{s:30:\"purge_expired_transients_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1698263106;a:1:{s:26:\"wordfence_daily_autoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1698263121;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1698263808;a:4:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1698263817;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1698288903;a:1:{s:19:\"wpseo-reindex-links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1698401400;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"f5b91df4e108106de2d08d4068d0625d\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1698401400;}}}}i:1698660600;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"9a64b3b0d21446011c721c7e0e34adab\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1698660600;}}}}i:1698720902;a:1:{s:16:\"wpseo_ryte_fetch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1698774776;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1698955049;a:1:{s:32:\"et_core_page_resource_auto_clear\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}s:7:\"version\";i:2;}',	'yes'),
(104,	'widget_pages',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(105,	'widget_calendar',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(106,	'widget_media_audio',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(107,	'widget_media_image',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(108,	'widget_media_gallery',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(109,	'widget_media_video',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(110,	'widget_tag_cloud',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(111,	'widget_nav_menu',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(112,	'widget_custom_html',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(114,	'recovery_keys',	'a:0:{}',	'yes'),
(123,	'auto_core_update_notified',	'a:4:{s:4:\"type\";s:4:\"fail\";s:5:\"email\";s:21:\"derek@covertagent.com\";s:7:\"version\";s:6:\"5.5.13\";s:9:\"timestamp\";i:1697227212;}',	'no'),
(146,	'recently_activated',	'a:0:{}',	'yes'),
(147,	'theme_mods_twentytwenty',	'a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1579723049;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}',	'yes'),
(148,	'current_theme',	'CovertAgent Divi Child',	'yes'),
(149,	'theme_mods_Divi',	'a:6:{i:0;b:0;s:18:\"custom_css_post_id\";i:5;s:16:\"et_pb_css_synced\";s:3:\"yes\";s:18:\"nav_menu_locations\";a:1:{s:12:\"primary-menu\";i:7;}s:39:\"et_updated_layouts_built_for_post_types\";s:3:\"yes\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1589849384;s:4:\"data\";a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}}}}',	'yes'),
(150,	'theme_switched',	'',	'yes'),
(151,	'et_pb_cache_notice',	'a:1:{s:5:\"4.2.2\";s:6:\"ignore\";}',	'yes'),
(156,	'et_core_version',	'4.5.1',	'yes'),
(158,	'et_divi',	'a:300:{s:39:\"static_css_custom_css_safety_check_done\";b:1;s:23:\"2_5_flush_rewrite_rules\";s:4:\"done\";s:30:\"et_flush_rewrite_rules_library\";s:5:\"4.5.1\";s:31:\"divi_previous_installed_version\";s:5:\"4.4.7\";s:29:\"divi_latest_installed_version\";s:5:\"4.5.1\";s:27:\"divi_skip_font_subset_force\";b:1;s:27:\"et_pb_clear_templates_cache\";b:1;s:23:\"builder_custom_defaults\";O:8:\"stdClass\":3:{s:9:\"et_pb_cta\";O:8:\"stdClass\":6:{s:13:\"custom_button\";s:2:\"on\";s:16:\"button_text_size\";s:4:\"16px\";s:17:\"button_text_color\";s:7:\"#ffffff\";s:19:\"button_border_width\";s:3:\"3px\";s:11:\"button_font\";s:22:\"Open Sans|700||on|||||\";s:21:\"button_custom_padding\";s:29:\"10px|20px|10px|20px|true|true\";}s:10:\"et_pb_text\";O:8:\"stdClass\":4:{s:13:\"header_4_font\";s:12:\"Lato||||||||\";s:19:\"header_4_text_align\";s:6:\"center\";s:19:\"header_4_text_color\";s:7:\"#ffffff\";s:18:\"header_4_font_size\";s:4:\"25px\";}s:12:\"et_pb_button\";O:8:\"stdClass\":8:{s:16:\"button_alignment\";s:6:\"center\";s:13:\"custom_button\";s:2:\"on\";s:16:\"button_text_size\";s:4:\"14px\";s:17:\"button_text_color\";s:7:\"#000000\";s:11:\"button_font\";s:14:\"Lato|||on|||||\";s:15:\"button_on_hover\";s:3:\"off\";s:20:\"button_border_radius\";s:3:\"2px\";s:14:\"custom_padding\";s:30:\"10px|27px|10px|18px|true|false\";}}s:33:\"customizer_settings_migrated_flag\";b:1;s:34:\"builder_custom_defaults_unmigrated\";b:0;s:40:\"divi_email_provider_credentials_migrated\";b:1;s:15:\"divi_1_3_images\";s:7:\"checked\";s:21:\"et_pb_layouts_updated\";b:1;s:30:\"library_removed_legacy_layouts\";b:1;s:30:\"divi_2_4_documentation_message\";s:9:\"triggered\";s:9:\"divi_logo\";s:0:\"\";s:14:\"divi_fixed_nav\";s:2:\"on\";s:26:\"divi_gallery_layout_enable\";s:5:\"false\";s:18:\"divi_color_palette\";s:63:\"#000000|#ffffff|#e02b20|#e09900|#edf000|#7cda24|#0c71c3|#8300e9\";s:15:\"divi_grab_image\";s:5:\"false\";s:15:\"divi_blog_style\";s:2:\"on\";s:12:\"divi_sidebar\";s:16:\"et_right_sidebar\";s:22:\"divi_shop_page_sidebar\";s:16:\"et_right_sidebar\";s:23:\"divi_show_facebook_icon\";s:2:\"on\";s:22:\"divi_show_twitter_icon\";s:2:\"on\";s:21:\"divi_show_google_icon\";s:2:\"on\";s:24:\"divi_show_instagram_icon\";s:2:\"on\";s:18:\"divi_show_rss_icon\";s:2:\"on\";s:17:\"divi_facebook_url\";s:1:\"#\";s:16:\"divi_twitter_url\";s:1:\"#\";s:15:\"divi_google_url\";s:1:\"#\";s:18:\"divi_instagram_url\";s:1:\"#\";s:12:\"divi_rss_url\";s:0:\"\";s:34:\"divi_woocommerce_archive_num_posts\";i:9;s:17:\"divi_catnum_posts\";i:50;s:21:\"divi_archivenum_posts\";i:50;s:20:\"divi_searchnum_posts\";i:50;s:17:\"divi_tagnum_posts\";i:50;s:16:\"divi_date_format\";s:6:\"M j, Y\";s:16:\"divi_use_excerpt\";s:5:\"false\";s:26:\"divi_responsive_shortcodes\";s:2:\"on\";s:33:\"divi_gf_enable_all_character_sets\";s:5:\"false\";s:16:\"divi_back_to_top\";s:5:\"false\";s:18:\"divi_smooth_scroll\";s:5:\"false\";s:25:\"divi_disable_translations\";s:5:\"false\";s:29:\"divi_enable_responsive_images\";s:2:\"on\";s:27:\"divi_minify_combine_scripts\";s:2:\"on\";s:26:\"divi_minify_combine_styles\";s:2:\"on\";s:15:\"divi_custom_css\";s:9906:\"/*https://player.vimeo.com/video/356704112\n\n#bg-home-vid {background-image:url(https://player.vimeo.com/video/356704112)}*/\n\n.et_pb_blog_grid .et_pb_post {\n    border: 1px solid #ffffff;\n    padding: 19px;\n    background-color: #fff;\n    word-wrap: break-word;\n    box-shadow: 4px 4px 15px 0px rgba(0, 0, 0, 0.1), 0px 0px 4px 0px rgba(0, 0, 0, 0.1);\n    border-radius: 4px;\n}\n.has-post-thumbnail {\n    max-height: 300px;\n    margin: 0 0 70px;\n}\n.et_pb_blog_grid .et_pb_image_container a:before {\ncontent:\'\';\n/*imports an image*/\nbackground-color: #000;\n/*places an overlay on top of the image*/\nopacity: 0.4;\n/*makes the image visible*/\nposition: absolute;\ntop: 0;\nleft: 0;\nwidth: 100%;\nheight: 100%;\n\n}\n.et_pb_blog_grid h2 {\n    font-size: 18px;\n    margin-top: -85px;\n    position: relative;\n    color: #fff;\n    text-align: center;\n    z-index: 9999;\n}\n\n\n\n\n\n.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] {\n    overflow: visible;\n    bottom: 15px!important;\n    margin: 0;\n	  right: 28px!important;\n	  left:unset!important;\n}\n\n@media (max-width:662px) {\n	.ti-widget{display:none!important;}\n	\n	#horizontal-idx-search-widget {display:inline-block!important;}\n	\n}\n\n#menu-top-menu ul.sub-menu {background-color: rgb(92, 91, 91) !important; border-color: transparent;\n}\n#top-menu {float: right!important;}\n#top-menu li {padding-right: 0!important;padding-left: 20px!important;}\nul.sub-menu li a {padding: 6px 10px!important;width: 200px;}\n\n.pagination ul {\n    text-align: center;\n}\n\n.pagination li {\n    display: inline;\n    padding: 10px 20px;\n    font-size: 18px;\n    background-color: #f3f3f3;\n    border-radius: 6px;\n    margin-right: 5px;\n}\n\n/**CA IDX edits**/\n.detailspage .fa {\n    font-size: 45px;\n    color: #000000;\n}\n\n.speclabel {\n    display: block;\n    width: 100%;\n    padding-top: 10px;\n    text-align: center;\n}\n\n.rel-description p  {\n    font-weight: 500;\n    font-size: 18px;\n}\n\n/*Listing Details Schools*/\n[data-init=\"widgets/schoolsNearby\"] {\n	max-width: 100%!important;}\n\n.schools-nearby {padding: 0 0 50px!important;}\n\n.schools-nearby__tabs .nav-item.active {\n    border-width: 3px;\n    background-color: #ededed;\n}\n\n.hjitb .nav-tabs>li {\n    padding: 15px!important;\n}\n\n#property-nearby-schools {padding: 50px 0 0!important;}\n\n#property-map h2  {padding: 50px 0 15px!important;}\n/*End Listing Details Schools*/\n.slider-wrapper {\n    margin: 30px -15px 0!important;\n}\n\n.idx-property-description {font-size: 16px!important; line-height: 1.6em!important;   margin-top: 15px;}\n\n#vtour iframe {\n	width: 1080px;\n    height: 620px;\nmargin-bottom: 80px;}\n\n#listing-stats {\n    font-weight: bold;\n    font-size: 18px;\n    padding: 50px 10px;\n    background-color: #f7f7f7;\n    margin-bottom: 50px;\n}\n\n.property-description-wrap {margin-top: 18px;}\n\n.idx-price {text-align: center;\n    padding: 20px 0 10px;\n    margin-bottom: 10px;}\n\n.idx-price h2, .property-description-wrap h2 span  {\n    color: #071645!important;\n}\n\nh1.entry-title {top:45vh!important;}\n\n.compliance-asset {max-width:80px;position: relative;    float: left;top: 5px;}\n\n#listing-details .horizontal {padding: 60px 0;}\n\n.listing-hdr:before {position: absolute;\n    left: 0;\n    width: 100%;\n    height: 100%;\n    background-color: #000;\n    content: \' \';\n    opacity: 0.35;\n}\n\n.gridback {background-position: center center!important;box-shadow: 0px 2px 18px 0px rgba(0,0,0,0.3)!important;}\n\n.idx-result-snippet-wrapper:hover {box-shadow: 0px 2px 18px 0px rgba(0,0,0,0.3)!important;}\n\n.idx-result-snippet .listing-title {min-height: 30px;}\n\n.quick-search-widget-wrapper {    min-height: 265px;}\n#idx-footer-compliance {\n    max-width: none;\n    margin: auto;\n    line-height: 1em;\n    padding-bottom: 3em;\n    padding: 20px 50px;\n    background-color:#171717;\n    color: #555;\n    text-align: center;\n    font-size: 12px;\n}\n\n.idx-result-snippet .open_house_flag {\n    bottom: 0;\n    background: #000;\n    padding: 15px;\n}\n\n.empty-field.idx-row.odd {\n	display:none;}\n\n.hjitb .btn-primary {\n    color: #000;\n    background-color: #e6e6e6;\n    border-color: #e6e6e6;\n    border: none;\n    padding: 20px;\n    border-radius: 0;\n    font-size: 20px;\n    text-transform: uppercase;\n    font-weight: bold;\n}\n\n.hjitb .btn-primary:hover,.hjitb .btn-primary:active  {background-color:#000;}\n\n.main-details .btn, .main-details .btn-primary {\n    margin: 5px auto;\n    width: 100%;\n}\n\n.idx-pagination ul {\n    float: right;\n}\n\n.idx-result-snippet .listing-title .address-line1, .idx-result-snippet .listing-title .address-line2 {\n	display: inherit;}\n\n.idx-result-snippet .listing-title {\n    margin: 15px 0 10px;\n    padding: 0;\n    text-align: center;\n    font-size: 22px;\n    line-height: normal;\n    bottom: 0;\n}\n\n.grid-view .main-details, .map-view .main-details {\n    position: absolute;\n    width: 100%;\n    float: none;\n    bottom: 0;\n    color: #fff;\n    padding-bottom: 15px;\n    background-color: rgba(0, 0, 0, .5);\n}\n\n/****** Misc Responsive ******/\n@media (min-width:1601px) {\n	.property_img,.property_img img {height: 375px!important;}\n}	\n@media (max-width:1600px) {\n	.property_img,.property_img img {height: 350px!important;}\n}\n@media (max-width:1450px) {\n	.property_img,.property_img img {height: 320px!important;}\n}\n@media (max-width:1200px) {\n	.property_img,.property_img img {height: 300px!important;}\n}\n@media (max-width:992px) {\n	.property_img,.property_img img {height: 280px!important;}\n}\n@media (max-width:767px) {\n	.property_img,.property_img img {height: 255px!important;}\n.covert_single_property {width: 100%;}\n.prop_title, .prop_title h1 {font-size: 20px;padding: 0 10px;}\n.covert_meta {padding: 0 10px;font-size: 16px;max-height: 55px;}\n.property_img, .property_img img {max-height: 320px !important;}\n.search_area .searchfldcont {margin-bottom: 10px;width: 100%;}\n.search_area .filterbeds {width: 24.2%;}\n.search_area .filterbath {width: 24.2%;}\n.search_area .sortby {width: 24.2%;}\n.search_area .resetbut {width: 24.3%;padding: 7px 7px 8px;}}\n@media (max-width:400px){}\n\n/*Mobile container width adj*/\n\n@media only screen and (max-width: 690px) and (min-width: 480px){\nbody .container, body div.slider-nav, .post-area.standard-minimal.full-width-content article.post .inner-wrap {\n    max-width: 90%!important;\n}}\n\n@media only screen and (max-width: 690px){\n.container, div.slider-nav, .post-area.standard-minimal.full-width-content article.post .inner-wrap {\n    max-width: 90%!important;\n}}\n/*********CA LISTING***************/\n/**CA-Listings**/\n.rel-single-listing .rel-photo-wrap img {width:100%!important;}\n\n/**.cboxElement {max-width:129px!important;}**/\n.bx-wrapper, .bx-clone, .bx-clone img {max-height:96.5px;}\n\n/*fixes gallery img wrapper on listing details*/\n.bx-wrapper {\n    display: inline-table;\n    margin-top: -50px;\n    max-width:100%!important;\n	  width:100%;\n}\n\nh1.entry-title {\n    position: absolute;\n    top: 45%;\n    text-align: center;\n    width: 100%;\n	  color:#fff;\n}\n\n.content-heading h1 {font-size: 50px;text-align: center;padding: 30px;}\n\nhtml body .row .col.section-title h1 {font-size: 50px;}\n\n.listing .rel-single-listing .rel-photo-wrap{width:100%}\n\n.listing .rel-main-details{width:100%}\n\n.listing{font-size:20px;font-weight:bold;}\n	\n.grid_title {text-align: center;}\n\n.gridbgback  .rel-photo-wrap{position:absolute;bottom:10px;text-align:center;}\n\n.gridbgback  .rel-photo-wrap .grid_title, .gridbgback  .rel-photo-wrap .grid_title a{color:#FFFFFF !important;}\n	\n.gridmeta{color:#FFFFFF !important;}\n\n#rel-archive-view .listing{margin-bottom:0px !important;}\n	\n.row{padding-bottom:0px;}\n	\n.grid_title{font-size:20px;}\n	\n\n\n@media (min-width:1601px) {\n	.listing_grid img, .gridbgback {height: 400px!important;}#rel-archive-view{padding:0 10%;}\n	}\n@media (max-width:1600px) {\n		.listing_grid img, .gridbgback {height: 400px!important;}\n	}\n@media (max-width:1450px) {\n		.listing_grid img, .gridbgback {height: 350px!important;}\n	}\n@media (max-width:1200px) {\n		.listing_grid img, .gridbgback {height: 300px!important;}\n	}\n@media (max-width:992px) {\n		.listing_grid img, .gridbgback {height: 250px!important;}\n	\n	\n#top-menu {\n    display: inherit!important;\n	float:none!important;\n}\n\n.et_mobile_menu {\n    width: 300px;\n    left: -130px;\n}\n\n#mobile_menu1, ul .sub-menu,.et_pb_menu_0_tb_header.et_pb_menu .et_mobile_menu ul, .menu-item-430 {\n  background-color: #000 !important;}\n\n#et-secondary-menu li, #top-menu li {\n  word-wrap: unset!important;\n	width: 100%;\n}\n	\n	\n	\n	}\n@media (max-width:767px) {\n		.listing_grid img, .gridbgback {height: 325px!important;}\n	}\n@media (max-width:400px){\n		.listing_grid img, .gridbgback {height: 225px!important;}\n	}\n.pg_ehader{width:100%;height:70vh;background-size:cover !important;background-position:center center!important;}\n/*********CA LISTING END***************/\n\n/*************CA BADGES************/\nspan.listing-status {\n	width: 130px;\n    padding: 5px;\n    top: 20px;\n    right: -20px;\n    font-size: 12px;\n    line-height: 18px;\n	position: absolute;\n    -moz-transform: scale(1) rotate(45deg) translate(0px);\n    -webkit-transform: scale(1) rotate(45deg) translate(0px);\n    -o-transform: scale(1) rotate(45deg) translate(0px);\n    transform: scale(1) rotate(45deg) translate(0px);\n	color: #fff;\n    background: #53c331;\n    background: rgba(83,195,49,0.8);\n    font-weight: 700;\n    text-align: center;\n    text-transform: uppercase;\n    box-shadow: 0px 4px 1px rgba(0,0,0,0.2);\n	z-index:9;\n}\n\n.listing-status.fsold {\n    color: #fff;\n    background: #53c331;\n    background: rgba(83,195,49,0.8);\n}\n\n.favorite-toggle-wrap .status-badge {\n    top: 2px;\n    right: 85px;\n}\n.listing-badge{color: #fff;background:rgb(82, 81, 81);}\nspan.listing-badge {\n    width: 130px;\n    padding: 5px;\n    top: 0;\n    right: 0;\n    font-size: 12px;\n    line-height: 18px;\n    position: absolute;\n    font-weight: 700;\n    text-align: center;\n    text-transform: uppercase;\n    z-index: 9;\n}\n/*************CA BADGES END************/\";s:21:\"divi_enable_dropdowns\";s:2:\"on\";s:14:\"divi_home_link\";s:2:\"on\";s:15:\"divi_sort_pages\";s:10:\"post_title\";s:15:\"divi_order_page\";s:3:\"asc\";s:22:\"divi_tiers_shown_pages\";i:3;s:32:\"divi_enable_dropdowns_categories\";s:2:\"on\";s:21:\"divi_categories_empty\";s:2:\"on\";s:27:\"divi_tiers_shown_categories\";i:3;s:13:\"divi_sort_cat\";s:4:\"name\";s:14:\"divi_order_cat\";s:3:\"asc\";s:20:\"divi_disable_toptier\";s:5:\"false\";s:25:\"divi_scroll_to_anchor_fix\";s:5:\"false\";s:27:\"et_pb_post_type_integration\";a:6:{s:4:\"post\";s:2:\"on\";s:4:\"page\";s:2:\"on\";s:7:\"project\";s:2:\"on\";s:5:\"email\";s:3:\"off\";s:3:\"sms\";s:3:\"off\";s:7:\"listing\";s:3:\"off\";}s:21:\"et_pb_static_css_file\";s:2:\"on\";s:19:\"et_pb_css_in_footer\";s:3:\"off\";s:25:\"et_pb_product_tour_global\";s:2:\"on\";s:24:\"et_enable_classic_editor\";s:3:\"off\";s:14:\"divi_postinfo2\";a:4:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";}s:22:\"divi_show_postcomments\";s:2:\"on\";s:15:\"divi_thumbnails\";s:2:\"on\";s:20:\"divi_page_thumbnails\";s:5:\"false\";s:23:\"divi_show_pagescomments\";s:5:\"false\";s:14:\"divi_postinfo1\";a:3:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";}s:21:\"divi_thumbnails_index\";s:2:\"on\";s:19:\"divi_seo_home_title\";s:5:\"false\";s:25:\"divi_seo_home_description\";s:5:\"false\";s:22:\"divi_seo_home_keywords\";s:5:\"false\";s:23:\"divi_seo_home_canonical\";s:5:\"false\";s:23:\"divi_seo_home_titletext\";s:0:\"\";s:29:\"divi_seo_home_descriptiontext\";s:0:\"\";s:26:\"divi_seo_home_keywordstext\";s:0:\"\";s:18:\"divi_seo_home_type\";s:27:\"BlogName | Blog description\";s:22:\"divi_seo_home_separate\";s:3:\" | \";s:21:\"divi_seo_single_title\";s:5:\"false\";s:27:\"divi_seo_single_description\";s:5:\"false\";s:24:\"divi_seo_single_keywords\";s:5:\"false\";s:25:\"divi_seo_single_canonical\";s:5:\"false\";s:27:\"divi_seo_single_field_title\";s:9:\"seo_title\";s:33:\"divi_seo_single_field_description\";s:15:\"seo_description\";s:30:\"divi_seo_single_field_keywords\";s:12:\"seo_keywords\";s:20:\"divi_seo_single_type\";s:21:\"Post title | BlogName\";s:24:\"divi_seo_single_separate\";s:3:\" | \";s:24:\"divi_seo_index_canonical\";s:5:\"false\";s:26:\"divi_seo_index_description\";s:5:\"false\";s:19:\"divi_seo_index_type\";s:24:\"Category name | BlogName\";s:23:\"divi_seo_index_separate\";s:3:\" | \";s:28:\"divi_integrate_header_enable\";s:2:\"on\";s:26:\"divi_integrate_body_enable\";s:2:\"on\";s:31:\"divi_integrate_singletop_enable\";s:2:\"on\";s:34:\"divi_integrate_singlebottom_enable\";s:2:\"on\";s:21:\"divi_integration_head\";s:0:\"\";s:21:\"divi_integration_body\";s:325:\"<!-- Global site tag (gtag.js) - Google Analytics -->\r\n<script async src=\"https://www.googletagmanager.com/gtag/js?id=UA-185016041-1\">\r\n</script>\r\n<script>\r\n  window.dataLayer = window.dataLayer || [];\r\n  function gtag(){dataLayer.push(arguments);}\r\n  gtag(\'js\', new Date());\r\n\r\n  gtag(\'config\', \'UA-185016041-1\');\r\n</script>\";s:27:\"divi_integration_single_top\";s:0:\"\";s:30:\"divi_integration_single_bottom\";s:0:\"\";s:15:\"divi_468_enable\";s:5:\"false\";s:14:\"divi_468_image\";s:0:\"\";s:12:\"divi_468_url\";s:0:\"\";s:16:\"divi_468_adsense\";s:0:\"\";s:19:\"product_tour_status\";a:2:{i:1;s:3:\"off\";i:2;s:3:\"off\";}s:32:\"et_fb_pref_settings_bar_location\";s:6:\"bottom\";s:28:\"et_fb_pref_builder_animation\";s:4:\"true\";s:41:\"et_fb_pref_builder_display_modal_settings\";s:5:\"false\";s:39:\"et_fb_pref_builder_enable_dummy_content\";s:4:\"true\";s:21:\"et_fb_pref_event_mode\";s:5:\"hover\";s:20:\"et_fb_pref_view_mode\";s:7:\"desktop\";s:32:\"et_fb_pref_hide_disabled_modules\";s:5:\"false\";s:28:\"et_fb_pref_history_intervals\";i:1;s:29:\"et_fb_pref_page_creation_flow\";s:7:\"default\";s:42:\"et_fb_pref_quick_actions_always_start_with\";s:7:\"nothing\";s:44:\"et_fb_pref_quick_actions_show_recent_queries\";s:3:\"off\";s:39:\"et_fb_pref_quick_actions_recent_queries\";s:3:\"tex\";s:40:\"et_fb_pref_quick_actions_recent_category\";s:0:\"\";s:27:\"et_fb_pref_modal_preference\";s:7:\"default\";s:30:\"et_fb_pref_modal_snap_location\";s:0:\"\";s:21:\"et_fb_pref_modal_snap\";s:5:\"false\";s:27:\"et_fb_pref_modal_fullscreen\";s:5:\"false\";s:32:\"et_fb_pref_modal_dimension_width\";i:500;s:33:\"et_fb_pref_modal_dimension_height\";i:459;s:27:\"et_fb_pref_modal_position_x\";i:126;s:27:\"et_fb_pref_modal_position_y\";i:56;s:24:\"et_fb_pref_toolbar_click\";s:5:\"false\";s:26:\"et_fb_pref_toolbar_desktop\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_grid\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_hover\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_phone\";s:4:\"true\";s:25:\"et_fb_pref_toolbar_tablet\";s:4:\"true\";s:28:\"et_fb_pref_toolbar_wireframe\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_zoom\";s:4:\"true\";s:31:\"builder_custom_defaults_history\";O:8:\"stdClass\":2:{s:7:\"history\";a:5:{i:0;O:8:\"stdClass\":3:{s:8:\"settings\";O:8:\"stdClass\":1:{s:9:\"et_pb_cta\";O:8:\"stdClass\":5:{s:13:\"custom_button\";s:2:\"on\";s:16:\"button_text_size\";s:4:\"16px\";s:17:\"button_text_color\";s:7:\"#ffffff\";s:19:\"button_border_width\";s:3:\"3px\";s:11:\"button_font\";s:22:\"Open Sans|700||on|||||\";}}s:4:\"time\";i:1580389705205;s:5:\"label\";s:21:\"Edited Call To Action\";}i:1;O:8:\"stdClass\":3:{s:8:\"settings\";O:8:\"stdClass\":1:{s:9:\"et_pb_cta\";O:8:\"stdClass\":6:{s:13:\"custom_button\";s:2:\"on\";s:16:\"button_text_size\";s:4:\"16px\";s:17:\"button_text_color\";s:7:\"#ffffff\";s:19:\"button_border_width\";s:3:\"3px\";s:11:\"button_font\";s:22:\"Open Sans|700||on|||||\";s:21:\"button_custom_padding\";s:29:\"10px|20px|10px|20px|true|true\";}}s:4:\"time\";i:1580389788809;s:5:\"label\";s:21:\"Edited Call To Action\";}i:2;O:8:\"stdClass\":3:{s:8:\"settings\";O:8:\"stdClass\":1:{s:9:\"et_pb_cta\";O:8:\"stdClass\":6:{s:13:\"custom_button\";s:2:\"on\";s:16:\"button_text_size\";s:4:\"16px\";s:17:\"button_text_color\";s:7:\"#ffffff\";s:19:\"button_border_width\";s:3:\"3px\";s:11:\"button_font\";s:22:\"Open Sans|700||on|||||\";s:21:\"button_custom_padding\";s:29:\"10px|20px|10px|20px|true|true\";}}s:4:\"time\";i:1580389863115;s:5:\"label\";s:21:\"Edited Call To Action\";}i:3;O:8:\"stdClass\":3:{s:8:\"settings\";O:8:\"stdClass\":2:{s:9:\"et_pb_cta\";O:8:\"stdClass\":6:{s:13:\"custom_button\";s:2:\"on\";s:16:\"button_text_size\";s:4:\"16px\";s:17:\"button_text_color\";s:7:\"#ffffff\";s:19:\"button_border_width\";s:3:\"3px\";s:11:\"button_font\";s:22:\"Open Sans|700||on|||||\";s:21:\"button_custom_padding\";s:29:\"10px|20px|10px|20px|true|true\";}s:10:\"et_pb_text\";O:8:\"stdClass\":4:{s:13:\"header_4_font\";s:12:\"Lato||||||||\";s:19:\"header_4_text_align\";s:6:\"center\";s:19:\"header_4_text_color\";s:7:\"#ffffff\";s:18:\"header_4_font_size\";s:4:\"25px\";}}s:4:\"time\";i:1580390163483;s:5:\"label\";s:11:\"Edited Text\";}i:4;O:8:\"stdClass\":3:{s:8:\"settings\";r:9;s:4:\"time\";i:1580391814097;s:5:\"label\";s:13:\"Edited Button\";}}s:5:\"index\";s:1:\"4\";}s:28:\"et_fb_pref_limited_view_mode\";s:9:\"wireframe\";s:35:\"et_fb_pref_limited_modal_preference\";s:7:\"default\";s:32:\"et_fb_pref_limited_toolbar_click\";s:5:\"false\";s:34:\"et_fb_pref_limited_toolbar_desktop\";s:4:\"true\";s:31:\"et_fb_pref_limited_toolbar_grid\";s:5:\"false\";s:32:\"et_fb_pref_limited_toolbar_hover\";s:5:\"false\";s:32:\"et_fb_pref_limited_toolbar_phone\";s:4:\"true\";s:33:\"et_fb_pref_limited_toolbar_tablet\";s:4:\"true\";s:36:\"et_fb_pref_limited_toolbar_wireframe\";s:4:\"true\";s:31:\"et_fb_pref_limited_toolbar_zoom\";s:4:\"true\";s:24:\"footer_widget_text_color\";s:7:\"#ffffff\";s:24:\"footer_widget_link_color\";s:7:\"#ffffff\";s:36:\"et_fb_pref_lv_modal_dimension_height\";i:1;s:35:\"et_fb_pref_lv_modal_dimension_width\";i:1;s:30:\"et_fb_pref_lv_modal_position_x\";i:1;s:30:\"et_fb_pref_lv_modal_position_y\";i:1;s:16:\"mobile_menu_link\";s:7:\"#ffffff\";s:21:\"mobile_primary_nav_bg\";s:7:\"#0a0a0a\";s:30:\"builder_global_presets_history\";O:8:\"stdClass\":2:{s:7:\"history\";a:5:{i:0;O:8:\"stdClass\":3:{s:8:\"settings\";O:8:\"stdClass\":1:{s:9:\"et_pb_cta\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":1:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:23:\"Call To Action Preset 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:5:\"4.5.1\";s:8:\"settings\";O:8:\"stdClass\":5:{s:13:\"custom_button\";s:2:\"on\";s:16:\"button_text_size\";s:4:\"16px\";s:17:\"button_text_color\";s:7:\"#ffffff\";s:19:\"button_border_width\";s:3:\"3px\";s:11:\"button_font\";s:22:\"Open Sans|700||on|||||\";}}}}}s:4:\"time\";i:1580389705205;s:5:\"label\";s:21:\"Edited Call To Action\";}i:1;O:8:\"stdClass\":3:{s:8:\"settings\";O:8:\"stdClass\":1:{s:9:\"et_pb_cta\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":1:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:23:\"Call To Action Preset 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:5:\"4.5.1\";s:8:\"settings\";O:8:\"stdClass\":6:{s:13:\"custom_button\";s:2:\"on\";s:16:\"button_text_size\";s:4:\"16px\";s:17:\"button_text_color\";s:7:\"#ffffff\";s:19:\"button_border_width\";s:3:\"3px\";s:11:\"button_font\";s:22:\"Open Sans|700||on|||||\";s:21:\"button_custom_padding\";s:29:\"10px|20px|10px|20px|true|true\";}}}}}s:4:\"time\";i:1580389788809;s:5:\"label\";s:21:\"Edited Call To Action\";}i:2;O:8:\"stdClass\":3:{s:8:\"settings\";O:8:\"stdClass\":1:{s:9:\"et_pb_cta\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":1:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:23:\"Call To Action Preset 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:5:\"4.5.1\";s:8:\"settings\";O:8:\"stdClass\":6:{s:13:\"custom_button\";s:2:\"on\";s:16:\"button_text_size\";s:4:\"16px\";s:17:\"button_text_color\";s:7:\"#ffffff\";s:19:\"button_border_width\";s:3:\"3px\";s:11:\"button_font\";s:22:\"Open Sans|700||on|||||\";s:21:\"button_custom_padding\";s:29:\"10px|20px|10px|20px|true|true\";}}}}}s:4:\"time\";i:1580389863115;s:5:\"label\";s:21:\"Edited Call To Action\";}i:3;O:8:\"stdClass\":3:{s:8:\"settings\";O:8:\"stdClass\":2:{s:9:\"et_pb_cta\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":1:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:23:\"Call To Action Preset 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:5:\"4.5.1\";s:8:\"settings\";O:8:\"stdClass\":6:{s:13:\"custom_button\";s:2:\"on\";s:16:\"button_text_size\";s:4:\"16px\";s:17:\"button_text_color\";s:7:\"#ffffff\";s:19:\"button_border_width\";s:3:\"3px\";s:11:\"button_font\";s:22:\"Open Sans|700||on|||||\";s:21:\"button_custom_padding\";s:29:\"10px|20px|10px|20px|true|true\";}}}}s:10:\"et_pb_text\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":1:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"Text Preset 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:5:\"4.5.1\";s:8:\"settings\";O:8:\"stdClass\":4:{s:13:\"header_4_font\";s:12:\"Lato||||||||\";s:19:\"header_4_text_align\";s:6:\"center\";s:19:\"header_4_text_color\";s:7:\"#ffffff\";s:18:\"header_4_font_size\";s:4:\"25px\";}}}}}s:4:\"time\";i:1580390163483;s:5:\"label\";s:11:\"Edited Text\";}i:4;O:8:\"stdClass\":3:{s:8:\"settings\";O:8:\"stdClass\":3:{s:9:\"et_pb_cta\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":1:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:23:\"Call To Action Preset 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:5:\"4.5.1\";s:8:\"settings\";O:8:\"stdClass\":6:{s:13:\"custom_button\";s:2:\"on\";s:16:\"button_text_size\";s:4:\"16px\";s:17:\"button_text_color\";s:7:\"#ffffff\";s:19:\"button_border_width\";s:3:\"3px\";s:11:\"button_font\";s:22:\"Open Sans|700||on|||||\";s:21:\"button_custom_padding\";s:29:\"10px|20px|10px|20px|true|true\";}}}}s:10:\"et_pb_text\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":1:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"Text Preset 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:5:\"4.5.1\";s:8:\"settings\";O:8:\"stdClass\":4:{s:13:\"header_4_font\";s:12:\"Lato||||||||\";s:19:\"header_4_text_align\";s:6:\"center\";s:19:\"header_4_text_color\";s:7:\"#ffffff\";s:18:\"header_4_font_size\";s:4:\"25px\";}}}}s:12:\"et_pb_button\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":1:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:15:\"Button Preset 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:5:\"4.5.1\";s:8:\"settings\";O:8:\"stdClass\":8:{s:16:\"button_alignment\";s:6:\"center\";s:13:\"custom_button\";s:2:\"on\";s:16:\"button_text_size\";s:4:\"14px\";s:17:\"button_text_color\";s:7:\"#000000\";s:11:\"button_font\";s:14:\"Lato|||on|||||\";s:15:\"button_on_hover\";s:3:\"off\";s:20:\"button_border_radius\";s:3:\"2px\";s:14:\"custom_padding\";s:30:\"10px|27px|10px|18px|true|false\";}}}}}s:4:\"time\";i:1580391814097;s:5:\"label\";s:13:\"Edited Button\";}}s:5:\"index\";s:1:\"4\";}s:22:\"builder_global_presets\";O:8:\"stdClass\":3:{s:9:\"et_pb_cta\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":1:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:23:\"Call To Action Preset 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:5:\"4.5.1\";s:8:\"settings\";O:8:\"stdClass\":6:{s:13:\"custom_button\";s:2:\"on\";s:16:\"button_text_size\";s:4:\"16px\";s:17:\"button_text_color\";s:7:\"#ffffff\";s:19:\"button_border_width\";s:3:\"3px\";s:11:\"button_font\";s:22:\"Open Sans|700||on|||||\";s:21:\"button_custom_padding\";s:29:\"10px|20px|10px|20px|true|true\";}}}}s:10:\"et_pb_text\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":1:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"Text Preset 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:5:\"4.5.1\";s:8:\"settings\";O:8:\"stdClass\":4:{s:13:\"header_4_font\";s:12:\"Lato||||||||\";s:19:\"header_4_text_align\";s:6:\"center\";s:19:\"header_4_text_color\";s:7:\"#ffffff\";s:18:\"header_4_font_size\";s:4:\"25px\";}}}}s:12:\"et_pb_button\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":1:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:15:\"Button Preset 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:5:\"4.5.1\";s:8:\"settings\";O:8:\"stdClass\":8:{s:16:\"button_alignment\";s:6:\"center\";s:13:\"custom_button\";s:2:\"on\";s:16:\"button_text_size\";s:4:\"14px\";s:17:\"button_text_color\";s:7:\"#000000\";s:11:\"button_font\";s:14:\"Lato|||on|||||\";s:15:\"button_on_hover\";s:3:\"off\";s:20:\"button_border_radius\";s:3:\"2px\";s:14:\"custom_padding\";s:30:\"10px|27px|10px|18px|true|false\";}}}}}s:29:\"custom_defaults_migrated_flag\";b:1;s:19:\"post_meta_font_size\";s:2:\"14\";s:16:\"post_meta_height\";s:1:\"1\";s:17:\"post_meta_spacing\";s:1:\"0\";s:15:\"post_meta_style\";s:0:\"\";s:21:\"post_header_font_size\";s:2:\"30\";s:18:\"post_header_height\";s:1:\"1\";s:19:\"post_header_spacing\";s:1:\"0\";s:17:\"post_header_style\";s:0:\"\";s:12:\"boxed_layout\";s:0:\"\";s:13:\"content_width\";s:4:\"1080\";s:12:\"gutter_width\";s:1:\"3\";s:17:\"use_sidebar_width\";s:0:\"\";s:13:\"sidebar_width\";s:2:\"21\";s:15:\"section_padding\";s:1:\"4\";s:20:\"phone_section_height\";s:2:\"50\";s:21:\"tablet_section_height\";s:2:\"50\";s:11:\"row_padding\";s:1:\"2\";s:16:\"phone_row_height\";s:2:\"30\";s:17:\"tablet_row_height\";s:2:\"30\";s:16:\"cover_background\";s:2:\"on\";s:14:\"body_font_size\";s:2:\"14\";s:16:\"body_font_height\";s:3:\"1.7\";s:20:\"phone_body_font_size\";s:2:\"14\";s:21:\"tablet_body_font_size\";s:2:\"14\";s:16:\"body_header_size\";s:2:\"30\";s:19:\"body_header_spacing\";s:1:\"0\";s:18:\"body_header_height\";s:1:\"1\";s:17:\"body_header_style\";s:0:\"\";s:22:\"phone_header_font_size\";s:2:\"30\";s:23:\"tablet_header_font_size\";s:2:\"30\";s:12:\"heading_font\";s:4:\"none\";s:9:\"body_font\";s:4:\"none\";s:10:\"link_color\";s:7:\"#2ea3f2\";s:10:\"font_color\";s:7:\"#666666\";s:12:\"header_color\";s:7:\"#666666\";s:12:\"accent_color\";s:7:\"#2ea3f2\";s:13:\"color_schemes\";s:4:\"none\";s:12:\"header_style\";s:4:\"left\";s:12:\"vertical_nav\";s:0:\"\";s:24:\"vertical_nav_orientation\";s:4:\"left\";s:8:\"hide_nav\";s:0:\"\";s:24:\"show_header_social_icons\";s:0:\"\";s:16:\"show_search_icon\";s:2:\"on\";s:22:\"slide_nav_show_top_bar\";s:2:\"on\";s:15:\"slide_nav_width\";s:3:\"320\";s:19:\"slide_nav_font_size\";s:2:\"14\";s:23:\"slide_nav_top_font_size\";s:2:\"14\";s:24:\"fullscreen_nav_font_size\";s:2:\"30\";s:28:\"fullscreen_nav_top_font_size\";s:2:\"18\";s:22:\"slide_nav_font_spacing\";s:1:\"0\";s:14:\"slide_nav_font\";s:4:\"none\";s:20:\"slide_nav_font_style\";s:0:\"\";s:12:\"slide_nav_bg\";s:7:\"#2ea3f2\";s:21:\"slide_nav_links_color\";s:7:\"#ffffff\";s:28:\"slide_nav_links_color_active\";s:7:\"#ffffff\";s:19:\"slide_nav_top_color\";s:21:\"rgba(255,255,255,0.6)\";s:16:\"slide_nav_search\";s:21:\"rgba(255,255,255,0.6)\";s:19:\"slide_nav_search_bg\";s:15:\"rgba(0,0,0,0.2)\";s:13:\"nav_fullwidth\";s:0:\"\";s:17:\"hide_primary_logo\";s:0:\"\";s:11:\"menu_height\";s:2:\"66\";s:11:\"logo_height\";s:2:\"54\";s:15:\"menu_margin_top\";s:1:\"0\";s:21:\"primary_nav_font_size\";s:2:\"14\";s:24:\"primary_nav_font_spacing\";s:1:\"0\";s:16:\"primary_nav_font\";s:4:\"none\";s:22:\"primary_nav_font_style\";s:0:\"\";s:23:\"secondary_nav_font_size\";s:2:\"12\";s:23:\"secondary_nav_fullwidth\";s:0:\"\";s:26:\"secondary_nav_font_spacing\";s:1:\"0\";s:18:\"secondary_nav_font\";s:4:\"none\";s:24:\"secondary_nav_font_style\";s:0:\"\";s:9:\"menu_link\";s:15:\"rgba(0,0,0,0.6)\";s:16:\"hide_mobile_logo\";s:0:\"\";s:16:\"menu_link_active\";s:7:\"#2ea3f2\";s:14:\"primary_nav_bg\";s:7:\"#ffffff\";s:23:\"primary_nav_dropdown_bg\";s:7:\"#ffffff\";s:31:\"primary_nav_dropdown_line_color\";s:7:\"#2ea3f2\";s:31:\"primary_nav_dropdown_link_color\";s:15:\"rgba(0,0,0,0.7)\";s:30:\"primary_nav_dropdown_animation\";s:4:\"fade\";s:16:\"secondary_nav_bg\";s:7:\"#2ea3f2\";s:28:\"secondary_nav_text_color_new\";s:7:\"#ffffff\";s:25:\"secondary_nav_dropdown_bg\";s:7:\"#2ea3f2\";s:33:\"secondary_nav_dropdown_link_color\";s:7:\"#ffffff\";s:32:\"secondary_nav_dropdown_animation\";s:4:\"fade\";s:22:\"primary_nav_text_color\";s:4:\"dark\";s:24:\"secondary_nav_text_color\";s:5:\"light\";s:15:\"hide_fixed_logo\";s:0:\"\";s:21:\"minimized_menu_height\";s:2:\"40\";s:27:\"fixed_primary_nav_font_size\";s:2:\"14\";s:20:\"fixed_primary_nav_bg\";s:7:\"#ffffff\";s:22:\"fixed_secondary_nav_bg\";s:7:\"#2ea3f2\";s:15:\"fixed_menu_link\";s:15:\"rgba(0,0,0,0.6)\";s:25:\"fixed_secondary_menu_link\";s:7:\"#ffffff\";s:22:\"fixed_menu_link_active\";s:7:\"#2ea3f2\";s:12:\"phone_number\";s:0:\"\";s:12:\"header_email\";s:0:\"\";s:24:\"show_footer_social_icons\";s:2:\"on\";s:14:\"footer_columns\";s:1:\"4\";s:9:\"footer_bg\";s:7:\"#222222\";s:23:\"widget_header_font_size\";d:18;s:24:\"widget_header_font_style\";b:0;s:21:\"widget_body_font_size\";s:2:\"14\";s:23:\"widget_body_line_height\";s:3:\"1.7\";s:22:\"widget_body_font_style\";b:0;s:26:\"footer_widget_header_color\";s:7:\"#2ea3f2\";s:26:\"footer_widget_bullet_color\";s:7:\"#2ea3f2\";s:28:\"footer_menu_background_color\";s:22:\"rgba(255,255,255,0.05)\";s:22:\"footer_menu_text_color\";s:7:\"#bbbbbb\";s:29:\"footer_menu_active_link_color\";s:7:\"#2ea3f2\";s:26:\"footer_menu_letter_spacing\";s:1:\"0\";s:22:\"footer_menu_font_style\";b:0;s:21:\"footer_menu_font_size\";s:2:\"14\";s:27:\"bottom_bar_background_color\";s:16:\"rgba(0,0,0,0.32)\";s:21:\"bottom_bar_text_color\";s:7:\"#666666\";s:21:\"bottom_bar_font_style\";b:0;s:20:\"bottom_bar_font_size\";s:2:\"14\";s:27:\"bottom_bar_social_icon_size\";s:2:\"24\";s:28:\"bottom_bar_social_icon_color\";s:7:\"#666666\";s:29:\"disable_custom_footer_credits\";s:0:\"\";s:21:\"custom_footer_credits\";s:0:\"\";s:21:\"all_buttons_font_size\";s:2:\"20\";s:22:\"all_buttons_text_color\";s:0:\"\";s:20:\"all_buttons_bg_color\";s:13:\"rgba(0,0,0,0)\";s:24:\"all_buttons_border_width\";s:1:\"2\";s:24:\"all_buttons_border_color\";s:7:\"#ffffff\";s:25:\"all_buttons_border_radius\";s:1:\"3\";s:19:\"all_buttons_spacing\";s:1:\"0\";s:22:\"all_buttons_font_style\";s:0:\"\";s:16:\"all_buttons_font\";s:4:\"none\";s:16:\"all_buttons_icon\";s:3:\"yes\";s:25:\"all_buttons_selected_icon\";s:1:\"5\";s:22:\"all_buttons_icon_color\";s:7:\"#ffffff\";s:26:\"all_buttons_icon_placement\";s:5:\"right\";s:22:\"all_buttons_icon_hover\";s:3:\"yes\";s:28:\"all_buttons_text_color_hover\";s:0:\"\";s:26:\"all_buttons_bg_color_hover\";s:21:\"rgba(255,255,255,0.2)\";s:30:\"all_buttons_border_color_hover\";s:13:\"rgba(0,0,0,0)\";s:31:\"all_buttons_border_radius_hover\";b:0;s:25:\"all_buttons_spacing_hover\";b:0;s:12:\"divi_favicon\";s:0:\"\";}',	'yes'),
(159,	'widget_aboutmewidget',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(160,	'widget_adsensewidget',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(161,	'widget_advwidget',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(162,	'shop_catalog_image_size',	'a:3:{s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"400\";s:4:\"crop\";i:1;}',	'yes'),
(163,	'shop_single_image_size',	'a:3:{s:5:\"width\";s:3:\"510\";s:6:\"height\";s:4:\"9999\";s:4:\"crop\";i:0;}',	'yes'),
(164,	'shop_thumbnail_image_size',	'a:3:{s:5:\"width\";s:3:\"157\";s:6:\"height\";s:3:\"157\";s:4:\"crop\";i:1;}',	'yes'),
(165,	'et_support_site_id',	'nobL@7vJMXED2YR-fS=#',	'yes'),
(166,	'et_safe_mode_plugins_whitelist',	'a:8:{i:0;s:15:\"etdev/etdev.php\";i:1;s:15:\"bloom/bloom.php\";i:2;s:19:\"monarch/monarch.php\";i:3;s:29:\"divi-builder/divi-builder.php\";i:4;s:27:\"ari-adminer/ari-adminer.php\";i:5;s:31:\"query-monitor/query-monitor.php\";i:6;s:27:\"woocommerce/woocommerce.php\";i:7;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";}',	'yes'),
(167,	'et_support_center_installed',	'true',	'yes'),
(168,	'et_images_temp_folder',	'',	'yes'),
(169,	'et_schedule_clean_images_last_time',	'1579723049',	'yes'),
(170,	'et_bfb_settings',	'a:2:{s:10:\"enable_bfb\";s:2:\"on\";s:10:\"toggle_bfb\";s:2:\"on\";}',	'yes'),
(172,	'et_pb_builder_options',	'a:2:{i:0;b:0;s:35:\"email_provider_credentials_migrated\";b:1;}',	'yes'),
(173,	'et_support_center_setup_done',	'processed',	'yes'),
(174,	'WPLANG',	'',	'yes'),
(175,	'new_admin_email',	'c.gray@graygroupla.com',	'yes'),
(179,	'et_account_status',	'active',	'no'),
(180,	'_site_transient_et_update_themes',	'O:8:\"stdClass\":3:{s:7:\"checked\";a:2:{s:11:\"CovertAgent\";s:3:\"3.0\";s:4:\"Divi\";s:5:\"4.5.1\";}s:8:\"response\";a:1:{s:4:\"Divi\";a:4:{s:11:\"new_version\";s:4:\"4.23\";s:5:\"theme\";s:4:\"Divi\";s:3:\"url\";s:52:\"https://www.elegantthemes.com/api/changelog/divi.txt\";s:7:\"package\";s:145:\"https://www.elegantthemes.com/api/api_downloads.php?api_update=1&theme=Divi&api_key=fea83a232dc46fc1423f97a88be2adb15db5e21f&username=covertagent\";}}s:12:\"last_checked\";i:1698100273;}',	'no'),
(188,	'et_google_api_settings',	'a:3:{s:7:\"api_key\";s:0:\"\";s:26:\"enqueue_google_maps_script\";s:2:\"on\";s:16:\"use_google_fonts\";s:2:\"on\";}',	'yes'),
(189,	'et_automatic_updates_options',	'a:2:{s:8:\"username\";s:11:\"covertagent\";s:7:\"api_key\";s:40:\"fea83a232dc46fc1423f97a88be2adb15db5e21f\";}',	'no'),
(190,	'et_account_status_last_checked',	'1589820746',	'no'),
(288,	'max_file_size',	'67108864',	'yes'),
(307,	'filemanager_email_verified_1',	'yes',	'yes'),
(404,	'duplicate_page_options',	'a:4:{s:21:\"duplicate_post_status\";s:5:\"draft\";s:23:\"duplicate_post_redirect\";s:7:\"to_list\";s:21:\"duplicate_post_suffix\";s:0:\"\";s:21:\"duplicate_post_editor\";s:7:\"classic\";}',	'yes'),
(509,	'nav_menu_options',	'a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}',	'yes'),
(712,	'active_plugin_versions',	'a:2:{s:25:\"ca-members/Membership.php\";s:5:\"3.0.0\";s:19:\"ca-listings/rel.php\";s:5:\"2.4.6\";}',	'yes'),
(713,	'hji-membership-settings',	'a:1:{s:11:\"license-key\";s:0:\"\";}',	'yes'),
(719,	'external_updates-ca-members',	'O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1683747960;s:14:\"checkedVersion\";s:5:\"3.0.0\";s:6:\"update\";N;}',	'no'),
(724,	'hji_ridx_db_version',	'1.0',	'yes'),
(729,	'widget_promoted_listings_widget',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(730,	'widget_sm_quicksearch_widget',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(732,	'external_updates-ca-idx',	'O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1682429113;s:14:\"checkedVersion\";s:5:\"3.9.0\";s:6:\"update\";N;}',	'no'),
(733,	'hji_ridx_version',	'3.9.0',	'yes'),
(734,	'rel_general_settings',	'a:16:{s:13:\"singular_slug\";s:15:\"listing-details\";s:11:\"plural_slug\";s:8:\"listings\";s:16:\"listing_template\";s:20:\"ca-listing-sps-1.php\";s:17:\"listings_template\";s:22:\"ca-listing-results.php\";s:14:\"title_location\";s:9:\"In Header\";s:11:\"title_color\";s:7:\"#ffffff\";s:6:\"layout\";s:3:\"to2\";s:8:\"per_page\";s:2:\"24\";s:7:\"orderby\";s:9:\"_pl_price\";s:5:\"order\";s:4:\"DESC\";s:9:\"for_lease\";s:1:\"1\";s:8:\"for_sale\";s:1:\"1\";s:6:\"leased\";s:1:\"1\";s:4:\"sold\";s:1:\"1\";s:10:\"disclaimer\";s:0:\"\";s:20:\"listing_inquiry_form\";s:0:\"\";}',	'yes'),
(735,	'listing-taxonomies',	'a:7:{s:12:\"mainfeatures\";a:10:{s:6:\"labels\";a:12:{s:4:\"name\";s:13:\"Main Features\";s:13:\"singular_name\";s:12:\"Main Feature\";s:9:\"menu_name\";s:13:\"Main Features\";s:12:\"search_items\";s:20:\"Search Main Features\";s:13:\"popular_items\";s:21:\"Popular Main Features\";s:9:\"all_items\";s:17:\"All Main Features\";s:9:\"edit_item\";s:17:\"Edit Main Feature\";s:11:\"update_item\";s:19:\"Update Main Feature\";s:12:\"add_new_item\";s:20:\"Add New Main Feature\";s:13:\"new_item_name\";s:21:\"New Main Feature Name\";s:19:\"add_or_remove_items\";s:27:\"Add or Remove Main Features\";s:21:\"choose_from_most_used\";s:39:\"Choose from the most used Main Features\";}s:6:\"public\";b:1;s:17:\"show_in_nav_menus\";b:1;s:7:\"show_ui\";b:1;s:13:\"show_tagcloud\";b:1;s:12:\"hierarchical\";b:1;s:4:\"sort\";b:1;s:4:\"args\";a:1:{s:7:\"orderby\";s:10:\"term_order\";}s:7:\"rewrite\";a:2:{s:4:\"slug\";s:12:\"mainfeatures\";s:10:\"with_front\";b:0;}s:8:\"editable\";i:0;}s:8:\"features\";a:10:{s:6:\"labels\";a:12:{s:4:\"name\";s:19:\"Additional Features\";s:13:\"singular_name\";s:7:\"Feature\";s:9:\"menu_name\";s:19:\"Additional Features\";s:12:\"search_items\";s:26:\"Search Additional Features\";s:13:\"popular_items\";s:27:\"Popular Additional Features\";s:9:\"all_items\";s:23:\"All Additional Features\";s:9:\"edit_item\";s:12:\"Edit Feature\";s:11:\"update_item\";s:14:\"Update Feature\";s:12:\"add_new_item\";s:15:\"Add New Feature\";s:13:\"new_item_name\";s:16:\"New Feature Name\";s:19:\"add_or_remove_items\";s:33:\"Add or Remove Additional Features\";s:21:\"choose_from_most_used\";s:45:\"Choose from the most used Additional Features\";}s:6:\"public\";b:1;s:17:\"show_in_nav_menus\";b:1;s:7:\"show_ui\";b:1;s:13:\"show_tagcloud\";b:1;s:12:\"hierarchical\";b:1;s:4:\"sort\";b:1;s:4:\"args\";a:1:{s:7:\"orderby\";s:10:\"term_order\";}s:7:\"rewrite\";a:2:{s:4:\"slug\";s:8:\"features\";s:10:\"with_front\";b:0;}s:8:\"editable\";i:0;}s:12:\"listing-type\";a:10:{s:6:\"labels\";a:12:{s:4:\"name\";s:13:\"Listing Types\";s:13:\"singular_name\";s:12:\"Listing Type\";s:9:\"menu_name\";s:13:\"Listing Types\";s:12:\"search_items\";s:20:\"Search Listing Types\";s:13:\"popular_items\";s:21:\"Popular Listing Types\";s:9:\"all_items\";s:17:\"All Listing Types\";s:9:\"edit_item\";s:17:\"Edit Listing Type\";s:11:\"update_item\";s:19:\"Update Listing Type\";s:12:\"add_new_item\";s:20:\"Add New Listing Type\";s:13:\"new_item_name\";s:21:\"New Listing Type Name\";s:19:\"add_or_remove_items\";s:27:\"Add or Remove Listing Types\";s:21:\"choose_from_most_used\";s:39:\"Choose from the most used Listing Types\";}s:6:\"public\";b:1;s:17:\"show_in_nav_menus\";b:1;s:7:\"show_ui\";b:1;s:13:\"show_tagcloud\";b:1;s:12:\"hierarchical\";b:1;s:4:\"sort\";b:1;s:4:\"args\";a:1:{s:7:\"orderby\";s:10:\"term_order\";}s:7:\"rewrite\";a:2:{s:4:\"slug\";s:12:\"listing-type\";s:10:\"with_front\";b:0;}s:8:\"editable\";i:0;}s:13:\"property-type\";a:10:{s:6:\"labels\";a:12:{s:4:\"name\";s:14:\"Property Types\";s:13:\"singular_name\";s:13:\"Property Type\";s:9:\"menu_name\";s:14:\"Property Types\";s:12:\"search_items\";s:21:\"Search Property Types\";s:13:\"popular_items\";s:22:\"Popular Property Types\";s:9:\"all_items\";s:18:\"All Property Types\";s:9:\"edit_item\";s:18:\"Edit Property Type\";s:11:\"update_item\";s:20:\"Update Property Type\";s:12:\"add_new_item\";s:21:\"Add New Property Type\";s:13:\"new_item_name\";s:22:\"New Property Type Name\";s:19:\"add_or_remove_items\";s:28:\"Add or Remove Property Types\";s:21:\"choose_from_most_used\";s:40:\"Choose from the most used Property Types\";}s:6:\"public\";b:1;s:17:\"show_in_nav_menus\";b:1;s:7:\"show_ui\";b:1;s:13:\"show_tagcloud\";b:1;s:12:\"hierarchical\";b:1;s:4:\"sort\";b:1;s:4:\"args\";a:1:{s:7:\"orderby\";s:10:\"term_order\";}s:7:\"rewrite\";a:2:{s:4:\"slug\";s:13:\"property-type\";s:10:\"with_front\";b:0;}s:8:\"editable\";i:0;}s:4:\"city\";a:10:{s:6:\"labels\";a:12:{s:4:\"name\";s:6:\"Cities\";s:13:\"singular_name\";s:4:\"City\";s:9:\"menu_name\";s:6:\"Cities\";s:12:\"search_items\";s:13:\"Search Cities\";s:13:\"popular_items\";s:14:\"Popular Cities\";s:9:\"all_items\";s:10:\"All Cities\";s:9:\"edit_item\";s:9:\"Edit City\";s:11:\"update_item\";s:11:\"Update City\";s:12:\"add_new_item\";s:12:\"Add New City\";s:13:\"new_item_name\";s:13:\"New City Name\";s:19:\"add_or_remove_items\";s:20:\"Add or Remove Cities\";s:21:\"choose_from_most_used\";s:32:\"Choose from the most used Cities\";}s:6:\"public\";b:1;s:17:\"show_in_nav_menus\";b:1;s:7:\"show_ui\";b:1;s:13:\"show_tagcloud\";b:1;s:12:\"hierarchical\";b:1;s:4:\"sort\";b:1;s:4:\"args\";a:1:{s:7:\"orderby\";s:10:\"term_order\";}s:7:\"rewrite\";a:2:{s:4:\"slug\";s:4:\"city\";s:10:\"with_front\";b:0;}s:8:\"editable\";i:0;}s:12:\"neighborhood\";a:10:{s:6:\"labels\";a:12:{s:4:\"name\";s:13:\"Neighborhoods\";s:13:\"singular_name\";s:12:\"Neighborhood\";s:9:\"menu_name\";s:13:\"Neighborhoods\";s:12:\"search_items\";s:20:\"Search Neighborhoods\";s:13:\"popular_items\";s:21:\"Popular Neighborhoods\";s:9:\"all_items\";s:17:\"All Neighborhoods\";s:9:\"edit_item\";s:17:\"Edit Neighborhood\";s:11:\"update_item\";s:19:\"Update Neighborhood\";s:12:\"add_new_item\";s:20:\"Add New Neighborhood\";s:13:\"new_item_name\";s:21:\"New Neighborhood Name\";s:19:\"add_or_remove_items\";s:27:\"Add or Remove Neighborhoods\";s:21:\"choose_from_most_used\";s:39:\"Choose from the most used Neighborhoods\";}s:6:\"public\";b:1;s:17:\"show_in_nav_menus\";b:1;s:7:\"show_ui\";b:1;s:13:\"show_tagcloud\";b:1;s:12:\"hierarchical\";b:1;s:4:\"sort\";b:1;s:4:\"args\";a:1:{s:7:\"orderby\";s:10:\"term_order\";}s:7:\"rewrite\";a:2:{s:4:\"slug\";s:12:\"neighborhood\";s:10:\"with_front\";b:0;}s:8:\"editable\";i:0;}s:15:\"property-status\";a:10:{s:6:\"labels\";a:12:{s:4:\"name\";s:15:\"Property Status\";s:13:\"singular_name\";s:15:\"Property Status\";s:9:\"menu_name\";s:15:\"Property Status\";s:12:\"search_items\";s:22:\"Search Property Status\";s:13:\"popular_items\";s:23:\"Popular Property Status\";s:9:\"all_items\";s:19:\"All Property Status\";s:9:\"edit_item\";s:20:\"Edit Property Status\";s:11:\"update_item\";s:22:\"Update Property Status\";s:12:\"add_new_item\";s:23:\"Add New Property Status\";s:13:\"new_item_name\";s:24:\"New Property Status Name\";s:19:\"add_or_remove_items\";s:29:\"Add or Remove Property Status\";s:21:\"choose_from_most_used\";s:41:\"Choose from the most used Property Status\";}s:6:\"public\";b:1;s:17:\"show_in_nav_menus\";b:1;s:7:\"show_ui\";b:1;s:13:\"show_tagcloud\";b:1;s:12:\"hierarchical\";b:1;s:4:\"sort\";b:1;s:4:\"args\";a:1:{s:7:\"orderby\";s:10:\"term_order\";}s:7:\"rewrite\";a:2:{s:4:\"slug\";s:15:\"property-status\";s:10:\"with_front\";b:0;}s:8:\"editable\";i:0;}}',	'yes'),
(740,	'widget_property-search',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(741,	'widget_featured-listings',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(743,	'external_updates-ca-listings',	'O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1683747961;s:14:\"checkedVersion\";s:5:\"2.4.6\";s:6:\"update\";N;}',	'no'),
(744,	'gf_db_version',	'2.4.24',	'no'),
(745,	'rg_form_version',	'2.4.24',	'no'),
(746,	'gform_enable_background_updates',	'1',	'yes'),
(747,	'gform_pending_installation',	'',	'yes'),
(752,	'widget_gform_widget',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(753,	'gravityformsaddon_gravityformswebapi_version',	'1.0',	'yes'),
(754,	'gform_version_info',	'a:10:{s:12:\"is_valid_key\";b:0;s:6:\"reason\";s:7:\"expired\";s:7:\"version\";s:6:\"2.7.15\";s:3:\"url\";s:0:\"\";s:15:\"expiration_time\";i:1639699200;s:9:\"offerings\";a:74:{s:12:\"gravityforms\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:6:\"2.7.15\";s:14:\"version_latest\";s:8:\"2.7.15.2\";}s:17:\"gravityforms-beta\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:12:\"2.8.0-beta-1\";s:14:\"version_latest\";s:12:\"2.8.0-beta-1\";}s:21:\"gravityforms2checkout\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"2.1\";s:14:\"version_latest\";s:3:\"2.1\";}s:26:\"gravityformsactivecampaign\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"2.0\";s:14:\"version_latest\";s:5:\"2.0.1\";}s:32:\"gravityformsadvancedpostcreation\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.4.0\";s:14:\"version_latest\";s:5:\"1.4.0\";}s:20:\"gravityformsagilecrm\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.4\";s:14:\"version_latest\";s:5:\"1.4.1\";}s:19:\"gravityformsakismet\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.0\";s:14:\"version_latest\";s:3:\"1.0\";}s:24:\"gravityformsauthorizenet\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:4:\"2.11\";s:14:\"version_latest\";s:4:\"2.11\";}s:18:\"gravityformsaweber\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.0.0\";s:14:\"version_latest\";s:5:\"4.0.0\";}s:21:\"gravityformsbatchbook\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.3\";s:14:\"version_latest\";s:3:\"1.3\";}s:18:\"gravityformsbreeze\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.5\";s:14:\"version_latest\";s:5:\"1.5.1\";}s:27:\"gravityformscampaignmonitor\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"3.9\";s:14:\"version_latest\";s:5:\"3.9.1\";}s:20:\"gravityformscampfire\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.1\";s:14:\"version_latest\";s:5:\"1.2.2\";}s:22:\"gravityformscapsulecrm\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.6\";s:14:\"version_latest\";s:5:\"1.6.1\";}s:26:\"gravityformschainedselects\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.6\";s:14:\"version_latest\";s:3:\"1.6\";}s:31:\"gravityformschainedselects-beta\";a:3:{s:12:\"is_available\";b:0;s:7:\"version\";s:3:\"1.0\";s:14:\"version_latest\";s:12:\"1.0-beta-1.3\";}s:23:\"gravityformscleverreach\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.8\";s:14:\"version_latest\";s:3:\"1.8\";}s:15:\"gravityformscli\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:0:\"\";s:14:\"version_latest\";s:3:\"1.4\";}s:27:\"gravityformsconstantcontact\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.7\";s:14:\"version_latest\";s:3:\"1.7\";}s:31:\"gravityformsconversationalforms\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.1.0\";s:14:\"version_latest\";s:5:\"1.1.0\";}s:22:\"gravityformsconvertkit\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:0:\"\";s:14:\"version_latest\";s:10:\"1.0-beta-1\";}s:19:\"gravityformscoupons\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"3.2.0\";s:14:\"version_latest\";s:5:\"3.2.0\";}s:17:\"gravityformsdebug\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:0:\"\";s:14:\"version_latest\";s:10:\"1.0.beta12\";}s:19:\"gravityformsdropbox\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"3.1\";s:14:\"version_latest\";s:5:\"3.1.2\";}s:24:\"gravityformsdropbox-beta\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"2.0\";s:14:\"version_latest\";s:12:\"2.0-beta-1.1\";}s:24:\"gravityformsemailoctopus\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.2\";s:14:\"version_latest\";s:5:\"1.2.2\";}s:16:\"gravityformsemma\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.5\";s:14:\"version_latest\";s:5:\"1.5.2\";}s:22:\"gravityformsfreshbooks\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"2.8\";s:14:\"version_latest\";s:3:\"2.8\";}s:23:\"gravityformsgeolocation\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.1.0\";s:14:\"version_latest\";s:5:\"1.1.0\";}s:23:\"gravityformsgetresponse\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.7\";s:14:\"version_latest\";s:5:\"1.7.1\";}s:27:\"gravityformsgoogleanalytics\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.1.0\";s:14:\"version_latest\";s:5:\"2.1.1\";}s:21:\"gravityformsgutenberg\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:10:\"1.0-rc-1.4\";s:14:\"version_latest\";s:10:\"1.0-rc-1.5\";}s:21:\"gravityformshelpscout\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"2.1\";s:14:\"version_latest\";s:5:\"2.1.1\";}s:20:\"gravityformshighrise\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.3\";s:14:\"version_latest\";s:3:\"1.3\";}s:19:\"gravityformshipchat\";a:3:{s:12:\"is_available\";b:0;s:7:\"version\";s:3:\"1.2\";s:14:\"version_latest\";s:3:\"1.2\";}s:19:\"gravityformshubspot\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.9\";s:14:\"version_latest\";s:3:\"1.9\";}s:20:\"gravityformsicontact\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.5\";s:14:\"version_latest\";s:5:\"1.5.1\";}s:19:\"gravityformslogging\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.3\";s:14:\"version_latest\";s:5:\"1.3.1\";}s:19:\"gravityformsmadmimi\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.4\";s:14:\"version_latest\";s:5:\"1.4.1\";}s:21:\"gravityformsmailchimp\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"5.2\";s:14:\"version_latest\";s:5:\"5.2.1\";}s:19:\"gravityformsmailgun\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.3\";s:14:\"version_latest\";s:5:\"1.3.1\";}s:22:\"gravityformsmoderation\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.0\";s:14:\"version_latest\";s:5:\"1.0.2\";}s:18:\"gravityformsmollie\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.4.0\";s:14:\"version_latest\";s:5:\"1.4.0\";}s:26:\"gravityformspartialentries\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.7\";s:14:\"version_latest\";s:3:\"1.7\";}s:18:\"gravityformspaypal\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"3.5\";s:14:\"version_latest\";s:3:\"3.5\";}s:33:\"gravityformspaypalexpresscheckout\";a:3:{s:12:\"is_available\";b:0;s:7:\"version\";s:0:\"\";s:14:\"version_latest\";N;}s:29:\"gravityformspaypalpaymentspro\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"2.7\";s:14:\"version_latest\";s:3:\"2.7\";}s:21:\"gravityformspaypalpro\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.1\";s:14:\"version_latest\";s:5:\"1.8.4\";}s:20:\"gravityformspicatcha\";a:3:{s:12:\"is_available\";b:0;s:7:\"version\";s:3:\"2.0\";s:14:\"version_latest\";s:3:\"2.0\";}s:16:\"gravityformspipe\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.2\";s:14:\"version_latest\";s:5:\"1.3.1\";}s:17:\"gravityformspolls\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"4.1\";s:14:\"version_latest\";s:3:\"4.1\";}s:20:\"gravityformspostmark\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.3\";s:14:\"version_latest\";s:3:\"1.3\";}s:16:\"gravityformsppcp\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.8.0\";s:14:\"version_latest\";s:5:\"2.8.0\";}s:21:\"gravityformsppcp-beta\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:10:\"2.0-beta-3\";s:14:\"version_latest\";s:10:\"2.0-beta-3\";}s:24:\"gravityformsppcp-release\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"2.0\";s:14:\"version_latest\";s:5:\"2.0.2\";}s:16:\"gravityformsquiz\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"4.1\";s:14:\"version_latest\";s:3:\"4.1\";}s:21:\"gravityformsrecaptcha\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.2.0\";s:14:\"version_latest\";s:5:\"1.2.2\";}s:19:\"gravityformsrestapi\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:10:\"2.0-beta-2\";s:14:\"version_latest\";s:10:\"2.0-beta-2\";}s:20:\"gravityformssendgrid\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.5\";s:14:\"version_latest\";s:3:\"1.5\";}s:21:\"gravityformssignature\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"4.5\";s:14:\"version_latest\";s:3:\"4.5\";}s:17:\"gravityformsslack\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"2.0\";s:14:\"version_latest\";s:5:\"2.0.1\";}s:18:\"gravityformssquare\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.0.0\";s:14:\"version_latest\";s:5:\"2.0.0\";}s:18:\"gravityformsstripe\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"5.2.0\";s:14:\"version_latest\";s:5:\"5.2.1\";}s:23:\"gravityformsstripe-beta\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:10:\"5.0-beta-1\";s:14:\"version_latest\";s:10:\"5.0-beta-1\";}s:18:\"gravityformssurvey\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"3.8\";s:14:\"version_latest\";s:3:\"3.8\";}s:18:\"gravityformstrello\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"2.0\";s:14:\"version_latest\";s:5:\"2.0.1\";}s:21:\"gravityformsturnstile\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.0.0\";s:14:\"version_latest\";s:5:\"1.0.0\";}s:18:\"gravityformstwilio\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"2.9\";s:14:\"version_latest\";s:5:\"2.9.1\";}s:28:\"gravityformsuserregistration\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"5.2.0\";s:14:\"version_latest\";s:5:\"5.2.0\";}s:20:\"gravityformswebhooks\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.5\";s:14:\"version_latest\";s:3:\"1.5\";}s:18:\"gravityformszapier\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"4.2\";s:14:\"version_latest\";s:5:\"4.2.1\";}s:23:\"gravityformszapier-beta\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:10:\"4.0-beta-2\";s:14:\"version_latest\";s:10:\"4.0-beta-2\";}s:19:\"gravityformszohocrm\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"2.0\";s:14:\"version_latest\";s:5:\"2.0.1\";}s:11:\"gravitysmtp\";a:3:{s:12:\"is_available\";b:1;s:7:\"version\";s:11:\"1.0-alpha-5\";s:14:\"version_latest\";s:11:\"1.0-alpha-5\";}}s:9:\"is_active\";s:1:\"1\";s:12:\"product_code\";s:7:\"GFELITE\";s:14:\"version_latest\";s:8:\"2.7.15.2\";s:9:\"timestamp\";i:1698220615;}',	'no'),
(760,	'gravityformsaddon_gravityformssendgrid_version',	'1.4',	'yes'),
(766,	'rg_gforms_key',	'e6649231e0594503c95927fbf946f831',	'yes'),
(767,	'gf_site_key',	'f559849e-423c-404f-8347-d3cc1e33cb81',	'yes'),
(768,	'gf_site_secret',	'71cd4000-47be-453b-9341-4d6dda5407e1',	'yes'),
(769,	'rg_gforms_enable_akismet',	'0',	'yes'),
(770,	'rg_gforms_currency',	'USD',	'yes'),
(771,	'gform_enable_toolbar_menu',	'1',	'yes'),
(887,	'font-awesome',	'a:7:{s:6:\"usePro\";b:0;s:8:\"v4Compat\";b:1;s:10:\"technology\";s:7:\"webfont\";s:14:\"pseudoElements\";b:1;s:8:\"kitToken\";N;s:8:\"apiToken\";b:0;s:7:\"version\";s:6:\"5.13.0\";}',	'yes'),
(888,	'font-awesome-conflict-detection',	'a:2:{s:20:\"detectConflictsUntil\";i:0;s:19:\"unregisteredClients\";a:0:{}}',	'yes'),
(963,	'theme_mods_CovertAgent',	'a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:12:\"primary-menu\";i:7;}s:16:\"et_pb_css_synced\";s:3:\"yes\";s:39:\"et_updated_layouts_built_for_post_types\";s:3:\"yes\";s:18:\"custom_css_post_id\";i:437;}',	'yes'),
(1040,	'wpseo',	'a:26:{s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:25:\"ignore_indexation_warning\";b:1;s:29:\"indexation_warning_hide_until\";b:0;s:18:\"indexation_started\";b:0;s:7:\"version\";s:4:\"14.1\";s:16:\"previous_version\";s:0:\"\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:1;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1589856902;s:13:\"myyoast-oauth\";b:0;}',	'yes'),
(1041,	'wpseo_titles',	'a:135:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:23:\"is-media-purge-relevant\";b:0;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:14:\"person_logo_id\";i:0;s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:15:\"company_logo_id\";i:0;s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:13:\"title-project\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:16:\"metadesc-project\";s:0:\"\";s:15:\"noindex-project\";b:0;s:16:\"showdate-project\";b:0;s:26:\"display-metabox-pt-project\";b:1;s:26:\"post_types-project-maintax\";i:0;s:23:\"title-ptarchive-project\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-ptarchive-project\";s:0:\"\";s:25:\"bctitle-ptarchive-project\";s:0:\"\";s:25:\"noindex-ptarchive-project\";b:0;s:13:\"title-listing\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:16:\"metadesc-listing\";s:0:\"\";s:15:\"noindex-listing\";b:0;s:16:\"showdate-listing\";b:0;s:26:\"display-metabox-pt-listing\";b:1;s:26:\"post_types-listing-maintax\";i:0;s:23:\"title-ptarchive-listing\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-ptarchive-listing\";s:0:\"\";s:25:\"bctitle-ptarchive-listing\";s:0:\"\";s:25:\"noindex-ptarchive-listing\";b:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:26:\"title-tax-project_category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:29:\"metadesc-tax-project_category\";s:0:\"\";s:36:\"display-metabox-tax-project_category\";b:1;s:28:\"noindex-tax-project_category\";b:0;s:34:\"taxonomy-project_category-ptparent\";i:0;s:21:\"title-tax-project_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-project_tag\";s:0:\"\";s:31:\"display-metabox-tax-project_tag\";b:1;s:23:\"noindex-tax-project_tag\";b:0;s:29:\"taxonomy-project_tag-ptparent\";i:0;s:22:\"title-tax-mainfeatures\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:25:\"metadesc-tax-mainfeatures\";s:0:\"\";s:32:\"display-metabox-tax-mainfeatures\";b:1;s:24:\"noindex-tax-mainfeatures\";b:0;s:30:\"taxonomy-mainfeatures-ptparent\";i:0;s:18:\"title-tax-features\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-features\";s:0:\"\";s:28:\"display-metabox-tax-features\";b:1;s:20:\"noindex-tax-features\";b:0;s:26:\"taxonomy-features-ptparent\";i:0;s:22:\"title-tax-listing-type\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:25:\"metadesc-tax-listing-type\";s:0:\"\";s:32:\"display-metabox-tax-listing-type\";b:1;s:24:\"noindex-tax-listing-type\";b:0;s:30:\"taxonomy-listing-type-ptparent\";i:0;s:23:\"title-tax-property-type\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-tax-property-type\";s:0:\"\";s:33:\"display-metabox-tax-property-type\";b:1;s:25:\"noindex-tax-property-type\";b:0;s:31:\"taxonomy-property-type-ptparent\";i:0;s:14:\"title-tax-city\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:17:\"metadesc-tax-city\";s:0:\"\";s:24:\"display-metabox-tax-city\";b:1;s:16:\"noindex-tax-city\";b:0;s:22:\"taxonomy-city-ptparent\";i:0;s:22:\"title-tax-neighborhood\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:25:\"metadesc-tax-neighborhood\";s:0:\"\";s:32:\"display-metabox-tax-neighborhood\";b:1;s:24:\"noindex-tax-neighborhood\";b:0;s:30:\"taxonomy-neighborhood-ptparent\";i:0;s:25:\"title-tax-property-status\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-tax-property-status\";s:0:\"\";s:35:\"display-metabox-tax-property-status\";b:1;s:27:\"noindex-tax-property-status\";b:0;s:33:\"taxonomy-property-status-ptparent\";i:0;}',	'yes'),
(1042,	'wpseo_social',	'a:19:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}',	'yes'),
(1043,	'wpseo_flush_rewrite',	'1',	'yes'),
(1044,	'yoast_migrations_free',	'a:1:{s:7:\"version\";s:4:\"14.1\";}',	'yes'),
(1055,	'wpseo_ryte',	'a:2:{s:6:\"status\";i:1;s:10:\"last_fetch\";i:1657594507;}',	'yes'),
(1088,	'wpseo_sitemap_1_cache_validator',	'5lxWF',	'no'),
(1089,	'wpseo_sitemap_page_cache_validator',	'4JMU',	'no'),
(1100,	'wpseo_sitemap_cache_validator_global',	'5nFba',	'no'),
(1101,	'category_children',	'a:0:{}',	'yes'),
(1104,	'wpseo_sitemap_project_cache_validator',	'5nMno',	'no'),
(1109,	'wpseo_sitemap_category_cache_validator',	'5lxWV',	'no'),
(1112,	'wpseo_sitemap_author_cache_validator',	'5GcM6',	'no'),
(1115,	'wpseo_sitemap_post_cache_validator',	'5lxXc',	'no'),
(1118,	'wpseo_sitemap_listing_cache_validator',	'6gcrm',	'no'),
(1226,	'wpseo_sitemap_scope_cache_validator',	'5LCHT',	'no'),
(1227,	'wpseo_sitemap_layout_type_cache_validator',	'5LCHE',	'no'),
(1228,	'wpseo_sitemap_module_width_cache_validator',	'5LCIa',	'no'),
(1909,	'hjpl_general_settings',	'a:13:{s:13:\"listings_slug\";s:16:\"property-details\";s:22:\"search_results_page_id\";s:3:\"827\";s:9:\"grid_size\";s:3:\"to2\";s:9:\"grid_rows\";s:1:\"5\";s:11:\"leads_email\";s:21:\"derek@covertagent.com\";s:6:\"form_1\";s:0:\"\";s:6:\"form_2\";s:0:\"\";s:8:\"button_1\";s:17:\"Request More Info\";s:8:\"button_2\";s:18:\"Schedule a Showing\";s:22:\"button_listing_details\";s:21:\"View Property Details\";s:13:\"button_search\";s:10:\"Search Now\";s:21:\"button_ad_call2action\";s:16:\"View More Photos\";s:16:\"results_per_page\";i:10;}',	'yes'),
(2340,	'aft_options',	'a:1:{s:18:\"checked_taxonomies\";a:8:{s:8:\"category\";s:8:\"category\";s:8:\"post_tag\";s:8:\"post_tag\";s:8:\"features\";s:8:\"features\";s:12:\"listing-type\";s:12:\"listing-type\";s:13:\"property-type\";s:13:\"property-type\";s:4:\"city\";s:4:\"city\";s:12:\"neighborhood\";s:12:\"neighborhood\";s:15:\"property-status\";s:15:\"property-status\";}}',	'yes'),
(2343,	'_category_image12',	'https://graygroupla.com/wp-content/uploads/2020/05/North_Beverly_Park_Overlook.jpg',	'yes'),
(2344,	'property-type_children',	'a:0:{}',	'yes'),
(2345,	'_category_image13',	'https://graygroupla.com/wp-content/uploads/2020/05/North_Beverly_Park_Overlook.jpg',	'yes'),
(2347,	'_category_image14',	'https://graygroupla.com/wp-content/uploads/2020/05/North_Beverly_Park_Overlook.jpg',	'yes'),
(2349,	'_category_image15',	'https://graygroupla.com/wp-content/uploads/2020/05/North_Beverly_Park_Overlook.jpg',	'yes'),
(2356,	'wpseo_sitemap_property-status_cache_validator',	'6gcrR',	'no'),
(2399,	'wpseo_sitemap_property-type_cache_validator',	'6gcrC',	'no'),
(2407,	'mainfeatures_children',	'a:0:{}',	'yes'),
(2408,	'features_children',	'a:0:{}',	'yes'),
(2409,	'listing-type_children',	'a:0:{}',	'yes'),
(2410,	'city_children',	'a:0:{}',	'yes'),
(2411,	'neighborhood_children',	'a:0:{}',	'yes'),
(2497,	'wpseo_sitemap_431_cache_validator',	'5MYpa',	'no'),
(2764,	'layout_category_children',	'a:0:{}',	'yes'),
(2816,	'wpseo_sitemap_435_cache_validator',	'6mh2g',	'no'),
(2909,	'property-status_children',	'a:0:{}',	'yes'),
(2948,	'wpseo_sitemap_1102_cache_validator',	'5sLqR',	'no'),
(3044,	'CA_acent_color',	'#000000',	'yes'),
(3045,	'CA_font_color',	'#FFFFFF',	'yes'),
(3046,	'CA_upload_image',	'https://graygroupla.com/wp-content/uploads/2020/01/graygrp-all.png',	'yes'),
(3047,	'CA_upload_p_image',	'https://graygroupla.com/wp-content/uploads/2020/03/chris-gray.jpg',	'yes'),
(3048,	'CA_message',	'Hi,\n\nMy name is Chris Gray, I am your local real estate expert.  Above is just an estimate based on recent local sales.  With more specific knowledge about your property, I can provide a much more in-depth analysis along with support and guidance to help you negotiate the highest price for your home.\n\nContact me for a no-obligation consultation today.',	'yes'),
(3049,	'CA_contact_info',	'Chris Gray\n<a href=\\\"mailto:c.gray@graygroupLA.com\\\">c.gray@graygroupLA.com</a>\n<a href=\\\"https://gaygroupla.com\\\">GrayGroupLA.com</a>',	'yes'),
(3050,	'CA_form_title',	'What\\\'s Your Home Worth?',	'yes'),
(3052,	'wpseo_sitemap_attachment_cache_validator',	'5O9pv',	'no'),
(3192,	'wpseo_sitemap_148_cache_validator',	'6aksx',	'no'),
(3791,	'wordfence_ls_version',	'1.0.11',	'yes'),
(3792,	'wordfence_version',	'7.7.1',	'yes'),
(3793,	'wordfence_case',	'1',	'yes'),
(3794,	'wordfence_installed',	'1',	'yes'),
(3795,	'rewrite_rules',	'a:288:{s:10:\"project/?$\";s:27:\"index.php?post_type=project\";s:40:\"project/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:35:\"project/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:27:\"project/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=project&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:56:\"layout_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=layout_category&term=$matches[1]&feed=$matches[2]\";s:51:\"layout_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=layout_category&term=$matches[1]&feed=$matches[2]\";s:32:\"layout_category/([^/]+)/embed/?$\";s:62:\"index.php?taxonomy=layout_category&term=$matches[1]&embed=true\";s:44:\"layout_category/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?taxonomy=layout_category&term=$matches[1]&paged=$matches[2]\";s:26:\"layout_category/([^/]+)/?$\";s:51:\"index.php?taxonomy=layout_category&term=$matches[1]\";s:52:\"layout_pack/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=layout_pack&term=$matches[1]&feed=$matches[2]\";s:47:\"layout_pack/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=layout_pack&term=$matches[1]&feed=$matches[2]\";s:28:\"layout_pack/([^/]+)/embed/?$\";s:58:\"index.php?taxonomy=layout_pack&term=$matches[1]&embed=true\";s:40:\"layout_pack/([^/]+)/page/?([0-9]{1,})/?$\";s:65:\"index.php?taxonomy=layout_pack&term=$matches[1]&paged=$matches[2]\";s:22:\"layout_pack/([^/]+)/?$\";s:47:\"index.php?taxonomy=layout_pack&term=$matches[1]\";s:52:\"layout_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=layout_type&term=$matches[1]&feed=$matches[2]\";s:47:\"layout_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=layout_type&term=$matches[1]&feed=$matches[2]\";s:28:\"layout_type/([^/]+)/embed/?$\";s:58:\"index.php?taxonomy=layout_type&term=$matches[1]&embed=true\";s:40:\"layout_type/([^/]+)/page/?([0-9]{1,})/?$\";s:65:\"index.php?taxonomy=layout_type&term=$matches[1]&paged=$matches[2]\";s:22:\"layout_type/([^/]+)/?$\";s:47:\"index.php?taxonomy=layout_type&term=$matches[1]\";s:46:\"scope/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?taxonomy=scope&term=$matches[1]&feed=$matches[2]\";s:41:\"scope/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?taxonomy=scope&term=$matches[1]&feed=$matches[2]\";s:22:\"scope/([^/]+)/embed/?$\";s:52:\"index.php?taxonomy=scope&term=$matches[1]&embed=true\";s:34:\"scope/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?taxonomy=scope&term=$matches[1]&paged=$matches[2]\";s:16:\"scope/([^/]+)/?$\";s:41:\"index.php?taxonomy=scope&term=$matches[1]\";s:53:\"module_width/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?taxonomy=module_width&term=$matches[1]&feed=$matches[2]\";s:48:\"module_width/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?taxonomy=module_width&term=$matches[1]&feed=$matches[2]\";s:29:\"module_width/([^/]+)/embed/?$\";s:59:\"index.php?taxonomy=module_width&term=$matches[1]&embed=true\";s:41:\"module_width/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?taxonomy=module_width&term=$matches[1]&paged=$matches[2]\";s:23:\"module_width/([^/]+)/?$\";s:48:\"index.php?taxonomy=module_width&term=$matches[1]\";s:40:\"et_pb_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"et_pb_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"et_pb_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"et_pb_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"et_pb_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"et_pb_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"et_pb_layout/([^/]+)/embed/?$\";s:60:\"index.php?post_type=et_pb_layout&name=$matches[1]&embed=true\";s:33:\"et_pb_layout/([^/]+)/trackback/?$\";s:54:\"index.php?post_type=et_pb_layout&name=$matches[1]&tb=1\";s:41:\"et_pb_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:67:\"index.php?post_type=et_pb_layout&name=$matches[1]&paged=$matches[2]\";s:48:\"et_pb_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?post_type=et_pb_layout&name=$matches[1]&cpage=$matches[2]\";s:37:\"et_pb_layout/([^/]+)(?:/([0-9]+))?/?$\";s:66:\"index.php?post_type=et_pb_layout&name=$matches[1]&page=$matches[2]\";s:29:\"et_pb_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"et_pb_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"et_pb_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"et_pb_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"et_pb_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"et_pb_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"project/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"project/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"project/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"project/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"project/([^/]+)/embed/?$\";s:40:\"index.php?project=$matches[1]&embed=true\";s:28:\"project/([^/]+)/trackback/?$\";s:34:\"index.php?project=$matches[1]&tb=1\";s:48:\"project/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:43:\"project/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:36:\"project/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&paged=$matches[2]\";s:43:\"project/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&cpage=$matches[2]\";s:32:\"project/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?project=$matches[1]&page=$matches[2]\";s:24:\"project/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"project/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"project/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"project/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"project_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:52:\"project_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:33:\"project_category/([^/]+)/embed/?$\";s:49:\"index.php?project_category=$matches[1]&embed=true\";s:45:\"project_category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?project_category=$matches[1]&paged=$matches[2]\";s:27:\"project_category/([^/]+)/?$\";s:38:\"index.php?project_category=$matches[1]\";s:52:\"project_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:47:\"project_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:28:\"project_tag/([^/]+)/embed/?$\";s:44:\"index.php?project_tag=$matches[1]&embed=true\";s:40:\"project_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project_tag=$matches[1]&paged=$matches[2]\";s:22:\"project_tag/([^/]+)/?$\";s:33:\"index.php?project_tag=$matches[1]\";s:33:\"email/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"email/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"email/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"email/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"email/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"email/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"email/([^/]+)/embed/?$\";s:38:\"index.php?email=$matches[1]&embed=true\";s:26:\"email/([^/]+)/trackback/?$\";s:32:\"index.php?email=$matches[1]&tb=1\";s:34:\"email/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?email=$matches[1]&paged=$matches[2]\";s:41:\"email/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?email=$matches[1]&cpage=$matches[2]\";s:30:\"email/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?email=$matches[1]&page=$matches[2]\";s:22:\"email/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"email/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"email/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"email/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"email/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"email/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"sms/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"sms/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"sms/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"sms/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"sms/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"sms/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:20:\"sms/([^/]+)/embed/?$\";s:36:\"index.php?sms=$matches[1]&embed=true\";s:24:\"sms/([^/]+)/trackback/?$\";s:30:\"index.php?sms=$matches[1]&tb=1\";s:32:\"sms/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?sms=$matches[1]&paged=$matches[2]\";s:39:\"sms/([^/]+)/comment-page-([0-9]{1,})/?$\";s:43:\"index.php?sms=$matches[1]&cpage=$matches[2]\";s:28:\"sms/([^/]+)(?:/([0-9]+))?/?$\";s:42:\"index.php?sms=$matches[1]&page=$matches[2]\";s:20:\"sms/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:30:\"sms/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:50:\"sms/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\"sms/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\"sms/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:26:\"sms/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_theme_builder/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_theme_builder/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_theme_builder/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_builder/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_builder/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_theme_builder/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_theme_builder/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_theme_builder&name=$matches[1]&embed=true\";s:37:\"et_theme_builder/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_theme_builder&name=$matches[1]&tb=1\";s:45:\"et_theme_builder/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_builder&name=$matches[1]&paged=$matches[2]\";s:52:\"et_theme_builder/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_builder&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_theme_builder/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_theme_builder&name=$matches[1]&page=$matches[2]\";s:33:\"et_theme_builder/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_theme_builder/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_theme_builder/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_builder/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_builder/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_theme_builder/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"et_template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"et_template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"et_template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"et_template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"et_template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"et_template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"et_template/([^/]+)/embed/?$\";s:59:\"index.php?post_type=et_template&name=$matches[1]&embed=true\";s:32:\"et_template/([^/]+)/trackback/?$\";s:53:\"index.php?post_type=et_template&name=$matches[1]&tb=1\";s:40:\"et_template/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?post_type=et_template&name=$matches[1]&paged=$matches[2]\";s:47:\"et_template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:66:\"index.php?post_type=et_template&name=$matches[1]&cpage=$matches[2]\";s:36:\"et_template/([^/]+)(?:/([0-9]+))?/?$\";s:65:\"index.php?post_type=et_template&name=$matches[1]&page=$matches[2]\";s:28:\"et_template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"et_template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"et_template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"et_template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"et_template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"et_template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_header_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_header_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_header_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_header_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_header_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_header_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_header_layout/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_header_layout&name=$matches[1]&embed=true\";s:37:\"et_header_layout/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_header_layout&name=$matches[1]&tb=1\";s:45:\"et_header_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_header_layout&name=$matches[1]&paged=$matches[2]\";s:52:\"et_header_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_header_layout&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_header_layout/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_header_layout&name=$matches[1]&page=$matches[2]\";s:33:\"et_header_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_header_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_header_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_header_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_header_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_header_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"et_body_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"et_body_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"et_body_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"et_body_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"et_body_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"et_body_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"et_body_layout/([^/]+)/embed/?$\";s:62:\"index.php?post_type=et_body_layout&name=$matches[1]&embed=true\";s:35:\"et_body_layout/([^/]+)/trackback/?$\";s:56:\"index.php?post_type=et_body_layout&name=$matches[1]&tb=1\";s:43:\"et_body_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?post_type=et_body_layout&name=$matches[1]&paged=$matches[2]\";s:50:\"et_body_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:69:\"index.php?post_type=et_body_layout&name=$matches[1]&cpage=$matches[2]\";s:39:\"et_body_layout/([^/]+)(?:/([0-9]+))?/?$\";s:68:\"index.php?post_type=et_body_layout&name=$matches[1]&page=$matches[2]\";s:31:\"et_body_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"et_body_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"et_body_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"et_body_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"et_body_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"et_body_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_footer_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_footer_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_footer_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_footer_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_footer_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_footer_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_footer_layout/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_footer_layout&name=$matches[1]&embed=true\";s:37:\"et_footer_layout/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_footer_layout&name=$matches[1]&tb=1\";s:45:\"et_footer_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_footer_layout&name=$matches[1]&paged=$matches[2]\";s:52:\"et_footer_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_footer_layout&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_footer_layout/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_footer_layout&name=$matches[1]&page=$matches[2]\";s:33:\"et_footer_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_footer_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_footer_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_footer_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_footer_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_footer_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=7&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}',	'yes'),
(3796,	'wordfenceActivated',	'1',	'yes'),
(3797,	'wf_plugin_act_error',	'',	'yes'),
(3815,	'rg_gforms_captcha_public_key',	'6Levc_0UAAAAAMZgaKQ_7ZWYGUlWeDsrSRlf1bHw',	'yes'),
(3816,	'rg_gforms_captcha_private_key',	'6Levc_0UAAAAAFchkglpXEoyc0UqECFNFcXaCybq',	'yes'),
(3817,	'rg_gforms_captcha_type',	'invisible',	'yes'),
(3818,	'gform_recaptcha_keys_status',	'1',	'yes'),
(3819,	'rg_gforms_message',	'<!--GFM-->',	'yes'),
(5119,	'wordfence_syncAttackDataAttempts',	'0',	'no'),
(5120,	'wordfence_syncingAttackData',	'0',	'no'),
(5121,	'wordfence_lastSyncAttackData',	'1698245190',	'no'),
(6904,	'wpseo_sitemap_119697_cache_validator',	'7zUF',	'no'),
(6929,	'wpseo_sitemap_119724_cache_validator',	'6Nbv',	'no'),
(7630,	'wpseo_sitemap_home_slider_cache_validator',	'2AT5k',	'no'),
(7637,	'wpseo_sitemap_portfolio_cache_validator',	'2AVNJ',	'no'),
(7640,	'wpseo_sitemap_testimonial_cache_validator',	'2AX2M',	'no'),
(8383,	'wpseo_sitemap_263_cache_validator',	'6cxlF',	'no'),
(8384,	'wpseo_sitemap_158_cache_validator',	'6cxmI',	'no'),
(9361,	'external_updates-ca-idx.',	'O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1592756854;s:14:\"checkedVersion\";s:5:\"3.9.0\";s:6:\"update\";N;}',	'no'),
(9484,	'hji-google-api',	'a:1:{s:14:\"google-api-key\";s:39:\"AIzaSyBwYHttWE6_lJHmh4ViKJxaxGm882kjfvc\";}',	'yes'),
(10044,	'wpseo_sitemap_161_cache_validator',	'6cUTB',	'no'),
(14087,	'wpseo_sitemap_1095_cache_validator',	'6cqHq',	'no'),
(14836,	'gf_previous_db_version',	'2.4.23',	'yes'),
(14837,	'gf_upgrade_lock',	'',	'yes'),
(14838,	'gform_sticky_admin_messages',	'a:0:{}',	'yes'),
(24194,	'adminhash',	'a:2:{s:4:\"hash\";s:32:\"4e1d8513e18b682b6e2ee1b0afab7fd7\";s:8:\"newemail\";s:22:\"c.gray@graygroupla.com\";}',	'yes'),
(27220,	'wpseo_sitemap_120106_cache_validator',	'6P1Dp',	'no'),
(27229,	'wpseo_sitemap_1104_cache_validator',	'6PqD2',	'no'),
(29475,	'wpseo_sitemap_1101_cache_validator',	'6cBgx',	'no'),
(29476,	'wpseo_sitemap_1100_cache_validator',	'6cBhp',	'no'),
(29477,	'wpseo_sitemap_1099_cache_validator',	'6cBhJ',	'no'),
(33434,	'gform_email_count',	'650',	'yes'),
(34500,	'wpseo_sitemap_119241_cache_validator',	'5Zcoc',	'no'),
(35141,	'wpseo_sitemap_sms_cache_validator',	'2573',	'no'),
(35145,	'wpseo_sitemap_email_cache_validator',	'2Lpgg',	'no'),
(43363,	'wpseo_sitemap_120253_cache_validator',	'5jkYv',	'no'),
(43897,	'_site_transient_font-awesome-releases',	'a:2:{s:12:\"refreshed_at\";i:1610138853;s:4:\"data\";a:2:{s:6:\"latest\";s:6:\"5.15.1\";s:8:\"releases\";a:39:{s:5:\"5.0.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-VVoO3UHXsmXwXvf1kJx2jV3b1LbOfTqKL46DdeLG8z4pImkQ4GAP9GMy+MxHMDYG\";s:14:\"css/brands.css\";s:71:\"sha384-JT52EiskN0hkvVxJA8d2wg8W/tLxrC02M4u5+YAezNnBlY/N2yy3X51pKC1QaPkw\";s:19:\"css/fontawesome.css\";s:71:\"sha384-7mC9VNNEUg5vt0kVQGblkna/29L8CpTJ5fkpo0nlmTbfCoDXyuK/gPO3wx8bglOz\";s:15:\"css/regular.css\";s:71:\"sha384-JZ2w5NHrKZS6hqVAVlhUO3eHPVzjDZqOpWBZZ6opcmMwVjN7uoagKSSftrq8F0pn\";s:13:\"css/solid.css\";s:71:\"sha384-TQW9cJIp+U8M7mByg5ZKUQoIxj0ac36aOpNzqQ04HpwyrJivS38EQsKHO2rR5eit\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-X1ZQAmDHBeo7eaAJwWMyyA3mva9mMK10CpRFvX8PejR0XIUjwvGDqr2TwJqwbH9S\";s:9:\"js/all.js\";s:71:\"sha384-2CD5KZ3lSO1FK9XJ2hsLsEPy5/TBISgKIk2NSEcS03GbEnWEfhzd0x6DBIkqgPN1\";s:12:\"js/brands.js\";s:71:\"sha384-i3UPn8g8uJGiS6R/++68nHyfYAnr/lE/biTuWYbya2dONccicnZZPlAH6P8EWf28\";s:17:\"js/fontawesome.js\";s:71:\"sha384-tqpP2rDLsdWkeBrG3Jachyp0yzl/pmhnsdV88ySUFZATuziAnHWsHRSS97l5D9jn\";s:13:\"js/regular.js\";s:71:\"sha384-hXqI+wajk6jJu2DXwf2oqBg6q5+HqXM5yz9smX94pDjiLzH81gAuVtjter66i1Ct\";s:11:\"js/solid.js\";s:71:\"sha384-kbPfTyGdGugnvSKEBJCd6+vYipOQ6a+2np5O4Ty3sW7tgI0MpwPyAh+QwUpMujV9\";s:14:\"js/v4-shims.js\";s:71:\"sha384-BRge2B8T+0rmvB/KszFfdQ0PDvPnhV2J80JMKrnq21Fq6tHeKFhSIrdoroXvk7eB\";}s:3:\"pro\";a:0:{}}}s:5:\"5.0.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-bJB2Wn8ZuuMwYA12t6nmPqVTqT64ruKTAWqdxs/Oal3vexA7RPAo3FtVU5hIil2E\";s:14:\"css/brands.css\";s:71:\"sha384-F8vNf2eNIHep58ofQztLhhWsZXaTzzfZRqFfWmh7Cup7LqrF0HCtB6UCAIIkZZYZ\";s:19:\"css/fontawesome.css\";s:71:\"sha384-CTTGZltCsihOiEwOCbT7p1lhij8kYk6lapCladmNzxj4yXj/AKp6q3+CRoNN3UCG\";s:15:\"css/regular.css\";s:71:\"sha384-GtLUznQ3nMgus15JP1pAE2UH9HAQi8gjQTNfIT+Gq6zFPeeq3y+Xtxt5HUBFF0YO\";s:13:\"css/solid.css\";s:71:\"sha384-WEKepgUDOaHRK2/r+qA7W/Srd+36IIOmBm/+wm9aSz6acYC0LkyM9UJElLVNy95T\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-sV6Qj6KRPF7HrXfo5NK0evVt+YbNxUuGZU2udYKDAxwxPVTuEE6lofcZJhRMK4WT\";s:9:\"js/all.js\";s:71:\"sha384-xiGKJ+4CP2p2WkTifyjHDeZVAg1zBrnJV8LU33N7J+5BWp1biPcSpEJJY7hFiRLn\";s:12:\"js/brands.js\";s:71:\"sha384-V+scQ15NnQuKVajRBsSery7bV87d0xDAoCs4pB8ZcwW74+zzW5CkgRmIFOYw8kKX\";s:17:\"js/fontawesome.js\";s:71:\"sha384-CxMnuVDquTXcsJnW1rAfSm4uzGr12HENF1oe+JRZm4jcQDerJ6VeA1XLvAso396r\";s:13:\"js/regular.js\";s:71:\"sha384-ihKlq3j4PocIYMPkNra+ieEVsLuFzj4rp1yjn3jq+La7r4G9kf9COpWfOI8SGapM\";s:11:\"js/solid.js\";s:71:\"sha384-KDEuZV2OBU0Q264kBX2Idu9gYr5z/fQrtvUsKfuKGEDkDxV0GBVN/qi3QoLZPmbJ\";s:14:\"js/v4-shims.js\";s:71:\"sha384-0nloDHslShcnKvH94Zv8nb0zPlzTFCzfZGx9YxR2ngUWs9HXXHVx1PUQw0u9/7LE\";}s:3:\"pro\";a:0:{}}}s:5:\"5.0.3\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-KFTzeUQSHjcfuC8qqdFm+laWVqpkucx/3uXo41hhKQzUEtbNnNSk8KEEBZ+2lEQy\";s:14:\"css/brands.css\";s:71:\"sha384-J6h7hpR0mfr79Ck/ZfDrhN14FnkbkLbd+mm0yTw5spSpK08yOK/AB9IRR/Dcg8EJ\";s:19:\"css/fontawesome.css\";s:71:\"sha384-l2oTZy4pLseT/J6oW0mwsjKPhjpTctOfU191uVonzezZiqw9PPcz4AMKsIAeyR4P\";s:15:\"css/regular.css\";s:71:\"sha384-cDXlx+8npD3wa2ahyeSZvsi9VlRrMmJVIB1rpK7Ftyq4cppWM9d2mBhrlOqYBljt\";s:13:\"css/solid.css\";s:71:\"sha384-ioYc/tyAAvPTKdlEWH/BDO/Fn0RGAWisNzyfZNt74mHfA6UPN2tzjD6Nm4ieQfBR\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-bnoXyQHIAXdkrtQTtvuajtPgmWqHQ8657dQ4vzySapygDMqzijBpEq96AwgX2u4N\";s:9:\"js/all.js\";s:71:\"sha384-4OPaVeLgwRHdGJplmRGxGcoGYwxBAdR8Qr9z/Av7blRYPlRIPtjTygdtpQlD1HHv\";s:12:\"js/brands.js\";s:71:\"sha384-68dqWCRgViK/UsBTW5vGfntS6GdBDT5D4KWUBXTf6IkF2NFFD+X/0QNs0FZaIELt\";s:17:\"js/fontawesome.js\";s:71:\"sha384-sBtO3o3oG61AtAKrg74kfk50JP0YHcRTwOXgTeUobbJJBgYiCcmtkh784fmHww23\";s:13:\"js/regular.js\";s:71:\"sha384-J0ggktpCvzBHSxd/a8EBQgQDIWBtASK5rhHMvGWuR/UyjuPgX0iCAcb3OlfhvlQz\";s:11:\"js/solid.js\";s:71:\"sha384-DX1/9hggbc1yKVl40n2dNF9OzLf9ZPwZm87WzIW+FinkgjSq18PXpUxOL4I0iS1+\";s:14:\"js/v4-shims.js\";s:71:\"sha384-kysXtDCmCTYxM55rHL+9xPu6+Inoi3ZzZHvcxkXs+iPj5nymJKlauQdXyzubyD0b\";}s:3:\"pro\";a:0:{}}}s:5:\"5.0.4\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-DmABxgPhJN5jlTwituIyzIUk6oqyzf3+XuP7q3VfcWA2unxgim7OSSZKKf0KSsnh\";s:14:\"css/brands.css\";s:71:\"sha384-1beec9tTZuu+KrTudmvRnGpK81r78DKCAXdphCvdG+PR+n/WCczsYPqTBTvYsM7z\";s:19:\"css/fontawesome.css\";s:71:\"sha384-xdTUmhbcetyLRVL4PAriRajOve+/5pjOiy5sJABnhXMcRMVc9HI9s2KmOCjjDK/P\";s:15:\"css/regular.css\";s:71:\"sha384-nM5tBytXTc1HDZ/A3My2gNT2TxLk/M/5yFi0QrOxaZjBi7QpKUfA2QqT+fcSxSlg\";s:13:\"css/solid.css\";s:71:\"sha384-g2aKxiZcFezoVOq4MsjaxuBbSxSlXD/NRQ5GaPLfvCtcTLgP3fYZKKAGxCM/wMfe\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-MCR8qGTbdyK+hklwz1eKgGiAjT57F5HEJMs/uHRAwZ6GI5602TyGI89FyrbUwiIc\";s:9:\"js/all.js\";s:71:\"sha384-nVi8MaibAtVMFZb4R1zHUW/DsTJpG/YwPknbGABVOgk5s6Vhopl6XQD/pTCG/DKB\";s:12:\"js/brands.js\";s:71:\"sha384-dl3ONr32uA3YqpqKWzhXLs5k1YbKOn3dwiMbEP1S/XQMa3LPRwvJrhW7+lomL/uc\";s:17:\"js/fontawesome.js\";s:71:\"sha384-l7FyBM+wFIWpfmy8RYkWgEu/Me6Hrz98ijLu4nP3PkGbTtTCvtHB5ktI8hLEgEG3\";s:13:\"js/regular.js\";s:71:\"sha384-lwwoO5Gg19TptbILrLBjV28EVJ9RW3tD3cGyjCRn3OY9IuLua/YRlE47btZIXfMv\";s:11:\"js/solid.js\";s:71:\"sha384-4KkAk2UXMS9Xl3FoAAN43VJxRZ/emjElCz60xUTegPOZlbPLZGylvor2v7wQ0JNb\";s:14:\"js/v4-shims.js\";s:71:\"sha384-yfrMPoFcXUzdvECrvYRYE7wlxouXxjRSge5x6BlPPOb38tW4n0e8EW79RGU7VY0R\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-1RxicL8bcQJWgpr/clvtGVG7DVFJvDX/DVsJsbjKhXtdo8r5WVZQqB9AHTNPr08A\";s:14:\"css/brands.css\";s:71:\"sha384-sFwP5Zsnp6I4zQxUMPHvv8Bk16eEzU0YhaNbMCftDHPKDD+BR8WdXAHKL4xpipII\";s:19:\"css/fontawesome.css\";s:71:\"sha384-VFi8UvBDvM8muKO8ogMXi2j8vdJiu8hq1uxpX/NS8BsftBiJpheM5AuhFH1dvURx\";s:13:\"css/light.css\";s:71:\"sha384-4FGoKudkcpRXgx5UNFa5TxzaHUhnvCGFDeZKncEn9KJx/l07kcid3VbpwajrvrFW\";s:15:\"css/regular.css\";s:71:\"sha384-eyjlqgvgpHiWM0GoL4/hsTh22piTKmMTM+sfJYacddG2n9AEubqQB/w4CPJK1/1b\";s:13:\"css/solid.css\";s:71:\"sha384-TlWtvBj4TXNlpJC5Qq4aHel0R/dywVcP/6eOFC0qptQ71WWSxJCvuTajjGb1duS9\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-rHay3RzsgCtbjvDmBLThu6ESXlU4Al5STjlHSpNygnbeyt04OP1uKZVXB2Zy16+T\";s:9:\"js/all.js\";s:71:\"sha384-vV0064GQjt+TcoZxVPm/f6vyAivSNofFvOHKLWxcDl784Dzm9W4BBpoTvUG4vi5a\";s:12:\"js/brands.js\";s:71:\"sha384-/877azmwW/YhoBsPeM9dh61dNr5XGbuk24lyjPbFWyrPaZPyU2oxgOY6PE1OH4z4\";s:17:\"js/fontawesome.js\";s:71:\"sha384-7L9/YJQEf9kLPc6sdtoVIsuBNxCVi4OmHPcszcY685IJIcB52hgYoL1OiwTawJS/\";s:11:\"js/light.js\";s:71:\"sha384-iXxa9ExuZ0Fi2N2VO/buuWuAgYIUXNtOaJiKLa40Bjt43KJpzJdhg2TBHyBVqCPh\";s:13:\"js/regular.js\";s:71:\"sha384-YzSStfq1m16y1v5M97ViNRpiQUCVpagVVOkqlmww8otyjFkY6EXT4dShlKNuxRDu\";s:11:\"js/solid.js\";s:71:\"sha384-WJDZ/GI6pz1VoELs6i44T3f00fguksrLXIx3LXHdlaAzmOvX/mTK5j+qzHJdKejC\";s:14:\"js/v4-shims.js\";s:71:\"sha384-8XZ16R7aSGin4NRuv6gn5xfbsvad5H8LR41g48iduwkfZEqDgXlvUjkJKgxqZUiW\";}}}s:5:\"5.0.6\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-VY3F8aCQDLImi4L+tPX4XjtiJwXDwwyXNbkH7SHts0Jlo85t1R15MlXVBKLNx+dj\";s:14:\"css/brands.css\";s:71:\"sha384-rK0EPNdv8UCeRNPzX+96ARRlf9hZM+OukGceDTdbPH30DYcSI1x5QyBU7d2I2kHX\";s:19:\"css/fontawesome.css\";s:71:\"sha384-dbkYY2NmVwxaFrr4gq04oVh6w39ovmevsgD80Il1Od3hwpgREqyPb3XqbpaSwN4x\";s:15:\"css/regular.css\";s:71:\"sha384-HGbVnizaFNw8zW+vIol9xMwBFWdV7/k61278Zo1bnMy9dLmjv48D7rtpgYRTe5Pd\";s:13:\"css/solid.css\";s:71:\"sha384-GfC9nfESTZkjCPFbevBVig3FTd6wkjRRYMtj+qFgK8mMBvGIje2rrALgiBy6pwRL\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-U2b24h7gWqOYespg+vI5yiIn4ZYlTevT0N96xkGrw7ktP1gg9XwqEslsdTLJdlGg\";s:9:\"js/all.js\";s:71:\"sha384-0AJY8UERsBUKdWcyF3o2kisLKeIo6G4Tbd8Y6fbyw6qYmn4WBuqcvxokp8m2UzSD\";s:12:\"js/brands.js\";s:71:\"sha384-4iSpDug9fizYiQRPpPafdAh5NaF8yzNMjOvu3veWgaFm0iIo8y4vUi7f3Yyz5WP1\";s:17:\"js/fontawesome.js\";s:71:\"sha384-rttr/ldR2uHigckjTCjMDe47ySeFVaL3Q7xUkJZir56u8Z8h/XnHJXHocgyfb25F\";s:13:\"js/regular.js\";s:71:\"sha384-G375DXNEVfALvsggywPWDYrRxNOvXaCYt/kiq/GXmbaDW8/B0XtbC8iuLpXXm1jF\";s:11:\"js/solid.js\";s:71:\"sha384-U0ZJ7q5xbT8hEoRqj61HzpvsqNOQ8bsHY2VqSRPqGOzjHXmmV70Aw+DBC/PT00p4\";s:14:\"js/v4-shims.js\";s:71:\"sha384-L8zntmMOcCbOxXiL5Rjn6ubB7KunZiQ8U3bb9x6FFTGDEvVEESW9n+x49jm34K3W\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-ldFHeX3xCFvM4uf7m0mCMIoCPVwM71jopwqLZRldf+ojynoGVSxDiphfScLukkwO\";s:14:\"css/brands.css\";s:71:\"sha384-Ks7IvHjmJ4FIFxhK4iNrtW0rAVo1DlCYpe/nDsK8CnU+yactd38YiNE1GT018WPg\";s:19:\"css/fontawesome.css\";s:71:\"sha384-sATKZbJwxaEIU3unIoL1VMbIyrNNh7PlgnaiWlicWXeRA7qdnzfFzMP9AaN2wfTU\";s:13:\"css/light.css\";s:71:\"sha384-YWWfxaKIDrbFXuVQnpxASJDHmFl2K5f2vDgrcROb+rYycoqcQVdMlfu3U38boTg/\";s:15:\"css/regular.css\";s:71:\"sha384-CydLcYoDSbudHX/6hygyQD4jBMPsv91d/RwdtH1qxI79KG8kII/OzxKDwsswywA4\";s:13:\"css/solid.css\";s:71:\"sha384-uBARwTxpZ7FB08kQlCOS/dUaN3TrGGcHthrXYIhZBpdq7YtUdVDM1sAUH9NIozMl\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-BptPo+4C0N+fnMTnfw7ddW/zYUJhuNEe7edve8UrMbs+fCpfDJvJcC/lpa5Nvaky\";s:9:\"js/all.js\";s:71:\"sha384-FrB6Se1Wkxlx66xA4rPuOoOolLyQt5B1uptDmtLJSIVRJDbNkmE3QOLipnMuAbUW\";s:12:\"js/brands.js\";s:71:\"sha384-G12tjfNd/W8L4IrE5+f13LUbpzVowwhNDv+WNecvxjbaGN9bbSY7epBOqUlRqXnq\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Ln5PcCmuH8v+AF9nt+HkM2GfXjsn1CtVc0n+ciM8+oe3nwGyPCceDVva7bUjNfo0\";s:11:\"js/light.js\";s:71:\"sha384-jzS22FYPy68IBBet2IRM5aQDOXjg9X1g+drXIVonDtyqGFCtUA0YIdgHdvCCX/fD\";s:13:\"js/regular.js\";s:71:\"sha384-M8TFIPAJNl8UIC8OP6GFcIE0SHkGN4zjwwjz+BBTz60XhNegOrZmjNtTQNKifmXX\";s:11:\"js/solid.js\";s:71:\"sha384-R/e3QvpS9m8HcN9b9l6nNo678ekTXL31kFY/XtRHSjrihDX8A2DF8HaXhdlAtzMx\";s:14:\"js/v4-shims.js\";s:71:\"sha384-X9eLyweB0LOTEGCwMARo9+zibrXQYmBMSrhFk4ncpT/WYnPIcpTg0IgBFDgzuPwL\";}}}s:5:\"5.0.8\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-3AB7yXWz4OeoZcPbieVW64vVXEwADiYyAEhwilzWsLw+9FgqpyjjStpPnpBO8o8S\";s:14:\"css/brands.css\";s:71:\"sha384-IiIL1/ODJBRTrDTFk/pW8j0DUI5/z9m1KYsTm/RjZTNV8RHLGZXkUDwgRRbbQ+Jh\";s:19:\"css/fontawesome.css\";s:71:\"sha384-q3jl8XQu1OpdLgGFvNRnPdj5VIlCvgsDQTQB6owSOHWlAurxul7f+JpUOVdAiJ5P\";s:15:\"css/regular.css\";s:71:\"sha384-A/oR8MwZKeyJS+Y0tLZ16QIyje/AmPduwrvjeH6NLiLsp4cdE4uRJl8zobWXBm4u\";s:13:\"css/solid.css\";s:71:\"sha384-v2Tw72dyUXeU3y4aM2Y0tBJQkGfplr39mxZqlTBDUZAb9BGoC40+rdFCG0m10lXk\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-TGBI4yK0MJz2ga16RLBBt4xT4aoPMPmRYhfu1Kl5IJ0gsLyOBIKHEb49BtoO+lPS\";s:9:\"js/all.js\";s:71:\"sha384-SlE991lGASHoBfWbelyBPLsUlwY1GwNDJo3jSJO04KZ33K2bwfV9YBauFfnzvynJ\";s:12:\"js/brands.js\";s:71:\"sha384-sCI3dTBIJuqT6AwL++zH7qL8ZdKaHpxU43dDt9SyOzimtQ9eyRhkG3B7KMl6AO19\";s:17:\"js/fontawesome.js\";s:71:\"sha384-7ox8Q2yzO/uWircfojVuCQOZl+ZZBg2D2J5nkpLqzH1HY0C1dHlTKIbpRz/LG23c\";s:13:\"js/regular.js\";s:71:\"sha384-t7yHmUlwFrLxHXNLstawVRBMeSLcXTbQ5hsd0ifzwGtN7ZF7RZ8ppM7Ldinuoiif\";s:11:\"js/solid.js\";s:71:\"sha384-+Ga2s7YBbhOD6nie0DzrZpJes+b2K1xkpKxTFFcx59QmVPaSA8c7pycsNaFwUK6l\";s:14:\"js/v4-shims.js\";s:71:\"sha384-4CnzNxEP5RK316IYY2+W4hc05uJdfd+p9iNVeNG9Ws3Qxf5tKolysO9wu/8rloj2\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-OGsxOZf8qnUumoWWSmTqXMPSNI9URpNYN35fXDb5Cv5jT6OR673ah1e5q+9xKTq6\";s:14:\"css/brands.css\";s:71:\"sha384-VRONz34zTLl4P+DLYyJ8kP8C3tB1PGtqL5p8nBAvHuoc1u32bR3RHixrjffD8Fly\";s:19:\"css/fontawesome.css\";s:71:\"sha384-+5VkSw5C1wIu2iUZEfX77QSYRb5fhjmEsRn8u4r9Ma8mvu/GvTag4LDSEAw7RjXl\";s:13:\"css/light.css\";s:71:\"sha384-shmfBA2CRxp88gq8NcvWbEN8KExYU4uvQUBEG36BStGZ5k91nGKE4wDvvWvuimbu\";s:15:\"css/regular.css\";s:71:\"sha384-0w6MzzKHIB9cUlfWSmSp1Pj6XqGGDseWSMz1Yppk3UOc1dhYhpFx1AuCkMBECEvC\";s:13:\"css/solid.css\";s:71:\"sha384-+iHwwKZGTdlVFbv4fsKmLkogfdKlp47zQGkSMDN3ANc8kXjyKudKvQwinI5VH+2C\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-b2wDmqWyAwmI2rS5ut5UweBS1V32L/k1+2Oo7eCaHdXOS/1bFwC8AKevTI6N28LN\";s:9:\"js/all.js\";s:71:\"sha384-816IUmmhAwCMonQiPZBO/PTgzgsjHtpb78rpsLzldhb4HZjFzBl06Z3eu4ZuwHTz\";s:12:\"js/brands.js\";s:71:\"sha384-gJijC/2qM/p3zm2wHECHX1OMLdzlu61sNp7YfmFQxo+OyT9hO1orX7MmnHhaoXQ4\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Ht3fAeBiX/rVmKVyMwONAIIt0aRoPzZgq1FzdRgR9zFo+Kcd8YDwUbFlTItfaYW4\";s:11:\"js/light.js\";s:71:\"sha384-mfSnp84URDGC1t+cg63LgVKwEs63ulRUpjNneyDZMGMAE9ZKUNZ85rMBMHucGLYP\";s:13:\"js/regular.js\";s:71:\"sha384-SIp/+zr0hyfSVIQPkAwB/L1h4fph6T3CmU4mE7IFtGJlgwoCko0Bye/1J0sjyh4v\";s:11:\"js/solid.js\";s:71:\"sha384-jTxqWCb7UqRDQDd2Nkuh5BkHe9k+ElbFLa3NaJfid5kBK/+cVktzVRXrw0isFWxf\";s:14:\"js/v4-shims.js\";s:71:\"sha384-w/sFNq23wbOXJOUpFyISABLXk9tA4Z8r9hl80er2mobEwgS7VXXYDANaWyrCWe3/\";}}}s:5:\"5.0.9\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-5SOiIsAziJl6AWe0HWRKTXlfcSHKmYV4RBF18PPJ173Kzn7jzMyFuTtk8JA7QQG1\";s:14:\"css/brands.css\";s:71:\"sha384-ATC/oZittI09GYIoscTZKDdBr/kI3lCwzw3oBMnOYCPVNJ4i7elNlCxSgLfdfFbl\";s:19:\"css/fontawesome.css\";s:71:\"sha384-Lyz+8VfV0lv38W729WFAmn77iH5OSroyONnUva4+gYaQTic3iI2fnUKtDSpbVf0J\";s:15:\"css/regular.css\";s:71:\"sha384-seionXF7gEANg+LFxIOw3+igh1ZAWgHpNR8SvE64G/Zgmjd918dTL55e8hOy7P4T\";s:13:\"css/solid.css\";s:71:\"sha384-29Ax2Ao1SMo9Pz5CxU1KMYy+aRLHmOu6hJKgWiViCYpz3f9egAJNwjnKGgr+BXDN\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-Hl6tZnMfNiJHYyFxpmnRV8+pziARxY3X/4XWfFXldG7sdkkLv+Od2Gpc57P7C1g6\";s:9:\"js/all.js\";s:71:\"sha384-8iPTk2s/jMVj81dnzb/iFR2sdA7u06vHJyyLlAd4snFpCl/SnyUjRrbdJsw1pGIl\";s:12:\"js/brands.js\";s:71:\"sha384-qJKAzpOXfvmSjzbmsEtlYziSrpVjh5ROPNqb8UZ60myWy7rjTObnarseSKotmJIx\";s:17:\"js/fontawesome.js\";s:71:\"sha384-2IUdwouOFWauLdwTuAyHeMMRFfeyy4vqYNjodih+28v2ReC+8j+sLF9cK339k5hY\";s:13:\"js/regular.js\";s:71:\"sha384-BazKgf1FxrIbS1eyw7mhcLSSSD1IOsynTzzleWArWaBKoA8jItTB5QR+40+4tJT1\";s:11:\"js/solid.js\";s:71:\"sha384-P4tSluxIpPk9wNy8WSD8wJDvA8YZIkC6AQ+BfAFLXcUZIPQGu4Ifv4Kqq+i2XzrM\";s:14:\"js/v4-shims.js\";s:71:\"sha384-9f5gaI9TkuYhi5O/inzfdOXx2nkIhDsLtXqBNmtY6/c5PoqXfd0U2DAjqQVSCXQh\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-L+XK540vkePe55E7PAfByfvW0XpsyYpsifTpgh/w8WvH6asVg/c2zqp0EfZfZTbF\";s:14:\"css/brands.css\";s:71:\"sha384-+LMmZxgyldhNCY6nei3oAWJjHbpbROtVb+f5Ux/nahA+Xjm3wcNdu7zyB39Yj38S\";s:19:\"css/fontawesome.css\";s:71:\"sha384-31qpW3hduWGiGey9tdI9rBBxiog5pxZbPiAlD6YKIgy0P2V1meprKhvpk+xJDkMw\";s:13:\"css/light.css\";s:71:\"sha384-wD8IB6DSQidXyIWfwBrsFwTaHTQDsgzyeqzhd1jNdBZHvGSa7KRGb6Q5sMlroCyk\";s:15:\"css/regular.css\";s:71:\"sha384-hJbmKHxbgrH79UtKxubo1UTe96bOL4Xfhjaqr0csD1UMPEPbeV+446QAC+IGxY+b\";s:13:\"css/solid.css\";s:71:\"sha384-k8v16DuQ4ZFtRfpTeqTW4tcHIj5tkvUNQm1QiLs90XiToLzyFeV+yxujHjSZ2wim\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-yVUvm1bVSmayKKt0YHPKotNQzlBvgNhEBbQ6U1d38bjpapXMVmE+SLXrpQ9td4Ij\";s:9:\"js/all.js\";s:71:\"sha384-DtPgXIYsUR6lLmJK14ZNUi11aAoezQtw4ut26Zwy9/6QXHH8W3+gjrRDT+lHiiW4\";s:12:\"js/brands.js\";s:71:\"sha384-yIJb2TJeTM04vupX+3lv0Qp9j0Pnk8Qm9UPYlXr3H0ROCHNNLoacpS++HWDabbzi\";s:17:\"js/fontawesome.js\";s:71:\"sha384-8QYlVHotqQzcAVhJny7MO9ZR0hASr6cRCpURV+EobTTAv5wftkn4i+U6UrMqoCis\";s:11:\"js/light.js\";s:71:\"sha384-06sraYAcw8BzUjsPn5z8Qi/QAA2/ZJl5GN3LGtRp7k+tZpu7kw+sRNXDDTU4RkOt\";s:13:\"js/regular.js\";s:71:\"sha384-C6h/8oKUfY6cVuGfFSu9uGIlFkaD1u1j+ByYGFTdFbOpHOHpw39lKxqEpRgLQg6A\";s:11:\"js/solid.js\";s:71:\"sha384-nISI3wKDp2gWn9L91zXOKXZ6JPt2mteGTnaJAMfeNgAoeLKl2AQsWLH69HMmBXHa\";s:14:\"js/v4-shims.js\";s:71:\"sha384-vuyo8HdrwozCl2DhHOJ40ytjEx9FGy0cqu8i5GHeIoSUm6MPgqCXAVoUIsudKfuE\";}}}s:6:\"5.0.10\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-+d0P83n9kaQMCwj8F4RJB66tzIwOKmrdb46+porD/OvrJ+37WqIM7UoBtwHO6Nlg\";s:14:\"css/brands.css\";s:71:\"sha384-KtmfosZaF4BaDBojD9RXBSrq5pNEO79xGiggBxf8tsX+w2dBRpVW5o0BPto2Rb2F\";s:19:\"css/fontawesome.css\";s:71:\"sha384-8WwquHbb2jqa7gKWSoAwbJBV2Q+/rQRss9UXL5wlvXOZfSodONmVnifo/+5xJIWX\";s:15:\"css/regular.css\";s:71:\"sha384-R7FIq3bpFaYzR4ogOiz75MKHyuVK0iHja8gmH1DHlZSq4tT/78gKAa7nl4PJD7GP\";s:13:\"css/solid.css\";s:71:\"sha384-HTDlLIcgXajNzMJv5hiW5s2fwegQng6Hi+fN6t5VAcwO/9qbg2YEANIyKBlqLsiT\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-ucawWSvpdgQ67m4VQzI6qBOHIsGRoY2soJtCkkp15b6IaNCLgauWkbKR8SAuiDQ7\";s:9:\"js/all.js\";s:71:\"sha384-slN8GvtUJGnv6ca26v8EzVaR9DC58QEwsIk9q1QXdCU8Yu8ck/tL/5szYlBbqmS+\";s:12:\"js/brands.js\";s:71:\"sha384-6jhVhr5a+Z1nLr9h+fd7ocMEo847wnGFelCHddaOOACUeZNoQwFXTxh4ysXVam8u\";s:17:\"js/fontawesome.js\";s:71:\"sha384-M2FSA4xMm1G9m4CNXM49UcDHeWcDZNucAlz1WVHxohug0Uw1K+IpUhp/Wjg0y6qG\";s:13:\"js/regular.js\";s:71:\"sha384-JWLWlnwX0pRcCBsI3ZzOEyVDoUmngnFnbXR9VedCc3ko4R3xDG+KTMYmVciWbf4N\";s:11:\"js/solid.js\";s:71:\"sha384-Q7KAHqDd5trmfsv85beYZBsUmw0lsreFBQZfsEhzUtUn5HhpjVzwY0Aq4z8DY9sA\";s:14:\"js/v4-shims.js\";s:71:\"sha384-RLvgmog5EsZMMDnT3uJo6ScffPHTtMbhtV8pcT8kP5UJzlVRU1SP9Hccelk3zYZc\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-KwxQKNj2D0XKEW5O/Y6haRH39PE/xry8SAoLbpbCMraqlX7kUP6KHOnrlrtvuJLR\";s:14:\"css/brands.css\";s:71:\"sha384-cyAsyPMdnj21FGg6BEGfZdZ99a/opKBeFa8z5VoHPsPj+tLRYSxkRlPWnGkCJGyA\";s:19:\"css/fontawesome.css\";s:71:\"sha384-HE+OCjOJOPZavEcVffA6E24sIfY2RwV4JRieXa/3N5iCY8vgnTwZemElENQ8ak/K\";s:13:\"css/light.css\";s:71:\"sha384-k/d3hya1Xwx/V3yLAr7/6ibFaFIaN+xeY1eIv42A1Bn2HgfB+/YjLscji1sHLOkb\";s:15:\"css/regular.css\";s:71:\"sha384-D4yOV+i5oKU6w8CiadBDVtSim/UXmlmQfrIdRsuKT3nYhiF/Tb6YLQtyF9l0vqQF\";s:13:\"css/solid.css\";s:71:\"sha384-WjYgBJXUWNFTzFd4wNJuzUZx28GSgjzXrPO4LJrng96HFrI/nLrG1R5NET65v1yR\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-S/uB02cfkgX8kd+j6f3gmw/PPTg8xSiE/w6d8dE852PzHXkGBYLrqpWFse9hInR2\";s:9:\"js/all.js\";s:71:\"sha384-+1nLPoB0gaUktsZJP+ycZectl3GX7wP8Xf2PE/JHrb7X1u7Emm+v7wJMbAcPr8Ge\";s:12:\"js/brands.js\";s:71:\"sha384-OwdVp9K/baqiXthTvRnYzMcsTaqwG19SfDkTRc/GBIhK9eYlWVVBEvLlueA0STAP\";s:17:\"js/fontawesome.js\";s:71:\"sha384-TxXqLyCP6HYGVtr9V1M1rQE7IMbBEZoDdOX+MFeYNbWNwopWKVQM8NyqtU2x+5t2\";s:11:\"js/light.js\";s:71:\"sha384-rv/n2A+UxOzR1qs4wrcOtJ7Ai5Hcn3QQ8tvEkOo5lCvqCD3xwpeO3KZP18JpSXr3\";s:13:\"js/regular.js\";s:71:\"sha384-QNGmoJVI8f07j7N4+DSn4Cdob1PTBJOR6jRGwUwqSPyL2HmvWaBPXuSXOcStGo9D\";s:11:\"js/solid.js\";s:71:\"sha384-m3J/Wb6KcNkFJIpCugSSJITG80sKhEA+16UCFdq1LnpMTOCXwwpeyrE1FmyqoArv\";s:14:\"js/v4-shims.js\";s:71:\"sha384-H+U1wWQdWbEtuQPJ4ZpMl8yWydI6xc/306L/NZkpGY8BGpeSpu39V20x03S3xcMw\";}}}s:6:\"5.0.12\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-G0fIWCsCzJIMAVNQPfjH08cyYaUtMwjJwqiRKxxE/rx96Uroj1BtIQ6MLJuheaO9\";s:14:\"css/brands.css\";s:71:\"sha384-Pln/erVatVEIIVh7sfyudOXs5oajCSHg7l5e2Me02e3TklmDuKEhQ8resTIwyI+w\";s:19:\"css/fontawesome.css\";s:71:\"sha384-rnr8fdrJ6oj4zli02To2U/e6t1qG8dvJ8yNZZPsKHcU7wFK3MGilejY5R/cUc5kf\";s:15:\"css/regular.css\";s:71:\"sha384-RGDxJbFQcd3/Rei8rYb+3xO3YREd0abxm8WfLkYj7j4HHo5ZVuNUGVx8H8GbpFTQ\";s:13:\"css/solid.css\";s:71:\"sha384-VxweGom9fDoUf7YfLTHgO0r70LVNHP5+Oi8dcR4hbEjS8UnpRtrwTx7LpHq/MWLI\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-N44Xrku5FaDiZLZ8lncIZLh+x9xiqk1r0NTlUJQ5xanSpdORyQHP4Zp2WQJ9GlpJ\";s:9:\"js/all.js\";s:71:\"sha384-Voup2lBiiyZYkRto2XWqbzxHXwzcm4A5RfdfG6466bu5LqjwwrjXCMBQBLMWh7qR\";s:12:\"js/brands.js\";s:71:\"sha384-BPIhZF7kZGuZzBS4SP/oIqzpxWuOUtsPLUTVGpGw+EtB1wKt1hv63jb2OCroS3EX\";s:17:\"js/fontawesome.js\";s:71:\"sha384-6AOxTjzzZLvbTJayrLOYweuPckqh0rrB4Sj+Js8Vzgr85/qm2e0DRqi+rBzyK52J\";s:13:\"js/regular.js\";s:71:\"sha384-6XNKyHeL6pEPXURVNSKQ0lUP80a5FHqN0oFqSSS8Qviyy2u0KmCMJlQ5iLiAAPBg\";s:11:\"js/solid.js\";s:71:\"sha384-652/z7yNdGONCCBu0u5h5uF9voJhBdgruAuIDVheEaQ7O/ZC9wyyV+yZsYb32Wy7\";s:14:\"js/v4-shims.js\";s:71:\"sha384-STc8Gazx86A+NmeBWQTqa5Ob1wGSRQZevexYiUkKdiqZhi5LSZ28XYAvgptHK5HH\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-HX5QvHXoIsrUAY0tE/wG8+Wt1MwvaY28d9Zciqcj6Ob7Tw99tFPo4YUXcZw9l930\";s:14:\"css/brands.css\";s:71:\"sha384-M4owBK0KiG0Vz+G5z/8v8tBb1+w9ts66Z6xKkZEPgBwzISkrcNra4GxZcvJPyaGB\";s:19:\"css/fontawesome.css\";s:71:\"sha384-ZDxYpspDwfEsC0ZJDb74i/Rqjb1CnX3a69Dz9vXv4PvvlTEkgMI02TATTRNJoZ06\";s:13:\"css/light.css\";s:71:\"sha384-PWGGmWk9+xVydf1Gzso0ouaikBBKLu4nCY52q+tBUMq5iXmRhpgTuDkjbtxZ1rXT\";s:15:\"css/regular.css\";s:71:\"sha384-tYZB+BP2inzRg01pQhSlW4Tloc0ULXYGiBaf5kSB5Tb3+l84bJy+PKerqziKz3iv\";s:13:\"css/solid.css\";s:71:\"sha384-KY40QRrgoQAM9BPN+gm7JoK30M/P6QqKRCbXUS3uWbPfycyiVeEsPkGNMhcNL3DU\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-ubRAMbpAKC+ULwg5mkUQLFReIXq1yeiKIcfV7cYp+rEaeINfEglYX6JOte80PCDk\";s:9:\"js/all.js\";s:71:\"sha384-quzri7saio48xMf3ED3HiI5YaItt68Q+0J3qc9EIfk1jk3QqCJhS24l6CZpUGfEe\";s:12:\"js/brands.js\";s:71:\"sha384-QlvHmHtevrYI4s/vdiK6chTDouw2pRA5av6ZLVtENubkoCgSZz4ZaXVvplQ1FRPs\";s:17:\"js/fontawesome.js\";s:71:\"sha384-CUrLKzrygRugRUPtEJ1u4nV4Ec6GnuDMRDGaxfoFXLI+sraWS6rqGg2Sjfs6BTet\";s:11:\"js/light.js\";s:71:\"sha384-z7YlG414oqy0TO7qY/nGfC8zd1LL8JAX3iNQ3iLybUIziHzaMYqBwUvhizEwV0Fd\";s:13:\"js/regular.js\";s:71:\"sha384-p/qo0lifpToZ0ubNiv1WFzlmYJU+BOenvU+evARCvCqALvbpZuqmZQ207vmYD6QL\";s:11:\"js/solid.js\";s:71:\"sha384-y//1Knkpeyl2S568g2ECqUA4n3MKf+kpj1/sfjUQbR1WtBPONceBHrQVMiAqfjLH\";s:14:\"js/v4-shims.js\";s:71:\"sha384-6+8zJP76v3EziONR2vMd32iSU3qbdicAE8KNp+NWniM6mBmvN80NlY+sbvCO+w7M\";}}}s:6:\"5.0.13\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-DNOHZ68U8hZfKXOrtjWvjxusGo9WQnrNx2sqG0tfsghAvtVlRW3tvkXWZh58N9jp\";s:14:\"css/brands.css\";s:71:\"sha384-VGCZwiSnlHXYDojsRqeMn3IVvdzTx5JEuHgqZ3bYLCLUBV8rvihHApoA1Aso2TZA\";s:19:\"css/fontawesome.css\";s:71:\"sha384-GVa9GOgVQgOk+TNYXu7S/InPTfSDTtBalSgkgqQ7sCik56N9ztlkoTr2f/T44oKV\";s:15:\"css/regular.css\";s:71:\"sha384-EWu6DiBz01XlR6XGsVuabDMbDN6RT8cwNoY+3tIH+6pUCfaNldJYJQfQlbEIWLyA\";s:13:\"css/solid.css\";s:71:\"sha384-Rw5qeepMFvJVEZdSo1nDQD5B6wX0m7c5Z/pLNvjkB14W6Yki1hKbSEQaX9ffUbWe\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-LAtyQAMHxrIJzktG06ww5mJ0KQ+uCqQIJFjwj+ceCjUlZ2jkLwJZt1nBGw4KaFEZ\";s:9:\"js/all.js\";s:71:\"sha384-xymdQtn1n3lH2wcu0qhcdaOpQwyoarkgLVxC/wZ5q7h9gHtxICrpcaSUfygqZGOe\";s:12:\"js/brands.js\";s:71:\"sha384-G/XjSSGjG98ANkPn82CYar6ZFqo7iCeZwVZIbNWhAmvCF2l+9b5S21K4udM7TGNu\";s:17:\"js/fontawesome.js\";s:71:\"sha384-6OIrr52G08NpOFSZdxxz1xdNSndlD4vdcf/q2myIUVO0VsqaGHJsB0RaBE01VTOY\";s:13:\"js/regular.js\";s:71:\"sha384-IJ3h7bJ6KqiB70L7/+fc44fl+nKF5eOFkgM9l/zZii9xs7W2aJrwIlyHZiowN+Du\";s:11:\"js/solid.js\";s:71:\"sha384-tzzSw1/Vo+0N5UhStP3bvwWPq+uvzCMfrN1fEFe+xBmv1C/AtVX5K0uZtmcHitFZ\";s:14:\"js/v4-shims.js\";s:71:\"sha384-qqI1UsWtMEdkxgOhFCatSq+JwGYOQW+RSazfcjlyZFNGjfwT/T1iJ26+mp70qvXx\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-oi8o31xSQq8S0RpBcb4FaLB8LJi9AT8oIdmS1QldR8Ui7KUQjNAnDlJjp55Ba8FG\";s:14:\"css/brands.css\";s:71:\"sha384-t3MQUMU0g3tY/0O/50ja6YVaEFYwPpOiPbrHk9p5DmYtkHJU2U1/ujNhYruOJwcj\";s:19:\"css/fontawesome.css\";s:71:\"sha384-LDuQaX4rOgqi4rbWCyWj3XVBlgDzuxGy/E6vWN6U7c25/eSJIwyKhy9WgZCHQWXz\";s:13:\"css/light.css\";s:71:\"sha384-d8NbeymhHpk+ydwT2rk4GxrRuC9pDL/3A6EIedSEYb+LE+KQ5QKgIWTjYwHj/NBs\";s:15:\"css/regular.css\";s:71:\"sha384-HLkkol/uuRVQDnHaAwidOxb1uCbd78FoGV/teF8vONYKRP9oPQcBZKFdi3LYDy/C\";s:13:\"css/solid.css\";s:71:\"sha384-drdlAcijFWubhOfj9OS/gy2Gs34hVhVT90FgJLzrldrLI+7E7lwBxmanEEhKTRTS\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-8YpCivPy+AkMdZ0uAvEP04Gs77AN/6mS5AmZqkCwniP51zSG8rCMaH06OYuC4iXd\";s:9:\"js/all.js\";s:71:\"sha384-d84LGg2pm9KhR4mCAs3N29GQ4OYNy+K+FBHX8WhimHpPm86c839++MDABegrZ3gn\";s:12:\"js/brands.js\";s:71:\"sha384-44Hl7UlQr9JXHFcZOp9qWHk2H1lrsAN/cG3GNgB2JqbciecuJ2/B9sjelOMttzBM\";s:17:\"js/fontawesome.js\";s:71:\"sha384-BUkEHIKZJ0ussRY3zYfFL7R0LpqWmucr9K38zMTJWdGQywTjmzbejVSNIHuNEhug\";s:11:\"js/light.js\";s:71:\"sha384-+iGqamqASU/OvBgGwlIHH6HSEgiluzJvTqcjJy8IN9QG9aUfd0z0pKpTlH7TpU7X\";s:13:\"js/regular.js\";s:71:\"sha384-1bAvs6o5Yb7MMzvTI3oq2qkreCQFDXb6KISLBhrHR+3sJ/mm7ZWfnQVRwScbPEmd\";s:11:\"js/solid.js\";s:71:\"sha384-CucLC75yxFXtBjA/DCHWMS14abAUhf5HmFRdHyKURqqLqi3OrLsyhCyqp83qjiOR\";s:14:\"js/v4-shims.js\";s:71:\"sha384-LDfu/SrM7ecLU6uUcXDDIg59Va/6VIXvEDzOZEiBJCh148mMGba7k3BUFp1fo79X\";}}}s:5:\"5.1.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-lKuwvrZot6UHsBSfcMvOkWwlCMgc0TaWr+30HWe3a4ltaBwTZhyTEggF5tJv8tbt\";s:14:\"css/brands.css\";s:71:\"sha384-7xAnn7Zm3QC1jFjVc1A6v/toepoG3JXboQYzbM0jrPzou9OFXm/fY6Z/XiIebl/k\";s:19:\"css/fontawesome.css\";s:71:\"sha384-ozJwkrqb90Oa3ZNb+yKFW2lToAWYdTiF1vt8JiH5ptTGHTGcN7qdoR1F95e0kYyG\";s:15:\"css/regular.css\";s:71:\"sha384-avJt9MoJH2rB4PKRsJRHZv7yiFZn8LrnXuzvmZoD3fh1aL6aM6s0BBcnCvBe6XSD\";s:13:\"css/solid.css\";s:71:\"sha384-TbilV5Lbhlwdyc4RuIV/JhD8NR+BfMrvz4BL5QFa2we1hQu6wvREr3v6XSRfCTRp\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-5aLiCANDiVeIiNfzcW+kXWzWdC6riDYfxLS6ifvejaqYOiEufCh0zVLMkW4nr8iC\";s:16:\"css/v4-shims.css\";s:71:\"sha384-epK5t6ciulYxBQbRDZyYJFVuWey/zPlkBIbv6UujFdGiIwQCeWOyv5PVp2UQXbr2\";s:9:\"js/all.js\";s:71:\"sha384-3LK/3kTpDE/Pkp8gTNp2gR/2gOiwQ6QaO7Td0zV76UFJVhqLl4Vl3KL1We6q6wR9\";s:12:\"js/brands.js\";s:71:\"sha384-ZqDZAkGUHrXxm3bvcTCmQWz4lt7QGLxzlqauKOyLwg8U0wYcYPDIIVTbZZXjbfsM\";s:17:\"js/fontawesome.js\";s:71:\"sha384-juNb2Ils/YfoXkciRFz//Bi34FN+KKL2AN4R/COdBOMD9/sV/UsxI6++NqifNitM\";s:13:\"js/regular.js\";s:71:\"sha384-Y+AVd32cSTAMpwehrH10RiRmA28kvu879VbHTG58mUFhd+Uxl/bkAXsgcIesWn3a\";s:11:\"js/solid.js\";s:71:\"sha384-Z7p3uC4xXkxbK7/4keZjny0hTCWPXWfXl/mJ36+pW7ffAGnXzO7P+iCZ0mZv5Zt0\";s:14:\"js/v4-shims.js\";s:71:\"sha384-3qT9zZfeo1gcy2NmVv5dAhtOYkj91cMLXRkasOiRB/v+EU3G+LZUyk5uqZQdIPsV\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-87DrmpqHRiY8hPLIr7ByqhPIywuSsjuQAfMXAE0sMUpY3BM7nXjf+mLIUSvhDArs\";s:14:\"css/brands.css\";s:71:\"sha384-C1HxUFJBptCeaMsYCbPUw8fdL2Cblu3mJZilxrfujE+7QLr8BfuzBl5rPLNM61F6\";s:19:\"css/fontawesome.css\";s:71:\"sha384-PnWzJku7hTqk2JREATthkLpYeVVGcBbXG5yEzk7hD2HIr/VxffIDfNSR7p7u4HUy\";s:13:\"css/light.css\";s:71:\"sha384-ANTAgj8tbw0vj4HgQ4HsB886G2pH15LXbruHPCBcUcaPAtn66UMxh8HQcb1cH141\";s:15:\"css/regular.css\";s:71:\"sha384-6kuJOVhnZHzJdVIZJcWiMZVi/JwinbqLbVxIbR73nNqXnYJDQ5TGtf+3XyASO4Am\";s:13:\"css/solid.css\";s:71:\"sha384-rvfDcG9KDoxdTesRF/nZ/sj8CdQU+hy6JbNMwxUTqpoI2LaPK8ASQk6E4bgabrox\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-/h6SKuA/ysT91EgYEGm9B6Z6zlaxuvKeW/JB7FWdGwCFalafxmGzJE2a63hS1BLm\";s:16:\"css/v4-shims.css\";s:71:\"sha384-2RBBYH6GaI11IJzJ6V1eL7kXXON+epoQIt+HqpzQdBrtyT7gNwKPDxo2roxUbtW9\";s:9:\"js/all.js\";s:71:\"sha384-E5SpgaZcbSJx0Iabb3Jr2AfTRiFnrdOw1mhO19DzzrT9L+wCpDyHUG2q07aQdO6E\";s:12:\"js/brands.js\";s:71:\"sha384-QPbiRUBnwCr8JYNjjm7CB0QP9h4MLvWUZhsChFX6dLzRkY22/nAxVYqa5nUTd6PL\";s:17:\"js/fontawesome.js\";s:71:\"sha384-ckjcH5WkBMAwWPjTJiy7K2LaLp37yyCVKAs3DKjhPdo0lRCDIScolBzRsuaSu+bQ\";s:11:\"js/light.js\";s:71:\"sha384-77i21WTcIcnSPKxwR794RLUQitpNqm6K3Fxsjx8hgoc3ZZbPJu5orgvU/7xS3EFq\";s:13:\"js/regular.js\";s:71:\"sha384-S21AhcbZ5SXPXH+MH7JuToqmKYXviahLaD1s9yApRbu1JDiMjPBGQIw/3PCHKUio\";s:11:\"js/solid.js\";s:71:\"sha384-q6QALO/4RSDjqnloeDcGnkB0JdK3MykIi6dUW5YD66JHE3JFf8rwtV5AQdYHdE0X\";s:14:\"js/v4-shims.js\";s:71:\"sha384-9gfBAY6DS3wT0yuvYN1aaA1Q9R0fYQHliQWLChuYDWJJ0wQJpoNZrzlcqd4+qqny\";}}}s:5:\"5.1.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-O8whS3fhG2OnA5Kas0Y9l3cfpmYjapjI0E4theH4iuMD+pLhbf6JI0jIMfYcK3yZ\";s:14:\"css/brands.css\";s:71:\"sha384-SYNjKRRe+vDW0KSn/LrkhG++hqCLJg9ev1jIh8CHKuEA132pgAz+WofmKAhPpTR7\";s:19:\"css/fontawesome.css\";s:71:\"sha384-0b7ERybvrT5RZyD80ojw6KNKz6nIAlgOKXIcJ0CV7A6Iia8yt2y1bBfLBOwoc9fQ\";s:15:\"css/regular.css\";s:71:\"sha384-QNorH84/Id/CMkUkiFb5yTU3E/qqapnCVt6k5xh1PFIJ9hJ8VfovwwH/eMLQTjGS\";s:13:\"css/solid.css\";s:71:\"sha384-S2gVFTIn1tJ/Plf+40+RRAxBCiBU5oAMFUJxTXT3vOlxtXm7MGjVj62mDpbujs4C\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-EH3TEAKYd7R0QbCS4OFuYoEpaXITVg5c/gdZ/beEaAbRjMGVuVLLFjiIKOneCzGZ\";s:16:\"css/v4-shims.css\";s:71:\"sha384-LCsPWAjCFLDeFHB5Y0SBIOqgC5othK8pIZiJAdbJDiN10B2HXEm1mFNHtED8cViz\";s:9:\"js/all.js\";s:71:\"sha384-BtvRZcyfv4r0x/phJt9Y9HhnN5ur1Z+kZbKVgzVBAlQZX4jvAuImlIz+bG7TS00a\";s:12:\"js/brands.js\";s:71:\"sha384-0inRy4HkP0hJ038ZyfQ4vLl+F4POKbqnaUB6ewmU4dWP0ki8Q27A0VFiVRIpscvL\";s:17:\"js/fontawesome.js\";s:71:\"sha384-NY6PHjYLP2f+gL3uaVfqUZImmw71ArL9+Roi9o+I4+RBqArA2CfW1sJ1wkABFfPe\";s:13:\"js/regular.js\";s:71:\"sha384-sAzYCvbTTKFOxT4VHu+ZjHRMXjvfjT6TAqOng28g4jba88Peg5+hkoVIqQKGjmj1\";s:11:\"js/solid.js\";s:71:\"sha384-GXi56ipjsBwAe6v5X4xSrVNXGOmpdJYZEEh/0/GqJ3JTHsfDsF8v0YQvZCJYAiGu\";s:14:\"js/v4-shims.js\";s:71:\"sha384-T69Lzd4bE7W8/vVrxvfsx45/AAKf6QmKEg5zSl0v9aZwo/pTKseq81mxdpARTQpx\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-xyMU7RufUdPGVOZRrc2z2nRWVWBONzqa0NFctWglHmt5q5ukL22+lvHAqhqsIm3h\";s:14:\"css/brands.css\";s:71:\"sha384-E5dVkWQIVhVPtBz/KK2TS7EM9l1+5XiWFPX7l3+5ayHPwDguGsHqof3GQbk55AS3\";s:19:\"css/fontawesome.css\";s:71:\"sha384-bHoj6f1b1CQ6zapOREeYBO/JnDjeV1fLuKn3KHnbqAAnkLva11KY3m8YyKPVXYLF\";s:13:\"css/light.css\";s:71:\"sha384-EGKQAl6ZrGi/zGxZ4ykVhc/A3tFVeBiLnneETILtcxQnZpo7ejmb4BkNa3zSgo4K\";s:15:\"css/regular.css\";s:71:\"sha384-AKIrAHbICIQF+NEqtykrcdzMjExDiKLa9hOyUVsr4PlHtktH7xaD10vO98UnPjuE\";s:13:\"css/solid.css\";s:71:\"sha384-Ux3tEr1RmnxCht2XbPkWWBuotwMVXKOe0PkWN/nmiD5CSV6Tyjl+Kr0J0iX1yd0q\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-++BmJ9x4V05AhCNnLr/RjPTY4BAFuhZsESUqH5hiwZspBvy7F+DRGvSH8tGHw9P/\";s:16:\"css/v4-shims.css\";s:71:\"sha384-TUicmScQcYANFcc4OQKEX6V1Zek9o9t+dwW/2tZoXmSigBk9JqfHxZZFlSo+0oRl\";s:9:\"js/all.js\";s:71:\"sha384-cHcg4nvWPIGArJhEgL2F5e09Cn1GyPQpNYKbPatFCpDefCbezZjPA3PhLozKTZnv\";s:12:\"js/brands.js\";s:71:\"sha384-KCMfKsP/3VgeibBQRMu4bT+9041Hi2v9PIz9FLOPJBEvxCBklc4o7tRwwQu4FWsT\";s:17:\"js/fontawesome.js\";s:71:\"sha384-EWJRWU7LQt+ri8YtDjTr8adATyP7y8DwlpE8zruoUC4nHNjtWZMU+iPYK+tFaV3U\";s:11:\"js/light.js\";s:71:\"sha384-0rp6k6cJIuLV1ORowDSSKr4VbEqb664PQUWdBvhJyt6IfkshVb0r6UlOkX6yVdaI\";s:13:\"js/regular.js\";s:71:\"sha384-Mw6yr+W+X+ckaAUbsPUb2BcU3Af9aSjmPMIlMr2iplN0VQIpscDWy/VwY5w0sz9w\";s:11:\"js/solid.js\";s:71:\"sha384-PyvJtlnGBA/R+hfVbHbnzfeT8G/iTORqPhR5WKGTQXlfmLe5bV+d64NECHG4sIMa\";s:14:\"js/v4-shims.js\";s:71:\"sha384-rJQjFeDWQReL3KmIeV81jB594CgKx/MmXyAgiuu88Jo253P+PSMgWzivZQtR6N6J\";}}}s:5:\"5.2.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-hWVjflwFxL6sNzntih27bfxkr27PmbbK/iSvJ+a4+0owXq79v+lsFkW54bOGbiDQ\";s:14:\"css/brands.css\";s:71:\"sha384-nT8r1Kzllf71iZl81CdFzObMsaLOhqBU1JD2+XoAALbdtWaXDOlWOZTR4v1ktjPE\";s:19:\"css/fontawesome.css\";s:71:\"sha384-HbmWTHay9psM8qyzEKPc8odH4DsOuzdejtnr+OFtDmOcIVnhgReQ4GZBH7uwcjf6\";s:15:\"css/regular.css\";s:71:\"sha384-zkhEzh7td0PG30vxQk1D9liRKeizzot4eqkJ8gB3/I+mZ1rjgQk+BSt2F6rT2c+I\";s:13:\"css/solid.css\";s:71:\"sha384-wnAC7ln+XN0UKdcPvJvtqIH3jOjs9pnKnq9qX68ImXvOGz2JuFoEiCjT8jyZQX2z\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-jKeGgxY7zPT61fNXg6OMRDu8vsxOPRLMlgAIUHo1KVag4lyu5B03KsDLYOTMM4ld\";s:16:\"css/v4-shims.css\";s:71:\"sha384-W14o25dsDf2S/y9FS68rJKUyCoBGkLwr8owWTSTTHj4LOoHdrgSxw1cmNQMULiRb\";s:9:\"js/all.js\";s:71:\"sha384-4oV5EgaV02iISL2ban6c/RmotsABqE4yZxZLcYMAdG7FAPsyHYAPpywE9PJo+Khy\";s:12:\"js/brands.js\";s:71:\"sha384-4BRtleJgTYsMKIVuV1Z7lNE29r4MxwKR7u88TWG2GaXsmSljIykt/YDbmKndKGID\";s:17:\"js/fontawesome.js\";s:71:\"sha384-QcnrgQuRmocjIBY6ByWMmDvUg3HO4MSdVjY7ynJwZfvTDhVPPQOUI9TRzc6/7ZO1\";s:13:\"js/regular.js\";s:71:\"sha384-YdSTwqfKxyP06Jj3UzTeumv8M+Pme60+KND4oF+5r5VeUCvdkw7NhSzFYWbe00ba\";s:11:\"js/solid.js\";s:71:\"sha384-YmNA3b9AQuWW8KZguYfqJa/YhKNTwGVD5pQc1cN0ZAVRudFFtR17HR7rooNcVXe4\";s:14:\"js/v4-shims.js\";s:71:\"sha384-rn4uxZDX7xwNq5bkqSbpSQ3s4tK9evZrXAO1Gv9WTZK4p1+NFsJvOQmkos19ebn2\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-TXfwrfuHVznxCssTxWoPZjhcss/hp38gEOH8UPZG/JcXonvBQ6SlsIF49wUzsGno\";s:14:\"css/brands.css\";s:71:\"sha384-Ei2oxwH0wpwmp7KPdhYnajC5fWDdMENOjDw9OfzWvcFcOGn0Egy+L5AAculaqBbD\";s:19:\"css/fontawesome.css\";s:71:\"sha384-4eP+1rYQmuI3hxrmyE+GT/EIiNbF4R85ciN3jMpmIh+bU5Hz2IU7AdcVe+JS+AJz\";s:13:\"css/light.css\";s:71:\"sha384-pcDR01P1wNxsYZiEYdROCAYhU2u8VHOctLrYRonRFtkf/TGEQFWt0rqFbPGWlyn4\";s:15:\"css/regular.css\";s:71:\"sha384-g3XsWx0Sqi7JIjLKVnwUxEvqrxTMQPIf3PN+vTdWY2AhduP/rnj0rw89v0nbD4Ro\";s:13:\"css/solid.css\";s:71:\"sha384-B/E/KxBX31kY/5sew+X4c8e6ErosbqOOsA3t4k6VVmx8Hrz//v0tEUtXmUVx9X6Q\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-O6mvz45yC1vfdu/EgUxAoSGrP+sFtepMtj7eOQIW1G3WT9Sj5djActZC0hd/F42D\";s:16:\"css/v4-shims.css\";s:71:\"sha384-2QRS8Mv2zxkE2FAZ5/vfIJ7i0j+oF15LolHAhqFp9Tm4fQ2FEOzgPj4w/mWOTdnC\";s:9:\"js/all.js\";s:71:\"sha384-yBZ34R8uZDBb7pIwm+whKmsCiRDZXCW1vPPn/3Gz0xm4E95frfRNrOmAUfGbSGqN\";s:12:\"js/brands.js\";s:71:\"sha384-eg9wHuvEPj6+GlGomBRaMHLF0QfCnjdASWDKd84DMeM9phhyDaPFou/nHJBt0bz+\";s:17:\"js/fontawesome.js\";s:71:\"sha384-FQUuiJxt9F0hPc9IP3M5ndmqK53iBCGcy4ZSx8QirhYOIs8l7x+e1/zdswyZEigi\";s:11:\"js/light.js\";s:71:\"sha384-glAz6mCeiwAe/kHHHG/OvhrjA4+AH55ZfH8fwYp48YCY61POwUmOrH/oYOaF2Ujy\";s:13:\"js/regular.js\";s:71:\"sha384-8hKZY21U4J3r9N0GFl+24YnDkbRhs8y/nXT6BaZ+sOJDNmz+1DhFawE9UYL37XzB\";s:11:\"js/solid.js\";s:71:\"sha384-1j3ph9Rf+Aaz6rrizz6cdFxU9ZbUyvkbiwQ5+T/BY4I5mk37vUpTA8S9ZZOlfdWu\";s:14:\"js/v4-shims.js\";s:71:\"sha384-aoMjEUBUPf5GpXx1WJUeTZ/gBmGqQB1u8uUc2J5LW2xnQtJKkGulESZ+rkoj182s\";}}}s:5:\"5.3.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-mzrmE5qonljUremFsqc01SB46JvROS7bZs3IO2EmfFsd15uHvIt+Y8vEf7N7fWAU\";s:14:\"css/brands.css\";s:71:\"sha384-rf1bqOAj3+pw6NqYrtaE1/4Se2NBwkIfeYbsFdtiR6TQz0acWiwJbv1IM/Nt/ite\";s:19:\"css/fontawesome.css\";s:71:\"sha384-1rquJLNOM3ijoueaaeS5m+McXPJCGdr5HcA03/VHXxcp2kX2sUrQDmFc3jR5i/C7\";s:15:\"css/regular.css\";s:71:\"sha384-ZlNfXjxAqKFWCwMwQFGhmMh3i89dWDnaFU2/VZg9CvsMGA7hXHQsPIqS+JIAmgEq\";s:13:\"css/solid.css\";s:71:\"sha384-VGP9aw4WtGH/uPAOseYxZ+Vz/vaTb1ehm1bwx92Fm8dTrE+3boLfF1SpAtB1z7HW\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-4K9ulTwOtsXr+7hczR7fImKfUZY5THwqvfxwPx1VUCEOt4qssi2Vm+kHY7NJQPoy\";s:16:\"css/v4-shims.css\";s:71:\"sha384-lmquXrF9qn7mMo6iRQ662vN44vTTVUBpcdtDFWPxD9uFPqC/aMn6pcQrTTupiv1A\";s:9:\"js/all.js\";s:71:\"sha384-kW+oWsYx3YpxvjtZjFXqazFpA7UP/MbiY4jvs+RWZo2+N94PFZ36T6TFkc9O3qoB\";s:12:\"js/brands.js\";s:71:\"sha384-2vdvXGQdnt+ze3ylY5ESeZ9TOxwxlOsldUzQBwtjvRpen1FwDT767SqyVbYrltjb\";s:17:\"js/fontawesome.js\";s:71:\"sha384-2OfHGv4zQZxcNK+oL8TR9pA+ADXtUODqGpIRy1zOgioC4X3+2vbOAp5Qv7uHM4Z8\";s:13:\"js/regular.js\";s:71:\"sha384-sqmLTIuB+bQgkyOcdJ/hAvXl51Z7qqdK/lcH/rt6sdvDKFincQWI+fVgcDZM6NMz\";s:11:\"js/solid.js\";s:71:\"sha384-GJiigN/ef2B3HMj0haY+eMmG4EIIrhWgGJ2Rv0IaWnNdWdbWPr1sRLkGz7xfjOFw\";s:14:\"js/v4-shims.js\";s:71:\"sha384-DtdEw3/pBQuSag11V3is/UZMjGkGMLDRBgk1UVAOvH6cYoqKjBmCEhePm13skjRV\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-9ralMzdK1QYsk4yBY680hmsb4/hJ98xK3w0TIaJ3ll4POWpWUYaA2bRjGGujGT8w\";s:14:\"css/brands.css\";s:71:\"sha384-AOiME8p6xSUbTO/93cbYmpOihKrqxrLjvkT2lOpIov+udKmjXXXFLfpKeqwTjNTC\";s:19:\"css/fontawesome.css\";s:71:\"sha384-Yz2UJoJEWBkb0TBzOd2kozX5/G4+z5WzWMMZz1Np2vwnFjF5FypnmBUBPH2gUa1F\";s:13:\"css/light.css\";s:71:\"sha384-9QuzjQIM/Un6pY9bKVJGLW8PauASO8Mf9y3QcsHhfZSXNyXGoXt/POh3VLeiv4mw\";s:15:\"css/regular.css\";s:71:\"sha384-pofSFWh/aTwxUvfNhg+LRpOXIFViguTD++4CNlmwgXOrQZj1EOJewBT+DmUVeyJN\";s:13:\"css/solid.css\";s:71:\"sha384-wJu5pIbEyJzi+kRgVKVQkPNKI104yNC+IAyK7XXEVGgPGe+LTEERIkpSZbc/wrOx\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-Hmg9TonawJaGH8ayFFnEBwvkx61BYLPAOV7b/YDGQEVIs1jh9pWQigAavMuD+Vc/\";s:16:\"css/v4-shims.css\";s:71:\"sha384-1YFoQoO5Em1oxLErpWpJuswiqPFVHl8HLDUaLjJGJH8+Nra/Y1D6uOZkEgfH5OZf\";s:9:\"js/all.js\";s:71:\"sha384-eAVkiER0fL/ySiqS7dXu8TLpoR8d9KRzIYtG0Tz7pi24qgQIIupp0fn2XA1H90fP\";s:12:\"js/brands.js\";s:71:\"sha384-am5AyalpQCEfbKe6FYiGZc2vX080nrcueZmrbkljxLdQDJ5q5Vu9QDROD/QefEp1\";s:17:\"js/fontawesome.js\";s:71:\"sha384-u3o36ga3mMU6/lK/zdiER4h7pPtAK7wBuN0DrZPH22v01RZL8bKZkULIjxcx2/X/\";s:11:\"js/light.js\";s:71:\"sha384-2R0W5LA7dXp3ze/WhvjXlUcDaHRhtGlKYxN9QMhGDdjmj2EI1bub5ysSwofJwGfI\";s:13:\"js/regular.js\";s:71:\"sha384-EbI+OvKb7noKOfu8MSi/vCbi0KWlM61MjHDmRk4/vwJkPsMIRcJggYLDGWv7VeYY\";s:11:\"js/solid.js\";s:71:\"sha384-U4vTrZsQ4ooEtzL162EZfTtCiJNTXOwGDBzV91//DI5L/h48ibzHBiHJmPLpx2hO\";s:14:\"js/v4-shims.js\";s:71:\"sha384-8e1r0+5VTqCqkg/9vG+cnipytzBkEh9fpESgVwBZAizMkWRfiaTkdhgdnhLGwuPd\";}}}s:5:\"5.4.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-5sAR7xN1Nv6T6+dT2mhtzEpVJvfS3NScPQTrOxhwjIuvcA67KV2R5Jz6kr4abQsz\";s:14:\"css/brands.css\";s:71:\"sha384-Px1uYmw7+bCkOsNAiAV5nxGKJ0Ixn5nChyW8lCK1Li1ic9nbO5pC/iXaq27X5ENt\";s:19:\"css/fontawesome.css\";s:71:\"sha384-BzCy2fixOYd0HObpx3GMefNqdbA7Qjcc91RgYeDjrHTIEXqiF00jKvgQG0+zY/7I\";s:15:\"css/regular.css\";s:71:\"sha384-4e3mPOi7K1/4SAx8aMeZqaZ1Pm4l73ZnRRquHFWzPh2Pa4PMAgZm8/WNh6ydcygU\";s:13:\"css/solid.css\";s:71:\"sha384-osqezT+30O6N/vsMqwW8Ch6wKlMofqueuia2H7fePy42uC05rm1G+BUPSd2iBSJL\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-2MWWLQq91kFwloAny7gkgoeV33bD/cE3A9ZbB2rCN/YAAR/VEHVoDq6vRJJYTaxM\";s:16:\"css/v4-shims.css\";s:71:\"sha384-YIDcSvDDaIskj/WDlWwjrNdK194YAGWc1CScdo2tXl3IQVS1zS07xQaoAFlXCf1P\";s:9:\"js/all.js\";s:71:\"sha384-L469/ELG4Bg9sDQbl0hvjMq8pOcqFgkSpwhwnslzvVVGpDjYJ6wJJyYjvG3u8XW7\";s:12:\"js/brands.js\";s:71:\"sha384-lc/yFuYW3B0EW9B2QSpod2KeBxq6/ZizGwAW6mRLUe3kKUVlSBfDIVZKwKIz/DBg\";s:17:\"js/fontawesome.js\";s:71:\"sha384-ISRc+776vRkDOTSbmnyoZFmwHy7hw2UR3KJpb4YtcfOyqUqhLGou8j5YmYnvQQJ4\";s:13:\"js/regular.js\";s:71:\"sha384-SQqzt64aAzh3UJ9XghcA//GE8+NxAIRcuCrrekyDokXP6Bbt/FYAFlV6VSPrZKwH\";s:11:\"js/solid.js\";s:71:\"sha384-agDKwSYPuGlC0wD14lKXXwb94jlUkbkoSugquwmKRKWv/nDXe1kApDS/gqUlRQmZ\";s:14:\"js/v4-shims.js\";s:71:\"sha384-/s2EnwEz7C3ziRundAGzeOAoGYffu84oY4SOHjhI/2Wqk3Z0usUm9bjdduzhZ9+z\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-POYwD7xcktv3gUeZO5s/9nUbRJG/WOmV6jfEGikMJu77LGYO8Rfs2X7URG822aum\";s:14:\"css/brands.css\";s:71:\"sha384-rmUpvtaCngUop5CYz7WL1LnqkMweXskxP+1AXmkuMSbImsUuy82bUYS4A8Syd3Pf\";s:19:\"css/fontawesome.css\";s:71:\"sha384-PPeKwWhk5XZBVVq089DuhGmjaEVB1r+jdmx6jZrqzlef8ojhZXG+E/D6SP7uO1dk\";s:13:\"css/light.css\";s:71:\"sha384-DZAoxBcs4G15aUXLX4vKbO53ye8L8AB/zg07HOVhIMVclhx8rdWye0AJSQl51ehV\";s:15:\"css/regular.css\";s:71:\"sha384-xKPOvJDwdb/n5w2kh6cxds98Ae2d5N63xkIydEdoYeA2bxIKUmmyU9lZ9j58mLYS\";s:13:\"css/solid.css\";s:71:\"sha384-oT4lQmwnKx98HRnFgaGvgCdjtKOjep9CjfMdAOPtJU8Vy6NY3X34GfqL0H43ydJn\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-j2EtHJUHBAZF9vkmX0TSA/QqYMf0Npp9P2leJGZFDbLHbcI62HH8w7FRcUMNf8Q2\";s:16:\"css/v4-shims.css\";s:71:\"sha384-aaXKvb/d7l2hTm3ZDWCy5v4ct5zXIslt+70K4xalZPLu3ifrkYcG61m4u+DIQGEk\";s:9:\"js/all.js\";s:71:\"sha384-0+tugznPwCEvPiypW+OwmFjAQvRKlgI0ZZZW3nofNlLMmbYXbmNvfX/9up9XQSRs\";s:12:\"js/brands.js\";s:71:\"sha384-ShBqjf9lFG58e2NmhnbVlhAOPCWdzkPbBmAEcQ37Liu3TwOYxIizS7J1P3rRLJHm\";s:17:\"js/fontawesome.js\";s:71:\"sha384-8vKKeD0uIV/HXM5ym3RGB4O7rZ43fCdpiXqP047w7sEE3igcK0Y1U9ApEArcRBDJ\";s:11:\"js/light.js\";s:71:\"sha384-jlaccvPpizUbHU/8pYAsDEwhhBae8MUcYqHHsKkjFcFsEp3Y6LrVXh0GA84aAkTg\";s:13:\"js/regular.js\";s:71:\"sha384-MB7Bz/7e8sBWnZgblSLUfFOOi+V1PIkRG/Ex1NMeu0CovaXCzHyCMwAwOF+FAo1s\";s:11:\"js/solid.js\";s:71:\"sha384-KlTWIsOnBg7LJobQmLsv5fQ1qbx73K+o8/xhoUDoIba13SxF4bT5W2WgV3d8mZIw\";s:14:\"js/v4-shims.js\";s:71:\"sha384-e+EZ4XUeGXVd0FDmP/mFu7FFe+qVX738ayOS2AErNIPSLz5oZ3OgVa9zEyCds3HP\";}}}s:5:\"5.4.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-/rXc/GQVaYpyDdyxK+ecHPVYJSN9bmVFBvjA/9eOB+pb3F2w2N6fc5qB9Ew5yIns\";s:14:\"css/brands.css\";s:71:\"sha384-BCEeiNUiLzxxoeYaIu7jJqq0aVVz2O2Ig4WbWEmRQ2Dx/AAxNV1wMDBXyyrxw1Zd\";s:19:\"css/fontawesome.css\";s:71:\"sha384-HU5rcgG/yUrsDGWsVACclYdzdCcn5yU8V/3V84zSrPDHwZEdjykadlgI6RHrxGrJ\";s:15:\"css/regular.css\";s:71:\"sha384-OEIzojYBMrmz48aIjVQj7VG38613/sxpP58OW9h5zBYC7biGFlv9tyu5kWmaAYlF\";s:13:\"css/solid.css\";s:71:\"sha384-uKQOWcYZKOuKmpYpvT0xCFAs/wE157X5Ua3H5onoRAOCNkJAMX/6QF0iXGGQV9cP\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-+moUZLBX5mmeUnjaImkzlTo5cXyQWAvzbqQapNFd7+dGIaap0koo0rtfe8lHD38R\";s:16:\"css/v4-shims.css\";s:71:\"sha384-SlbnWxwEHTVYxDLrpIRrG2BpsTpWALbJ6Tx5Fq+XNHRBL7xI6xwhVpuUGrrbLBXe\";s:9:\"js/all.js\";s:71:\"sha384-wp96dIgDl5BLlOXb4VMinXPNiB32VYBSoXOoiARzSTXY+tsK8yDTYfvdTyqzdGGN\";s:12:\"js/brands.js\";s:71:\"sha384-i1RNpxOOEnRm63Ii3TuV0aM8bJ+6Pv6XHpRSJbN7QlIzZIsl7m36R0GhOTTGN3F9\";s:17:\"js/fontawesome.js\";s:71:\"sha384-n1qPouQQJ9VNZnZeNZWSDiclpIOJwZBS2bkD6rEX+DTmMXTKXBVCZw2cGbU/I17z\";s:13:\"js/regular.js\";s:71:\"sha384-Uj7q9rRb3eJNp0j1kXwOBgEWDGbAiJ7Dcuz4hLRQdtza6pawbo/Bmwgr58THzHyR\";s:11:\"js/solid.js\";s:71:\"sha384-OQNCj138epg9A13jaL9L/d5vMlK2jyPL4aOgi37KYt07aZARbv/eFGp/wnrCxkW5\";s:14:\"js/v4-shims.js\";s:71:\"sha384-fzYnAZZYxpOQTjc3Y1eP04DGdMLAy+PeiZ8+ICh4FDLkJR/NJiAgKgK2vEpGx3au\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-zhaLg9HKxTxDljOPXpWHGn91XMDH+sYAWRSgvzHes290/ISyrNicGrd6BInTnx3L\";s:14:\"css/brands.css\";s:71:\"sha384-RjTk1OTKX8K8S4QfwhFOfbNSbQxLFgN6jqDw05QuBDDEbc/x6xlPtkPSO4vA1TtI\";s:19:\"css/fontawesome.css\";s:71:\"sha384-XkH+Vmez3OoFo52K+SkBE61xZ7vKh9tF35gL9Yf8rD3RtKUqIQGoTJTsLdR5u8rt\";s:13:\"css/light.css\";s:71:\"sha384-n0uyPlhqrQyWPPzm6+B9xDeZKCD81RgGRsTO7PQt3McgMXSR9zjhGaD5cXHwk+D8\";s:15:\"css/regular.css\";s:71:\"sha384-+OdrK32QtByk1ipA7b4+uLddrcWs2bx3nn37Dl5h98PW1AYKIrRZKveBl6AcpgcD\";s:13:\"css/solid.css\";s:71:\"sha384-SYCdBxlsgGngJi9eiKt5Tk6UtOJs1Jq5eU3yZDZ+hOe0GKk/obXhHy50IYVVdJro\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3f24zIRoR/ma/cnROK52rTVZpgCXKQ92/89RDq7GO7/9IxIl3VQV/tF6ecGgvUs8\";s:16:\"css/v4-shims.css\";s:71:\"sha384-ah4vMGE5UgKcCIB90FZl8BOcusXAVTm070n1UuOrNQA9QwkgnhqASrop/Oblr6wY\";s:9:\"js/all.js\";s:71:\"sha384-+lZy0zDh4RS9ZG6+Od6x6irKqoBH4NSy0m7IW8UGbzGZ/rupt9Cd9NdEb5S7+V9w\";s:12:\"js/brands.js\";s:71:\"sha384-LVdS6BqWBV1V0OyGzWK0HrGN4uDZbpO6hja1oVh86MhthieoER2crgKS/KsaiN8E\";s:17:\"js/fontawesome.js\";s:71:\"sha384-zMrS036pMtJ0Ukzo5x2YiTrYDGDaoeO8Yd0IHhI/PaEnfrY/nMHqvKME8C7dHhUE\";s:11:\"js/light.js\";s:71:\"sha384-hOiC7FL4572/E3aEEeWM6dF3ch/qFz59R91pAJqjYEKHBXN5u7e2oAYAgeSGF1VB\";s:13:\"js/regular.js\";s:71:\"sha384-f1yYCENdJ+9NE5J2T8weglyMCtTqRJOeGP9qaLwO43aYY0PVeuAfmsGgTegByFW6\";s:11:\"js/solid.js\";s:71:\"sha384-XlRgTEYU6HJ02+ZCuXW2/CgjnpV2+8FuQPTJSJ/+ZCQS5ZXRfIS5FHDRhMvOL++d\";s:14:\"js/v4-shims.js\";s:71:\"sha384-6TX+vqRZyQq+vB25wCb101/vY510EN37QZgs5f1dfG1+QYuIoQGdFFV8sx8W36AL\";}}}s:5:\"5.5.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-B4dIYHKNBt8Bc12p+WXckhzcICo0wtJAoU8YZTY5qE0Id1GSseTk6S+L3BlXeVIU\";s:14:\"css/brands.css\";s:71:\"sha384-QT2Z8ljl3UupqMtQNmPyhSPO/d5qbrzWmFxJqmY7tqoTuT2YrQLEqzvVOP2cT5XW\";s:19:\"css/fontawesome.css\";s:71:\"sha384-u5J7JghGz0qUrmEsWzBQkfvc8nK3fUT7DCaQzNQ+q4oEXhGSx+P2OqjWsfIRB8QT\";s:15:\"css/regular.css\";s:71:\"sha384-z3ccjLyn+akM2DtvRQCXJwvT5bGZsspS4uptQKNXNg778nyzvdMqiGcqHVGiAUyY\";s:13:\"css/solid.css\";s:71:\"sha384-rdyFrfAIC05c5ph7BKz3l5NG5yEottvO/DQ0dCrwD8gzeQDjYBHNr1ucUpQuljos\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-NKdowA6EzI4CWz/dLjoC7dhVj+KczesQbwkbt6y3aRTi1JPZBy2uOocsmHmYvkux\";s:16:\"css/v4-shims.css\";s:71:\"sha384-TTjEZR8VsD+LjNa98drkrTRYhdUEaS3gAGE7PGnx2qkePR3fZtnVNoAfxPNyf+IQ\";s:9:\"js/all.js\";s:71:\"sha384-GqVMZRt5Gn7tB9D9q7ONtcp4gtHIUEW/yG7h98J7IpE3kpi+srfFyyB/04OV6pG0\";s:12:\"js/brands.js\";s:71:\"sha384-S2C955KPLo8/zc2J7kJTG38hvFV+SnzXM6hwfEUhGHw5wPo6uXbnbjSJgw3clO4G\";s:17:\"js/fontawesome.js\";s:71:\"sha384-bNOdVeWbABef8Lh4uZ8c3lJXVlHdf8W5hh1OpJ4dGyqIEhMmcnJrosjQ36Kniaqm\";s:13:\"js/regular.js\";s:71:\"sha384-XrvTJeiQ46fxxPrZP6fay5yejA2FV4G1XsS8E4Piz6Fz+7FaEFTw7A7GR972irVV\";s:11:\"js/solid.js\";s:71:\"sha384-Xgf/DMe1667bioB9X1UM5QX+EG6FolMT4K7G+6rqNZBSONbmPh/qZ62nBPfTx+xG\";s:14:\"js/v4-shims.js\";s:71:\"sha384-vBDTb50BKnwbvJZ5ZC5dsGJNQydTI7ZoAjCeJkdta6nSewwGXCnppKI5lrIQX4Qu\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-j8y0ITrvFafF4EkV1mPW0BKm6dp3c+J9Fky22Man50Ofxo2wNe5pT1oZejDH9/Dt\";s:14:\"css/brands.css\";s:71:\"sha384-t0iPfoyIjBoVR2Kw/65HArpRWQy0/xKBUmdEVTs5VYBb/yiPZxMY6egc9MROr/Og\";s:19:\"css/fontawesome.css\";s:71:\"sha384-srL3Qh9R/n855m4o5fegS//B2q0R1md7z6ndDYaPj8iEp0j0IuKdFVWMY0JosKPF\";s:13:\"css/light.css\";s:71:\"sha384-33RmjeesW9BZ4wR2Gm3n4iBXOvGTto4znqL2kZleiRanWDxM59IHIq5RsbRioqxb\";s:15:\"css/regular.css\";s:71:\"sha384-UPs+YiUhgn0/I0swkJmk3PSj3SWmzDrM+S0S09xLI/UUmHBU7ivRHryI3uVL6H+m\";s:13:\"css/solid.css\";s:71:\"sha384-YIyAArzQv8q6Av1kr9cwxHhFcfNBUaolJindR2XO8E3OLp6z3d8My3oWLd33ET7M\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-a2sfkqnB9p/zq6OT4QhuD80qQZ70fGDmo4JUNqP5E7NIICvgRNPjIBkQE/Qcl3SN\";s:16:\"css/v4-shims.css\";s:71:\"sha384-SNyDPad7e8WM4Nu7W/f1x3qsDrLxMCvXurQfwNdp418WWmkkTQuPBGYDZA6rSg0X\";s:9:\"js/all.js\";s:71:\"sha384-3yBLeJ4waqGSAf4A8pjZ13UF7GuhgbdKnBQvIp/TkWoXtQbtwjlIPNjkDRJ46UCn\";s:12:\"js/brands.js\";s:71:\"sha384-oMyy7aPCmlH4ZGEaKHW+zAoaKDWIFh6iqJ53lusMpn+Kp8SN5nJ2kzkP1qd0+icb\";s:17:\"js/fontawesome.js\";s:71:\"sha384-oPma1F1txBbqTG+1O7BEx0A/qFtD+R661ULJLmI9RDQ0PfbRP1tQU3vBIBbJIAxL\";s:11:\"js/light.js\";s:71:\"sha384-SVEn5VmGP1fxV9V5TOZOTwL9dCg50Yb0Xn4fbV9Ic/kp8we6kv4zPVcs9seU0675\";s:13:\"js/regular.js\";s:71:\"sha384-gbY/GPDSEaMQ9cjqWLbLcaxUCtCeExO9oUEZLrOQHfFLoV5ouwIrqF6mGnjyIOc2\";s:11:\"js/solid.js\";s:71:\"sha384-VxezC2Q+YoC+yUILib+HlmOsFiqNzYtQIXsHYY6ST7QZVfgBNs2giKE97ijGMgUH\";s:14:\"js/v4-shims.js\";s:71:\"sha384-8sPM0eSaqmdF9ruedfsxEZfxVcIp0cwhosrBhWl/Q4t1eQSMXl6tYenNe87MraQ6\";}}}s:5:\"5.6.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-aOkxzJ5uQz7WBObEZcHvV5JvRW3TUc2rNPA7pe3AwnsUohiw1Vj2Rgx2KSOkF5+h\";s:14:\"css/brands.css\";s:71:\"sha384-oT8S/zsbHtHRVSs2Weo00ensyC4I8kyMsMhqTD4XrWxyi8NHHxnS0Hy+QEtgeKUE\";s:19:\"css/fontawesome.css\";s:71:\"sha384-J4287OME5B0yzlP80TtfccOBwJJt6xiO2KS14V7z0mVCRwpz+71z7lwP4yoFbTnD\";s:15:\"css/regular.css\";s:71:\"sha384-yWI8JeRmJFie/rrEn4skBd/XXXfUWuc7wAhaj9q71PzjdYD3JslHSEU7BXCCcVyP\";s:13:\"css/solid.css\";s:71:\"sha384-COsgLGwf6vbsibKzWojSqhIjQND/Sa0RWQ5BHFrKOz5JrUObnh5GEBUH2oZwITuM\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-nHELFCUV8tffuhz6PkFYcEl6VCneIQgaHNbLkOHukzJs12+rUiKwsVmVhbqhEAq7\";s:16:\"css/v4-shims.css\";s:71:\"sha384-HiCW4rrGA9WlUM512GMhD+YfcMidwWluZzyu+X55gfVYgAPrlIkG5BnHyAl/VHJO\";s:9:\"js/all.js\";s:71:\"sha384-z9ZOvGHHo21RqN5De4rfJMoAxYpaVoiYhuJXPyVmSs8yn20IE3PmBM534CffwSJI\";s:12:\"js/brands.js\";s:71:\"sha384-GEA3+tbEaglIUriKygE2OQX9k7YrAMJ5oZF0mb8Xx7hUmTTWDuQDtPY4l13jl99w\";s:17:\"js/fontawesome.js\";s:71:\"sha384-tHFnt8QELQGC1IJzcTUX5zFEnn/FLVa0ADTmxRyeSmWukJ4umWnJbwiMTkw/bKEK\";s:13:\"js/regular.js\";s:71:\"sha384-gy4pB6yY1j4DPCG6rZcE6NX1Lnqz8ZJEfotVUvCN2EGwlUS3WUHxcn8rrEOYiyiS\";s:11:\"js/solid.js\";s:71:\"sha384-akyniW0Jfrt1Z7kvRmaF2fkq9vuVQAPEGN4qq7s17l9PG3zz7FThoWnfVxpvnUn9\";s:14:\"js/v4-shims.js\";s:71:\"sha384-08SAgv7bDUyzB5O71dehOCZ42IpryGqW/G+GdxeFmBfaB71QIZWe5ZXBFKYFTEu4\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-rTQdcTFdT69CgbBErourkScWQ6j5WQ4aAoCF0UyPhog3PNysM/xz/kqshWKP4NLA\";s:14:\"css/brands.css\";s:71:\"sha384-84OQfm1oTwjnXmujNUnQC09L4G7mglZspQwfSNPvf5V3zAA1sdvqbIigA9AWY5DB\";s:19:\"css/fontawesome.css\";s:71:\"sha384-NFsDS9VURN70zaqw67F1OtJ6MtdeCrHeGMD1KzqIv5ft0JiHgVtV7u+v09yR+iEZ\";s:13:\"css/light.css\";s:71:\"sha384-aofICWgqJQbZZCaWEU7H0ULLqXTBu/DAALblEYqLfQSjb2ASOw0tADOdJ5rmVDWL\";s:15:\"css/regular.css\";s:71:\"sha384-voao2F8iKUwwSMRhLJ982edrRSHOmc5v5rvQ/5aH5pvSAx1aoL6usygGSRz3jfHF\";s:13:\"css/solid.css\";s:71:\"sha384-RYuivM1ikcxEL+96Q/7B/CcvyswPRuOatldvqvk+Bm3hwVKZUjay1ohuPUyD9ZYk\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-NYMicmsVmKaI5/JVN8JamOLMuIrbzeu4Gc+cike3jcoDpaLfMtvWPJeNhnx8K8x0\";s:16:\"css/v4-shims.css\";s:71:\"sha384-L7wiz9NeFS+vFpG/jl0zBsE7EqrVfeNoaHhnvxlsfwihUr9FIbDnfQqv5r8o02wQ\";s:9:\"js/all.js\";s:71:\"sha384-rDdEqfkiaN9iEfS6XrBzTxL5wVFzBoMsyHmoAIl/T7VdxJvGYuM5bDlDOkmE6r3C\";s:12:\"js/brands.js\";s:71:\"sha384-TN18fDSDUbMxI3DK3z2G8Pl68N7jvVjWPBx8z0m7YhoWKnmGdKRJ6S90IcyeUXUy\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Oa9P+sg4Q/5Yo0a/UoRAG8zLSexWLxLgbPb12tgvs/swrfePVf6IdrwoW2RGV2pU\";s:11:\"js/light.js\";s:71:\"sha384-6DMqAgIR8HN9OqBF3zfhQ4Tmh+KO9Sf0QAwxGkiaKO51dFGBBxBTmdOSneYESZZ0\";s:13:\"js/regular.js\";s:71:\"sha384-LvwwgOzFfwTikawPye02NmwONhyBLBbmu04J+IuLBS6HdNHX3JnRqY80mscKVLTH\";s:11:\"js/solid.js\";s:71:\"sha384-71d190zi1266uo3WuvCJ77V1YdXxDfm5GPMySGFKTMHsoHaxKhPe5XkKaH9iPLWC\";s:14:\"js/v4-shims.js\";s:71:\"sha384-Rr25noDuBAtBUFs9feRsF3EK8Pw5bWuhYxD7ztcDUJqR/eiCpNPGIeyO5Ago6pYW\";}}}s:5:\"5.6.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-gfdkjb5BdAXd+lj+gudLWI+BXq4IuLW5IT+brZEZsLFm++aCMlF1V92rMkPaX4PP\";s:14:\"css/brands.css\";s:71:\"sha384-whKHCkwP9f4MyD1vda26+XRyEg2zkyZezur14Kxc784RxUU1E7HvWVYj9EoJnUV7\";s:19:\"css/fontawesome.css\";s:71:\"sha384-WK8BzK0mpgOdhCxq86nInFqSWLzR5UAsNg0MGX9aDaIIrFWQ38dGdhwnNCAoXFxL\";s:15:\"css/regular.css\";s:71:\"sha384-l+NpTtA08hNNeMp0aMBg/cqPh507w3OvQSRoGnHcVoDCS9OtgxqgR7u8mLQv8poF\";s:13:\"css/solid.css\";s:71:\"sha384-aj0h5DVQ8jfwc8DA7JiM+Dysv7z+qYrFYZR+Qd/TwnmpDI6UaB3GJRRTdY8jYGS4\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-ir31wc9kqVZclsGL3U5IucynDpj1TeEzDCvxEWqw8QuxLFETRgirOiygjXdjId3z\";s:16:\"css/v4-shims.css\";s:71:\"sha384-s0z+GcIRRdtdjGfnyKRFh9Oaw3aasU/TFotdFmreqjf+a+Mks2Umj0CrlN0S9lqi\";s:9:\"js/all.js\";s:71:\"sha384-R5JkiUweZpJjELPWqttAYmYM1P3SNEJRM6ecTQF05pFFtxmCO+Y1CiUhvuDzgSVZ\";s:12:\"js/brands.js\";s:71:\"sha384-rsLJp1pKbmeEMVcdsNJfAWZ9FQP5CrQt6Vikj/usZcTgrD28FhqYqKJn5XIaoXjm\";s:17:\"js/fontawesome.js\";s:71:\"sha384-T6YzYwAGZAItTIkYlBzfwqa07o9R1AND3Lgt6Or6c5IdukY7tqShoryqwpKrpeIB\";s:13:\"js/regular.js\";s:71:\"sha384-+e+pqX41PD6VrFw9HZ3YKJHFT+SZoEMBmnMpLUpHrdd5BE46xHCrzap9c6kfTi9H\";s:11:\"js/solid.js\";s:71:\"sha384-8Lgyylu0vfTGCXDKe435hJgX8s96c19R+dvpH0NHKdX47GA7TmMj+BDiZZ76qqhT\";s:14:\"js/v4-shims.js\";s:71:\"sha384-LqOeBjW8oAuwB6xooSoyjAV+CcJLQGftH6m0Xoo+mhJ0TlEAVR9jBsAXXpeEJlyP\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-NJXGk7R+8gWGBdutmr+/d6XDokLwQhF1U3VA7FhvBDlOq7cNdI69z7NQdnXxcF7k\";s:14:\"css/brands.css\";s:71:\"sha384-2k7wpGHb3PA1OZUtSqAk+nIVo2wgBQdEoL1F/FnC+/HHi2bh3N9aSstY0Af72gka\";s:19:\"css/fontawesome.css\";s:71:\"sha384-GQK3B9PHv3SNzYUrdlEpL6CFKQlW/Co4va906SViL0F6U16Li47NXtvwWmFnetYk\";s:13:\"css/light.css\";s:71:\"sha384-QXb14MpvHKJr57ixwhGSXACaU/eGo/NwF/uWE97+C5QPdq8sLQhM1+WKDk6vando\";s:15:\"css/regular.css\";s:71:\"sha384-ThqFFlbk+2bnAn1zc61SL7r8sFUVUkFvtsT+jYr1Jy6xTlvdcqzcerrDGrHqWv6j\";s:13:\"css/solid.css\";s:71:\"sha384-pbj30780YbUh3WmbEAhOL8tHgoaU4xrdmAN+RewL6HsW9EOMIIE4+6rerMXTfJXq\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-fjim8BUuF/D2Y8Qyr4U5iLdeKqzyQe927qD4SIdbPDyX2iSN6xNGhoyd2jTiw+Sx\";s:16:\"css/v4-shims.css\";s:71:\"sha384-c2aTxrKw0nWEPlLqENAD5t3J3Ajs/o5LBudKFP44hexDYKKQTgRCAaECkBk+p3L9\";s:9:\"js/all.js\";s:71:\"sha384-ncMWtRMSOo+cLmfdaa6vmMGzBJKysBDF9tq5YK1MAnAjcyipdW2vgTS1jOntY4fs\";s:12:\"js/brands.js\";s:71:\"sha384-+4YdTIsot+hvYL7nKQ9cJs7OWaFvJ7ZTkVretfEoX8uDiTED9tumG/9RsRmlW3jX\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Ya+lFT8MCnVaSXkMxO4FEUsv4BG1VrVAMY0PiCnmJ4Sq57zoarae8T2EgioHiaMA\";s:11:\"js/light.js\";s:71:\"sha384-hy7ipunNmCKP7KpzkasGow2eTRYx9IbxV0BvBqlWLWRu8mlWMNrj9y6qOLEnxIuF\";s:13:\"js/regular.js\";s:71:\"sha384-8VWoI12VOwcfxYszEUreYXR4Jh1+oxv+mfsVISgPJTsc2Ftw4RC+bO719C+PunjY\";s:11:\"js/solid.js\";s:71:\"sha384-Pl3KUQLNwa33i6dvnL77HMDxZPk93eoi1kB5xZ0eGKgTEt39iQkHdSM6/w53By9e\";s:14:\"js/v4-shims.js\";s:71:\"sha384-ts+GFi6rOAISeHC+EnLaj6AOSoosWr3TALIaYSeHCVsNHkGLlTtzdbMvolIe6tG7\";}}}s:5:\"5.6.3\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-UHRtZLI+pbxtHCWp1t77Bi1L4ZtiqrqD80Kn4Z8NTSRyMA2Fd33n5dQ8lWUE00s/\";s:14:\"css/brands.css\";s:71:\"sha384-1KLgFVb/gHrlDGLFPgMbeedi6tQBLcWvyNUN+YKXbD7ZFbjX6BLpMDf0PJ32XJfX\";s:19:\"css/fontawesome.css\";s:71:\"sha384-jLuaxTTBR42U2qJ/pm4JRouHkEDHkVqH0T1nyQXn1mZ7Snycpf6Rl25VBNthU4z0\";s:15:\"css/regular.css\";s:71:\"sha384-aubIA90W7NxJ+Ly4QHAqo1JBSwQ0jejV75iHhj59KRwVjLVHjuhS3LkDAoa/ltO4\";s:13:\"css/solid.css\";s:71:\"sha384-+0VIRx+yz1WBcCTXBkVQYIBVNEFH1eP6Zknm16roZCyeNg2maWEpk/l/KsyFKs7G\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-KHV7fADs212mr+U2tmuDnxozv2BzTX1qhxPoZ/lT2QcUFkjwat694MI3AzyiVJ+q\";s:16:\"css/v4-shims.css\";s:71:\"sha384-DrjN/yxBJAblffPf548CARk30Xz2Glal7YO5kqQ8c8GHgrAMXZN2ZDTGwV9xTDJF\";s:9:\"js/all.js\";s:71:\"sha384-EIHISlAOj4zgYieurP0SdoiBYfGJKkgWedPHH4jCzpCXLmzVsw1ouK59MuUtP4a1\";s:12:\"js/brands.js\";s:71:\"sha384-VLgz+MgaFCnsFLiBwE3ItNouuqbWV2ZnIqfsA6QRHksEAQfgbcoaQ4PP0ZeS0zS5\";s:17:\"js/fontawesome.js\";s:71:\"sha384-treYPdjUrP4rW5q82SnECO7TPVAz4bpas16yuE9F5o7CeBn2YYw1yr5oC8s8Mf8t\";s:13:\"js/regular.js\";s:71:\"sha384-V+AkgA1cZ+p3DRK63AHCaXvO68V7B5eHoxl7QVN21zftbkFn/sGAIVR7vmQL3Zhp\";s:11:\"js/solid.js\";s:71:\"sha384-F4BRNf3onawQt7LDHDJm/hwm3wBtbLIfGk1VSB/3nn3E+7Rox1YpYcKJMsmHBJIl\";s:14:\"js/v4-shims.js\";s:71:\"sha384-miy+FCz1uGOaEWy6IaOB4X2pp60+e6jaSECmnvz+qo7Os/Q1oflHUIrS0JdfNafk\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-LRlmVvLKVApDVGuspQFnRQJjkv0P7/YFrw84YYQtmYG4nK8c+M+NlmYDCv0rKWpG\";s:14:\"css/brands.css\";s:71:\"sha384-1KLgFVb/gHrlDGLFPgMbeedi6tQBLcWvyNUN+YKXbD7ZFbjX6BLpMDf0PJ32XJfX\";s:19:\"css/fontawesome.css\";s:71:\"sha384-toEUmnrGu+eq8XUD6ovsr/vFX+R3v9+FUGAnpef+uwGKMCeqZkcZfkXQ0Pls5WS7\";s:13:\"css/light.css\";s:71:\"sha384-ouQ4uivIto2ZdBS6+torZMbImJhWA6/m7/CAGY9z0FNDmoAF6uWAEnavvIsR1EBt\";s:15:\"css/regular.css\";s:71:\"sha384-IXqJGQI1K0IzdpdY2ASrRbDgPr1rUKzDAA90uL7iX1hPQf6Tkve9Z82TUVWm9aje\";s:13:\"css/solid.css\";s:71:\"sha384-5XPOduYq6F78ZOuHxFHpQJCD2l7aCHCf0+o8qKTD2VfqJTgPT3YkyuBGsDSrVsic\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-KHV7fADs212mr+U2tmuDnxozv2BzTX1qhxPoZ/lT2QcUFkjwat694MI3AzyiVJ+q\";s:16:\"css/v4-shims.css\";s:71:\"sha384-U1d6UqL28bnGVHunjKzlOZ8IatZ4il21uTor0FijL3224okgH54hOnOVB50CDK0M\";s:9:\"js/all.js\";s:71:\"sha384-4Gm0M5DjJ0zGaEtLu0ztNIoHWiuJ5rKiaVlpZKeNqXAW49eIIa2ymxb3C4c3uEXR\";s:12:\"js/brands.js\";s:71:\"sha384-VLgz+MgaFCnsFLiBwE3ItNouuqbWV2ZnIqfsA6QRHksEAQfgbcoaQ4PP0ZeS0zS5\";s:17:\"js/fontawesome.js\";s:71:\"sha384-treYPdjUrP4rW5q82SnECO7TPVAz4bpas16yuE9F5o7CeBn2YYw1yr5oC8s8Mf8t\";s:11:\"js/light.js\";s:71:\"sha384-E2rKHkorMllWJmt2GKXlwZ3+kPl6i3FrJ8ihFkf6F7F/AtGvuXY21bQC8mhz2Po+\";s:13:\"js/regular.js\";s:71:\"sha384-nX7teCj1FtQErhxXjr+JWXfe4EjU6KlgeVBHAzQ/L95eWzwx+W1+HuQGmxZT9VkS\";s:11:\"js/solid.js\";s:71:\"sha384-2ZaaAuh8tTVN1nHRrlXAX1tz8fGhZDgusJdBI5BBGycCq37AUonw8dHlPpx7iD6N\";s:14:\"js/v4-shims.js\";s:71:\"sha384-q8jijYZFNY4pjTA22Qe+33WWGmm0tpPPfMEdUxmXNoEkN5YeCMJYxGcl+XiCckQh\";}}}s:5:\"5.7.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-lZN37f5QGtY3VHgisS14W3ExzMWZxybE1SJSEsQp9S+oqd12jhcu+A56Ebc1zFSJ\";s:14:\"css/brands.css\";s:71:\"sha384-BKw0P+CQz9xmby+uplDwp82Py8x1xtYPK3ORn/ZSoe6Dk3ETP59WCDnX+fI1XCKK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-4aon80D8rXCGx9ayDt85LbyUHeMWd3UiBaWliBlJ53yzm9hqN21A+o1pqoyK04h+\";s:15:\"css/regular.css\";s:71:\"sha384-IG162Tfx2WTn//TRUi9ahZHsz47lNKzYOp0b6Vv8qltVlPkub2yj9TVwzNck6GEF\";s:13:\"css/solid.css\";s:71:\"sha384-r/k8YTFqmlOaqRkZuSiE9trsrDXkh07mRaoGBMoDcmA58OHILZPsk29i2BsFng1B\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3oHRxwaq4aKTY0NVNLfynvnb/U7E0MGiosKUE4cNMIDRezfXvssVlwQ+xsuBLbXf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-DrjN/yxBJAblffPf548CARk30Xz2Glal7YO5kqQ8c8GHgrAMXZN2ZDTGwV9xTDJF\";s:9:\"js/all.js\";s:71:\"sha384-qD/MNBVMm3hVYCbRTSOW130+CWeRIKbpot9/gR1BHkd7sIct4QKhT1hOPd+2hO8K\";s:12:\"js/brands.js\";s:71:\"sha384-zJ8/qgGmKwL+kr/xmGA6s1oXK63ah5/1rHuILmZ44sO2Bbq1V3p3eRTkuGcivyhD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-av0fZBtv517ppGAYKqqaiTvWEK6WXW7W0N1ocPSPI/wi+h8qlgWck2Hikm5cxH0E\";s:13:\"js/regular.js\";s:71:\"sha384-Gxfqh68NuE4s0o2renzieYkDYVbdJynynsdrB7UG9yEvgpS9TVM+c4bknWfQXUBg\";s:11:\"js/solid.js\";s:71:\"sha384-6FXzJ8R8IC4v/SKPI8oOcRrUkJU8uvFK6YJ4eDY11bJQz4lRw5/wGthflEOX8hjL\";s:14:\"js/v4-shims.js\";s:71:\"sha384-miy+FCz1uGOaEWy6IaOB4X2pp60+e6jaSECmnvz+qo7Os/Q1oflHUIrS0JdfNafk\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-6jHF7Z3XI3fF4XZixAuSu0gGKrXwoX/w3uFPxC56OtjChio7wtTGJWRW53Nhx6Ev\";s:14:\"css/brands.css\";s:71:\"sha384-BKw0P+CQz9xmby+uplDwp82Py8x1xtYPK3ORn/ZSoe6Dk3ETP59WCDnX+fI1XCKK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-iD1qS/uJjE9q9kecNUe9R4FRvcinAvTcPClTz7NI8RI5gUsJ+eaeJeblG1Ex0ieh\";s:13:\"css/light.css\";s:71:\"sha384-puvvQVSC+mXL7INuI0i5Q7QkwwIyYIBJ7caGHiUXD7FndtoyNd78NxgvuBJAYI2m\";s:15:\"css/regular.css\";s:71:\"sha384-4Cp0kYV2i1JFDfp6MQAdlrauJM+WTabydjMk5iJ7A9D+TXIh5zQMd5KXydBCAUN4\";s:13:\"css/solid.css\";s:71:\"sha384-j+2fZ2qAg9GyYKkVpuwm+HLQVz6EYCaTqS3KKx8oectYXMgm4bRmohzCfEvi5j7J\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3oHRxwaq4aKTY0NVNLfynvnb/U7E0MGiosKUE4cNMIDRezfXvssVlwQ+xsuBLbXf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-U1d6UqL28bnGVHunjKzlOZ8IatZ4il21uTor0FijL3224okgH54hOnOVB50CDK0M\";s:9:\"js/all.js\";s:71:\"sha384-uyhTADGMAJuHgGNdH+rozTpOkfXUORTgjTmMBtxR8ISQjOs+IIWb8UBn9ixSd4xo\";s:12:\"js/brands.js\";s:71:\"sha384-zJ8/qgGmKwL+kr/xmGA6s1oXK63ah5/1rHuILmZ44sO2Bbq1V3p3eRTkuGcivyhD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-av0fZBtv517ppGAYKqqaiTvWEK6WXW7W0N1ocPSPI/wi+h8qlgWck2Hikm5cxH0E\";s:11:\"js/light.js\";s:71:\"sha384-Vs12SjRkIvphC81scjUNowpLYnSOLOrSGxOwVe00oEvWto49wVgjd6BfdeCPcArI\";s:13:\"js/regular.js\";s:71:\"sha384-JZmzMsvgUATRcNmXpyJHLhiqsREsPN/GBj7O5ifVfRU1o4vBp2dsjawGzYzl0QVW\";s:11:\"js/solid.js\";s:71:\"sha384-OzCiQJ65BS/RiwFjTWyem+uRtZ4/LnrVVbwHTT8fR5Q9rYqAaavyOK51RDxkXQzm\";s:14:\"js/v4-shims.js\";s:71:\"sha384-q8jijYZFNY4pjTA22Qe+33WWGmm0tpPPfMEdUxmXNoEkN5YeCMJYxGcl+XiCckQh\";}}}s:5:\"5.7.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-fnmOCqbTlWIlj8LyTjo7mOUStjsKC4pOpQbqyi7RrhN7udi9RwhKkMHpvLbHG9Sr\";s:14:\"css/brands.css\";s:71:\"sha384-BKw0P+CQz9xmby+uplDwp82Py8x1xtYPK3ORn/ZSoe6Dk3ETP59WCDnX+fI1XCKK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-4aon80D8rXCGx9ayDt85LbyUHeMWd3UiBaWliBlJ53yzm9hqN21A+o1pqoyK04h+\";s:15:\"css/regular.css\";s:71:\"sha384-IG162Tfx2WTn//TRUi9ahZHsz47lNKzYOp0b6Vv8qltVlPkub2yj9TVwzNck6GEF\";s:13:\"css/solid.css\";s:71:\"sha384-r/k8YTFqmlOaqRkZuSiE9trsrDXkh07mRaoGBMoDcmA58OHILZPsk29i2BsFng1B\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3oHRxwaq4aKTY0NVNLfynvnb/U7E0MGiosKUE4cNMIDRezfXvssVlwQ+xsuBLbXf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-DrjN/yxBJAblffPf548CARk30Xz2Glal7YO5kqQ8c8GHgrAMXZN2ZDTGwV9xTDJF\";s:9:\"js/all.js\";s:71:\"sha384-eVEQC9zshBn0rFj4+TU78eNA19HMNigMviK/PU/FFjLXqa/GKPgX58rvt5Z8PLs7\";s:12:\"js/brands.js\";s:71:\"sha384-zJ8/qgGmKwL+kr/xmGA6s1oXK63ah5/1rHuILmZ44sO2Bbq1V3p3eRTkuGcivyhD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Qmms7kHsbqYnKkSwiePYzreT+ufFVSNBhfLOEp0sEEfEVdORDs/aEnGaJy/l4eoy\";s:13:\"js/regular.js\";s:71:\"sha384-Gxfqh68NuE4s0o2renzieYkDYVbdJynynsdrB7UG9yEvgpS9TVM+c4bknWfQXUBg\";s:11:\"js/solid.js\";s:71:\"sha384-6FXzJ8R8IC4v/SKPI8oOcRrUkJU8uvFK6YJ4eDY11bJQz4lRw5/wGthflEOX8hjL\";s:14:\"js/v4-shims.js\";s:71:\"sha384-miy+FCz1uGOaEWy6IaOB4X2pp60+e6jaSECmnvz+qo7Os/Q1oflHUIrS0JdfNafk\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-6jHF7Z3XI3fF4XZixAuSu0gGKrXwoX/w3uFPxC56OtjChio7wtTGJWRW53Nhx6Ev\";s:14:\"css/brands.css\";s:71:\"sha384-BKw0P+CQz9xmby+uplDwp82Py8x1xtYPK3ORn/ZSoe6Dk3ETP59WCDnX+fI1XCKK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-iD1qS/uJjE9q9kecNUe9R4FRvcinAvTcPClTz7NI8RI5gUsJ+eaeJeblG1Ex0ieh\";s:13:\"css/light.css\";s:71:\"sha384-puvvQVSC+mXL7INuI0i5Q7QkwwIyYIBJ7caGHiUXD7FndtoyNd78NxgvuBJAYI2m\";s:15:\"css/regular.css\";s:71:\"sha384-4Cp0kYV2i1JFDfp6MQAdlrauJM+WTabydjMk5iJ7A9D+TXIh5zQMd5KXydBCAUN4\";s:13:\"css/solid.css\";s:71:\"sha384-j+2fZ2qAg9GyYKkVpuwm+HLQVz6EYCaTqS3KKx8oectYXMgm4bRmohzCfEvi5j7J\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3oHRxwaq4aKTY0NVNLfynvnb/U7E0MGiosKUE4cNMIDRezfXvssVlwQ+xsuBLbXf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-U1d6UqL28bnGVHunjKzlOZ8IatZ4il21uTor0FijL3224okgH54hOnOVB50CDK0M\";s:9:\"js/all.js\";s:71:\"sha384-5atZgfYD4MHp6kAnxjw4yM3binN4Yh5XXKAIO6m2kIB9CqdRUladdvTdffLnTK3N\";s:12:\"js/brands.js\";s:71:\"sha384-zJ8/qgGmKwL+kr/xmGA6s1oXK63ah5/1rHuILmZ44sO2Bbq1V3p3eRTkuGcivyhD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Qmms7kHsbqYnKkSwiePYzreT+ufFVSNBhfLOEp0sEEfEVdORDs/aEnGaJy/l4eoy\";s:11:\"js/light.js\";s:71:\"sha384-ua13CrU9gkzyOVxhPFl96iHgwnYTuTZ96YYiG08m1fYLvz8cVyHluzkzK9WcFLpT\";s:13:\"js/regular.js\";s:71:\"sha384-SdSeoV46BZSFmxvlUQwl3ImF6ton2ST4pPzYOmTTkFUm+UjdzORM0pTtF0sIHydx\";s:11:\"js/solid.js\";s:71:\"sha384-eLZVpmyzMTRsfwRGkcmyu0PXR5qqYDBCSh5PoYLdWFfDmMIibSuru0Blk+nq1Vfm\";s:14:\"js/v4-shims.js\";s:71:\"sha384-q8jijYZFNY4pjTA22Qe+33WWGmm0tpPPfMEdUxmXNoEkN5YeCMJYxGcl+XiCckQh\";}}}s:5:\"5.7.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-fnmOCqbTlWIlj8LyTjo7mOUStjsKC4pOpQbqyi7RrhN7udi9RwhKkMHpvLbHG9Sr\";s:14:\"css/brands.css\";s:71:\"sha384-BKw0P+CQz9xmby+uplDwp82Py8x1xtYPK3ORn/ZSoe6Dk3ETP59WCDnX+fI1XCKK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-4aon80D8rXCGx9ayDt85LbyUHeMWd3UiBaWliBlJ53yzm9hqN21A+o1pqoyK04h+\";s:15:\"css/regular.css\";s:71:\"sha384-IG162Tfx2WTn//TRUi9ahZHsz47lNKzYOp0b6Vv8qltVlPkub2yj9TVwzNck6GEF\";s:13:\"css/solid.css\";s:71:\"sha384-r/k8YTFqmlOaqRkZuSiE9trsrDXkh07mRaoGBMoDcmA58OHILZPsk29i2BsFng1B\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3oHRxwaq4aKTY0NVNLfynvnb/U7E0MGiosKUE4cNMIDRezfXvssVlwQ+xsuBLbXf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-DrjN/yxBJAblffPf548CARk30Xz2Glal7YO5kqQ8c8GHgrAMXZN2ZDTGwV9xTDJF\";s:9:\"js/all.js\";s:71:\"sha384-0pzryjIRos8mFBWMzSSZApWtPl/5++eIfzYmTgBBmXYdhvxPc+XcFEk+zJwDgWbP\";s:12:\"js/brands.js\";s:71:\"sha384-zJ8/qgGmKwL+kr/xmGA6s1oXK63ah5/1rHuILmZ44sO2Bbq1V3p3eRTkuGcivyhD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-xl26xwG2NVtJDw2/96Lmg09++ZjrXPc89j0j7JHjLOdSwHDHPHiucUjfllW0Ywrq\";s:13:\"js/regular.js\";s:71:\"sha384-Gxfqh68NuE4s0o2renzieYkDYVbdJynynsdrB7UG9yEvgpS9TVM+c4bknWfQXUBg\";s:11:\"js/solid.js\";s:71:\"sha384-6FXzJ8R8IC4v/SKPI8oOcRrUkJU8uvFK6YJ4eDY11bJQz4lRw5/wGthflEOX8hjL\";s:14:\"js/v4-shims.js\";s:71:\"sha384-miy+FCz1uGOaEWy6IaOB4X2pp60+e6jaSECmnvz+qo7Os/Q1oflHUIrS0JdfNafk\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-6jHF7Z3XI3fF4XZixAuSu0gGKrXwoX/w3uFPxC56OtjChio7wtTGJWRW53Nhx6Ev\";s:14:\"css/brands.css\";s:71:\"sha384-BKw0P+CQz9xmby+uplDwp82Py8x1xtYPK3ORn/ZSoe6Dk3ETP59WCDnX+fI1XCKK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-iD1qS/uJjE9q9kecNUe9R4FRvcinAvTcPClTz7NI8RI5gUsJ+eaeJeblG1Ex0ieh\";s:13:\"css/light.css\";s:71:\"sha384-puvvQVSC+mXL7INuI0i5Q7QkwwIyYIBJ7caGHiUXD7FndtoyNd78NxgvuBJAYI2m\";s:15:\"css/regular.css\";s:71:\"sha384-4Cp0kYV2i1JFDfp6MQAdlrauJM+WTabydjMk5iJ7A9D+TXIh5zQMd5KXydBCAUN4\";s:13:\"css/solid.css\";s:71:\"sha384-j+2fZ2qAg9GyYKkVpuwm+HLQVz6EYCaTqS3KKx8oectYXMgm4bRmohzCfEvi5j7J\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3oHRxwaq4aKTY0NVNLfynvnb/U7E0MGiosKUE4cNMIDRezfXvssVlwQ+xsuBLbXf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-U1d6UqL28bnGVHunjKzlOZ8IatZ4il21uTor0FijL3224okgH54hOnOVB50CDK0M\";s:9:\"js/all.js\";s:71:\"sha384-I3Hhe9TkmlsxzooTtbRzdeLbmkFQE9DVzX/19uTZfHk1zn/uWUyk+a+GyrHyseSq\";s:12:\"js/brands.js\";s:71:\"sha384-zJ8/qgGmKwL+kr/xmGA6s1oXK63ah5/1rHuILmZ44sO2Bbq1V3p3eRTkuGcivyhD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-xl26xwG2NVtJDw2/96Lmg09++ZjrXPc89j0j7JHjLOdSwHDHPHiucUjfllW0Ywrq\";s:11:\"js/light.js\";s:71:\"sha384-ua13CrU9gkzyOVxhPFl96iHgwnYTuTZ96YYiG08m1fYLvz8cVyHluzkzK9WcFLpT\";s:13:\"js/regular.js\";s:71:\"sha384-SdSeoV46BZSFmxvlUQwl3ImF6ton2ST4pPzYOmTTkFUm+UjdzORM0pTtF0sIHydx\";s:11:\"js/solid.js\";s:71:\"sha384-eLZVpmyzMTRsfwRGkcmyu0PXR5qqYDBCSh5PoYLdWFfDmMIibSuru0Blk+nq1Vfm\";s:14:\"js/v4-shims.js\";s:71:\"sha384-q8jijYZFNY4pjTA22Qe+33WWGmm0tpPPfMEdUxmXNoEkN5YeCMJYxGcl+XiCckQh\";}}}s:5:\"5.8.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-Mmxa0mLqhmOeaE8vgOSbKacftZcsNYDjQzuCOm6D02luYSzBG8vpaOykv9lFQ51Y\";s:14:\"css/brands.css\";s:71:\"sha384-5G2m52y/zN053yjBCyNXXotYpL2r5k1wg9aakiM5OgK9kdcCB68EECUce5vZiz/8\";s:19:\"css/fontawesome.css\";s:71:\"sha384-Sbwc59I1SOoVoCGgBCwAe/M1j5a9cHixHv/7x9vOxORnT73jUaxyK0paobkk3JSt\";s:15:\"css/regular.css\";s:71:\"sha384-Vma7aWQBdmjVfr98uRd1HcA/r6wPYrlNrIvQBJhDCvZi3X9gVuHtqUKUYep/1KKk\";s:13:\"css/solid.css\";s:71:\"sha384-n4xPrkfCJ3FzmPwM/Nf1QQu7Qx6oDcsbMp+qPOxrJ5w0Tq19ZWd9ylcMWkzKEpwP\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-5ywFB7dcUP6RcAWMLvCE58MQE5YMXWSPjly1IqItdN0w0TqoJD+w68U7C3ShoZRk\";s:16:\"css/v4-shims.css\";s:71:\"sha384-IaQiZkMW7NRKIS04GeT98++WyQ6RNaEQlHoHoDrhU+hhCJE4EkfL7itJyj/vanQT\";s:9:\"js/all.js\";s:71:\"sha384-ukiibbYjFS/1dhODSWD+PrZ6+CGCgf8VbyUH7bQQNUulL+2r59uGYToovytTf4Xm\";s:12:\"js/brands.js\";s:71:\"sha384-Gt4maPu5ZO/PkTh32sKMYmmCLGuWtMkv5YBtFZpx4Tu+Of3kFZPYBw9iD/pi4L6s\";s:17:\"js/fontawesome.js\";s:71:\"sha384-TAztyRuTlqgZ97tz982rMo44MRC58wyCC0pqKZY3cKWJNkK00qMd3DhQ7R25jpCe\";s:13:\"js/regular.js\";s:71:\"sha384-IQnlolMpq26nEj6AOd6JOnY2jqCa69uFBqCGBCWSm4EFZYprebVtp3Z2xVLMElvs\";s:11:\"js/solid.js\";s:71:\"sha384-prcFDC6iTvvWsx2iSZtbDdeMVWWOtxcQXXagr9uPHwi42uae31Y3Q17eehHuC0JL\";s:14:\"js/v4-shims.js\";s:71:\"sha384-l9bFz0TmR1ecMQdb9mzBeiLLX3z0mqeK0Bsxhim3nnHB9PoA6o3FUumLH7K6W6/D\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-/pOR6TNYPdUaQQQRKQ4XHznZ4U2K/Lscb3u6jshUngC/31fLTuyX9FZb24gp4O3J\";s:14:\"css/brands.css\";s:71:\"sha384-OxPYtFc8yWHWBo2MFY4rHs5dKcTpNGuyft0hQ+K/vSUJA21jrxi+Py412o2wMvsL\";s:19:\"css/fontawesome.css\";s:71:\"sha384-/0C3VuTlEzBany89/Wf2OJLSGrduLCC28kuoGL/PCGJjGj01pVtiqOcgZZ9AtlET\";s:13:\"css/light.css\";s:71:\"sha384-YmipRqYc8Wly1koaxcpAPTnvJIqXBN4Ue5+l0drZn34sdM+UufP6v8D8/s9xxXOI\";s:15:\"css/regular.css\";s:71:\"sha384-iUhpWyroENmdb/oNEGUdCk4J+TfFOm/SNYi79nN/Hb1aQgjofylAAuRTUfpK2yP1\";s:13:\"css/solid.css\";s:71:\"sha384-maIT5Qg1FqlJhNYpN2IgLAb5XPLY8CqZ7tKBQyjHh+nx/7JXsI5bp+8JHnUgeuyw\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-BUeh/IoVXY+o863GdrQzogOOSo3ABFpxuc9xZhQVnsM2T2vKmrpHGZwaEqqX/SZs\";s:16:\"css/v4-shims.css\";s:71:\"sha384-lRITDKAHusCdCcsQiEA2IIoqExMRD36Tbn9CZj00L8klRpDyMeOoPSv6ubcNAHux\";s:9:\"js/all.js\";s:71:\"sha384-gUdv3ElxXd3gVdbCqjppYoQanRONrQDSdaZY3zn1KeASeS8YGy+T/JDaD2ohyarV\";s:12:\"js/brands.js\";s:71:\"sha384-XLy4uPbRNbMJUgEm6JLmHI784E68XjgSbheIn0fP/6GdZtCcsZmlXvceAGvhzKCh\";s:17:\"js/fontawesome.js\";s:71:\"sha384-aoV9M7ZLyivlmo8GKrkeWiOUQzBnYBpP6U8gW7WXfhssy+HtO87KzowcBokSiK3g\";s:11:\"js/light.js\";s:71:\"sha384-+itlrN2dvS1RqmWnkLQkDqzANbdKqtt6JyQfE/DXxFnhg/PXf0ufRBCSp0c6q81i\";s:13:\"js/regular.js\";s:71:\"sha384-GoKOHat5yLSUYiGMfLJkuCErUZrNlW+2FeFYuKOt7sUWbqvMQOqfB+mdpfCU/8Q4\";s:11:\"js/solid.js\";s:71:\"sha384-jOmpRjxTFmJAVhf7+H7o9joWtQWHRZLdr+B25WojM1yfhB9wFkDvQ3x0VDDn4aAI\";s:14:\"js/v4-shims.js\";s:71:\"sha384-gaNKDFtFZuAyZDkB8Wov1Vl24lMu5MD5MXLmUSu+4HzB8tTVwemJnhqN4Zuj27wd\";}}}s:5:\"5.8.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-50oBUHEmvpQ+1lW4y57PTFmhCaXp0ML5d60M1M7uH2+nqUivzIebhndOJK28anvf\";s:14:\"css/brands.css\";s:71:\"sha384-n9+6/aSqa9lBidZMRCQHTHKJscPq6NW4pCQBiMmHdUCvPN8ZOg2zJJTkC7WIezWv\";s:19:\"css/fontawesome.css\";s:71:\"sha384-vd1e11sR28tEK9YANUtpIOdjGW14pS87bUBuOIoBILVWLFnS+MCX9T6MMf0VdPGq\";s:15:\"css/regular.css\";s:71:\"sha384-FKw7x8fCxuvzBwOJmhTJJsKzBl8dnN9e2R4+pXRfYoHivikuHkzWyhKWDSMcGNK8\";s:13:\"css/solid.css\";s:71:\"sha384-QokYePQSOwpBDuhlHOsX0ymF6R/vLk/UQVz3WHa6wygxI5oGTmDTv8wahFOSspdm\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-acBDV8BDMPEP50gJeFdMIg9yE8eOPuFdBV9r+2F492NUbKhURdQvglFkG0Q+0rlE\";s:16:\"css/v4-shims.css\";s:71:\"sha384-knhdgIEP1JBPHETtXGyUk1FXV22kd1ZAN8yyExweAKAfztV5+kSBjUff4pHDG38c\";s:9:\"js/all.js\";s:71:\"sha384-g5uSoOSBd7KkhAMlnQILrecXvzst9TdC09/VM+pjDTCM+1il8RHz5fKANTFFb+gQ\";s:12:\"js/brands.js\";s:71:\"sha384-rUOIFHM3HXni/WG5pzDhA1e2Js5nn4bWudTYujHbbI9ztBIxK54CL4ZNZWwcBQeD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-EMmnH+Njn8umuoSMZ3Ae3bC9hDknHKOWL2e9WJD/cN6XLeAN7tr5ZQ0Hx5HDHtkS\";s:13:\"js/regular.js\";s:71:\"sha384-Uc9toywOA44owltk1MWl0lQZ+L0mBzJkLQcdif6+JtG9izvok9DLJtCZX57Uq3k2\";s:11:\"js/solid.js\";s:71:\"sha384-IA6YnujJIO+z1m4NKyAGvZ9Wmxrd4Px8WFqhFcgRmwLaJaiwijYgApVpo1MV8p77\";s:14:\"js/v4-shims.js\";s:71:\"sha384-DWlD0qU0+4WTFKXrFbt8wXq/1NHvOGT8vwllYM0W2gIeqgaCC3bZ0U464mDtbR70\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-Bx4pytHkyTDy3aJKjGkGoHPt3tvv6zlwwjc3iqN7ktaiEMLDPqLSZYts2OjKcBx1\";s:14:\"css/brands.css\";s:71:\"sha384-9Wenwezdk1eEhfcpps+Heco4zWw6KuZ2VlevoPomUwWYYZd3nBX0kZ1hBV2zSIKF\";s:19:\"css/fontawesome.css\";s:71:\"sha384-4HqGlagEHMyfaDQVabl1wx7GCtGw6hDl3sKJEhqQjOCrXrvizhaA2j4hK8Piewtr\";s:13:\"css/light.css\";s:71:\"sha384-3SMOAKCN8LYSMjkWz1ChDg4pHSLtD+LuKXaZoHxE1oyDneLR6Ebjm3XHMHO9fWu3\";s:15:\"css/regular.css\";s:71:\"sha384-ELBQxbOyxSZRtZPNO1mVgYkEzMOXFNmQY6CLV1nw+4IZoiHWeuwYTnABxPxxsuBE\";s:13:\"css/solid.css\";s:71:\"sha384-MkkthiFx7890Rev6vwUJO4gRT4yuH5tqMm/Wl4/n9/qptaBpiGcMyjfgq2K4h394\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-LnvOeE4ntog9dzgq63i0OoI6jKPp3p0y693Fh4Fd4eOyx/UsAw0kHXbLKqML1p9R\";s:16:\"css/v4-shims.css\";s:71:\"sha384-68zdIccmue/irEHOgRiyNsWTZAGftSb6RkEtUhgaD+8213AXnbThq7m3WsO+B02H\";s:9:\"js/all.js\";s:71:\"sha384-GBwm0s/0wYcqnK/JmrCoRqWYIWzFiGEucsfFqkB76Ouii5+d4R31vWHPQtfhv55b\";s:12:\"js/brands.js\";s:71:\"sha384-b4zU5X+9uCyU5wpeWBsEIFph6tTD8ERLbUs93uYGQGNqzbcfPDeY6c4jMhTAfBri\";s:17:\"js/fontawesome.js\";s:71:\"sha384-w6QYwIdCVqcYkHtaFutVu3VlDeu+pBFvlp7e0/tygMFwnWTl13KuVYfsp0ediPpA\";s:11:\"js/light.js\";s:71:\"sha384-avwGKnev1pyXYEbWxXSg9S4rpTsws+5vQpoj76SfcccEzOL162Ei8+z4a6AlaMeE\";s:13:\"js/regular.js\";s:71:\"sha384-lv9QOXVC8fPRX14JTtgPGx1JjQPfjnqnp+bTlEnrW2FRawdJ4V8oe4Yq4kdfgJIp\";s:11:\"js/solid.js\";s:71:\"sha384-sJjbbGVKgAaulHq0KZK5MsUx9YmPj+4G3oY2vmW12iBNEFkkhObBezK0ZhSXchIs\";s:14:\"js/v4-shims.js\";s:71:\"sha384-J8Vif9iMSqb5RK45yq6+dnrM1lTP1oQcIHtKpoH0irzUJD/1gCK0pQgIr0hO+hta\";}}}s:5:\"5.8.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-oS3vJWv+0UjzBfQzYUhtDYW+Pj2yciDJxpsK1OYPAYjqT085Qq/1cq5FLXAZQ7Ay\";s:14:\"css/brands.css\";s:71:\"sha384-i2PyM6FMpVnxjRPi0KW/xIS7hkeSznkllv+Hx/MtYDaHA5VcF0yL3KVlvzp8bWjQ\";s:19:\"css/fontawesome.css\";s:71:\"sha384-sri+NftO+0hcisDKgr287Y/1LVnInHJ1l+XC7+FOabmTTIK0HnE2ID+xxvJ21c5J\";s:15:\"css/regular.css\";s:71:\"sha384-hCIN6p9+1T+YkCd3wWjB5yufpReULIPQ21XA/ncf3oZ631q2HEhdC7JgKqbk//4+\";s:13:\"css/solid.css\";s:71:\"sha384-ioUrHig76ITq4aEJ67dHzTvqjsAP/7IzgwE7lgJcg2r7BRNGYSK0LwSmROzYtgzs\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-PLvJTjM1QH/74H66d1I1vU8KYsjkbjSJn87gUIUsIO6Xjf8fRO8Hxdevr46EkV7M\";s:16:\"css/v4-shims.css\";s:71:\"sha384-XyBa62YmP9n5OJlz31oJcSVUqdJJ1dgQZriaAHtKZn/8Bu8KJ+PMJ/jjVGvhwvQi\";s:9:\"js/all.js\";s:71:\"sha384-DJ25uNYET2XCl5ZF++U8eNxPWqcKohUUBUpKGlNLMchM7q4Wjg2CUpjHLaL8yYPH\";s:12:\"js/brands.js\";s:71:\"sha384-GtvEzzhN52RvAD7CnSR7TcPw555abR8NK28tAqa/GgIDk59o0TsaK6FHglLstzCf\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Ia7KZbX22R7DDSbxNmxHqPQ15ceNzg2U4h5A8dy3K47G2fV1k658BTxXjp7rdhXa\";s:13:\"js/regular.js\";s:71:\"sha384-iFYyWQkY/Zvsdq3IIxRJI2FBoXPj6g73ok7rIH3sZGulA7E5PvFqB5BOELomUuyh\";s:11:\"js/solid.js\";s:71:\"sha384-+2/MEhV42Ne5nONkjLVCZFGh5IaEQmfXyvGlsibBiATelTFbVGoLB1sqhczi0hlf\";s:14:\"js/v4-shims.js\";s:71:\"sha384-5i8QG9UXrCZePXfj1ac87dq22tNtGoJ22fmjXaJI8iIy072+ZKv1NZHbsTMfYvnV\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-xVVam1KS4+Qt2OrFa+VdRUoXygyKIuNWUUUBZYv+n27STsJ7oDOHJgfF0bNKLMJF\";s:14:\"css/brands.css\";s:71:\"sha384-BeZiOfMYSXjscewXEIJ0PDoBy27u+zVSTP5ZuW3kjEZKCn7pOB7v+oQVtAtHfY0v\";s:19:\"css/fontawesome.css\";s:71:\"sha384-fqilzf6i0kkOYm+DT4UC9pWzYf4/eFdJKroY1jZyE7n8eYLujyYM9VCucGf/LdVD\";s:13:\"css/light.css\";s:71:\"sha384-0WqtEOayxoyo7wgxUc5l2RvIbaWTyny0LrJbwsKhrKXUyopxvaNFLIoob4dXRwLO\";s:15:\"css/regular.css\";s:71:\"sha384-jyNdSTwsauV6/i9u6sKFOZBrxlr4QREAY295HsNy8laz4LYryhnPdz0ewFVERKfV\";s:13:\"css/solid.css\";s:71:\"sha384-dUUyoHgD2BplZp1AnRbRu0HPC5jscpJEJaJjqnBh7Y5PT1gW7cM6BQEgrcOsSa7e\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-+BcpgpzTfqttc/C2LUPzGXIGunaa/aIuSC/BPO2BBqqMbHNRCF7d3DU54LxbCzTS\";s:16:\"css/v4-shims.css\";s:71:\"sha384-TpRSvWoRbPKMMxDvVZgEa9wxoOZyawahRkC2P+ksDRxjPSvZjhEf5nU7pqSWBCQF\";s:9:\"js/all.js\";s:71:\"sha384-RLPiEwcAdrH2NjFcwJipJtlFoIN1xvqPYeeDX5yYtSNu+HTIkQCDvPQ9thsUnPUS\";s:12:\"js/brands.js\";s:71:\"sha384-NBtHk407eZGNubj82MbaKt5CrNLfhnYmCbpjSyDk/nWemMXE/mfvm3c1MPjfnWmU\";s:17:\"js/fontawesome.js\";s:71:\"sha384-b7K10RWf2Q3m26zPrKzM95th5yJnxEw+vpCzNITZFKV8UgxPgHb61bS0xFkKdV2I\";s:11:\"js/light.js\";s:71:\"sha384-BMiulaMo0kY9ExzwDFFjsXkU373Br7qSwYa/hdDlWEWEkE3flk4mBFvMwlpye3Aw\";s:13:\"js/regular.js\";s:71:\"sha384-uMEQdPXvyCTabszTyCxRRMDh/xIcRlT/fpq2DKkcjR6+lOqq2111EL0C1OiRVu1E\";s:11:\"js/solid.js\";s:71:\"sha384-9fQzIUDeLlrPRI2CT9AqVv6Yr0JgEY0+rr7ngyaatQAQrEHhCv5CvG8F8UFdgk7u\";s:14:\"js/v4-shims.js\";s:71:\"sha384-Ts0FauTmSRKZNl+Uw+WC04UuoVYd2gXlJ+OcUvb1NDrV2XmDcgCr8PPv5MY/7KZR\";}}}s:5:\"5.9.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-i1LQnF23gykqWXg6jxC2ZbCbUMxyw5gLZY6UiUS98LYV5unm8GWmfkIS6jqJfb4E\";s:14:\"css/brands.css\";s:71:\"sha384-vfTtNoEyqnxivzqkzc+mvlVeCWPGwMlIIkeTkt0mcUQNmFLyyXxY5SgZIkKQIXRK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-NnhYAEceBbm5rQuNvCv6o4iIoPZlkaWfvuXVh4XkRNvHWKgu/Mk2nEjFZpPQdwiz\";s:15:\"css/regular.css\";s:71:\"sha384-5E/NXotaQSDJW8gq/9pxwQHSPRrb21suHuLPqOIlgob8QC8ltM13i6HLujrhWmBL\";s:13:\"css/solid.css\";s:71:\"sha384-ypqxM+6jj5ropInEPawU1UEhbuOuBkkz59KyIbbsTu4Sw62PfV3KUnQadMbIoAzq\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-Bfk4oyOug+rBqsciYilQ+iwazXsMTURz/M6Gfx7fb02KNeW5VHwt7aHTXWNU9B2W\";s:16:\"css/v4-shims.css\";s:71:\"sha384-zpflLcSaYRmTsnK2LTOdvChgML+Tt/4aE2szcblLVBXd8Jq/HGz6rhZqZ+4TkK75\";s:9:\"js/all.js\";s:71:\"sha384-7Gk1S6elg570RSJJxILsRiq8o0CO99g1zjfOISrqjFUCjxHDn3TmaWoWOqt6eswF\";s:12:\"js/brands.js\";s:71:\"sha384-CZZj1HZWqgh/CGR22Lnl6+fZC6IDR10ga+wECjipCR3zId+7ZxZP1JNI+YgdzyO/\";s:17:\"js/fontawesome.js\";s:71:\"sha384-RXRrB6R44g3RRohoKLAOK5MjNq4PVvz7iZErCckeyobGIJLpTP2qq6xjJFuKnfZu\";s:13:\"js/regular.js\";s:71:\"sha384-xrLv+W4OudHJZ6QDKuv+el28Wyr4OMO0qSQuBiPqhBsnSGKdGct/ElQm+2/fx/eS\";s:11:\"js/solid.js\";s:71:\"sha384-kDWpGOpzLEy85/cK1Df/ba6PkpDHAKUGOX4YHEt0sFzHdrTY1rGmT/gYHN3zCcF0\";s:14:\"js/v4-shims.js\";s:71:\"sha384-npD7syUhXOZUTbAzJEyIPGq/8gGAhBmei7JkUwUki9hAtz9oPkFJwx5f3vGb7SOi\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-vlOMx0hKjUCl4WzuhIhSNZSm2yQCaf0mOU1hEDK/iztH3gU4v5NMmJln9273A6Jz\";s:14:\"css/brands.css\";s:71:\"sha384-wRa49NRotGDh34aLO1Hjbu65qHSTF/ZNSBm7uTpMUa2EQ1Csq7Zlswm+FR9hcWtn\";s:19:\"css/fontawesome.css\";s:71:\"sha384-QSCxeayZXa6bvOhHReoQRGN7utvnOnY3JoBHGxM61JQQ1EXA7AT3m7dnlHXLhnCj\";s:13:\"css/light.css\";s:71:\"sha384-/ggAGHSQWxssDRflcj0aeAlGN2rNgsnWOLv1ZU5FEvjQWxP53glq5pNPjtfldVVN\";s:15:\"css/regular.css\";s:71:\"sha384-FrLF2uGffV1P93pQZme192v/cHRu1XlgjMreWAScHPPjBz/p9pNTx/bTV83x8peQ\";s:13:\"css/solid.css\";s:71:\"sha384-KyLwW4NRDhAz4RVatBCvFATniD3ze5rJvP1usxUFectdGgG8n+7OTcZug8s4bj5H\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-dwNK02s77FqYOBDJpF4ttbI23g2UUTrI9euJ+OQGonHAy4W1kCpAyV7ozLK24GWz\";s:16:\"css/v4-shims.css\";s:71:\"sha384-tlZ/hMWxtcO6JxnBPYGsa5Oiu1gmAqp/bY7s7G6m5OOCJvcNQ6Fo39YHu4Elr+Hf\";s:9:\"js/all.js\";s:71:\"sha384-nKdXFHC25mX+ztWymakpQ8nRykznAcZ+yHi9XETJ8CuVvvSGeg/0QCPhvDb41hUb\";s:12:\"js/brands.js\";s:71:\"sha384-4Md2NBtJT8CgVnGaoonPkhRdMvGcFRH/nATvRJ0+2VsJ5bjySPpBil+KbSC+9yFv\";s:17:\"js/fontawesome.js\";s:71:\"sha384-nFIVFc2+uHHcH70YEBnMC6UmUjVxcQ0rZJe7u58lz5aUDQRz0l3xFmVSdao7Ag/K\";s:11:\"js/light.js\";s:71:\"sha384-C6XejYBP1H4YOZVReSXSBion6LKXOt7htNgjRlcKQSsMnL+/Ok1vyvI5EQs1/H1e\";s:13:\"js/regular.js\";s:71:\"sha384-GlXg5Pw5UjuoWpx2tbE3LsctnmBsngO5u5c+nK1slAwSuwN86zPzez+sFxncM+Tc\";s:11:\"js/solid.js\";s:71:\"sha384-pAEZwWHMzeWUPLx+edoghTzc+LBoBSIWMNFPeZGDiFDP6WL4g+EHr7DhQMUpjSLZ\";s:14:\"js/v4-shims.js\";s:71:\"sha384-A2MQ6ZItVBjKp0Efdmi8Xze6uRApxGoHzuGImgZGk6JfuaQ9Vkcev6HtJSQzftWE\";}}}s:6:\"5.10.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-0c38nfCMzF8w8DBI+9nTWzApOpr1z0WuyswL4y6x/2ZTtmj/Ki5TedKeUcFusC/k\";s:14:\"css/brands.css\";s:71:\"sha384-19EzMRnOAF4Gg36FukRf0Bee26rnZC49Ld5mFG+8XiQ8ddeKQYj7Rnl12YxIoHe6\";s:19:\"css/fontawesome.css\";s:71:\"sha384-YYaKmJMZQbIhKGKC1QGjVKSQ3s9OlZitN6xQQEPksarSkM0WNkq5Kke0yehyNwyT\";s:15:\"css/regular.css\";s:71:\"sha384-OVGJJ0J6OIuVjxoE5rUQPFweGgzO0xT+HKN5IChh3LTrsWQKjHocfKq+nk/8DogN\";s:13:\"css/solid.css\";s:71:\"sha384-dHM1276IWlmmltsiRRg04ASaTBbgAqnnjneOemUaqff0rqTtVHw5qqKE5i0k4Qll\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-oBn2TNb41FLJEvg05fPEoAhWHErn7PR1FiyT6NjQkoPzDDg1n/e/GrwRgh34gDmQ\";s:16:\"css/v4-shims.css\";s:71:\"sha384-R4Ah6+FGj2TWi1SbbJo01aRwLwdNunBoW4ALQ4SdcDpyQpKoP0pTL3Ce0Hf0oMOh\";s:9:\"js/all.js\";s:71:\"sha384-BfzGEucsDAHnSR99xBvG8cNHx7h6sEbKJejtvqlMrN8nMi3gP2ds+sMAjWfWnZyn\";s:12:\"js/brands.js\";s:71:\"sha384-SgCx6DCTHwPNfTrT8PeDNKVR+bLsTKTVnBbtZYSLgfp4dd+KGa6j4/Jy96HTd0nw\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-yhpUSfH+AXwjqsle/7pS92NQZivmuHw41bqBfGxkaV4ftpRTE9Z6MNd2oh9x/BBm\";s:17:\"js/fontawesome.js\";s:71:\"sha384-LMbxIMq/Ra43sLL8MF9d0C8NDym6Cp7d2rtvvZUd5n4EuGE3GSYBmf6JV41EB7+y\";s:13:\"js/regular.js\";s:71:\"sha384-eX5P9jt8OdQQ4ME1Y4Q90r5k0qCw55F9jie73NYjcSEHIYYV+x3MW3XgqK7HDuOG\";s:11:\"js/solid.js\";s:71:\"sha384-WvtEEwvz7coGHFMqz/gUsacHkjubSgzLIieTORXey1KIpl+/r1Sk5owMdBxnGFHy\";s:14:\"js/v4-shims.js\";s:71:\"sha384-RT+uACaLSP2jOOLdRXKvxcgxA/WNa36UYkM14r9ODCgz51g7frfTdR+Jv3q46NW3\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-AYmEC3Yw5cVb3ZcuHtOA93w35dYTsvhLPVnYs9eStHfGJvOvKxVfELGroGkvsg+p\";s:14:\"css/brands.css\";s:71:\"sha384-/BwiSb9M4ZqztN8bEG+VrC9ohWSBX3qEV95+/+gBJoE4+zG3KqcLj8ShUhBIALSm\";s:15:\"css/duotone.css\";s:71:\"sha384-R3QzTxyukP03CMqKFe0ssp5wUvBPEyy9ZspCB+Y01fEjhMwcXixTyeot+S40+AjZ\";s:19:\"css/fontawesome.css\";s:71:\"sha384-eHoocPgXsiuZh+Yy6+7DsKAerLXyJmu2Hadh4QYyt+8v86geixVYwFqUvMU8X90l\";s:13:\"css/light.css\";s:71:\"sha384-2CRj/5C4pwyS5v+q0KXxQ39b3qsKQNE6T+9FFaAOlps/XjJcK+M20aMUxuQtRLaZ\";s:15:\"css/regular.css\";s:71:\"sha384-pWItZRjB6NLzlrnwcL+2alve4CtHiaLj9W5ZwGPgy6dtMzCPsGv/qEcRvrbVkW5i\";s:13:\"css/solid.css\";s:71:\"sha384-Zbnz7QaugaSWTYmuSFTHGzMLxXAu2vzmqJhA/DS3bnaZGJaatH8apOWXfFaP6PMh\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-85qDq8Thytv8iDkEBcdksps8EZiX4DEo3vh6Ijk38Xi4RVm37Ttn+HU9rsXho2fN\";s:16:\"css/v4-shims.css\";s:71:\"sha384-y51MGgwaeLjbh5fbY1GJ6PypnEoMkGu8MoR1HRE/p/hHfiEE1G9bK/79bstJpyYk\";s:9:\"js/all.js\";s:71:\"sha384-G/ZR3ntz68JZrH4pfPJyRbjW+c0+ojii5f+GYiYwldYU69A+Ejat6yIfLSxljXxD\";s:12:\"js/brands.js\";s:71:\"sha384-8TDwqaS9Kr9a/3cVS6+XkvWUM1tz6XdS8s2urD5rXY1Cz22kPF77ZuG1gIWaz6kZ\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-JB1N15Wp6AIOL3sQ9Tm4a0kATlQy9/+/nLmU9B2wv4K4gGNAUFZEU7qDcxIPJLXy\";s:13:\"js/duotone.js\";s:71:\"sha384-PcDzzpTJzDDda2YUM4EY5ZqnZQ3DTIFtoaAn7t07N0UIY1HVyaxIHRzROmFBd48z\";s:17:\"js/fontawesome.js\";s:71:\"sha384-8YSeMunSTZdDZy7rZxfG3NqC3KnYaCKxTJMm9yoILgIoMpXeTKDrV8TeV9C5ItEc\";s:11:\"js/light.js\";s:71:\"sha384-sEc8iKGnMxm+Dm4AQabXbw0DKZU9FtFrWMppMOsxaUZsLL5pcpQs4aL/OfefTw7g\";s:13:\"js/regular.js\";s:71:\"sha384-wNQjNuGVt9TzLWqaxsZvH5uIDIxEkpSCeSPg6nF2ud6AK9jXY9yMFA6CbcZrr+cZ\";s:11:\"js/solid.js\";s:71:\"sha384-Vh+IVHoo4c4JXOfJBoUxIiEJf6bB443zoyGtwY8WbBmCU+7fAq9QX9JLtFcNSPZl\";s:14:\"js/v4-shims.js\";s:71:\"sha384-vzU1ar4oP9lOG/JJdj1q/+3aatI/ZbpyHIMelvsAi2Ee8gCiTIb/YhqRymLLZkje\";}}}s:6:\"5.10.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-wxqG4glGB3nlqX0bi23nmgwCSjWIW13BdLUEYC4VIMehfbcro/ATkyDsF/AbIOVe\";s:14:\"css/brands.css\";s:71:\"sha384-+B+cmd37r9agFUqHw5ABups/+o97SqA/Y6S5b3ly2q0ABacloQs0HZOQAX1NpJhF\";s:19:\"css/fontawesome.css\";s:71:\"sha384-jUGOH+gYMCfz2jbO6DW8vojES/a323h7dcoT6qI7Bvod9mew/wwTZryjccmaMOkf\";s:15:\"css/regular.css\";s:71:\"sha384-gr19od0wAxe2+mYHEXvS7Y1ppn+ESoAQzTYGPauVJYyAYYl0NBQaKveeQnzez2Rm\";s:13:\"css/solid.css\";s:71:\"sha384-VUnOJnDrNS0aVOhF6puq5SPJOP5oOvIO6n54m14E2/OHv6DU1gklJ4EImoD382c5\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-94OQehjHMl3lApC2tWmjwtxlB0oEtSE2zrTdf8uuWEaDEkkCxXK/w0vFs5J5WPU1\";s:16:\"css/v4-shims.css\";s:71:\"sha384-i1lF6V7EeiD7KOgGLtAvJiK1GAQx4ogzG6B9gpEaDuHSLZuM3sFtPZrI6H2Gzqs6\";s:9:\"js/all.js\";s:71:\"sha384-aC/bNmpJEYrEVX5KNHN+m0CmvycQX9wDnYv8X2gdXQjrbtDP5OcU5DRiXwL6bPwr\";s:12:\"js/brands.js\";s:71:\"sha384-BZIBcmKlroIkWe3e13MZbUHZdmagAU/8cnXo9mIW5p5wzf+/U5ULLQ8TVioSuCnC\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-A6TzAYakDQ9XwDY1hOPxAxI/3t6kol61Ed9hvHegEwcENzAE0vLojG6wItQDmclf\";s:17:\"js/fontawesome.js\";s:71:\"sha384-NXKh+ixIINN/JHIorH6fcTNwaAekBk2v7azch6cKmQm7wtb0yBt8ctqn1FAspAW5\";s:13:\"js/regular.js\";s:71:\"sha384-7Sk1mIxPYoZb2I3YK86sPsPMftKqv0aWP+dgX//x1mF1mSOYydXmX7DbtHN99bea\";s:11:\"js/solid.js\";s:71:\"sha384-dc4FEGpFyXnyL9DbieF6I8Xzipdt7GRHX6k8RM/ow6+IDISjPeeTwTiAkNzjv2OI\";s:14:\"js/v4-shims.js\";s:71:\"sha384-BtUWeH6hQDQGUZewQDmWRMisAxvs1LtqoVQgmbFptFnH1GpBw2b2vZenxfFmRtOS\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-y++enYq9sdV7msNmXr08kJdkX4zEI1gMjjkw0l9ttOepH7fMdhb7CePwuRQCfwCr\";s:14:\"css/brands.css\";s:71:\"sha384-9J78p9RP9gty/jk0TJPvYSzmYYCH4cRRkDMnZGxZNh1wdaXLvXzIk90EWrxjjqr9\";s:15:\"css/duotone.css\";s:71:\"sha384-Na50X0DRTNz+Sc+4XbFXONmaknKHBHw6gvRZ4coLQCl7ZLXziulq+4wvTZxkaM+U\";s:19:\"css/fontawesome.css\";s:71:\"sha384-OvQaO09Stu8nVnOdc+6B3WjpKg9dfBxoakdLxJKAYgsz62+DzBUCvWRxPl9LRVSq\";s:13:\"css/light.css\";s:71:\"sha384-CL557/BMzDSg/4ctPpKDphHJgLqpdJ5rvOklcaHzLHpX+qsgd4V/xao6Rya4xKMQ\";s:15:\"css/regular.css\";s:71:\"sha384-yLDdP4XFV3JqISKN0JaZ0kdyks9S+U2o9uBmNbmZh85yjdF/kpu+oY3/eXQcGHhT\";s:13:\"css/solid.css\";s:71:\"sha384-BrYpEWmuPyxLgVmvUGa111AoxZ3kKwiG4TVjjewWZV9vww+dTLWpmEffDSEg9Gf5\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-V8iByeksgr2la9ceLV1jNv7uWdzI3pYZLNzgYqWmQuQZa7khs4d6QC84YnMWoKxx\";s:16:\"css/v4-shims.css\";s:71:\"sha384-rql5zubvrhoXpo5buqgoiKryiT02OHCEtveKZrj4NX/C2Kuy7W2P7vl+RVzBUl9m\";s:9:\"js/all.js\";s:71:\"sha384-FW78RPcSpi13vjx77nPWQIrQbNSLkPBopb0qGzLCxD2x4Kr6FA8V05C/6cpgkKPL\";s:12:\"js/brands.js\";s:71:\"sha384-DGr5D3fYhGn4bylN+nFRaxvPt6s4FjV7B5EhOOFUKW0JKU2vco3q3xtgSZeeEYpw\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-++EkH6KNUkbsGzUhPmRa5yboy873FnCrHLPNWnvcfYOzCCShCQHtdQ3RQTt3WDsW\";s:13:\"js/duotone.js\";s:71:\"sha384-QwVJpiaupNLHQYsfQUftqzWXMT+SsU4AKnlvxDGzNjTq5xPXRbG/ohsvyIEyK2uf\";s:17:\"js/fontawesome.js\";s:71:\"sha384-v97MeHGTkmNphZhn+D7412xlPlc61o4jy6CouRwKfNltfXH68HcYhmQBr2j/J/Vp\";s:11:\"js/light.js\";s:71:\"sha384-TZInz5PvbxRzxSlGI1WYKmrrBBk/XTTZymO6w+smmSVD6RFpfZd+JtSye/viSFxA\";s:13:\"js/regular.js\";s:71:\"sha384-ZlV+aQMpcvCEqNPe9qTu/S6+eBL+DfRjOxr9wtsoZyGnJ/vwQk/U2SZhZ8tJqH5F\";s:11:\"js/solid.js\";s:71:\"sha384-WtnuXyp6MLUsHy3FAqJyL7aL0a/mdUjPwIs/Ub7FXJZufo/0qH9aFsTDY5Q6Bx3m\";s:14:\"js/v4-shims.js\";s:71:\"sha384-P9HMMmM/ObyzYMvKfF0Xf40MYwNdkI08AwhSyCsAVlmXZkJ9GaI0Z23pozRg8HAe\";}}}s:6:\"5.10.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-rtJEYb85SiYWgfpCr0jn174XgJTn4rptSOQsMroFBPQSGLdOC5IbubP6lJ35qoM9\";s:14:\"css/brands.css\";s:71:\"sha384-qVnmyLTtnGPGEN3HDG2MCEOXWH1Yk/i70lKRuV+gMCDQg+jblQlFGPf1mejWUyYG\";s:19:\"css/fontawesome.css\";s:71:\"sha384-hM7EQerc09E4O3zhtvF2iqcB4ZkEu9xkLQndhXdGGCEJ/sB4JK54SuKGmIC35UTf\";s:15:\"css/regular.css\";s:71:\"sha384-zuVEAfuEXYtKnHpmwmkhzwMdR2uek5gePU1XveESmScyRJHbncv8rLEAt+ofv7ze\";s:13:\"css/solid.css\";s:71:\"sha384-qPldrzmea0i8jhonuql0da/kQWeaXdQl+krGXcTQUdRUGHcXBfSrBbZLbyMcCWcF\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-G0mvrlfkz9DnjBCRmY8Wf7nC8wTxDsHE3pGAc7/4rDLh5+v9Z00qi/uyjjcDf1nf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-updXts+unDswrMsYxLc5R+HfSmF8CuEIOe48Rj3DoVoPUIImOT1fs26H/tr/H9gC\";s:9:\"js/all.js\";s:71:\"sha384-QMu+Y+eu45Nfr9fmFOlw8EqjiUreChmoQ7k7C1pFNO8hEbGv9yzsszTmz+RzwyCh\";s:12:\"js/brands.js\";s:71:\"sha384-0kDL5YEgNJjL/kNToZYEds3evLmosarb6OU2eKqRYu6O28jcJc121tjUC40sG9VB\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-Hg1lNcVEsyCqBb1J4/U9X9IW2DEhAKIBfBIE0J0eiWGEX9LEpEULwcsqoAb6HDgG\";s:17:\"js/fontawesome.js\";s:71:\"sha384-5WtMZ7frOu4PgR22YgRSlercgEU28i5Zn39Svk6+2cg1MOigLDSsvXccsmJO2Wxp\";s:13:\"js/regular.js\";s:71:\"sha384-CYi/gunDGMYA12KV546MNRqsjbbWSyKgPjA9BwVMBQmIMhzVrjyUJwkV9uujzHLJ\";s:11:\"js/solid.js\";s:71:\"sha384-RbVpZhfPW/1SmcShwIOauawY5vJWxTCeEnmiUCiY2SbkrbKuSGTqJ9NnBUmcP95A\";s:14:\"js/v4-shims.js\";s:71:\"sha384-gDM1aRghQ5DRg+fSCROSYawrJhbAHqa6Teb2Br0qRJtb+vRJlyU4U4xnmN5cwJ9j\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-XxNLWSzCxOe/CFcHcAiJAZ7LarLmw3f4975gOO6QkxvULbGGNDoSOTzItGUG++Q+\";s:14:\"css/brands.css\";s:71:\"sha384-hIpb1kefRKjC/r6WxN0S6Nai7+AuherqCoHKD0HNdXkbzJkZcS4o62bJ7ODiBWAu\";s:15:\"css/duotone.css\";s:71:\"sha384-B6+5TXCEkY2Io8b+v2Ki0aEWnpCFgBYkOzXAHY3oQ4tr90JpQC1RErwFbvJ9CRt8\";s:19:\"css/fontawesome.css\";s:71:\"sha384-1sdMwbsd8X7Y+nVcEr/4D35smQEaEd6Qz+R00Y+NPUkG8MyRa97RrX5I4nqDt6X7\";s:13:\"css/light.css\";s:71:\"sha384-dlxpRYGi8Pjg49IqtrDIVZmCOQZ//oDKDkoqbn/IXrwwQDP4Uf0ys6+eH1z9sfhV\";s:15:\"css/regular.css\";s:71:\"sha384-hKM7KqUOh6F2PI59uEhofbDs/5qHHdJEULlmNWJEQcu3D/5/vl5zpwBrveC4GAbI\";s:13:\"css/solid.css\";s:71:\"sha384-FCdq+BRoY+lV7Zy7HKKQ4zoywYLRyasGk6IrmrXfmYs0xIgL0QrPeEPTu3T4Uqcc\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-+OTv1mrGtdzHGeAuFSVKpPvaMXNpUu+W+Xs4xYz2RgUlrBctmMyE3noRImN5j+ot\";s:16:\"css/v4-shims.css\";s:71:\"sha384-88Tda+TyAtJK9/cRRXAWdJjyE56Tg4ai2x7RoSEqSVodcInAoV0HNQ2ofaGCidyr\";s:9:\"js/all.js\";s:71:\"sha384-lowSFbzpSYKDOsvnpi2JVneSnkrbVjOTwcHOWpC+tj/YT1mxTDIB3ZqbtllmfUSC\";s:12:\"js/brands.js\";s:71:\"sha384-nyTyvpFz3BvQZucRUSSEDlyivN7GAC2Xhgl9M92o/rt/KfEZ7LkqusFXlCjM4DvC\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-eYjh/PZbsWw6lqYWtDM+NlcRs3pUkOk8r4mxv/x0xDjmYPXTxPKQ8ZNXxOnd0UCL\";s:13:\"js/duotone.js\";s:71:\"sha384-2j1n2yG+7lkO9CjnN1DSQOGJoDEaJPEr+TPmTer3pK/yD3bQ/Kk8bqJyS3LfCK26\";s:17:\"js/fontawesome.js\";s:71:\"sha384-sy0tjZ+ivgcg2wUVVEmLMO5wfntWOSyQaD7AQec0iXINci5JAP92T8sM4YldYQIA\";s:11:\"js/light.js\";s:71:\"sha384-vh/BsPXkl02OgBjk1HJkukipMWFU6vHADY4W3u9BXIrKjcRFw5Y5XikVLoLElHee\";s:13:\"js/regular.js\";s:71:\"sha384-p89srWlrnSOel/vi/SpBD/wyTTJhu+27jcfOazOCUnLTpcxG+NVuYs/okkO2JBox\";s:11:\"js/solid.js\";s:71:\"sha384-JzK2muq5DGAdfmBP1xyuFUAYGceTmP/Y84tZvRxkdtsjwuIcd8Hpf1D+5izeBUQP\";s:14:\"js/v4-shims.js\";s:71:\"sha384-z089sTZgTLfns4lyNCTpVbdQA6JAhOs6JXwRH4ig0M6EHPg+Lzp/hdcx2OHQn/v8\";}}}s:6:\"5.11.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-XLYVh3ZsmvjnjODXg/qvDYjcINmPLORACP+Tk6qA3jNLbStl84PzAeEz2Su02511\";s:14:\"css/brands.css\";s:71:\"sha384-ngkCSSyhFgmeG9/8GICGMwnX44Q70/NN2XuNgrpMHOAjXVjYwTvtQML/2+2EH5mm\";s:19:\"css/fontawesome.css\";s:71:\"sha384-saSWCOAroWA1DTfG19axC5l7ej+/lsLpGrQjthhULGGw0FKZqZmxdjRhWqjypqgH\";s:15:\"css/regular.css\";s:71:\"sha384-NJ6bXu66piTFdxVfLXmQuxcjGye4blIA4H2DybHqY1WFdYSxbKQo6W0G53caD7MY\";s:13:\"css/solid.css\";s:71:\"sha384-1Ln0i7HCe1LMHO25AgX/9s/3XzTLIMev2SYgQz8xSyXSa3775gIb15NIpJoDRYDg\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-utbeJwkEmotPPgnsjR2cFDH5mR1JrU1EX02CRdVYlT6MuuLA6/jK0M1UcDXBVNa1\";s:16:\"css/v4-shims.css\";s:71:\"sha384-QZ/09hWMymER1waFUW4M2iM55h3bf5FVf516rOAYf9G2mHSpAj+oo/6jrxhxiVq4\";s:9:\"js/all.js\";s:71:\"sha384-Zgm+jt84FBq52ezxzG1WPrUHXPTLraCVSuBDiGgz/mX0FZxgdkTZNephFvciYglv\";s:12:\"js/brands.js\";s:71:\"sha384-FYnxcuBilMBfd4M0z3ZhTEWrorBL6P6mqaDWsYN46z3iJszwg7yqVAft8mxPhWQf\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-nDF1UhY85TnH6TtkBtlcaTXQh2EGA+oy54oi//hchZ6BIO8n0yZOdEDcqy3Lj6SH\";s:17:\"js/fontawesome.js\";s:71:\"sha384-+4PGPfaOiBMXBdbxBpjj3c78flBTf1SoDBBbEHY2P8SuIKsjNJ59vjhjpMClcRVk\";s:13:\"js/regular.js\";s:71:\"sha384-sPFXZNRvY5NMeQlqaEJyF/3Lrrcqi+EowkFdHnHe2B5/GSLq+RN8eAfpDiFzWveB\";s:11:\"js/solid.js\";s:71:\"sha384-abaNJNBN26YUz3JKjkP/eHqZP+7EaMLIkyR/I4JNQXin7CWBKc81Tmgh2//K2gfd\";s:14:\"js/v4-shims.js\";s:71:\"sha384-uQinggJhGToi55IHZla+hhoeR3xafp4JLhuIZzag3QFHKDyLLolL8IuCRM2aLdxy\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-eRd7BE4pd4YyGL79iaO+/+GQtuNU464XOqRShZHNdRwR66wJIzi0UirzOFzuoMOo\";s:14:\"css/brands.css\";s:71:\"sha384-/DL+sGDGYNVXNSXzx8omqgYJuKJWhPfJC0j3sM06CPE7CKypUtyAtAburBBMbhWn\";s:15:\"css/duotone.css\";s:71:\"sha384-JrGJDz5LRxQ3s3dW4Av8oo0oPABX1FQPzGwpVizHFqVT7RXKd2suPslh8/k6EFvo\";s:19:\"css/fontawesome.css\";s:71:\"sha384-ASwVckljSlVqrp7J4fCNW1Zfqp4GBw13f/oq/bwtr1KNG1j5lzKrfTpvoivwJZpS\";s:13:\"css/light.css\";s:71:\"sha384-SE3odAKV/Li06jtOem3j03b4qHD5AfOLS3ip3Ie7HS0QtdLJuRozlFcEiBnKhIjj\";s:15:\"css/regular.css\";s:71:\"sha384-v0Phnxb9e1tIN8ABEpuqr9+U98eA2hbSnnxnIFWqTyvwFd4QjVV9NOCl19hLotTv\";s:13:\"css/solid.css\";s:71:\"sha384-23irw3gzc0cirSOm9k0vC4Cb8339DDxFatLW9p83F4RsFK/1HuRvePKAltYrdlBX\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-c8uzxHbCxkqcTDgRCHmj0nVIK7Z72qzR5ciNuZIQQKWVMb0Trzdh3g9EmdybHyb/\";s:16:\"css/v4-shims.css\";s:71:\"sha384-+/X59I6aJtu7U5st0yw42TmOgz2GTi80ici4b4Zr3fVKaib7AhAhXm17vhXVqNN6\";s:9:\"js/all.js\";s:71:\"sha384-jaxx6ehyna+t5i9JERhQruWpH3C/xGZQJz6/+xqO5C/eWWJ7ysIZIe9BAULfRy+f\";s:12:\"js/brands.js\";s:71:\"sha384-om6tKqxNyejPYGBkAEpF5czG8EOB93m9G17YUGoJgRtei7kJnA4P4+w73UfDPtLl\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-I8WM/bXtfWQr8u2t0OIaUfJNpTd6LnCbNnrQpaKQN4/Pdek5IOtrXdpcXpLwzCoc\";s:13:\"js/duotone.js\";s:71:\"sha384-tit+/K18O6+uMPCuvEcobuzvT7aFly7Raxqnszuar7OzNloVr2oIugu9S/T3MNgn\";s:17:\"js/fontawesome.js\";s:71:\"sha384-kAYceFs9TzH4f4HsWzAZvbE7yJRTcOUe2UeJVCdVV8AYbspSlxAIwUg7yGHrtSKe\";s:11:\"js/light.js\";s:71:\"sha384-zam67iVIo4OJbdPFYrgsf4Te4l96q61wYKpT72nLO78ICkwXk27OlsN4SQYHOlI6\";s:13:\"js/regular.js\";s:71:\"sha384-8QzBYxpPIH9HEZ96HhicnkJ8XYzELjI6YQabAc2ANT0wExEgzeKwnNdQM3B0YPzX\";s:11:\"js/solid.js\";s:71:\"sha384-vTIqr5UHlJnlDEDAZB19P3NuSQy0Ynbzj7w5ofBkLPpN1bb7N2uZ/z0GNZGCIFxW\";s:14:\"js/v4-shims.js\";s:71:\"sha384-56L2fWZDluSTJKVxfc7PF+HoFsBrcdkn/Wj79nB2pzTgaYmqLT5T2pn6PLbMvHHq\";}}}s:6:\"5.11.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-IT8OQ5/IfeLGe8ZMxjj3QQNqT0zhBJSiFCL3uolrGgKRuenIU+mMS94kck/AHZWu\";s:14:\"css/brands.css\";s:71:\"sha384-UMAQJEtrY4iFRXQIYIXWfTd0GPzHrhSPK1SJ3fEeGGgtkC3m5qhKESA0yOXahpmJ\";s:19:\"css/fontawesome.css\";s:71:\"sha384-8dpIy0am6bmWHK+abUbC1sgkCSD6WstSMjjNB7JVa+rprKurA6xisqNHg6DESJWW\";s:15:\"css/regular.css\";s:71:\"sha384-5JoPxivOfpG9KRKbjXkqhwpMZ7vvAATGi77NPd6sC2ruJrWa/hKqoLBIWC1n1N/U\";s:13:\"css/solid.css\";s:71:\"sha384-20Qlvv++Kgw8B9SXDkUX4JrITPco1UXcaB1mkymQFgx8cM9azG2Ig9Sy3khBpWip\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-jv39B+1DxC6iSROYUwIeI9RUDrl9ckXFPOOlys2dTXchRTodXzqX0lm6GUwN4iLA\";s:16:\"css/v4-shims.css\";s:71:\"sha384-iJU+Et4BsM2cUxdymLmM7B8IF6IkyAYIcJRKroT/XuA5+2bWL9u+KJ1ZItC4bcdo\";s:9:\"js/all.js\";s:71:\"sha384-4Uei2cJ8mOycRxb1dxppaomro+V4vHdGuT3NfYGpENdgukEOcOrNB43OdzBiHdpZ\";s:12:\"js/brands.js\";s:71:\"sha384-q5JjSRgEoLV9cBFXvjGX8xxIxWN+LcGaDFBxSid/9XwjhecfXMQK9Ak7bcPSFT0M\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-LqGhhRx8iThhBm6ytksB4x9veweiV+qNa2soZmn8V37E4Nohq1ccRoaSr4o8YAGQ\";s:17:\"js/fontawesome.js\";s:71:\"sha384-jwx8I0tSvPLf7ZV1KwBdmXpCHgduVujQNEzmHuLEiCYql63uV/C9TCtdBU7E5TL/\";s:13:\"js/regular.js\";s:71:\"sha384-W1XmDNwB/NY1P/H0BiR107pc9NC7aTrPvwXbrZewndT3nyrmFm/7IIc0AxxcHQ/N\";s:11:\"js/solid.js\";s:71:\"sha384-kDwQ866HvlesMeZEZYvoa7AceBir+K+jB/0PVVSs/1bX0JtTvAm3aFEgOCOCt3c3\";s:14:\"js/v4-shims.js\";s:71:\"sha384-gtnOUe72T7BrqVgxbkcbbwZGJLyyHFFtefPxPZ5t/rmQ7vMNXbxml7JJkSNfHmkV\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-sr3GDThhNP8BxHFoTK4zKFgOjcrT8vzaiLwnwU+yB31BCaNj3QMX6YVXcv8AeBAy\";s:14:\"css/brands.css\";s:71:\"sha384-4sG0FgVejJMQM47pqYyG+7afeARX2P0HYkQ8JCKf3ZqTcpJ3/SWefUFX8kdm8eYV\";s:15:\"css/duotone.css\";s:71:\"sha384-q4v2/qv2HhGIAcd04NDH2XuGq8Bzu+xNYUI3gcKFfWt09m/dgZlvUC0rQJ3KtGg/\";s:19:\"css/fontawesome.css\";s:71:\"sha384-O68Og25nY+MZZRUiP6gm7XPDuHsNC5DgKWEoxn6+3CFcGLRXuFihbGO/8c5Ned0i\";s:13:\"css/light.css\";s:71:\"sha384-Rg8mXhpzJH99uBsgdsCp9zXjkcsw/pm+s4Kgu/56eRQSd8SAszYc6hssH5MLusHl\";s:15:\"css/regular.css\";s:71:\"sha384-RjVm0cyaQYehIEaR5Tt+JDfgnUUtY7GP/N4rEglG6DxLUhzozRl6HTH5NfPQ0X1/\";s:13:\"css/solid.css\";s:71:\"sha384-/SNkE+jEmgiOubdXCmBU+e2fWH200um/crHWjo/Rni9rhQuxT4demqM/PAyc+tXU\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-9q0WPwNHncxttx1Sf3c/G9lszy6f82L4rYAYW+JF0PRBNvJ1mVyYivrsep7J+Fud\";s:16:\"css/v4-shims.css\";s:71:\"sha384-1oMR0RRrEohmWSZo0t/tezQF1gyGc/b73Bba+qyZLEGdTAPORCf4p+pQm/iycsgj\";s:9:\"js/all.js\";s:71:\"sha384-7DVhSuOn0R5KmazSuDzmwQHOIPfU4+n8x8AifcGCoSOGATBJh55ZY41LSL37PB6m\";s:12:\"js/brands.js\";s:71:\"sha384-QRf6gn0gPrg4U0aYZ5s/Sx7xXy9gplYMzh82CI51530v89R9s9xGG8ljaSqYflQU\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-jKcJk7TgESeW6RZgq9/e8kTr0jRQ/JvaM//YDKwhF9wyvXk8lQs27OQ6cgv3FXTt\";s:13:\"js/duotone.js\";s:71:\"sha384-CeUA4+L5GZZwc5CGnvQVaT/Yrv5HuRydWW/QDCiXZnuORKxut4zKDa2WUaCS7fvo\";s:17:\"js/fontawesome.js\";s:71:\"sha384-hvER25BD06AWxsJLW7cQmGKjQp9PSZttpMIo36kIq2TTPEhP4lIT3VMFul89Ym6d\";s:11:\"js/light.js\";s:71:\"sha384-qvh52W5+cWrTxhfM559wBnsSqplMQIEjQkHnAE8c6MViBcH1OKvI1u4IGR+26hZK\";s:13:\"js/regular.js\";s:71:\"sha384-owKa0I4sfD0ooTioBE3KJEbjcmAZi2LeCbkqHr7/vkUeG/U5OyCGxYlcz8axgnSe\";s:11:\"js/solid.js\";s:71:\"sha384-hNm7JVaYkbmX1gZWRwOXVFKJ3onp68grA2bFGmFSMCQueJbgNvKR+iItAjM/PiuT\";s:14:\"js/v4-shims.js\";s:71:\"sha384-1MuEmp8vgjvrraTYbqRjvuZbLs+vFg2oeN+87QTVYX2EAXM90T4bzBm7HIFFzAp7\";}}}s:6:\"5.11.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-KA6wR/X5RY4zFAHpv/CnoG2UW1uogYfdnP67Uv7eULvTveboZJg0qUpmJZb5VqzN\";s:14:\"css/brands.css\";s:71:\"sha384-tft2+pObMD7rYFMZlLUziw/8QrQeKHU4GYYvA5jVaggC74ZrYdTASheA2vckPcX5\";s:19:\"css/fontawesome.css\";s:71:\"sha384-+pqJl+lfXqeZZHwVRNTbv2+eicpo+1TR/AEzHYYDKfAits/WRK21xLOwzOxZzJEZ\";s:15:\"css/regular.css\";s:71:\"sha384-zgXo5aJZxI4cJSgWSRtbv7q4JB6PzrmOTAWiZt2CqN25ifeKsCuQZ/pUNoPgjcTb\";s:13:\"css/solid.css\";s:71:\"sha384-doPVn+s3XZuxfJLS7K1E+sUl25XMZtTVb3O46RyV3JDU2ehfc0Aks4z0ufFpA2WC\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-PCpLTPQTGcSAXFltutjYRSDJAXJItRY88oa9XgNyYJuwrgJGx+uNVmtGSDS2PPvL\";s:16:\"css/v4-shims.css\";s:71:\"sha384-/EdpJd7d6gGFiQ/vhh7iOjiZdf4+6K4al/XrX6FxxZwDSrAdWxAynr4p/EA/vyPQ\";s:9:\"js/all.js\";s:71:\"sha384-b3ua1l97aVGAPEIe48b4TC60WUQbQaGi2jqAWM90y0OZXZeyaTCWtBTKtjW2GXG1\";s:12:\"js/brands.js\";s:71:\"sha384-b2GpqFrJizV0BUEdbrITdOA5HnxnlrErt7MlEERWd6NSJ32rHeibEvyyCuA13OAS\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-b1XIrGvAvE1F4q9vHz2OmkU7bBKvxebE+Q/bW+d4lG90kACkPFm/ZQuS9tlTwVD+\";s:17:\"js/fontawesome.js\";s:71:\"sha384-EYYaHDhIRoBhd/Ir/1fPnxg9rZLk/55lKtlNT5KrIcONoCS2kjf7ZWzMoCLLACeo\";s:13:\"js/regular.js\";s:71:\"sha384-vIxiYcREJ+yKr8tRXG0gCdepcyuhCTkHwiTdG0qVTHSQvjO0pmllh1QAy93JYsE5\";s:11:\"js/solid.js\";s:71:\"sha384-Mf3ap7OwO+bjTkzM1RsrothLh38uKXvMWJ2TQPXGHqZcqfeI/cyCV+sfV0IDnBDq\";s:14:\"js/v4-shims.js\";s:71:\"sha384-G5fIV0dSzZ1nDQSh+B5u3TRX2UtPcd5UWyi2WS1fZIpJQ/JpJCdShAZ+wmILZ7Qd\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-zrnmn8R8KkWl12rAZFt4yKjxplaDaT7/EUkKm7AovijfrQItFWR7O/JJn4DAa/gx\";s:14:\"css/brands.css\";s:71:\"sha384-dd+UlUKIkNDLBFy2GZJRdMODxfdUjx/PanzxBbsXaRBkyjHzUeDX3mj6q53uL825\";s:15:\"css/duotone.css\";s:71:\"sha384-tHth4ugEmPOZTBSN4Hi2oYiHY6vpxIL8clasFZidKyR6Gm34+U6wx6A9eZHqTs2W\";s:19:\"css/fontawesome.css\";s:71:\"sha384-bQakmC+XBF+eCf93fSR/57kAeX91i0BDyXyj8My8/e/3Bcno5zhEGM02xNvpXV+2\";s:13:\"css/light.css\";s:71:\"sha384-yNf+8hATd/MoR/yfZG0nBBtjTfxZEM1rJos9BgjBaVuLcu711wcecTXBlfS91nfj\";s:15:\"css/regular.css\";s:71:\"sha384-H5RIR1XTDkiiLdUTNtbYvWKpNd2qsPBeGzpT5PD495znZL9JCA7119EMPNfCASw1\";s:13:\"css/solid.css\";s:71:\"sha384-LkNnzh6wVxsC0m3vcQ0T5L6csSYpgSYniG/AKJqWBsHT7PVpeO0QHkBw4dW1WfVu\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-Mh++Qzb28x/RVEo6SYO87IyopQpwhzveyGIVg/AfbCLCEHUINYcCy24fkArgPFNc\";s:16:\"css/v4-shims.css\";s:71:\"sha384-A1hDH1BUL9ZdoEFsPEJY4LRFhu70QJj+RaY50Zoqd568i+ONa9LHCI+uoWDT0Lut\";s:9:\"js/all.js\";s:71:\"sha384-S++1cFhwpxbtRScUliTyprAMK33gMHbukurY4rNyt9CxIniGm6PfioUsQPoAITQJ\";s:12:\"js/brands.js\";s:71:\"sha384-NuqRsJYX4n2gSY6iMRHPZJxtpR40C8Lc/CV66yyeP1Vu5W2QSuVyPxMRpRIGihE+\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-GLrjh9czojGY48hc8pYlf/3FRNEBu9OWvNAta7SMilmijx8+ciGGVZyD+VwV4FVP\";s:13:\"js/duotone.js\";s:71:\"sha384-uO8Ntsr5QW0kAl13UUiYRBDhu3foxlKI+jZjPBApRxFDX2tgO/GYiCXIYiGixOU5\";s:17:\"js/fontawesome.js\";s:71:\"sha384-FdPoPmNNPrerz9uF/cNSTyPmNCRf6b81QDEPk0JlXAaailLV3DT9yA8plMzyffNZ\";s:11:\"js/light.js\";s:71:\"sha384-zE0WHJZIhNaysmywEoQBm6THN0uK5wAyfKWoN6lJPGOlrMB8hf0Yt4/+bex9jZi2\";s:13:\"js/regular.js\";s:71:\"sha384-+3mzeMYwSyHPQfOsqYlwcE3OSC7aI/+DjyVLkBxqWP9O+JyoEtzidrSonbNKh1uy\";s:11:\"js/solid.js\";s:71:\"sha384-9I7yL3g1YvBlMZjZ0bWzPqP1m3Ic5t3EgFq/MqNm2r8FUxDVowt7dO4S1IFleLqZ\";s:14:\"js/v4-shims.js\";s:71:\"sha384-+Onl+wOd5BbZvaC8Q/mQUO3lZAqsUyD+xqhS57VlU7gIpqXBMcS9Tw94A9uMZRwX\";}}}s:6:\"5.12.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-REHJTs1r2ErKBuJB0fCK99gCYsVjwxHrSU0N7I1zl9vZbggVJXRMsv/sLlOAGb4M\";s:14:\"css/brands.css\";s:71:\"sha384-ouytoyjvzHVJu1m+KEtJ+2Ys+WFsXUlknprEuQAUs62XNn0shj9U2QeTwdJQmPR1\";s:19:\"css/fontawesome.css\";s:71:\"sha384-VoScp22LWX8GkkUAmdkkkj+rz+/r84lmCD6FALIryJxjwBSz6kE6oebSlamQx19e\";s:15:\"css/regular.css\";s:71:\"sha384-uUtN9GUP/RxDz5kko+qO6znqTP45OrABIxrrPhm8tax1s1huRxYCF7xDm+YunNDB\";s:13:\"css/solid.css\";s:71:\"sha384-9AfJF7pZ+RYk3wXpf8ge6fc3XhPaW3Xl57Qj/mSzPckn9Tu8zJ9qUipWq+/utX20\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-e3I5IwYfes9z/NL+oosxhrbsLa9R8TaEY+Krsm07Fcz7q/R+8nswvn20QsrR8tsb\";s:16:\"css/v4-shims.css\";s:71:\"sha384-AL44/7DEVqkvY9j8IjGLGZgFmHAjuHa+2RIWKxDliMNIfSs9g14/BRpYwHrWQgz6\";s:9:\"js/all.js\";s:71:\"sha384-S+e0w/GqyDFzOU88KBBRbedIB4IMF55OzWmROqS6nlDcXlEaV8PcFi4DHZYfDk4Y\";s:12:\"js/brands.js\";s:71:\"sha384-NLUhiMQCi+OH3uxQu0Ems+2GYt6KJ89f90f4kZlK0BoDB63kHZqAICPl7nQHppJy\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-PpGSW7GgJeChJyQc4XW1MIgUrRkMZudoPYOYAqGERZ+w8ammaWDBQvHM3Qp85XCV\";s:17:\"js/fontawesome.js\";s:71:\"sha384-aolToWrR1Hn3EFHDZtvTl0mtjuJJKLxSu/6b2tlr1g9dS+RLt6QVshweU+2e1v6V\";s:13:\"js/regular.js\";s:71:\"sha384-LCyqT0dvDekY5RP1UquYgUJARvp4tHVJocO5ICwoWSyVoSXrKpJrRrDYxj7+ukHO\";s:11:\"js/solid.js\";s:71:\"sha384-QsXs4eh2k/7mk3dvvNMhJJDjh8UQ++vWm4e7ULJ1UZTbOv3wQOzn+4ULg5iLW+Ph\";s:14:\"js/v4-shims.js\";s:71:\"sha384-NNQFVmb048Dmy0GH4ex0kGVcjxaPeY6JA1+ImM4Lsfr4HOD5CNMvCSoIfjeJJWX9\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-ekOryaXPbeCpWQNxMwSWVvQ0+1VrStoPJq54shlYhR8HzQgig1v5fas6YgOqLoKz\";s:14:\"css/brands.css\";s:71:\"sha384-z3CBOpMFSI4D+GXPvBsSW5vXhm4MEzWuC/CycHv+vsuzuztOzPpomZimFLeWNOgk\";s:15:\"css/duotone.css\";s:71:\"sha384-SnqCl1xqt09zXtBnCqJWrwMR2wbeWfxeAEB8e2QuoHdWNY1V5k0HrDi889EMHehh\";s:19:\"css/fontawesome.css\";s:71:\"sha384-CtsKDnRWWHDhjRZ5qgpCFCGpib2FU2SChFu0xRt81grgvXq1P+lbpROQoBLxlU4o\";s:13:\"css/light.css\";s:71:\"sha384-i+ivMdAc0+wLEnd+UdXLpYGNTbyn/0Rjz7EqmkqEOkfat5/2T+S63wn3WDk6h4Yh\";s:15:\"css/regular.css\";s:71:\"sha384-hCQzyeTkj8xmAEG5HT7Hx6t6DUkpTM34rr6FHL04J4AWtPtryU6EjsEDb+Gf17KD\";s:13:\"css/solid.css\";s:71:\"sha384-U9f9KTMQ1TBvUUFLpp6FgAy1M59lrF3q3rYTHPRVtT8OzY3xyyFUzKevJFYHEbhq\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-CpTDS+d/m1rbSfuYxoVJXNCmq6ovovJAD1qgFE+K1Vf5N/n5Nt5yEoZq1UovRsXR\";s:16:\"css/v4-shims.css\";s:71:\"sha384-w49b1IAwJTEsYuPUW2QuSzpWNnhksbL+b/1q2eGObJ2CVV/HO5ubRS4jyMLB4cGs\";s:9:\"js/all.js\";s:71:\"sha384-t1m5KR+UJYhp5D1IG6cS5MuYjxDyh/lIkrB1YUpSPfGxgR4r7pA2xW+KoAfcE5IZ\";s:12:\"js/brands.js\";s:71:\"sha384-L2A2TL70Fg2x6gHvF0zTdYDo163eb/op5YdWXAr/rWfprmIjt6Ib+mdHv60yzNh2\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-Tj7c3TfdpwGV2RqPFYgEbtUTrY+wJeAPDMsuUTvdrbMDWlP6gpUN6LNbXNf1C8BA\";s:13:\"js/duotone.js\";s:71:\"sha384-wAGnJyD+rhKARbazT5ohAk3YosShbJZGkuSG5lrKQOfQpG+7Q7o6ZmAvNqeJ7mFf\";s:17:\"js/fontawesome.js\";s:71:\"sha384-YdKgBdzRKP5F/uorpoOtlS1fRNfveZicpRkkQTn0pQdqGWQs6AMr7Jby3mA/G53+\";s:11:\"js/light.js\";s:71:\"sha384-VuS+lIluvKV9KjbEENEaZi4Ixed0QRYlUr6DI6+U1vj/rOfMP7wl84Z53+fMZXM5\";s:13:\"js/regular.js\";s:71:\"sha384-lS00sjHGt6pxefm2C7siOngllQ0WM3NoXEgwBb79KI3nh2iB5F/vkL7q09F/Z3tj\";s:11:\"js/solid.js\";s:71:\"sha384-ejND26kSb92qqj9cH70EMoR8jytCElYWiCB0v+JkXBz6+2ccBkNJkJZuMmrXY9L+\";s:14:\"js/v4-shims.js\";s:71:\"sha384-xCtgvUZSTFqAix3U6PrST0KLLMXPkzVPwXq3AbYkoKi81K4Ppryd5D8lUII1MeU+\";}}}s:6:\"5.12.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-v8BU367qNbs/aIZIxuivaU55N5GPF89WBerHoGA4QTcbUjYiLQtKdrfXnqAcXyTv\";s:14:\"css/brands.css\";s:71:\"sha384-+2AYGyI2bR10NExh4Lu/3NQmpNxck8EcRE7aATrMi9QQ9OAKQAQw1bcrlWkp0tdM\";s:19:\"css/fontawesome.css\";s:71:\"sha384-C1VkjHy10mh0wo7rz2xEDdqrfn5C+AJpaCpUyScFHzKb0mnAU3I//2RrdAE+LfQ6\";s:15:\"css/regular.css\";s:71:\"sha384-ZYhRqsbjqPY5BrYAS/7RLN0cbKU9T2MfB24Lb42Gyv2BHvW5sujo7gc5gXEReTq9\";s:13:\"css/solid.css\";s:71:\"sha384-yiUBjfJC2dVbhAEtVzEfH+R8ZQJ91V1C+Vtr1ZDTX+gUBZWrNyVrs/Nvc1fzi8GP\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-XBFwYq8dzGeC/rGkEgveavwuEU0D16mIKfWeCX6deYzhMUaa8GX4CgA5c/YHP2xo\";s:16:\"css/v4-shims.css\";s:71:\"sha384-C8a18+Gvny8XkjAdfto/vjAUdpGuPtl1Ix/K2BgKhFaVO6w4onVVHiEaN9h9XsvX\";s:9:\"js/all.js\";s:71:\"sha384-ZbbbT1gw3joYkKRqh0kWyRp32UAvdqkpbLedQJSlnI8iLQcFVxaGyrOgOJiDQTTR\";s:12:\"js/brands.js\";s:71:\"sha384-KASsDRWwlErb8dTf+e5TxRXMnbXrVlbPbn1hS5B/yS4vNsF7mHHO+Gw1bBDhcyOt\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-fHnSzPZE3xYvvXY0y51vln9J+Jd0eK4HughCkcA0NsBpmAGgU97n65RbDqUgnWf1\";s:17:\"js/fontawesome.js\";s:71:\"sha384-H4naMsxnUrIT8qihjWfwIKXi5biIYnqUsQ+vIJGZIKfA+7/O3FxgvMrdH77X+aID\";s:13:\"js/regular.js\";s:71:\"sha384-yUk5aOIIy62R2bRFbFq0+bo+ChWYs75cusETAJ1KYvEMRiEbQZmNU6u+PK60t536\";s:11:\"js/solid.js\";s:71:\"sha384-OSCcNUu98kEBVxq0vZaBr0wdmmd2ojuJwvWuSRKD0V10PWmvTetja8mxGfZm5PsV\";s:14:\"js/v4-shims.js\";s:71:\"sha384-/OZ1Lht4J1/FfstamqqFX1tF7PkDWDKbvat1bkWByC2KRJwGzm/H2bVuw8N4SD8y\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-TxKWSXbsweFt0o2WqfkfJRRNVaPdzXJ/YLqgStggBVRREXkwU7OKz+xXtqOU4u8+\";s:14:\"css/brands.css\";s:71:\"sha384-oRjDIXtfHT9YAjxHLAbf8PsJklTJN+dl7PmnAlOTYJhNAspi+/xgU4f12vi5xGzz\";s:15:\"css/duotone.css\";s:71:\"sha384-qrJ30c8jzW/3IOQRl4RddzzMsw3YIUWq5YhHW/8D8EJnS+5J13GpCGVEVI3ELc/W\";s:19:\"css/fontawesome.css\";s:71:\"sha384-k8n1hWo+b1vuRb6E3KATGC++lfNDnJTtJ6pS2BFF3tp/OshnO7uhzoOj/zJbGfwg\";s:13:\"css/light.css\";s:71:\"sha384-iUpVK/Fzq7teRSWAUmJsnlccV1OgC2fMpgreA8gxAm68UxbZPiMu3GP4IbKdKIUh\";s:15:\"css/regular.css\";s:71:\"sha384-QprxpKrx/cRYKXmWVkM97ert3857dCN6bbf6cRMELoa1+IYdsHoqweHwJksEfb0j\";s:13:\"css/solid.css\";s:71:\"sha384-uef1Ib3WhVuFbw7CZtyE+4IDCiKe1/bGU0vJ2naf8VQHKAeA67yU344LBk/H6nhx\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-GucW5chDMZnyGPL1yaIe1GOHu/X7ixbmNjinYEIVr8a4Q4ewZjgipeXJhVi1lsrd\";s:16:\"css/v4-shims.css\";s:71:\"sha384-58YCAaXf5eAJ+1vna1eEUPuU+Ez6EhIPG77PXmK7QciGJsDNAHt2D8ke3vDio+Hz\";s:9:\"js/all.js\";s:71:\"sha384-RiuSF/PBDHssKXqYfH16Hw3famw7Xg29hNO7Lg636dZXUg42q2UtNLPsGfihOxT9\";s:12:\"js/brands.js\";s:71:\"sha384-yrJPiY+1PdmFAwIfz5kqOJt6qBz7DmhXnjLZWLQ9FopoqnhHIBdOQk6hafYoSquV\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-bIg1sG9EStRr/9ohrrZJs0/uTEvUEEOO+NWuOAsIj3a1ZCHqvWUW6w975b4BSbqI\";s:13:\"js/duotone.js\";s:71:\"sha384-1EFXmt5rBEAK6aeEt/mZiYu0QhdFqz7oRm0Kc4xKyZ2IkrQYBc5F77PWXv3Jl4jY\";s:17:\"js/fontawesome.js\";s:71:\"sha384-P6BxA/EZmb6ypE1RKWOU6G8Ww/wI6w4R6uP6u9mkq3uaBehDQxHOLax3fLvDqkvt\";s:11:\"js/light.js\";s:71:\"sha384-08D3jBd9Co2q3IJB/9qnaukQ4ZhFWVLATRpNirJUQ+yQ/oUORDPfJ7Z2OWySf7/A\";s:13:\"js/regular.js\";s:71:\"sha384-zw99I3pdjnsTnY9W+2pz18pxMpOw12uAiVqYL4dZJOf0Lm8dio2v03Y0L2wzECI7\";s:11:\"js/solid.js\";s:71:\"sha384-Jr2b2cxzFQ84TxM+s7yh1jUu1f4FLCHQQDT3ZeBYZNQo+xvCw52PmB7GbC9yqSqA\";s:14:\"js/v4-shims.js\";s:71:\"sha384-sLzGuPzMXKEht2hBPBvC5ere217qvxFZ1AogesHLWdB5ojWBInm4wE4J+HV7PB6z\";}}}s:6:\"5.13.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-Bfad6CLCknfcloXFOyFnlgtENryhrpZCe29RTifKEixXQZ38WheV+i/6YWSzkz3V\";s:14:\"css/brands.css\";s:71:\"sha384-yZSrIKdp94pouX5Mo4J2MnZUIAuHlZhe3H2c4FRXeUcHvI2k0zNtPrBu8p3bjun5\";s:19:\"css/fontawesome.css\";s:71:\"sha384-syoT0d9IcMjfxtHzbJUlNIuL19vD9XQAdOzftC+llPALVSZdxUpVXE0niLOiw/mn\";s:15:\"css/regular.css\";s:71:\"sha384-rbtXN6sVGIr49U/9DEVUaY55JgfUhjDiDo3EC0wYxfjknaJamv0+cF3XvyaovFbC\";s:13:\"css/solid.css\";s:71:\"sha384-fZFUEa75TqnWs6kJuLABg1hDDArGv1sOKyoqc7RubztZ1lvSU7BS+rc5mwf1Is5a\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-zMDYkJEHc2iapAk7o9HXGGD5N2+GGhOFQPDdNTYvlcc0gBA5r7r5f0aSYeCvm0qn\";s:16:\"css/v4-shims.css\";s:71:\"sha384-/7iOrVBege33/9vHFYEtviVcxjUsNCqyeMnlW/Ms+PH8uRdFkKFmqf9CbVAN0Qef\";s:9:\"js/all.js\";s:71:\"sha384-ujbKXb9V3HdK7jcWL6kHL1c+2Lj4MR4Gkjl7UtwpSHg/ClpViddK9TI7yU53frPN\";s:12:\"js/brands.js\";s:71:\"sha384-c4QRk2vaIFBj+66H3IMCeLBpgmeNbFV8HqOs55qMib1v/dM3JXdodyctPNa9hTyl\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-sDmAMseQ6ZkNcFsP2c8NLyUmSqzUpn9PdoWqr/IP+mXZANSiuN9/09SKaEaMJ39l\";s:17:\"js/fontawesome.js\";s:71:\"sha384-/uNTArWag0fq+MOMnITxuc/uQTqh5NVc+1x0LO4xG//FFwUa8Xff8zrZXIpETdf9\";s:13:\"js/regular.js\";s:71:\"sha384-5FWE8IhPJgMtacw/tJgCapT/ag4ftBYmykFO3KUsozTQ9JKaQhH2oX7RZdCDyWxg\";s:11:\"js/solid.js\";s:71:\"sha384-dCJKkv4KgC8c4IlevkK2DC4yY+rQidnMOt91EmILDbdn8M6cdsjaUbf6awWnsCaZ\";s:14:\"js/v4-shims.js\";s:71:\"sha384-XrjUu+3vbvZoLzAa5lC50XIslajkadQ9kvvTTq0odZ+LCoNEGqomuCdORdHv6wZ6\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-IIED/eyOkM6ihtOiQsX2zizxFBphgnv1zbe1bKA+njdFzkr6cDNy16jfIKWu4FNH\";s:14:\"css/brands.css\";s:71:\"sha384-YJugi/aYht+lwnwrJEOZp+tAEQ+DxNy2WByHkJcz+0oxlJu8YMSeEwsvZubB8F/E\";s:15:\"css/duotone.css\";s:71:\"sha384-oRY9z8lvkaf2a1RyLPsz9ba5IbYiz1X/udoO3kZH3WM+gidZ+eELnojAqaBwvAmB\";s:19:\"css/fontawesome.css\";s:71:\"sha384-tSxOKkJ+YPQOZg1RZd01upxL2FeeFVkHtkL0+04oWgcm9jnvH+EQNLxhpaNYblG2\";s:13:\"css/light.css\";s:71:\"sha384-HLeT9I9TL5c2ujLOZhv6z58D+FdF5R//KTyhCOiYBp1ZX9ZEdaVKPxZmzPx/tMWY\";s:15:\"css/regular.css\";s:71:\"sha384-BPtrG4jSUTPogkW6mA5hAGjvJapJnnMa8tKHQOR9MnrINanXN/IGDInK/SngoAFb\";s:13:\"css/solid.css\";s:71:\"sha384-9mSry5MRUHIfL5zghm8hV6FRKJIMfpofq3NWCyo+Kko5c16y0um8WfF5lB2EGIHJ\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-9WuNcdGCglpaefA1oUecTWMQL/+LmrCJiJJM+pDHX+82lfkj1CKUYLc6DZJQ+1/s\";s:16:\"css/v4-shims.css\";s:71:\"sha384-/WH+7sthk7TduL5PHd16Jew3Hd7eKInsAclAq/MoZWeyR4bMgUj12MSN79PtHEjc\";s:9:\"js/all.js\";s:71:\"sha384-Z0e6PSokCQP510gixgZGPs+obVv8eogS/eS2+/7lLSMOfmLnWBgPQppPispQXGUM\";s:12:\"js/brands.js\";s:71:\"sha384-T90KA1rFqB4OFs7EjJ9EGjXJkOXPhELY4hLaFVnB0LaTNUFGn3QyzNJZh307KVVc\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-8g5Au/J6e7pPZjkCDisd8Jd9psYpdlosRUbac9lOdXAADXrNgc20T1Xc24eIy3I7\";s:13:\"js/duotone.js\";s:71:\"sha384-dkbWEvgccxMcr38iB9BWNiExUnolXcLY54hGUJkFUqThvx5XsvcEervgRgRWz5fl\";s:17:\"js/fontawesome.js\";s:71:\"sha384-bU46hq+Od2wfS4XGCT7Ab5XmYYYY8LURSiGsr4YLIrUWBPeImW/B+OkFEcHhOzuF\";s:11:\"js/light.js\";s:71:\"sha384-ipYj2yPBG2ozjlrUCd6AheWkvEpqcCQNY7yxX8wDoIJc5Lr1zVXAE4sKB3hVfjfT\";s:13:\"js/regular.js\";s:71:\"sha384-5CC2/v59nxbyM1595fgM84ERvZXK5WbpCnB9/dd1gTJc2LyitbiKhULkaiXZNj6V\";s:11:\"js/solid.js\";s:71:\"sha384-Imz7xdjp2/vTu6azMFMusPHfSLwcYmj5ZWzOXv3esrLD8IDP9AMA28bwpJZwaR1g\";s:14:\"js/v4-shims.js\";s:71:\"sha384-ZbnNry/TJ2Ald71QRyefS1elxArPz0oOfiNFxpfSO0Yb5lnnftVJMFbENL3j0hCf\";}}}s:6:\"5.13.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-xxzQGERXS00kBmZW/6qxqJPyxW3UR0BPsL4c8ILaIWXva5kFi7TxkIIaMiKtqV1Q\";s:14:\"css/brands.css\";s:71:\"sha384-pmyS4Hp0pc0tA0poF+AKYeURgyIgYLt12rD/6gLC98rTImbSYIe75vT2/3jK4zIh\";s:19:\"css/fontawesome.css\";s:71:\"sha384-O6duc3QftgMWW3awKiGYswymy288kVFZgGWC/4YCl48Y0codWJRgs8DA0N4dX/zx\";s:15:\"css/regular.css\";s:71:\"sha384-aDoEE1PtWF0YZqVk7el3O+QPApPko7v9/7VYyuzjhHWwJ3cmn0m7xE3/FkHSpPNT\";s:13:\"css/solid.css\";s:71:\"sha384-wG7JbYjXVhle8f17qIp6KJaO/5PsPzOrT76RgvdRGLHj0yXZZ3jg98yb0GNRv1+M\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-CFCaxC5Lp+1aYrNgJjxz8bNrgnzVPnSxma3pb+m90jym25B+q2vYd3JfLQR00SNn\";s:16:\"css/v4-shims.css\";s:71:\"sha384-KkCLkpBvvcSnFQn3PbNkSgmwKGj7ln8pQe/6BOAE0i+/fU9QYEx5CtwduPRyTNob\";s:9:\"js/all.js\";s:71:\"sha384-heKROmDHlJdBb+n64p+i+wLplNYUZPaZmp2HZ4J6KCqzmd33FJ8QClrOV3IdHZm5\";s:12:\"js/brands.js\";s:71:\"sha384-Ay9V1h0l5sywM7gJ5YvOc05QytfKqZAElRgqU5kPcIIUAUBqLOYwu9gnW6p5t/FN\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-xDU4X/EdF/mFSa0TktUKBTHd/td1gTc+xWNLKdYcvrAUZExjiWhDnrLM4lGkqzeH\";s:17:\"js/fontawesome.js\";s:71:\"sha384-4NJBLvz0eHSgtSVDb+VOLh4cxmVluIBqCaNw97NvJAo18r+qV9pze1g4YnhB/X6Y\";s:13:\"js/regular.js\";s:71:\"sha384-omrmE/gvA72r1j409JaSn3V6w5f7Mx7GZpjB8xqS4nLwGpT7Zj2obev62Y9QcCZr\";s:11:\"js/solid.js\";s:71:\"sha384-81RFXCmeESYg4G/uFGo6Tu/eeK3klw0oKItW3nPhi2BuryJcE4lkOkwWsW6jzoNz\";s:14:\"js/v4-shims.js\";s:71:\"sha384-CtI1i5e/58ZMUgZkT75wgboNZAbEXBNToPY17SfEmfyKvGuJW7DP418LdXkjI++F\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-B9BoFFAuBaCfqw6lxWBZrhg/z4NkwqdBci+E+Sc2XlK/Rz25RYn8Fetb+Aw5irxa\";s:14:\"css/brands.css\";s:71:\"sha384-e0CAD3LQqbxBCI1WW9pe35Vr+ogbg41axplGx9yY6Woaw6h+zHnB7v4sVuZjHDnK\";s:15:\"css/duotone.css\";s:71:\"sha384-jZslG/z2CMKpawOGi2BzAUH7QBRu5umkFNeP0Op1SZksaT8WGx5MuZazFfE/XR9h\";s:19:\"css/fontawesome.css\";s:71:\"sha384-eKHMjnfl7jrOmk1Fw4dpPDTetBHFOho47C/omrsmBVN2ii45aI8s97OUFVtGg1CR\";s:13:\"css/light.css\";s:71:\"sha384-N45G0WPo8CMcXE4y+hOnuWLp2TJxNbhk/YbM4GQEymB5fPGzOXVH+er/7Z15oBjl\";s:15:\"css/regular.css\";s:71:\"sha384-h1Eirl+AlKkBdUtIMW1hm36KarFrx3iEfjcnTYKeeUdZTOsT8hLDc0lnlNG2jPn5\";s:13:\"css/solid.css\";s:71:\"sha384-F78AVlY1oEzT5bXRSwVzraqWTcbpglP7ILEEE3rmu1gIfm/TUo5gpdN4YVfvp7Xj\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-ZFFudtU+0nvUFj6ogUZSspaq7QhLb6JJX6jSIu5UiZAbZMhnBJfNwZahptQ4MQ/i\";s:16:\"css/v4-shims.css\";s:71:\"sha384-He820UjOck3Qu+A0dH2+CmHOeYAYN0kqRW3s6hHC/Jzu8IXSeZF2pn+lgVpz4KuJ\";s:9:\"js/all.js\";s:71:\"sha384-RFburpZVVirucdjarLLIoBiT+LY5YuPB8XboZYWRuWpElr46csH7Ia2nsHfkfBZF\";s:12:\"js/brands.js\";s:71:\"sha384-bM9U2rf0yP/4jsztQkRVwJnqtVcLJzwAMaVgd4sfQYxxm0ru+TieQ4ZaxKW4vsyo\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-DuzRvwD99f8XqXEPIxkpB1F+Ik6c2AZMj6gWcEDwFUCAgtVSelRH9Dos4SMxw/+i\";s:13:\"js/duotone.js\";s:71:\"sha384-uABtWM9HIHso7RIYTkd4w0zB8IgL/hTcPNyYTVA62Qw0lK3umduLb+vIYtXCd6W8\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Ta21ZAqXVyXVqLCnHENnO2ULnrJQzNdGFAbMR1nbZOSV7PcTcZVIWZJCCcRYy2Q4\";s:11:\"js/light.js\";s:71:\"sha384-+8Y6x3Roex77ZBdaQqtTN2QKu/TIOdzoswRYxryfW9ELmUxMTYLgzdz5nlA/3ndC\";s:13:\"js/regular.js\";s:71:\"sha384-sSHWg/dKYjGSJU6C17C2qGImASfPcJqy2BaW/iTzifkPJmzprIMH1tl4/tIbWq8M\";s:11:\"js/solid.js\";s:71:\"sha384-VBOdkc1roPM6EIGTBi2yraUNs04SZ9+TsLzF0vIecIKYf6oXYxAYgjzMpH8UdZYh\";s:14:\"js/v4-shims.js\";s:71:\"sha384-iwdWtJevtQK06+Bbqeb7Oo+osfnPQWsHQWR+5SeND0soWVUGjfyRC2XdttrYI2j+\";}}}s:6:\"5.14.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-HzLeBuhoNPvSl5KYnjx0BT+WB0QEEqLprO+NBkkk5gbc67FTaL7XIGa2w1L0Xbgc\";s:14:\"css/brands.css\";s:71:\"sha384-MiOGyNsVTeSVUjE9q/52dpdZjrr7yQAjVRUs23Bir5NhrTq0YA0rny4u/qe4dxNj\";s:19:\"css/fontawesome.css\";s:71:\"sha384-PRy/NDAXVTUcXlWA3voA+JO/UMtzWgsYuwMxjuu6DfFPgzJpciUiPwgsvp48fl3p\";s:15:\"css/regular.css\";s:71:\"sha384-e46AbGhCSICtPh8xpc35ZioOrHg2PGsH1Bpy/vyr9AhEMVhttzxc+2GSMSP+Y60P\";s:13:\"css/solid.css\";s:71:\"sha384-TN9eFVoW87zV3Q7PfVXNZFuCwsmMwkuOTOUsyESfMS9uwDTf7yrxXH78rsXT3xf0\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-PB7dcmSOBXciTYYzTvxdvcCEy4k3woMwwVAtsIA3LUQyKW21C7UL9EcGtd6IRNLc\";s:16:\"css/v4-shims.css\";s:71:\"sha384-9aKO2QU3KETrRCCXFbhLK16iRd15nC+OYEmpVb54jY8/CEXz/GVRsnM73wcbYw+m\";s:9:\"js/all.js\";s:71:\"sha384-3Nqiqht3ZZEO8FKj7GR1upiI385J92VwWNLj+FqHxtLYxd9l+WYpeqSOrLh0T12c\";s:12:\"js/brands.js\";s:71:\"sha384-V7gsTxvUZaeC6NAsCa24o3WvPOXwSsUM8/SBgy+fxlzWL3xEGXHsAv2E3UO5zKcZ\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-uMs7U5rgbKM9mJ/p05oZ+z+8uK1lwLhl96KWxP5odG0wm26IfhzgKQ0ktZnc2PYP\";s:17:\"js/fontawesome.js\";s:71:\"sha384-DNo9bmYZCHLtp0n0l0XA2UsoRHX1nx38aRP+p9yoP5A8kVTfeWG3aySMOq5FD/v3\";s:13:\"js/regular.js\";s:71:\"sha384-zHXcIX0meH+eFgqCa9QdLtYfc+0p7KcF4fVB+gMVFjV6rzYv+LxSIuF5i2eGVDlt\";s:11:\"js/solid.js\";s:71:\"sha384-4RG3cEPIlCBy6VNzxM9ZoEwZW+65ed5JDOfaJAnQqwV6ha/jZDJTXjFmvjFM4bk4\";s:14:\"js/v4-shims.js\";s:71:\"sha384-g+ezV6Pq6549QkJkkz2wmW/wpazNaliTdSg/HX4bKsQ7S8cfyMOiyAfzfWPtlVR9\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-VhBcF/php0Z/P5ZxlxaEx1GwqTQVIBu4G4giRWxTKOCjTxsPFETUDdVL5B6vYvOt\";s:14:\"css/brands.css\";s:71:\"sha384-DkuHshSFBB5Ozmaoq36ICABPCsIIbamipzuH7NO0sxDIDrJloLD43yBzNLI3gxS6\";s:15:\"css/duotone.css\";s:71:\"sha384-QRFqAT1IRNAzMGALiXfanFtQEBoLDPPh1vnrMbxHa+UeJkCTHO3TpYXHQ+GK1pKg\";s:19:\"css/fontawesome.css\";s:71:\"sha384-CAxg0L30Vie2vI3AniQ4UA+pSswoJmr/MK5Dl5DP9YlE1nzJn4z5updw5S3i/Nsn\";s:13:\"css/light.css\";s:71:\"sha384-LmKkPHDqucxgmrtLKWrMGZc5nnHQYAdFkSzMtl1OcvTZn4pebmVziSZPtp27MA6u\";s:15:\"css/regular.css\";s:71:\"sha384-izRgjQadEFrlAsdFZjlQ4v6Ff2E0R02RwYZwdL8lrt398rQmLNOFYYNk9qQoqjDP\";s:13:\"css/solid.css\";s:71:\"sha384-qJugmlTDyF5CNuv00JB+04BCmCVi5C2ZZhsIVMX0wxWr7U3ZuOsmO+nOLtoTxeWG\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-EjLtrKO3gucE2cOzLw8A5aJpQ9oXEJTxlTkbLrrL4JR7xGLPI8B1fyK3ygNxeLxq\";s:16:\"css/v4-shims.css\";s:71:\"sha384-oydBLEZZlqJqf0OWwXyyj91mRqrL25j/VMAvTl0BA0iIMoJGDTSksMDnqkl+TWLA\";s:9:\"js/all.js\";s:71:\"sha384-8nFttujfhbCh3CZJ34J+BtLPrg9cGflbku3ZQUTUewA7mqA8TG5Uip4fzQRbERs0\";s:12:\"js/brands.js\";s:71:\"sha384-9112PiGcvkxlUNBecZ0rk0c6zEGUKlR/enlHdLy0Xu42kfHEbIKsFVBsmEn+6cEt\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-9rbnCwKDHzpLDHYvYRqRWcyLZc3anAu+oe1dRxPOk7RcqBzjAv7CYTvAQJGkUNXS\";s:13:\"js/duotone.js\";s:71:\"sha384-HFlrQxjzjMUAiYmFuUKrkp90VMEpD/dpb8unLEWH5QXnUs2xHw5zd8aiztrPBLbT\";s:17:\"js/fontawesome.js\";s:71:\"sha384-XULY2W1C7bGq9gruRvsk8Zyhq33b1/TgBBKzJ+8dzWkJm0kObgcry2qU+Qf+HOZw\";s:11:\"js/light.js\";s:71:\"sha384-a8Ul+Nmi3glFYXvks3ShdxGHyk09LsZ3+TIjDr2vj9lMx2F29TqTJm7U0EutxFdH\";s:13:\"js/regular.js\";s:71:\"sha384-B8V2/SCNt/naDJB0LkeljUBBYYhGFm/rUVnNsFYlutzbeSTTzVEqxRo8SN3tuHSl\";s:11:\"js/solid.js\";s:71:\"sha384-CjNAVlgtLE9uQuDgWphA+b5vXjcy5spSSezhnbGWUZl0VDkAxzeU8elFOdDs4qaU\";s:14:\"js/v4-shims.js\";s:71:\"sha384-kN/8Lc85No/I30OsF5JSmBzc0W1W0AvgBJGA1eEtVSfaiIeg8oPTJ8CerHqDREVn\";}}}s:6:\"5.15.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-vp86vTRFVJgpjF9jiIGPEEqYqlDwgyBgEF109VFjmqGmIY/Y4HV4d3Gp2irVfcrp\";s:14:\"css/brands.css\";s:71:\"sha384-/feuykTegPRR7MxelAQ+2VUMibQwKyO6okSsWiblZAJhUSTF9QAVR0QLk6YwNURa\";s:19:\"css/fontawesome.css\";s:71:\"sha384-ijEtygNrZDKunAWYDdV3wAZWvTHSrGhdUfImfngIba35nhQ03lSNgfTJAKaGFjk2\";s:15:\"css/regular.css\";s:71:\"sha384-APzfePYec2VC7jyJSpgbPrqGZ365g49SgeW+7abV1GaUnDwW7dQIYFc+EuAuIx0c\";s:13:\"css/solid.css\";s:71:\"sha384-yo370P8tRI3EbMVcDU+ziwsS/s62yNv3tgdMqDSsRSILohhnOrDNl142Df8wuHA+\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-wvKQCF3aHjf73vG90/oO/tFarRthMbxfbW1DeHM+eJJYWmiFLJ0DyCzE1aSFHazB\";s:16:\"css/v4-shims.css\";s:71:\"sha384-WCuYjm/u5NsK4s/NfnJeHuMj6zzN2HFyjhBu/SnZJj7eZ6+ds4zqIM3wYgL59Clf\";s:9:\"js/all.js\";s:71:\"sha384-9/D4ECZvKMVEJ9Bhr3ZnUAF+Ahlagp1cyPC7h5yDlZdXs4DQ/vRftzfd+2uFUuqS\";s:12:\"js/brands.js\";s:71:\"sha384-GUtlu2Qit8cdodM5DbKnbDIWFJA8nWCVEwETZXY2xvKV1TFLtD/AL+bCOsPyh05M\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-sefi04js7ZytQojQsuOy097ewgefakplyIWjkCI75Wz1IxHB/9NAAinmgLG3uDt/\";s:17:\"js/fontawesome.js\";s:71:\"sha384-v0OPwyxrMWxEgAVlmUqvjeEr48Eh/SOZ2DRtVYJCx1ZNDfWBfNMWUjwUwBCJgfO4\";s:13:\"js/regular.js\";s:71:\"sha384-i9Vys31h0tPXNeAe12HKp4zkBi0S3LAH4OGYRSWKSrdnPYTS4pQgCc/HakrenJBh\";s:11:\"js/solid.js\";s:71:\"sha384-oKbh94nlFq571cjny1jaIBlQwzTJW4KYExGYjslYSoG/J/w68zUI+KHPRveXB6EY\";s:14:\"js/v4-shims.js\";s:71:\"sha384-IEHK9LKBXJdi7Y/gik7R6VYPuwx8hMiwQuaOh7BQUQ9rKmWr2N04KYFdmt5Xi0qG\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-9ZfPnbegQSumzaE7mks2IYgHoayLtuto3AS6ieArECeaR8nCfliJVuLh/GaQ1gyM\";s:14:\"css/brands.css\";s:71:\"sha384-YgEKO0tR8hhGPO9Dv3YGK+GstKp44//D72dbOA0oTX+7myWawnkifErid6FIpP9W\";s:15:\"css/duotone.css\";s:71:\"sha384-bXXzjCj9fg9FACS6tpRWhBsNqQ7j7swH/U3MKTJrZuRbF3ktmj9g/lie7L3CNSTd\";s:19:\"css/fontawesome.css\";s:71:\"sha384-RFOcGND+1HYm6OyEAF5WKkoZnwv/cXQpCX6KduKC1vAKAoohkNYWNPhkx4fsH9Fn\";s:13:\"css/light.css\";s:71:\"sha384-yWmEVLm9kM0L2w+XPDQQUv6tARNHEYPPwdDplMiVced5iOVoiUIToRveagZ56DVa\";s:15:\"css/regular.css\";s:71:\"sha384-pvlGSUiPzTZa8YsqGs23BENlf3D4ddnLRdl2q5R1ekGw7nnWJZ0AK74DUr0mzLTH\";s:13:\"css/solid.css\";s:71:\"sha384-LRz1HmzqffP7wO7piC0QSObi89cOdpFP7qMIx/UZ+qK2TdoDBdl+LidxFVnYu23p\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-mFHdQxElacASluqApikB6+SUGnAOWouxc19KqW5eZGoZ+b4A/Cj6pMUCGn6g1uZ+\";s:16:\"css/v4-shims.css\";s:71:\"sha384-r35xeRHwDKxzFjeApFdZuwo9D/nV4p0BPL4BxIVmsyKQGWWBaxG59Gr/9x7IfVog\";s:9:\"js/all.js\";s:71:\"sha384-Vipr9QSlUeD/qnhkau6GBnZnUmVkbaRZ0PgB1KjvWa1UoNBKnuzg1TgbJJn2a12T\";s:12:\"js/brands.js\";s:71:\"sha384-rdZ4AVYAMfVJRjRJzozK2JY6LOdLxKdUkHuegulAuMdllLH7M9AllgBLuYmBe+zm\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-qgGl/EYa0JYIveAO7M9W/hshMqlMyo0G/QHio/5D5r1ZbZxAoqcTTReeL4gRrL4m\";s:13:\"js/duotone.js\";s:71:\"sha384-4qqOVq7ZvSMSgZij30G8q1kOs7pBiAWrSVKqWRv32l99D/qqXlMpFQK8wLSfeQEZ\";s:17:\"js/fontawesome.js\";s:71:\"sha384-whiLNjPVOuBfSNjL/tLtRWANHP97vxmZ5OoUK496MOTzH07UdmxDLsnSBgvvjLNf\";s:11:\"js/light.js\";s:71:\"sha384-AEYbWLXnCyDCeopMCsF+A4qHLchpzJ4wMnZiE74Bcp6qLWwXIJCWY0ASqAf0qYrf\";s:13:\"js/regular.js\";s:71:\"sha384-wM50oZlS/21q6M6tlw0EWan+0yFpuRC/PrPeimdGxjCjfx45F0x3NZggS5uFp5uv\";s:11:\"js/solid.js\";s:71:\"sha384-PezVa2U3+0USHwNA7bgvfA+uSS1IPVdTat51a5IgvNGHUJjcvsj+TheZ6X30JybM\";s:14:\"js/v4-shims.js\";s:71:\"sha384-MafE1kr6MZ6PhxNeH0/kvg7f5ramk1tE+y/dBi4C6WgxaKU4mNGRxPNxcEZ5maAx\";}}}}}}',	'no'),
(47803,	'trustindex-google-active',	'1',	'yes'),
(47804,	'trustindex-google-version',	'',	'yes'),
(47809,	'widget_trustindex_google_widget',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(47812,	'trustindex-google-page-details',	'a:6:{s:2:\"id\";s:27:\"ChIJpwazf96_woARySHYNuGDqxo\";s:4:\"name\";s:17:\"Gray Group Realty\";s:7:\"address\";s:58:\"1115 N Harper Ave, West Hollywood, CA 90046, United States\";s:10:\"avatar_url\";s:97:\"https://lh5.googleusercontent.com/p/AF1QipOpujr_arYiOFYoI9FodCIfQdgiOwB2NItwr9ex=w256-h256-k-no-p\";s:13:\"rating_number\";i:5;s:12:\"rating_score\";i:5;}',	'no'),
(47813,	'trustindex-google-lang',	'en',	'no'),
(47814,	'trustindex-google-style-id',	'17',	'no'),
(47815,	'trustindex-google-scss-set',	'light-background',	'no'),
(47816,	'trustindex-google-css-content',	'@font-face{font-family:\'Open Sans\';font-style:normal;font-weight:400;font-display:swap;src:local(\'Open Sans Regular\'), local(\'OpenSans-Regular\'), url(https://cdn.trustindex.io/assets/fonts/opensans/cyrillic-ext.woff2) format(\'woff2\');unicode-range:U+0460-052F, U+1C80-1C88, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F}@font-face{font-family:\'Open Sans\';font-style:normal;font-weight:400;font-display:swap;src:local(\'Open Sans Regular\'), local(\'OpenSans-Regular\'), url(https://cdn.trustindex.io/assets/fonts/opensans/cyrillic.woff2) format(\'woff2\');unicode-range:U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116}@font-face{font-family:\'Open Sans\';font-style:normal;font-weight:400;font-display:swap;src:local(\'Open Sans Regular\'), local(\'OpenSans-Regular\'), url(https://cdn.trustindex.io/assets/fonts/opensans/greek-ext.woff2) format(\'woff2\');unicode-range:U+1F00-1FFF}@font-face{font-family:\'Open Sans\';font-style:normal;font-weight:400;font-display:swap;src:local(\'Open Sans Regular\'), local(\'OpenSans-Regular\'), url(https://cdn.trustindex.io/assets/fonts/opensans/greek.woff2) format(\'woff2\');unicode-range:U+0370-03FF}@font-face{font-family:\'Open Sans\';font-style:normal;font-weight:400;font-display:swap;src:local(\'Open Sans Regular\'), local(\'OpenSans-Regular\'), url(https://cdn.trustindex.io/assets/fonts/opensans/vietnamese.woff2) format(\'woff2\');unicode-range:U+0102-0103, U+0110-0111, U+0128-0129, U+0168-0169, U+01A0-01A1, U+01AF-01B0, U+1EA0-1EF9, U+20AB}@font-face{font-family:\'Open Sans\';font-style:normal;font-weight:400;font-display:swap;src:local(\'Open Sans Regular\'), local(\'OpenSans-Regular\'), url(https://cdn.trustindex.io/assets/fonts/opensans/latin-ext.woff2) format(\'woff2\');unicode-range:U+0100-024F, U+0259, U+1E00-1EFF, U+2020, U+20A0-20AB, U+20AD-20CF, U+2113, U+2C60-2C7F, U+A720-A7FF}@font-face{font-family:\'Open Sans\';font-style:normal;font-weight:400;font-display:swap;src:local(\'Open Sans Regular\'), local(\'OpenSans-Regular\'), url(https://cdn.trustindex.io/assets/fonts/opensans/latin.woff2) format(\'woff2\');unicode-range:U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD}@font-face{font-family:\'Open Sans\';font-style:normal;font-weight:700;font-display:swap;src:local(\'Open Sans Bold\'), local(\'OpenSans-Bold\'), url(https://cdn.trustindex.io/assets/fonts/opensans/cyrillic-ext2.woff2) format(\'woff2\');unicode-range:U+0460-052F, U+1C80-1C88, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F}@font-face{font-family:\'Open Sans\';font-style:normal;font-weight:700;font-display:swap;src:local(\'Open Sans Bold\'), local(\'OpenSans-Bold\'), url(https://cdn.trustindex.io/assets/fonts/opensans/cyrillic2.woff2) format(\'woff2\');unicode-range:U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116}@font-face{font-family:\'Open Sans\';font-style:normal;font-weight:700;font-display:swap;src:local(\'Open Sans Bold\'), local(\'OpenSans-Bold\'), url(https://cdn.trustindex.io/assets/fonts/opensans/greek-ext2.woff2) format(\'woff2\');unicode-range:U+1F00-1FFF}@font-face{font-family:\'Open Sans\';font-style:normal;font-weight:700;font-display:swap;src:local(\'Open Sans Bold\'), local(\'OpenSans-Bold\'), url(https://cdn.trustindex.io/assets/fonts/opensans/greek2.woff2) format(\'woff2\');unicode-range:U+0370-03FF}@font-face{font-family:\'Open Sans\';font-style:normal;font-weight:700;font-display:swap;src:local(\'Open Sans Bold\'), local(\'OpenSans-Bold\'), url(https://cdn.trustindex.io/assets/fonts/opensans/vietnamese2.woff2) format(\'woff2\');unicode-range:U+0102-0103, U+0110-0111, U+0128-0129, U+0168-0169, U+01A0-01A1, U+01AF-01B0, U+1EA0-1EF9, U+20AB}@font-face{font-family:\'Open Sans\';font-style:normal;font-weight:700;font-display:swap;src:local(\'Open Sans Bold\'), local(\'OpenSans-Bold\'), url(https://cdn.trustindex.io/assets/fonts/opensans/latin-ext2.woff2) format(\'woff2\');unicode-range:U+0100-024F, U+0259, U+1E00-1EFF, U+2020, U+20A0-20AB, U+20AD-20CF, U+2113, U+2C60-2C7F, U+A720-A7FF}@font-face{font-family:\'Open Sans\';font-style:normal;font-weight:700;font-display:swap;src:local(\'Open Sans Bold\'), local(\'OpenSans-Bold\'), url(https://cdn.trustindex.io/assets/fonts/opensans/latin2.woff2) format(\'woff2\');unicode-range:U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\']{width:100%;display:block;overflow:hidden;text-align:left;direction:ltr;box-sizing:border-box}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] *{box-sizing:border-box}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-row{display:-ms-flexbox;display:flex;-ms-flex-wrap:nowrap;flex-wrap:nowrap}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] a{text-decoration:underline !important}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] a.ti-header{text-decoration:none !important}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] a[href=\"#\"],.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] a:not([href]){text-decoration:none !important;pointer-events:none}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\']:before,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\']:after{content:none !important}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] strong,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] strong *{font-weight:700 !important;font-weight:bold !important}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-widget-container,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-widget-container *{font-family:\'Open sans\';font-size:14px;line-height:1.4em;color:#000000;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-widget-container{margin-bottom:15px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-widget-container .ti-name{font-weight:700;font-weight:bold;font-size:15px;overflow:hidden;padding-right:25px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;color:#000000;margin-bottom:2px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-widget-container .ti-company{color:#000000;opacity:0.5;font-size:12px !important;margin-bottom:0px;padding-right:25px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-widget-container .ti-date{color:#000000;opacity:0.5;font-size:12px !important}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-reviews-container-wrapper{overflow:hidden;display:-ms-flexbox;display:flex;-ms-flex-wrap:nowrap;flex-wrap:nowrap;padding-top:5px}@media (max-width:479px){.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-reviews-container-wrapper{margin-right:0px;margin-left:0px}}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-read-more{display:none}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-col-4 .ti-review-item,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-col-1 .ti-column{-ms-flex:0 0 25%;flex:0 0 25%;max-width:25%}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-col-3 .ti-review-item,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-col-3 .ti-column{-ms-flex:0 0 33.333333%;flex:0 0 33.333333%;max-width:33.333333%}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-col-2 .ti-review-item,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-col-2 .ti-column{-ms-flex:0 0 50%;flex:0 0 50%;max-width:50%}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-col-1 .ti-review-item,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-col-1 .ti-column{-ms-flex:0 0 100%;flex:0 0 100%;max-width:100%}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item{padding:0px 8px;transition:transform 300ms ease-out}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item .ti-read-more{font-weight:bold;white-space:nowrap;font-size:11.7px;color:#000000;text-decoration:none !important;display:block;text-align:center;padding:7px 0px 0px;text-align:left;transition:opacity 300ms ease-out}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item .ti-read-more:hover{opacity:0.5}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item .ti-recommendation .ti-recommendation-icon{position:relative;margin:0 5px;margin-bottom:-3px;text-indent:3px;display:inline-block;width:15px;height:15px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item .ti-recommendation .ti-recommendation-icon:first-child{margin-left:0}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item .ti-recommendation .ti-recommendation-title{font-weight:700;font-size:13px !important;opacity:0.8;position:relative;top:-1px}@media (max-width:479px){.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item{padding:0px}}@media (min-width:480px){.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item:hover{-webkit-transform:translate(0px, -5px);-ms-transform:translate(0px, -5px);transform:translate(0px, -5px)}}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-content{line-height:18.85px !important;font-size:13px;display:-webkit-box;-webkit-box-orient:vertical;overflow:inherit !important;overflow-x:inherit !important;overflow-y:inherit !important;-webkit-line-clamp:inherit !important;overflow:auto !important;overflow-x:hidden !important;overflow-y:auto !important;padding-right:10px;scrollbar-color:#8d8d8d #e0e0e0;scrollbar-width:thin}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-content .ti-stars{margin-bottom:5px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-content strong{font-size:inherit;color:inherit}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-header{display:-ms-flexbox;display:flex;-ms-flex-wrap:nowrap;flex-wrap:nowrap;position:relative}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-header:after{content:\"\";display:block;width:20px;height:20px;position:absolute;right:0px;background-repeat:no-repeat;background-position:center center}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-profile-img img{width:40px !important;margin:0 15px 0 0 !important;height:40px !important;padding:0px !important;display:block;border-radius:30px;min-width:initial !important;max-width:initial !important;object-fit:cover;object-position:top}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-profile-details{-webkit-box-flex:1;-ms-flex:1;flex:1;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;text-align:left}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-star{background-size:contain;background-repeat:no-repeat}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-star:before,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-star:after{content:none !important}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-header{display:-ms-flexbox;display:flex;-ms-flex-wrap:nowrap;flex-wrap:nowrap}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-header .ti-name{font-size:16px;overflow:visible;text-overflow:initial;white-space:normal;margin-top:0px;margin-top:-3px;padding-right:0px;margin-bottom:5px;color:#000000 !important}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-header .ti-star{width:20px;height:20px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-header .ti-star.ti-rating{color:#728EC2;font-weight:bold;display:inline-block;padding-right:5px;position:relative;font-size:16px;top:-2px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-header .ti-profile-img img{width:55px !important;height:55px !important}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-header .ti-profile-details{padding-top:6px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-header .ti-stars{margin-top:2px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item .inner,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item .ti-inner{border-radius:4px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-stars{margin-top:3px;white-space:nowrap}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-reviews-container-wrapper .inner>.ti-stars,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-reviews-container-wrapper .ti-inner>.ti-stars{margin-bottom:6px;margin-top:15px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-star{width:16px;height:16px;display:inline-block;margin-right:1px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .star-lg .ti-star{width:30px;height:30px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-footer{margin-top:15px;padding-top:0px;text-align:center;line-height:1.45em}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-footer .ti-name{color:#000000;font-size:16px;margin-bottom:5px;overflow:hidden;text-overflow:ellipsis}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-footer .ti-stars{margin-bottom:3px;margin-top:0px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-footer .ti-profile-details{padding-top:4px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-footer .ti-inner{padding-bottom:10px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-footer-link-block{margin-top:10px;color:#000000}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-footer-link-block a{font-size:13.3px;padding-right:10px;opacity:0.7;text-decoration:underline !important;color:inherit !important}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-footer-link-block a:hover{opacity:1}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-footer-copyright{font-size:13px;margin-top:5px;color:#777;text-align:center;line-height:1.45em}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-footer-copyright a{font-size:13px;color:#777}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-footer-copyright a:hover{color:#000}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-footer-copyright img{display:inline-block;width:80px;height:auto;text-align:center;vertical-align:middle;margin-top:-6px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item>.inner,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item>.ti-inner{border-style:solid !important;border-color:#efefef !important;background:#fff !important;border-radius:4px !important;padding:10px !important;margin:0px !important;display:block}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-d-none{display:none !important}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'].ti-icon-size1 .ti-review-header:after{width:25px;height:25px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'].ti-icon-size1 .ti-widget-container .ti-name{padding-left:30px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'].ti-icon-size2 .ti-review-header:after{width:30px;height:30px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'].ti-icon-size2 .ti-widget-container .ti-name{padding-left:35px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-rating-text,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-rating-text strong,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-rating-text strong a,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-rating-text strong span,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-rating-text span strong,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-rating-text span,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-footer,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-footer strong,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-footer span,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-footer strong a{font-size:14px;color:#000000}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-large-logo{display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap;height:50px;margin-bottom:0px !important}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-large-logo .ti-v-center{-ms-flex-item-align:center !important;align-self:center !important;text-align:center;-ms-flex-preferred-size:0;flex-basis:0;-ms-flex-positive:1;flex-grow:1;max-width:100%}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-large-logo img{margin:auto;padding:0px !important;display:block !important;position:relative}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .nowrap{white-space:nowrap;display:inline-block;margin:0 2px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .nowrap:first-of-type{margin-left:0}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .nowrap:last-of-type{margin-right:0}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] ::-webkit-scrollbar{width:4px;border-radius:3px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] ::-webkit-scrollbar-track{background:rgba(85, 85, 85, 0.1)}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] ::-webkit-scrollbar-thumb{background:rgba(85, 85, 85, 0.6)}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] ::-webkit-scrollbar-thumb:hover{background:#555}.ti-verified-review{display:inline-block;background:url(https://cdn.trustindex.io/assets/icon/trustindex-verified-icon.svg);background-size:contain;width:15px;height:15px;margin-left:7px;position:relative;z-index:2}.ti-verified-review .ti-verified-tooltip{color:#fff !important;background-color:#3B404B !important;padding:0px 10px;border-radius:4px;font-size:11px !important;line-height:22px !important;font-weight:500;display:inline-block;position:absolute;left:0px;margin-left:25px;top:-4px;white-space:nowrap;opacity:0;transition:all 0.3s ease-in-out}.ti-verified-review .ti-verified-tooltip:before{width:0;height:0;border-style:solid;border-width:5px 5px 5px 0;border-color:transparent #3B404B transparent transparent;content:\"\";position:absolute;left:-5px;top:50%;margin-top:-5px}.ti-verified-review:hover .ti-verified-tooltip{opacity:1;margin-left:20px}.ti-recommendation+.ti-verified-review{top:2px}.ti-widget .ti-icon:after{background-repeat:no-repeat;background-position:center center}.ti-widget .source-Facebook [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Facebook/icon.svg\");background-size:100% 100%}.ti-widget .source-Facebook .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Facebook/icon.svg\");background-size:100% 100%}.ti-widget .source-Facebook .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Facebook/star/f.svg\")}.ti-widget .source-Facebook .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Facebook/star/e.svg\")}.ti-widget .source-Facebook .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Facebook/star/h.svg\")}.ti-widget .source-Facebook .ti-recommendation-icon.positive{background-image:url(\"https://cdn.trustindex.io/assets/platform/Facebook/recommendation-positive.svg\")}.ti-widget .source-Facebook .ti-recommendation-icon.negative{background-image:url(\"https://cdn.trustindex.io/assets/platform/Facebook/recommendation-negative.svg\")}.ti-widget .source-Google [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Google/icon.svg\");background-size:100% 100%}.ti-widget .source-Google .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Google/icon.svg\");background-size:100% 100%}.ti-widget .source-Google .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Google/star/f.svg\")}.ti-widget .source-Google .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Google/star/e.svg\")}.ti-widget .source-Google .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Google/star/h.svg\")}.ti-widget .source-Yelp [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Yelp/icon.svg\");background-size:100% 100%}.ti-widget .source-Yelp .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Yelp/icon.svg\");background-size:100% 100%}.ti-widget .source-Yelp .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Yelp/star/f.svg\")}.ti-widget .source-Yelp .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Yelp/star/e.svg\")}.ti-widget .source-Yelp .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Yelp/star/h.svg\")}.ti-widget .source-Tripadvisor [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Tripadvisor/icon.svg\");background-size:100% 100%}.ti-widget .source-Tripadvisor .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Tripadvisor/icon.svg\");background-size:100% 100%}.ti-widget .source-Tripadvisor .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Tripadvisor/star/f.svg\")}.ti-widget .source-Tripadvisor .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Tripadvisor/star/e.svg\")}.ti-widget .source-Tripadvisor .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Tripadvisor/star/h.svg\")}.ti-widget .source-Trustpilot .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Trustpilot/star/f.svg\")}.ti-widget .source-Trustpilot .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Trustpilot/star/e.svg\")}.ti-widget .source-Trustpilot .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Trustpilot/star/h.svg\")}.ti-widget .source-Airbnb [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Airbnb/icon.svg\");background-size:100% 100%}.ti-widget .source-Airbnb .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Airbnb/icon.svg\");background-size:100% 100%}.ti-widget .source-Airbnb .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Airbnb/star/f.svg\")}.ti-widget .source-Airbnb .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Airbnb/star/e.svg\")}.ti-widget .source-Airbnb .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Airbnb/star/h.svg\")}.ti-widget .source-Booking [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Booking/icon.svg\");background-size:100% 100%}.ti-widget .source-Booking .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Booking/icon.svg\");background-size:100% 100%}.ti-widget .source-Booking .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Booking/star/f.svg\")}.ti-widget .source-Booking .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Booking/star/e.svg\")}.ti-widget .source-Booking .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Booking/star/h.svg\")}.ti-widget .source-Amazon [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Amazon/icon.svg\");background-size:100% 100%}.ti-widget .source-Amazon .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Amazon/icon.svg\");background-size:100% 100%}.ti-widget .source-Amazon .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Amazon/star/f.svg\")}.ti-widget .source-Amazon .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Amazon/star/e.svg\")}.ti-widget .source-Amazon .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Amazon/star/h.svg\")}.ti-widget .source-Arukereso [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Arukereso/icon.svg\");background-size:100% 100%}.ti-widget .source-Arukereso .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Arukereso/icon.svg\");background-size:100% 100%}.ti-widget .source-Arukereso .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Arukereso/star/f.svg\")}.ti-widget .source-Arukereso .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Arukereso/star/e.svg\")}.ti-widget .source-Arukereso .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Arukereso/star/h.svg\")}.ti-widget .source-Hotels [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Hotels/icon.svg\");background-size:100% 100%}.ti-widget .source-Hotels .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Hotels/icon.svg\");background-size:100% 100%}.ti-widget .source-Hotels .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Hotels/star/f.svg\")}.ti-widget .source-Hotels .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Hotels/star/e.svg\")}.ti-widget .source-Hotels .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Hotels/star/h.svg\")}.ti-widget .source-Trustindex [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Trustindex/icon.svg\");background-size:100% 100%}.ti-widget .source-Trustindex .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Trustindex/icon.svg\");background-size:100% 100%}.ti-widget .source-Trustindex .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Trustindex/star/f.svg\")}.ti-widget .source-Trustindex .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Trustindex/star/e.svg\")}.ti-widget .source-Trustindex .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Trustindex/star/h.svg\")}.ti-widget .source-Opentable [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Opentable/icon.svg\");background-size:100% 100%}.ti-widget .source-Opentable .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Opentable/icon.svg\");background-size:100% 100%}.ti-widget .source-Opentable .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Opentable/star/f.svg\")}.ti-widget .source-Opentable .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Opentable/star/e.svg\")}.ti-widget .source-Opentable .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Opentable/star/h.svg\")}.ti-widget .source-Foursquare [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Foursquare/icon.svg\");background-size:100% 100%}.ti-widget .source-Foursquare .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Foursquare/icon.svg\");background-size:100% 100%}.ti-widget .source-Foursquare .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Foursquare/star/f.svg\")}.ti-widget .source-Foursquare .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Foursquare/star/e.svg\")}.ti-widget .source-Foursquare .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Foursquare/star/h.svg\")}.ti-widget .source-Foursquare.ti-review-item .ti-star{display:none !important}.ti-widget .source-Bookatable [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Bookatable/icon.svg\");background-size:100% 100%}.ti-widget .source-Bookatable .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Bookatable/icon.svg\");background-size:100% 100%}.ti-widget .source-Bookatable .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Bookatable/star/f.svg\")}.ti-widget .source-Bookatable .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Bookatable/star/e.svg\")}.ti-widget .source-Bookatable .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Bookatable/star/h.svg\")}.ti-widget .source-Capterra [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Capterra/icon.svg\");background-size:100% 100%}.ti-widget .source-Capterra .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Capterra/icon.svg\");background-size:100% 100%}.ti-widget .source-Capterra .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Capterra/star/f.svg\")}.ti-widget .source-Capterra .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Capterra/star/e.svg\")}.ti-widget .source-Capterra .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Capterra/star/h.svg\")}.ti-widget .source-Szallashu[data-domain=cz] [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Szallashu/icon-cz.png\");background-size:100% 100%}.ti-widget .source-Szallashu[data-domain=hu] [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Szallashu/icon-hu.png\");background-size:100% 100%}.ti-widget .source-Szallashu[data-domain=ro] [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Szallashu/icon-ro.png\");background-size:100% 100%}.ti-widget .source-Szallashu[data-domain=com] [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Szallashu/icon-com.png\");background-size:100% 100%}.ti-widget .source-Szallashu[data-domain=pl] [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Szallashu/icon-pl.png\");background-size:100% 100%}.ti-widget .source-Szallashu[data-domain=cz] .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Szallashu/icon-cz.png\");background-size:100% 100%}.ti-widget .source-Szallashu[data-domain=hu] .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Szallashu/icon-hu.png\");background-size:100% 100%}.ti-widget .source-Szallashu[data-domain=ro] .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Szallashu/icon-ro.png\");background-size:100% 100%}.ti-widget .source-Szallashu[data-domain=com] .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Szallashu/icon-com.png\");background-size:100% 100%}.ti-widget .source-Szallashu[data-domain=pl] .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Szallashu/icon-pl.png\");background-size:100% 100%}.ti-widget .source-Szallashu .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Szallashu/star/f.svg\")}.ti-widget .source-Szallashu .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Szallashu/star/e.svg\")}.ti-widget .source-Szallashu .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Szallashu/star/h.svg\")}.ti-widget .source-Thumbtack [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Thumbtack/icon.svg\");background-size:100% 100%}.ti-widget .source-Thumbtack .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Thumbtack/icon.svg\");background-size:100% 100%}.ti-widget .source-Thumbtack .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Thumbtack/star/f.svg\")}.ti-widget .source-Thumbtack .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Thumbtack/star/e.svg\")}.ti-widget .source-Thumbtack .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Thumbtack/star/h.svg\")}.ti-widget .source-Fresha [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Fresha/icon.svg\");background-size:100% 100%}.ti-widget .source-Fresha .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Fresha/icon.svg\");background-size:100% 100%}.ti-widget .source-Fresha .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Fresha/star/f.svg\")}.ti-widget .source-Fresha .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Fresha/star/e.svg\")}.ti-widget .source-Fresha .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Fresha/star/h.svg\")}.ti-widget .source-Expedia [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Expedia/icon.svg\");background-size:100% 100%}.ti-widget .source-Expedia .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Expedia/icon.svg\");background-size:100% 100%}.ti-widget .source-Expedia .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Expedia/star/f.svg\")}.ti-widget .source-Expedia .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Expedia/star/e.svg\")}.ti-widget .source-Expedia .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Expedia/star/h.svg\")}.ti-widget .source-Reco [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Reco/icon.svg\");background-size:100% 100%}.ti-widget .source-Reco .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Reco/icon.svg\");background-size:100% 100%}.ti-widget .source-Reco .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Reco/star/f.svg\")}.ti-widget .source-Reco .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Reco/star/e.svg\")}.ti-widget .source-Reco .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Reco/star/h.svg\")}.ti-widget .source-Zillow [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Zillow/icon.svg\");background-size:100% 100%}.ti-widget .source-Zillow .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Zillow/icon.svg\");background-size:100% 100%}.ti-widget .source-Zillow .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Zillow/star/f.svg\")}.ti-widget .source-Zillow .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Zillow/star/e.svg\")}.ti-widget .source-Zillow .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Zillow/star/h.svg\")}.ti-widget .source-Pricespy [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Pricespy/icon.svg\");background-size:100% 100%}.ti-widget .source-Pricespy .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Pricespy/icon.svg\");background-size:100% 100%}.ti-widget .source-Pricespy .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Pricespy/star/f.svg\")}.ti-widget .source-Pricespy .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Pricespy/star/e.svg\")}.ti-widget .source-Pricespy .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Pricespy/star/h.svg\")}.ti-widget .source-Mobilede [class$=inner]:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Mobilede/icon.svg\");background-size:100% 100%}.ti-widget .source-Mobilede .ti-icon:after{background-image:url(\"https://cdn.trustindex.io/assets/platform/Mobilede/icon.svg\");background-size:100% 100%}.ti-widget .source-Mobilede .ti-star.f{background-image:url(\"https://cdn.trustindex.io/assets/platform/Mobilede/star/f.svg\")}.ti-widget .source-Mobilede .ti-star.e{background-image:url(\"https://cdn.trustindex.io/assets/platform/Mobilede/star/e.svg\")}.ti-widget .source-Mobilede .ti-star.h{background-image:url(\"https://cdn.trustindex.io/assets/platform/Mobilede/star/h.svg\")}.ti-widget .star-lg .ti-star{width:30px;height:30px}.ti-widget .ti-header .ti-star{width:20px;height:20px}.ti-widget .ti-rating-box{background:#000;color:#fff !important;display:inline-flex;align-items:center;font-size:10px !important;font-weight:bold;justify-content:center;vertical-align:baseline;border-radius:4px;height:22px;width:22px;position:relative;top:-4px}.ti-widget .source-Booking .ti-rating-box{background:#003580;border-radius:6px 6px 6px 0}.ti-widget .source-Hotels .ti-rating-box{height:auto !important;width:auto !important;padding:2px 4px;background:#388e3c}.ti-widget .source-Hotels .ti-rating-box:after{content:\'\';border-bottom:4px solid transparent;border-left:6px solid #388e3c;border-top:4px solid transparent;bottom:-4px;left:5px;position:absolute}.ti-widget .source-Foursquare .ti-rating-box{background:#73CF42}.ti-widget .source-Szallashu .ti-rating-box{border-radius:50%;background:#fff;color:#000 !important;border:2px solid #4b8a1a}.ti-widget:not([data-layout-id=\'27\']):not([data-layout-id=\'29\']):not([data-layout-id=\'32\']):not([data-layout-id=\'35\']) .ti-footer .ti-rating-box,.ti-widget:not([data-layout-id=\'27\']):not([data-layout-id=\'29\']):not([data-layout-id=\'32\']):not([data-layout-id=\'35\']) .ti-header .ti-rating-box{font-size:13px !important;height:32px;width:32px}.ti-widget:not([data-layout-id=\'27\']):not([data-layout-id=\'29\']):not([data-layout-id=\'32\']):not([data-layout-id=\'35\']) .ti-footer.source-Hotels .ti-rating-box,.ti-widget:not([data-layout-id=\'27\']):not([data-layout-id=\'29\']):not([data-layout-id=\'32\']):not([data-layout-id=\'35\']) .ti-header.source-Hotels .ti-rating-box{padding:4px 6px}.ti-widget:not([data-layout-id=\'27\']):not([data-layout-id=\'29\']):not([data-layout-id=\'32\']):not([data-layout-id=\'35\']) .ti-footer.source-Hotels .ti-rating-box:after,.ti-widget:not([data-layout-id=\'27\']):not([data-layout-id=\'29\']):not([data-layout-id=\'32\']):not([data-layout-id=\'35\']) .ti-header.source-Hotels .ti-rating-box:after{left:8px}.ti-widget:not([data-layout-id=\'27\']):not([data-layout-id=\'29\']):not([data-layout-id=\'32\']):not([data-layout-id=\'35\']) .ti-footer.source-Foursquare .ti-rating-box,.ti-widget:not([data-layout-id=\'27\']):not([data-layout-id=\'29\']):not([data-layout-id=\'32\']):not([data-layout-id=\'35\']) .ti-header.source-Foursquare .ti-rating-box{top:-2px}.ti-widget:not([data-layout-id=\'27\']):not([data-layout-id=\'29\']):not([data-layout-id=\'32\']):not([data-layout-id=\'35\']) .ti-footer.source-Szallashu .ti-rating-box,.ti-widget:not([data-layout-id=\'27\']):not([data-layout-id=\'29\']):not([data-layout-id=\'32\']):not([data-layout-id=\'35\']) .ti-header.source-Szallashu .ti-rating-box{top:-1px}.ti-widget .ti-mob-row .ti-rating-box{margin-top:1px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-controls{display:none;margin-top:-12px;width:100%;position:absolute;top:50%;height:0px;z-index:1}@media (max-width:479px){.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-controls{display:none !important}}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-controls .ti-next,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-controls .ti-prev{position:absolute;display:inline-block;width:20px;height:30px;padding-top:20px;padding-bottom:20px;display:block;opacity:1;-webkit-transition:all 200ms ease-out;-moz-transition:all 200ms ease-out;-o-transition:all 200ms ease-out;transition:all 200ms ease-out}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-controls .ti-next:hover,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-controls .ti-prev:hover{cursor:pointer;-webkit-transform:scale(1.2);-ms-transform:scale(1.2);transform:scale(1.2)}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-controls .ti-next:before,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-controls .ti-prev:before{content:\'\';background:#cccccc;width:17px;height:3px;display:block;-webkit-transform:rotate(45deg);-ms-transform:rotate(45deg);transform:rotate(45deg);border-radius:2px;position:absolute}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-controls .ti-next:after,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-controls .ti-prev:after{content:\'\';background:#cccccc;width:17px;height:3px;display:block;-webkit-transform:rotate(-45deg);-ms-transform:rotate(-45deg);transform:rotate(-45deg);border-radius:2px;position:absolute}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-controls .ti-next{right:2px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-controls .ti-next:after{top:18px;right:0px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-controls .ti-next:before{top:8px;right:0px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-controls .ti-prev{left:2px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-controls .ti-prev:after{top:8px;left:0px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-controls .ti-prev:before{top:18px;left:0px}.ti-controls-dots{margin-top:10px;margin-bottom:10px;text-align:center}.ti-controls-dots .dot{display:inline-block;width:10px;height:10px;background:#cccccc;border-radius:20px;padding:4px;cursor:pointer;opacity:0.4}.ti-controls-dots .dot.active,.ti-controls-dots .dot:hover{opacity:1}.ti-reviews-container{position:relative}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\']{overflow:visible !important}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item>.ti-inner{border-top-width:0px !important;border-bottom-width:0px !important;border-left-width:0px !important;border-right-width:0px !important;background-color:white !important;backdrop-filter:blur(0px)}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\']{position:fixed;overflow:visible;bottom:0px;margin:0;z-index:2;left:8px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item .ti-recommendation .ti-recommendation-title{font-size:12px !important}@media (min-width:1024px){.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\']{max-width:430px}}@media (min-width:768px) and (max-width:1023px){.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\']{max-width:430px}}@media (min-width:480px) and (max-width:767px){.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\']{max-width:430px}}@media (max-width:479px){.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\']{max-width:100%;left:5px;right:5px;bottom:5px;width:auto}}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-profile-img img{margin-right:10px;width:40px;height:40px}@media (max-width:479px){.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-profile-img img{width:30px;height:30px}}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-widget-container{margin-bottom:0px !important;padding-top:0px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-reviews-container{position:relative;padding:0px 0px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-reviews-container-wrapper{padding-top:0px;align-items:flex-end}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-text{display:-webkit-box;-webkit-box-orient:vertical;line-height:18.85px;font-size:13px;position:relative;z-index:1}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-text strong{font-size:inherit;color:inherit}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item>.inner,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item>.ti-inner{display:-ms-flexbox;display:flex;-ms-flex-wrap:nowrap;flex-wrap:nowrap;position:relative;-webkit-box-align:center !important;-ms-flex-align:center !important;align-items:center !important;padding:10px !important;background-color:#fff !important;box-shadow:2px 2px 10px 0px rgba(0, 0, 0, 0.2), 0px 0px 2px 0px rgba(0, 0, 0, 0.2);margin:10px 0px !important}@media (max-width:479px){.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item>.inner,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item>.ti-inner{margin:8px 8px !important}}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item>.inner .left-col,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item>.ti-inner .left-col{-ms-flex:0 0 auto;flex:0 0 auto;width:auto;max-width:100%}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item>.inner .right-col,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item>.ti-inner .right-col{-ms-flex-preferred-size:0;flex-basis:0;-ms-flex-positive:1;flex-grow:1;max-width:100%}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item>.inner:after,.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item>.ti-inner:after{content:\"\";display:block;width:20px;height:20px;position:absolute;top:8px;right:7px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-profile-details{white-space:normal;margin-top:0px;padding-right:30px}@media (max-width:479px){.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-profile-details{margin-bottom:2px}}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-profile-details .ti-name{display:inline;padding:0px;font-size:12px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-profile-details .ti-date{display:inline;margin:0px;white-space:normal}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-profile-details .ti-date:before{content:\'- \'}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-stars{margin-bottom:4px;margin-top:4px}@media (max-width:479px){.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-stars{margin-bottom:0px;margin-top:0px}}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-header:after{display:none}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .disable-widget{position:absolute;content:\'\';width:18px;height:18px;bottom:12px;bottom:17px;right:10px;border-radius:20px;border-width:0px;transition:all 0.3s ease-in-out;cursor:pointer;opacity:0.5;z-index:1}@media (min-width:480px){.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .disable-widget{display:none}}@media (max-width:479px){.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .disable-widget{right:10px;bottom:10px}}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .disable-widget:after{content:\'\';background:#000000;width:10px;height:2px;display:block;-webkit-transform:rotate(-45deg);-ms-transform:rotate(-45deg);transform:rotate(-45deg);border-radius:2px;position:absolute;left:4px;top:8px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .disable-widget:before{content:\'\';background:#000000;width:10px;height:2px;display:block;-webkit-transform:rotate(45deg);-ms-transform:rotate(45deg);transform:rotate(45deg);border-radius:2px;position:absolute;left:4px;top:8px}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .disable-widget:hover{opacity:1;background-color:rgba(155, 155, 155, 0.2)}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-reviews-container:hover .disable-widget{display:block}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-text{transition:max-height 0.5s ease-out;max-height:37.7px;-webkit-line-clamp:2;overflow:hidden !important}.ti-widget[data-layout-id=\'17\'][data-set-id=\'light-background\'] .ti-review-item:hover .ti-review-text{max-height:150.8px;-webkit-line-clamp:inherit;overflow:auto !important;padding-right:10px}.ti-preview-box { position: initial !important }',	'no'),
(47818,	'trustindex-google-widget-setted-up',	'1',	'no'),
(47819,	'trustindex-google-content-saved-to',	'5.0.1',	'no'),
(47830,	'trustindex-google-review-content',	'<div class=\"ti-widget\" data-layout-id=\"17\" data-set-id=\"\" data-pid=\"b5167179c03e50ec942cb\" data-pager-autoplay-timeout=\"6\" > <div class=\"ti-widget-container ti-col-1\"> <div class=\"ti-reviews-container\"> <div class=\"ti-controls\"> <div class=\"ti-next\"></div> <div class=\"ti-prev\"></div> </div> <div class=\"ti-reviews-container-wrapper\"> <!-- R-LIST --> <div class=\"ti-review-item source-%platform%\" > <div class=\"disable-widget\"></div> <div class=\"ti-inner\"> <div class=\"col-left\"> <div class=\"ti-review-header\"> <div class=\"ti-profile-img\"> <img src=\"%reviewer_photo%\" alt=\"%reviewer_name%\" /> </div> </div> </div> <div class=\"col-right\"> <div class=\"ti-stars\"><span class=\"ti-star f\"></span><span class=\"ti-star f\"></span><span class=\"ti-star f\"></span><span class=\"ti-star f\"></span><span class=\"ti-star f\"></span></div> <div class=\"ti-review-text\"><!-- R-CONTENT -->%text%<!-- R-CONTENT --></div> <div class=\"ti-profile-details\"> <div class=\"ti-name\">%reviewer_name%</div> <div class=\"ti-date\">%created_at%</div> </div> </div> </div> </div> <!-- R-LIST --> </div> </div> </div> </div>',	'no'),
(52544,	'trustindex-google-rate-us',	'hide',	'no'),
(52557,	'gravityformsaddon_gravityformssendgrid_settings',	'a:1:{s:6:\"apiKey\";s:69:\"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\";}',	'yes'),
(63054,	'wfls_last_role_change',	'1668109646',	'no'),
(86436,	'wpseo_sitemap_120466_cache_validator',	'6d18E',	'no'),
(89066,	'wpseo_sitemap_120395_cache_validator',	'7TZl',	'no'),
(147209,	'wpseo_sitemap_120593_cache_validator',	'6yZQh',	'no'),
(149524,	'wpseo_sitemap_120627_cache_validator',	'2Yixj',	'no'),
(149617,	'wpseo_sitemap_120628_cache_validator',	'3u7id',	'no'),
(150143,	'wpseo_sitemap_120653_cache_validator',	'6lt7p',	'no'),
(150420,	'gf_dismissed_upgrades',	'a:1:{i:0;s:6:\"2.5.16\";}',	'yes'),
(150546,	'wpseo_sitemap_120594_cache_validator',	'6wXlv',	'no'),
(153709,	'wpseo_sitemap_119442_cache_validator',	'5YrSX',	'no'),
(169727,	'wpsdth4_license_key',	'\n343811024355442c5f0f3d1b6c101a0a26281f183f05263b5b2316081808391e242405036b4e1f3e33173150040914052e5479285e35\n3378513a1552437316173f482d335c0b191c093917336245312a000c026f58022420064a7e4e572b200f2f4519131119231b34245c',	'yes'),
(169766,	'wp-human-presence',	'a:17:{s:13:\"hp_db_version\";s:6:\"3.4.36\";s:14:\"wp_hp_username\";s:0:\"\";s:11:\"wp_hp_email\";s:0:\"\";s:13:\"wp_hp_api_key\";s:0:\"\";s:17:\"wp_hp_autoprotect\";i:0;s:11:\"wp_hp_debug\";i:0;s:20:\"wp_hp_min_confidence\";i:70;s:21:\"wp_hp_premium_license\";i:0;s:25:\"wp_hp_premium_license_key\";s:0:\"\";s:27:\"wp_hp_premium_license_error\";i:0;s:25:\"wp_hp_premium_license_msg\";s:7:\"invalid\";s:32:\"wp_hp_premium_license_last_check\";i:1698177006;s:8:\"hp_forms\";a:1:{s:4:\"gf-3\";a:3:{s:12:\"form_enabled\";i:1;s:13:\"suspicious_ct\";i:4263;s:24:\"last_suspicious_activity\";s:19:\"2023-10-25 04:49:18\";}}s:18:\"protected_forms_ct\";i:1;s:12:\"last_updated\";i:1654145225;s:23:\"convesio_setup_complete\";i:0;s:18:\"hide_community_nag\";i:1;}',	'yes'),
(169767,	'wp-human-presence-upgrade-3-4-6',	'1',	'yes'),
(181226,	'wpseo_sitemap_120882_cache_validator',	'GbcB',	'no'),
(186521,	'et_safe_mode_plugins_allowlist',	'a:8:{i:0;s:15:\"etdev/etdev.php\";i:1;s:15:\"bloom/bloom.php\";i:2;s:19:\"monarch/monarch.php\";i:3;s:29:\"divi-builder/divi-builder.php\";i:4;s:27:\"ari-adminer/ari-adminer.php\";i:5;s:31:\"query-monitor/query-monitor.php\";i:6;s:27:\"woocommerce/woocommerce.php\";i:7;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";}',	'yes'),
(186524,	'disallowed_keys',	'',	'no'),
(186525,	'comment_previously_approved',	'1',	'yes'),
(186526,	'auto_plugin_theme_update_emails',	'a:0:{}',	'no'),
(186527,	'finished_updating_comment_type',	'1',	'yes'),
(186528,	'db_upgraded',	'',	'yes'),
(186534,	'can_compress_scripts',	'1',	'no'),
(186617,	'_site_transient_et_update_all_plugins',	'O:8:\"stdClass\":3:{s:7:\"checked\";a:15:{s:27:\"ca-drip-msg/ca-drip-msg.php\";s:0:\"\";s:53:\"wp-custom-taxonomy-image/wp-custom-taxonomy-image.php\";s:5:\"1.0.0\";s:33:\"classic-editor/classic-editor.php\";s:3:\"1.6\";s:25:\"ca-members/Membership.php\";s:5:\"3.0.0\";s:28:\"ca-idx---/responsive-idx.php\";s:5:\"3.9.0\";s:18:\"ca-leads/users.php\";s:6:\"1.10.1\";s:19:\"ca-listings/rel.php\";s:5:\"2.4.6\";s:26:\"ca-social/covertsocial.php\";s:0:\"\";s:32:\"duplicate-page/duplicatepage.php\";s:3:\"4.3\";s:34:\"cloudflare-flexible-ssl/plugin.php\";s:5:\"1.3.1\";s:22:\"font-awesome/index.php\";s:10:\"4.0.0-rc20\";s:29:\"gravityforms/gravityforms.php\";s:6:\"2.4.24\";s:56:\"ellipsis-human-presence-technology/wp-human-presence.php\";s:6:\"3.4.36\";s:61:\"wp-reviews-plugin-for-google/wp-reviews-plugin-for-google.php\";s:5:\"5.0.1\";s:23:\"wordfence/wordfence.php\";s:5:\"7.7.1\";}s:8:\"response\";a:0:{}s:12:\"last_checked\";i:1698100462;}',	'no'),
(186757,	'_site_transient_update_themes',	'O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1698220615;s:7:\"checked\";a:2:{s:11:\"CovertAgent\";s:3:\"3.0\";s:4:\"Divi\";s:5:\"4.5.1\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:0:{}s:12:\"translations\";a:0:{}}',	'no'),
(187212,	'_transient_health-check-site-status-result',	'{\"good\":10,\"recommended\":8,\"critical\":2}',	'yes'),
(187569,	'recovery_mode_email_last_sent',	'1683114105',	'yes'),
(203962,	'auto_core_update_failed',	'a:6:{s:9:\"attempted\";s:6:\"5.5.13\";s:7:\"current\";s:5:\"5.5.9\";s:10:\"error_code\";s:23:\"mkdir_failed_ziparchive\";s:10:\"error_data\";N;s:9:\"timestamp\";i:1697227212;s:5:\"retry\";b:0;}',	'no'),
(330459,	'_transient_timeout_et_core_version',	'1698266734',	'no'),
(330460,	'_transient_et_core_version',	'4.5.1',	'no'),
(335468,	'_site_transient_update_core',	'O:8:\"stdClass\":4:{s:7:\"updates\";a:10:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.3.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.3.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.3.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.3.2-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.3.2\";s:7:\"version\";s:5:\"6.3.2\";s:11:\"php_version\";s:5:\"7.0.0\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.3.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.3.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.3.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.3.2-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.3.2\";s:7:\"version\";s:5:\"6.3.2\";s:11:\"php_version\";s:5:\"7.0.0\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:2;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.2.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.2.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.2.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.2.3-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.2.3\";s:7:\"version\";s:5:\"6.2.3\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:3;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.1.4.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.1.4.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.1.4-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.1.4-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.1.4\";s:7:\"version\";s:5:\"6.1.4\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:4;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.0.6.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.0.6.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.0.6-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.0.6-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.0.6\";s:7:\"version\";s:5:\"6.0.6\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:5;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.9.8.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.9.8.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.9.8-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.9.8-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"5.9.8\";s:7:\"version\";s:5:\"5.9.8\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:6;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.8.8.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.8.8.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.8.8-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.8.8-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"5.8.8\";s:7:\"version\";s:5:\"5.8.8\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:7;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.7.10.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.7.10.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.7.10-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-5.7.10-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:6:\"5.7.10\";s:7:\"version\";s:6:\"5.7.10\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:8;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.6.12.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.6.12.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.6.12-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-5.6.12-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:6:\"5.6.12\";s:7:\"version\";s:6:\"5.6.12\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:9;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.5.13.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.5.13.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.5.13-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-5.5.13-new-bundled.zip\";s:7:\"partial\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.5.13-partial-9.zip\";s:8:\"rollback\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.5.13-rollback-9.zip\";}s:7:\"current\";s:6:\"5.5.13\";s:7:\"version\";s:6:\"5.5.13\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:5:\"5.5.9\";s:9:\"new_files\";s:0:\"\";}}s:12:\"last_checked\";i:1698220614;s:15:\"version_checked\";s:5:\"5.5.9\";s:12:\"translations\";a:0:{}}',	'no'),
(337223,	'_site_transient_timeout_browser_cac295178e991253f4aae6f6a861ae46',	'1698269514',	'no'),
(337224,	'_site_transient_browser_cac295178e991253f4aae6f6a861ae46',	'a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:5:\"118.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}',	'no'),
(337225,	'_site_transient_timeout_php_check_e75faed1a826552eb5da936534f0b349',	'1698269514',	'no'),
(337226,	'_site_transient_php_check_e75faed1a826552eb5da936534f0b349',	'a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:3:\"7.0\";s:12:\"is_supported\";b:0;s:9:\"is_secure\";b:0;s:13:\"is_acceptable\";b:0;}',	'no'),
(337258,	'_site_transient_timeout_browser_e3f8101c41b40572973227d0a64620d0',	'1698270969',	'no'),
(337259,	'_site_transient_browser_e3f8101c41b40572973227d0a64620d0',	'a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"118.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}',	'no'),
(338902,	'_site_transient_timeout_browser_15c2f6f9416d00cec8b4f729460293c0',	'1698587288',	'no'),
(338903,	'_site_transient_browser_15c2f6f9416d00cec8b4f729460293c0',	'a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"115.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}',	'no'),
(339386,	'ftp_credentials',	'a:3:{s:8:\"hostname\";s:15:\"graygroupla.com\";s:8:\"username\";s:5:\"chris\";s:15:\"connection_type\";s:4:\"ftps\";}',	'yes'),
(339677,	'_transient_timeout_human_presence_license',	'1698180606',	'no'),
(339678,	'_transient_human_presence_license',	'a:2:{s:7:\"success\";b:0;s:7:\"license\";s:7:\"invalid\";}',	'no'),
(339690,	'_transient_timeout_et_core_path',	'1698266734',	'no'),
(339691,	'_transient_et_core_path',	'/var/www/wordpress/graygroupla/wp-content/themes/Divi/core',	'no'),
(339760,	'_transient_timeout_wflginfl_00000000000000000000ffffc8780b82',	'1698219443',	'no'),
(339761,	'_transient_wflginfl_00000000000000000000ffffc8780b82',	'1',	'no'),
(339785,	'_transient_timeout_wflginfl_00000000000000000000ffff965f5361',	'1698223507',	'no'),
(339786,	'_transient_wflginfl_00000000000000000000ffff965f5361',	'1',	'no'),
(339796,	'_transient_timeout_wflginfl_2a02c207203236810000000000000001',	'1698223804',	'no'),
(339797,	'_transient_wflginfl_2a02c207203236810000000000000001',	'1',	'no'),
(339929,	'_transient_timeout_covert_upgrade_ca-listings',	'1698263814',	'no'),
(339930,	'_transient_covert_upgrade_ca-listings',	'a:6:{s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:4:\"date\";s:29:\"Wed, 25 Oct 2023 07:56:54 GMT\";s:12:\"content-type\";s:16:\"application/json\";s:13:\"last-modified\";s:29:\"Sun, 05 Apr 2020 16:10:17 GMT\";s:4:\"etag\";s:21:\"W/\"445-5a28d62f16e31\"\";s:15:\"cf-cache-status\";s:7:\"DYNAMIC\";s:9:\"report-to\";s:239:\"{\"endpoints\":[{\"url\":\"https:\\/\\/a.nel.cloudflare.com\\/report\\/v3?s=9oAWqR6ShP36swpCxSQKdKh6cSV4EYY52ZTo6k8nUzytJ6IK5oJlKYBNa8q73hFc7pZXWG7E6gFjVCzFAE84hxWF1lYkFmNPTBmOy4GaSaGWV7glnmc7v7eJF28RRkoZpjU%3D\"}],\"group\":\"cf-nel\",\"max_age\":604800}\";s:3:\"nel\";s:60:\"{\"success_fraction\":0,\"report_to\":\"cf-nel\",\"max_age\":604800}\";s:6:\"server\";s:10:\"cloudflare\";s:6:\"cf-ray\";s:20:\"81b8e7da5c4b1586-SJC\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";}}s:4:\"body\";s:1093:\"{\r\n	\"version\" : \"2.4.7\",\r\n	\"download_url\" : \"https://covertagent.com/customers/ca-plugins/ca-listings-v2.4.7.zip\",\r\n	\"requires\" : \"5.3.0\",\r\n	\"tested\" : \"5.4.0\",\r\n	\"requires_php\" : \"5.3\",\r\n	\"last_updated\" : \"2020-04-04 02:10:00\",\r\n	\"slug\" : \"ca-listings\",\r\n	\"plugin\" : \"ca-listings/rel.php\",\r\n	\"sections\" : {\r\n		\"description\" : \"This plugin allows you to add listings (active,sold,lease,pocket ect) Shortcode button added to text editor.\",\r\n		\"installation\" : \"Requires CovertAgent Membership. Upload the plugin, Activate it, that\'s it!\",\r\n		\"changelog\" : \"<h4>2.4.7 - April 5, 2020</h4><ul><li>Added settings to hide specific details.</li><li>Added disclaimer option</li></ul><h4>2.4.6 - March 16, 2020</h4><ul><li>Title location and color.</li><li>Header image background added.</li></ul><h4>2.4.5 - March 10, 2020</h4><ul><li>Added update script to ensure plugin recieves update notifications.</li><li>Forked from 2.4.4</li></ul>\"\r\n	},\r\n	\"banners\" : {\r\n		\"low\" : \"https://covertagent.com/images/plugins-772x250.jpg\",\r\n		\"high\" : \"https://covertagent.com/images/plugins-1544x500.jpg\"\r\n	}\r\n}\r\n\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;s:13:\"http_response\";O:25:\"WP_HTTP_Requests_Response\":5:{s:11:\"\0*\0response\";O:17:\"Requests_Response\":10:{s:4:\"body\";s:1093:\"{\r\n	\"version\" : \"2.4.7\",\r\n	\"download_url\" : \"https://covertagent.com/customers/ca-plugins/ca-listings-v2.4.7.zip\",\r\n	\"requires\" : \"5.3.0\",\r\n	\"tested\" : \"5.4.0\",\r\n	\"requires_php\" : \"5.3\",\r\n	\"last_updated\" : \"2020-04-04 02:10:00\",\r\n	\"slug\" : \"ca-listings\",\r\n	\"plugin\" : \"ca-listings/rel.php\",\r\n	\"sections\" : {\r\n		\"description\" : \"This plugin allows you to add listings (active,sold,lease,pocket ect) Shortcode button added to text editor.\",\r\n		\"installation\" : \"Requires CovertAgent Membership. Upload the plugin, Activate it, that\'s it!\",\r\n		\"changelog\" : \"<h4>2.4.7 - April 5, 2020</h4><ul><li>Added settings to hide specific details.</li><li>Added disclaimer option</li></ul><h4>2.4.6 - March 16, 2020</h4><ul><li>Title location and color.</li><li>Header image background added.</li></ul><h4>2.4.5 - March 10, 2020</h4><ul><li>Added update script to ensure plugin recieves update notifications.</li><li>Forked from 2.4.4</li></ul>\"\r\n	},\r\n	\"banners\" : {\r\n		\"low\" : \"https://covertagent.com/images/plugins-772x250.jpg\",\r\n		\"high\" : \"https://covertagent.com/images/plugins-1544x500.jpg\"\r\n	}\r\n}\r\n\";s:3:\"raw\";s:1752:\"HTTP/1.1 200 OK\r\nDate: Wed, 25 Oct 2023 07:56:54 GMT\r\nContent-Type: application/json\r\nTransfer-Encoding: chunked\r\nConnection: close\r\nLast-Modified: Sun, 05 Apr 2020 16:10:17 GMT\r\nETag: W/\"445-5a28d62f16e31\"\r\nCF-Cache-Status: DYNAMIC\r\nReport-To: {\"endpoints\":[{\"url\":\"https:\\/\\/a.nel.cloudflare.com\\/report\\/v3?s=9oAWqR6ShP36swpCxSQKdKh6cSV4EYY52ZTo6k8nUzytJ6IK5oJlKYBNa8q73hFc7pZXWG7E6gFjVCzFAE84hxWF1lYkFmNPTBmOy4GaSaGWV7glnmc7v7eJF28RRkoZpjU%3D\"}],\"group\":\"cf-nel\",\"max_age\":604800}\r\nNEL: {\"success_fraction\":0,\"report_to\":\"cf-nel\",\"max_age\":604800}\r\nServer: cloudflare\r\nCF-RAY: 81b8e7da5c4b1586-SJC\r\nContent-Encoding: gzip\r\nalt-svc: h3=\":443\"; ma=86400\r\n\r\n{\r\n	\"version\" : \"2.4.7\",\r\n	\"download_url\" : \"https://covertagent.com/customers/ca-plugins/ca-listings-v2.4.7.zip\",\r\n	\"requires\" : \"5.3.0\",\r\n	\"tested\" : \"5.4.0\",\r\n	\"requires_php\" : \"5.3\",\r\n	\"last_updated\" : \"2020-04-04 02:10:00\",\r\n	\"slug\" : \"ca-listings\",\r\n	\"plugin\" : \"ca-listings/rel.php\",\r\n	\"sections\" : {\r\n		\"description\" : \"This plugin allows you to add listings (active,sold,lease,pocket ect) Shortcode button added to text editor.\",\r\n		\"installation\" : \"Requires CovertAgent Membership. Upload the plugin, Activate it, that\'s it!\",\r\n		\"changelog\" : \"<h4>2.4.7 - April 5, 2020</h4><ul><li>Added settings to hide specific details.</li><li>Added disclaimer option</li></ul><h4>2.4.6 - March 16, 2020</h4><ul><li>Title location and color.</li><li>Header image background added.</li></ul><h4>2.4.5 - March 10, 2020</h4><ul><li>Added update script to ensure plugin recieves update notifications.</li><li>Forked from 2.4.4</li></ul>\"\r\n	},\r\n	\"banners\" : {\r\n		\"low\" : \"https://covertagent.com/images/plugins-772x250.jpg\",\r\n		\"high\" : \"https://covertagent.com/images/plugins-1544x500.jpg\"\r\n	}\r\n}\r\n\";s:7:\"headers\";O:25:\"Requests_Response_Headers\":1:{s:7:\"\0*\0data\";a:11:{s:4:\"date\";a:1:{i:0;s:29:\"Wed, 25 Oct 2023 07:56:54 GMT\";}s:12:\"content-type\";a:1:{i:0;s:16:\"application/json\";}s:13:\"last-modified\";a:1:{i:0;s:29:\"Sun, 05 Apr 2020 16:10:17 GMT\";}s:4:\"etag\";a:1:{i:0;s:21:\"W/\"445-5a28d62f16e31\"\";}s:15:\"cf-cache-status\";a:1:{i:0;s:7:\"DYNAMIC\";}s:9:\"report-to\";a:1:{i:0;s:239:\"{\"endpoints\":[{\"url\":\"https:\\/\\/a.nel.cloudflare.com\\/report\\/v3?s=9oAWqR6ShP36swpCxSQKdKh6cSV4EYY52ZTo6k8nUzytJ6IK5oJlKYBNa8q73hFc7pZXWG7E6gFjVCzFAE84hxWF1lYkFmNPTBmOy4GaSaGWV7glnmc7v7eJF28RRkoZpjU%3D\"}],\"group\":\"cf-nel\",\"max_age\":604800}\";}s:3:\"nel\";a:1:{i:0;s:60:\"{\"success_fraction\":0,\"report_to\":\"cf-nel\",\"max_age\":604800}\";}s:6:\"server\";a:1:{i:0;s:10:\"cloudflare\";}s:6:\"cf-ray\";a:1:{i:0;s:20:\"81b8e7da5c4b1586-SJC\";}s:16:\"content-encoding\";a:1:{i:0;s:4:\"gzip\";}s:7:\"alt-svc\";a:1:{i:0;s:19:\"h3=\":443\"; ma=86400\";}}}s:11:\"status_code\";i:200;s:16:\"protocol_version\";d:1.1;s:7:\"success\";b:1;s:9:\"redirects\";i:0;s:3:\"url\";s:61:\"https://covertagent.com/customers/ca-plugins/ca-listings.json\";s:7:\"history\";a:0:{}s:7:\"cookies\";O:19:\"Requests_Cookie_Jar\":1:{s:10:\"\0*\0cookies\";a:0:{}}}s:11:\"\0*\0filename\";N;s:4:\"data\";N;s:7:\"headers\";N;s:6:\"status\";N;}}',	'no'),
(339931,	'_transient_timeout_covert_upgrade_ca-idx',	'1698263814',	'no'),
(339932,	'_transient_covert_upgrade_ca-idx',	'a:6:{s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:4:\"date\";s:29:\"Wed, 25 Oct 2023 07:56:54 GMT\";s:12:\"content-type\";s:16:\"application/json\";s:13:\"last-modified\";s:29:\"Mon, 16 Mar 2020 22:34:45 GMT\";s:4:\"etag\";s:21:\"W/\"401-5a1006d194800\"\";s:15:\"cf-cache-status\";s:7:\"DYNAMIC\";s:9:\"report-to\";s:247:\"{\"endpoints\":[{\"url\":\"https:\\/\\/a.nel.cloudflare.com\\/report\\/v3?s=hTmGZRvyyJGyCVGXiit4vH3okYdTPwaCCrVZXuhRsAOHe1W2hJugNQoYcZwn%2BwEuo1g%2BDsW58WehcwPdblJlcHVXOucbHBO%2FAEQNhMzDzzRGMu2bdrBbuU%2F0t3XdcKt7weA%3D\"}],\"group\":\"cf-nel\",\"max_age\":604800}\";s:3:\"nel\";s:60:\"{\"success_fraction\":0,\"report_to\":\"cf-nel\",\"max_age\":604800}\";s:6:\"server\";s:10:\"cloudflare\";s:6:\"cf-ray\";s:20:\"81b8e7dad8159651-SJC\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";}}s:4:\"body\";s:1025:\"{\r\n	\"version\" : \"3.9.0\",\r\n	\"download_url\" : \"https://covertagent.com/customers/ca-plugins/ca-idx-v3.9.0.zip\",\r\n	\"requires\" : \"5.3.0\",\r\n	\"tested\" : \"5.3.2\",\r\n	\"requires_php\" : \"5.3\",\r\n	\"last_updated\" : \"2020-03-16 02:10:00\",\r\n	\"slug\" : \"ca-idx\",\r\n	\"plugin\" : \"ca-idx/responsive-idx.php\",\r\n	\"sections\" : {\r\n		\"description\" : \"This plugin allows you to place mls listings on any page of your WordPress website by simply dropping in a shortcode.\",\r\n		\"installation\" : \"Requires CovertAgent Membership. Upload the plugin, Activate it, that\'s it!\",\r\n		\"changelog\" : \"<h4>3.9.0 - March 16, 2020</h4><ul><li>Header images for search results & property details</li><li>REmove header/footer from /search for page includes</li></ul><h4>3.8.1 - March 10, 2020</h4><ul><li>Added update script to ensure plugin recieves update notifications.</li><li>Branch from 3.8.0</li></ul>\"\r\n	},\r\n	\"banners\" : {\r\n		\"low\" : \"https://covertagent.com/images/plugins-772x250.jpg\",\r\n		\"high\" : \"https://covertagent.com/images/plugins-1544x500.jpg\"\r\n	}\r\n}\r\n\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;s:13:\"http_response\";O:25:\"WP_HTTP_Requests_Response\":5:{s:11:\"\0*\0response\";O:17:\"Requests_Response\":10:{s:4:\"body\";s:1025:\"{\r\n	\"version\" : \"3.9.0\",\r\n	\"download_url\" : \"https://covertagent.com/customers/ca-plugins/ca-idx-v3.9.0.zip\",\r\n	\"requires\" : \"5.3.0\",\r\n	\"tested\" : \"5.3.2\",\r\n	\"requires_php\" : \"5.3\",\r\n	\"last_updated\" : \"2020-03-16 02:10:00\",\r\n	\"slug\" : \"ca-idx\",\r\n	\"plugin\" : \"ca-idx/responsive-idx.php\",\r\n	\"sections\" : {\r\n		\"description\" : \"This plugin allows you to place mls listings on any page of your WordPress website by simply dropping in a shortcode.\",\r\n		\"installation\" : \"Requires CovertAgent Membership. Upload the plugin, Activate it, that\'s it!\",\r\n		\"changelog\" : \"<h4>3.9.0 - March 16, 2020</h4><ul><li>Header images for search results & property details</li><li>REmove header/footer from /search for page includes</li></ul><h4>3.8.1 - March 10, 2020</h4><ul><li>Added update script to ensure plugin recieves update notifications.</li><li>Branch from 3.8.0</li></ul>\"\r\n	},\r\n	\"banners\" : {\r\n		\"low\" : \"https://covertagent.com/images/plugins-772x250.jpg\",\r\n		\"high\" : \"https://covertagent.com/images/plugins-1544x500.jpg\"\r\n	}\r\n}\r\n\";s:3:\"raw\";s:1692:\"HTTP/1.1 200 OK\r\nDate: Wed, 25 Oct 2023 07:56:54 GMT\r\nContent-Type: application/json\r\nTransfer-Encoding: chunked\r\nConnection: close\r\nLast-Modified: Mon, 16 Mar 2020 22:34:45 GMT\r\nETag: W/\"401-5a1006d194800\"\r\nCF-Cache-Status: DYNAMIC\r\nReport-To: {\"endpoints\":[{\"url\":\"https:\\/\\/a.nel.cloudflare.com\\/report\\/v3?s=hTmGZRvyyJGyCVGXiit4vH3okYdTPwaCCrVZXuhRsAOHe1W2hJugNQoYcZwn%2BwEuo1g%2BDsW58WehcwPdblJlcHVXOucbHBO%2FAEQNhMzDzzRGMu2bdrBbuU%2F0t3XdcKt7weA%3D\"}],\"group\":\"cf-nel\",\"max_age\":604800}\r\nNEL: {\"success_fraction\":0,\"report_to\":\"cf-nel\",\"max_age\":604800}\r\nServer: cloudflare\r\nCF-RAY: 81b8e7dad8159651-SJC\r\nContent-Encoding: gzip\r\nalt-svc: h3=\":443\"; ma=86400\r\n\r\n{\r\n	\"version\" : \"3.9.0\",\r\n	\"download_url\" : \"https://covertagent.com/customers/ca-plugins/ca-idx-v3.9.0.zip\",\r\n	\"requires\" : \"5.3.0\",\r\n	\"tested\" : \"5.3.2\",\r\n	\"requires_php\" : \"5.3\",\r\n	\"last_updated\" : \"2020-03-16 02:10:00\",\r\n	\"slug\" : \"ca-idx\",\r\n	\"plugin\" : \"ca-idx/responsive-idx.php\",\r\n	\"sections\" : {\r\n		\"description\" : \"This plugin allows you to place mls listings on any page of your WordPress website by simply dropping in a shortcode.\",\r\n		\"installation\" : \"Requires CovertAgent Membership. Upload the plugin, Activate it, that\'s it!\",\r\n		\"changelog\" : \"<h4>3.9.0 - March 16, 2020</h4><ul><li>Header images for search results & property details</li><li>REmove header/footer from /search for page includes</li></ul><h4>3.8.1 - March 10, 2020</h4><ul><li>Added update script to ensure plugin recieves update notifications.</li><li>Branch from 3.8.0</li></ul>\"\r\n	},\r\n	\"banners\" : {\r\n		\"low\" : \"https://covertagent.com/images/plugins-772x250.jpg\",\r\n		\"high\" : \"https://covertagent.com/images/plugins-1544x500.jpg\"\r\n	}\r\n}\r\n\";s:7:\"headers\";O:25:\"Requests_Response_Headers\":1:{s:7:\"\0*\0data\";a:11:{s:4:\"date\";a:1:{i:0;s:29:\"Wed, 25 Oct 2023 07:56:54 GMT\";}s:12:\"content-type\";a:1:{i:0;s:16:\"application/json\";}s:13:\"last-modified\";a:1:{i:0;s:29:\"Mon, 16 Mar 2020 22:34:45 GMT\";}s:4:\"etag\";a:1:{i:0;s:21:\"W/\"401-5a1006d194800\"\";}s:15:\"cf-cache-status\";a:1:{i:0;s:7:\"DYNAMIC\";}s:9:\"report-to\";a:1:{i:0;s:247:\"{\"endpoints\":[{\"url\":\"https:\\/\\/a.nel.cloudflare.com\\/report\\/v3?s=hTmGZRvyyJGyCVGXiit4vH3okYdTPwaCCrVZXuhRsAOHe1W2hJugNQoYcZwn%2BwEuo1g%2BDsW58WehcwPdblJlcHVXOucbHBO%2FAEQNhMzDzzRGMu2bdrBbuU%2F0t3XdcKt7weA%3D\"}],\"group\":\"cf-nel\",\"max_age\":604800}\";}s:3:\"nel\";a:1:{i:0;s:60:\"{\"success_fraction\":0,\"report_to\":\"cf-nel\",\"max_age\":604800}\";}s:6:\"server\";a:1:{i:0;s:10:\"cloudflare\";}s:6:\"cf-ray\";a:1:{i:0;s:20:\"81b8e7dad8159651-SJC\";}s:16:\"content-encoding\";a:1:{i:0;s:4:\"gzip\";}s:7:\"alt-svc\";a:1:{i:0;s:19:\"h3=\":443\"; ma=86400\";}}}s:11:\"status_code\";i:200;s:16:\"protocol_version\";d:1.1;s:7:\"success\";b:1;s:9:\"redirects\";i:0;s:3:\"url\";s:56:\"https://covertagent.com/customers/ca-plugins/ca-idx.json\";s:7:\"history\";a:0:{}s:7:\"cookies\";O:19:\"Requests_Cookie_Jar\":1:{s:10:\"\0*\0cookies\";a:0:{}}}s:11:\"\0*\0filename\";N;s:4:\"data\";N;s:7:\"headers\";N;s:6:\"status\";N;}}',	'no'),
(339933,	'_transient_timeout_covert_upgrade_ca-homevalue',	'1698263814',	'no'),
(339934,	'_transient_covert_upgrade_ca-homevalue',	'a:6:{s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:4:\"date\";s:29:\"Wed, 25 Oct 2023 07:56:54 GMT\";s:12:\"content-type\";s:16:\"application/json\";s:13:\"last-modified\";s:29:\"Tue, 17 Mar 2020 17:58:33 GMT\";s:4:\"etag\";s:21:\"W/\"348-5a110af2b06ad\"\";s:15:\"cf-cache-status\";s:7:\"DYNAMIC\";s:9:\"report-to\";s:249:\"{\"endpoints\":[{\"url\":\"https:\\/\\/a.nel.cloudflare.com\\/report\\/v3?s=GWkNZuBjAQzr4HgTQuqsT%2BYg3Ta3ldALXW%2BEpJJEINwG3YGuggnuSUAozoTRnVLT8roCTr%2FYWL34mZh0Da2ewz%2B38e4Op435InhkwzOFlP2zi8pP0s1CqQFOT6boq%2Fsu8bs%3D\"}],\"group\":\"cf-nel\",\"max_age\":604800}\";s:3:\"nel\";s:60:\"{\"success_fraction\":0,\"report_to\":\"cf-nel\",\"max_age\":604800}\";s:6:\"server\";s:10:\"cloudflare\";s:6:\"cf-ray\";s:20:\"81b8e7db3979ceed-SJC\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";}}s:4:\"body\";s:840:\"{\r\n	\"version\" : \"1.3\",\r\n	\"download_url\" : \"https://covertagent.com/customers/ca-plugins/ca-homevalue-v1.3.zip\",\r\n	\"requires\" : \"5.3.0\",\r\n	\"tested\" : \"5.3.2\",\r\n	\"requires_php\" : \"5.3\",\r\n	\"last_updated\" : \"2020-03-17 02:10:00\",\r\n	\"slug\" : \"ca-homevalue\",\r\n	\"plugin\" : \"ca-homevalue/ca-homevalue.php\",\r\n	\"sections\" : {\r\n		\"description\" : \"Real Estate Lead Generation Tool - Home Value Estimate.\",\r\n		\"installation\" : \"Upload the plugin, Activate it, that\'s it!\",\r\n		\"changelog\" : \"<h4>1.3 - March 17, 2020</h4><ul><li>Updated GF form ID</li><li>Required for all installs</li></ul><h4>1.2 - March 10, 2020</h4><ul><li>Added GravityForms Integration</li><li>Forked from 1.2</li></ul>\"\r\n	},\r\n	\"banners\" : {\r\n		\"low\" : \"https://covertagent.com/images/plugins-772x250.jpg\",\r\n		\"high\" : \"https://covertagent.com/images/plugins-1544x500.jpg\"\r\n	}\r\n}\r\n\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;s:13:\"http_response\";O:25:\"WP_HTTP_Requests_Response\":5:{s:11:\"\0*\0response\";O:17:\"Requests_Response\":10:{s:4:\"body\";s:840:\"{\r\n	\"version\" : \"1.3\",\r\n	\"download_url\" : \"https://covertagent.com/customers/ca-plugins/ca-homevalue-v1.3.zip\",\r\n	\"requires\" : \"5.3.0\",\r\n	\"tested\" : \"5.3.2\",\r\n	\"requires_php\" : \"5.3\",\r\n	\"last_updated\" : \"2020-03-17 02:10:00\",\r\n	\"slug\" : \"ca-homevalue\",\r\n	\"plugin\" : \"ca-homevalue/ca-homevalue.php\",\r\n	\"sections\" : {\r\n		\"description\" : \"Real Estate Lead Generation Tool - Home Value Estimate.\",\r\n		\"installation\" : \"Upload the plugin, Activate it, that\'s it!\",\r\n		\"changelog\" : \"<h4>1.3 - March 17, 2020</h4><ul><li>Updated GF form ID</li><li>Required for all installs</li></ul><h4>1.2 - March 10, 2020</h4><ul><li>Added GravityForms Integration</li><li>Forked from 1.2</li></ul>\"\r\n	},\r\n	\"banners\" : {\r\n		\"low\" : \"https://covertagent.com/images/plugins-772x250.jpg\",\r\n		\"high\" : \"https://covertagent.com/images/plugins-1544x500.jpg\"\r\n	}\r\n}\r\n\";s:3:\"raw\";s:1509:\"HTTP/1.1 200 OK\r\nDate: Wed, 25 Oct 2023 07:56:54 GMT\r\nContent-Type: application/json\r\nTransfer-Encoding: chunked\r\nConnection: close\r\nLast-Modified: Tue, 17 Mar 2020 17:58:33 GMT\r\nETag: W/\"348-5a110af2b06ad\"\r\nCF-Cache-Status: DYNAMIC\r\nReport-To: {\"endpoints\":[{\"url\":\"https:\\/\\/a.nel.cloudflare.com\\/report\\/v3?s=GWkNZuBjAQzr4HgTQuqsT%2BYg3Ta3ldALXW%2BEpJJEINwG3YGuggnuSUAozoTRnVLT8roCTr%2FYWL34mZh0Da2ewz%2B38e4Op435InhkwzOFlP2zi8pP0s1CqQFOT6boq%2Fsu8bs%3D\"}],\"group\":\"cf-nel\",\"max_age\":604800}\r\nNEL: {\"success_fraction\":0,\"report_to\":\"cf-nel\",\"max_age\":604800}\r\nServer: cloudflare\r\nCF-RAY: 81b8e7db3979ceed-SJC\r\nContent-Encoding: gzip\r\nalt-svc: h3=\":443\"; ma=86400\r\n\r\n{\r\n	\"version\" : \"1.3\",\r\n	\"download_url\" : \"https://covertagent.com/customers/ca-plugins/ca-homevalue-v1.3.zip\",\r\n	\"requires\" : \"5.3.0\",\r\n	\"tested\" : \"5.3.2\",\r\n	\"requires_php\" : \"5.3\",\r\n	\"last_updated\" : \"2020-03-17 02:10:00\",\r\n	\"slug\" : \"ca-homevalue\",\r\n	\"plugin\" : \"ca-homevalue/ca-homevalue.php\",\r\n	\"sections\" : {\r\n		\"description\" : \"Real Estate Lead Generation Tool - Home Value Estimate.\",\r\n		\"installation\" : \"Upload the plugin, Activate it, that\'s it!\",\r\n		\"changelog\" : \"<h4>1.3 - March 17, 2020</h4><ul><li>Updated GF form ID</li><li>Required for all installs</li></ul><h4>1.2 - March 10, 2020</h4><ul><li>Added GravityForms Integration</li><li>Forked from 1.2</li></ul>\"\r\n	},\r\n	\"banners\" : {\r\n		\"low\" : \"https://covertagent.com/images/plugins-772x250.jpg\",\r\n		\"high\" : \"https://covertagent.com/images/plugins-1544x500.jpg\"\r\n	}\r\n}\r\n\";s:7:\"headers\";O:25:\"Requests_Response_Headers\":1:{s:7:\"\0*\0data\";a:11:{s:4:\"date\";a:1:{i:0;s:29:\"Wed, 25 Oct 2023 07:56:54 GMT\";}s:12:\"content-type\";a:1:{i:0;s:16:\"application/json\";}s:13:\"last-modified\";a:1:{i:0;s:29:\"Tue, 17 Mar 2020 17:58:33 GMT\";}s:4:\"etag\";a:1:{i:0;s:21:\"W/\"348-5a110af2b06ad\"\";}s:15:\"cf-cache-status\";a:1:{i:0;s:7:\"DYNAMIC\";}s:9:\"report-to\";a:1:{i:0;s:249:\"{\"endpoints\":[{\"url\":\"https:\\/\\/a.nel.cloudflare.com\\/report\\/v3?s=GWkNZuBjAQzr4HgTQuqsT%2BYg3Ta3ldALXW%2BEpJJEINwG3YGuggnuSUAozoTRnVLT8roCTr%2FYWL34mZh0Da2ewz%2B38e4Op435InhkwzOFlP2zi8pP0s1CqQFOT6boq%2Fsu8bs%3D\"}],\"group\":\"cf-nel\",\"max_age\":604800}\";}s:3:\"nel\";a:1:{i:0;s:60:\"{\"success_fraction\":0,\"report_to\":\"cf-nel\",\"max_age\":604800}\";}s:6:\"server\";a:1:{i:0;s:10:\"cloudflare\";}s:6:\"cf-ray\";a:1:{i:0;s:20:\"81b8e7db3979ceed-SJC\";}s:16:\"content-encoding\";a:1:{i:0;s:4:\"gzip\";}s:7:\"alt-svc\";a:1:{i:0;s:19:\"h3=\":443\"; ma=86400\";}}}s:11:\"status_code\";i:200;s:16:\"protocol_version\";d:1.1;s:7:\"success\";b:1;s:9:\"redirects\";i:0;s:3:\"url\";s:62:\"https://covertagent.com/customers/ca-plugins/ca-homevalue.json\";s:7:\"history\";a:0:{}s:7:\"cookies\";O:19:\"Requests_Cookie_Jar\":1:{s:10:\"\0*\0cookies\";a:0:{}}}s:11:\"\0*\0filename\";N;s:4:\"data\";N;s:7:\"headers\";N;s:6:\"status\";N;}}',	'no'),
(339935,	'_transient_timeout_covert_upgrade_ca-members',	'1698263815',	'no'),
(339936,	'_transient_covert_upgrade_ca-members',	'a:6:{s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:4:\"date\";s:29:\"Wed, 25 Oct 2023 07:56:54 GMT\";s:12:\"content-type\";s:16:\"application/json\";s:13:\"last-modified\";s:29:\"Sun, 15 Mar 2020 20:42:25 GMT\";s:4:\"etag\";s:21:\"W/\"312-5a0eabd7781ff\"\";s:15:\"cf-cache-status\";s:7:\"DYNAMIC\";s:9:\"report-to\";s:243:\"{\"endpoints\":[{\"url\":\"https:\\/\\/a.nel.cloudflare.com\\/report\\/v3?s=Dxz96Rh8qE9G9tUg%2FPL%2BadBxY35KyQpugGKcM5flT2idxzrgSc2gY6SZGGHcZNxMN9tkO400VZA4L4jlpgP9um5OY0CF0GsdFxCWA8cLLdvC3IoJOrfWcye1d4GB5C7bkiU%3D\"}],\"group\":\"cf-nel\",\"max_age\":604800}\";s:3:\"nel\";s:60:\"{\"success_fraction\":0,\"report_to\":\"cf-nel\",\"max_age\":604800}\";s:6:\"server\";s:10:\"cloudflare\";s:6:\"cf-ray\";s:20:\"81b8e7dba9c5cfbc-SJC\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";}}s:4:\"body\";s:786:\"{\r\n	\"version\" : \"3.0.0\",\r\n	\"download_url\" : \"https://covertagent.com/customers/ca-plugins/ca-members-v3.0.0.zip\",\r\n	\"requires\" : \"5.3.0\",\r\n	\"tested\" : \"5.3.2\",\r\n	\"requires_php\" : \"5.3\",\r\n	\"last_updated\" : \"2020-03-10 02:10:00\",\r\n	\"slug\" : \"ca-members\",\r\n	\"plugin\" : \"ca-members/Membership.php\",\r\n	\"sections\" : {\r\n		\"description\" : \"Core functionality required by all other plugins..\",\r\n		\"installation\" : \"Upload the plugin to your blog, Activate it, that\'s it!\",\r\n		\"changelog\" : \"<h4>3.0.0 - March 10, 2020</h4><ul><li>Added update script to ensure plugin recieves update notifications.</li><li>Forked from 2.9.9</li></ul>\"\r\n	},\r\n	\"banners\" : {\r\n		\"low\" : \"https://covertagent.com/images/plugins-772x250.jpg\",\r\n		\"high\" : \"https://covertagent.com/images/plugins-1544x500.jpg\"\r\n	}\r\n}\r\n\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;s:13:\"http_response\";O:25:\"WP_HTTP_Requests_Response\":5:{s:11:\"\0*\0response\";O:17:\"Requests_Response\":10:{s:4:\"body\";s:786:\"{\r\n	\"version\" : \"3.0.0\",\r\n	\"download_url\" : \"https://covertagent.com/customers/ca-plugins/ca-members-v3.0.0.zip\",\r\n	\"requires\" : \"5.3.0\",\r\n	\"tested\" : \"5.3.2\",\r\n	\"requires_php\" : \"5.3\",\r\n	\"last_updated\" : \"2020-03-10 02:10:00\",\r\n	\"slug\" : \"ca-members\",\r\n	\"plugin\" : \"ca-members/Membership.php\",\r\n	\"sections\" : {\r\n		\"description\" : \"Core functionality required by all other plugins..\",\r\n		\"installation\" : \"Upload the plugin to your blog, Activate it, that\'s it!\",\r\n		\"changelog\" : \"<h4>3.0.0 - March 10, 2020</h4><ul><li>Added update script to ensure plugin recieves update notifications.</li><li>Forked from 2.9.9</li></ul>\"\r\n	},\r\n	\"banners\" : {\r\n		\"low\" : \"https://covertagent.com/images/plugins-772x250.jpg\",\r\n		\"high\" : \"https://covertagent.com/images/plugins-1544x500.jpg\"\r\n	}\r\n}\r\n\";s:3:\"raw\";s:1449:\"HTTP/1.1 200 OK\r\nDate: Wed, 25 Oct 2023 07:56:54 GMT\r\nContent-Type: application/json\r\nTransfer-Encoding: chunked\r\nConnection: close\r\nLast-Modified: Sun, 15 Mar 2020 20:42:25 GMT\r\nETag: W/\"312-5a0eabd7781ff\"\r\nCF-Cache-Status: DYNAMIC\r\nReport-To: {\"endpoints\":[{\"url\":\"https:\\/\\/a.nel.cloudflare.com\\/report\\/v3?s=Dxz96Rh8qE9G9tUg%2FPL%2BadBxY35KyQpugGKcM5flT2idxzrgSc2gY6SZGGHcZNxMN9tkO400VZA4L4jlpgP9um5OY0CF0GsdFxCWA8cLLdvC3IoJOrfWcye1d4GB5C7bkiU%3D\"}],\"group\":\"cf-nel\",\"max_age\":604800}\r\nNEL: {\"success_fraction\":0,\"report_to\":\"cf-nel\",\"max_age\":604800}\r\nServer: cloudflare\r\nCF-RAY: 81b8e7dba9c5cfbc-SJC\r\nContent-Encoding: gzip\r\nalt-svc: h3=\":443\"; ma=86400\r\n\r\n{\r\n	\"version\" : \"3.0.0\",\r\n	\"download_url\" : \"https://covertagent.com/customers/ca-plugins/ca-members-v3.0.0.zip\",\r\n	\"requires\" : \"5.3.0\",\r\n	\"tested\" : \"5.3.2\",\r\n	\"requires_php\" : \"5.3\",\r\n	\"last_updated\" : \"2020-03-10 02:10:00\",\r\n	\"slug\" : \"ca-members\",\r\n	\"plugin\" : \"ca-members/Membership.php\",\r\n	\"sections\" : {\r\n		\"description\" : \"Core functionality required by all other plugins..\",\r\n		\"installation\" : \"Upload the plugin to your blog, Activate it, that\'s it!\",\r\n		\"changelog\" : \"<h4>3.0.0 - March 10, 2020</h4><ul><li>Added update script to ensure plugin recieves update notifications.</li><li>Forked from 2.9.9</li></ul>\"\r\n	},\r\n	\"banners\" : {\r\n		\"low\" : \"https://covertagent.com/images/plugins-772x250.jpg\",\r\n		\"high\" : \"https://covertagent.com/images/plugins-1544x500.jpg\"\r\n	}\r\n}\r\n\";s:7:\"headers\";O:25:\"Requests_Response_Headers\":1:{s:7:\"\0*\0data\";a:11:{s:4:\"date\";a:1:{i:0;s:29:\"Wed, 25 Oct 2023 07:56:54 GMT\";}s:12:\"content-type\";a:1:{i:0;s:16:\"application/json\";}s:13:\"last-modified\";a:1:{i:0;s:29:\"Sun, 15 Mar 2020 20:42:25 GMT\";}s:4:\"etag\";a:1:{i:0;s:21:\"W/\"312-5a0eabd7781ff\"\";}s:15:\"cf-cache-status\";a:1:{i:0;s:7:\"DYNAMIC\";}s:9:\"report-to\";a:1:{i:0;s:243:\"{\"endpoints\":[{\"url\":\"https:\\/\\/a.nel.cloudflare.com\\/report\\/v3?s=Dxz96Rh8qE9G9tUg%2FPL%2BadBxY35KyQpugGKcM5flT2idxzrgSc2gY6SZGGHcZNxMN9tkO400VZA4L4jlpgP9um5OY0CF0GsdFxCWA8cLLdvC3IoJOrfWcye1d4GB5C7bkiU%3D\"}],\"group\":\"cf-nel\",\"max_age\":604800}\";}s:3:\"nel\";a:1:{i:0;s:60:\"{\"success_fraction\":0,\"report_to\":\"cf-nel\",\"max_age\":604800}\";}s:6:\"server\";a:1:{i:0;s:10:\"cloudflare\";}s:6:\"cf-ray\";a:1:{i:0;s:20:\"81b8e7dba9c5cfbc-SJC\";}s:16:\"content-encoding\";a:1:{i:0;s:4:\"gzip\";}s:7:\"alt-svc\";a:1:{i:0;s:19:\"h3=\":443\"; ma=86400\";}}}s:11:\"status_code\";i:200;s:16:\"protocol_version\";d:1.1;s:7:\"success\";b:1;s:9:\"redirects\";i:0;s:3:\"url\";s:60:\"https://covertagent.com/customers/ca-plugins/ca-members.json\";s:7:\"history\";a:0:{}s:7:\"cookies\";O:19:\"Requests_Cookie_Jar\":1:{s:10:\"\0*\0cookies\";a:0:{}}}s:11:\"\0*\0filename\";N;s:4:\"data\";N;s:7:\"headers\";N;s:6:\"status\";N;}}',	'no'),
(339937,	'_site_transient_timeout_theme_roots',	'1698222415',	'no'),
(339938,	'_site_transient_theme_roots',	'a:2:{s:11:\"CovertAgent\";s:7:\"/themes\";s:4:\"Divi\";s:7:\"/themes\";}',	'no'),
(339939,	'_site_transient_update_plugins',	'O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1698220616;s:7:\"checked\";a:15:{s:27:\"ca-drip-msg/ca-drip-msg.php\";s:0:\"\";s:53:\"wp-custom-taxonomy-image/wp-custom-taxonomy-image.php\";s:5:\"1.0.0\";s:33:\"classic-editor/classic-editor.php\";s:3:\"1.6\";s:25:\"ca-members/Membership.php\";s:5:\"3.0.0\";s:28:\"ca-idx---/responsive-idx.php\";s:5:\"3.9.0\";s:18:\"ca-leads/users.php\";s:6:\"1.10.1\";s:19:\"ca-listings/rel.php\";s:5:\"2.4.6\";s:26:\"ca-social/covertsocial.php\";s:0:\"\";s:32:\"duplicate-page/duplicatepage.php\";s:3:\"4.3\";s:34:\"cloudflare-flexible-ssl/plugin.php\";s:5:\"1.3.1\";s:22:\"font-awesome/index.php\";s:10:\"4.0.0-rc20\";s:29:\"gravityforms/gravityforms.php\";s:6:\"2.4.24\";s:56:\"ellipsis-human-presence-technology/wp-human-presence.php\";s:6:\"3.4.36\";s:61:\"wp-reviews-plugin-for-google/wp-reviews-plugin-for-google.php\";s:5:\"5.0.1\";s:23:\"wordfence/wordfence.php\";s:5:\"7.7.1\";}s:8:\"response\";a:6:{s:33:\"classic-editor/classic-editor.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:28:\"w.org/plugins/classic-editor\";s:4:\"slug\";s:14:\"classic-editor\";s:6:\"plugin\";s:33:\"classic-editor/classic-editor.php\";s:11:\"new_version\";s:5:\"1.6.3\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/classic-editor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/classic-editor.1.6.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-256x256.png?rev=1998671\";s:2:\"1x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-128x128.png?rev=1998671\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/classic-editor/assets/banner-1544x500.png?rev=1998671\";s:2:\"1x\";s:69:\"https://ps.w.org/classic-editor/assets/banner-772x250.png?rev=1998676\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";s:6:\"tested\";s:5:\"6.3.2\";s:12:\"requires_php\";s:5:\"5.2.4\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:32:\"duplicate-page/duplicatepage.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:28:\"w.org/plugins/duplicate-page\";s:4:\"slug\";s:14:\"duplicate-page\";s:6:\"plugin\";s:32:\"duplicate-page/duplicatepage.php\";s:11:\"new_version\";s:5:\"4.5.3\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/duplicate-page/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/duplicate-page.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:67:\"https://ps.w.org/duplicate-page/assets/icon-128x128.jpg?rev=1412874\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:69:\"https://ps.w.org/duplicate-page/assets/banner-772x250.jpg?rev=1410328\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.4\";s:6:\"tested\";s:5:\"6.3.2\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:22:\"font-awesome/index.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:26:\"w.org/plugins/font-awesome\";s:4:\"slug\";s:12:\"font-awesome\";s:6:\"plugin\";s:22:\"font-awesome/index.php\";s:11:\"new_version\";s:5:\"4.4.0\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/font-awesome/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/font-awesome.4.4.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/font-awesome/assets/icon-256x256.png?rev=1991998\";s:2:\"1x\";s:65:\"https://ps.w.org/font-awesome/assets/icon-128x128.png?rev=1991998\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/font-awesome/assets/banner-1544x500.png?rev=1991998\";s:2:\"1x\";s:67:\"https://ps.w.org/font-awesome/assets/banner-772x250.png?rev=1991993\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.7\";s:6:\"tested\";s:5:\"6.3.2\";s:12:\"requires_php\";s:3:\"5.6\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:56:\"ellipsis-human-presence-technology/wp-human-presence.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:48:\"w.org/plugins/ellipsis-human-presence-technology\";s:4:\"slug\";s:34:\"ellipsis-human-presence-technology\";s:6:\"plugin\";s:56:\"ellipsis-human-presence-technology/wp-human-presence.php\";s:11:\"new_version\";s:6:\"3.4.43\";s:3:\"url\";s:65:\"https://wordpress.org/plugins/ellipsis-human-presence-technology/\";s:7:\"package\";s:84:\"https://downloads.wordpress.org/plugin/ellipsis-human-presence-technology.3.4.43.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:87:\"https://ps.w.org/ellipsis-human-presence-technology/assets/icon-256x256.png?rev=1853753\";s:2:\"1x\";s:87:\"https://ps.w.org/ellipsis-human-presence-technology/assets/icon-128x128.png?rev=1853753\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:90:\"https://ps.w.org/ellipsis-human-presence-technology/assets/banner-1544x500.jpg?rev=2613320\";s:2:\"1x\";s:89:\"https://ps.w.org/ellipsis-human-presence-technology/assets/banner-772x250.jpg?rev=2613320\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.0\";s:6:\"tested\";s:5:\"6.1.4\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:61:\"wp-reviews-plugin-for-google/wp-reviews-plugin-for-google.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:42:\"w.org/plugins/wp-reviews-plugin-for-google\";s:4:\"slug\";s:28:\"wp-reviews-plugin-for-google\";s:6:\"plugin\";s:61:\"wp-reviews-plugin-for-google/wp-reviews-plugin-for-google.php\";s:11:\"new_version\";s:6:\"10.9.1\";s:3:\"url\";s:59:\"https://wordpress.org/plugins/wp-reviews-plugin-for-google/\";s:7:\"package\";s:78:\"https://downloads.wordpress.org/plugin/wp-reviews-plugin-for-google.10.9.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:81:\"https://ps.w.org/wp-reviews-plugin-for-google/assets/icon-256x256.png?rev=2721569\";s:2:\"1x\";s:81:\"https://ps.w.org/wp-reviews-plugin-for-google/assets/icon-128x128.png?rev=2721569\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:84:\"https://ps.w.org/wp-reviews-plugin-for-google/assets/banner-1544x500.jpg?rev=2473551\";s:2:\"1x\";s:83:\"https://ps.w.org/wp-reviews-plugin-for-google/assets/banner-772x250.jpg?rev=2476764\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"3.0.1\";s:6:\"tested\";s:5:\"6.3.2\";s:12:\"requires_php\";s:3:\"5.2\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:23:\"wordfence/wordfence.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:23:\"w.org/plugins/wordfence\";s:4:\"slug\";s:9:\"wordfence\";s:6:\"plugin\";s:23:\"wordfence/wordfence.php\";s:11:\"new_version\";s:6:\"7.10.5\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wordfence/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/wordfence.7.10.5.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:54:\"https://ps.w.org/wordfence/assets/icon.svg?rev=2070865\";s:3:\"svg\";s:54:\"https://ps.w.org/wordfence/assets/icon.svg?rev=2070865\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/wordfence/assets/banner-1544x500.jpg?rev=2124102\";s:2:\"1x\";s:64:\"https://ps.w.org/wordfence/assets/banner-772x250.jpg?rev=2124102\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.9\";s:6:\"tested\";s:5:\"6.3.2\";s:12:\"requires_php\";s:3:\"5.5\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:2:{s:53:\"wp-custom-taxonomy-image/wp-custom-taxonomy-image.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"w.org/plugins/wp-custom-taxonomy-image\";s:4:\"slug\";s:24:\"wp-custom-taxonomy-image\";s:6:\"plugin\";s:53:\"wp-custom-taxonomy-image/wp-custom-taxonomy-image.php\";s:11:\"new_version\";s:5:\"1.0.0\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/wp-custom-taxonomy-image/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/wp-custom-taxonomy-image.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:77:\"https://ps.w.org/wp-custom-taxonomy-image/assets/icon-128x128.png?rev=1233793\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:79:\"https://ps.w.org/wp-custom-taxonomy-image/assets/banner-772x250.png?rev=1228036\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"3.5.0\";}s:34:\"cloudflare-flexible-ssl/plugin.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:37:\"w.org/plugins/cloudflare-flexible-ssl\";s:4:\"slug\";s:23:\"cloudflare-flexible-ssl\";s:6:\"plugin\";s:34:\"cloudflare-flexible-ssl/plugin.php\";s:11:\"new_version\";s:5:\"1.3.1\";s:3:\"url\";s:54:\"https://wordpress.org/plugins/cloudflare-flexible-ssl/\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/plugin/cloudflare-flexible-ssl.1.3.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:76:\"https://ps.w.org/cloudflare-flexible-ssl/assets/icon-256x256.png?rev=2021081\";s:2:\"1x\";s:76:\"https://ps.w.org/cloudflare-flexible-ssl/assets/icon-128x128.jpg?rev=2021081\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:79:\"https://ps.w.org/cloudflare-flexible-ssl/assets/banner-1544x500.png?rev=2362309\";s:2:\"1x\";s:78:\"https://ps.w.org/cloudflare-flexible-ssl/assets/banner-772x250.png?rev=2362309\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"3.2.0\";}}}',	'no'),
(339979,	'_transient_timeout_wflginfl_00000000000000000000ffff22428def',	'1698243686',	'no'),
(339980,	'_transient_wflginfl_00000000000000000000ffff22428def',	'1',	'no'),
(339982,	'_transient_timeout_wflginfl_00000000000000000000ffff6f76b961',	'1698243765',	'no'),
(339983,	'_transient_wflginfl_00000000000000000000ffff6f76b961',	'1',	'no');

DROP TABLE IF EXISTS `wp_postmeta`;
CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_postmeta` (`meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES
(2,	3,	'_wp_page_template',	'default'),
(3,	7,	'_edit_lock',	'1663726388:2'),
(4,	7,	'_et_pb_use_builder',	'on'),
(5,	7,	'_et_gb_content_width',	''),
(6,	7,	'_edit_last',	'1'),
(7,	7,	'_et_pb_post_hide_nav',	'default'),
(8,	7,	'_et_pb_page_layout',	'et_right_sidebar'),
(9,	7,	'_et_pb_side_nav',	'off'),
(10,	7,	'_wp_page_template',	'default'),
(11,	7,	'_et_pb_built_for_post_type',	'page'),
(12,	7,	'_et_pb_ab_subjects',	''),
(13,	7,	'_et_pb_enable_shortcode_tracking',	''),
(14,	7,	'_et_pb_ab_current_shortcode',	'[et_pb_split_track id=\"7\" /]'),
(15,	7,	'_et_pb_custom_css',	'.et_pb_slide_description {\ntext-shadow:none !important;\n}\n#et-main-area {\n    margin-top: 0px!important;\n}'),
(16,	7,	'_et_pb_gutter_width',	'3'),
(18,	7,	'_et_pb_first_image',	''),
(19,	7,	'_et_pb_truncate_post',	''),
(20,	7,	'_et_pb_truncate_post_date',	''),
(21,	7,	'_et_builder_version',	'VB|Divi|4.5.1'),
(22,	7,	'_et_pb_show_page_creation',	'off'),
(23,	7,	'et_enqueued_post_fonts',	'a:2:{s:6:\"family\";a:4:{s:16:\"et-gf-montserrat\";s:137:\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\";s:10:\"et-gf-lato\";s:75:\"Lato:100,100italic,300,300italic,regular,italic,700,700italic,900,900italic\";s:19:\"et-gf-abril-fatface\";s:21:\"Abril+Fatface:regular\";s:15:\"et-gf-open-sans\";s:80:\"Open+Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic\";}s:6:\"subset\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}}'),
(24,	15,	'_wp_attached_file',	'2020/01/beverly-hills-gg.jpg'),
(25,	15,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:900;s:6:\"height\";i:600;s:4:\"file\";s:28:\"2020/01/beverly-hills-gg.jpg\";s:5:\"sizes\";a:8:{s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"beverly-hills-gg-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"beverly-hills-gg-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:28:\"beverly-hills-gg-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:28:\"beverly-hills-gg-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:28:\"beverly-hills-gg-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:28:\"beverly-hills-gg-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:28:\"beverly-hills-gg-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:28:\"beverly-hills-gg-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(26,	16,	'_wp_attached_file',	'2020/01/santa-monica-gg.jpg'),
(27,	16,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:900;s:6:\"height\";i:600;s:4:\"file\";s:27:\"2020/01/santa-monica-gg.jpg\";s:5:\"sizes\";a:8:{s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"santa-monica-gg-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"santa-monica-gg-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:27:\"santa-monica-gg-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:27:\"santa-monica-gg-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:27:\"santa-monica-gg-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:27:\"santa-monica-gg-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:27:\"santa-monica-gg-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:27:\"santa-monica-gg-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(28,	17,	'_wp_attached_file',	'2020/01/los-angeles-gg.jpg'),
(29,	17,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:518;s:4:\"file\";s:26:\"2020/01/los-angeles-gg.jpg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"los-angeles-gg-300x144.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:144;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"los-angeles-gg-1024x491.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:491;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"los-angeles-gg-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"los-angeles-gg-768x368.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:368;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:26:\"los-angeles-gg-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:26:\"los-angeles-gg-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:26:\"los-angeles-gg-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:26:\"los-angeles-gg-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:26:\"los-angeles-gg-980x470.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:26:\"los-angeles-gg-480x230.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(30,	18,	'_wp_attached_file',	'2020/01/hollywood-hills-gg.jpg'),
(31,	18,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:400;s:6:\"height\";i:600;s:4:\"file\";s:30:\"2020/01/hollywood-hills-gg.jpg\";s:5:\"sizes\";a:6:{s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"hollywood-hills-gg-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"hollywood-hills-gg-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:30:\"hollywood-hills-gg-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:30:\"hollywood-hills-gg-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:30:\"hollywood-hills-gg-400x382.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:30:\"hollywood-hills-gg-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(32,	19,	'_wp_attached_file',	'2020/01/la-home8.jpg'),
(33,	19,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:1708;s:6:\"height\";i:1056;s:4:\"file\";s:20:\"2020/01/la-home8.jpg\";s:5:\"sizes\";a:14:{s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"la-home8-300x185.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"la-home8-1024x633.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:633;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"la-home8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"la-home8-768x475.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:475;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:21:\"la-home8-1536x950.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:950;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:20:\"la-home8-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:21:\"la-home8-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:20:\"la-home8-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:20:\"la-home8-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:21:\"la-home8-1080x668.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:668;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:20:\"la-home8-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:21:\"la-home8-1280x791.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:791;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:20:\"la-home8-980x606.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:606;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:20:\"la-home8-480x297.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(34,	20,	'_wp_attached_file',	'2020/01/BH_office.jpg'),
(35,	20,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:1366;s:4:\"file\";s:21:\"2020/01/BH_office.jpg\";s:5:\"sizes\";a:14:{s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"BH_office-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"BH_office-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"BH_office-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"BH_office-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:23:\"BH_office-1536x1025.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1025;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:21:\"BH_office-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:22:\"BH_office-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:21:\"BH_office-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:21:\"BH_office-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:22:\"BH_office-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:21:\"BH_office-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:22:\"BH_office-1280x854.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:854;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:21:\"BH_office-980x654.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:654;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:21:\"BH_office-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(36,	21,	'_wp_attached_file',	'2020/01/Sherman-Oaks_office.jpg'),
(37,	21,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:1032;s:6:\"height\";i:688;s:4:\"file\";s:31:\"2020/01/Sherman-Oaks_office.jpg\";s:5:\"sizes\";a:11:{s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"Sherman-Oaks_office-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:32:\"Sherman-Oaks_office-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"Sherman-Oaks_office-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:31:\"Sherman-Oaks_office-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:31:\"Sherman-Oaks_office-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:32:\"Sherman-Oaks_office-1032x675.jpg\";s:5:\"width\";i:1032;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:31:\"Sherman-Oaks_office-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:31:\"Sherman-Oaks_office-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:31:\"Sherman-Oaks_office-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:31:\"Sherman-Oaks_office-980x653.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:653;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:31:\"Sherman-Oaks_office-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:9:\"DYS PHOTO\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(38,	22,	'_wp_attached_file',	'2020/01/screenshot-graygroupla.com-2020.01.30-18_21_15.png'),
(39,	22,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:242;s:6:\"height\";i:47;s:4:\"file\";s:58:\"2020/01/screenshot-graygroupla.com-2020.01.30-18_21_15.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:57:\"screenshot-graygroupla.com-2020.01.30-18_21_15-150x47.png\";s:5:\"width\";i:150;s:6:\"height\";i:47;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(42,	26,	'_et_pb_use_builder',	'on'),
(43,	26,	'_et_pb_show_page_creation',	'off'),
(44,	28,	'_et_autogenerated_title',	'0'),
(45,	28,	'_et_default',	'1'),
(46,	28,	'_et_enabled',	'1'),
(47,	28,	'_et_header_layout_id',	'26'),
(48,	28,	'_et_header_layout_enabled',	'1'),
(49,	28,	'_et_body_layout_id',	'0'),
(50,	28,	'_et_body_layout_enabled',	'1'),
(51,	28,	'_et_footer_layout_id',	'76'),
(52,	28,	'_et_footer_layout_enabled',	'1'),
(55,	45,	'_wp_attached_file',	'2020/01/BeverlyCo-logo-white.png'),
(56,	45,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:350;s:6:\"height\";i:73;s:4:\"file\";s:32:\"2020/01/BeverlyCo-logo-white.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"BeverlyCo-logo-white-300x63.png\";s:5:\"width\";i:300;s:6:\"height\";i:63;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"BeverlyCo-logo-white-150x73.png\";s:5:\"width\";i:150;s:6:\"height\";i:73;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(57,	47,	'_wp_attached_file',	'2020/01/graygrp-all.png'),
(58,	47,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:475;s:6:\"height\";i:80;s:4:\"file\";s:23:\"2020/01/graygrp-all.png\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"graygrp-all-300x51.png\";s:5:\"width\";i:300;s:6:\"height\";i:51;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"graygrp-all-150x80.png\";s:5:\"width\";i:150;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:22:\"graygrp-all-400x80.png\";s:5:\"width\";i:400;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:22:\"graygrp-all-400x80.png\";s:5:\"width\";i:400;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:22:\"graygrp-all-400x80.png\";s:5:\"width\";i:400;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(59,	26,	'_et_pb_built_for_post_type',	'page'),
(60,	26,	'_et_pb_ab_subjects',	''),
(61,	26,	'_et_pb_enable_shortcode_tracking',	''),
(62,	26,	'_et_pb_ab_current_shortcode',	'[et_pb_split_track id=\"26\" /]'),
(63,	26,	'_et_pb_custom_css',	''),
(64,	26,	'_et_pb_gutter_width',	'3'),
(65,	26,	'_thumbnail_id',	''),
(66,	26,	'_et_pb_first_image',	''),
(67,	26,	'_et_pb_truncate_post',	''),
(68,	26,	'_et_pb_truncate_post_date',	''),
(69,	26,	'_et_builder_version',	'VB|Divi|4.4.7'),
(71,	76,	'_et_pb_use_builder',	'on'),
(72,	76,	'_et_pb_show_page_creation',	'off'),
(83,	80,	'_wp_attached_file',	'2020/01/eh-re.png'),
(84,	80,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:300;s:6:\"height\";i:96;s:4:\"file\";s:17:\"2020/01/eh-re.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"eh-re-150x96.png\";s:5:\"width\";i:150;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(85,	76,	'_et_pb_built_for_post_type',	'page'),
(86,	76,	'_et_pb_ab_subjects',	''),
(87,	76,	'_et_pb_enable_shortcode_tracking',	''),
(88,	76,	'_et_pb_ab_current_shortcode',	'[et_pb_split_track id=\"76\" /]'),
(89,	76,	'_et_pb_custom_css',	''),
(90,	76,	'_et_pb_gutter_width',	'3'),
(91,	76,	'_thumbnail_id',	''),
(92,	76,	'_et_pb_first_image',	''),
(93,	76,	'_et_pb_truncate_post',	''),
(94,	76,	'_et_pb_truncate_post_date',	''),
(95,	76,	'_et_builder_version',	'VB|Divi|4.4.7'),
(103,	7,	'_et_pb_old_content',	''),
(105,	122,	'_et_pb_built_for_post_type',	'page'),
(106,	123,	'_et_pb_built_for_post_type',	'page'),
(107,	124,	'_et_pb_built_for_post_type',	'page'),
(108,	125,	'_et_pb_built_for_post_type',	'page'),
(109,	126,	'_et_pb_built_for_post_type',	'page'),
(113,	128,	'_edit_lock',	'1590520378:1'),
(114,	128,	'_et_pb_use_builder',	'on'),
(115,	128,	'_et_gb_content_width',	''),
(116,	128,	'_edit_last',	'1'),
(117,	128,	'_et_pb_post_hide_nav',	'default'),
(118,	128,	'_et_pb_page_layout',	'et_right_sidebar'),
(119,	128,	'_et_pb_side_nav',	'off'),
(120,	128,	'_wp_page_template',	'default'),
(121,	128,	'_et_pb_built_for_post_type',	'page'),
(122,	128,	'_et_pb_ab_subjects',	''),
(123,	128,	'_et_pb_enable_shortcode_tracking',	''),
(124,	128,	'_et_pb_ab_current_shortcode',	'[et_pb_split_track id=\"128\" /]'),
(125,	128,	'_et_pb_custom_css',	'.et_pb_slide_description {\ntext-shadow:none !important;\n}'),
(126,	128,	'_et_pb_gutter_width',	'3'),
(127,	128,	'_et_pb_first_image',	''),
(128,	128,	'_et_pb_truncate_post',	''),
(129,	128,	'_et_pb_truncate_post_date',	''),
(130,	128,	'_et_builder_version',	'VB|Divi|4.2.2'),
(131,	128,	'_et_pb_show_page_creation',	'off'),
(132,	128,	'et_enqueued_post_fonts',	'a:2:{s:6:\"family\";a:3:{s:16:\"et-gf-montserrat\";s:137:\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\";s:10:\"et-gf-lato\";s:75:\"Lato:100,100italic,300,300italic,regular,italic,700,700italic,900,900italic\";s:19:\"et-gf-abril-fatface\";s:21:\"Abril+Fatface:regular\";}s:6:\"subset\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}}'),
(133,	128,	'_et_pb_old_content',	''),
(144,	130,	'_edit_lock',	'1590521861:1'),
(145,	130,	'_et_pb_use_builder',	'on'),
(146,	130,	'_et_gb_content_width',	''),
(147,	130,	'_edit_last',	'1'),
(148,	130,	'_et_pb_post_hide_nav',	'default'),
(149,	130,	'_et_pb_page_layout',	'et_right_sidebar'),
(150,	130,	'_et_pb_side_nav',	'off'),
(151,	130,	'_wp_page_template',	'default'),
(152,	130,	'_et_pb_built_for_post_type',	'page'),
(153,	130,	'_et_pb_ab_subjects',	''),
(154,	130,	'_et_pb_enable_shortcode_tracking',	''),
(155,	130,	'_et_pb_ab_current_shortcode',	'[et_pb_split_track id=\"130\" /]'),
(156,	130,	'_et_pb_custom_css',	'.et_pb_slide_description {\ntext-shadow:none !important;\n}'),
(157,	130,	'_et_pb_gutter_width',	'3'),
(158,	130,	'_et_pb_first_image',	''),
(159,	130,	'_et_pb_truncate_post',	''),
(160,	130,	'_et_pb_truncate_post_date',	''),
(161,	130,	'_et_builder_version',	'VB|Divi|4.2.2'),
(162,	130,	'_et_pb_show_page_creation',	'off'),
(163,	130,	'et_enqueued_post_fonts',	'a:2:{s:6:\"family\";a:3:{s:16:\"et-gf-montserrat\";s:137:\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\";s:10:\"et-gf-lato\";s:75:\"Lato:100,100italic,300,300italic,regular,italic,700,700italic,900,900italic\";s:19:\"et-gf-abril-fatface\";s:21:\"Abril+Fatface:regular\";}s:6:\"subset\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}}'),
(164,	130,	'_et_pb_old_content',	''),
(175,	132,	'_edit_lock',	'1607554100:2'),
(176,	132,	'_et_pb_use_builder',	'on'),
(177,	132,	'_et_gb_content_width',	''),
(178,	132,	'_edit_last',	'1'),
(179,	132,	'_et_pb_post_hide_nav',	'default'),
(180,	132,	'_et_pb_page_layout',	'et_right_sidebar'),
(181,	132,	'_et_pb_side_nav',	'off'),
(182,	132,	'_wp_page_template',	'default'),
(183,	132,	'_et_pb_built_for_post_type',	'page'),
(184,	132,	'_et_pb_ab_subjects',	''),
(185,	132,	'_et_pb_enable_shortcode_tracking',	''),
(186,	132,	'_et_pb_ab_current_shortcode',	'[et_pb_split_track id=\"132\" /]'),
(187,	132,	'_et_pb_custom_css',	'.et_pb_slide_description {\ntext-shadow:none !important;\n}'),
(188,	132,	'_et_pb_gutter_width',	'3'),
(189,	132,	'_et_pb_first_image',	''),
(190,	132,	'_et_pb_truncate_post',	''),
(191,	132,	'_et_pb_truncate_post_date',	''),
(192,	132,	'_et_builder_version',	'VB|Divi|4.5.1'),
(193,	132,	'_et_pb_show_page_creation',	'off'),
(194,	132,	'et_enqueued_post_fonts',	'a:2:{s:6:\"family\";a:3:{s:16:\"et-gf-montserrat\";s:137:\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\";s:10:\"et-gf-lato\";s:75:\"Lato:100,100italic,300,300italic,regular,italic,700,700italic,900,900italic\";s:15:\"et-gf-open-sans\";s:80:\"Open+Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic\";}s:6:\"subset\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}}'),
(195,	132,	'_et_pb_old_content',	''),
(206,	134,	'_edit_lock',	'1600129434:1'),
(207,	134,	'_et_pb_use_builder',	'on'),
(208,	134,	'_et_gb_content_width',	''),
(209,	134,	'_edit_last',	'1'),
(210,	134,	'_et_pb_post_hide_nav',	'default'),
(211,	134,	'_et_pb_page_layout',	'et_right_sidebar'),
(212,	134,	'_et_pb_side_nav',	'off'),
(213,	134,	'_wp_page_template',	'default'),
(214,	134,	'_et_pb_built_for_post_type',	'page'),
(215,	134,	'_et_pb_ab_subjects',	''),
(216,	134,	'_et_pb_enable_shortcode_tracking',	''),
(217,	134,	'_et_pb_ab_current_shortcode',	'[et_pb_split_track id=\"134\" /]'),
(218,	134,	'_et_pb_custom_css',	'.et_pb_slide_description {\ntext-shadow:none !important;\n}'),
(219,	134,	'_et_pb_gutter_width',	'3'),
(220,	134,	'_et_pb_first_image',	''),
(221,	134,	'_et_pb_truncate_post',	''),
(222,	134,	'_et_pb_truncate_post_date',	''),
(223,	134,	'_et_builder_version',	'VB|Divi|4.2.2'),
(224,	134,	'_et_pb_show_page_creation',	'off'),
(225,	134,	'et_enqueued_post_fonts',	'a:2:{s:6:\"family\";a:3:{s:16:\"et-gf-montserrat\";s:137:\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\";s:10:\"et-gf-lato\";s:75:\"Lato:100,100italic,300,300italic,regular,italic,700,700italic,900,900italic\";s:19:\"et-gf-abril-fatface\";s:21:\"Abril+Fatface:regular\";}s:6:\"subset\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}}'),
(226,	134,	'_et_pb_old_content',	''),
(237,	136,	'_edit_lock',	'1697684658:1'),
(238,	136,	'_et_pb_use_builder',	'on'),
(239,	136,	'_et_gb_content_width',	''),
(240,	136,	'_edit_last',	'1'),
(241,	136,	'_et_pb_post_hide_nav',	'default'),
(242,	136,	'_et_pb_page_layout',	'et_right_sidebar'),
(243,	136,	'_et_pb_side_nav',	'off'),
(244,	136,	'_wp_page_template',	'default'),
(245,	136,	'_et_pb_built_for_post_type',	'page'),
(246,	136,	'_et_pb_ab_subjects',	''),
(247,	136,	'_et_pb_enable_shortcode_tracking',	''),
(248,	136,	'_et_pb_ab_current_shortcode',	'[et_pb_split_track id=\"7\" /]'),
(249,	136,	'_et_pb_custom_css',	'.et_pb_slide_description {\ntext-shadow:none !important;\n}\n#et-main-area {\n    margin-top: 0px!important;\n}'),
(250,	136,	'_et_pb_gutter_width',	'3'),
(251,	136,	'_et_pb_first_image',	''),
(252,	136,	'_et_pb_truncate_post',	''),
(253,	136,	'_et_pb_truncate_post_date',	''),
(254,	136,	'_et_builder_version',	'VB|Divi|4.4.7'),
(255,	136,	'_et_pb_show_page_creation',	'off'),
(256,	136,	'et_enqueued_post_fonts',	'a:2:{s:6:\"family\";a:2:{s:16:\"et-gf-montserrat\";s:137:\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\";s:10:\"et-gf-lato\";s:75:\"Lato:100,100italic,300,300italic,regular,italic,700,700italic,900,900italic\";}s:6:\"subset\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}}'),
(257,	136,	'_et_pb_old_content',	''),
(330,	142,	'_edit_lock',	'1664229948:1'),
(331,	142,	'_et_pb_use_builder',	'on'),
(332,	142,	'_et_gb_content_width',	''),
(333,	142,	'_edit_last',	'2'),
(334,	142,	'_et_pb_post_hide_nav',	'default'),
(335,	142,	'_et_pb_page_layout',	'et_right_sidebar'),
(336,	142,	'_et_pb_side_nav',	'off'),
(337,	142,	'_wp_page_template',	'default'),
(338,	142,	'_et_pb_built_for_post_type',	'page'),
(339,	142,	'_et_pb_ab_subjects',	''),
(340,	142,	'_et_pb_enable_shortcode_tracking',	''),
(341,	142,	'_et_pb_ab_current_shortcode',	'[et_pb_split_track id=\"142\" /]'),
(342,	142,	'_et_pb_custom_css',	'.et_pb_slide_description {\ntext-shadow:none !important;\n}\n.et_pb_tab_0:before {position: absolute;font-family: \'FontAwesome\';top: 18px;left: 15px;content: \"\\f207\";font-size:24px;color:#fff;}\n.et_pb_tab_1:before {position: absolute;font-family: \'FontAwesome\';top: 18px;left: 15px;content: \"\\f0f7\";font-size:24px;color:#fff;}\n.et_pb_tab_2:before {position: absolute;font-family: \'FontAwesome\';top: 18px;left: 15px;content: \"\\f1ad\";font-size:24px;color:#fff;}\n.et_pb_tab_3:before {position: absolute;font-family: \'FontAwesome\';top: 18px;left: 15px;content: \"\\f19d\";font-size:24px;color:#fff;}\n.et_pb_tabs_controls li {\n    display: table;\n    float: left;\n    position: relative;\n    z-index: 11;\n    max-width: 100%;\n    border-right: 1px solid #d9d9d9;\n    font-weight: 400;\n    line-height: 1.7em;\n    cursor: pointer;\n    padding: 15px 20px;\n}'),
(343,	142,	'_et_pb_gutter_width',	'3'),
(344,	142,	'_et_pb_first_image',	''),
(345,	142,	'_et_pb_truncate_post',	''),
(346,	142,	'_et_pb_truncate_post_date',	''),
(347,	142,	'_et_builder_version',	'VB|Divi|4.4.7'),
(348,	142,	'_et_pb_show_page_creation',	'off'),
(349,	142,	'et_enqueued_post_fonts',	'a:2:{s:6:\"family\";a:2:{s:16:\"et-gf-montserrat\";s:137:\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\";s:10:\"et-gf-lato\";s:75:\"Lato:100,100italic,300,300italic,regular,italic,700,700italic,900,900italic\";}s:6:\"subset\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}}'),
(350,	142,	'_et_pb_old_content',	''),
(459,	152,	'_menu_item_type',	'post_type'),
(460,	152,	'_menu_item_menu_item_parent',	'0'),
(461,	152,	'_menu_item_object_id',	'132'),
(462,	152,	'_menu_item_object',	'page'),
(463,	152,	'_menu_item_target',	''),
(464,	152,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(465,	152,	'_menu_item_xfn',	''),
(466,	152,	'_menu_item_url',	''),
(522,	159,	'_menu_item_type',	'post_type'),
(523,	159,	'_menu_item_menu_item_parent',	'0'),
(524,	159,	'_menu_item_object_id',	'134'),
(525,	159,	'_menu_item_object',	'page'),
(526,	159,	'_menu_item_target',	''),
(527,	159,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(528,	159,	'_menu_item_xfn',	''),
(529,	159,	'_menu_item_url',	''),
(531,	160,	'_menu_item_type',	'post_type'),
(532,	160,	'_menu_item_menu_item_parent',	'0'),
(533,	160,	'_menu_item_object_id',	'128'),
(534,	160,	'_menu_item_object',	'page'),
(535,	160,	'_menu_item_target',	''),
(536,	160,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(537,	160,	'_menu_item_xfn',	''),
(538,	160,	'_menu_item_url',	''),
(549,	162,	'_menu_item_type',	'post_type'),
(550,	162,	'_menu_item_menu_item_parent',	'0'),
(551,	162,	'_menu_item_object_id',	'136'),
(552,	162,	'_menu_item_object',	'page'),
(553,	162,	'_menu_item_target',	''),
(554,	162,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(555,	162,	'_menu_item_xfn',	''),
(556,	162,	'_menu_item_url',	''),
(558,	163,	'_menu_item_type',	'post_type'),
(559,	163,	'_menu_item_menu_item_parent',	'0'),
(560,	163,	'_menu_item_object_id',	'130'),
(561,	163,	'_menu_item_object',	'page'),
(562,	163,	'_menu_item_target',	''),
(563,	163,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(564,	163,	'_menu_item_xfn',	''),
(565,	163,	'_menu_item_url',	''),
(567,	166,	'_wp_attached_file',	'2020/03/losangeles1.mp4'),
(568,	166,	'_wp_attachment_metadata',	'a:10:{s:8:\"filesize\";i:5522449;s:9:\"mime_type\";s:9:\"video/mp4\";s:6:\"length\";i:22;s:16:\"length_formatted\";s:4:\"0:22\";s:5:\"width\";i:1280;s:6:\"height\";i:720;s:10:\"fileformat\";s:3:\"mp4\";s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"audio\";a:7:{s:10:\"dataformat\";s:3:\"mp4\";s:5:\"codec\";s:19:\"ISO/IEC 14496-3 AAC\";s:11:\"sample_rate\";d:44100;s:8:\"channels\";i:2;s:15:\"bits_per_sample\";i:16;s:8:\"lossless\";b:0;s:11:\"channelmode\";s:6:\"stereo\";}s:17:\"created_timestamp\";i:1581139626;}'),
(572,	174,	'_wp_attached_file',	'2020/03/la-home.jpg'),
(573,	174,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1200;s:4:\"file\";s:19:\"2020/03/la-home.jpg\";s:5:\"sizes\";a:14:{s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"la-home-300x188.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:188;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"la-home-1024x640.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:640;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"la-home-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"la-home-768x480.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:20:\"la-home-1536x960.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:960;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:19:\"la-home-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:20:\"la-home-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:19:\"la-home-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:19:\"la-home-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:20:\"la-home-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:19:\"la-home-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:20:\"la-home-1280x800.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:19:\"la-home-980x613.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:613;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:19:\"la-home-480x300.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(574,	175,	'_wp_attached_file',	'2020/03/la-home1.jpg'),
(575,	175,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:1782;s:6:\"height\";i:1179;s:4:\"file\";s:20:\"2020/03/la-home1.jpg\";s:5:\"sizes\";a:14:{s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"la-home1-300x198.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:198;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"la-home1-1024x677.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:677;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"la-home1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"la-home1-768x508.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:508;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:22:\"la-home1-1536x1016.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1016;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:20:\"la-home1-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:21:\"la-home1-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:20:\"la-home1-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:20:\"la-home1-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:21:\"la-home1-1080x715.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:715;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:20:\"la-home1-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:21:\"la-home1-1280x847.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:847;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:20:\"la-home1-980x648.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:648;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:20:\"la-home1-480x318.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:318;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(576,	176,	'_wp_attached_file',	'2020/03/la-home2.jpg'),
(577,	176,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:2100;s:6:\"height\";i:1400;s:4:\"file\";s:20:\"2020/03/la-home2.jpg\";s:5:\"sizes\";a:15:{s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"la-home2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"la-home2-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"la-home2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"la-home2-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:22:\"la-home2-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:22:\"la-home2-2048x1365.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:20:\"la-home2-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:21:\"la-home2-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:20:\"la-home2-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:20:\"la-home2-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:21:\"la-home2-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:20:\"la-home2-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:21:\"la-home2-1280x853.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:853;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:20:\"la-home2-980x653.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:653;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:20:\"la-home2-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(578,	177,	'_wp_attached_file',	'2020/03/la-home3.jpg'),
(579,	177,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1278;s:4:\"file\";s:20:\"2020/03/la-home3.jpg\";s:5:\"sizes\";a:14:{s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"la-home3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"la-home3-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"la-home3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"la-home3-768x511.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:511;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:22:\"la-home3-1536x1022.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1022;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:20:\"la-home3-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:21:\"la-home3-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:20:\"la-home3-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:20:\"la-home3-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:21:\"la-home3-1080x719.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:719;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:20:\"la-home3-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:21:\"la-home3-1280x852.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:852;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:20:\"la-home3-980x652.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:652;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:20:\"la-home3-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(580,	178,	'_wp_attached_file',	'2020/03/la-home4.jpg'),
(581,	178,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:1800;s:6:\"height\";i:1198;s:4:\"file\";s:20:\"2020/03/la-home4.jpg\";s:5:\"sizes\";a:14:{s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"la-home4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"la-home4-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"la-home4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"la-home4-768x511.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:511;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:22:\"la-home4-1536x1022.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1022;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:20:\"la-home4-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:21:\"la-home4-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:20:\"la-home4-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:20:\"la-home4-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:21:\"la-home4-1080x719.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:719;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:20:\"la-home4-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:21:\"la-home4-1280x852.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:852;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:20:\"la-home4-980x652.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:652;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:20:\"la-home4-480x319.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:319;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(582,	179,	'_wp_attached_file',	'2020/03/la-home5.jpg'),
(583,	179,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1080;s:4:\"file\";s:20:\"2020/03/la-home5.jpg\";s:5:\"sizes\";a:14:{s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"la-home5-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"la-home5-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"la-home5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"la-home5-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:21:\"la-home5-1536x864.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:864;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:20:\"la-home5-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:21:\"la-home5-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:20:\"la-home5-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:20:\"la-home5-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:21:\"la-home5-1080x608.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:608;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:20:\"la-home5-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:21:\"la-home5-1280x720.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:20:\"la-home5-980x551.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:551;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:20:\"la-home5-480x270.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(584,	180,	'_wp_attached_file',	'2020/03/la-home6.jpg'),
(585,	180,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:2050;s:6:\"height\";i:1367;s:4:\"file\";s:20:\"2020/03/la-home6.jpg\";s:5:\"sizes\";a:15:{s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"la-home6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"la-home6-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"la-home6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"la-home6-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:22:\"la-home6-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:22:\"la-home6-2048x1366.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1366;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:20:\"la-home6-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:21:\"la-home6-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:20:\"la-home6-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:20:\"la-home6-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:21:\"la-home6-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:20:\"la-home6-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:21:\"la-home6-1280x854.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:854;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:20:\"la-home6-980x653.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:653;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:20:\"la-home6-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(586,	181,	'_wp_attached_file',	'2020/03/la-luxury-full-1.jpg'),
(587,	181,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:1900;s:6:\"height\";i:1267;s:4:\"file\";s:28:\"2020/03/la-luxury-full-1.jpg\";s:5:\"sizes\";a:14:{s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"la-luxury-full-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:29:\"la-luxury-full-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"la-luxury-full-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:28:\"la-luxury-full-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:30:\"la-luxury-full-1-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:28:\"la-luxury-full-1-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:29:\"la-luxury-full-1-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:28:\"la-luxury-full-1-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:28:\"la-luxury-full-1-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:29:\"la-luxury-full-1-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:28:\"la-luxury-full-1-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:29:\"la-luxury-full-1-1280x854.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:854;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:28:\"la-luxury-full-1-980x654.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:654;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:28:\"la-luxury-full-1-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(588,	182,	'_wp_attached_file',	'2020/03/la-luxury-full-2.jpg'),
(589,	182,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:1900;s:6:\"height\";i:1267;s:4:\"file\";s:28:\"2020/03/la-luxury-full-2.jpg\";s:5:\"sizes\";a:14:{s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"la-luxury-full-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:29:\"la-luxury-full-2-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"la-luxury-full-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:28:\"la-luxury-full-2-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:30:\"la-luxury-full-2-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:28:\"la-luxury-full-2-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:29:\"la-luxury-full-2-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:28:\"la-luxury-full-2-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:28:\"la-luxury-full-2-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:29:\"la-luxury-full-2-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:28:\"la-luxury-full-2-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:29:\"la-luxury-full-2-1280x854.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:854;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:28:\"la-luxury-full-2-980x654.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:654;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:28:\"la-luxury-full-2-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(590,	183,	'_et_pb_built_for_post_type',	'page'),
(591,	128,	'_thumbnail_id',	''),
(592,	134,	'_thumbnail_id',	''),
(594,	190,	'_wp_attached_file',	'2020/03/chris-gray.jpg'),
(595,	190,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:518;s:6:\"height\";i:777;s:4:\"file\";s:22:\"2020/03/chris-gray.jpg\";s:5:\"sizes\";a:8:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"chris-gray-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"chris-gray-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:22:\"chris-gray-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:22:\"chris-gray-518x675.jpg\";s:5:\"width\";i:518;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:22:\"chris-gray-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:22:\"chris-gray-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:22:\"chris-gray-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:22:\"chris-gray-480x720.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(602,	230,	'_wp_attached_file',	'2020/05/bell-air-neigh.jpg'),
(603,	230,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:800;s:6:\"height\";i:533;s:4:\"file\";s:26:\"2020/05/bell-air-neigh.jpg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"bell-air-neigh-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"bell-air-neigh-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"bell-air-neigh-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:26:\"bell-air-neigh-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:26:\"bell-air-neigh-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:26:\"bell-air-neigh-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:26:\"bell-air-neigh-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:26:\"bell-air-neigh-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"hji/150w150h\";a:4:{s:4:\"file\";s:26:\"bell-air-neigh-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"hji/150h\";a:4:{s:4:\"file\";s:26:\"bell-air-neigh-225x150.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(604,	231,	'_wp_attached_file',	'2020/05/beverly-hills-neigh.jpg'),
(605,	231,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:800;s:6:\"height\";i:533;s:4:\"file\";s:31:\"2020/05/beverly-hills-neigh.jpg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"beverly-hills-neigh-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"beverly-hills-neigh-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:31:\"beverly-hills-neigh-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:31:\"beverly-hills-neigh-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:31:\"beverly-hills-neigh-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:31:\"beverly-hills-neigh-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:31:\"beverly-hills-neigh-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:31:\"beverly-hills-neigh-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"hji/150w150h\";a:4:{s:4:\"file\";s:31:\"beverly-hills-neigh-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"hji/150h\";a:4:{s:4:\"file\";s:31:\"beverly-hills-neigh-225x150.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(606,	232,	'_wp_attached_file',	'2020/05/brentwood-gg.jpg'),
(607,	232,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:900;s:6:\"height\";i:600;s:4:\"file\";s:24:\"2020/05/brentwood-gg.jpg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"brentwood-gg-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"brentwood-gg-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"brentwood-gg-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:24:\"brentwood-gg-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:24:\"brentwood-gg-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:24:\"brentwood-gg-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:24:\"brentwood-gg-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:24:\"brentwood-gg-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"hji/150w150h\";a:4:{s:4:\"file\";s:24:\"brentwood-gg-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"hji/150h\";a:4:{s:4:\"file\";s:24:\"brentwood-gg-225x150.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(608,	233,	'_wp_attached_file',	'2020/05/downtown-la-neigh.jpg'),
(609,	233,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:800;s:6:\"height\";i:533;s:4:\"file\";s:29:\"2020/05/downtown-la-neigh.jpg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"downtown-la-neigh-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"downtown-la-neigh-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:29:\"downtown-la-neigh-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:29:\"downtown-la-neigh-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:29:\"downtown-la-neigh-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:29:\"downtown-la-neigh-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:29:\"downtown-la-neigh-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:29:\"downtown-la-neigh-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"hji/150w150h\";a:4:{s:4:\"file\";s:29:\"downtown-la-neigh-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"hji/150h\";a:4:{s:4:\"file\";s:29:\"downtown-la-neigh-225x150.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(610,	234,	'_wp_attached_file',	'2020/05/hollywood-hills-neigh.jpg'),
(611,	234,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:800;s:6:\"height\";i:533;s:4:\"file\";s:33:\"2020/05/hollywood-hills-neigh.jpg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"hollywood-hills-neigh-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"hollywood-hills-neigh-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:33:\"hollywood-hills-neigh-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:33:\"hollywood-hills-neigh-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:33:\"hollywood-hills-neigh-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:33:\"hollywood-hills-neigh-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:33:\"hollywood-hills-neigh-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:33:\"hollywood-hills-neigh-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"hji/150w150h\";a:4:{s:4:\"file\";s:33:\"hollywood-hills-neigh-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"hji/150h\";a:4:{s:4:\"file\";s:33:\"hollywood-hills-neigh-225x150.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(612,	235,	'_wp_attached_file',	'2020/05/holmby-hills-neigh.jpg'),
(613,	235,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:800;s:6:\"height\";i:533;s:4:\"file\";s:30:\"2020/05/holmby-hills-neigh.jpg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"holmby-hills-neigh-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"holmby-hills-neigh-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"holmby-hills-neigh-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:30:\"holmby-hills-neigh-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:30:\"holmby-hills-neigh-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:30:\"holmby-hills-neigh-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:30:\"holmby-hills-neigh-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:30:\"holmby-hills-neigh-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"hji/150w150h\";a:4:{s:4:\"file\";s:30:\"holmby-hills-neigh-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"hji/150h\";a:4:{s:4:\"file\";s:30:\"holmby-hills-neigh-225x150.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(614,	236,	'_wp_attached_file',	'2020/05/malibu-neigh.jpg'),
(615,	236,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:800;s:6:\"height\";i:533;s:4:\"file\";s:24:\"2020/05/malibu-neigh.jpg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"malibu-neigh-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"malibu-neigh-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"malibu-neigh-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:24:\"malibu-neigh-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:24:\"malibu-neigh-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:24:\"malibu-neigh-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:24:\"malibu-neigh-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:24:\"malibu-neigh-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"hji/150w150h\";a:4:{s:4:\"file\";s:24:\"malibu-neigh-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"hji/150h\";a:4:{s:4:\"file\";s:24:\"malibu-neigh-225x150.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(616,	237,	'_wp_attached_file',	'2020/05/santa-monica-neigh.jpg'),
(617,	237,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:800;s:6:\"height\";i:533;s:4:\"file\";s:30:\"2020/05/santa-monica-neigh.jpg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"santa-monica-neigh-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"santa-monica-neigh-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"santa-monica-neigh-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:30:\"santa-monica-neigh-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:30:\"santa-monica-neigh-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:30:\"santa-monica-neigh-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:30:\"santa-monica-neigh-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:30:\"santa-monica-neigh-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"hji/150w150h\";a:4:{s:4:\"file\";s:30:\"santa-monica-neigh-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"hji/150h\";a:4:{s:4:\"file\";s:30:\"santa-monica-neigh-225x150.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(618,	238,	'_wp_attached_file',	'2020/05/venice-neigh.jpg'),
(619,	238,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:800;s:6:\"height\";i:533;s:4:\"file\";s:24:\"2020/05/venice-neigh.jpg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"venice-neigh-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"venice-neigh-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"venice-neigh-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:24:\"venice-neigh-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:24:\"venice-neigh-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:24:\"venice-neigh-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:24:\"venice-neigh-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:24:\"venice-neigh-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"hji/150w150h\";a:4:{s:4:\"file\";s:24:\"venice-neigh-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"hji/150h\";a:4:{s:4:\"file\";s:24:\"venice-neigh-225x150.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(620,	240,	'_wp_attached_file',	'2020/05/bh-hdr2.jpg'),
(621,	240,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:2000;s:6:\"height\";i:1500;s:4:\"file\";s:19:\"2020/05/bh-hdr2.jpg\";s:5:\"sizes\";a:16:{s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"bh-hdr2-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"bh-hdr2-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"bh-hdr2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"bh-hdr2-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:21:\"bh-hdr2-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:19:\"bh-hdr2-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:20:\"bh-hdr2-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:19:\"bh-hdr2-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:19:\"bh-hdr2-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:20:\"bh-hdr2-1080x810.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:810;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:19:\"bh-hdr2-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:20:\"bh-hdr2-1280x960.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:960;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:19:\"bh-hdr2-980x735.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:735;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:19:\"bh-hdr2-480x360.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"hji/150w150h\";a:4:{s:4:\"file\";s:19:\"bh-hdr2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"hji/150h\";a:4:{s:4:\"file\";s:19:\"bh-hdr2-200x150.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(630,	265,	'_et_pb_built_for_post_type',	'page'),
(634,	268,	'_edit_lock',	'1611459916:2'),
(635,	268,	'_et_pb_use_builder',	'on'),
(636,	268,	'_et_gb_content_width',	''),
(637,	268,	'_edit_last',	'2'),
(638,	268,	'_et_pb_post_hide_nav',	'default'),
(639,	268,	'_et_pb_page_layout',	'et_right_sidebar'),
(640,	268,	'_et_pb_side_nav',	'off'),
(641,	268,	'_wp_page_template',	'default'),
(642,	268,	'_et_pb_built_for_post_type',	'page'),
(643,	268,	'_et_pb_ab_subjects',	''),
(644,	268,	'_et_pb_enable_shortcode_tracking',	''),
(645,	268,	'_et_pb_ab_current_shortcode',	'[et_pb_split_track id=\"268\" /]'),
(646,	268,	'_et_pb_custom_css',	'.et_pb_slide_description {\ntext-shadow:none !important;\n}'),
(647,	268,	'_et_pb_gutter_width',	'3'),
(648,	268,	'_et_pb_first_image',	''),
(649,	268,	'_et_pb_truncate_post',	''),
(650,	268,	'_et_pb_truncate_post_date',	''),
(651,	268,	'_et_builder_version',	'VB|Divi|4.4.7'),
(652,	268,	'_et_pb_show_page_creation',	'off'),
(653,	268,	'et_enqueued_post_fonts',	'a:2:{s:6:\"family\";a:2:{s:16:\"et-gf-montserrat\";s:137:\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\";s:10:\"et-gf-lato\";s:75:\"Lato:100,100italic,300,300italic,regular,italic,700,700italic,900,900italic\";}s:6:\"subset\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}}'),
(654,	268,	'_et_pb_old_content',	''),
(665,	265,	'_et_pb_excluded_global_options',	'[]'),
(666,	276,	'_wp_attached_file',	'2020/05/La-dusk.jpg'),
(667,	276,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:2124;s:6:\"height\";i:1411;s:4:\"file\";s:19:\"2020/05/La-dusk.jpg\";s:5:\"sizes\";a:17:{s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"La-dusk-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"La-dusk-1024x680.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:680;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"La-dusk-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"La-dusk-768x510.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:21:\"La-dusk-1536x1020.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1020;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:21:\"La-dusk-2048x1361.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1361;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:19:\"La-dusk-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:20:\"La-dusk-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:19:\"La-dusk-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:19:\"La-dusk-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:20:\"La-dusk-1080x717.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:717;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:19:\"La-dusk-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:20:\"La-dusk-1280x850.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:850;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:19:\"La-dusk-980x651.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:651;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:19:\"La-dusk-480x319.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:319;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"hji/150w150h\";a:4:{s:4:\"file\";s:19:\"La-dusk-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"hji/150h\";a:4:{s:4:\"file\";s:19:\"La-dusk-226x150.jpg\";s:5:\"width\";i:226;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(672,	279,	'_edit_lock',	'1646439269:2'),
(673,	279,	'_et_pb_use_builder',	'on'),
(674,	279,	'_et_gb_content_width',	''),
(675,	279,	'_edit_last',	'2'),
(676,	279,	'_et_pb_post_hide_nav',	'default'),
(677,	279,	'_et_pb_page_layout',	'et_right_sidebar'),
(678,	279,	'_et_pb_side_nav',	'off'),
(679,	279,	'_wp_page_template',	'default'),
(680,	279,	'_et_pb_built_for_post_type',	'page'),
(681,	279,	'_et_pb_ab_subjects',	''),
(682,	279,	'_et_pb_enable_shortcode_tracking',	''),
(683,	279,	'_et_pb_ab_current_shortcode',	'[et_pb_split_track id=\"279\" /]'),
(684,	279,	'_et_pb_custom_css',	'.et_pb_slide_description {\ntext-shadow:none !important;\n}'),
(685,	279,	'_et_pb_gutter_width',	'3'),
(686,	279,	'_et_pb_first_image',	''),
(687,	279,	'_et_pb_truncate_post',	'<p><div class=\"et_pb_section et_pb_section_34 et_pb_fullwidth_section et_section_regular\" >\n				\n				\n				\n				\n					<section class=\"et_pb_module et_pb_fullwidth_header et_pb_fullwidth_header_9 et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_fullwidth_header_container left\">\n					\n					\n				</div>\n				<div class=\"et_pb_fullwidth_header_overlay\"></div>\n				<div class=\"et_pb_fullwidth_header_scroll\"></div>\n			</section>\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_35 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_97\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_151  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_testimonial et_pb_testimonial_0 clearfix  et_pb_text_align_left et_pb_bg_layout_light et_pb_testimonial_no_image\">\n				\n				\n				\n				<div class=\"et_pb_testimonial_description\">\n					<div class=\"et_pb_testimonial_description_inner\"><div class=\"et_pb_testimonial_content\">Record price in the neighborhood<br />\nI received a letter from Chris Gray as I was getting ready to put my house up for sale. Typically, I ignore these sort of letters, however Chris’ picture looked very honest and plus he had had work experience in China, so I gave him a call to come over. He brought with him a very well-put together proposal with market statistics of my home and a marketing plan. This pleased me and made me think that he was prepared and professional.<br />\nThe result was exactly what we had planned out! In only 3 short weeks, my property set a record price in the neighborhood. This was met with much gratitude from the neighbors in raising property values for the entire building. Chris’ success is not only attributed to his ability to effectively communicate with Chinese clients, but he is also an extremely honest person and skillful at communicating with English-speaking buyers. He also pays close attention to detail and knows how to beautifully present a house. I am extremely happy to recommend Chris to everyone!</div></div> <!-- .et_pb_testimonial_description_inner -->\n					<span class=\"et_pb_testimonial_author\">Sara C. – Beverly Hills, CA</span>\n					<p class=\"et_pb_testimonial_meta\"></p>\n				</div> <!-- .et_pb_testimonial_description -->\n			</div> <!-- .et_pb_testimonial --><div class=\"et_pb_module et_pb_testimonial et_pb_testimonial_1 clearfix  et_pb_text_align_left et_pb_bg_layout_light et_pb_testimonial_no_image\">\n				\n				\n				\n				<div class=\"et_pb_testimonial_description\">\n					<div class=\"et_pb_testimonial_description_inner\"><div class=\"et_pb_testimonial_content\">Essential in helping me buy a home<br />\nChris was essential in helping me buy a home in a complex situation. The seller needed several iterations to understand the realities of market pricing and moving. Chris was professional, persistent and perceptive throughout the process. He understood when it was appropriate to wait or to press forward. His dependability and availability were always present. He is a model for doing it the right way.</div></div> <!-- .et_pb_testimonial_description_inner -->\n					<span class=\"et_pb_testimonial_author\">Harry H. – Santa Monica, CA</span>\n					<p class=\"et_pb_testimonial_meta\"></p>\n				</div> <!-- .et_pb_testimonial_description -->\n			</div> <!-- .et_pb_testimonial --><div class=\"et_pb_module et_pb_testimonial et_pb_testimonial_2 clearfix  et_pb_text_align_left et_pb_bg_layout_light et_pb_testimonial_no_image\">\n				\n				\n				\n				<div class=\"et_pb_testimonial_description\">\n					<div class=\"et_pb_testimonial_description_inner\"><div class=\"et_pb_testimonial_content\">Chris is a Rock Star of realtors<br />\nChris is a Rock Star of realtors! He knows the area well, has a great team working with him, and was incredibly responsive to all of my needs throughout the selling &amp; then buying processes. You won&#8217;t find a better, more competent realtor &amp; I just can&#8217;t recommend him enough. Thanks Chris, I will definitely be recommending you to everyone I know.</div></div> <!-- .et_pb_testimonial_description_inner -->\n					<span class=\"et_pb_testimonial_author\">Scott W. – Hollywood Hills, CA</span>\n					<p class=\"et_pb_testimonial_meta\"></p>\n				</div> <!-- .et_pb_testimonial_description -->\n			</div> <!-- .et_pb_testimonial --><div class=\"et_pb_module et_pb_testimonial et_pb_testimonial_3 clearfix  et_pb_text_align_left et_pb_bg_layout_light et_pb_testimonial_no_image\">\n				\n				\n				\n				<div class=\"et_pb_testimonial_description\">\n					<div class=\"et_pb_testimonial_description_inner\"><div class=\"et_pb_testimonial_content\">My utmost recommendation!<br />\nChris and his company handled the recent sale of my Beverly Hills property. From the moment I met Chris, he impressed me with his honesty, straight talk, professionalism, confidence and overall knowledge of the market. His preparation before bringing my property to market was impeccable and right on target as demonstrated by the fact the first and accepted offer was received before the house was even on the market – and the deal was done above the asking price!! How much more impressive can that be? Thereafter he and his entire team took over the closing process and handled it to perfection even with a few tribulations! I can’t say enough about how pleased I’m with how Chris and his team guided me through the entire process. They are truly an extremely organized, proactive and responsive team. Needless to say, Chris and his team have my utmost recommendation!! Chris and Team Thank you for a job well done! Your excellence, honesty, and professionalism is greatly appreciated. I could not have done it without you. Keep up the good work!!</div></div> <!-- .et_pb_testimonial_description_inner -->\n					<span class=\"et_pb_testimonial_author\">Li H. – Malibu, CA</span>\n					<p class=\"et_pb_testimonial_meta\"></p>\n				</div> <!-- .et_pb_testimonial_description -->\n			</div> <!-- .et_pb_testimonial --><div class=\"et_pb_module et_pb_testimonial et_pb_testimonial_4 clearfix  et_pb_text_align_left et_pb_bg_layout_light et_pb_testimonial_no_image\">\n				\n				\n				\n				<div class=\"et_pb_testimonial_description\">\n					<div class=\"et_pb_testimonial_description_inner\"><div class=\"et_pb_testimonial_content\">My home sold quickly<br />\nIf you are thinking about buying or selling your home, you must contact Chris Gray, who is affiliated with Beverly &amp; Co. He just sold my home in the Roxbury Park neighborhood of Beverly Hills and I was very pleased with the outcome. Chris is straight forward, gives knowledgeable projections of value, and gets results. My home sold quickly, had multiple offers, and I received more than the original asking price.</div></div> <!-- .et_pb_testimonial_description_inner -->\n					<span class=\"et_pb_testimonial_author\">Sylvia F. - Beverly Hills, CA</span>\n					<p class=\"et_pb_testimonial_meta\"></p>\n				</div> <!-- .et_pb_testimonial_description -->\n			</div> <!-- .et_pb_testimonial --><div class=\"et_pb_module et_pb_testimonial et_pb_testimonial_5 clearfix  et_pb_text_align_left et_pb_bg_layout_light et_pb_testimonial_no_image\">\n				\n				\n				\n				<div class=\"et_pb_testimonial_description\">\n					<div class=\"et_pb_testimonial_description_inner\"><div class=\"et_pb_testimonial_content\">Persistence, Consistency and Commitment<br />\nChris was amazing in his persistence, consistency and commitment to selling our property. He was very much into the details and I felt that he understood the legal issues. A great partner, available and reliable. I would recommend Chris to anyone interested in buying or selling a property. Also, he has a very calm and professional demeanor. What you want in someone representing you!</div></div> <!-- .et_pb_testimonial_description_inner -->\n					<span class=\"et_pb_testimonial_author\">Janine C. and Pascal L. Beverly Hills, CA</span>\n					<p class=\"et_pb_testimonial_meta\"></p>\n				</div> <!-- .et_pb_testimonial_description -->\n			</div> <!-- .et_pb_testimonial --><div class=\"et_pb_module et_pb_testimonial et_pb_testimonial_6 clearfix  et_pb_text_align_left et_pb_bg_layout_light et_pb_testimonial_no_image\">\n				\n				\n				\n				<div class=\"et_pb_testimonial_description\">\n					<div class=\"et_pb_testimonial_description_inner\"><div class=\"et_pb_testimonial_content\">Aptitude to Negotiate<br />\nChris is a great agent. He helped me navigate the greater Southern California market and get an amazing place in Santa Barbara. He was very responsive and worked diligently to get my offer accepted and guide me through each stage of the process. I was impressed with his aptitude to negotiate and push the deal to close.</div></div> <!-- .et_pb_testimonial_description_inner -->\n					<span class=\"et_pb_testimonial_author\">Jack C. - Santa Barbara, CA</span>\n					<p class=\"et_pb_testimonial_meta\"></p>\n				</div> <!-- .et_pb_testimonial_description -->\n			</div> <!-- .et_pb_testimonial --><div class=\"et_pb_module et_pb_testimonial et_pb_testimonial_7 clearfix  et_pb_text_align_left et_pb_bg_layout_light et_pb_testimonial_no_image\">\n				\n				\n				\n				<div class=\"et_pb_testimonial_description\">\n					<div class=\"et_pb_testimonial_description_inner\"><div class=\"et_pb_testimonial_content\">Made the Deal Work for Everyone<br />\nChris’s approach made the deal work for everyone, two thumbs up!</div></div> <!-- .et_pb_testimonial_description_inner -->\n					<span class=\"et_pb_testimonial_author\">Karl M. - Hollywood Hills, CA</span>\n					<p class=\"et_pb_testimonial_meta\"></p>\n				</div> <!-- .et_pb_testimonial_description -->\n			</div> <!-- .et_pb_testimonial --><div class=\"et_pb_module et_pb_testimonial et_pb_testimonial_8 clearfix  et_pb_text_align_left et_pb_bg_layout_light et_pb_testimonial_no_image\">\n				\n				\n				\n				<div class=\"et_pb_testimonial_description\">\n					<div class=\"et_pb_testimonial_description_inner\"><div class=\"et_pb_testimonial_content\">Honest, Professional, a Lot of Fun to Work With and MORE!<br />\nA friend of mine recommended Chris to me back in March, from the first meeting I knew Chris was going to be honest, professional, and lot of fun to work with! As we moved through the process he was that and more. I was not a &#8220;traditional&#8221; client, I put the cart before the horse and was not fully ready to buy when we started looking. But Chris was a real trouper, especially during the time of COVID, where extra steps are needed to look at properties, and set up the showings. I think all in we looked at about 20 condos! Put offers in on three and finally got over the finish line with the third.<br />\nAs a first time home buyer, I needed a great deal of hand holding. Chris was there every step of the way, and he really helped me understand what I wanted in a condo and what sacrifices I would need to make to get across the finish line in my price range. In a New York Minute, I would recommend Chris to any of my inner circle, close, family and friends.<br />\nWhile Chris has several multi million dollar clients, he never made me feel less than cause my budget was in the low 400&#8217;s, he was just as excited as I was with every property, and negotiated just as fiercely.</div></div> <!-- .et_pb_testimonial_description_inner -->\n					<span class=\"et_pb_testimonial_author\">Jacob M. - Woodland Hills, CA</span>\n					<p class=\"et_pb_testimonial_meta\"></p>\n				</div> <!-- .et_pb_testimonial_description -->\n			</div> <!-- .et_pb_testimonial --><div class=\"et_pb_module et_pb_testimonial et_pb_testimonial_9 clearfix  et_pb_text_align_left et_pb_bg_layout_light et_pb_testimonial_no_image\">\n				\n				\n				\n				<div class=\"et_pb_testimonial_description\">\n					<div class=\"et_pb_testimonial_description_inner\"><div class=\"et_pb_testimonial_content\">I Know I Will Use Him Again<br />\nChris helped my wife and I find our perfect house in Los Angeles. He is very knowledgeable and works really hard for you. I would highly recommend Chris for all your Los Angeles real estate needs. I know I will be using him again.</div></div> <!-- .et_pb_testimonial_description_inner -->\n					<span class=\"et_pb_testimonial_author\">Scott R. - West Hollywood, CA</span>\n					<p class=\"et_pb_testimonial_meta\"></p>\n				</div> <!-- .et_pb_testimonial_description -->\n			</div> <!-- .et_pb_testimonial -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --></p>\n'),
(688,	279,	'_et_pb_truncate_post_date',	'2022-10-06 06:21:56'),
(689,	279,	'_et_builder_version',	'VB|Divi|4.2.2'),
(690,	279,	'_et_pb_show_page_creation',	'off'),
(691,	279,	'et_enqueued_post_fonts',	'a:2:{s:6:\"family\";a:2:{s:16:\"et-gf-montserrat\";s:137:\"Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\";s:10:\"et-gf-lato\";s:75:\"Lato:100,100italic,300,300italic,regular,italic,700,700italic,900,900italic\";}s:6:\"subset\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}}'),
(692,	279,	'_et_pb_old_content',	''),
(703,	286,	'_wp_attached_file',	'2020/05/la-home7.jpg'),
(704,	286,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1058;s:4:\"file\";s:20:\"2020/05/la-home7.jpg\";s:5:\"sizes\";a:16:{s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"la-home7-300x165.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"la-home7-1024x564.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:564;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"la-home7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"la-home7-768x423.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:423;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:21:\"la-home7-1536x846.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:846;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:20:\"la-home7-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:21:\"la-home7-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";